/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.stream.StreamSupport;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.JdbcLogging;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.cursor.internal.StandardRefCursorSupport;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.env.spi.SQLStateType;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;

public class ExtractedDatabaseMetaDataImpl
implements ExtractedDatabaseMetaData {
    private final JdbcEnvironment jdbcEnvironment;
    private final JdbcConnectionAccess connectionAccess;
    private final boolean supportsSchemas;
    private final boolean supportsCatalogs;
    private final String connectionCatalogName;
    private final String connectionSchemaName;
    private final String databaseProductName;
    private final String databaseProductVersion;
    private final boolean supportsRefCursors;
    private final boolean supportsNamedParameters;
    private final boolean supportsScrollableResults;
    private final boolean supportsGetGeneratedKeys;
    private final boolean supportsBatchUpdates;
    private final boolean supportsDataDefinitionInTransaction;
    private final boolean doesDataDefinitionCauseTransactionCommit;
    private final SQLStateType sqlStateType;
    private final int transactionIsolation;
    private final int defaultTransactionIsolation;
    private final String url;
    private final String driver;
    private final boolean jdbcMetadataAccessible;
    private final int defaultFetchSize;
    private List<SequenceInformation> sequenceInformationList;

    ExtractedDatabaseMetaDataImpl(JdbcEnvironment environment) {
        this.jdbcEnvironment = environment;
        this.connectionAccess = null;
        this.jdbcMetadataAccessible = false;
        this.connectionSchemaName = null;
        this.connectionCatalogName = null;
        this.supportsSchemas = true;
        this.supportsCatalogs = true;
        this.databaseProductName = null;
        this.databaseProductVersion = null;
        this.supportsRefCursors = false;
        this.supportsNamedParameters = false;
        this.supportsScrollableResults = false;
        this.supportsGetGeneratedKeys = false;
        this.supportsBatchUpdates = true;
        this.supportsDataDefinitionInTransaction = false;
        this.doesDataDefinitionCauseTransactionCommit = false;
        this.sqlStateType = null;
        this.url = null;
        this.driver = null;
        this.defaultTransactionIsolation = 0;
        this.transactionIsolation = 0;
        this.defaultFetchSize = -1;
    }

    ExtractedDatabaseMetaDataImpl(JdbcEnvironment environment, JdbcConnectionAccess connections, DatabaseMetaData metaData) throws SQLException {
        this.jdbcEnvironment = environment;
        this.connectionAccess = connections;
        this.jdbcMetadataAccessible = true;
        Dialect dialect = environment.getDialect();
        Connection connection = metaData.getConnection();
        this.supportsSchemas = metaData.supportsSchemasInDataManipulation();
        this.supportsCatalogs = metaData.supportsCatalogsInDataManipulation();
        this.connectionSchemaName = dialect.getSchemaNameResolver().resolveSchemaName(connection, dialect);
        this.connectionCatalogName = connection.getCatalog();
        this.databaseProductName = metaData.getDatabaseProductName();
        this.databaseProductVersion = metaData.getDatabaseProductVersion();
        this.supportsRefCursors = StandardRefCursorSupport.supportsRefCursors(metaData);
        this.supportsNamedParameters = dialect.supportsNamedParameters(metaData);
        this.supportsScrollableResults = metaData.supportsResultSetType(1004);
        this.supportsGetGeneratedKeys = metaData.supportsGetGeneratedKeys();
        this.supportsBatchUpdates = metaData.supportsBatchUpdates();
        this.supportsDataDefinitionInTransaction = !metaData.dataDefinitionIgnoredInTransactions();
        this.doesDataDefinitionCauseTransactionCommit = metaData.dataDefinitionCausesTransactionCommit();
        this.sqlStateType = SQLStateType.interpretReportedSQLStateType(metaData.getSQLStateType());
        this.url = metaData.getURL();
        this.driver = metaData.getDriverName();
        this.defaultTransactionIsolation = metaData.getDefaultTransactionIsolation();
        this.transactionIsolation = connection.getTransactionIsolation();
        this.defaultFetchSize = ExtractedDatabaseMetaDataImpl.defaultFetchSize(connection);
    }

    @Override
    public boolean supportsRefCursors() {
        return this.supportsRefCursors;
    }

    @Override
    public JdbcEnvironment getJdbcEnvironment() {
        return this.jdbcEnvironment;
    }

    @Override
    public boolean supportsSchemas() {
        return this.supportsSchemas;
    }

    @Override
    public boolean supportsCatalogs() {
        return this.supportsCatalogs;
    }

    @Override
    public boolean supportsNamedParameters() {
        return this.supportsNamedParameters;
    }

    @Override
    public boolean supportsScrollableResults() {
        return this.supportsScrollableResults;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    @Override
    public boolean supportsDataDefinitionInTransaction() {
        return this.supportsDataDefinitionInTransaction;
    }

    @Override
    public boolean doesDataDefinitionCauseTransactionCommit() {
        return this.doesDataDefinitionCauseTransactionCommit;
    }

    @Override
    public SQLStateType getSqlStateType() {
        return this.sqlStateType;
    }

    @Override
    public String getConnectionCatalogName() {
        return this.connectionCatalogName;
    }

    @Override
    public String getConnectionSchemaName() {
        return this.connectionSchemaName;
    }

    @Override
    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    @Override
    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    @Override
    public synchronized List<SequenceInformation> getSequenceInformationList() {
        if (this.jdbcMetadataAccessible) {
            if (this.sequenceInformationList == null) {
                this.sequenceInformationList = this.sequenceInformationList();
            }
            return this.sequenceInformationList;
        }
        return Collections.emptyList();
    }

    public boolean isJdbcMetadataAccessible() {
        return this.jdbcMetadataAccessible;
    }

    private static int defaultFetchSize(Connection connection) {
        int n;
        block8: {
            Statement statement = connection.createStatement();
            try {
                n = statement.getFetchSize();
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ignore) {
                    return -1;
                }
            }
            statement.close();
        }
        return n;
    }

    private List<SequenceInformation> sequenceInformationList() {
        Connection connection = null;
        try {
            connection = this.connectionAccess.obtainConnection();
            List<SequenceInformation> list = StreamSupport.stream(ExtractedDatabaseMetaDataImpl.sequenceInformation(connection, this.jdbcEnvironment).spliterator(), false).toList();
            return list;
        }
        catch (SQLException e) {
            throw new HibernateException("Could not fetch the SequenceInformation from the database", e);
        }
        finally {
            if (connection != null) {
                try {
                    this.connectionAccess.releaseConnection(connection);
                }
                catch (SQLException exception) {
                    JdbcLogging.JDBC_MESSAGE_LOGGER.unableToReleaseConnection(exception);
                }
            }
        }
    }

    private static Iterable<SequenceInformation> sequenceInformation(final Connection connection, final JdbcEnvironment jdbcEnvironment) throws SQLException {
        return jdbcEnvironment.getDialect().getSequenceInformationExtractor().extractMetadata(new ExtractionContext.EmptyExtractionContext(){

            @Override
            public Connection getJdbcConnection() {
                return connection;
            }

            @Override
            public JdbcEnvironment getJdbcEnvironment() {
                return jdbcEnvironment;
            }
        });
    }
}

