/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.spi.runtime.MethodDescription;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.function.Consumer;

public class EagerSecurityInterceptorStorage {
    private final Map<MethodDescription, Consumer<RoutingContext>> methodToInterceptor;
    private final Map<String, Consumer<RoutingContext>> classNameToInterceptor;

    EagerSecurityInterceptorStorage(Map<MethodDescription, Consumer<RoutingContext>> methodToInterceptor, Map<String, Consumer<RoutingContext>> classNameToInterceptor) {
        this.methodToInterceptor = methodToInterceptor.isEmpty() ? Map.of() : Map.copyOf(methodToInterceptor);
        this.classNameToInterceptor = classNameToInterceptor.isEmpty() ? Map.of() : Map.copyOf(classNameToInterceptor);
    }

    public Consumer<RoutingContext> getInterceptor(MethodDescription endpoint) {
        return this.methodToInterceptor.get(endpoint);
    }

    public Consumer<RoutingContext> getClassInterceptor(String className) {
        return this.classNameToInterceptor.get(className);
    }
}

