/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import jakarta.persistence.Timeout;
import org.hibernate.Timeouts;
import org.hibernate.community.dialect.TiDBSqlAstTranslator;
import org.hibernate.community.dialect.lock.internal.TiDBLockingSupport;
import org.hibernate.community.dialect.sequence.SequenceInformationExtractorTiDBDatabaseImpl;
import org.hibernate.community.dialect.sequence.TiDBSequenceSupport;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.MySQLServerConfiguration;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.MySQLAggregateSupport;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;

public class TiDBDialect
extends MySQLDialect {
    private static final DatabaseVersion VERSION57 = DatabaseVersion.make((Integer)5, (Integer)7);
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make((Integer)5, (Integer)4);

    public TiDBDialect() {
        this(MINIMUM_VERSION);
    }

    public TiDBDialect(DatabaseVersion version) {
        super(version);
    }

    public TiDBDialect(DialectResolutionInfo info) {
        super(TiDBDialect.createVersion((DialectResolutionInfo)info, (DatabaseVersion)MINIMUM_VERSION), MySQLServerConfiguration.fromDialectResolutionInfo((DialectResolutionInfo)info));
        this.registerKeywords(info);
    }

    public DatabaseVersion getMySQLVersion() {
        return VERSION57;
    }

    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("CUME_DIST");
        this.registerKeyword("DENSE_RANK");
        this.registerKeyword("EXCEPT");
        this.registerKeyword("FIRST_VALUE");
        this.registerKeyword("GROUPS");
        this.registerKeyword("LAG");
        this.registerKeyword("LAST_VALUE");
        this.registerKeyword("LEAD");
        this.registerKeyword("NTH_VALUE");
        this.registerKeyword("NTILE");
        this.registerKeyword("PERCENT_RANK");
        this.registerKeyword("RANK");
        this.registerKeyword("ROW_NUMBER");
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public String getQuerySequencesString() {
        return "SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = database()";
    }

    public SequenceSupport getSequenceSupport() {
        return TiDBSequenceSupport.INSTANCE;
    }

    public AggregateSupport getAggregateSupport() {
        return MySQLAggregateSupport.forTiDB((Dialect)this);
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorTiDBDatabaseImpl.INSTANCE;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new TiDBSqlAstTranslator(sessionFactory, statement, TiDBDialect.this);
            }
        };
    }

    public boolean supportsRecursiveCTE() {
        return true;
    }

    public LockingSupport getLockingSupport() {
        return TiDBLockingSupport.TIDB_LOCKING_SUPPORT;
    }

    protected boolean supportsForShare() {
        return false;
    }

    protected boolean supportsAliasLocks() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return this.getVersion().isSameOrAfter(5, 7);
    }

    public String getReadLockString(Timeout timeout) {
        if (timeout.milliseconds() == 0) {
            return this.getForUpdateNowaitString();
        }
        return super.getReadLockString(timeout);
    }

    public String getReadLockString(String aliases, Timeout timeout) {
        if (timeout.milliseconds() == 0) {
            return this.getForUpdateNowaitString(aliases);
        }
        return super.getReadLockString(aliases, timeout);
    }

    public String getWriteLockString(Timeout timeout) {
        if (timeout.milliseconds() == 0) {
            return this.getForUpdateNowaitString();
        }
        if (Timeouts.isRealTimeout((Timeout)timeout)) {
            return this.getForUpdateString() + " wait " + Timeouts.getTimeoutInSeconds((Timeout)timeout);
        }
        return this.getForUpdateString();
    }

    public String getReadLockString(int timeout) {
        if (timeout == 0) {
            return this.getForUpdateNowaitString();
        }
        return super.getReadLockString(timeout);
    }

    public String getReadLockString(String aliases, int timeout) {
        if (timeout == 0) {
            return this.getForUpdateNowaitString(aliases);
        }
        return super.getReadLockString(aliases, timeout);
    }

    public String getWriteLockString(int timeout) {
        if (timeout == 0) {
            return this.getForUpdateNowaitString();
        }
        if (Timeouts.isRealTimeout((int)timeout)) {
            return this.getForUpdateString() + " wait " + Timeouts.getTimeoutInSeconds((int)timeout);
        }
        return this.getForUpdateString();
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString() + " nowait";
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString(aliases) + " nowait";
    }

    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_REFERENCE;
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return unit == TemporalUnit.SECOND && intervalType == null ? "timestampadd(microsecond,?2*1e6,?3)" : super.timestampaddPattern(unit, temporalType, intervalType);
    }

    public String getDual() {
        return "dual";
    }
}

