/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.jdkspecific;

import java.util.Arrays;
import java.util.List;

public class ProcessInfo {
    private final String name;
    private final long pid;
    private final long ppid;
    private final List<String> arguments;

    private ProcessInfo(ProcessHandle handle) {
        this.name = handle.info().command().orElse("-");
        this.pid = handle.pid();
        this.ppid = handle.parent().map(ProcessHandle::pid).orElse(-1L);
        this.arguments = Arrays.asList(handle.info().arguments().orElse(new String[0]));
    }

    public static ProcessInfo getInstance() {
        return new ProcessInfo(ProcessHandle.current());
    }

    public static ProcessInfo of(Process process) {
        return new ProcessInfo(process.toHandle());
    }

    public String getName() {
        return this.name;
    }

    public long getPid() {
        return this.pid;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public ProcessInfo getParent() {
        if (this.ppid > 0L) {
            return new ProcessInfo(ProcessHandle.of(this.ppid).get());
        }
        return null;
    }

    public String toString() {
        return "Process[jdk11]{name='" + this.name + "', pid=" + this.pid + ", ppid=" + this.ppid + ", arguments=" + String.valueOf(this.arguments) + "}";
    }
}

