/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.requiredactions.util.UpdateProfileContext;
import org.keycloak.authentication.requiredactions.util.UserUpdateProfileContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.Profile;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.forms.login.LoginFormsPages;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.forms.login.MessageType;
import org.keycloak.forms.login.freemarker.AuthenticatorConfiguredMethod;
import org.keycloak.forms.login.freemarker.DetachedInfoStateChecker;
import org.keycloak.forms.login.freemarker.DetachedInfoStateCookie;
import org.keycloak.forms.login.freemarker.Templates;
import org.keycloak.forms.login.freemarker.model.AuthenticationContextBean;
import org.keycloak.forms.login.freemarker.model.AuthenticationSessionBean;
import org.keycloak.forms.login.freemarker.model.ClientBean;
import org.keycloak.forms.login.freemarker.model.CodeBean;
import org.keycloak.forms.login.freemarker.model.EmailBean;
import org.keycloak.forms.login.freemarker.model.FrontChannelLogoutBean;
import org.keycloak.forms.login.freemarker.model.IdentityProviderBean;
import org.keycloak.forms.login.freemarker.model.IdpReviewProfileBean;
import org.keycloak.forms.login.freemarker.model.LoginBean;
import org.keycloak.forms.login.freemarker.model.LogoutConfirmBean;
import org.keycloak.forms.login.freemarker.model.OAuthGrantBean;
import org.keycloak.forms.login.freemarker.model.OrganizationBean;
import org.keycloak.forms.login.freemarker.model.PasswordPoliciesBean;
import org.keycloak.forms.login.freemarker.model.ProfileBean;
import org.keycloak.forms.login.freemarker.model.RealmBean;
import org.keycloak.forms.login.freemarker.model.RecoveryAuthnCodeInputLoginBean;
import org.keycloak.forms.login.freemarker.model.RecoveryAuthnCodesBean;
import org.keycloak.forms.login.freemarker.model.RegisterBean;
import org.keycloak.forms.login.freemarker.model.RequiredActionUrlFormatterMethod;
import org.keycloak.forms.login.freemarker.model.SAMLPostFormBean;
import org.keycloak.forms.login.freemarker.model.TotpBean;
import org.keycloak.forms.login.freemarker.model.TotpLoginBean;
import org.keycloak.forms.login.freemarker.model.UrlBean;
import org.keycloak.forms.login.freemarker.model.VerifyProfileBean;
import org.keycloak.forms.login.freemarker.model.X509ConfirmBean;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.organization.forms.login.freemarker.model.OrganizationAwareIdentityProviderBean;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.rar.AuthorizationDetails;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.Theme;
import org.keycloak.theme.beans.AdvancedMessageFormatterMethod;
import org.keycloak.theme.beans.LocaleBean;
import org.keycloak.theme.beans.MessageBean;
import org.keycloak.theme.beans.MessageFormatterMethod;
import org.keycloak.theme.beans.MessagesPerFieldBean;
import org.keycloak.theme.freemarker.FreeMarkerProvider;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.utils.MediaType;
import org.keycloak.utils.MediaTypeMatcher;

public class FreeMarkerLoginFormsProvider
implements LoginFormsProvider {
    private static final Logger logger = Logger.getLogger(FreeMarkerLoginFormsProvider.class);
    protected String accessCode;
    protected Response.Status status;
    protected List<AuthorizationDetails> clientScopesRequested;
    protected Map<String, String> httpResponseHeaders = new HashMap<String, String>();
    protected URI actionUri;
    protected String execution;
    protected AuthenticationFlowContext context;
    protected List<FormMessage> messages = null;
    protected MessageType messageType = MessageType.ERROR;
    protected MultivaluedMap<String, String> formData;
    protected boolean detachedAuthSession = false;
    protected KeycloakSession session;
    protected AuthenticationSessionModel authenticationSession;
    protected RealmModel realm;
    protected ClientModel client;
    protected UriInfo uriInfo;
    protected FreeMarkerProvider freeMarker;
    protected UserModel user;
    protected String lang;
    protected final Map<String, Object> attributes = new HashMap<String, Object>();
    private Function<Map<String, Object>, Map<String, Object>> attributeMapper;

    public FreeMarkerLoginFormsProvider(KeycloakSession session) {
        this.session = session;
        this.freeMarker = (FreeMarkerProvider)session.getProvider(FreeMarkerProvider.class);
        this.attributes.put("scripts", new LinkedList());
        this.realm = session.getContext().getRealm();
        this.client = session.getContext().getClient();
        this.uriInfo = session.getContext().getUri();
        this.lang = Locale.ENGLISH.toLanguageTag();
    }

    public void addScript(String scriptUrl) {
        List scripts = (List)this.attributes.get("scripts");
        scripts.add(scriptUrl);
    }

    public Response createResponse(UserModel.RequiredAction action) {
        LoginFormsPages page;
        String actionMessage;
        switch (action) {
            case CONFIGURE_TOTP: {
                actionMessage = "configureTotpMessage";
                page = LoginFormsPages.LOGIN_CONFIG_TOTP;
                break;
            }
            case CONFIGURE_RECOVERY_AUTHN_CODES: {
                actionMessage = "configureBackupCodesMessage";
                page = LoginFormsPages.LOGIN_RECOVERY_AUTHN_CODES_CONFIG;
                break;
            }
            case UPDATE_PROFILE: {
                this.attributes.put("updateProfileCtx", new UserUpdateProfileContext(this.realm, this.user));
                actionMessage = "updateProfileMessage";
                page = LoginFormsPages.LOGIN_UPDATE_PROFILE;
                break;
            }
            case UPDATE_EMAIL: {
                UserUpdateProfileContext updateEmailContext = new UserUpdateProfileContext(this.realm, this.user);
                this.attributes.put("user", new ProfileBean(updateEmailContext, this.formData));
                actionMessage = "updateEmailMessage";
                page = LoginFormsPages.UPDATE_EMAIL;
                break;
            }
            case UPDATE_PASSWORD: {
                boolean isRequestedByAdmin = this.user.getRequiredActionsStream().filter(Objects::nonNull).anyMatch(UserModel.RequiredAction.UPDATE_PASSWORD.toString()::contains);
                actionMessage = isRequestedByAdmin ? "updatePasswordMessage" : "resetPasswordMessage";
                page = LoginFormsPages.LOGIN_UPDATE_PASSWORD;
                break;
            }
            case VERIFY_EMAIL: {
                UserUpdateProfileContext userBasedContext1 = new UserUpdateProfileContext(this.realm, this.user);
                this.attributes.put("user", new ProfileBean(userBasedContext1, this.formData));
                if (this.authenticationSession.getAuthNote("VERIFY_EMAIL_KEY") != null) {
                    this.attributes.put("verifyEmail", this.authenticationSession.getAuthNote("VERIFY_EMAIL_KEY"));
                }
                actionMessage = "verifyEmailMessage";
                page = LoginFormsPages.LOGIN_VERIFY_EMAIL;
                break;
            }
            case VERIFY_PROFILE: {
                UserUpdateProfileContext verifyProfile = new UserUpdateProfileContext(this.realm, this.user);
                this.attributes.put("updateProfileCtx", verifyProfile);
                actionMessage = "updateProfileMessage";
                page = LoginFormsPages.LOGIN_UPDATE_PROFILE;
                break;
            }
            default: {
                return Response.serverError().build();
            }
        }
        if (this.messages == null) {
            this.setMessage(MessageType.WARNING, actionMessage, new Object[0]);
        }
        return this.createResponse(page);
    }

    protected Response createResponse(LoginFormsPages page) {
        Theme theme;
        try {
            theme = this.getTheme();
        }
        catch (IOException e) {
            logger.error((Object)"Failed to create theme", (Throwable)e);
            return Response.serverError().build();
        }
        Locale locale = this.session.getContext().resolveLocale(this.user);
        Properties messagesBundle = this.handleThemeResources(theme, locale);
        this.handleMessages(locale, messagesBundle);
        UriBuilder uriBuilder = this.prepareBaseUriBuilder(page == LoginFormsPages.OAUTH_GRANT);
        this.createCommonAttributes(theme, locale, messagesBundle, uriBuilder, page);
        this.attributes.put("login", new LoginBean(this.formData));
        if (this.status != null) {
            this.attributes.put("statusCode", this.status.getStatusCode());
        }
        if (!this.isDetachedAuthenticationSession() && (CommonClientSessionModel.Action.AUTHENTICATE.name().equals(this.authenticationSession.getAction()) || CommonClientSessionModel.Action.REQUIRED_ACTIONS.name().equals(this.authenticationSession.getAction()) || CommonClientSessionModel.Action.OAUTH_GRANT.name().equals(this.authenticationSession.getAction()))) {
            this.setAttribute("authenticationSession", new AuthenticationSessionBean(this.authenticationSession.getParentSession().getId(), this.authenticationSession.getTabId()));
        }
        switch (page) {
            case LOGIN_CONFIG_TOTP: {
                TotpBean totpBean = new TotpBean(this.session, this.realm, this.user, this.getTotpUriBuilder(), this.authenticationSession.getAuthNote("TOTP_SECRET_KEY"));
                this.authenticationSession.setAuthNote("TOTP_SECRET_KEY", totpBean.getTotpSecret());
                this.attributes.put("totp", totpBean);
                break;
            }
            case LOGIN_RECOVERY_AUTHN_CODES_CONFIG: {
                RecoveryAuthnCodesBean recoveryAuthnCodesBean = new RecoveryAuthnCodesBean();
                this.attributes.put("recoveryAuthnCodesConfigBean", recoveryAuthnCodesBean);
                this.authenticationSession.setAuthNote("RecoveryAuthnCodes.generatedRecoveryAuthnCodes", recoveryAuthnCodesBean.getGeneratedRecoveryAuthnCodesAsString());
                this.authenticationSession.setAuthNote("RecoveryAuthnCodes.generatedAt", Long.toString(recoveryAuthnCodesBean.getGeneratedAt()));
                break;
            }
            case LOGIN_RECOVERY_AUTHN_CODES_INPUT: {
                this.attributes.put("recoveryAuthnCodesInputBean", new RecoveryAuthnCodeInputLoginBean(this.session, this.realm, this.user));
                break;
            }
            case LOGIN_UPDATE_PROFILE: {
                this.attributes.put("profile", new VerifyProfileBean(this.user, this.formData, this.session));
                UpdateProfileContext userCtx = (UpdateProfileContext)this.attributes.get("updateProfileCtx");
                this.attributes.put("user", new ProfileBean(userCtx, this.formData));
                break;
            }
            case UPDATE_EMAIL: {
                EmailBean emailBean = new EmailBean(this.user, this.formData, this.session);
                this.attributes.put("profile", emailBean);
                this.attributes.put("email", emailBean);
                break;
            }
            case LOGIN_IDP_LINK_CONFIRM: 
            case LOGIN_IDP_LINK_CONFIRM_OVERRIDE: 
            case LOGIN_IDP_LINK_EMAIL: {
                BrokeredIdentityContext brokerContext = (BrokeredIdentityContext)this.attributes.get("identityProviderBrokerCtx");
                String idpAlias = brokerContext.getIdpConfig().getAlias();
                String displayName = idpAlias = ObjectUtil.capitalize((String)idpAlias);
                if (!ObjectUtil.isBlank((CharSequence)brokerContext.getIdpConfig().getDisplayName())) {
                    displayName = brokerContext.getIdpConfig().getDisplayName();
                }
                this.attributes.put("brokerContext", brokerContext);
                this.attributes.put("idpAlias", idpAlias);
                this.attributes.put("idpDisplayName", displayName);
                break;
            }
            case LOGIN_TOTP: {
                this.attributes.put("otpLogin", new TotpLoginBean(this.session, this.realm, this.user, (String)this.attributes.get("selectedOtpCredentialId")));
                break;
            }
            case LOGIN_RESET_OTP: {
                this.attributes.put("configuredOtpCredentials", new TotpLoginBean(this.session, this.realm, this.user, (String)this.attributes.get("selectedOtpCredentialId")));
                break;
            }
            case REGISTER: {
                RegisterBean rb = new RegisterBean(this.formData, this.session);
                this.attributes.put("register", rb);
                this.attributes.put("profile", rb);
                break;
            }
            case OAUTH_GRANT: {
                this.attributes.put("oauth", new OAuthGrantBean(this.accessCode, this.client, this.clientScopesRequested));
                break;
            }
            case CODE: {
                this.attributes.remove("message");
                this.attributes.put("code", new CodeBean(this.accessCode, this.messageType == MessageType.ERROR ? this.getFirstMessageUnformatted() : null));
                break;
            }
            case X509_CONFIRM: {
                this.attributes.put("x509", new X509ConfirmBean(this.formData));
                break;
            }
            case SAML_POST_FORM: {
                this.attributes.put("samlPost", new SAMLPostFormBean(this.formData));
                break;
            }
            case IDP_REVIEW_USER_PROFILE: {
                UpdateProfileContext idpCtx = (UpdateProfileContext)this.attributes.get("updateProfileCtx");
                this.attributes.put("profile", new IdpReviewProfileBean(idpCtx, this.formData, this.session));
                this.attributes.put("user", new ProfileBean(idpCtx, this.formData));
                break;
            }
            case FRONTCHANNEL_LOGOUT: {
                this.attributes.put("logout", new FrontChannelLogoutBean(this.session));
                break;
            }
            case LOGOUT_CONFIRM: {
                this.attributes.put("logoutConfirm", new LogoutConfirmBean(this.accessCode, this.authenticationSession));
            }
        }
        return this.processTemplate(theme, Templates.getTemplate(page), locale);
    }

    private UriBuilder getTotpUriBuilder() {
        return this.uriInfo.getBaseUriBuilder().path(this.uriInfo.getPath()).replaceQuery(this.uriInfo.getRequestUri().getQuery());
    }

    public Response createForm(String form) {
        Theme theme;
        try {
            theme = this.getTheme();
        }
        catch (IOException e) {
            logger.error((Object)"Failed to create theme", (Throwable)e);
            return Response.serverError().build();
        }
        Locale locale = this.session.getContext().resolveLocale(this.user);
        Properties messagesBundle = this.handleThemeResources(theme, locale);
        this.handleMessages(locale, messagesBundle);
        UriBuilder uriBuilder = this.prepareBaseUriBuilder(false);
        this.createCommonAttributes(theme, locale, messagesBundle, uriBuilder, null);
        return this.processTemplate(theme, form, locale);
    }

    protected UriBuilder prepareBaseUriBuilder(boolean resetRequestUriParams) {
        String requestURI = this.uriInfo.getBaseUri().getPath();
        UriBuilder uriBuilder = UriBuilder.fromUri((String)requestURI);
        if (resetRequestUriParams) {
            uriBuilder.replaceQuery(null);
        }
        if (this.client != null) {
            uriBuilder.queryParam("client_id", new Object[]{this.client.getClientId()});
        }
        if (this.authenticationSession != null) {
            uriBuilder.queryParam("tab_id", new Object[]{this.authenticationSession.getTabId()});
            String authSessionAction = this.authenticationSession.getAction();
            if (!CommonClientSessionModel.Action.LOGGING_OUT.name().equals(authSessionAction) && !CommonClientSessionModel.Action.LOGGED_OUT.name().equals(authSessionAction)) {
                uriBuilder.queryParam("client_data", new Object[]{AuthenticationProcessor.getClientData(this.session, this.authenticationSession)});
            }
        }
        return uriBuilder;
    }

    protected Theme getTheme() throws IOException {
        return this.session.theme().getTheme(Theme.Type.LOGIN);
    }

    protected Properties handleThemeResources(Theme theme, Locale locale) {
        Properties messagesBundle;
        try {
            messagesBundle = theme.getEnhancedMessages(this.realm, locale);
            HashMap<Object, Object> msgParams = new HashMap<Object, Object>(this.attributes);
            msgParams.putAll(messagesBundle);
            this.attributes.put("msg", new MessageFormatterMethod(locale, msgParams));
            this.attributes.put("advancedMsg", new AdvancedMessageFormatterMethod(locale, messagesBundle));
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load messages", (Throwable)e);
            messagesBundle = new Properties();
        }
        try {
            Properties properties = theme.getProperties();
            this.attributes.put("properties", properties);
            this.attributes.put("darkMode", "true".equals(properties.getProperty("darkMode")) && this.realm.getAttribute("darkMode", Boolean.valueOf(true)) != false);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load properties", (Throwable)e);
        }
        return messagesBundle;
    }

    protected void handleMessages(Locale locale, Properties messagesBundle) {
        MessagesPerFieldBean messagesPerField = new MessagesPerFieldBean();
        if (this.messages != null) {
            MessageBean wholeMessage = new MessageBean(null, this.messageType);
            for (FormMessage message : this.messages) {
                String formattedMessageText = this.formatMessage(message, messagesBundle, locale);
                if (formattedMessageText == null) continue;
                wholeMessage.appendSummaryLine(formattedMessageText);
                messagesPerField.addMessage(message.getField(), formattedMessageText, this.messageType);
            }
            this.attributes.put("message", wholeMessage);
        } else {
            this.attributes.remove("message");
        }
        this.attributes.put("messagesPerField", messagesPerField);
    }

    public String getMessage(String message, Object ... parameters) {
        return this.formatMessage(new FormMessage(null, message, parameters));
    }

    protected void createCommonAttributes(Theme theme, Locale locale, Properties messagesBundle, UriBuilder baseUriBuilder, LoginFormsPages page) {
        URI baseUri = baseUriBuilder.build(new Object[0]);
        if (this.accessCode != null) {
            baseUriBuilder.queryParam("session_code", new Object[]{this.accessCode});
        }
        URI baseUriWithCodeAndClientId = baseUriBuilder.build(new Object[0]);
        if (this.client != null) {
            this.attributes.put("client", new ClientBean(this.session, this.client));
        }
        if (this.realm != null) {
            OrganizationModel organization;
            this.attributes.put("realm", new RealmBean(this.realm));
            IdentityProviderBean idpBean = new IdentityProviderBean(this.session, this.realm, baseUriWithCodeAndClientId, this.context);
            if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION) && this.realm.isOrganizationsEnabled()) {
                idpBean = new OrganizationAwareIdentityProviderBean(idpBean);
            }
            this.attributes.put("social", idpBean);
            this.attributes.put("url", new UrlBean(this.realm, theme, baseUri, this.actionUri));
            this.attributes.put("requiredActionUrl", new RequiredActionUrlFormatterMethod(this.realm, baseUri));
            this.attributes.put("auth", new AuthenticationContextBean(this.context, page));
            this.setAttribute("execution", this.execution);
            if (this.realm.isInternationalizationEnabled()) {
                UriBuilder b;
                if (page != null) {
                    switch (page) {
                        case X509_CONFIRM: 
                        case LOGIN: 
                        case LOGIN_USERNAME: 
                        case LOGIN_WEBAUTHN: {
                            b = UriBuilder.fromUri((URI)Urls.realmLoginPage(baseUri, this.realm.getName()));
                            break;
                        }
                        case REGISTER: {
                            b = UriBuilder.fromUri((URI)Urls.realmRegisterPage(baseUri, this.realm.getName()));
                            break;
                        }
                        case LOGOUT_CONFIRM: {
                            b = UriBuilder.fromUri((URI)Urls.logoutConfirm(baseUri, this.realm.getName()));
                            break;
                        }
                        case INFO: 
                        case ERROR: {
                            if (this.isDetachedAuthenticationSession()) {
                                FormMessage formMessage = this.getFirstMessage();
                                if (formMessage == null) {
                                    throw new IllegalStateException("Not able to create info/error page with detached authentication session as no info/error message available");
                                }
                                DetachedInfoStateCookie cookie = new DetachedInfoStateChecker(this.session, this.realm).generateAndSetCookie(formMessage.getMessage(), this.messageType.toString(), this.status == null ? null : Integer.valueOf(this.status.getStatusCode()), this.client == null ? null : this.client.getId(), formMessage.getParameters());
                                b = UriBuilder.fromUri((URI)Urls.loginActionsDetachedInfo(baseUri, this.realm.getName())).queryParam("kc_state_checker", new Object[]{cookie.getRenderedUrlState()});
                                break;
                            }
                        }
                        default: {
                            b = UriBuilder.fromUri((URI)baseUri).path(this.uriInfo.getPath());
                            break;
                        }
                    }
                } else {
                    b = UriBuilder.fromUri((URI)baseUri).path(this.uriInfo.getPath());
                }
                if (this.execution != null) {
                    b.queryParam("execution", new Object[]{this.execution});
                }
                if (this.authenticationSession != null && this.authenticationSession.getAuthNote("key") != null) {
                    b.queryParam("key", new Object[]{this.authenticationSession.getAuthNote("key")});
                } else {
                    HttpRequest request = this.session.getContext().getHttpRequest();
                    MultivaluedMap queryParameters = request.getUri().getQueryParameters();
                    if (queryParameters != null && queryParameters.getFirst((Object)"token") != null) {
                        b.queryParam("token", new Object[]{queryParameters.getFirst((Object)"token")});
                    }
                }
                LocaleBean localeBean = new LocaleBean(this.realm, locale, b, messagesBundle);
                this.attributes.put("locale", localeBean);
                this.lang = localeBean.getCurrentLanguageTag();
            }
            if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION) && (organization = Organizations.resolveOrganization(this.session, this.user)) != null) {
                this.attributes.put("org", new OrganizationBean(organization, this.user));
            }
            this.attributes.put("passwordPolicies", new PasswordPoliciesBean(this.realm.getPasswordPolicy()));
        }
        if (this.realm != null && this.user != null && this.session != null) {
            this.attributes.put("authenticatorConfigured", new AuthenticatorConfiguredMethod(this.realm, this.user, this.session));
        }
        if (this.authenticationSession != null && this.authenticationSession.getClientNote("kc_action_executing") != null && !Boolean.TRUE.toString().equals(this.authenticationSession.getClientNote("kc_action_enforced"))) {
            this.attributes.put("isAppInitiatedAction", true);
        }
        this.attributes.put("lang", this.lang);
    }

    protected Response processTemplate(Theme theme, String templateName, Locale locale) {
        try {
            Map attributes = (Map)Optional.ofNullable(this.attributeMapper).orElse(Function.identity()).apply(this.attributes);
            if (!attributes.containsKey("templateName")) {
                attributes.put("templateName", templateName);
            }
            attributes.put("pageId", templateName.substring(0, templateName.length() - 4));
            String result = this.freeMarker.processTemplate(attributes, templateName, theme);
            Response.ResponseBuilder builder = Response.status((Response.Status)(this.status == null ? Response.Status.OK : this.status)).type(MediaType.TEXT_HTML_UTF_8_TYPE).language(locale).entity((Object)result);
            for (Map.Entry<String, String> entry : this.httpResponseHeaders.entrySet()) {
                builder.header(entry.getKey(), (Object)entry.getValue());
            }
            return builder.build();
        }
        catch (FreeMarkerException e) {
            logger.error((Object)"Failed to process template", (Throwable)e);
            return Response.serverError().build();
        }
    }

    public Response createLoginUsernamePassword() {
        return this.createResponse(LoginFormsPages.LOGIN);
    }

    public Response createLoginUsername() {
        return this.createResponse(LoginFormsPages.LOGIN_USERNAME);
    }

    public Response createLoginPassword() {
        return this.createResponse(LoginFormsPages.LOGIN_PASSWORD);
    }

    public Response createPasswordReset() {
        String loginHint = this.authenticationSession.getClientNote("login_hint");
        if (loginHint != null && !loginHint.isEmpty()) {
            this.authenticationSession.setAuthNote("ATTEMPTED_USERNAME", loginHint);
        }
        return this.createResponse(LoginFormsPages.LOGIN_RESET_PASSWORD);
    }

    public Response createOtpReset() {
        return this.createResponse(LoginFormsPages.LOGIN_RESET_OTP);
    }

    public Response createLoginTotp() {
        return this.createResponse(LoginFormsPages.LOGIN_TOTP);
    }

    public Response createLoginRecoveryAuthnCode() {
        return this.createResponse(LoginFormsPages.LOGIN_RECOVERY_AUTHN_CODES_INPUT);
    }

    public Response createLoginWebAuthn() {
        return this.createResponse(LoginFormsPages.LOGIN_WEBAUTHN);
    }

    public Response createRegistration() {
        String loginHint = this.authenticationSession.getClientNote("login_hint");
        if (loginHint != null && !loginHint.isEmpty()) {
            if (this.formData == null) {
                this.formData = new MultivaluedHashMap();
            }
            if (this.realm.isRegistrationEmailAsUsername()) {
                value = (String)this.formData.getFirst((Object)"email");
                if (value == null || value.trim().isEmpty()) {
                    this.formData.putSingle((Object)"email", (Object)loginHint);
                }
            } else {
                value = (String)this.formData.getFirst((Object)"username");
                if (value == null || value.trim().isEmpty()) {
                    this.formData.putSingle((Object)"username", (Object)loginHint);
                }
            }
        }
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            String value;
            String email = (String)this.attributes.get("email");
            if (this.formData == null) {
                this.formData = new MultivaluedHashMap();
            }
            if ((value = (String)this.formData.getFirst((Object)"email")) == null || value.trim().isEmpty()) {
                this.formData.putSingle((Object)"email", (Object)email);
            }
        }
        return this.createResponse(LoginFormsPages.REGISTER);
    }

    public Response createInfoPage() {
        return this.createResponse(LoginFormsPages.INFO);
    }

    public Response createUpdateProfilePage() {
        UpdateProfileContext userCtx;
        if (this.messageType != MessageType.ERROR) {
            this.setMessage(MessageType.WARNING, "updateProfileMessage", new Object[0]);
        }
        if ((userCtx = (UpdateProfileContext)this.attributes.get("updateProfileCtx")) != null && userCtx.getUserProfileContext() == UserProfileContext.IDP_REVIEW) {
            return this.createResponse(LoginFormsPages.IDP_REVIEW_USER_PROFILE);
        }
        return this.createResponse(LoginFormsPages.LOGIN_UPDATE_PROFILE);
    }

    public Response createIdpLinkConfirmLinkPage() {
        return this.createResponse(LoginFormsPages.LOGIN_IDP_LINK_CONFIRM);
    }

    public Response createIdpLinkConfirmOverrideLinkPage() {
        return this.createResponse(LoginFormsPages.LOGIN_IDP_LINK_CONFIRM_OVERRIDE);
    }

    public Response createLoginExpiredPage() {
        return this.createResponse(LoginFormsPages.LOGIN_PAGE_EXPIRED);
    }

    public Response createIdpLinkEmailPage() {
        BrokeredIdentityContext brokerContext = (BrokeredIdentityContext)this.attributes.get("identityProviderBrokerCtx");
        String idpAlias = brokerContext.getIdpConfig().getAlias();
        String displayName = idpAlias = ObjectUtil.capitalize((String)idpAlias);
        if (!ObjectUtil.isBlank((CharSequence)brokerContext.getIdpConfig().getDisplayName())) {
            displayName = brokerContext.getIdpConfig().getDisplayName();
        }
        this.setMessage(MessageType.WARNING, "linkIdpMessage", displayName);
        return this.createResponse(LoginFormsPages.LOGIN_IDP_LINK_EMAIL);
    }

    public Response createErrorPage(Response.Status status) {
        if (MediaTypeMatcher.isJsonRequest(this.session.getContext().getRequestHeaders())) {
            OAuth2ErrorRepresentation errorRep = new OAuth2ErrorRepresentation();
            errorRep.setError(this.formatMessage(this.getFirstMessage()));
            return Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)errorRep).build();
        }
        this.status = status;
        return this.createResponse(LoginFormsPages.ERROR);
    }

    public Response createWebAuthnErrorPage() {
        return this.createResponse(LoginFormsPages.ERROR_WEBAUTHN);
    }

    public Response createOAuthGrant() {
        return this.createResponse(LoginFormsPages.OAUTH_GRANT);
    }

    public Response createSelectAuthenticator() {
        return this.createResponse(LoginFormsPages.LOGIN_SELECT_AUTHENTICATOR);
    }

    public Response createOAuth2DeviceVerifyUserCodePage() {
        return this.createResponse(LoginFormsPages.LOGIN_OAUTH2_DEVICE_VERIFY_USER_CODE);
    }

    public Response createCode() {
        return this.createResponse(LoginFormsPages.CODE);
    }

    public Response createX509ConfirmPage() {
        return this.createResponse(LoginFormsPages.X509_CONFIRM);
    }

    public Response createSamlPostForm() {
        return this.createResponse(LoginFormsPages.SAML_POST_FORM);
    }

    public Response createFrontChannelLogoutPage() {
        return this.createResponse(LoginFormsPages.FRONTCHANNEL_LOGOUT);
    }

    public Response createLogoutConfirmPage() {
        return this.createResponse(LoginFormsPages.LOGOUT_CONFIRM);
    }

    public LoginFormsProvider setMessage(MessageType type, String message, Object ... parameters) {
        this.messageType = type;
        this.messages = new ArrayList<FormMessage>();
        this.messages.add(new FormMessage(null, message, parameters));
        return this;
    }

    private FormMessage getFirstMessage() {
        if (this.messages != null && !this.messages.isEmpty()) {
            return this.messages.get(0);
        }
        return null;
    }

    protected String getFirstMessageUnformatted() {
        FormMessage formMessage = this.getFirstMessage();
        return formMessage == null ? null : formMessage.getMessage();
    }

    protected String formatMessage(FormMessage message) {
        Theme theme;
        try {
            theme = this.getTheme();
        }
        catch (IOException e) {
            logger.error((Object)"Failed to create theme", (Throwable)e);
            throw new RuntimeException("Failed to create theme");
        }
        Locale locale = this.session.getContext().resolveLocale(this.user);
        Properties messagesBundle = this.handleThemeResources(theme, locale);
        return this.formatMessage(message, messagesBundle, locale);
    }

    protected String formatMessage(FormMessage message, Properties messagesBundle, Locale locale) {
        if (message == null) {
            return null;
        }
        if (messagesBundle.containsKey(message.getMessage())) {
            return new MessageFormat(messagesBundle.getProperty(message.getMessage()), locale).format(message.getParameters());
        }
        return message.getMessage();
    }

    public FreeMarkerLoginFormsProvider setError(String message, Object ... parameters) {
        this.setMessage(MessageType.ERROR, message, parameters);
        return this;
    }

    public LoginFormsProvider setErrors(List<FormMessage> messages) {
        if (messages == null) {
            return this;
        }
        this.messageType = MessageType.ERROR;
        this.messages = new ArrayList<FormMessage>(messages);
        return this;
    }

    public LoginFormsProvider addError(FormMessage errorMessage) {
        if (this.messageType != MessageType.ERROR) {
            this.messageType = null;
            this.messages = null;
        }
        if (this.messages == null) {
            this.messageType = MessageType.ERROR;
            this.messages = new LinkedList<FormMessage>();
        }
        this.messages.add(errorMessage);
        return this;
    }

    public LoginFormsProvider addSuccess(FormMessage errorMessage) {
        if (this.messageType != MessageType.SUCCESS) {
            this.messageType = null;
            this.messages = null;
        }
        if (this.messages == null) {
            this.messageType = MessageType.SUCCESS;
            this.messages = new LinkedList<FormMessage>();
        }
        this.messages.add(errorMessage);
        return this;
    }

    public FreeMarkerLoginFormsProvider setSuccess(String message, Object ... parameters) {
        this.setMessage(MessageType.SUCCESS, message, parameters);
        return this;
    }

    public FreeMarkerLoginFormsProvider setInfo(String message, Object ... parameters) {
        this.setMessage(MessageType.INFO, message, parameters);
        return this;
    }

    public LoginFormsProvider setDetachedAuthSession() {
        this.detachedAuthSession = true;
        return this;
    }

    private boolean isDetachedAuthenticationSession() {
        return this.detachedAuthSession || this.authenticationSession == null;
    }

    public LoginFormsProvider setAuthenticationSession(AuthenticationSessionModel authenticationSession) {
        this.authenticationSession = authenticationSession;
        return this;
    }

    public FreeMarkerLoginFormsProvider setUser(UserModel user) {
        this.user = user;
        return this;
    }

    public FreeMarkerLoginFormsProvider setFormData(MultivaluedMap<String, String> formData) {
        this.formData = formData;
        return this;
    }

    public LoginFormsProvider setClientSessionCode(String accessCode) {
        this.accessCode = accessCode;
        return this;
    }

    public LoginFormsProvider setAccessRequest(List<AuthorizationDetails> clientScopesRequested) {
        this.clientScopesRequested = clientScopesRequested;
        return this;
    }

    public LoginFormsProvider setAttribute(String name, Object value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
        return this;
    }

    public LoginFormsProvider setStatus(Response.Status status) {
        this.status = status;
        return this;
    }

    public LoginFormsProvider setActionUri(URI actionUri) {
        this.actionUri = actionUri;
        return this;
    }

    public LoginFormsProvider setExecution(String execution) {
        this.execution = execution;
        return this;
    }

    public LoginFormsProvider setResponseHeader(String headerName, String headerValue) {
        this.httpResponseHeaders.put(headerName, headerValue);
        return this;
    }

    public LoginFormsProvider setAuthContext(AuthenticationFlowContext context) {
        this.context = context;
        return this;
    }

    public LoginFormsProvider setAttributeMapper(Function<Map<String, Object>, Map<String, Object>> mapper) {
        this.attributeMapper = mapper;
        return this;
    }

    public void close() {
    }
}

