/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.userprofile.config.UPAttribute;
import org.keycloak.representations.userprofile.config.UPAttributePermissions;
import org.keycloak.representations.userprofile.config.UPAttributeRequired;
import org.keycloak.representations.userprofile.config.UPAttributeSelector;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.representations.userprofile.config.UPGroup;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeGroupMetadata;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.DeclarativeUserProfileProviderFactory;
import org.keycloak.userprofile.DefaultAttributes;
import org.keycloak.userprofile.DefaultUserProfile;
import org.keycloak.userprofile.ServiceAccountAttributes;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.config.DeclarativeUserProfileModel;
import org.keycloak.userprofile.config.UPConfigUtils;
import org.keycloak.util.JsonSerialization;
import org.keycloak.validate.ValidatorConfig;

public class DeclarativeUserProfileProvider
implements UserProfileProvider {
    public static final String UP_COMPONENT_CONFIG_KEY = "kc.user.profile.config";
    protected static final String PARSED_CONFIG_COMPONENT_KEY = "kc.user.profile.metadata";
    protected static final String PARSED_UP_CONFIG_COMPONENT_KEY = "kc.parsed.up.config";
    private final KeycloakSession session;
    private final String providerId;
    private final Map<UserProfileContext, UserProfileMetadata> contextualMetadataRegistry;
    protected final UPConfig parsedDefaultRawConfig;

    private static boolean requestedScopePredicate(AttributeContext context, Set<String> configuredScopes) {
        if (UserProfileContext.USER_API.equals((Object)context.getContext())) {
            return true;
        }
        KeycloakSession session = context.getSession();
        String requestedScopes = AuthenticationManager.getRequestedScopes(session);
        ClientModel client = session.getContext().getClient();
        return TokenManager.getRequestedClientScopes(session, requestedScopes, client, context.getUser()).map(ClientScopeModel::getName).anyMatch(configuredScopes::contains);
    }

    public DeclarativeUserProfileProvider(KeycloakSession session, DeclarativeUserProfileProviderFactory factory) {
        this.session = session;
        this.providerId = factory.getId();
        this.contextualMetadataRegistry = factory.getContextualMetadataRegistry();
        this.parsedDefaultRawConfig = factory.getParsedDefaultRawConfig();
    }

    protected Attributes createAttributes(UserProfileContext context, Map<String, ?> attributes, UserModel user, UserProfileMetadata metadata) {
        if (this.isServiceAccountUser(user)) {
            return new ServiceAccountAttributes(context, attributes, user, metadata, this.session);
        }
        return new DefaultAttributes(context, attributes, user, metadata, this.session);
    }

    public UserProfile create(UserProfileContext context, UserModel user) {
        return this.createUserProfile(context, user.getAttributes(), user);
    }

    public UserProfile create(UserProfileContext context, Map<String, ?> attributes, UserModel user) {
        return this.createUserProfile(context, attributes, user);
    }

    public UserProfile create(UserProfileContext context, Map<String, ?> attributes) {
        return this.createUserProfile(context, attributes, null);
    }

    private UserProfile createUserProfile(UserProfileContext context, Map<String, ?> attributes, UserModel user) {
        UserProfileMetadata defaultMetadata = this.contextualMetadataRegistry.get(context);
        if (defaultMetadata == null) {
            throw new RuntimeException("No metadata is bound to the " + String.valueOf(context) + " context");
        }
        UserProfileMetadata metadata = this.configureUserProfile(defaultMetadata, this.session);
        Attributes profileAttributes = this.createAttributes(context, attributes, user, metadata);
        return new DefaultUserProfile(metadata, profileAttributes, this.createUserFactory(), user, this.session);
    }

    private Function<Attributes, UserModel> createUserFactory() {
        return new Function<Attributes, UserModel>(){
            private UserModel user;

            @Override
            public UserModel apply(Attributes attributes) {
                if (this.user == null) {
                    String userName = attributes.getFirst("username");
                    if (userName == null) {
                        userName = attributes.getFirst("email");
                    }
                    this.user = DeclarativeUserProfileProvider.this.session.users().addUser(DeclarativeUserProfileProvider.this.session.getContext().getRealm(), userName);
                }
                return this.user;
            }
        };
    }

    protected UserProfileMetadata configureUserProfile(UserProfileMetadata metadata, KeycloakSession session) {
        UserProfileContext context = metadata.getContext();
        UserProfileMetadata decoratedMetadata = metadata.clone();
        ComponentModel component = this.getComponentModel().orElse(null);
        if (component == null) {
            return decoratedMetadata;
        }
        ConcurrentHashMap<UserProfileContext, UserProfileMetadata> metadataMap = (ConcurrentHashMap<UserProfileContext, UserProfileMetadata>)component.getNote(PARSED_CONFIG_COMPONENT_KEY);
        if (metadataMap == null) {
            metadataMap = new ConcurrentHashMap<UserProfileContext, UserProfileMetadata>();
            component.setNote(PARSED_CONFIG_COMPONENT_KEY, metadataMap);
        }
        return metadataMap.computeIfAbsent(context, this.createUserDefinedProfileDecorator(session, decoratedMetadata, component)).clone();
    }

    public UPConfig getConfiguration() {
        Optional<ComponentModel> component = this.getComponentModel();
        if (component.isPresent()) {
            UPConfig cfg = this.getConfigFromComponentModel(component.get());
            if (cfg == null) {
                cfg = this.parsedDefaultRawConfig;
            }
            return cfg.clone();
        }
        return this.parsedDefaultRawConfig.clone();
    }

    public void setConfiguration(UPConfig configuration) {
        RealmModel realm = this.session.getContext().getRealm();
        Optional<ComponentModel> optionalComponent = this.getComponentModel();
        if (optionalComponent.isEmpty() && configuration == null) {
            return;
        }
        ComponentModel component = optionalComponent.orElseGet(this::createComponentModel);
        this.removeConfigJsonFromComponentModel(component);
        if (configuration == null) {
            realm.removeComponent(component);
            return;
        }
        try {
            component.getConfig().putSingle((Object)UP_COMPONENT_CONFIG_KEY, (Object)JsonSerialization.writeValueAsString((Object)configuration));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot write component config", ioe);
        }
        realm.updateComponent(component);
    }

    private Optional<ComponentModel> getComponentModel() {
        RealmModel realm = this.session.getContext().getRealm();
        return realm.getComponentsStream(realm.getId(), UserProfileProvider.class.getName()).filter(componentModel -> componentModel.getProviderId().equals(this.providerId)).findFirst();
    }

    protected UserProfileMetadata decorateUserProfileForCache(UserProfileMetadata decoratedMetadata, UPConfig parsedConfig) {
        UserProfileContext context = decoratedMetadata.getContext();
        if (parsedConfig == null || parsedConfig.getAttributes() == null) {
            return decoratedMetadata;
        }
        Map<String, UPGroup> groupsByName = this.asHashMap(parsedConfig.getGroups());
        int guiOrder = 0;
        for (UPAttribute attrConfig : parsedConfig.getAttributes()) {
            UPAttributeRequired rc;
            String attributeName = attrConfig.getName();
            if (!context.isAttributeSupported(attributeName)) continue;
            ArrayList<AttributeValidatorMetadata> validators = new ArrayList<AttributeValidatorMetadata>();
            Map validationsConfig = attrConfig.getValidations();
            if (validationsConfig != null) {
                for (Map.Entry vc : validationsConfig.entrySet()) {
                    validators.add(this.createConfiguredValidator((String)vc.getKey(), (Map)vc.getValue()));
                }
            }
            if ((rc = attrConfig.getRequired()) != null) {
                validators.add(new AttributeValidatorMetadata("up-attribute-required-by-metadata-value"));
            }
            Predicate<AttributeContext> required = AttributeMetadata.ALWAYS_FALSE;
            if (rc != null) {
                if (rc.isAlways() || context.isRoleForContext(rc.getRoles())) {
                    required = c -> !this.isServiceAccountUser(c.getUser());
                    if (rc.getScopes() != null && !rc.getScopes().isEmpty()) {
                        required = context.canBeAuthFlowContext() ? c -> !this.isServiceAccountUser(c.getUser()) && DeclarativeUserProfileProvider.requestedScopePredicate(c, rc.getScopes()) : AttributeMetadata.ALWAYS_FALSE;
                    }
                } else if (context.canBeAuthFlowContext() && rc.getScopes() != null && !rc.getScopes().isEmpty()) {
                    required = c -> !this.isServiceAccountUser(c.getUser()) && DeclarativeUserProfileProvider.requestedScopePredicate(c, rc.getScopes());
                }
            }
            Predicate<Object> writeAllowed = AttributeMetadata.ALWAYS_FALSE;
            Predicate<Object> readAllowed = AttributeMetadata.ALWAYS_FALSE;
            UPAttributePermissions permissions = attrConfig.getPermissions();
            if (permissions != null) {
                Set viewRoles;
                Set editRoles = permissions.getEdit();
                if (!editRoles.isEmpty()) {
                    writeAllowed = ac -> ac.getContext().isRoleForContext(editRoles);
                }
                readAllowed = (viewRoles = permissions.getView()).isEmpty() ? writeAllowed : this.createViewAllowedPredicate(writeAllowed, viewRoles);
            }
            Predicate<AttributeContext> selector = AttributeMetadata.ALWAYS_TRUE;
            UPAttributeSelector sc = attrConfig.getSelector();
            if (sc != null && !this.isBuiltInAttribute(attributeName) && context.canBeAuthFlowContext() && sc.getScopes() != null && !sc.getScopes().isEmpty()) {
                selector = c -> DeclarativeUserProfileProvider.requestedScopePredicate(c, sc.getScopes());
            }
            Map annotations = attrConfig.getAnnotations();
            String attributeGroup = attrConfig.getGroup();
            AttributeGroupMetadata groupMetadata = this.toAttributeGroupMeta(groupsByName.get(attributeGroup));
            ++guiOrder;
            validators.add(new AttributeValidatorMetadata("up-immutable-attribute"));
            if (!attrConfig.isMultivalued() && validators.stream().map(AttributeValidatorMetadata::getValidatorId).noneMatch("multivalued"::equals)) {
                validators.add(new AttributeValidatorMetadata("multivalued", ValidatorConfig.builder().config("max", (Object)"1").build()));
            }
            if (this.isBuiltInAttribute(attributeName)) {
                List existingMetadata;
                if (permissions == null || permissions.isEmpty()) {
                    writeAllowed = AttributeMetadata.ALWAYS_TRUE;
                    readAllowed = AttributeMetadata.ALWAYS_TRUE;
                }
                if ("username".equals(attributeName)) {
                    required = new Predicate<AttributeContext>(){

                        @Override
                        public boolean test(AttributeContext context) {
                            RealmModel realm = context.getSession().getContext().getRealm();
                            return !realm.isRegistrationEmailAsUsername();
                        }
                    };
                }
                if ("email".equals(attributeName)) {
                    final Predicate<AttributeContext> requiredFromConfig = required;
                    required = new Predicate<AttributeContext>(){

                        @Override
                        public boolean test(AttributeContext context) {
                            UserModel user = context.getUser();
                            if (DeclarativeUserProfileProvider.this.isServiceAccountUser(user)) {
                                return false;
                            }
                            if (requiredFromConfig.test(context)) {
                                return true;
                            }
                            RealmModel realm = context.getSession().getContext().getRealm();
                            return realm.isRegistrationEmailAsUsername();
                        }
                    };
                }
                if ((existingMetadata = decoratedMetadata.getAttribute(attributeName)).isEmpty()) {
                    throw new IllegalStateException("Attribute " + attributeName + " not defined in the context.");
                }
                for (AttributeMetadata metadata : existingMetadata) {
                    metadata.addAnnotations(annotations).setAttributeDisplayName(attrConfig.getDisplayName()).setGuiOrder(guiOrder).setAttributeGroupMetadata(groupMetadata).addReadCondition((Predicate)readAllowed).addWriteCondition((Predicate)writeAllowed).addValidators(validators).setRequired((Predicate)required).setDefaultValue(attrConfig.getDefaultValue()).setMultivalued(attrConfig.isMultivalued());
                }
                continue;
            }
            decoratedMetadata.addAttribute(attributeName, guiOrder, validators, selector, (Predicate)writeAllowed, required, (Predicate)readAllowed).addAnnotations(annotations).setAttributeDisplayName(attrConfig.getDisplayName()).setAttributeGroupMetadata(groupMetadata).setDefaultValue(attrConfig.getDefaultValue()).setMultivalued(attrConfig.isMultivalued());
        }
        return decoratedMetadata;
    }

    private Map<String, UPGroup> asHashMap(List<UPGroup> groups) {
        return groups.stream().collect(Collectors.toMap(g -> g.getName(), g -> g));
    }

    private AttributeGroupMetadata toAttributeGroupMeta(UPGroup group) {
        if (group == null) {
            return null;
        }
        return new AttributeGroupMetadata(group.getName(), group.getDisplayHeader(), group.getDisplayDescription(), group.getAnnotations());
    }

    private boolean isBuiltInAttribute(String attributeName) {
        return "username".equals(attributeName) || "email".equals(attributeName);
    }

    private boolean isOptionalBuiltInAttribute(String attributeName) {
        return "firstName".equals(attributeName) || "lastName".equals(attributeName);
    }

    private Predicate<AttributeContext> createViewAllowedPredicate(Predicate<AttributeContext> canEdit, Set<String> viewRoles) {
        return ac -> ac.getContext().isRoleForContext(viewRoles) || canEdit.test((AttributeContext)ac);
    }

    private boolean isServiceAccountUser(UserModel user) {
        return user != null && user.getServiceAccountClientLink() != null;
    }

    protected UPConfig parseConfigOrDefault(ComponentModel component) {
        String rawConfig = component.get(UP_COMPONENT_CONFIG_KEY);
        if (ObjectUtil.isBlank((CharSequence)rawConfig)) {
            return this.parsedDefaultRawConfig;
        }
        try {
            return UPConfigUtils.parseConfig(rawConfig);
        }
        catch (IOException e) {
            throw new RuntimeException("UserProfile configuration for realm '" + this.session.getContext().getRealm().getName() + "' is invalid:" + e.getMessage(), e);
        }
    }

    protected ComponentModel createComponentModel() {
        RealmModel realm = this.session.getContext().getRealm();
        return realm.addComponentModel((ComponentModel)new DeclarativeUserProfileModel(this.providerId));
    }

    protected AttributeValidatorMetadata createConfiguredValidator(String validator, Map<String, Object> validatorConfig) {
        return new AttributeValidatorMetadata(validator, ValidatorConfig.builder().config(validatorConfig).config("ignore.empty.value", (Object)true).build());
    }

    private UPConfig getConfigFromComponentModel(ComponentModel model) {
        UPConfig cached = this.getParsedConfigFromCache(model);
        if (cached == null) {
            cached = this.parseAndCacheConfig(model);
        }
        return cached;
    }

    private UPConfig parseAndCacheConfig(ComponentModel model) {
        UPConfig cfg = this.parseConfigOrDefault(model);
        model.setNote(PARSED_UP_CONFIG_COMPONENT_KEY, (Object)cfg);
        return cfg;
    }

    private UPConfig getParsedConfigFromCache(ComponentModel component) {
        if (component == null) {
            return null;
        }
        return (UPConfig)component.getNote(PARSED_UP_CONFIG_COMPONENT_KEY);
    }

    private void removeConfigJsonFromComponentModel(ComponentModel model) {
        if (model == null) {
            return;
        }
        model.getConfig().remove((Object)UP_COMPONENT_CONFIG_KEY);
    }

    public void close() {
    }

    private Function<UserProfileContext, UserProfileMetadata> createUserDefinedProfileDecorator(KeycloakSession session, UserProfileMetadata decoratedMetadata, ComponentModel component) {
        return c -> {
            UPConfig parsedConfig = this.getConfigFromComponentModel(component);
            List<String> errors = UPConfigUtils.validate(session, parsedConfig);
            if (!errors.isEmpty()) {
                throw new RuntimeException("UserProfile configuration for realm '" + session.getContext().getRealm().getName() + "' is invalid: " + errors.toString());
            }
            Iterator attributes = decoratedMetadata.getAttributes().iterator();
            while (attributes.hasNext()) {
                AttributeMetadata metadata = (AttributeMetadata)attributes.next();
                String attributeName = metadata.getName();
                if (this.isBuiltInAttribute(attributeName)) {
                    UPAttribute upAttribute = this.parsedDefaultRawConfig.getAttribute(attributeName);
                    Map validations = Optional.ofNullable(upAttribute.getValidations()).orElse(Collections.emptyMap());
                    for (String id : validations.keySet()) {
                        List validators = metadata.getValidators();
                        validators.removeIf(m -> m.getValidatorId().equals(id));
                    }
                    continue;
                }
                if (!this.isOptionalBuiltInAttribute(attributeName)) continue;
                attributes.remove();
            }
            return this.decorateUserProfileForCache(decoratedMetadata, parsedConfig);
        };
    }
}

