/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaCompilerConfigurationProxy {
    private static final ExtensionPointName<JavaCompilerConfigurationProxy> EP_NAME = new ExtensionPointName("com.intellij.javaCompilerConfigurationProxy");

    protected abstract List<String> getAdditionalOptionsImpl(@NotNull Project var1, @NotNull Module var2);

    protected abstract void setAdditionalOptionsImpl(@NotNull Project var1, @NotNull Module var2, @NotNull List<String> var3);

    public static List<String> getAdditionalOptions(@NotNull Project project, @NotNull Module module2) {
        List<JavaCompilerConfigurationProxy> extensions;
        if (project == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(0);
        }
        if (module2 == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(1);
        }
        if ((extensions = EP_NAME.getExtensionList()).isEmpty()) {
            return Collections.emptyList();
        }
        return extensions.get(0).getAdditionalOptionsImpl(project, module2);
    }

    public static void setAdditionalOptions(@NotNull Project project, @NotNull Module module2, @NotNull List<String> options) {
        List<JavaCompilerConfigurationProxy> extensions;
        if (project == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(2);
        }
        if (module2 == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(3);
        }
        if (options == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(4);
        }
        if ((extensions = EP_NAME.getExtensionList()).isEmpty()) {
            return;
        }
        extensions.get(0).setAdditionalOptionsImpl(project, module2, options);
    }

    public static boolean isPatchedModuleRoot(@NotNull String targetModuleName, @NotNull Module module2, @NotNull VirtualFile root) {
        List<String> options;
        if (targetModuleName == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(5);
        }
        if (module2 == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(6);
        }
        if (root == null) {
            JavaCompilerConfigurationProxy.$$$reportNull$$$0(7);
        }
        if ((options = JavaCompilerConfigurationProxy.getAdditionalOptions(module2.getProject(), module2)).isEmpty()) {
            return false;
        }
        String prefix = targetModuleName + "=";
        for (String option : JavaCompilerConfigurationProxy.optionValues(options, "--patch-module")) {
            String[] patchingPaths;
            if (!option.startsWith(prefix)) continue;
            for (String patchingPath : patchingPaths = option.substring(prefix.length()).split(File.pathSeparator)) {
                if (!VfsUtilCore.pathEqualsTo(root, FileUtil.toSystemIndependentName(patchingPath))) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> optionValues(List<String> options, String name2) {
        if (options.isEmpty()) {
            return Collections.emptyList();
        }
        boolean useValue = false;
        ArrayList<String> result2 = new ArrayList<String>();
        for (String option : options) {
            if (option.equals(name2)) {
                useValue = true;
                continue;
            }
            if (useValue) {
                useValue = false;
            } else {
                if (!option.startsWith(name2) || option.length() <= name2.length() + 1 || option.charAt(name2.length()) != '=') continue;
                option = option.substring(name2.length() + 1);
            }
            if (option.isEmpty()) continue;
            result2.add(option);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetModuleName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/JavaCompilerConfigurationProxy";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdditionalOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setAdditionalOptions";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isPatchedModuleRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

