/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementPsiSource;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

public class JavaAnnotationImpl
extends JavaElementImpl<PsiAnnotation>
implements JavaAnnotation {
    public JavaAnnotationImpl(@NotNull JavaElementPsiSource<PsiAnnotation> psiAnnotation) {
        if (psiAnnotation == null) {
            JavaAnnotationImpl.$$$reportNull$$$0(0);
        }
        super(psiAnnotation);
    }

    @Override
    @NotNull
    public Collection<JavaAnnotationArgument> getArguments() {
        Collection<JavaAnnotationArgument> collection = JavaElementCollectionFromPsiArrayUtil.namedAnnotationArguments(((PsiAnnotation)this.getPsi()).getParameterList().getAttributes(), this.getSourceFactory());
        if (collection == null) {
            JavaAnnotationImpl.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    @Nullable
    public ClassId getClassId() {
        PsiClass resolved = this.resolvePsi();
        if (resolved != null) {
            return JavaAnnotationImpl.computeClassId(resolved);
        }
        String qualifiedName = ((PsiAnnotation)this.getPsi()).getQualifiedName();
        if (qualifiedName != null) {
            return ClassId.topLevel(new FqName(qualifiedName));
        }
        return null;
    }

    @Override
    @Nullable
    public JavaClass resolve() {
        PsiClass resolved = this.resolvePsi();
        return resolved == null ? null : new JavaClassImpl(this.createPsiSource(resolved));
    }

    @Nullable
    private static ClassId computeClassId(@NotNull PsiClass psiClass) {
        PsiClass container;
        if (psiClass == null) {
            JavaAnnotationImpl.$$$reportNull$$$0(2);
        }
        if ((container = psiClass.getContainingClass()) != null) {
            ClassId parentClassId = JavaAnnotationImpl.computeClassId(container);
            String name2 = psiClass.getName();
            return parentClassId == null || name2 == null ? null : parentClassId.createNestedClassId(Name.identifier(name2));
        }
        String fqName = psiClass.getQualifiedName();
        return fqName == null ? null : ClassId.topLevel(new FqName(fqName));
    }

    @Nullable
    private PsiClass resolvePsi() {
        PsiJavaCodeReferenceElement referenceElement = ((PsiAnnotation)this.getPsi()).getNameReferenceElement();
        if (referenceElement == null) {
            return null;
        }
        PsiElement resolved = referenceElement.resolve();
        return resolved instanceof PsiClass ? (PsiClass)resolved : null;
    }

    @Override
    public boolean isIdeExternalAnnotation() {
        PsiAnnotation psi = (PsiAnnotation)this.getPsi();
        ExternalAnnotationsManager externalAnnotationManager = ExternalAnnotationsManager.getInstance(psi.getProject());
        return externalAnnotationManager.isExternalAnnotation(psi);
    }

    @Override
    public boolean isResolvedTo(@NotNull FqName fqName) {
        PsiJavaCodeReferenceElement referenceElement;
        if (fqName == null) {
            JavaAnnotationImpl.$$$reportNull$$$0(3);
        }
        if ((referenceElement = ((PsiAnnotation)this.getPsi()).getNameReferenceElement()) == null || !Objects.equals(referenceElement.getReferenceName(), fqName.shortNameOrSpecial().asString())) {
            return false;
        }
        return ((PsiAnnotation)this.getPsi()).hasQualifiedName(fqName.asString());
    }

    @Override
    public boolean isFreshlySupportedTypeUseAnnotation() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/load/java/structure/impl/JavaAnnotationImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/load/java/structure/impl/JavaAnnotationImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeClassId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

