/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.CheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.OptInDescription;
import org.jetbrains.kotlin.resolve.checkers.OptInDiagnosticMessageProvider;
import org.jetbrains.kotlin.resolve.checkers.OptInInheritanceDiagnosticMessageProvider;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.checkers.OptInUsageCheckerUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.OptInUsagesDiagnosticMessageProvider;
import org.jetbrains.kotlin.resolve.checkers.OptInUsagesInFutureDiagnosticMessageProvider;
import org.jetbrains.kotlin.resolve.checkers.UsageCheckerUtilsKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationSettings;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0006\u000f\u0010\u0011\u0012\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findRelevantDataClassPropertyIfAny", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "OptInDiagnosticReporter", "OptInFactoryBasedReporter", "OptInReporterMultiplexer", "Companion", "ClassifierUsage", "Overrides", "frontend"})
@SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,561:1\n1563#2:562\n1634#2,3:563\n*S KotlinDebug\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker\n*L\n104#1:562\n104#1:563,3\n*E\n"})
public final class OptInUsageChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Name LEVEL;
    @NotNull
    private static final Name MESSAGE;
    @NotNull
    private static final Name WARNING_LEVEL;
    @NotNull
    private static final Name ERROR_LEVEL;
    @NotNull
    private static final OptInReporterMultiplexer USAGE_DIAGNOSTICS;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        PropertyDescriptor propertyDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getResultingDescriptor(...)");
        Object resultingDescriptor = obj;
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        LanguageVersionSettings languageVersionSettings = context2.getLanguageVersionSettings();
        Set optIns = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, (DeclarationDescriptor)resultingDescriptor, bindingContext2, languageVersionSettings, null, false, false, false, 60, null);
        if (resultingDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)resultingDescriptor).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED && (propertyDescriptor = this.findRelevantDataClassPropertyIfAny((FunctionDescriptor)resultingDescriptor, context2)) != null) {
            Companion.reportNotAllowedOptIns(SetsKt.plus(optIns, org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, propertyDescriptor, bindingContext2, languageVersionSettings, null, false, false, false, 60, null)), reportOn, context2);
            return;
        }
        if (resultingDescriptor instanceof SamConstructorDescriptor) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            CallableMemberDescriptor methodDescriptor = ((SamConstructorDescriptor)resultingDescriptor).getSingleAbstractMethod();
            Iterable iterable = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, methodDescriptor, bindingContext2, languageVersionSettings, null, false, false, false, 60, null);
            boolean $i$f$map = false;
            void var12_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                OptInDescription optInDescription = (OptInDescription)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FqName fqName = optInDescription.component1();
                String message2 = optInDescription.component3();
                collection.add(new OptInDescription(fqName, OptInDescription.Severity.WARNING, message2, false));
            }
            List samOptIns = (List)destination$iv$iv;
            Companion.reportNotAllowedOptIns(samOptIns, reportOn, context2);
        }
        Companion.reportNotAllowedOptIns(optIns, reportOn, context2);
    }

    private final PropertyDescriptor findRelevantDataClassPropertyIfAny(FunctionDescriptor $this$findRelevantDataClassPropertyIfAny, CallCheckerContext context2) {
        String string = $this$findRelevantDataClassPropertyIfAny.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        Integer index = StringsKt.toIntOrNull(StringsKt.removePrefix(string, (CharSequence)"component"));
        DeclarationDescriptor declarationDescriptor = $this$findRelevantDataClassPropertyIfAny.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor container = declarationDescriptor;
        if (container instanceof ClassDescriptor && ((ClassDescriptor)container).isData() && index != null) {
            ValueParameterDescriptor dataClassParameterDescriptor;
            Object object = ((ClassDescriptor)container).getUnsubstitutedPrimaryConstructor();
            ValueParameterDescriptor valueParameterDescriptor = object != null && (object = object.getValueParameters()) != null ? (ValueParameterDescriptor)CollectionsKt.getOrNull(object, index - 1) : (dataClassParameterDescriptor = null);
            if (dataClassParameterDescriptor != null) {
                return (PropertyDescriptor)context2.getTrace().getBindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, dataClassParameterDescriptor);
            }
        }
        return null;
    }

    private static final OptInDiagnosticReporter USAGE_DIAGNOSTICS$lambda$0(boolean subclassesOnly) {
        OptInDiagnosticMessageProvider messageProvider = OptInUsageChecker.Companion.getMessageProvider(subclassesOnly);
        DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory2 = subclassesOnly ? Errors.OPT_IN_TO_INHERITANCE : Errors.OPT_IN_USAGE;
        Intrinsics.checkNotNull(diagnosticFactory2);
        return new OptInFactoryBasedReporter(diagnosticFactory2, (Function1<? super String, String>)new Function1<String, String>((Object)messageProvider){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((OptInDiagnosticMessageProvider)this.receiver).buildCustomDiagnosticMessage(p0);
            }
        }, Companion.getDefaultDiagnosticMessage$frontend(messageProvider, "should"));
    }

    private static final OptInDiagnosticReporter USAGE_DIAGNOSTICS$lambda$1(boolean subclassesOnly) {
        OptInDiagnosticMessageProvider messageProvider = OptInUsageChecker.Companion.getMessageProvider(subclassesOnly);
        DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory2 = subclassesOnly ? Errors.OPT_IN_TO_INHERITANCE_ERROR : Errors.OPT_IN_USAGE_ERROR;
        Intrinsics.checkNotNull(diagnosticFactory2);
        return new OptInFactoryBasedReporter(diagnosticFactory2, (Function1<? super String, String>)new Function1<String, String>((Object)messageProvider){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((OptInDiagnosticMessageProvider)this.receiver).buildCustomDiagnosticMessage(p0);
            }
        }, Companion.getDefaultDiagnosticMessage$frontend(messageProvider, "must"));
    }

    static {
        Name name2 = Name.identifier("level");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        LEVEL = name2;
        Name name3 = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        MESSAGE = name3;
        Name name4 = Name.identifier("WARNING");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
        WARNING_LEVEL = name4;
        Name name5 = Name.identifier("ERROR");
        Intrinsics.checkNotNullExpressionValue(name5, "identifier(...)");
        ERROR_LEVEL = name5;
        Function1<Boolean, OptInDiagnosticReporter> function1 = OptInUsageChecker::USAGE_DIAGNOSTICS$lambda$0;
        Function1<Boolean, OptInDiagnosticReporter> function12 = OptInUsageChecker::USAGE_DIAGNOSTICS$lambda$1;
        DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory2 = Errors.OPT_IN_USAGE_FUTURE_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, "OPT_IN_USAGE_FUTURE_ERROR");
        USAGE_DIAGNOSTICS = new OptInReporterMultiplexer(function1, function12, new OptInFactoryBasedReporter(diagnosticFactory2, (Function1<? super String, String>)new Function1<String, String>((Object)OptInUsagesInFutureDiagnosticMessageProvider.INSTANCE){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((OptInUsagesInFutureDiagnosticMessageProvider)this.receiver).buildCustomDiagnosticMessage(p0);
            }
        }, Companion.getDefaultDiagnosticMessage$frontend(OptInUsagesInFutureDiagnosticMessageProvider.INSTANCE, "must")));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\tH\u0002J\u0014\u0010\u0010\u001a\u00020\u000f*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "<init>", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "checkUsageOfKotlinRequiresOptInOrOptIn", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "isUsageAsQualifier", "", "isUsageAsOptInArgument", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$ClassifierUsage\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,561:1\n232#2:562\n232#2:563\n1761#3,3:564\n*S KotlinDebug\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$ClassifierUsage\n*L\n476#1:562\n477#1:563\n478#1:564,3\n*E\n"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        /*
         * Unable to fully structure code
         */
        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context) {
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter(targetDescriptor, "targetDescriptor");
                    Intrinsics.checkNotNullParameter(element, "element");
                    Intrinsics.checkNotNullParameter(context, "context");
                    v0 = targetDescriptor.getName();
                    Intrinsics.checkNotNullExpressionValue(v0, "getName(...)");
                    name = v0;
                    if ((Intrinsics.areEqual(name, OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().shortName()) || Intrinsics.areEqual(name, OptInNames.INSTANCE.getOPT_IN_FQ_NAME().shortName())) && (Intrinsics.areEqual(fqName = DescriptorUtilsKt.getFqNameSafe(targetDescriptor), OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME()) || Intrinsics.areEqual(fqName, OptInNames.INSTANCE.getOPT_IN_FQ_NAME()))) {
                        this.checkUsageOfKotlinRequiresOptInOrOptIn(element, context);
                        return;
                    }
                    var6_6 = targetDescriptor;
                    targetClass = var6_6 instanceof ClassDescriptor != false ? (ClassDescriptor)targetDescriptor : (var6_6 instanceof TypeAliasDescriptor != false ? ((TypeAliasDescriptor)targetDescriptor).getClassDescriptor() : null);
                    v1 = context.getTrace().getBindingContext();
                    Intrinsics.checkNotNullExpressionValue(v1, "getBindingContext(...)");
                    bindingContext = v1;
                    if (targetClass != null && org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(OptInUsageChecker.Companion, targetClass, false, false, 3, null) != null && !UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element) && !this.isUsageAsOptInArgument(element, bindingContext)) {
                        context.getTrace().report(Errors.OPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN.on(element));
                    }
                    var7_7 = element;
                    strict$iv = false;
                    $i$f$getParentOfType = false;
                    if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtImportDirective.class, strict$iv) != null) break block8;
                    strict$iv = element;
                    strict$iv = true;
                    $i$f$getParentOfType = false;
                    containingClass = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClassOrObject.class, strict$iv);
                    if (containingClass == null) ** GOTO lbl-1000
                    $this$any$iv = containingClass.getSuperTypeListEntries();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v2 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (KtSuperTypeListEntry)element$iv;
                            $i$a$-any-OptInUsageChecker$ClassifierUsage$check$fromSuperType$1 = false;
                            if (!Intrinsics.areEqual(it.getTypeAsUserType(), element.getParent())) continue;
                            v2 = true;
                            break block7;
                        }
                        v2 = false;
                    }
                }
                if (v2) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                fromSuperType = v3;
                checkedDescriptor = fromSuperType != false && targetClass != null ? (ClassifierDescriptor)targetClass : targetDescriptor;
                descriptions = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(OptInUsageChecker.Companion, checkedDescriptor, bindingContext, context.getLanguageVersionSettings(), null, false, false, fromSuperType, 28, null);
                OptInUsageChecker.Companion.reportNotAllowedOptIns(descriptions, element, context);
            }
        }

        private final void checkUsageOfKotlinRequiresOptInOrOptIn(PsiElement element, CheckerContext context2) {
            List<String> optInFqNames = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getOptIn());
            if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.OptInRelease) && !optInFqNames.contains(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) {
                context2.getTrace().report(Errors.OPT_IN_IS_NOT_ENABLED.on(element));
            }
            if (!UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element) && !this.isUsageAsQualifier(element)) {
                context2.getTrace().report(Errors.OPT_IN_CAN_ONLY_BE_USED_AS_ANNOTATION.on(element));
            }
        }

        private final boolean isUsageAsQualifier(PsiElement $this$isUsageAsQualifier) {
            if ($this$isUsageAsQualifier instanceof KtSimpleNameExpression) {
                KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector((KtSimpleNameExpression)$this$isUsageAsQualifier);
                KtExpression qualifier = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)$this$isUsageAsQualifier;
                PsiElement psiElement = qualifier.getParent();
                KtDotQualifiedExpression ktDotQualifiedExpression = psiElement instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null;
                if (Intrinsics.areEqual(ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getReceiverExpression() : null, qualifier)) {
                    return true;
                }
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUsageAsOptInArgument(PsiElement $this$isUsageAsOptInArgument, BindingContext bindingContext) {
            KtExpression ktExpression = $this$isUsageAsOptInArgument instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)$this$isUsageAsOptInArgument : null;
            PsiElement qualifier = ktExpression != null && (ktExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector(ktExpression)) != null ? (PsiElement)ktExpression : $this$isUsageAsOptInArgument;
            PsiElement parent2 = qualifier.getParent();
            if (!(parent2 instanceof KtClassLiteralExpression)) return false;
            if (!(((KtClassLiteralExpression)parent2).getParent() instanceof KtValueArgument)) return false;
            if (!(((KtClassLiteralExpression)parent2).getParent().getParent() instanceof KtValueArgumentList)) return false;
            PsiElement entry = ((KtClassLiteralExpression)parent2).getParent().getParent().getParent();
            boolean bl = false;
            if (!(entry instanceof KtAnnotationEntry)) return false;
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
            if (annotationDescriptor == null) return false;
            AnnotationDescriptor annotation = annotationDescriptor;
            boolean bl2 = false;
            if (Intrinsics.areEqual(annotation.getFqName(), OptInNames.INSTANCE.getOPT_IN_FQ_NAME())) return true;
            if (Intrinsics.areEqual(annotation.getFqName(), OptInNames.INSTANCE.getWAS_EXPERIMENTAL_FQ_NAME())) return true;
            if (!Intrinsics.areEqual(annotation.getFqName(), OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME())) return false;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ4\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015JN\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0%*\u00020&2\u0006\u0010\u001d\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 2\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020&0)2\b\b\u0002\u0010*\u001a\u00020\u00132\b\b\u0002\u0010+\u001a\u00020\u00132\b\b\u0002\u0010,\u001a\u00020\u0013J<\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0%*\u0004\u0018\u00010-2\u0006\u0010\u001d\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020&0)2\b\b\u0002\u0010/\u001a\u00020\u0013H\u0002J'\u00100\u001a\u0004\u0018\u00010\u001a*\u0002012\b\b\u0002\u0010*\u001a\u00020\u00132\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b2J\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u001a04*\u0002052\u0006\u00106\u001a\u000207H\u0002J$\u00108\u001a\u00020\u0013*\u00020\u001c2\u0006\u00109\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u00108\u001a\u00020\u0013*\u00020\u001c2\u0006\u00109\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010:\u001a\u00020'J,\u00108\u001a\u00020\u0013*\u00020\u001c2\u0006\u00109\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010:\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J!\u0010;\u001a\u00020\u0013*\u00020\u001c2\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020'H\u0000\u00a2\u0006\u0002\b<J\u001c\u0010=\u001a\u00020\u0013*\u00020\u001c2\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020'H\u0002J\u001c\u0010>\u001a\u00020\u0013*\u00020\u001c2\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020'H\u0002J0\u0010?\u001a\u00020\u0013*\u00020\u001c2!\u0010@\u001a\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\bA\u0012\b\bB\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00130\nH\u0082\bJ>\u0010C\u001a\u00020\u00172\u0006\u00106\u001a\u0002072\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\n2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Companion;", "", "<init>", "()V", "LEVEL", "Lorg/jetbrains/kotlin/name/Name;", "MESSAGE", "WARNING_LEVEL", "ERROR_LEVEL", "getDefaultDiagnosticMessage", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqName;", "", "messageProvider", "Lorg/jetbrains/kotlin/resolve/checkers/OptInDiagnosticMessageProvider;", "verb", "getDefaultDiagnosticMessage$frontend", "getMessageProvider", "subclassesOnly", "", "USAGE_DIAGNOSTICS", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInReporterMultiplexer;", "reportNotAllowedOptIns", "", "descriptions", "", "Lorg/jetbrains/kotlin/resolve/checkers/OptInDescription;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "diagnostics", "loadOptIns", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "visited", "", "useFutureError", "useMarkersFromContainer", "fromSupertype", "Lorg/jetbrains/kotlin/types/KotlinType;", "visitedClassifiers", "warningsOnly", "loadOptInForMarkerAnnotation", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "loadOptInForMarkerAnnotation$frontend", "loadSubclassOptInRequired", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "isOptInAllowed", "annotationFqName", "bindingContext", "isDeclarationAnnotatedWith", "isDeclarationAnnotatedWith$frontend", "isElementAnnotatedWithOptIn", "isElementAnnotatedWithSubclassOptInRequired", "anyParentMatches", "predicate", "Lkotlin/ParameterName;", "name", "checkCompilerArguments", "reportError", "reportWarning", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,561:1\n396#1,4:600\n1869#2,2:562\n1761#2,3:564\n1617#2,9:567\n1869#2:576\n1870#2:578\n1626#2:579\n1374#2:580\n1460#2,5:581\n1617#2,9:586\n1869#2:595\n1870#2:597\n1626#2:598\n1761#2,2:604\n1761#2,3:606\n1763#2:609\n1761#2,2:610\n1761#2,3:612\n1763#2:615\n1869#2,2:616\n1#3:577\n1#3:596\n1#3:618\n232#4:599\n*S KotlinDebug\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Companion\n*L\n350#1:600,4\n241#1:562,2\n255#1:564,3\n258#1:567,9\n258#1:576\n258#1:578\n258#1:579\n287#1:580\n287#1:581,5\n319#1:586,9\n319#1:595\n319#1:597\n319#1:598\n365#1:604,2\n369#1:606,3\n365#1:609\n383#1:610,2\n387#1:612,3\n383#1:615\n441#1:616,2\n258#1:577\n319#1:596\n349#1:599\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<FqName, String> getDefaultDiagnosticMessage$frontend(@NotNull OptInDiagnosticMessageProvider messageProvider, @NotNull String verb) {
            Intrinsics.checkNotNullParameter(messageProvider, "messageProvider");
            Intrinsics.checkNotNullParameter(verb, "verb");
            return arg_0 -> Companion.getDefaultDiagnosticMessage$lambda$0(messageProvider, verb, arg_0);
        }

        private final OptInDiagnosticMessageProvider getMessageProvider(boolean subclassesOnly) {
            return subclassesOnly ? (OptInDiagnosticMessageProvider)new OptInInheritanceDiagnosticMessageProvider(true) : (OptInDiagnosticMessageProvider)OptInUsagesDiagnosticMessageProvider.INSTANCE;
        }

        public final void reportNotAllowedOptIns(@NotNull Collection<OptInDescription> descriptions, @NotNull PsiElement element, @NotNull CheckerContext context2) {
            Intrinsics.checkNotNullParameter(descriptions, "descriptions");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(context2, "context");
            this.reportNotAllowedOptIns(descriptions, element, context2.getLanguageVersionSettings(), context2.getTrace(), USAGE_DIAGNOSTICS);
        }

        public final void reportNotAllowedOptIns(@NotNull Collection<OptInDescription> descriptions, @NotNull PsiElement element, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace, @NotNull OptInReporterMultiplexer diagnostics) {
            Intrinsics.checkNotNullParameter(descriptions, "descriptions");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(diagnostics, "diagnostics");
            for (OptInDescription optInDescription : descriptions) {
                OptInDiagnosticReporter optInDiagnosticReporter;
                FqName annotationFqName = optInDescription.component1();
                OptInDescription.Severity severity = optInDescription.component2();
                String message2 = optInDescription.component3();
                boolean subclassesOnly = optInDescription.component4();
                BindingContext bindingContext = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                if (this.isOptInAllowed(element, annotationFqName, languageVersionSettings, bindingContext, subclassesOnly)) continue;
                switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                    case 1: {
                        optInDiagnosticReporter = diagnostics.getWarning().invoke(subclassesOnly);
                        break;
                    }
                    case 2: {
                        optInDiagnosticReporter = diagnostics.getError().invoke(subclassesOnly);
                        break;
                    }
                    case 3: {
                        optInDiagnosticReporter = diagnostics.getFutureError();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                OptInDiagnosticReporter diagnostic = optInDiagnosticReporter;
                diagnostic.report(trace, element, annotationFqName, message2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<OptInDescription> loadOptIns(@NotNull DeclarationDescriptor $this$loadOptIns, @NotNull BindingContext context2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Set<DeclarationDescriptor> visited2, boolean useFutureError, boolean useMarkersFromContainer, boolean fromSupertype) {
            SinceKotlinAccessibility accessibility;
            boolean bl;
            SmartSet result2;
            block15: {
                Object it;
                Intrinsics.checkNotNullParameter($this$loadOptIns, "<this>");
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
                Intrinsics.checkNotNullParameter(visited2, "visited");
                if (!visited2.add($this$loadOptIns)) {
                    return SetsKt.emptySet();
                }
                result2 = SmartSet.Companion.create();
                if ($this$loadOptIns instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)$this$loadOptIns).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                    for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)$this$loadOptIns).getOverriddenDescriptors()) {
                        ClassDescriptor it2;
                        Intrinsics.checkNotNull(callableMemberDescriptor);
                        result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, callableMemberDescriptor, context2, languageVersionSettings, visited2, !languageVersionSettings.supportsFeature(LanguageFeature.OptInContagiousSignatures), false, false, 32, null));
                        if (!useMarkersFromContainer) continue;
                        DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)$this$loadOptIns).getContainingDeclaration();
                        if ((declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null) == null) continue;
                        it2 = it2;
                        boolean bl2 = false;
                        result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, it2, context2, languageVersionSettings, visited2, useFutureError, false, false, 48, null));
                    }
                    return result2;
                }
                for (AnnotationDescriptor annotationDescriptor : $this$loadOptIns.getAnnotations()) {
                    Iterator optInMarker;
                    ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
                    Iterator iterator2 = optInMarker = classDescriptor != null ? org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(this, classDescriptor, useFutureError, false, 2, null) : null;
                    if (optInMarker != null) {
                        org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result2, optInMarker);
                        continue;
                    }
                    if (!fromSupertype) continue;
                    result2.addAll(this.loadSubclassOptInRequired(annotationDescriptor, DescriptorUtilsKt.getModule($this$loadOptIns)));
                }
                if ($this$loadOptIns instanceof CallableDescriptor && !($this$loadOptIns instanceof ClassConstructorDescriptor)) {
                    result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, ((CallableDescriptor)$this$loadOptIns).getReturnType(), context2, languageVersionSettings, visited2, false, 8, null));
                    ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)$this$loadOptIns).getExtensionReceiverParameter();
                    result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null, context2, languageVersionSettings, visited2, false, 8, null));
                }
                if ($this$loadOptIns instanceof FunctionDescriptor) {
                    List<ValueParameterDescriptor> list = ((FunctionDescriptor)$this$loadOptIns).getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
                    Iterable $this$forEach$iv = list;
                    boolean bl2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (ValueParameterDescriptor)element$iv;
                        boolean bl3 = false;
                        result2.addAll(Companion.loadOptIns(it.getType(), context2, languageVersionSettings, visited2, $this$loadOptIns instanceof ConstructorDescriptor));
                    }
                }
                if ($this$loadOptIns instanceof TypeAliasDescriptor) {
                    result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, ((TypeAliasDescriptor)$this$loadOptIns).getExpandedType(), context2, languageVersionSettings, visited2, false, 8, null));
                }
                Iterable $this$any$iv = $this$loadOptIns.getAnnotations();
                boolean bl3 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (AnnotationDescriptor)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(it.getFqName(), OptInNames.INSTANCE.getWAS_EXPERIMENTAL_FQ_NAME())) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl && (accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility($this$loadOptIns, languageVersionSettings)) instanceof SinceKotlinAccessibility.NotAccessibleButWasExperimental) {
                void $this$mapNotNullTo$iv$iv;
                Object element$iv;
                Iterable iterable = ((SinceKotlinAccessibility.NotAccessibleButWasExperimental)accessibility).getMarkerClasses();
                SmartSet smartSet = result2;
                boolean $i$f$mapNotNull = false;
                element$iv = iterable;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    OptInDescription it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                    boolean bl5 = false;
                    ClassDescriptor it = (ClassDescriptor)element$iv$iv;
                    boolean bl6 = false;
                    if (org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(Companion, it, useFutureError, false, 2, null) == null) continue;
                    boolean bl7 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                smartSet.addAll((List)destination$iv$iv);
            }
            DeclarationDescriptor container = $this$loadOptIns.getContainingDeclaration();
            if (useMarkersFromContainer && container instanceof ClassDescriptor && !($this$loadOptIns instanceof ConstructorDescriptor)) {
                result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, container, context2, languageVersionSettings, visited2, useFutureError, false, false, 48, null));
            }
            return result2;
        }

        public static /* synthetic */ Set loadOptIns$default(Companion companion, DeclarationDescriptor declarationDescriptor, BindingContext bindingContext, LanguageVersionSettings languageVersionSettings, Set set, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
            if ((n2 & 4) != 0) {
                set = new LinkedHashSet();
            }
            if ((n2 & 8) != 0) {
                bl = false;
            }
            if ((n2 & 0x10) != 0) {
                bl2 = true;
            }
            if ((n2 & 0x20) != 0) {
                bl3 = false;
            }
            return companion.loadOptIns(declarationDescriptor, bindingContext, languageVersionSettings, set, bl, bl2, bl3);
        }

        /*
         * WARNING - void declaration
         */
        private final Set<OptInDescription> loadOptIns(KotlinType $this$loadOptIns, BindingContext context2, LanguageVersionSettings languageVersionSettings, Set<DeclarationDescriptor> visitedClassifiers, boolean warningsOnly) {
            Set<OptInDescription> set;
            KotlinType kotlinType = $this$loadOptIns;
            if (!(kotlinType != null ? !KotlinTypeKt.isError(kotlinType) : false)) {
                set = SetsKt.emptySet();
            } else if ($this$loadOptIns instanceof AbbreviatedType) {
                Set set2;
                ClassifierDescriptor classifierDescriptor = ((AbbreviatedType)$this$loadOptIns).getAbbreviation().getConstructor().getDeclarationDescriptor();
                if ((classifierDescriptor != null ? org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, classifierDescriptor, context2, languageVersionSettings, visitedClassifiers, warningsOnly || !languageVersionSettings.supportsFeature(LanguageFeature.OptInContagiousSignatures), false, false, 48, null) : (set2 = null)) == null) {
                    set2 = SetsKt.emptySet();
                }
                set = SetsKt.plus(set2, org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, ((AbbreviatedType)$this$loadOptIns).getExpandedType(), context2, languageVersionSettings, visitedClassifiers, false, 8, null));
            } else {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Set set3;
                ClassifierDescriptor classifierDescriptor = $this$loadOptIns.getConstructor().getDeclarationDescriptor();
                if ((classifierDescriptor != null ? org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, classifierDescriptor, context2, languageVersionSettings, visitedClassifiers, warningsOnly || !languageVersionSettings.supportsFeature(LanguageFeature.OptInContagiousSignatures), false, false, 48, null) : (set3 = null)) == null) {
                    set3 = SetsKt.emptySet();
                }
                Iterable iterable = $this$loadOptIns.getArguments();
                Set set4 = set3;
                boolean $i$f$flatMap = false;
                void var8_9 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    TypeProjection it = (TypeProjection)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.isStarProjection() ? SetsKt.emptySet() : org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, it.getType(), context2, languageVersionSettings, visitedClassifiers, false, 8, null);
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                set = SetsKt.plus(set4, (List)destination$iv$iv);
            }
            return set;
        }

        static /* synthetic */ Set loadOptIns$default(Companion companion, KotlinType kotlinType, BindingContext bindingContext, LanguageVersionSettings languageVersionSettings, Set set, boolean bl, int n2, Object object) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            return companion.loadOptIns(kotlinType, bindingContext, languageVersionSettings, set, bl);
        }

        @Nullable
        public final OptInDescription loadOptInForMarkerAnnotation$frontend(@NotNull ClassDescriptor $this$loadOptInForMarkerAnnotation, boolean useFutureError, boolean subclassesOnly) {
            Name name2;
            Intrinsics.checkNotNullParameter($this$loadOptInForMarkerAnnotation, "<this>");
            AnnotationDescriptor annotationDescriptor = $this$loadOptInForMarkerAnnotation.getAnnotations().findAnnotation(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME());
            if (annotationDescriptor == null) {
                return null;
            }
            AnnotationDescriptor optInAnnotationDescriptor = annotationDescriptor;
            Map<Name, ConstantValue<?>> arguments = optInAnnotationDescriptor.getAllValueArguments();
            ConstantValue<?> constantValue = arguments.get(LEVEL);
            EnumValue enumValue = constantValue instanceof EnumValue ? (EnumValue)constantValue : null;
            Name name3 = name2 = enumValue != null ? enumValue.getEnumEntryName() : null;
            OptInDescription.Severity severity = Intrinsics.areEqual(name2, WARNING_LEVEL) ? OptInDescription.Severity.WARNING : (Intrinsics.areEqual(name2, ERROR_LEVEL) ? (useFutureError ? OptInDescription.Severity.FUTURE_ERROR : OptInDescription.Severity.ERROR) : (OptInDescription.Companion.getDEFAULT_SEVERITY() == OptInDescription.Severity.ERROR && useFutureError ? OptInDescription.Severity.FUTURE_ERROR : OptInDescription.Companion.getDEFAULT_SEVERITY()));
            constantValue = arguments.get(MESSAGE);
            StringValue stringValue = constantValue instanceof StringValue ? (StringValue)constantValue : null;
            String message2 = stringValue != null ? (String)stringValue.getValue() : null;
            return new OptInDescription(DescriptorUtilsKt.getFqNameSafe($this$loadOptInForMarkerAnnotation), severity, message2, subclassesOnly);
        }

        public static /* synthetic */ OptInDescription loadOptInForMarkerAnnotation$frontend$default(Companion companion, ClassDescriptor classDescriptor, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            return companion.loadOptInForMarkerAnnotation$frontend(classDescriptor, bl, bl2);
        }

        /*
         * WARNING - void declaration
         */
        private final List<OptInDescription> loadSubclassOptInRequired(AnnotationDescriptor $this$loadSubclassOptInRequired, ModuleDescriptor module2) {
            void $this$mapNotNullTo$iv$iv;
            if (!Intrinsics.areEqual($this$loadSubclassOptInRequired.getFqName(), OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME())) {
                return CollectionsKt.emptyList();
            }
            List<ConstantValue<?>> markerClasses = OptInUsageCheckerUtilsKt.getOptInAnnotationArgs($this$loadSubclassOptInRequired);
            Iterable $this$mapNotNull$iv = markerClasses;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                OptInDescription optInDescription;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ConstantValue constant = (ConstantValue)element$iv$iv;
                boolean bl2 = false;
                KClassValue kClassValue = constant instanceof KClassValue ? (KClassValue)constant : null;
                if (kClassValue == null) {
                    optInDescription = null;
                } else {
                    ClassDescriptor markerDescriptor;
                    KClassValue klass = kClassValue;
                    ClassifierDescriptor classifierDescriptor = klass.getArgumentType(module2).getConstructor().getDeclarationDescriptor();
                    ClassDescriptor classDescriptor = markerDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                    optInDescription = classDescriptor != null ? org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(Companion, classDescriptor, false, true, 1, null) : null;
                }
                if (optInDescription == null) continue;
                OptInDescription it$iv$iv = optInDescription;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final boolean isOptInAllowed(PsiElement $this$isOptInAllowed, FqName annotationFqName, CheckerContext context2, boolean subclassesOnly) {
            LanguageVersionSettings languageVersionSettings = context2.getLanguageVersionSettings();
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            return this.isOptInAllowed($this$isOptInAllowed, annotationFqName, languageVersionSettings, bindingContext, subclassesOnly);
        }

        public final boolean isOptInAllowed(@NotNull PsiElement $this$isOptInAllowed, @NotNull FqName annotationFqName, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter($this$isOptInAllowed, "<this>");
            Intrinsics.checkNotNullParameter(annotationFqName, "annotationFqName");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            return this.isOptInAllowed($this$isOptInAllowed, annotationFqName, languageVersionSettings, bindingContext, false);
        }

        /*
         * Unable to fully structure code
         */
        private final boolean isOptInAllowed(PsiElement $this$isOptInAllowed, FqName annotationFqName, LanguageVersionSettings languageVersionSettings, BindingContext bindingContext, boolean subclassesOnly) {
            if (languageVersionSettings.getFlag(AnalysisFlags.getOptIn()).contains(annotationFqName.asString())) {
                return true;
            }
            if (!subclassesOnly) ** GOTO lbl-1000
            var7_6 = $this$isOptInAllowed;
            strict$iv = true;
            $i$f$getParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtSuperTypeListEntry.class, strict$iv) != null) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            isSubclass = v0;
            $this$getParentOfType$iv = this;
            $this$anyParentMatches$iv = $this$isOptInAllowed;
            $i$f$anyParentMatches = false;
            element$iv = $this$anyParentMatches$iv;
            while (true) {
                element = element$iv;
                $i$a$-anyParentMatches-OptInUsageChecker$Companion$isOptInAllowed$1 = false;
                if (OptInUsageChecker.Companion.isDeclarationAnnotatedWith$frontend(element, annotationFqName, bindingContext) != false || OptInUsageChecker.Companion.isElementAnnotatedWithOptIn(element, annotationFqName, bindingContext) != false || isSubclass != false && OptInUsageChecker.Companion.isElementAnnotatedWithSubclassOptInRequired(element, annotationFqName, bindingContext) != false) {
                    v1 = true;
                    break;
                }
                if (element$iv.getParent() != null) continue;
                v1 = false;
                break;
            }
            return v1;
        }

        public final boolean isDeclarationAnnotatedWith$frontend(@NotNull PsiElement $this$isDeclarationAnnotatedWith, @NotNull FqName annotationFqName, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter($this$isDeclarationAnnotatedWith, "<this>");
            Intrinsics.checkNotNullParameter(annotationFqName, "annotationFqName");
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            if (!($this$isDeclarationAnnotatedWith instanceof KtDeclaration)) {
                return false;
            }
            DeclarationDescriptor descriptor = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, $this$isDeclarationAnnotatedWith);
            return descriptor != null && descriptor.getAnnotations().hasAnnotation(annotationFqName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isElementAnnotatedWithOptIn(PsiElement $this$isElementAnnotatedWithOptIn, FqName annotationFqName, BindingContext bindingContext) {
            boolean bl;
            if (!($this$isElementAnnotatedWithOptIn instanceof KtAnnotated)) return false;
            List<KtAnnotationEntry> list = ((KtAnnotated)$this$isElementAnnotatedWithOptIn).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getAnnotationEntries(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                boolean bl2 = false;
                AnnotationDescriptor descriptor = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
                if (descriptor != null && Intrinsics.areEqual(descriptor.getFqName(), OptInNames.INSTANCE.getOPT_IN_FQ_NAME())) {
                    List<ConstantValue<?>> annotationClasses = OptInUsageCheckerUtilsKt.getOptInAnnotationArgs(descriptor);
                    Iterable $this$any$iv2 = annotationClasses;
                    boolean $i$f$any2 = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl = false;
                        continue;
                    }
                    for (Object element$iv2 : $this$any$iv2) {
                        ConstantValue annotationClass = (ConstantValue)element$iv2;
                        boolean bl3 = false;
                        if (annotationClass instanceof KClassValue) {
                            KClassValue.Value value2 = (KClassValue.Value)((KClassValue)annotationClass).getValue();
                            boolean bl4 = false;
                            if (value2 instanceof KClassValue.Value.NormalClass && Intrinsics.areEqual(((KClassValue.Value.NormalClass)value2).getClassId().asSingleFqName(), annotationFqName) && ((KClassValue.Value.NormalClass)value2).getArrayDimensions() == 0) {
                                return true;
                            }
                            boolean bl5 = false;
                            if (bl5) {
                                return true;
                            }
                        }
                        boolean bl6 = false;
                        if (!bl6) continue;
                        return true;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isElementAnnotatedWithSubclassOptInRequired(PsiElement $this$isElementAnnotatedWithSubclassOptInRequired, FqName annotationFqName, BindingContext bindingContext) {
            boolean bl;
            if (!($this$isElementAnnotatedWithSubclassOptInRequired instanceof KtAnnotated)) return false;
            List<KtAnnotationEntry> list = ((KtAnnotated)$this$isElementAnnotatedWithSubclassOptInRequired).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getAnnotationEntries(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                boolean bl2 = false;
                AnnotationDescriptor descriptor = (AnnotationDescriptor)bindingContext.get(BindingContext.ANNOTATION, entry);
                if (descriptor != null && Intrinsics.areEqual(descriptor.getFqName(), OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME())) {
                    List<ConstantValue<?>> annotationClasses = OptInUsageCheckerUtilsKt.getOptInAnnotationArgs(descriptor);
                    Iterable $this$any$iv2 = annotationClasses;
                    boolean $i$f$any2 = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl = false;
                        continue;
                    }
                    for (Object element$iv2 : $this$any$iv2) {
                        ConstantValue constant = (ConstantValue)element$iv2;
                        boolean bl3 = false;
                        Object t2 = constant.getValue();
                        if (!(t2 instanceof KClassValue.Value.NormalClass)) return false;
                        KClassValue.Value.NormalClass normalClass = (KClassValue.Value.NormalClass)t2;
                        if (normalClass == null) {
                            return false;
                        }
                        KClassValue.Value.NormalClass klass = normalClass;
                        if (Intrinsics.areEqual(klass.getClassId().asSingleFqName(), annotationFqName) && klass.getArrayDimensions() == 0) {
                            return true;
                        }
                        boolean bl4 = false;
                        if (!bl4) continue;
                        return true;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public final void checkCompilerArguments(@NotNull ModuleDescriptor module2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull Function1<? super String, Unit> reportError, @NotNull Function1<? super String, Unit> reportWarning) {
            Intrinsics.checkNotNullParameter(module2, "module");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(reportError, "reportError");
            Intrinsics.checkNotNullParameter(reportWarning, "reportWarning");
            DeprecationResolver deprecationResolver = new DeprecationResolver(new LockBasedStorageManager("OptInUsageChecker"), languageVersionSettings, DeprecationSettings.Default.INSTANCE);
            Iterable $this$forEach$iv = languageVersionSettings.getFlag(AnalysisFlags.getOptIn());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String fqName = (String)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(fqName, OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) continue;
                org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.checkCompilerArguments$checkAnnotation(module2, reportWarning, deprecationResolver, reportError, fqName);
            }
        }

        private static final String getDefaultDiagnosticMessage$lambda$0(OptInDiagnosticMessageProvider $messageProvider, String $verb, FqName fqName) {
            Intrinsics.checkNotNullParameter(fqName, "fqName");
            return $messageProvider.buildDefaultDiagnosticMessage(fqName.asString(), $verb);
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean checkCompilerArguments$checkAnnotation(ModuleDescriptor $module, Function1<? super String, Unit> $reportWarning, DeprecationResolver deprecationResolver, Function1<? super String, Unit> $reportError, String fqName) {
            ClassDescriptor descriptor = DescriptorUtilKt.resolveClassByFqName($module, new FqName(fqName), NoLookupLocation.FOR_NON_TRACKED_SCOPE);
            if (descriptor == null) {
                $reportWarning.invoke("Opt-in requirement marker " + fqName + " is unresolved. Please make sure it's present in the module dependencies");
                return false;
            }
            if (org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(Companion, descriptor, false, false, 3, null) == null) {
                $reportWarning.invoke("Class " + fqName + " is not an opt-in requirement marker");
                return false;
            }
            for (DescriptorBasedDeprecationInfo deprecation : deprecationResolver.getDeprecations(descriptor)) {
                String string;
                String string2;
                Function1<? super String, Unit> report2;
                Function1<? super String, Unit> function1;
                switch (WhenMappings.$EnumSwitchMapping$1[deprecation.getDeprecationLevel().ordinal()]) {
                    case 1: {
                        function1 = $reportWarning;
                        break;
                    }
                    case 2: 
                    case 3: {
                        function1 = $reportError;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Function1<? super String, Unit> function12 = report2 = function1;
                StringBuilder stringBuilder = new StringBuilder().append("Opt-in requirement marker ").append(fqName).append(" is deprecated");
                if (deprecation.getMessage() != null) {
                    void it;
                    StringBuilder stringBuilder2 = stringBuilder;
                    Function1<? super String, Unit> function13 = function12;
                    boolean bl = false;
                    String string3 = ". " + (String)it;
                    function12 = function13;
                    stringBuilder = stringBuilder2;
                    string2 = string3;
                } else {
                    string2 = string = null;
                }
                if (string2 == null) {
                    string = "";
                }
                function12.invoke(stringBuilder.append(string).toString());
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[OptInDescription.Severity.values().length];
                try {
                    nArray[OptInDescription.Severity.WARNING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OptInDescription.Severity.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OptInDescription.Severity.FUTURE_ERROR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[DeprecationLevelValue.values().length];
                try {
                    nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeprecationLevelValue.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J*\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lcom/intellij/psi/PsiElement;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "message", "", "frontend"})
    public static interface OptInDiagnosticReporter {
        public void report(@NotNull BindingTrace var1, @NotNull PsiElement var2, @NotNull FqName var3, @Nullable String var4);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BI\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0004\b\n\u0010\u000bJ*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0016R#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInFactoryBasedReporter;", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/name/FqName;", "", "getCustomMessage", "Lkotlin/Function1;", "getDefaultMessage", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "getGetCustomMessage", "()Lkotlin/jvm/functions/Function1;", "getGetDefaultMessage", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "fqName", "message", "frontend"})
    public static final class OptInFactoryBasedReporter
    implements OptInDiagnosticReporter {
        @NotNull
        private final DiagnosticFactory2<PsiElement, FqName, String> factory;
        @NotNull
        private final Function1<String, String> getCustomMessage;
        @NotNull
        private final Function1<FqName, String> getDefaultMessage;

        public OptInFactoryBasedReporter(@NotNull DiagnosticFactory2<PsiElement, FqName, String> factory, @NotNull Function1<? super String, String> getCustomMessage, @NotNull Function1<? super FqName, String> getDefaultMessage) {
            Intrinsics.checkNotNullParameter(factory, "factory");
            Intrinsics.checkNotNullParameter(getCustomMessage, "getCustomMessage");
            Intrinsics.checkNotNullParameter(getDefaultMessage, "getDefaultMessage");
            this.factory = factory;
            this.getCustomMessage = getCustomMessage;
            this.getDefaultMessage = getDefaultMessage;
        }

        @NotNull
        public final DiagnosticFactory2<PsiElement, FqName, String> getFactory() {
            return this.factory;
        }

        @NotNull
        public final Function1<String, String> getGetCustomMessage() {
            return this.getCustomMessage;
        }

        @NotNull
        public final Function1<FqName, String> getGetDefaultMessage() {
            return this.getDefaultMessage;
        }

        @Override
        public void report(@NotNull BindingTrace trace, @NotNull PsiElement element, @NotNull FqName fqName, @Nullable String message2) {
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(fqName, "fqName");
            CharSequence charSequence = message2;
            String diagnosticMessage = !(charSequence == null || StringsKt.isBlank(charSequence)) ? this.getCustomMessage.invoke(message2) : this.getDefaultMessage.invoke(fqName);
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = this.factory.on(element, fqName, diagnosticMessage);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(trace, parametrizedDiagnostic);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BU\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u0012!\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ$\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J$\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J]\u0010\u0015\u001a\u00020\u00002#\b\u0002\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u00032#\b\u0002\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u00032\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R,\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR,\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInReporterMultiplexer;", "", "warning", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "subclassesOnly", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "error", "futureError", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;)V", "getWarning", "()Lkotlin/jvm/functions/Function1;", "getError", "getFutureError", "()Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "frontend"})
    public static final class OptInReporterMultiplexer {
        @NotNull
        private final Function1<Boolean, OptInDiagnosticReporter> warning;
        @NotNull
        private final Function1<Boolean, OptInDiagnosticReporter> error;
        @NotNull
        private final OptInDiagnosticReporter futureError;

        public OptInReporterMultiplexer(@NotNull Function1<? super Boolean, ? extends OptInDiagnosticReporter> warning, @NotNull Function1<? super Boolean, ? extends OptInDiagnosticReporter> error, @NotNull OptInDiagnosticReporter futureError) {
            Intrinsics.checkNotNullParameter(warning, "warning");
            Intrinsics.checkNotNullParameter(error, "error");
            Intrinsics.checkNotNullParameter(futureError, "futureError");
            this.warning = warning;
            this.error = error;
            this.futureError = futureError;
        }

        @NotNull
        public final Function1<Boolean, OptInDiagnosticReporter> getWarning() {
            return this.warning;
        }

        @NotNull
        public final Function1<Boolean, OptInDiagnosticReporter> getError() {
            return this.error;
        }

        @NotNull
        public final OptInDiagnosticReporter getFutureError() {
            return this.futureError;
        }

        @NotNull
        public final Function1<Boolean, OptInDiagnosticReporter> component1() {
            return this.warning;
        }

        @NotNull
        public final Function1<Boolean, OptInDiagnosticReporter> component2() {
            return this.error;
        }

        @NotNull
        public final OptInDiagnosticReporter component3() {
            return this.futureError;
        }

        @NotNull
        public final OptInReporterMultiplexer copy(@NotNull Function1<? super Boolean, ? extends OptInDiagnosticReporter> warning, @NotNull Function1<? super Boolean, ? extends OptInDiagnosticReporter> error, @NotNull OptInDiagnosticReporter futureError) {
            Intrinsics.checkNotNullParameter(warning, "warning");
            Intrinsics.checkNotNullParameter(error, "error");
            Intrinsics.checkNotNullParameter(futureError, "futureError");
            return new OptInReporterMultiplexer(warning, error, futureError);
        }

        public static /* synthetic */ OptInReporterMultiplexer copy$default(OptInReporterMultiplexer optInReporterMultiplexer, Function1 function1, Function1 function12, OptInDiagnosticReporter optInDiagnosticReporter, int n2, Object object) {
            if ((n2 & 1) != 0) {
                function1 = optInReporterMultiplexer.warning;
            }
            if ((n2 & 2) != 0) {
                function12 = optInReporterMultiplexer.error;
            }
            if ((n2 & 4) != 0) {
                optInDiagnosticReporter = optInReporterMultiplexer.futureError;
            }
            return optInReporterMultiplexer.copy(function1, function12, optInDiagnosticReporter);
        }

        @NotNull
        public String toString() {
            return "OptInReporterMultiplexer(warning=" + this.warning + ", error=" + this.error + ", futureError=" + this.futureError + ')';
        }

        public int hashCode() {
            int result2 = this.warning.hashCode();
            result2 = result2 * 31 + this.error.hashCode();
            result2 = result2 * 31 + this.futureError.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OptInReporterMultiplexer)) {
                return false;
            }
            OptInReporterMultiplexer optInReporterMultiplexer = (OptInReporterMultiplexer)other;
            if (!Intrinsics.areEqual(this.warning, optInReporterMultiplexer.warning)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.error, optInReporterMultiplexer.error)) {
                return false;
            }
            return Intrinsics.areEqual(this.futureError, optInReporterMultiplexer.futureError);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Overrides;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Overrides\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,561:1\n1374#2:562\n1460#2,2:563\n1563#2:565\n1634#2,3:566\n1462#2,3:569\n*S KotlinDebug\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Overrides\n*L\n535#1:562\n535#1:563,2\n537#1:565\n537#1:566,3\n535#1:569,3\n*E\n"})
    public static final class Overrides
    implements DeclarationChecker {
        /*
         * WARNING - void declaration
         */
        @Override
        public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(descriptor, "descriptor");
            Intrinsics.checkNotNullParameter(context2, "context");
            if (!(descriptor instanceof CallableMemberDescriptor)) {
                return;
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
            Iterable $this$flatMap$iv = collection;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                CallableMemberDescriptor overriddenMember = (CallableMemberDescriptor)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(overriddenMember);
                DeclarationDescriptor declarationDescriptor = overriddenMember;
                BindingContext bindingContext = context2.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                Iterable iterable2 = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, declarationDescriptor, bindingContext, context2.getLanguageVersionSettings(), null, false, false, false, 60, null);
                boolean $i$f$map = false;
                void var16_18 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void description;
                    OptInDescription optInDescription = (OptInDescription)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(TuplesKt.to(description, overriddenMember));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Map optInOverriddenDescriptorMap = MapsKt.toMap((List)destination$iv$iv);
            for (Map.Entry entry : optInOverriddenDescriptorMap.entrySet()) {
                Pair<DiagnosticFactory2<PsiElement, FqName, String>, String> pair;
                OptInDescription description = (OptInDescription)entry.getKey();
                CallableMemberDescriptor overriddenMember = (CallableMemberDescriptor)entry.getValue();
                if (Companion.isOptInAllowed(declaration, description.getAnnotationFqName(), context2, description.getSubclassesOnly())) continue;
                PsiElement psiElement = declaration instanceof KtNamedDeclaration ? (KtNamedDeclaration)declaration : null;
                if (psiElement == null || (psiElement = psiElement.getNameIdentifier()) == null) {
                    psiElement = declaration;
                }
                PsiElement reportOn = psiElement;
                switch (WhenMappings.$EnumSwitchMapping$0[description.getSeverity().ordinal()]) {
                    case 1: {
                        pair = TuplesKt.to(Errors.OPT_IN_OVERRIDE, "should");
                        break;
                    }
                    case 2: {
                        pair = TuplesKt.to(Errors.OPT_IN_OVERRIDE_ERROR, "must");
                        break;
                    }
                    case 3: {
                        pair = TuplesKt.to(Errors.OPT_IN_OVERRIDE_ERROR, "must");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Pair<DiagnosticFactory2<PsiElement, FqName, String>, String> pair2 = pair;
                DiagnosticFactory2 diagnostic = (DiagnosticFactory2)pair2.component1();
                String defaultMessageVerb = (String)pair2.component2();
                String string = overriddenMember.getContainingDeclaration().getName().asString();
                Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
                String message2 = OptInNames.INSTANCE.buildOverrideMessage(string, description.getMessage(), defaultMessageVerb, description.getAnnotationFqName().asString());
                context2.getTrace().report(diagnostic.on(reportOn, description.getAnnotationFqName(), message2));
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OptInDescription.Severity.values().length];
                try {
                    nArray[OptInDescription.Severity.WARNING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OptInDescription.Severity.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OptInDescription.Severity.FUTURE_ERROR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

