/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.Calc.NLPSolver.dialogs.controls;

import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseControl {
    protected XComponentContext context;
    private Object unoModel;
    protected Object unoControl;
    private XPropertySet properties;

    public abstract String getName();

    public Object getUnoModel() {
        return this.unoModel;
    }

    protected void setUnoModel(Object object) {
        this.unoModel = object;
        this.properties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
    }

    public void setParentControl(BaseControl baseControl) {
        try {
            String string = this.getName();
            XNameContainer xNameContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)baseControl.unoModel);
            xNameContainer.insertByName(string, this.unoModel);
            XControlContainer xControlContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)baseControl.unoControl);
            this.unoControl = xControlContainer.getControl(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
        }
        catch (ElementExistException elementExistException) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, elementExistException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, wrappedTargetException);
        }
    }

    public BaseControl(XComponentContext xComponentContext) {
        this.context = xComponentContext;
        this.unoModel = null;
        this.unoControl = null;
    }

    protected void setProperty(String string, Object object) {
        try {
            this.properties.setPropertyValue(string, object);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, unknownPropertyException);
        }
        catch (PropertyVetoException propertyVetoException) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, propertyVetoException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, wrappedTargetException);
        }
    }

    protected Object getProperty(String string) {
        try {
            return this.properties.getPropertyValue(string);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, unknownPropertyException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            Logger.getLogger(BaseControl.class.getName()).log(Level.SEVERE, null, wrappedTargetException);
        }
        return null;
    }

    public void setPosition(int n, int n2) {
        this.setProperty("PositionX", n);
        this.setProperty("PositionY", n2);
    }

    public void setSize(int n, int n2) {
        this.setProperty("Width", n);
        this.setProperty("Height", n2);
    }

    public void setEnabled(boolean bl) {
        this.setProperty("Enabled", bl);
    }

    public void setVisible(boolean bl) {
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.unoControl);
        xWindow.setVisible(bl);
    }
}

