/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.files.AbstractExtractArchiveAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.content.CountingInputStream;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarArchiveEntry;
import com.install4j.runtime.installer.helper.content.apache.archivers.tar.TarArchiveInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.GZIPInputStream;

public class ExtractTarFileAction
extends AbstractExtractArchiveAction {
    public static final SymlinkHandler DEFAULT_SYMLINK_HANDLER = UnixFileSystem::createLink;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean extract(Context context, File archiveFile, File destinationDirectory) throws IOException {
        ProgressAdapter progressInterface = new ProgressAdapter(context.getProgressInterface(), 0, 100);
        this.initProgress(progressInterface, 0);
        try {
            ExtractTarFileAction.extractTarFile(archiveFile, destinationDirectory, progressInterface, this.isShowProgress(), this.isShowProgress() && this.isShowFileNames(), tarArchiveEntry -> {
                String entryName = tarArchiveEntry.getName();
                File entryFile = new File(entryName);
                if (ContextImpl.runBooleanScript(context, this.getFileFilter(), this, entryFile, tarArchiveEntry.isDirectory(), tarArchiveEntry.isSymbolicLink())) {
                    return entryName;
                }
                return null;
            }, DEFAULT_SYMLINK_HANDLER);
        }
        finally {
            this.initProgress(progressInterface, 100);
        }
        return true;
    }

    public static void extractTarFile(File archiveFile, File destinationDirectory, final ProgressInterface progressInterface, boolean showProgress, boolean showFileNames, AbstractExtractArchiveAction.TarEntryMapper tarEntryMapper, SymlinkHandler symlinkHandler) throws IOException {
        final long fileLength = archiveFile.length();
        if (fileLength < 2L) {
            throw new IOException("length of " + archiveFile + " < 2");
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(archiveFile, "r");){
            byte[] signature = new byte[2];
            randomAccessFile.readFully(signature);
            randomAccessFile.seek(0L);
            final CountingInputStream countingIn = new CountingInputStream(new BufferedInputStream(new FileInputStream(randomAccessFile.getFD())));
            FileUtil.CopyProgressListener copyProgressListener = null;
            if (showProgress) {
                copyProgressListener = new FileUtil.CopyProgressListener(){
                    long lastProgress = 0L;

                    @Override
                    public boolean progressPerformed(long val) {
                        long newProgress = countingIn.getCount() * 100L / fileLength;
                        if (newProgress > 100L) {
                            newProgress = 100L;
                        }
                        if (newProgress > this.lastProgress) {
                            this.lastProgress = newProgress;
                            progressInterface.setPercentCompleted((int)newProgress);
                        }
                        return true;
                    }
                };
            }
            TarArchiveInputStream in = new TarArchiveInputStream(FileUtil.isGzipStream(signature) ? new GZIPInputStream(countingIn) : countingIn);
            TarArchiveEntry tarEntry = in.getNextTarEntry();
            while (tarEntry != null) {
                String entryName = tarEntry.getName();
                String targetEntryName = tarEntryMapper.mapEntry(tarEntry);
                if (targetEntryName != null) {
                    File destFile = new File(destinationDirectory, targetEntryName);
                    if (showFileNames) {
                        progressInterface.setDetailMessage(InstallerUtil.cleanupName(entryName));
                    }
                    if (tarEntry.isSymbolicLink()) {
                        symlinkHandler.handle(tarEntry.getLinkName(), destFile);
                    } else if (tarEntry.isDirectory()) {
                        destFile.mkdirs();
                    } else {
                        destFile.getParentFile().mkdirs();
                        FileUtil.extractFile(in, destFile, tarEntry.getSize(), copyProgressListener, false);
                    }
                    destFile.setLastModified(tarEntry.getModTime().getTime());
                    UnixFileSystem.setMode(tarEntry.getMode(), destFile);
                }
                tarEntry = in.getNextTarEntry();
            }
            in.close();
        }
    }

    public static interface SymlinkHandler {
        public void handle(String var1, File var2) throws IOException;
    }
}

