/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.launching;

import com.install4j.runtime.installer.helper.launching.InputRedirectionMode;
import com.install4j.runtime.installer.helper.launching.Redirection;
import java.io.File;
import java.util.Objects;

public class InputRedirection
extends Redirection {
    private static final String DEV_STDIN = "/dev/stdin";
    public static final InputRedirection LEGACY_STDIN_REDIRECTION = new InputRedirection(InputRedirectionMode.FILE, "", new File("/dev/stdin"), false);
    public static final InputRedirection INHERIT_REDIRECTION = new InputRedirection(InputRedirectionMode.INHERIT, "", null, false);
    public static final InputRedirection NO_REDIRECTION = new InputRedirection(InputRedirectionMode.NONE, "", null, false);
    private InputRedirectionMode redirectionMode;
    private String string;

    public InputRedirection(InputRedirectionMode redirectionMode, String string, File file, boolean failOnFileError) {
        super(file, failOnFileError);
        this.redirectionMode = redirectionMode;
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public InputRedirectionMode getRedirectionMode() {
        return this.redirectionMode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append((Object)this.redirectionMode);
        if (this.redirectionMode == InputRedirectionMode.FILE) {
            buffer.append("[file: ").append(this.getFile()).append(", failOnError: ").append(this.isFailOnFileError());
        } else if (this.redirectionMode == InputRedirectionMode.STRING) {
            buffer.append("[string: ").append(this.string);
        }
        return buffer.toString();
    }

    public boolean isStdInFile() {
        return this.redirectionMode == InputRedirectionMode.FILE && this.getFile() != null && Objects.equals(this.getFile().getPath().replace('\\', '/'), DEV_STDIN);
    }
}

