/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos.macho;

import com.install4j.runtime.installer.platform.macos.macho.Header;
import com.install4j.runtime.installer.platform.macos.macho.LinkDataCommand;
import com.install4j.runtime.installer.platform.macos.macho.LoadCommand;
import com.install4j.runtime.installer.platform.macos.macho.MachoCpuType;
import com.install4j.runtime.installer.platform.macos.macho.Part;
import com.install4j.runtime.installer.platform.macos.macho.Segment64Command;
import com.install4j.runtime.installer.platform.macos.macho.SegmentCommand;
import com.install4j.runtime.installer.platform.macos.macho.SymtabCommand;
import com.install4j.runtime.installer.platform.macos.macho.VersionCommand;
import com.install4j.runtime.util.BinaryUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MachoFile
implements Part {
    private static int MH_MAGIC = -17958194;
    private static int MH_CIGAM = -822415874;
    private static int MH_MAGIC_64 = -17958193;
    private static int MH_CIGAM_64 = -805638658;
    private static String LINK_EDIT_SEGMENT_NAME = "__LINKEDIT";
    private int magic;
    private Header header;
    private List<LoadCommand> loadCommands = new ArrayList<LoadCommand>();
    private ByteBuffer byteBuffer;

    public MachoFile(@NotNull ByteBuffer data) throws IOException {
        this.byteBuffer = data;
        this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
        this.magic = this.byteBuffer.getInt();
        if (!MachoFile.isThinMagic(this.magic)) {
            throw new NoMachoException();
        }
        if (!this.isBigEndian()) {
            this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.read(this.byteBuffer, this.is64Bit());
    }

    public boolean isExecutable() {
        return this.header.isExecutable();
    }

    static boolean isThinMagic(int magic) {
        return magic == MH_MAGIC || magic == MH_CIGAM || magic == MH_MAGIC_64 || magic == MH_CIGAM_64;
    }

    public void growLinkSegment(int size) throws IOException {
        for (LoadCommand loadCommand : this.loadCommands) {
            SegmentCommand segmentCommand;
            if (!(loadCommand.getContent() instanceof SegmentCommand) || !(segmentCommand = (SegmentCommand)loadCommand.getContent()).getSegmentName().equals(LINK_EDIT_SEGMENT_NAME)) continue;
            long newFileSize = segmentCommand.getFilesize() + (long)size;
            segmentCommand.setFilesize(newFileSize);
            segmentCommand.setVmsize(Math.max(segmentCommand.getVmsize(), MachoFile.alignVmSize(newFileSize)));
            return;
        }
    }

    private static long alignVmSize(long size) {
        return BinaryUtil.align(size, 4096L);
    }

    public boolean is64Bit() {
        return this.magic == MH_MAGIC_64 || this.magic == MH_CIGAM_64;
    }

    public boolean isBigEndian() {
        return this.magic == MH_MAGIC_64 || this.magic == MH_MAGIC;
    }

    @Override
    public void read(ByteBuffer buf, boolean bit64) throws IOException {
        this.header = new Header();
        this.header.read(buf, bit64);
        for (int i = 0; i < this.header.getNcmds(); ++i) {
            LoadCommand loadCommand = new LoadCommand();
            loadCommand.read(buf, bit64);
            this.loadCommands.add(loadCommand);
        }
    }

    @Override
    public void write(ByteBuffer buf, boolean bit64) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void appendOrReplaceLoadCommand(LoadCommand loadCommand) throws IOException {
        this.removeLoadCommand(loadCommand.getCmd());
        this.loadCommands.add(loadCommand);
    }

    public void removeLoadCommand(int cmd) throws IOException {
        this.loadCommands.removeIf(loadCommand -> loadCommand.getCmd() == cmd);
    }

    public void removeSignature() throws IOException {
        this.shrinkForSignatureRemoval();
        this.removeLoadCommand(29);
    }

    private void shrinkForSignatureRemoval() {
        long diffSize;
        long linkEditSize;
        int codeSignatureSize;
        LinkDataCommand codeSignatureCommand = null;
        SegmentCommand linkEditCommand = null;
        SymtabCommand symtabCommand = null;
        block5: for (int commandIndex = 0; commandIndex < this.loadCommands.size(); ++commandIndex) {
            LoadCommand loadCommand = this.loadCommands.get(commandIndex);
            switch (loadCommand.getCmd()) {
                case 29: {
                    if (commandIndex != this.loadCommands.size() - 1) continue block5;
                    codeSignatureCommand = (LinkDataCommand)loadCommand.getContent();
                    continue block5;
                }
                case 1: 
                case 25: {
                    SegmentCommand segmentCommand = (SegmentCommand)loadCommand.getContent();
                    if (!"__LINKEDIT".equals(segmentCommand.getSegmentName())) continue block5;
                    linkEditCommand = segmentCommand;
                    continue block5;
                }
                case 2: {
                    symtabCommand = (SymtabCommand)loadCommand.getContent();
                }
            }
        }
        if (codeSignatureCommand == null || linkEditCommand == null) {
            return;
        }
        int codeSignatureOffset = codeSignatureCommand.getOffset();
        if (codeSignatureOffset + (codeSignatureSize = codeSignatureCommand.getSize()) != this.byteBuffer.limit()) {
            return;
        }
        long linkEditOffset = linkEditCommand.getFileoff();
        if (linkEditOffset + (linkEditSize = linkEditCommand.getFilesize()) != (long)this.byteBuffer.limit()) {
            return;
        }
        int sizeReduction = codeSignatureSize;
        if (symtabCommand != null && 0L <= (diffSize = (long)(this.byteBuffer.limit() - sizeReduction - (symtabCommand.getStroff() + symtabCommand.getStrsize()))) && diffSize <= 16L) {
            sizeReduction = (int)((long)sizeReduction + diffSize);
        }
        this.setLength(this.byteBuffer.limit() - sizeReduction);
        linkEditCommand.setFilesize(linkEditCommand.getFilesize() - (long)sizeReduction);
        linkEditCommand.setVmsize(MachoFile.alignVmSize(linkEditCommand.getFilesize()));
    }

    public void writeHeaderAndCommands() throws IOException {
        this.header.updateHeader(this.loadCommands);
        this.byteBuffer.position(4);
        this.header.write(this.byteBuffer, this.is64Bit());
        for (LoadCommand loadCommand : this.loadCommands) {
            loadCommand.write(this.byteBuffer, this.is64Bit());
        }
    }

    public void position(int pos) {
        this.byteBuffer.position(pos);
    }

    public void write(byte[] bytes) {
        this.byteBuffer.put(bytes);
    }

    public void setLength(int length) {
        if (this.byteBuffer.capacity() >= length) {
            this.byteBuffer.limit(length);
        } else {
            int pos = this.byteBuffer.position();
            ByteBuffer newBuffer = ByteBuffer.allocate(length);
            newBuffer.order(this.byteBuffer.order());
            newBuffer.put((ByteBuffer)this.byteBuffer.position(0));
            this.byteBuffer = newBuffer;
            this.byteBuffer.position(pos);
        }
    }

    public ByteBuffer getData() {
        return (ByteBuffer)this.byteBuffer.duplicate().position(0);
    }

    public void setMinimumSdkVersion(int version) throws IOException {
        for (LoadCommand loadCommand : this.loadCommands) {
            VersionCommand versionCommand;
            if (!(loadCommand.getContent() instanceof VersionCommand) || (versionCommand = (VersionCommand)loadCommand.getContent()).getSdk() >= version) continue;
            versionCommand.setSdk(version);
            versionCommand.write(this.byteBuffer, this.is64Bit());
        }
    }

    public MachoCpuType getMachoCpuType() {
        return this.header.getMachoCpuType();
    }

    public int getCpuType() {
        return this.header.getCpuType();
    }

    public int getCpuSubType() {
        return this.header.getCpuSubType();
    }

    public void changeInfoPlist(byte[] bytes) {
        for (LoadCommand loadCommand : this.loadCommands) {
            Segment64Command segmentCommand;
            Segment64Command.Section64 section64;
            if (!(loadCommand.getContent() instanceof Segment64Command) || (section64 = (segmentCommand = (Segment64Command)loadCommand.getContent()).findTextSection("__info_plist")) == null) continue;
            int previousLength = (int)section64.getSize();
            if (previousLength != bytes.length) {
                throw new IllegalArgumentException("embedded plist must be of the same length: " + previousLength + " != " + bytes.length);
            }
            ByteBuffer data = this.getData();
            data.position(section64.getOffset());
            data.put(bytes);
        }
    }

    public byte[] getInfoPlist() {
        for (LoadCommand loadCommand : this.loadCommands) {
            int length;
            Segment64Command segmentCommand;
            Segment64Command.Section64 section64;
            if (!(loadCommand.getContent() instanceof Segment64Command) || (section64 = (segmentCommand = (Segment64Command)loadCommand.getContent()).findTextSection("__info_plist")) == null || (length = (int)section64.getSize()) <= 0) continue;
            byte[] ret = new byte[length];
            ByteBuffer data = this.getData();
            data.position(section64.getOffset());
            data.get(ret);
            return ret;
        }
        return null;
    }

    public static class NoMachoException
    extends IOException {
        public NoMachoException(File file) {
            super("no macho file: " + file);
        }

        public NoMachoException() {
            super("no macho file");
        }
    }
}

