/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration;

import com.install4j.api.Util;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import com.install4j.runtime.launcher.integration.UpdateLog;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class LockFile {
    private static final String INIT_LOCK_NAME = "init.lck";
    private static final String INSTALLER_LOCK_NAME = "installer.lck";
    private static final String PROPNAME_LOCK_FILE = "install4j.lockFile";
    private static final String PROPNAME_TIMEOUT = "install4j.lockFileTimeout";

    public static void deleteShutdownLockFile() {
        String lockFileName = System.getProperty(PROPNAME_LOCK_FILE);
        if (lockFileName != null) {
            UpdateLog.log(20, "deleting shutdown lock file " + lockFileName);
            new File(lockFileName).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForShutdownLockFile() {
        File lockFile;
        String lockFileName = System.getProperty(PROPNAME_LOCK_FILE);
        if (lockFileName != null && (lockFile = new File(lockFileName)).isFile()) {
            UpdateLog.log(5, "waiting for shutdown lock " + lockFile);
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(lockFile, "rw");){
                int maxTryCount = Integer.getInteger(PROPNAME_TIMEOUT, 120) * 2;
                int tryCount = 0;
                FileLock fileLock = randomAccessFile.getChannel().tryLock();
                while (fileLock == null) {
                    if (tryCount++ == maxTryCount) {
                        Util.showMessage(Messages.getString(".NoTerminationUpdaterInvocationError"), 0);
                        System.exit(1);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    fileLock = randomAccessFile.getChannel().tryLock();
                }
                fileLock.release();
            }
            catch (IOException e) {
                UpdateLog.log(e);
            }
            finally {
                if (!lockFile.delete() && lockFile.isFile()) {
                    lockFile.deleteOnExit();
                }
            }
            UpdateLog.log(5, "shutdown lock " + lockFile + " released");
        }
    }

    private static String createShutdownLockFile() {
        try {
            File file = File.createTempFile("lock", ".tmp", AutomaticUpdate.getUpdateDir());
            new RandomAccessFile(file, "rw").getChannel().lock();
            UpdateLog.log(5, "created shutdown lock " + file);
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            UpdateLog.log(e);
            e.printStackTrace();
            return null;
        }
    }

    static void addShutdownLockFile(List<String> arguments) {
        String lockFileName = LockFile.createShutdownLockFile();
        if (lockFileName != null) {
            arguments.add("-Dinstall4j.lockFile=" + lockFileName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitForInstallerLock(Process installerProcess) {
        UpdateLog.log(5, "waiting for installer lock " + installerProcess);
        int tryCount = 0;
        while (true) {
            if (tryCount >= 1500) {
                UpdateLog.log(5, "waiting for installer lock timed out");
                return false;
            }
            File file = new File(AutomaticUpdate.getUpdateDir(), INSTALLER_LOCK_NAME);
            if (file.isFile()) {
                try (RandomAccessFile raFile = new RandomAccessFile(file, "r");
                     FileLock fileLock = raFile.getChannel().tryLock(0L, Long.MAX_VALUE, true);){
                    if (fileLock == null) {
                        UpdateLog.log(10, "installer lock was acquired. Continuing. (alive: " + installerProcess.isAlive() + ")");
                        boolean bl = true;
                        return bl;
                    }
                    if (tryCount == 0) {
                        UpdateLog.log(10, "installer lock not yet acquired. Waiting. (alive: " + installerProcess.isAlive() + ")");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!installerProcess.isAlive()) {
                UpdateLog.log(5, "installer process terminated before installer lock was acquired");
                return false;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++tryCount;
        }
    }

    public static void createInstallerLock() {
        RandomAccessFile raFile = null;
        Throwable lastException = null;
        for (int tryCount = 0; tryCount < 40; ++tryCount) {
            if (raFile != null) {
                try {
                    raFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                AutomaticUpdate.getUpdateDir().mkdirs();
                File file = new File(AutomaticUpdate.getUpdateDir(), INSTALLER_LOCK_NAME);
                UpdateLog.log(20, "creating installer lock file " + file);
                raFile = new RandomAccessFile(file, "rw");
                FileLock fileLock = raFile.getChannel().lock(0L, Long.MAX_VALUE, false);
                if (fileLock != null) {
                    UpdateLog.log(20, "locked " + file);
                    return;
                }
                Thread.sleep(100L);
                continue;
            }
            catch (Throwable e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            UpdateLog.log(lastException);
            Logger.getInstance().log(lastException);
        }
    }

    @Nullable
    public static Closeable tryInitLock() {
        try {
            return new InitLock(new File(AutomaticUpdate.getUpdateDir(), INIT_LOCK_NAME));
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class InitLock
    implements Closeable {
        private final RandomAccessFile raFile;
        private final FileLock lock;

        public InitLock(File file) throws IOException {
            file.getParentFile().mkdirs();
            this.raFile = new RandomAccessFile(file, "rw");
            this.lock = this.raFile.getChannel().tryLock(0L, Long.MAX_VALUE, false);
            if (this.lock == null) {
                throw new IOException("lock not acquired");
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.lock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.raFile.close();
        }
    }
}

