/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LineIterator
implements Iterator<String>,
Closeable {
    private BufferedReader bufferedReader;
    private String cachedLine;
    private boolean finished = false;

    public LineIterator(Reader reader) throws IllegalArgumentException {
        this.bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    @Override
    public boolean hasNext() {
        if (this.cachedLine != null) {
            return true;
        }
        if (this.finished) {
            return false;
        }
        try {
            String line = this.bufferedReader.readLine();
            if (line == null) {
                this.finished = true;
                return false;
            }
            this.cachedLine = line;
            return true;
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String currentLine = this.cachedLine;
        this.cachedLine = null;
        return currentLine;
    }

    @Override
    public void close() throws IOException {
        this.finished = true;
        this.bufferedReader.close();
        this.cachedLine = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

