/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.basic.Resource;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.PartialLineBorder;
import com.jidesoft.swing.TabColorProvider;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicJideTabbedPaneUI
extends JideTabbedPaneUI
implements SwingConstants,
DocumentListener {
    protected int _tabRectPadding;
    protected int _closeButtonMarginHorizon;
    protected int _closeButtonMarginVertical;
    protected int _textMarginVertical;
    protected int _noIconMargin;
    protected int _iconMargin;
    protected int _textPadding;
    protected int _buttonSize;
    protected int _buttonMargin;
    protected int _fitStyleBoundSize;
    protected int _fitStyleFirstTabMargin;
    protected int _fitStyleIconMinWidth;
    protected int _fitStyleTextMinWidth;
    protected int _compressedStyleNoIconRectSize;
    protected int _compressedStyleIconMargin;
    protected int _compressedStyleCloseButtonMarginHorizon;
    protected int _compressedStyleCloseButtonMarginVertical;
    protected int _fixedStyleRectSize;
    protected int _closeButtonMargin;
    protected int _gripLeftMargin;
    protected int _closeButtonMarginSize;
    protected int _closeButtonLeftMargin;
    protected int _closeButtonRightMargin;
    protected Component _tabLeadingComponent = null;
    protected Component _tabTrailingComponent = null;
    protected JideTabbedPane _tabPane;
    protected Font _selectedTabFont;
    protected Color _tabBackground;
    protected Color _background;
    protected Color _highlight;
    protected Color _lightHighlight;
    protected Color _shadow;
    protected Color _darkShadow;
    protected Color _focus;
    protected Color _inactiveTabForeground;
    protected Color _inactiveSelectedTabForeground;
    protected Color _activeTabForeground;
    protected Color _tabListBackground;
    protected Color _selectedColor;
    protected Color _activeBackground;
    protected int _textIconGap;
    protected int _tabRunOverlay;
    protected boolean _showIconOnTab;
    protected boolean _showCloseButtonOnTab;
    protected int _closeButtonAlignment = 11;
    protected Insets _tabInsets;
    protected Insets _selectedTabPadInsets;
    protected Insets _tabAreaInsets;
    protected boolean _ignoreContentBorderInsetsIfNoTabs;
    protected int[] _tabRuns = new int[10];
    protected int _runCount = 0;
    protected int _selectedRun = -1;
    protected Rectangle[] _rects = new Rectangle[0];
    protected int _additionalWidth = 0;
    protected int _maxTabHeight;
    protected int _maxTabWidth;
    protected int _gripperWidth = 6;
    protected int _gripperHeight = 6;
    protected ChangeListener _tabChangeListener;
    protected FocusListener _tabFocusListener;
    protected PropertyChangeListener _propertyChangeListener;
    protected ChangeListener _tabModelChangeListener;
    protected MouseListener _mouseListener;
    protected MouseMotionListener _mousemotionListener;
    protected MouseWheelListener _mouseWheelListener;
    private ContainerListener _containerListener;
    private ComponentListener _componentListener;
    private Insets _currentTabInsets = new Insets(0, 0, 0, 0);
    private Insets _currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets _currentTabAreaInsets = new Insets(2, 4, 0, 4);
    private Insets _currentContentBorderInsets = new Insets(3, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;
    private Hashtable _mnemonicToIndexMap;
    private InputMap _mnemonicInputMap;
    public ScrollableTabSupport _tabScroller;
    protected transient Rectangle _calcRect = new Rectangle(0, 0, 0, 0);
    protected int _tabCount;
    protected JButton[] _closeButtons;
    private ThemePainter _painter;
    private Painter _gripperPainter;
    private DropTargetListener _dropListener;
    private boolean _layouted;
    public DropTarget _dt;
    public static final int DEFAULT_LEFT_MARGIN = 0;
    public static final int OFFICE2003_LEFT_MARGIN = 18;
    public static final int EXCEL_LEFT_MARGIN = 6;
    protected int _rectSizeExtend = 0;
    protected Polygon tabRegion = null;
    protected Color _selectColor1 = null;
    protected Color _selectColor2 = null;
    protected Color _selectColor3 = null;
    protected Color _unselectColor1 = null;
    protected Color _unselectColor2 = null;
    protected Color _unselectColor3 = null;
    protected Color _officeTabBorderColor;
    protected Color _defaultTabBorderShadowColor;
    protected boolean _mouseEnter = false;
    protected int _indexMouseOver;
    protected boolean _alwaysShowLineBorder = false;
    protected boolean _showFocusIndicator = false;
    private TabContainer _tabContainer;
    public static final String BUTTON_NAME_CLOSE = "JideTabbedPane.close";
    public static final String BUTTON_NAME_TAB_LIST = "JideTabbedPane.showList";
    public static final String BUTTON_NAME_SCROLL_BACKWARD = "JideTabbedPane.scrollBackward";
    public static final String BUTTON_NAME_SCROLL_FORWARD = "JideTabbedPane.scrollForward";
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;
    protected TabSpaceAllocator tryTabSpacer = new TabSpaceAllocator();
    protected Color _closeButtonSelectedColor = new Color(255, 162, 165);
    protected Color _closeButtonColor = Color.BLACK;
    protected Color _popupColor = Color.BLACK;
    protected TabEditor _tabEditor;
    protected boolean _isEditing;
    protected int _editingTab = -1;
    protected String _oldValue;
    protected String _oldPrefix;
    protected String _oldPostfix;
    protected Component _originalFocusComponent;
    protected final boolean PAINT_TAB = true;
    protected final boolean PAINT_TAB_BORDER = true;
    protected final boolean PAINT_TAB_BACKGROUND = true;
    protected final boolean PAINT_TABAREA = true;
    protected final boolean PAINT_CONTENT_BORDER = true;
    protected final boolean PAINT_CONTENT_BORDER_EDGE = true;

    public static ComponentUI createUI(JComponent c) {
        return new BasicJideTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        if (c == null) {
            return;
        }
        this._tabPane = (JideTabbedPane)c;
        if (this._tabPane.isTabShown() && this._tabPane.getTabLeadingComponent() != null) {
            this._tabLeadingComponent = this._tabPane.getTabLeadingComponent();
        }
        if (this._tabPane.isTabShown() && this._tabPane.getTabTrailingComponent() != null) {
            this._tabTrailingComponent = this._tabPane.getTabTrailingComponent();
        }
        this.setMouseOverTabIndex(-1);
        c.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installColorTheme();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void installColorTheme() {
        switch (this.getTabShape()) {
            case 8: {
                this._selectColor1 = this._darkShadow;
                this._selectColor2 = this._lightHighlight;
                this._selectColor3 = this._shadow;
                this._unselectColor1 = this._darkShadow;
                this._unselectColor2 = this._lightHighlight;
                this._unselectColor3 = this._shadow;
                break;
            }
            case 1: 
            case 11: {
                this._selectColor1 = this._lightHighlight;
                this._selectColor2 = this._shadow;
                this._selectColor3 = this._defaultTabBorderShadowColor;
                this._unselectColor1 = this._selectColor1;
                this._unselectColor2 = this._selectColor2;
                this._unselectColor3 = this._selectColor3;
                break;
            }
            case 2: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._shadow;
                this._unselectColor1 = this._selectColor1;
                break;
            }
            case 9: {
                this._selectColor2 = this._selectColor1 = this._shadow;
                this._unselectColor1 = this._selectColor1;
                break;
            }
            case 5: {
                this._unselectColor1 = this._selectColor1 = this._shadow;
                break;
            }
            case 10: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._shadow;
                this._unselectColor1 = this._selectColor1;
                this._unselectColor2 = this._selectColor2;
                break;
            }
            case 3: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._lightHighlight;
                this._unselectColor1 = this.getPainter().getControlShadow();
                this._unselectColor2 = this._lightHighlight;
                break;
            }
            default: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._lightHighlight;
                this._unselectColor1 = this._shadow;
                this._unselectColor2 = null;
                this._unselectColor3 = null;
            }
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallColorTheme();
        this.uninstallDefaults();
        this.uninstallComponents();
        c.setLayout(null);
        this._tabTrailingComponent = null;
        this._tabLeadingComponent = null;
        this._tabPane = null;
    }

    public void uninstallColorTheme() {
        this._selectColor1 = null;
        this._selectColor2 = null;
        this._selectColor3 = null;
        this._unselectColor1 = null;
        this._unselectColor2 = null;
        this._unselectColor3 = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this._tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    protected boolean scrollableTabLayoutEnabled() {
        return this._tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this._tabScroller == null) {
            this._tabScroller = new ScrollableTabSupport(this._tabPane.getTabPlacement());
            this._tabPane.add(this._tabScroller.viewport);
            this._tabPane.add(this._tabScroller.scrollForwardButton);
            this._tabPane.add(this._tabScroller.scrollBackwardButton);
            this._tabPane.add(this._tabScroller.listButton);
            this._tabPane.add(this._tabScroller.closeButton);
            if (this._tabLeadingComponent != null) {
                this._tabPane.add(this._tabLeadingComponent);
            }
            if (this._tabTrailingComponent != null) {
                this._tabPane.add(this._tabTrailingComponent);
            }
        }
        this.installTabContainer();
    }

    private void installTabContainer() {
        for (int i = 0; i < this._tabPane.getTabCount(); ++i) {
            Component tabComponent;
            Component component = tabComponent = SystemInfo.isJdk6Above() ? this._tabPane.getTabComponentAt(i) : null;
            if (tabComponent == null) continue;
            if (this._tabContainer == null) {
                this._tabContainer = new TabContainer();
            }
            this._tabContainer.add(tabComponent);
        }
        if (this._tabContainer == null) {
            return;
        }
        if (this.scrollableTabLayoutEnabled()) {
            this._tabScroller.tabPanel.add(this._tabContainer);
        } else {
            this._tabPane.add(this._tabContainer);
        }
    }

    protected void uninstallComponents() {
        this.uninstallTabContainer();
        if (this.scrollableTabLayoutEnabled()) {
            this._tabPane.remove(this._tabScroller.viewport);
            this._tabPane.remove(this._tabScroller.scrollForwardButton);
            this._tabPane.remove(this._tabScroller.scrollBackwardButton);
            this._tabPane.remove(this._tabScroller.listButton);
            this._tabPane.remove(this._tabScroller.closeButton);
            if (this._tabLeadingComponent != null) {
                this._tabPane.remove(this._tabLeadingComponent);
            }
            if (this._tabTrailingComponent != null) {
                this._tabPane.remove(this._tabTrailingComponent);
            }
            this._tabScroller = null;
        }
    }

    private void uninstallTabContainer() {
        if (this._tabContainer == null) {
            return;
        }
        this._tabContainer.notifyTabbedPane = false;
        this._tabContainer.removeAll();
        if (this.scrollableTabLayoutEnabled()) {
            this._tabScroller.tabPanel.remove(this._tabContainer);
        } else {
            this._tabPane.remove(this._tabContainer);
        }
        this._tabContainer = null;
    }

    protected void installDefaults() {
        Insets insets;
        Insets tabAreaInsets;
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideTabbedPane.gripperPainter");
        LookAndFeel.installColorsAndFont(this._tabPane, "JideTabbedPane.background", "JideTabbedPane.foreground", "JideTabbedPane.font");
        LookAndFeel.installBorder(this._tabPane, "JideTabbedPane.border");
        this._selectedTabFont = UIDefaultsLookup.getFont("JideTabbedPane.selectedTabFont");
        this._highlight = UIDefaultsLookup.getColor("JideTabbedPane.light");
        this._lightHighlight = UIDefaultsLookup.getColor("JideTabbedPane.highlight");
        this._shadow = UIDefaultsLookup.getColor("JideTabbedPane.shadow");
        this._darkShadow = UIDefaultsLookup.getColor("JideTabbedPane.darkShadow");
        this._focus = UIDefaultsLookup.getColor("TabbedPane.focus");
        if (this.getTabShape() == 3) {
            this._background = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground");
            this._tabBackground = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground");
            this._inactiveTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.foreground");
            this._inactiveSelectedTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.foreground");
            this._activeTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.foreground");
            this._selectedColor = this._lightHighlight;
            this._activeBackground = this._lightHighlight;
        } else {
            this._background = UIDefaultsLookup.getColor("JideTabbedPane.background");
            this._tabBackground = UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackground");
            this._inactiveTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.unselectedTabTextForeground");
            this._inactiveSelectedTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabTextForeground");
            this._activeTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.activeTabTextForeground");
            if (this._activeTabForeground == null) {
                this._activeTabForeground = this._inactiveSelectedTabForeground;
            }
            this._selectedColor = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground");
            this._activeBackground = UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground");
            if (this._activeBackground == null) {
                this._activeBackground = UIDefaultsLookup.getColor("JideTabbedPane.activeTabBackground");
            }
            if (this._activeBackground == null) {
                this._activeBackground = this._selectedColor;
            }
        }
        this._tabListBackground = UIDefaultsLookup.getColor("JideTabbedPane.tabListBackground");
        this._textIconGap = UIDefaultsLookup.getInt("JideTabbedPane.textIconGap");
        Insets tabInsets = this._tabPane.getTabInsets();
        if (tabInsets == null || tabInsets instanceof UIResource) {
            this._tabPane.setTabInsets(UIDefaultsLookup.getInsets("JideTabbedPane.tabInsets"));
        }
        this._selectedTabPadInsets = UIDefaultsLookup.getInsets("TabbedPane.selectedTabPadInsets");
        if (this._selectedTabPadInsets == null) {
            this._selectedTabPadInsets = new InsetsUIResource(0, 0, 0, 0);
        }
        if ((tabAreaInsets = this._tabPane.getTabAreaInsets()) == null || tabAreaInsets instanceof UIResource) {
            this._tabPane.setTabAreaInsets(UIDefaultsLookup.getInsets("JideTabbedPane.tabAreaInsets"));
        }
        if ((insets = this._tabPane.getContentBorderInsets()) == null || insets instanceof UIResource) {
            this._tabPane.setContentBorderInsets(UIDefaultsLookup.getInsets("JideTabbedPane.contentBorderInsets"));
        }
        this._ignoreContentBorderInsetsIfNoTabs = UIDefaultsLookup.getBoolean("JideTabbedPane.ignoreContentBorderInsetsIfNoTabs");
        this._tabRunOverlay = UIDefaultsLookup.getInt("JideTabbedPane.tabRunOverlay");
        this._showIconOnTab = UIDefaultsLookup.getBoolean("JideTabbedPane.showIconOnTab");
        this._showCloseButtonOnTab = UIDefaultsLookup.getBoolean("JideTabbedPane.showCloseButtonOnTab");
        this._closeButtonAlignment = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonAlignment");
        this._gripperWidth = UIDefaultsLookup.getInt("Gripper.size");
        this._tabRectPadding = UIDefaultsLookup.getInt("JideTabbedPane.tabRectPadding");
        this._closeButtonMarginHorizon = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginHorizonal");
        this._closeButtonMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginVertical");
        this._textMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.textMarginVertical");
        this._noIconMargin = UIDefaultsLookup.getInt("JideTabbedPane.noIconMargin");
        this._iconMargin = UIDefaultsLookup.getInt("JideTabbedPane.iconMargin");
        this._textPadding = UIDefaultsLookup.getInt("JideTabbedPane.textPadding");
        this._buttonSize = UIDefaultsLookup.getInt("JideTabbedPane.buttonSize");
        this._buttonMargin = UIDefaultsLookup.getInt("JideTabbedPane.buttonMargin");
        this._fitStyleBoundSize = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleBoundSize");
        this._fitStyleFirstTabMargin = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleFirstTabMargin");
        this._fitStyleIconMinWidth = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleIconMinWidth");
        this._fitStyleTextMinWidth = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleTextMinWidth");
        this._compressedStyleNoIconRectSize = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleNoIconRectSize");
        this._compressedStyleIconMargin = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleIconMargin");
        this._compressedStyleCloseButtonMarginHorizon = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleCloseButtonMarginHorizontal");
        this._compressedStyleCloseButtonMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleCloseButtonMarginVertical");
        this._fixedStyleRectSize = UIDefaultsLookup.getInt("JideTabbedPane.fixedStyleRectSize");
        this._closeButtonMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMargin");
        this._gripLeftMargin = UIDefaultsLookup.getInt("JideTabbedPane.gripLeftMargin");
        this._closeButtonMarginSize = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginSize");
        this._closeButtonLeftMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonLeftMargin");
        this._closeButtonRightMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonRightMargin");
        this._defaultTabBorderShadowColor = UIDefaultsLookup.getColor("JideTabbedPane.defaultTabBorderShadowColor");
        this._alwaysShowLineBorder = UIDefaultsLookup.getBoolean("JideTabbedPane.alwaysShowLineBorder");
        this._showFocusIndicator = UIDefaultsLookup.getBoolean("JideTabbedPane.showFocusIndicator");
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._gripperPainter = null;
        this._highlight = null;
        this._lightHighlight = null;
        this._shadow = null;
        this._darkShadow = null;
        this._focus = null;
        this._inactiveTabForeground = null;
        this._selectedColor = null;
        this._tabInsets = null;
        this._selectedTabPadInsets = null;
        this._tabAreaInsets = null;
        this._defaultTabBorderShadowColor = null;
    }

    protected void installListeners() {
        if (this._tabModelChangeListener == null) {
            this._tabModelChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int selectedIndex;
                    if (BasicJideTabbedPaneUI.this._tabPane != null && (selectedIndex = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex()) >= 0 && selectedIndex < BasicJideTabbedPaneUI.this._tabPane.getTabCount() && BasicJideTabbedPaneUI.this._tabScroller != null && BasicJideTabbedPaneUI.this._tabScroller.closeButton != null) {
                        BasicJideTabbedPaneUI.this._tabScroller.closeButton.setEnabled(BasicJideTabbedPaneUI.this._tabPane.isTabClosableAt(selectedIndex));
                    }
                }
            };
            this._tabPane.getModel().addChangeListener(this._tabModelChangeListener);
        }
        if (this._propertyChangeListener == null) {
            this._propertyChangeListener = this.createPropertyChangeListener();
            this._tabPane.addPropertyChangeListener(this._propertyChangeListener);
        }
        if (this._tabChangeListener == null) {
            this._tabChangeListener = this.createChangeListener();
            this._tabPane.addChangeListener(this._tabChangeListener);
        }
        if (this._tabFocusListener == null) {
            this._tabFocusListener = this.createFocusListener();
            this._tabPane.addFocusListener(this._tabFocusListener);
        }
        if (this._mouseListener == null) {
            this._mouseListener = this.createMouseListener();
            this._tabPane.addMouseListener(this._mouseListener);
        }
        if (this._mousemotionListener == null) {
            this._mousemotionListener = this.createMouseMotionListener();
            this._tabPane.addMouseMotionListener(this._mousemotionListener);
        }
        if (this._mouseWheelListener == null) {
            this._mouseWheelListener = this.createMouseWheelListener();
            this._tabPane.addMouseWheelListener(this._mouseWheelListener);
        }
        if (this._containerListener == null) {
            this._containerListener = new ContainerHandler();
            this._tabPane.addContainerListener(this._containerListener);
            if (this._tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
        if (this._componentListener == null) {
            this._componentListener = new ComponentHandler();
            this._tabPane.addComponentListener(this._componentListener);
        }
        if (!this._tabPane.isDragOverDisabled() && this._dropListener == null) {
            this._dropListener = this.createDropListener();
            this._dt = new DropTarget(this.getTabPanel(), this._dropListener);
        }
    }

    protected DropListener createDropListener() {
        return new DropListener();
    }

    protected void uninstallListeners() {
        if (this._tabModelChangeListener != null) {
            this._tabPane.getModel().removeChangeListener(this._tabModelChangeListener);
            this._tabModelChangeListener = null;
        }
        if (this._containerListener != null) {
            this._tabPane.removeContainerListener(this._containerListener);
            this._containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this._componentListener != null) {
            this._tabPane.removeComponentListener(this._componentListener);
            this._componentListener = null;
        }
        if (this._tabChangeListener != null) {
            this._tabPane.removeChangeListener(this._tabChangeListener);
            this._tabChangeListener = null;
        }
        if (this._tabFocusListener != null) {
            this._tabPane.removeFocusListener(this._tabFocusListener);
            this._tabFocusListener = null;
        }
        if (this._mouseListener != null) {
            this._tabPane.removeMouseListener(this._mouseListener);
            this._mouseListener = null;
        }
        if (this._mousemotionListener != null) {
            this._tabPane.removeMouseMotionListener(this._mousemotionListener);
            this._mousemotionListener = null;
        }
        if (this._mouseWheelListener != null) {
            this._tabPane.removeMouseWheelListener(this._mouseWheelListener);
            this._mouseWheelListener = null;
        }
        if (this._propertyChangeListener != null) {
            this._tabPane.removePropertyChangeListener(this._propertyChangeListener);
            this._propertyChangeListener = null;
        }
        if (this._dt != null && this._dropListener != null) {
            this._dt.removeDropTargetListener(this._dropListener);
            this._dropListener = null;
            this._dt = null;
            this.getTabPanel().setDropTarget(null);
        }
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected FocusListener createFocusListener() {
        return new TabFocusListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap km3 = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this._tabPane, 1, km3);
        km3 = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this._tabPane, 0, km3);
        ActionMap am = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this._tabPane, am);
        this.ensureCloseButtonCreated();
        if (this.scrollableTabLayoutEnabled()) {
            Icon forwardIcon = this._tabScroller.scrollForwardButton.getIcon();
            this._tabScroller.scrollForwardButton.setAction(am.get("scrollTabsForwardAction"));
            if (forwardIcon != null) {
                this._tabScroller.scrollForwardButton.setIcon(forwardIcon);
            }
            Icon backwardIcon = this._tabScroller.scrollBackwardButton.getIcon();
            this._tabScroller.scrollBackwardButton.setAction(am.get("scrollTabsBackwardAction"));
            if (backwardIcon != null) {
                this._tabScroller.scrollBackwardButton.setIcon(backwardIcon);
            }
            Icon listIcon = this._tabScroller.listButton.getIcon();
            this._tabScroller.listButton.setAction(am.get("scrollTabsListAction"));
            if (listIcon != null) {
                this._tabScroller.listButton.setIcon(listIcon);
            }
            Action action = this._tabPane.getCloseAction();
            this.updateButtonFromAction(this._tabScroller.closeButton, action);
            Icon closeIcon = this._tabScroller.closeButton.getIcon();
            this._tabScroller.closeButton.setAction(am.get("closeTabAction"));
            if (closeIcon != null) {
                this._tabScroller.closeButton.setIcon(closeIcon);
            }
            this._tabScroller.scrollForwardButton.setToolTipText(this.getResourceString(BUTTON_NAME_SCROLL_FORWARD));
            this._tabScroller.scrollBackwardButton.setToolTipText(this.getResourceString(BUTTON_NAME_SCROLL_BACKWARD));
            this._tabScroller.listButton.setToolTipText(this.getResourceString(BUTTON_NAME_TAB_LIST));
            this._tabScroller.closeButton.setToolTipText(this.getResourceString(BUTTON_NAME_CLOSE));
        }
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIDefaultsLookup.get("JideTabbedPane.ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)UIDefaultsLookup.get("JideTabbedPane.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIDefaultsLookup.get("JideTabbedPane.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("JideTabbedPane.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("navigateNext", new NextAction());
        map.put("navigatePrevious", new PreviousAction());
        map.put("navigateRight", new RightAction());
        map.put("navigateLeft", new LeftAction());
        map.put("navigateUp", new UpAction());
        map.put("navigateDown", new DownAction());
        map.put("navigatePageUp", new PageUpAction());
        map.put("navigatePageDown", new PageDownAction());
        map.put("requestFocus", new RequestFocusAction());
        map.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        map.put("setSelectedIndex", new SetSelectedIndexAction());
        map.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        map.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        map.put("scrollTabsListAction", new ScrollTabsListAction());
        map.put("closeTabAction", new CloseTabAction());
        return map;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this._tabPane, null);
        SwingUtilities.replaceUIInputMap(this._tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this._tabPane, 0, null);
        if (this._closeButtons != null) {
            for (int i = 0; i < this._closeButtons.length; ++i) {
                this._closeButtons[i] = null;
            }
            this._closeButtons = null;
        }
    }

    protected void updateMnemonics() {
        this.resetMnemonics();
        for (int counter = this._tabPane.getTabCount() - 1; counter >= 0; --counter) {
            int mnemonic = this._tabPane.getMnemonicAt(counter);
            if (mnemonic <= 0) continue;
            this.addMnemonic(counter, mnemonic);
        }
    }

    private void resetMnemonics() {
        if (this._mnemonicToIndexMap != null) {
            this._mnemonicToIndexMap.clear();
            this._mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int index, int mnemonic) {
        if (this._mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this._mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "setSelectedIndex");
        this._mnemonicToIndexMap.put(mnemonic, index);
    }

    private void initMnemonics() {
        this._mnemonicToIndexMap = new Hashtable();
        this._mnemonicInputMap = new InputMapUIResource();
        this._mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this._tabPane, 1));
        SwingUtilities.replaceUIInputMap(this._tabPane, 1, this._mnemonicInputMap);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        int tc = this._tabPane.getTabCount();
        this.paintBackground(g2, c);
        if (tc == 0) {
            return;
        }
        if (this._tabCount != tc) {
            this._tabCount = tc;
            this.updateMnemonics();
        }
        int selectedIndex = this._tabPane.getSelectedIndex();
        int tabPlacement = this._tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(g2, tabPlacement, selectedIndex, c);
        }
        this.paintContentBorder(g2, tabPlacement, selectedIndex);
    }

    public void paintBackground(Graphics g2, Component c) {
        if (this._tabPane.isOpaque()) {
            int width = c.getWidth();
            int height = c.getHeight();
            g2.setColor(this._background);
            g2.fillRect(0, 0, width, height);
        }
    }

    protected void paintTabArea(Graphics g2, int tabPlacement, int selectedIndex, Component c) {
        int tabCount = this._tabPane.getTabCount();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle rect = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        this.paintTabAreaBackground(g2, rect, tabPlacement);
        boolean leftToRight = tabPlacement == 2 || tabPlacement == 4 || this._tabPane.getComponentOrientation().isLeftToRight();
        for (int i = this._runCount - 1; i >= 0; --i) {
            int start = this._tabRuns[i];
            int next = this._tabRuns[i == this._runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : tabCount - 1;
            for (int j = start; j <= end; ++j) {
                if (!this._rects[j].intersects(rect) && leftToRight || j == selectedIndex) continue;
                this.paintTab(g2, tabPlacement, this._rects, j, iconRect, textRect);
            }
        }
        if (selectedIndex >= 0 && selectedIndex < this._tabPane.getTabCount() && this.getRunForTab(tabCount, selectedIndex) == 0 && (this._rects[selectedIndex].intersects(rect) || !leftToRight)) {
            this.paintTab(g2, tabPlacement, this._rects, selectedIndex, iconRect, textRect);
        }
    }

    protected void paintTabAreaBackground(Graphics g2, Rectangle rect, int tabPlacement) {
        this.getPainter().paintTabAreaBackground(this._tabPane, g2, rect, tabPlacement == 1 || tabPlacement == 3 ? 0 : 1, 0);
    }

    protected void paintTab(Graphics g2, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this._tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        this.paintTabBackground(g2, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        Object savedHints = JideSwingUtilities.setupShapeAntialiasing(g2);
        this.paintTabBorder(g2, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        JideSwingUtilities.restoreShapeAntialiasing(g2, savedHints);
        Icon icon = this._tabPane.getIconForTab(tabIndex);
        Rectangle tempTabRect = new Rectangle(tabRect);
        if (this._tabPane.isShowGripper()) {
            if (leftToRight) {
                tempTabRect.x += this._gripperWidth;
            }
            tempTabRect.width -= this._gripperWidth;
            Rectangle gripperRect = new Rectangle(tabRect);
            gripperRect.x = leftToRight ? (gripperRect.x += this._gripLeftMargin) : tabRect.x + tabRect.width - this._gripLeftMargin - this._gripperWidth;
            gripperRect.width = this._gripperWidth;
            if (this._gripperPainter != null) {
                this._gripperPainter.paint(this._tabPane, g2, gripperRect, 0, isSelected ? 3 : 0);
            } else {
                this.getPainter().paintGripper(this._tabPane, g2, gripperRect, 0, isSelected ? 3 : 0);
            }
        }
        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this._tabPane.isTabClosableAt(tabIndex) && (!this._tabPane.isShowCloseButtonOnSelectedTab() || isSelected)) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                int buttonWidth = this._closeButtons[tabIndex].getPreferredSize().width + this._closeButtonLeftMargin + this._closeButtonRightMargin;
                if (!(this._closeButtonAlignment == 10 ^ leftToRight)) {
                    tempTabRect.x += buttonWidth;
                }
                tempTabRect.width -= buttonWidth;
            } else {
                int buttonHeight = this._closeButtons[tabIndex].getPreferredSize().height + this._closeButtonLeftMargin + this._closeButtonRightMargin;
                if (this._closeButtonAlignment == 10) {
                    tempTabRect.y += buttonHeight;
                    tempTabRect.height -= buttonHeight;
                } else {
                    tempTabRect.height -= buttonHeight;
                }
            }
        }
        String title = this.getCurrentDisplayTitleAt(this._tabPane, tabIndex);
        Font font = isSelected ? (this._tabPane.getSelectedTabFont() != null ? this._tabPane.getSelectedTabFont() : (this._tabPane.getFont() instanceof UIResource ? this._selectedTabFont : this._tabPane.getFont())) : this._tabPane.getFont();
        if (isSelected && this._tabPane.isBoldActiveTab() && font.getStyle() != 1) {
            font = font.deriveFont(1);
        }
        FontMetrics metrics = this._tabPane.getFontMetrics(font);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tempTabRect, iconRect, textRect, isSelected);
        if (!(this._isEditing && isSelected || SystemInfo.isJdk6Above() && this._tabPane.getTabComponentAt(tabIndex) != null)) {
            this.paintText(g2, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        }
        if (!SystemInfo.isJdk6Above() || this._tabPane.getTabComponentAt(tabIndex) == null) {
            this.paintIcon(g2, tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
        this.paintFocusIndicator(g2, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
    }

    private void paintCroppedTabEdge(Graphics g2, int tabPlacement, int tabIndex, boolean isSelected, int x, int y) {
        switch (tabPlacement) {
            case 2: 
            case 4: {
                g2.setColor(this._shadow);
                for (int xx = x; xx <= x + this._rects[tabIndex].width; xx += 12) {
                    for (int i = 0; i < this.xCropLen.length; i += 2) {
                        g2.drawLine(xx + this.yCropLen[i], y - this.xCropLen[i], xx + this.yCropLen[i + 1] - 1, y - this.xCropLen[i + 1]);
                    }
                }
                break;
            }
            default: {
                g2.setColor(this._shadow);
                for (int yy = y; yy <= y + this._rects[tabIndex].height; yy += 12) {
                    for (int i = 0; i < this.xCropLen.length; i += 2) {
                        g2.drawLine(x - this.xCropLen[i], yy + this.yCropLen[i], x - this.xCropLen[i + 1], yy + this.yCropLen[i + 1] - 1);
                    }
                }
            }
        }
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this._tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this._tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this._textIconGap);
        this._tabPane.putClientProperty("html", null);
        if (tabPlacement == 1 || tabPlacement == 3) {
            if (iconRect.x - tabRect.x < this._iconMargin) {
                iconRect.x = tabRect.x + this._iconMargin;
                textRect.x = icon != null ? iconRect.x + iconRect.width + this._textIconGap : tabRect.x + this._textPadding;
                iconRect.width = Math.min(iconRect.width, tabRect.width - this._tabRectPadding);
                textRect.width = tabRect.width - this._tabRectPadding - iconRect.width - (icon != null ? this._textIconGap + this._iconMargin : this._noIconMargin);
            }
            if (this.getTabResizeMode() == 4 && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab() && !isSelected) {
                iconRect.width = iconRect.width + this._closeButtons[tabIndex].getPreferredSize().width + this._closeButtonMarginHorizon;
                textRect.width = 0;
            }
        } else {
            iconRect.y = tabRect.y + this._iconMargin;
            textRect.y = icon != null ? iconRect.y + iconRect.height + this._textIconGap : tabRect.y + this._textPadding;
            iconRect.x = tabRect.x + 2;
            textRect.x = tabRect.x + 2;
            textRect.width = tabRect.width - this._textMarginVertical;
            textRect.height = tabRect.height - this._tabRectPadding - iconRect.height - (icon != null ? this._textIconGap + this._iconMargin : this._noIconMargin);
            if (this.getTabResizeMode() == 4 && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab() && !isSelected) {
                iconRect.height = iconRect.height + this._closeButtons[tabIndex].getPreferredSize().height + this._closeButtonMarginVertical;
                textRect.height = 0;
            }
        }
    }

    protected void paintIcon(Graphics g2, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        if (icon != null && iconRect.width >= icon.getIconWidth()) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                icon.paintIcon(this._tabPane, g2, iconRect.x, iconRect.y);
            } else if (iconRect.height < this._rects[tabIndex].height - this._gripperHeight) {
                icon.paintIcon(this._tabPane, g2, iconRect.x, iconRect.y);
            }
        }
    }

    protected void paintText(Graphics g2, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        View v;
        Graphics2D g2d = (Graphics2D)g2.create();
        if (isSelected && this._tabPane.isBoldActiveTab()) {
            g2d.setFont(font.deriveFont(1));
        } else {
            g2d.setFont(font);
        }
        String actualText = title;
        if (tabPlacement == 1 || tabPlacement == 3) {
            if (textRect.width <= 0) {
                return;
            }
            while (SwingUtilities.computeStringWidth(metrics, actualText) > textRect.width) {
                actualText = actualText.substring(0, actualText.length() - 1);
            }
            if (!actualText.equals(title)) {
                actualText = actualText.length() >= 2 ? actualText.substring(0, actualText.length() - 2) + ".." : "";
            }
        } else {
            if (textRect.height <= 0) {
                return;
            }
            while (SwingUtilities.computeStringWidth(metrics, actualText) > textRect.height) {
                actualText = actualText.substring(0, actualText.length() - 1);
            }
            if (!actualText.equals(title)) {
                actualText = actualText.length() >= 2 ? actualText.substring(0, actualText.length() - 2) + ".." : "";
            }
        }
        if ((v = this.getTextViewForTab(tabIndex)) != null) {
            v.paint(g2d, textRect);
        } else {
            int mnemIndex = this._tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            Component comp = null;
            if (tabIndex >= 0 && tabIndex < this._tabPane.getTabCount()) {
                comp = this._tabPane.getComponentAt(tabIndex);
            }
            JideTabbedPane.ColorProvider colorProvider = this._tabPane.getTabColorProvider();
            Color color = null;
            if (comp instanceof TabColorProvider) {
                color = ((TabColorProvider)((Object)comp)).getTabForeground();
            }
            if (this._tabPane.isEnabled() && this._tabPane.isEnabledAt(tabIndex)) {
                if (color == null && colorProvider != null && colorProvider.getForegroundAt(tabIndex) != null) {
                    g2d.setColor(colorProvider.getForegroundAt(tabIndex));
                } else {
                    if (color == null) {
                        color = this._tabPane.getForegroundAt(tabIndex);
                    }
                    if (isSelected && this.showFocusIndicator()) {
                        if (!(color instanceof ColorUIResource)) {
                            g2d.setColor(color);
                        } else {
                            g2d.setColor(this._activeTabForeground);
                        }
                    } else if (isSelected) {
                        if (!(color instanceof ColorUIResource)) {
                            g2d.setColor(color);
                        } else {
                            g2d.setColor(this._inactiveSelectedTabForeground);
                        }
                    } else if (!(color instanceof ColorUIResource)) {
                        g2d.setColor(color);
                    } else {
                        g2d.setColor(this._inactiveTabForeground);
                    }
                }
                if (tabPlacement == 1 || tabPlacement == 3) {
                    JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, g2d, actualText, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                } else {
                    AffineTransform old = g2d.getTransform();
                    g2d.translate(textRect.x, textRect.y);
                    if (tabPlacement == 4) {
                        g2d.rotate(1.5707963267948966);
                        g2d.translate(0, -textRect.width);
                    } else {
                        g2d.rotate(-1.5707963267948966);
                        g2d.translate(-textRect.height + metrics.getHeight() / 2 + this._rectSizeExtend, 0);
                    }
                    JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, g2d, actualText, mnemIndex, 0, (textRect.width - metrics.getHeight()) / 2 + metrics.getAscent());
                    g2d.setTransform(old);
                }
            } else if (tabPlacement == 1 || tabPlacement == 3) {
                g2d.setColor(this._tabPane.getBackgroundAt(tabIndex).brighter());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, g2d, actualText, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g2d.setColor(this._tabPane.getBackgroundAt(tabIndex).darker());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, g2d, actualText, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            } else {
                AffineTransform old = g2d.getTransform();
                g2d.translate(textRect.x, textRect.y);
                if (tabPlacement == 4) {
                    g2d.rotate(1.5707963267948966);
                    g2d.translate(0, -textRect.width);
                } else {
                    g2d.rotate(-1.5707963267948966);
                    g2d.translate(-textRect.height + metrics.getHeight() / 2 + this._rectSizeExtend, 0);
                }
                g2d.setColor(this._tabPane.getBackgroundAt(tabIndex).brighter());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, g2d, actualText, mnemIndex, 0, (textRect.width - metrics.getHeight()) / 2 + metrics.getAscent());
                g2d.setColor(this._tabPane.getBackgroundAt(tabIndex).darker());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, g2d, actualText, mnemIndex, tabPlacement == 4 ? -1 : 1, (textRect.width - metrics.getHeight()) / 2 + metrics.getAscent() - 1);
                g2d.setTransform(old);
            }
        }
        g2d.dispose();
    }

    protected void paintTabBorder(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        switch (this.getTabShape()) {
            case 3: {
                this.paintBoxTabBorder(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 8: {
                this.paintExcelTabBorder(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 1: {
                this.paintWindowsTabBorder(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 11: {
                if (!isSelected) break;
                this.paintWindowsTabBorder(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 2: {
                this.paintVsnetTabBorder(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 9: {
                this.paintRoundedVsnetTabBorder(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 5: {
                this.paintFlatTabBorder(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 10: {
                this.paintRoundedFlatTabBorder(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            default: {
                this.paintOffice2003TabBorder(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
            }
        }
        int tabShape = this.getTabShape();
        if (tabShape == 1) {
            if (this._mouseEnter && this._tabPane.getColorTheme() == 4 && tabIndex == this._indexMouseOver && !isSelected && this._tabPane.isEnabledAt(this._indexMouseOver)) {
                this.paintTabBorderMouseOver(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
            }
        } else if (tabShape == 11 && this._mouseEnter && tabIndex == this._indexMouseOver && !isSelected && this._tabPane.isEnabledAt(this._indexMouseOver)) {
            this.paintTabBorderMouseOver(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
        }
    }

    protected void paintOffice2003TabBorder(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (tabPlacement) {
            case 2: {
                y += 2;
                if (isSelected) {
                    int i;
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y + 3, x, y + h2 - 5);
                    g2.drawLine(x + 1, y + h2 - 4, x + 1, y + h2 - 4);
                    g2.drawLine(x + 2, y + h2 - 3, x + w - 1, y + h2 - 3);
                    g2.drawLine(x + 1, y + 2, x + 1, y + 1);
                    g2.drawLine(x + 2, y, x + 2, y - 1);
                    for (i = 0; i < w - 4; ++i) {
                        g2.drawLine(x + 3 + i, y - 2 - i, x + 3 + i, y - 2 - i);
                    }
                    g2.drawLine(x + w - 1, y - w + 1, x + w - 1, y - w + 2);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + 1, y + 3, x + 1, y + h2 - 5);
                    g2.drawLine(x + 2, y + h2 - 4, x + w - 1, y + h2 - 4);
                    g2.drawLine(x + 2, y + 2, x + 2, y + 1);
                    g2.drawLine(x + 3, y, x + 3, y - 1);
                    for (i = 0; i < w - 4; ++i) {
                        g2.drawLine(x + 4 + i, y - 2 - i, x + 4 + i, y - 2 - i);
                    }
                    break;
                }
                if (tabIndex == 0) {
                    int i;
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x, y + 3, x, y + h2 - 5);
                    g2.drawLine(x + 1, y + h2 - 4, x + 1, y + h2 - 4);
                    g2.drawLine(x + 2, y + h2 - 3, x + w - 1, y + h2 - 3);
                    g2.drawLine(x + 1, y + 2, x + 1, y + 1);
                    g2.drawLine(x + 2, y, x + 2, y - 1);
                    for (i = 0; i < w - 4; ++i) {
                        g2.drawLine(x + 3 + i, y - 2 - i, x + 3 + i, y - 2 - i);
                    }
                    g2.drawLine(x + w - 1, y - w + 1, x + w - 1, y - w + 2);
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + 1, y + 3, x + 1, y + h2 - 6);
                        g2.drawLine(x + 2, y + 2, x + 2, y + 1);
                        g2.drawLine(x + 3, y, x + 3, y - 1);
                        for (i = 0; i < w - 4; ++i) {
                            g2.drawLine(x + 4 + i, y - 2 - i, x + 4 + i, y - 2 - i);
                        }
                        g2.setColor(this.getPainter().getControlDk());
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + 2, y + h2 - 4, x + w - 1, y + h2 - 4);
                    g2.drawLine(x + 1, y + h2 - 5, x + 1, y + h2 - 5);
                    break;
                }
                g2.setColor(this._unselectColor1);
                g2.drawLine(x, y + 3, x, y + h2 - 5);
                g2.drawLine(x + 1, y + h2 - 4, x + 1, y + h2 - 4);
                g2.drawLine(x + 2, y + h2 - 3, x + w - 1, y + h2 - 3);
                g2.drawLine(x + 1, y + 2, x + 1, y + 1);
                g2.drawLine(x + 2, y, x + 2, y - 1);
                g2.drawLine(x + 3, y - 2, x + 3, y - 2);
                if (this._unselectColor2 != null) {
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x + 1, y + 3, x + 1, y + h2 - 6);
                    g2.drawLine(x + 2, y + 2, x + 2, y + 1);
                    g2.drawLine(x + 3, y, x + 3, y - 1);
                    g2.drawLine(x + 4, y - 2, x + 4, y - 2);
                }
                if (this._unselectColor3 == null) break;
                g2.setColor(this._unselectColor3);
                g2.drawLine(x + 2, y + h2 - 4, x + w - 1, y + h2 - 4);
                g2.drawLine(x + 1, y + h2 - 5, x + 1, y + h2 - 5);
                break;
            }
            case 4: {
                if (isSelected) {
                    int i;
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + w - 1, y + 5, x + w - 1, y + h2 - 3);
                    g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                    g2.drawLine(x + w - 3, y + h2 - 1, x, y + h2 - 1);
                    g2.drawLine(x + w - 2, y + 4, x + w - 2, y + 3);
                    g2.drawLine(x + w - 3, y + 2, x + w - 3, y + 1);
                    for (i = 0; i < w - 4; ++i) {
                        g2.drawLine(x + w - 4 - i, y - i, x + w - 4 - i, y - i);
                    }
                    g2.drawLine(x, y - w + 3, x, y - w + 4);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + w - 2, y + 5, x + w - 2, y + h2 - 3);
                    g2.drawLine(x + w - 3, y + h2 - 2, x, y + h2 - 2);
                    g2.drawLine(x + w - 3, y + 4, x + w - 3, y + 3);
                    g2.drawLine(x + w - 4, y + 2, x + w - 4, y + 1);
                    for (i = 0; i < w - 4; ++i) {
                        g2.drawLine(x + w - 5 - i, y - i, x + w - 5 - i, y - i);
                    }
                    break;
                }
                if (tabIndex == 0) {
                    int i;
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + w - 1, y + 5, x + w - 1, y + h2 - 3);
                    g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                    g2.drawLine(x + w - 3, y + h2 - 1, x, y + h2 - 1);
                    g2.drawLine(x + w - 2, y + 4, x + w - 2, y + 3);
                    g2.drawLine(x + w - 3, y + 2, x + w - 3, y + 1);
                    for (i = 0; i < w - 4; ++i) {
                        g2.drawLine(x + w - 4 - i, y - i, x + w - 4 - i, y - i);
                    }
                    g2.drawLine(x, y - w + 3, x, y - w + 4);
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + w - 2, y + 5, x + w - 2, y + h2 - 4);
                        g2.drawLine(x + w - 3, y + 4, x + w - 3, y + 3);
                        g2.drawLine(x + w - 4, y + 2, x + w - 4, y + 1);
                        for (i = 0; i < w - 4; ++i) {
                            g2.drawLine(x + w - 5 - i, y - i, x + w - 5 - i, y - i);
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 2, y + h2 - 3, x + w - 2, y + h2 - 3);
                    g2.drawLine(x + w - 3, y + h2 - 2, x, y + h2 - 2);
                    break;
                }
                g2.setColor(this._unselectColor1);
                g2.drawLine(x + w - 1, y + 5, x + w - 1, y + h2 - 3);
                g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                g2.drawLine(x + w - 3, y + h2 - 1, x, y + h2 - 1);
                g2.drawLine(x + w - 2, y + 4, x + w - 2, y + 3);
                g2.drawLine(x + w - 3, y + 2, x + w - 3, y + 1);
                g2.drawLine(x + w - 4, y, x + w - 4, y);
                if (this._unselectColor2 != null) {
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x + w - 2, y + 5, x + w - 2, y + h2 - 4);
                    g2.drawLine(x + w - 3, y + 4, x + w - 3, y + 3);
                    g2.drawLine(x + w - 4, y + 2, x + w - 4, y + 1);
                    g2.drawLine(x + w - 5, y, x + w - 5, y);
                }
                if (this._unselectColor3 == null) break;
                g2.setColor(this._unselectColor3);
                g2.drawLine(x + w - 2, y + h2 - 3, x + w - 2, y + h2 - 3);
                g2.drawLine(x + w - 3, y + h2 - 2, x, y + h2 - 2);
                break;
            }
            case 3: {
                if (leftToRight) {
                    if (isSelected) {
                        int i;
                        g2.setColor(this._selectColor1);
                        g2.drawLine(x + w - 1, y + h2 - 3, x + w - 1, y);
                        g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                        g2.drawLine(x + 5, y + h2 - 1, x + w - 3, y + h2 - 1);
                        g2.drawLine(x + 3, y + h2 - 2, x + 4, y + h2 - 2);
                        g2.drawLine(x + 1, y + h2 - 3, x + 2, y + h2 - 3);
                        g2.drawLine(x, y + h2 - 4, x, y + h2 - 4);
                        for (i = 3; i < h2 - 2; ++i) {
                            g2.drawLine(x + 2 - i, y + h2 - 2 - i, x + 2 - i, y + h2 - 2 - i);
                        }
                        g2.drawLine(x - h2 + 3, y, x - h2 + 4, y);
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x + 5, y + h2 - 2, x + w - 3, y + h2 - 2);
                        g2.drawLine(x + w - 2, y, x + w - 2, y + h2 - 3);
                        g2.drawLine(x + 3, y + h2 - 3, x + 4, y + h2 - 3);
                        g2.drawLine(x + 1, y + h2 - 4, x + 2, y + h2 - 4);
                        g2.drawLine(x, y + h2 - 5, x, y + h2 - 5);
                        for (i = 3; i < h2 - 2; ++i) {
                            g2.drawLine(x + 2 - i, y + h2 - 3 - i, x + 2 - i, y + h2 - 3 - i);
                        }
                        break;
                    }
                    if (tabIndex == 0) {
                        int i;
                        g2.setColor(this._unselectColor1);
                        g2.drawLine(x + w - 1, y + h2 - 3, x + w - 1, y);
                        g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                        g2.drawLine(x + 5, y + h2 - 1, x + w - 3, y + h2 - 1);
                        g2.drawLine(x + 3, y + h2 - 2, x + 4, y + h2 - 2);
                        g2.drawLine(x + 1, y + h2 - 3, x + 2, y + h2 - 3);
                        g2.drawLine(x, y + h2 - 4, x, y + h2 - 4);
                        for (i = 3; i < h2 - 2; ++i) {
                            g2.drawLine(x + 2 - i, y + h2 - 2 - i, x + 2 - i, y + h2 - 2 - i);
                        }
                        g2.drawLine(x - h2 + 3, y, x - h2 + 4, y);
                        if (this._unselectColor2 != null) {
                            g2.setColor(this._unselectColor2);
                            g2.drawLine(x + 3, y + h2 - 3, x + 4, y + h2 - 3);
                            g2.drawLine(x + 1, y + h2 - 4, x + 2, y + h2 - 4);
                            g2.drawLine(x, y + h2 - 5, x, y + h2 - 5);
                            for (i = 3; i < h2 - 2; ++i) {
                                g2.drawLine(x + 2 - i, y + h2 - 3 - i, x + 2 - i, y + h2 - 3 - i);
                            }
                            g2.drawLine(x + 5, y + h2 - 2, x + w - 4, y + h2 - 2);
                        }
                        if (this._unselectColor3 == null) break;
                        g2.setColor(this._unselectColor3);
                        g2.drawLine(x + w - 3, y + h2 - 2, x + w - 3, y + h2 - 2);
                        g2.drawLine(x + w - 2, y + h2 - 3, x + w - 2, y);
                        break;
                    }
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 5, y + h2 - 1, x + w - 3, y + h2 - 1);
                    g2.drawLine(x + w - 1, y + h2 - 3, x + w - 1, y);
                    g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                    g2.drawLine(x + 3, y + h2 - 2, x + 4, y + h2 - 2);
                    g2.drawLine(x + 1, y + h2 - 3, x + 2, y + h2 - 3);
                    g2.drawLine(x, y + h2 - 4, x, y + h2 - 4);
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + 3, y + h2 - 3, x + 4, y + h2 - 3);
                        g2.drawLine(x + 1, y + h2 - 4, x + 2, y + h2 - 4);
                        g2.drawLine(x, y + h2 - 5, x, y + h2 - 5);
                        g2.drawLine(x + 5, y + h2 - 2, x + w - 4, y + h2 - 2);
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 3, y + h2 - 2, x + w - 3, y + h2 - 2);
                    g2.drawLine(x + w - 2, y + h2 - 3, x + w - 2, y);
                    break;
                }
                if (isSelected) {
                    int i;
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y + h2 - 3, x, y);
                    g2.drawLine(x + 1, y + h2 - 2, x + 1, y + h2 - 2);
                    g2.drawLine(x + w - 6, y + h2 - 1, x + 2, y + h2 - 1);
                    g2.drawLine(x + w - 4, y + h2 - 2, x + w - 5, y + h2 - 2);
                    g2.drawLine(x + w - 2, y + h2 - 3, x + w - 3, y + h2 - 3);
                    g2.drawLine(x + w - 1, y + h2 - 4, x + w - 1, y + h2 - 4);
                    for (i = 3; i < h2 - 2; ++i) {
                        g2.drawLine(x + w - 3 + i, y + h2 - 2 - i, x + w - 3 + i, y + h2 - 2 - i);
                    }
                    g2.drawLine(x + w - 4 + h2, y, x + w - 5 + h2, y);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + w - 6, y + h2 - 2, x + 2, y + h2 - 2);
                    g2.drawLine(x + 1, y, x + 1, y + h2 - 3);
                    g2.drawLine(x + w - 4, y + h2 - 3, x + w - 5, y + h2 - 3);
                    g2.drawLine(x + w - 2, y + h2 - 4, x + w - 3, y + h2 - 4);
                    g2.drawLine(x + w - 1, y + h2 - 5, x + w - 1, y + h2 - 5);
                    for (i = 3; i < h2 - 2; ++i) {
                        g2.drawLine(x + w - 3 + i, y + h2 - 3 - i, x + w - 3 + i, y + h2 - 3 - i);
                    }
                    break;
                }
                if (tabIndex == 0) {
                    int i;
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x, y + h2 - 3, x, y);
                    g2.drawLine(x + 1, y + h2 - 2, x + 1, y + h2 - 2);
                    g2.drawLine(x + w - 6, y + h2 - 1, x + 2, y + h2 - 1);
                    g2.drawLine(x + w - 4, y + h2 - 2, x + w - 5, y + h2 - 2);
                    g2.drawLine(x + w - 2, y + h2 - 3, x + w - 3, y + h2 - 3);
                    g2.drawLine(x + w - 1, y + h2 - 4, x + w - 1, y + h2 - 4);
                    for (i = 3; i < h2 - 2; ++i) {
                        g2.drawLine(x + w - 3 + i, y + h2 - 2 - i, x + w - 3 + i, y + h2 - 2 - i);
                    }
                    g2.drawLine(x + w - 4 + h2, y, x + w - 5 + h2, y);
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + w - 4, y + h2 - 3, x + w - 5, y + h2 - 3);
                        g2.drawLine(x + w - 2, y + h2 - 4, x + w - 3, y + h2 - 4);
                        g2.drawLine(x + w - 1, y + h2 - 5, x + w - 1, y + h2 - 5);
                        for (i = 3; i < h2 - 2; ++i) {
                            g2.drawLine(x + w - 3 + i, y + h2 - 3 - i, x + w - 3 + i, y + h2 - 3 - i);
                        }
                        g2.drawLine(x + w - 6, y + h2 - 2, x + 3, y + h2 - 2);
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + 2, y + h2 - 2, x + 2, y + h2 - 2);
                    g2.drawLine(x + 1, y + h2 - 3, x + 1, y);
                    break;
                }
                g2.setColor(this._unselectColor1);
                g2.drawLine(x + w - 6, y + h2 - 1, x + 2, y + h2 - 1);
                g2.drawLine(x, y + h2 - 3, x, y);
                g2.drawLine(x + 1, y + h2 - 2, x + 1, y + h2 - 2);
                g2.drawLine(x + w - 4, y + h2 - 2, x + w - 5, y + h2 - 2);
                g2.drawLine(x + w - 2, y + h2 - 3, x + w - 3, y + h2 - 3);
                g2.drawLine(x + w - 1, y + h2 - 4, x + w - 1, y + h2 - 4);
                if (this._unselectColor2 != null) {
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x + w - 4, y + h2 - 3, x + w - 5, y + h2 - 3);
                    g2.drawLine(x + w - 2, y + h2 - 4, x + w - 3, y + h2 - 4);
                    g2.drawLine(x + w - 1, y + h2 - 5, x + w - 1, y + h2 - 5);
                    g2.drawLine(x + w - 6, y + h2 - 2, x + 3, y + h2 - 2);
                }
                if (this._unselectColor3 == null) break;
                g2.setColor(this._unselectColor3);
                g2.drawLine(x + 2, y + h2 - 2, x + 2, y + h2 - 2);
                g2.drawLine(x + 1, y + h2 - 3, x + 1, y);
                break;
            }
            default: {
                if (leftToRight) {
                    if (isSelected) {
                        int i;
                        g2.setColor(this._selectColor1);
                        g2.drawLine(x + 3, y + 1, x + 4, y + 1);
                        g2.drawLine(x + 1, y + 2, x + 2, y + 2);
                        g2.drawLine(x, y + 3, x, y + 3);
                        g2.drawLine(x + 5, y, x + w - 3, y);
                        g2.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                        g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 1);
                        for (i = 3; i < h2 - 2; ++i) {
                            g2.drawLine(x + 2 - i, y + 1 + i, x + 2 - i, y + 1 + i);
                        }
                        g2.drawLine(x - h2 + 3, y + h2 - 1, x - h2 + 4, y + h2 - 1);
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x + 3, y + 2, x + 4, y + 2);
                        g2.drawLine(x + 1, y + 3, x + 2, y + 3);
                        g2.drawLine(x, y + 4, x, y + 4);
                        g2.drawLine(x + 5, y + 1, x + w - 3, y + 1);
                        g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h2 - 1);
                        for (i = 3; i < h2 - 2; ++i) {
                            g2.drawLine(x + 2 - i, y + 2 + i, x + 2 - i, y + 2 + i);
                        }
                        break;
                    }
                    if (tabIndex == 0) {
                        int i;
                        g2.setColor(this._unselectColor1);
                        g2.drawLine(x + 3, y + 1, x + 4, y + 1);
                        g2.drawLine(x + 1, y + 2, x + 2, y + 2);
                        g2.drawLine(x, y + 3, x, y + 3);
                        g2.drawLine(x + 5, y, x + w - 3, y);
                        g2.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                        g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 1);
                        for (i = 3; i < h2 - 2; ++i) {
                            g2.drawLine(x + 2 - i, y + 1 + i, x + 2 - i, y + 1 + i);
                        }
                        g2.drawLine(x - h2 + 3, y + h2 - 1, x - h2 + 4, y + h2 - 1);
                        if (this._unselectColor2 != null) {
                            g2.setColor(this._unselectColor2);
                            g2.drawLine(x + 3, y + 2, x + 4, y + 2);
                            g2.drawLine(x + 1, y + 3, x + 2, y + 3);
                            g2.drawLine(x, y + 4, x, y + 4);
                            for (i = 3; i < h2 - 2; ++i) {
                                g2.drawLine(x + 2 - i, y + 2 + i, x + 2 - i, y + 2 + i);
                            }
                            g2.drawLine(x + 5, y + 1, x + w - 4, y + 1);
                        }
                        if (this._unselectColor3 == null) break;
                        g2.setColor(this._unselectColor3);
                        g2.drawLine(x + w - 3, y + 1, x + w - 3, y + 1);
                        g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h2 - 1);
                        break;
                    }
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 3, y + 1, x + 4, y + 1);
                    g2.drawLine(x + 1, y + 2, x + 2, y + 2);
                    g2.drawLine(x, y + 3, x, y + 3);
                    g2.drawLine(x + 5, y, x + w - 3, y);
                    g2.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 1);
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + 3, y + 2, x + 4, y + 2);
                        g2.drawLine(x + 1, y + 3, x + 2, y + 3);
                        g2.drawLine(x, y + 4, x, y + 4);
                        g2.drawLine(x + 5, y + 1, x + w - 4, y + 1);
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 3, y + 1, x + w - 3, y + 1);
                    g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h2 - 1);
                    break;
                }
                if (isSelected) {
                    int i;
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + w - 4, y + 1, x + w - 5, y + 1);
                    g2.drawLine(x + w - 2, y + 2, x + w - 3, y + 2);
                    g2.drawLine(x + w - 1, y + 3, x + w - 1, y + 3);
                    g2.drawLine(x + w - 6, y, x + 2, y);
                    g2.drawLine(x + 1, y + 1, x + 1, y + 1);
                    g2.drawLine(x, y + 2, x, y + h2 - 1);
                    for (i = 3; i < h2 - 2; ++i) {
                        g2.drawLine(x + w - 3 + i, y + 1 + i, x + w - 3 + i, y + 1 + i);
                    }
                    g2.drawLine(x + w - 4 + h2, y + h2 - 1, x + w - 5 + h2, y + h2 - 1);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + w - 4, y + 2, x + w - 5, y + 2);
                    g2.drawLine(x + w - 2, y + 3, x + w - 3, y + 3);
                    g2.drawLine(x + w - 1, y + 4, x + w - 1, y + 4);
                    g2.drawLine(x + w - 6, y + 1, x + 2, y + 1);
                    g2.drawLine(x + 1, y + 2, x + 1, y + h2 - 1);
                    for (i = 3; i < h2 - 2; ++i) {
                        g2.drawLine(x + w - 3 + i, y + 2 + i, x + w - 3 + i, y + 2 + i);
                    }
                    break;
                }
                if (tabIndex == 0) {
                    int i;
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + w - 4, y + 1, x + w - 5, y + 1);
                    g2.drawLine(x + w - 2, y + 2, x + w - 3, y + 2);
                    g2.drawLine(x + w - 1, y + 3, x + w - 1, y + 3);
                    g2.drawLine(x + w - 6, y, x + 2, y);
                    g2.drawLine(x + 1, y + 1, x + 1, y + 1);
                    g2.drawLine(x, y + 2, x, y + h2 - 1);
                    for (i = 3; i < h2 - 2; ++i) {
                        g2.drawLine(x + w - 3 + i, y + 1 + i, x + w - 3 + i, y + 1 + i);
                    }
                    g2.drawLine(x + w - 4 + h2, y + h2 - 1, x + w - 5 + h2, y + h2 - 1);
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + w - 4, y + 2, x + w - 5, y + 2);
                        g2.drawLine(x + w - 2, y + 3, x + w - 3, y + 3);
                        g2.drawLine(x + w - 1, y + 4, x + w - 1, y + 4);
                        for (i = 3; i < h2 - 2; ++i) {
                            g2.drawLine(x + w - 3 + i, y + 2 + i, x + w - 3 + i, y + 2 + i);
                        }
                        g2.drawLine(x + w - 6, y + 1, x + 3, y + 1);
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + 2, y + 1, x + 2, y + 1);
                    g2.drawLine(x + 1, y + 2, x + 1, y + h2 - 1);
                    break;
                }
                g2.setColor(this._unselectColor1);
                g2.drawLine(x + w - 4, y + 1, x + w - 5, y + 1);
                g2.drawLine(x + w - 2, y + 2, x + w - 3, y + 2);
                g2.drawLine(x + w - 1, y + 3, x + w - 1, y + 3);
                g2.drawLine(x + w - 6, y, x + 2, y);
                g2.drawLine(x + 1, y + 1, x + 1, y + 1);
                g2.drawLine(x, y + 2, x, y + h2 - 1);
                if (this._unselectColor2 != null) {
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x + w - 4, y + 2, x + w - 5, y + 2);
                    g2.drawLine(x + w - 2, y + 3, x + w - 3, y + 3);
                    g2.drawLine(x + w - 1, y + 4, x + w - 1, y + 4);
                    g2.drawLine(x + w - 6, y + 1, x + 3, y + 1);
                }
                if (this._unselectColor3 == null) break;
                g2.setColor(this._unselectColor3);
                g2.drawLine(x + 2, y + 1, x + 2, y + 1);
                g2.drawLine(x + 1, y + 2, x + 1, y + h2 - 1);
            }
        }
    }

    protected void paintExcelTabBorder(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (tabPlacement) {
            case 2: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y + 5, x, y + h2 - 5);
                    int i = 0;
                    int j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + 1 + j, y + 4 - i, x + 2 + j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + j, y + h2 - 4 + i, x + 1 + j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._selectColor2 != null) {
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x + 1, y + 6, x + 1, y + h2 - 6);
                        i = 0;
                        j = 0;
                        while (i < w / 2 + 1) {
                            g2.drawLine(x + 1 + j, y + 5 - i, x + 2 + j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    g2.setColor(this._selectColor3);
                    g2.drawLine(x + 1, y + h2 - 5, x + 1, y + h2 - 5);
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + 2 + j, y + h2 - 4 + i, x + 3 + j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                } else if (tabIndex == 0) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x, y + 5, x, y + h2 - 5);
                    int i = 0;
                    int j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + 1 + j, y + 4 - i, x + 2 + j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + j, y + h2 - 4 + i, x + 1 + j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + 1, y + 6, x + 1, y + h2 - 6);
                        i = 0;
                        j = 0;
                        while (i < w / 2) {
                            g2.drawLine(x + 1 + j, y + 5 - i, x + 2 + j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + 1, y + h2 - 5, x + 1, y + h2 - 5);
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + 2 + j, y + h2 - 4 + i, x + 3 + j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                } else if (tabIndex == this._tabPane.getSelectedIndex() - 1) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x, y + 5, x, y + h2 - 5);
                    int i = 0;
                    int j = 0;
                    while (i < 4) {
                        g2.drawLine(x + 1 + j, y + 4 - i, x + 2 + j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g2.drawLine(x + j, y + h2 - 4 + i, x + 1 + j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + 1, y + 6, x + 1, y + h2 - 6);
                        i = 0;
                        j = 0;
                        while (i < 4) {
                            g2.drawLine(x + 1 + j, y + 5 - i, x + 2 + j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + 1, y + h2 - 5, x + 1, y + h2 - 5);
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g2.drawLine(x + 2 + j, y + h2 - 4 + i, x + 3 + j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                } else {
                    if (tabIndex == this._tabPane.getSelectedIndex() - 1) break;
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x, y + 5, x, y + h2 - 5);
                    int i = 0;
                    int j = 0;
                    while (i < 4) {
                        g2.drawLine(x + 1 + j, y + 4 - i, x + 2 + j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + j, y + h2 - 4 + i, x + 1 + j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + 1, y + 6, x + 1, y + h2 - 6);
                        i = 0;
                        j = 0;
                        while (i < 4) {
                            g2.drawLine(x + 1 + j, y + 5 - i, x + 2 + j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + 1, y + h2 - 5, x + 1, y + h2 - 5);
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + 2 + j, y + h2 - 4 + i, x + 3 + j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                }
                break;
            }
            case 4: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + w - 1, y + 5, x + w - 1, y + h2 - 5);
                    int i = 0;
                    int j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + w - 2 - j, y + 4 - i, x + w - 3 - j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + w - 1 - j, y + h2 - 4 + i, x + w - 2 - j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._selectColor2 != null) {
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x + w - 2, y + 6, x + w - 2, y + h2 - 6);
                        i = 0;
                        j = 0;
                        while (i < w / 2 + 1) {
                            g2.drawLine(x + w - 2 - j, y + 5 - i, x + w - 3 - j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    g2.setColor(this._selectColor3);
                    g2.drawLine(x + w - 2, y + h2 - 5, x + w - 2, y + h2 - 5);
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + w - 3 - j, y + h2 - 4 + i, x + w - 4 - j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                } else if (tabIndex == 0) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + w - 1, y + 5, x + w - 1, y + h2 - 5);
                    int i = 0;
                    int j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + w - 2 - j, y + 4 - i, x + w - 3 - j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + w - 1 - j, y + h2 - 4 + i, x + w - 2 - j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + w - 2, y + 6, x + w - 2, y + h2 - 6);
                        i = 0;
                        j = 0;
                        while (i < w / 2 + 1) {
                            g2.drawLine(x + w - 2 - j, y + 5 - i, x + w - 3 - j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 2, y + h2 - 5, x + w - 2, y + h2 - 5);
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + w - 3 - j, y + h2 - 4 + i, x + w - 4 - j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                } else if (tabIndex == this._tabPane.getSelectedIndex() - 1) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + w - 1, y + 5, x + w - 1, y + h2 - 5);
                    int i = 0;
                    int j = 0;
                    while (i < 4) {
                        g2.drawLine(x + w - 2 - j, y + 4 - i, x + w - 3 - j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g2.drawLine(x + w - 1 - j, y + h2 - 4 + i, x + w - 2 - j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + w - 2, y + 6, x + w - 2, y + h2 - 6);
                        i = 0;
                        j = 0;
                        while (i < 4) {
                            g2.drawLine(x + w - 2 - j, y + 5 - i, x + w - 3 - j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 2, y + h2 - 5, x + w - 2, y + h2 - 5);
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g2.drawLine(x + w - 3 - j, y + h2 - 4 + i, x + w - 4 - j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                } else {
                    if (tabIndex == this._tabPane.getSelectedIndex() - 1) break;
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + w - 1, y + 5, x + w - 1, y + h2 - 5);
                    int i = 0;
                    int j = 0;
                    while (i < 4) {
                        g2.drawLine(x + w - 2 - j, y + 4 - i, x + w - 3 - j, y + 4 - i);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + w - 1 - j, y + h2 - 4 + i, x + w - 2 - j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + w - 2, y + 6, x + w - 2, y + h2 - 6);
                        i = 0;
                        j = 0;
                        while (i < 4) {
                            g2.drawLine(x + w - 2 - j, y + 5 - i, x + w - 3 - j, y + 5 - i);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 2, y + h2 - 5, x + w - 2, y + h2 - 5);
                    i = 0;
                    j = 0;
                    while (i < w / 2 + 1) {
                        g2.drawLine(x + w - 3 - j, y + h2 - 4 + i, x + w - 4 - j, y + h2 - 4 + i);
                        ++i;
                        j += 2;
                    }
                }
                break;
            }
            case 3: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + 5, y + h2 - 1, x + w - 5, y + h2 - 1);
                    int i = 0;
                    int j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + 4 - i, y + h2 - 2 - j, x + 4 - i, y + h2 - 3 - j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + w - 4 - 1 + i, y + h2 - 1 - j, x + w - 4 - 1 + i, y + h2 - 2 - j);
                        ++i;
                        j += 2;
                    }
                    if (this._selectColor2 != null) {
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x + 5, y + h2 - 3, x + 5, y + h2 - 3);
                        i = 0;
                        j = 0;
                        while (i < h2 / 2 + 1) {
                            g2.drawLine(x + 4 - i, y + h2 - 4 - j, x + 4 - i, y + h2 - 5 - j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    g2.setColor(this._selectColor3);
                    g2.drawLine(x + 5, y + h2 - 2, x + w - 6, y + h2 - 2);
                    i = 0;
                    j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + w - 5 + i, y + h2 - 3 - j, x + w - 5 + i, y + h2 - 4 - j);
                        ++i;
                        j += 2;
                    }
                } else if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 5, y + h2 - 1, x + w - 5, y + h2 - 1);
                    int i = 0;
                    int j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + 4 - i, y + h2 - 2 - j, x + 4 - i, y + h2 - 3 - j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + w - 4 - 1 + i, y + h2 - 1 - j, x + w - 4 - 1 + i, y + h2 - 2 - j);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        i = 0;
                        j = 0;
                        while (i < h2 / 2 + 1) {
                            g2.drawLine(x + 5 - i, y + h2 - 2 - j, x + 5 - i, y + h2 - 3 - j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 6, y + h2 - 2, x + w - 6, y + h2 - 2);
                    i = 0;
                    j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + w - 5 + i, y + h2 - 3 - j, x + w - 5 + i, y + h2 - 4 - j);
                        ++i;
                        j += 2;
                    }
                } else if (tabIndex == this._tabPane.getSelectedIndex() + (leftToRight ? -1 : 1)) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 5, y + h2 - 1, x + w - 6, y + h2 - 1);
                    int i = 0;
                    int j = 0;
                    while (i < 5) {
                        g2.drawLine(x + 4 - i, y + h2 - 2 - j, x + 4 - i, y + h2 - 3 - j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g2.drawLine(x + w - 5 + i, y + h2 - 1 - j, x + w - 5 + i, y + h2 - 2 - j);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        i = 0;
                        j = 0;
                        while (i < 5) {
                            g2.drawLine(x + 5 - i, y + h2 - 2 - j, x + 5 - i, y + h2 - 3 - j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 6, y + h2 - 2, x + w - 6, y + h2 - 2);
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g2.drawLine(x + w - 5 + i, y + h2 - 3 - j, x + w - 5 + i, y + h2 - 4 - j);
                        ++i;
                        j += 2;
                    }
                } else {
                    if (tabIndex == this._tabPane.getSelectedIndex() + (leftToRight ? -1 : 1)) break;
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 5, y + h2 - 1, x + w - 6, y + h2 - 1);
                    int i = 0;
                    int j = 0;
                    while (i < 5) {
                        g2.drawLine(x + 4 - i, y + h2 - 2 - j, x + 4 - i, y + h2 - 3 - j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + w - 5 + i, y + h2 - 1 - j, x + w - 5 + i, y + h2 - 2 - j);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        i = 0;
                        j = 0;
                        while (i < 5) {
                            g2.drawLine(x + 5 - i, y + h2 - 2 - j, x + 5 - i, y + h2 - 3 - j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 6, y + h2 - 2, x + w - 6, y + h2 - 2);
                    i = 0;
                    j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + w - 5 + i, y + h2 - 3 - j, x + w - 5 + i, y + h2 - 4 - j);
                        ++i;
                        j += 2;
                    }
                }
                break;
            }
            default: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + 5, y, x + w - 5, y);
                    int i = 0;
                    int j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + 4 - i, y + 1 + j, x + 4 - i, y + 2 + j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + w - 4 - 1 + i, y + j, x + w - 4 - 1 + i, y + 1 + j);
                        ++i;
                        j += 2;
                    }
                    if (this._selectColor2 != null) {
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x + 6, y + 1, x + w - 7, y + 1);
                        i = 0;
                        j = 0;
                        while (i < h2 / 2 + 1) {
                            g2.drawLine(x + 5 - i, y + 1 + j, x + 5 - i, y + 2 + j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    g2.setColor(this._selectColor3);
                    g2.drawLine(x + w - 6, y + 1, x + w - 6, y + 1);
                    i = 0;
                    j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + w - 5 + i, y + 2 + j, x + w - 5 + i, y + 3 + j);
                        ++i;
                        j += 2;
                    }
                } else if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 5, y, x + w - 5, y);
                    int i = 0;
                    int j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + 4 - i, y + 1 + j, x + 4 - i, y + 2 + j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + w - 4 - 1 + i, y + j, x + w - 4 - 1 + i, y + 1 + j);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + 6, y + 1, x + w - 7, y + 1);
                        i = 0;
                        j = 0;
                        while (i < h2 / 2 + 1) {
                            g2.drawLine(x + 5 - i, y + 1 + j, x + 5 - i, y + 2 + j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 6, y + 1, x + w - 6, y + 1);
                    i = 0;
                    j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + w - 5 + i, y + 2 + j, x + w - 5 + i, y + 3 + j);
                        ++i;
                        j += 2;
                    }
                } else if (tabIndex == this._tabPane.getSelectedIndex() + (leftToRight ? -1 : 1)) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 5, y, x + w - 5, y);
                    int i = 0;
                    int j = 0;
                    while (i < 5) {
                        g2.drawLine(x + 4 - i, y + 1 + j, x + 4 - i, y + 2 + j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g2.drawLine(x + w - 4 - 1 + i, y + j, x + w - 4 - 1 + i, y + 1 + j);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + 6, y + 1, x + w - 7, y + 1);
                        i = 0;
                        j = 0;
                        while (i < 5) {
                            g2.drawLine(x + 5 - i, y + 1 + j, x + 5 - i, y + 2 + j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 6, y + 1, x + w - 6, y + 1);
                    i = 0;
                    j = 0;
                    while (i < 5) {
                        g2.drawLine(x + w - 5 + i, y + 2 + j, x + w - 5 + i, y + 3 + j);
                        ++i;
                        j += 2;
                    }
                } else {
                    if (tabIndex == this._tabPane.getSelectedIndex() + (leftToRight ? -1 : 1)) break;
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 5, y, x + w - 5, y);
                    int i = 0;
                    int j = 0;
                    while (i < 5) {
                        g2.drawLine(x + 4 - i, y + 1 + j, x + 4 - i, y + 2 + j);
                        ++i;
                        j += 2;
                    }
                    i = 0;
                    j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + w - 4 - 1 + i, y + j, x + w - 4 - 1 + i, y + 1 + j);
                        ++i;
                        j += 2;
                    }
                    if (this._unselectColor2 != null) {
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + 6, y + 1, x + w - 7, y + 1);
                        i = 0;
                        j = 0;
                        while (i < 5) {
                            g2.drawLine(x + 5 - i, y + 1 + j, x + 5 - i, y + 2 + j);
                            ++i;
                            j += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 6, y + 1, x + w - 6, y + 1);
                    i = 0;
                    j = 0;
                    while (i < h2 / 2 + 1) {
                        g2.drawLine(x + w - 5 + i, y + 2 + j, x + w - 5 + i, y + 3 + j);
                        ++i;
                        j += 2;
                    }
                }
                break;
            }
        }
    }

    protected void paintWindowsTabBorder(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        int colorTheme = this.getColorTheme();
        switch (tabPlacement) {
            case 2: {
                if (colorTheme == 2 || colorTheme == 1) {
                    if (isSelected) {
                        g2.setColor(this._selectColor1);
                        g2.drawLine(x - 2, y + 1, x - 2, y + h2 - 1);
                        g2.drawLine(x - 1, y, x - 1, y);
                        g2.drawLine(x, y - 1, x + w - 1, y - 1);
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x - 1, y + h2, x - 1, y + h2);
                        g2.drawLine(x, y + h2 + 1, x, y + h2 + 1);
                        g2.drawLine(x + 1, y + h2, x + w - 1, y + h2);
                        g2.setColor(this._selectColor3);
                        g2.drawLine(x, y + h2, x, y + h2);
                        g2.drawLine(x + 1, y + h2 + 1, x + w - 1, y + h2 + 1);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g2.setColor(this._unselectColor1);
                        g2.drawLine(x, y + 2, x, y + h2 - 3);
                        g2.drawLine(x + 1, y + 1, x + 1, y + 1);
                        g2.drawLine(x + 2, y, x + w - 1, y);
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + 1, y + h2 - 2, x + 1, y + h2 - 2);
                        g2.drawLine(x + 2, y + h2 - 1, x + 2, y + h2 - 1);
                        g2.drawLine(x + 3, y + h2 - 2, x + w - 1, y + h2 - 2);
                        g2.setColor(this._unselectColor3);
                        g2.drawLine(x + 2, y + h2 - 2, x + 2, y + h2 - 2);
                        g2.drawLine(x + 3, y + h2 - 1, x + w - 1, y + h2 - 1);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x, y + 3, x, y + h2 - 2);
                    g2.drawLine(x + 1, y + 2, x + 1, y + 2);
                    g2.drawLine(x + 2, y + 1, x + w - 1, y + 1);
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x + 1, y + h2 - 1, x + 1, y + h2 - 1);
                    g2.drawLine(x + 2, y + h2, x + 2, y + h2);
                    g2.drawLine(x + 3, y + h2 - 1, x + w - 1, y + h2 - 1);
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + 2, y + h2 - 1, x + 2, y + h2 - 1);
                    g2.drawLine(x + 3, y + h2, x + w - 1, y + h2);
                    break;
                }
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x - 2, y + 1, x - 2, y + h2 - 1);
                    g2.drawLine(x - 1, y, x - 1, y);
                    g2.drawLine(x, y - 1, x, y - 1);
                    g2.drawLine(x - 1, y + h2, x - 1, y + h2);
                    g2.drawLine(x, y + h2 + 1, x, y + h2 + 1);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x - 1, y + 1, x - 1, y + h2 - 1);
                    g2.drawLine(x, y, x, y + h2);
                    g2.setColor(this._selectColor3);
                    g2.drawLine(x + 1, y - 2, x + w - 1, y - 2);
                    g2.drawLine(x + 1, y + h2 + 2, x + w - 1, y + h2 + 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x, y + 2, x, y + h2 - 4);
                    g2.drawLine(x + 1, y + 1, x + 1, y + 1);
                    g2.drawLine(x + 2, y, x + w - 1, y);
                    g2.drawLine(x + 1, y + h2 - 3, x + 1, y + h2 - 3);
                    g2.drawLine(x + 2, y + h2 - 2, x + w - 1, y + h2 - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g2.setColor(this._unselectColor1);
                g2.drawLine(x, y + 4, x, y + h2 - 2);
                g2.drawLine(x + 1, y + 3, x + 1, y + 3);
                g2.drawLine(x + 2, y + 2, x + w - 1, y + 2);
                g2.drawLine(x + 1, y + h2 - 1, x + 1, y + h2 - 1);
                g2.drawLine(x + 2, y + h2, x + w - 1, y + h2);
                break;
            }
            case 4: {
                if (colorTheme == 2 || colorTheme == 1) {
                    if (isSelected) {
                        g2.setColor(this._selectColor1);
                        g2.drawLine(x + w - 1, y - 1, x, y - 1);
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x + w, y + 1, x + w, y + h2 - 1);
                        g2.drawLine(x + w - 1, y + h2, x, y + h2);
                        g2.setColor(this._selectColor3);
                        g2.drawLine(x + w, y, x + w, y);
                        g2.drawLine(x + w + 1, y + 1, x + w + 1, y + h2 - 1);
                        g2.drawLine(x + w, y + h2, x + w, y + h2);
                        g2.drawLine(x + w - 1, y + h2 + 1, x, y + h2 + 1);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g2.setColor(this._unselectColor1);
                        g2.drawLine(x + w - 3, y, x, y);
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h2 - 3);
                        g2.drawLine(x + w - 3, y + h2 - 2, x, y + h2 - 2);
                        g2.setColor(this._unselectColor3);
                        g2.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                        g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 3);
                        g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                        g2.drawLine(x + w - 3, y + h2 - 1, x, y + h2 - 1);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + w - 3, y + 1, x, y + 1);
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x + w - 2, y + 3, x + w - 2, y + h2 - 2);
                    g2.drawLine(x + w - 3, y + h2 - 1, x, y + h2 - 1);
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 2, y + 2, x + w - 2, y + 2);
                    g2.drawLine(x + w - 1, y + 3, x + w - 1, y + h2 - 2);
                    g2.drawLine(x + w - 2, y + h2 - 1, x + w - 2, y + h2 - 1);
                    g2.drawLine(x + w - 3, y + h2, x, y + h2);
                    break;
                }
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + w + 1, y + 1, x + w + 1, y + h2 - 1);
                    g2.drawLine(x + w, y, x + w, y);
                    g2.drawLine(x + w - 1, y - 1, x + w - 1, y - 1);
                    g2.drawLine(x + w, y + h2, x + w, y + h2);
                    g2.drawLine(x + w - 1, y + h2 + 1, x + w - 1, y + h2 + 1);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + w, y + 1, x + w, y + h2 - 1);
                    g2.drawLine(x + w - 1, y, x + w - 1, y + h2);
                    g2.setColor(this._selectColor3);
                    g2.drawLine(x + w - 2, y - 2, x, y - 2);
                    g2.drawLine(x + w - 2, y + h2 + 2, x, y + h2 + 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 4);
                    g2.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g2.drawLine(x + w - 2, y + h2 - 3, x + w - 2, y + h2 - 3);
                    g2.drawLine(x + w - 3, y, x, y);
                    g2.drawLine(x + w - 3, y + h2 - 2, x, y + h2 - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g2.setColor(this._unselectColor1);
                g2.drawLine(x + w - 1, y + 4, x + w - 1, y + h2 - 2);
                g2.drawLine(x + w - 2, y + 3, x + w - 2, y + 3);
                g2.drawLine(x + w - 3, y + 2, x, y + 2);
                g2.drawLine(x + w - 2, y + h2 - 1, x + w - 2, y + h2 - 1);
                g2.drawLine(x + w - 3, y + h2, x, y + h2);
                break;
            }
            case 3: {
                if (colorTheme == 2 || colorTheme == 1) {
                    if (isSelected) {
                        g2.setColor(this._selectColor1);
                        g2.drawLine(x, y + h2, x, y + h2);
                        g2.drawLine(x - 1, y + h2 - 1, x - 1, y);
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x + 1, y + h2, x + w - 2, y + h2);
                        g2.drawLine(x + w - 1, y + h2 - 1, x + w - 1, y - 1);
                        g2.setColor(this._selectColor3);
                        g2.drawLine(x + 1, y + h2 + 1, x + w - 2, y + h2 + 1);
                        g2.drawLine(x + w - 1, y + h2, x + w - 1, y + h2);
                        g2.drawLine(x + w, y + h2 - 1, x + w, y - 1);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g2.setColor(this._unselectColor1);
                        g2.drawLine(x, y + h2 - 2, x, y + h2 - 2);
                        g2.drawLine(x - 1, y + h2 - 3, x - 1, y);
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + 1, y + h2 - 2, x + w - 4, y + h2 - 2);
                        g2.drawLine(x + w - 3, y + h2 - 3, x + w - 3, y - 1);
                        g2.setColor(this._unselectColor3);
                        g2.drawLine(x + 1, y + h2 - 1, x + w - 4, y + h2 - 1);
                        g2.drawLine(x + w - 3, y + h2 - 2, x + w - 3, y + h2 - 2);
                        g2.drawLine(x + w - 2, y + h2 - 3, x + w - 2, y - 1);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 2, y + h2 - 2, x + 2, y + h2 - 2);
                    g2.drawLine(x + 1, y + h2 - 3, x + 1, y);
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x + 3, y + h2 - 2, x + w - 2, y + h2 - 2);
                    g2.drawLine(x + w - 1, y + h2 - 3, x + w - 1, y);
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + 3, y + h2 - 1, x + w - 2, y + h2 - 1);
                    g2.drawLine(x + w - 1, y + h2 - 2, x + w - 1, y + h2 - 2);
                    g2.drawLine(x + w, y + h2 - 3, x + w, y);
                    break;
                }
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + 1, y + h2 + 1, x + w, y + h2 + 1);
                    g2.drawLine(x, y + h2, x, y + h2);
                    g2.drawLine(x - 1, y + h2 - 1, x - 1, y + h2 - 1);
                    g2.drawLine(x + w + 1, y + h2, x + w + 1, y + h2);
                    g2.drawLine(x + w + 2, y + h2 - 1, x + w + 2, y + h2 - 1);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + 1, y + h2, x + w, y + h2);
                    g2.drawLine(x, y + h2 - 1, x + w + 1, y + h2 - 1);
                    g2.setColor(this._selectColor3);
                    g2.drawLine(x - 1, y + h2 - 2, x - 1, y);
                    g2.drawLine(x + w + 2, y + h2 - 2, x + w + 2, y);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 3, y + h2 - 1, x + w - 3, y + h2 - 1);
                    g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                    g2.drawLine(x + w - 1, y + h2 - 3, x + w - 1, y - 1);
                    g2.drawLine(x + 2, y + h2 - 2, x + 2, y + h2 - 2);
                    g2.drawLine(x + 1, y + h2 - 3, x + 1, y);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g2.setColor(this._unselectColor1);
                g2.drawLine(x + 3, y + h2 - 1, x + w - 3, y + h2 - 1);
                g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                g2.drawLine(x + w - 1, y + h2 - 3, x + w - 1, y - 1);
                g2.drawLine(x + 2, y + h2 - 2, x + 2, y + h2 - 2);
                g2.drawLine(x + 1, y + h2 - 3, x + 1, y);
                break;
            }
            default: {
                if (colorTheme == 2 || colorTheme == 1) {
                    if (isSelected) {
                        g2.setColor(this._selectColor1);
                        g2.drawLine(x, y - 1, x, y - 1);
                        g2.drawLine(x - 1, y, x - 1, y + h2 - 1);
                        g2.drawLine(x + 1, y - 2, x + w + 1, y - 2);
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x + w + 2, y - 1, x + w + 2, y + h2 - 1);
                        g2.setColor(this._selectColor3);
                        g2.drawLine(x + w + 2, y - 1, x + w + 2, y - 1);
                        g2.drawLine(x + w + 3, y, x + w + 3, y + h2 - 1);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g2.setColor(this._unselectColor1);
                        g2.drawLine(x + 2, y + 1, x + 2, y + 1);
                        g2.drawLine(x + 1, y + 2, x + 1, y + h2 - 1);
                        g2.drawLine(x + 3, y, x + w - 2, y);
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + w - 1, y + 1, x + w - 1, y + h2 - 1);
                        g2.setColor(this._unselectColor3);
                        g2.drawLine(x + w - 1, y + 1, x + w - 1, y + 1);
                        g2.drawLine(x + w, y + 2, x + w, y + h2 - 1);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 2, y + 1, x + 2, y + 1);
                    g2.drawLine(x + 1, y + 2, x + 1, y + h2 - 1);
                    g2.drawLine(x + 3, y, x + w - 2, y);
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x + w - 1, y + 1, x + w - 1, y + h2 - 1);
                    g2.setColor(this._unselectColor3);
                    g2.drawLine(x + w - 1, y + 1, x + w - 1, y + 1);
                    g2.drawLine(x + w, y + 2, x + w, y + h2 - 1);
                    break;
                }
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + 1, y - 2, x + w, y - 2);
                    g2.drawLine(x, y - 1, x, y - 1);
                    g2.drawLine(x - 1, y, x - 1, y);
                    g2.drawLine(x + w + 1, y - 1, x + w + 1, y - 1);
                    g2.drawLine(x + w + 2, y, x + w + 2, y);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + 1, y - 1, x + w, y - 1);
                    g2.drawLine(x, y, x + w + 1, y);
                    g2.setColor(this._selectColor3);
                    g2.drawLine(x - 1, y + 1, x - 1, y + h2 - 1);
                    g2.drawLine(x + w + 2, y + 1, x + w + 2, y + h2 - 1);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 1, y + 2, x + 1, y + h2 - 1);
                    g2.drawLine(x + 2, y + 1, x + 2, y + 1);
                    g2.drawLine(x + 3, y, x + w - 3, y);
                    g2.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 1);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g2.setColor(this._unselectColor1);
                g2.drawLine(x + 1, y + 2, x + 1, y + h2 - 1);
                g2.drawLine(x + 2, y + 1, x + 2, y + 1);
                g2.drawLine(x + 3, y, x + w - 3, y);
                g2.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 1);
            }
        }
    }

    protected void paintTabBorderMouseOver(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        if (this.getTabShape() == 1) {
            switch (tabPlacement) {
                case 2: {
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        y -= 2;
                    }
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y + 4, x, y + h2 - 2);
                    g2.drawLine(x + 1, y + 3, x + 1, y + 3);
                    g2.drawLine(x + 2, y + 2, x + 2, y + 2);
                    g2.drawLine(x + 1, y + h2 - 1, x + 1, y + h2 - 1);
                    g2.drawLine(x + 2, y + h2, x + 2, y + h2);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + 1, y + 4, x + 1, y + h2 - 2);
                    g2.drawLine(x + 2, y + 3, x + 2, y + h2 - 1);
                    break;
                }
                case 4: {
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        y -= 2;
                    }
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + w - 1, y + 4, x + w - 1, y + h2 - 2);
                    g2.drawLine(x + w - 2, y + 3, x + w - 2, y + 3);
                    g2.drawLine(x + w - 3, y + 2, x + w - 3, y + 2);
                    g2.drawLine(x + w - 2, y + h2 - 1, x + w - 2, y + h2 - 1);
                    g2.drawLine(x + w - 3, y + h2, x + w - 3, y + h2);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + w - 2, y + 4, x + w - 2, y + h2 - 2);
                    g2.drawLine(x + w - 3, y + 3, x + w - 3, y + h2 - 1);
                    break;
                }
                case 3: {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + 3, y + h2 - 1, x + w - 3, y + h2 - 1);
                    g2.drawLine(x + 2, y + h2 - 2, x + 2, y + h2 - 2);
                    g2.drawLine(x + 1, y + h2 - 3, x + 1, y + h2 - 3);
                    g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                    g2.drawLine(x + w - 1, y + h2 - 3, x + w - 1, y + h2 - 3);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + 3, y + h2 - 2, x + w - 3, y + h2 - 2);
                    g2.drawLine(x + 2, y + h2 - 3, x + w - 2, y + h2 - 3);
                    break;
                }
                default: {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + 3, y, x + w - 3, y);
                    g2.drawLine(x + 2, y + 1, x + 2, y + 1);
                    g2.drawLine(x + 1, y + 2, x + 1, y + 2);
                    g2.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g2.drawLine(x + w - 1, y + 2, x + w - 1, y + 2);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + 3, y + 1, x + w - 3, y + 1);
                    g2.drawLine(x + 2, y + 2, x + w - 2, y + 2);
                    break;
                }
            }
        } else if (this.getTabShape() == 11) {
            switch (tabPlacement) {
                case 2: {
                    if (this.getColorTheme() == 4) {
                        if (tabIndex > this._tabPane.getSelectedIndex()) {
                            y -= 2;
                        }
                        g2.setColor(this._selectColor1);
                        g2.drawLine(x, y + 4, x, y + h2 - 2);
                        g2.drawLine(x + 1, y + 3, x + 1, y + 3);
                        g2.drawLine(x + 2, y + 2, x + 2, y + 2);
                        g2.drawLine(x + 1, y + h2 - 1, x + 1, y + h2 - 1);
                        g2.drawLine(x + 2, y + h2, x + 2, y + h2);
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x + 1, y + 4, x + 1, y + h2 - 2);
                        g2.drawLine(x + 2, y + 3, x + 2, y + h2 - 1);
                        g2.setColor(this._selectColor3);
                        g2.drawLine(x + 3, y + 2, x + w - 1, y + 2);
                        g2.drawLine(x + 3, y + h2, x + w - 1, y + h2);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        --y;
                    }
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y + 3, x, y + h2 - 2);
                    g2.drawLine(x + 1, y + 2, x + 1, y + 2);
                    g2.drawLine(x + 2, y + 1, x + w - 1, y + 1);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + 1, y + h2 - 1, x + 1, y + h2 - 1);
                    g2.drawLine(x + 2, y + h2, x + 2, y + h2);
                    g2.drawLine(x + 3, y + h2 - 1, x + w - 1, y + h2 - 1);
                    g2.setColor(this._selectColor3);
                    g2.drawLine(x + 2, y + h2 - 1, x + 2, y + h2 - 1);
                    g2.drawLine(x + 3, y + h2, x + w - 1, y + h2);
                    break;
                }
                case 4: {
                    if (this.getColorTheme() == 4) {
                        if (tabIndex > this._tabPane.getSelectedIndex()) {
                            y -= 2;
                        }
                        g2.setColor(this._selectColor1);
                        g2.drawLine(x + w - 1, y + 4, x + w - 1, y + h2 - 2);
                        g2.drawLine(x + w - 2, y + 3, x + w - 2, y + 3);
                        g2.drawLine(x + w - 3, y + 2, x + w - 3, y + 2);
                        g2.drawLine(x + w - 2, y + h2 - 1, x + w - 2, y + h2 - 1);
                        g2.drawLine(x + w - 3, y + h2, x + w - 3, y + h2);
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x + w - 2, y + 4, x + w - 2, y + h2 - 2);
                        g2.drawLine(x + w - 3, y + 3, x + w - 3, y + h2 - 1);
                        g2.setColor(this._selectColor3);
                        g2.drawLine(x + w - 4, y + 2, x, y + 2);
                        g2.drawLine(x + w - 4, y + h2, x, y + h2);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        --y;
                    }
                    g2.setColor(this._selectColor3);
                    g2.drawLine(x + w - 1, y + 3, x + w - 1, y + h2 - 2);
                    g2.drawLine(x + w - 2, y + h2 - 1, x + w - 2, y + h2 - 1);
                    g2.drawLine(x + w - 3, y + h2, x, y + h2);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + w - 2, y + 3, x + w - 2, y + h2 - 2);
                    g2.drawLine(x + w - 3, y + h2 - 1, x, y + h2 - 1);
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + w - 2, y + 2, x + w - 2, y + 2);
                    g2.drawLine(x + w - 3, y + 1, x, y + 1);
                    break;
                }
                case 3: {
                    if (this.getColorTheme() == 4) {
                        g2.setColor(this._selectColor1);
                        g2.drawLine(x + 3, y + h2 - 1, x + w - 3, y + h2 - 1);
                        g2.drawLine(x + 2, y + h2 - 2, x + 2, y + h2 - 2);
                        g2.drawLine(x + 1, y + h2 - 3, x + 1, y + h2 - 3);
                        g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                        g2.drawLine(x + w - 1, y + h2 - 3, x + w - 1, y + h2 - 3);
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x + 3, y + h2 - 2, x + w - 3, y + h2 - 2);
                        g2.drawLine(x + 2, y + h2 - 3, x + w - 2, y + h2 - 3);
                        g2.setColor(this._selectColor3);
                        g2.drawLine(x + 1, y, x + 1, y + h2 - 4);
                        g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 4);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        x -= 2;
                    }
                    g2.setColor(this._selectColor3);
                    g2.drawLine(x + 3, y + h2 - 1, x + w - 2, y + h2 - 1);
                    g2.drawLine(x + w - 1, y + h2 - 2, x + w - 1, y + h2 - 2);
                    g2.drawLine(x + w, y + h2 - 3, x + w, y);
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + 2, y + h2 - 2, x + 2, y + h2 - 2);
                    g2.drawLine(x + 1, y + h2 - 3, x + 1, y);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + 3, y + h2 - 2, x + w - 2, y + h2 - 2);
                    g2.drawLine(x + w - 1, y + h2 - 3, x + w - 1, y);
                    break;
                }
                default: {
                    if (this.getColorTheme() == 4) {
                        g2.setColor(this._selectColor1);
                        g2.drawLine(x + 3, y, x + w - 3, y);
                        g2.drawLine(x + 2, y + 1, x + 2, y + 1);
                        g2.drawLine(x + 1, y + 2, x + 1, y + 2);
                        g2.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                        g2.drawLine(x + w - 1, y + 2, x + w - 1, y + 2);
                        g2.setColor(this._selectColor2);
                        g2.drawLine(x + 3, y + 1, x + w - 3, y + 1);
                        g2.drawLine(x + 2, y + 2, x + w - 2, y + 2);
                        g2.setColor(this._selectColor3);
                        g2.drawLine(x + 1, y + 3, x + 1, y + h2 - 1);
                        g2.drawLine(x + w - 1, y + 3, x + w - 1, y + h2 - 1);
                        break;
                    }
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        --x;
                    }
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + 2, y + 1, x + 2, y + 1);
                    g2.drawLine(x + 1, y + 2, x + 1, y + h2 - 1);
                    g2.drawLine(x + 3, y, x + w - 2, y);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + w - 1, y + 1, x + w - 1, y + h2 - 1);
                    g2.setColor(this._selectColor3);
                    g2.drawLine(x + w - 1, y + 1, x + w - 1, y + 1);
                    g2.drawLine(x + w, y + 2, x + w, y + h2 - 1);
                }
            }
        }
    }

    protected void paintVsnetTabBorder(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (tabPlacement) {
            case 2: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y, x + w - 1, y);
                    g2.drawLine(x, y, x, y + h2 - 2);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
                    break;
                }
                g2.setColor(this._unselectColor1);
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.drawLine(x + 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                g2.drawLine(x + 2, y, x + w - 2, y);
                break;
            }
            case 4: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y, x + w - 1, y);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 2);
                    g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
                    break;
                }
                g2.setColor(this._unselectColor1);
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.drawLine(x + 1, y + h2 - 2, x + w - 3, y + h2 - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                g2.drawLine(x + 1, y, x + w - 3, y);
                break;
            }
            case 3: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y, x, y + h2 - 1);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
                    g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 2);
                    break;
                }
                g2.setColor(this._unselectColor1);
                if (leftToRight) {
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h2 - 2);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                    g2.drawLine(x, y + 2, x, y + h2 - 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.drawLine(x, y + 2, x, y + h2 - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == this._tabPane.getTabCount() - 1) break;
                g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h2 - 2);
                break;
            }
            default: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y + 1, x, y + h2 - 1);
                    g2.drawLine(x, y, x + w - 1, y);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
                    break;
                }
                g2.setColor(this._unselectColor1);
                if (leftToRight) {
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h2 - 2);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                    g2.drawLine(x, y + 2, x, y + h2 - 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.drawLine(x, y + 2, x, y + h2 - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == this._tabPane.getTabCount() - 1) break;
                g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h2 - 2);
            }
        }
    }

    protected void paintRoundedVsnetTabBorder(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (tabPlacement) {
            case 2: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + 2, y, x + w - 1, y);
                    g2.drawLine(x + 1, y + 1, x + 1, y + 1);
                    g2.drawLine(x, y + 2, x, y + h2 - 3);
                    g2.drawLine(x + 1, y + h2 - 2, x + 1, y + h2 - 2);
                    g2.drawLine(x + 2, y + h2 - 1, x + w - 1, y + h2 - 1);
                    break;
                }
                g2.setColor(this._unselectColor1);
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.drawLine(x + 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                g2.drawLine(x + 2, y + 1, x + w - 2, y + 1);
                break;
            }
            case 4: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y, x + w - 3, y);
                    g2.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 3);
                    g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                    g2.drawLine(x, y + h2 - 1, x + w - 3, y + h2 - 1);
                    break;
                }
                g2.setColor(this._unselectColor1);
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.drawLine(x + 1, y + h2 - 2, x + w - 3, y + h2 - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                g2.drawLine(x + 1, y + 1, x + w - 3, y + 1);
                break;
            }
            case 3: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y, x, y + h2 - 3);
                    g2.drawLine(x + 1, y + h2 - 2, x + 1, y + h2 - 2);
                    g2.drawLine(x + 2, y + h2 - 1, x + w - 3, y + h2 - 1);
                    g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                    g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 3);
                    break;
                }
                g2.setColor(this._unselectColor1);
                if (leftToRight) {
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h2 - 2);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                    g2.drawLine(x, y + 2, x, y + h2 - 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.drawLine(x, y + 2, x, y + h2 - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == this._tabPane.getTabCount() - 1) break;
                g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h2 - 2);
                break;
            }
            default: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y + 2, x, y + h2 - 1);
                    g2.drawLine(x, y + 2, x + 2, y);
                    g2.drawLine(x + 2, y, x + w - 3, y);
                    g2.drawLine(x + w - 3, y, x + w - 1, y + 2);
                    g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 1);
                    break;
                }
                g2.setColor(this._unselectColor1);
                if (leftToRight) {
                    if (tabIndex > this._tabPane.getSelectedIndex()) {
                        g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h2 - 2);
                        break;
                    }
                    if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == 0) break;
                    g2.drawLine(x, y + 2, x, y + h2 - 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.drawLine(x, y + 2, x, y + h2 - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex() || tabIndex == this._tabPane.getTabCount() - 1) break;
                g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h2 - 2);
            }
        }
    }

    protected void paintFlatTabBorder(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        switch (tabPlacement) {
            case 2: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawRect(x, y, w, h2);
                    break;
                }
                g2.setColor(this._unselectColor1);
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g2.drawRect(x, y, w, h2 - 1);
                        break;
                    }
                    g2.drawRect(x, y, w, h2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g2.drawRect(x, y, w, h2);
                break;
            }
            case 4: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawRect(x - 1, y, w, h2);
                    break;
                }
                g2.setColor(this._unselectColor1);
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g2.drawRect(x - 1, y, w, h2 - 1);
                        break;
                    }
                    g2.drawRect(x - 1, y, w, h2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g2.drawRect(x - 1, y, w, h2);
                break;
            }
            case 3: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawRect(x, y - 1, w, h2);
                    break;
                }
                g2.setColor(this._unselectColor1);
                g2.drawRect(x, y - 1, w, h2);
                break;
            }
            default: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawRect(x, y, w, h2);
                    break;
                }
                g2.setColor(this._unselectColor1);
                g2.drawRect(x, y, w, h2);
            }
        }
    }

    protected void paintRoundedFlatTabBorder(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        switch (tabPlacement) {
            case 2: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x + 2, y, x + w - 1, y);
                    g2.drawLine(x + 2, y + h2, x + w - 1, y + h2);
                    g2.drawLine(x, y + 2, x, y + h2 - 2);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + 1, y + 1, x + 1, y + 1);
                    g2.drawLine(x + 1, y + h2 - 1, x + 1, y + h2 - 1);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 2, y, x + w - 1, y);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g2.drawLine(x + 2, y + h2 - 1, x + w - 1, y + h2 - 1);
                        g2.drawLine(x, y + 2, x, y + h2 - 3);
                    } else {
                        g2.drawLine(x + 2, y + h2, x + w - 1, y + h2);
                        g2.drawLine(x, y + 2, x, y + h2 - 2);
                    }
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x + 1, y + 1, x + 1, y + 1);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g2.drawLine(x, y + h2 - 2, x, y + h2 - 2);
                        g2.drawLine(x + 1, y + h2 - 1, x + 1, y + h2 - 1);
                        break;
                    }
                    g2.drawLine(x, y + h2 - 1, x, y + h2 - 1);
                    g2.drawLine(x + 1, y + h2, x + 1, y + h2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g2.setColor(this._unselectColor1);
                g2.drawLine(x + 2, y, x + w - 1, y);
                g2.drawLine(x + 2, y + h2, x + w - 1, y + h2);
                g2.drawLine(x, y + 2, x, y + h2 - 2);
                g2.setColor(this._unselectColor2);
                g2.drawLine(x + 1, y + 1, x + 1, y + 1);
                g2.drawLine(x + 1, y + h2 - 1, x + 1, y + h2 - 1);
                break;
            }
            case 4: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y, x + w - 3, y);
                    g2.drawLine(x, y + h2, x + w - 3, y + h2);
                    g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 2);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    g2.drawLine(x + w - 2, y + h2 - 1, x + w - 2, y + h2 - 1);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x, y, x + w - 3, y);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g2.drawLine(x, y + h2 - 1, x + w - 3, y + h2 - 1);
                        g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 3);
                    } else {
                        g2.drawLine(x, y + h2, x + w - 3, y + h2);
                        g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 2);
                    }
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                        break;
                    }
                    g2.drawLine(x + w - 2, y + h2 - 1, x + w - 2, y + h2 - 1);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g2.setColor(this._unselectColor1);
                g2.drawLine(x, y, x + w - 3, y);
                g2.drawLine(x, y + h2, x + w - 3, y + h2);
                g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 2);
                g2.setColor(this._unselectColor2);
                g2.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                g2.drawLine(x + w - 2, y + h2 - 1, x + w - 2, y + h2 - 1);
                break;
            }
            case 3: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y, x, y + h2 - 3);
                    g2.drawLine(x + 2, y + h2 - 1, x + w - 2, y + h2 - 1);
                    g2.drawLine(x + w, y, x + w, y + h2 - 3);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x + 1, y + h2 - 2, x + 1, y + h2 - 2);
                    g2.drawLine(x + w - 1, y + h2 - 2, x + w - 1, y + h2 - 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x, y, x, y + h2 - 3);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g2.drawLine(x + 2, y + h2 - 1, x + w - 3, y + h2 - 1);
                        g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 3);
                    } else {
                        g2.drawLine(x + 2, y + h2 - 1, x + w - 2, y + h2 - 1);
                        g2.drawLine(x + w, y, x + w, y + h2 - 3);
                    }
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x + 1, y + h2 - 2, x + 1, y + h2 - 2);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g2.drawLine(x + w - 2, y + h2 - 2, x + w - 2, y + h2 - 2);
                        break;
                    }
                    g2.drawLine(x + w - 1, y + h2 - 2, x + w - 1, y + h2 - 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g2.setColor(this._unselectColor1);
                g2.drawLine(x, y, x, y + h2 - 3);
                g2.drawLine(x + 2, y + h2 - 1, x + w - 2, y + h2 - 1);
                g2.drawLine(x + w, y, x + w, y + h2 - 3);
                g2.setColor(this._unselectColor2);
                g2.drawLine(x + 1, y + h2 - 2, x + 1, y + h2 - 2);
                g2.drawLine(x + w - 1, y + h2 - 2, x + w - 1, y + h2 - 2);
                break;
            }
            default: {
                if (isSelected) {
                    g2.setColor(this._selectColor1);
                    g2.drawLine(x, y + h2 - 1, x, y + 2);
                    g2.drawLine(x + 2, y, x + w - 2, y);
                    g2.drawLine(x + w, y + 2, x + w, y + h2 - 1);
                    g2.setColor(this._selectColor2);
                    g2.drawLine(x, y + 2, x + 2, y);
                    g2.drawLine(x + w - 2, y, x + w, y + 2);
                    break;
                }
                if (tabIndex > this._tabPane.getSelectedIndex()) {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x, y + h2 - 1, x, y + 2);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g2.drawLine(x + 2, y, x + w - 3, y);
                        g2.drawLine(x + w - 1, y + 2, x + w - 1, y + h2 - 1);
                    } else {
                        g2.drawLine(x + 2, y, x + w - 2, y);
                        g2.drawLine(x + w, y + 2, x + w, y + h2 - 1);
                    }
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x, y + 2, x + 2, y);
                    if (tabIndex == this._tabPane.getTabCount() - 1) {
                        g2.drawLine(x + w - 3, y, x + w - 1, y + 2);
                        break;
                    }
                    g2.drawLine(x + w - 2, y, x + w, y + 2);
                    break;
                }
                if (tabIndex >= this._tabPane.getSelectedIndex()) break;
                g2.setColor(this._unselectColor1);
                g2.drawLine(x, y + h2 - 1, x, y + 2);
                g2.drawLine(x + 2, y, x + w - 2, y);
                g2.drawLine(x + w, y + 2, x + w, y + h2 - 1);
                g2.setColor(this._unselectColor2);
                g2.drawLine(x, y + 2, x + 2, y);
                g2.drawLine(x + w - 2, y, x + w, y + 2);
            }
        }
    }

    protected void paintBoxTabBorder(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        if (isSelected) {
            g2.setColor(this._selectColor1);
            g2.drawLine(x, y, x + w - 2, y);
            g2.drawLine(x, y, x, y + h2 - 2);
            g2.setColor(this._selectColor2);
            g2.drawLine(x + w - 1, y, x + w - 1, y + h2 - 1);
            g2.drawLine(x, y + h2 - 1, x + w - 1, y + h2 - 1);
        } else if (tabIndex != this._tabPane.getSelectedIndex() - 1) {
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x + 2, y + h2, x + w - 2, y + h2);
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x + 2, y + h2 + 1, x + w - 2, y + h2 + 1);
                    break;
                }
                default: {
                    if (leftToRight) {
                        g2.setColor(this._unselectColor1);
                        g2.drawLine(x + w, y + 2, x + w, y + h2 - 2);
                        g2.setColor(this._unselectColor2);
                        g2.drawLine(x + w + 1, y + 2, x + w + 1, y + h2 - 2);
                        break;
                    }
                    g2.setColor(this._unselectColor1);
                    g2.drawLine(x, y + 2, x, y + h2 - 2);
                    g2.setColor(this._unselectColor2);
                    g2.drawLine(x + 1, y + 2, x + 1, y + h2 - 2);
                }
            }
        }
    }

    protected void paintTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        switch (this.getTabShape()) {
            case 3: {
                this.paintButtonTabBackground(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 8: {
                this.paintExcelTabBackground(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 1: {
                this.paintDefaultTabBackground(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 11: {
                if (!isSelected) break;
                this.paintDefaultTabBackground(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 2: 
            case 9: {
                this.paintVsnetTabBackground(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            case 5: 
            case 10: {
                this.paintFlatTabBackground(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
                break;
            }
            default: {
                this.paintOffice2003TabBackground(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
            }
        }
    }

    protected void paintOffice2003TabBackground(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (tabPlacement) {
            case 2: {
                if (tabIndex != 0 && !isSelected) {
                    int[] xp = new int[]{x + w, x + 4, x + 2, x, x, x + 3, x + w};
                    int[] yp = new int[]{y, y, y + 2, y + 5, y + h2 - 5, y + h2 - 2, y + h2 - 2};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x + w, x + 2, x, x, x + 3, x + w};
                int[] yp = new int[]{y - w + 2 + 2, y + 2, y + 5, y + h2 - 5, y + h2 - 2, y + h2 - 2};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            case 4: {
                if (tabIndex != 0 && !isSelected) {
                    int[] xp = new int[]{x, x + w - 4, x + w - 3, x + w - 1, x + w - 1, x + w - 3, x};
                    int[] yp = new int[]{y, y, y + 2, y + 5, y + h2 - 5, y + h2 - 2, y + h2 - 2};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x, x + w - 3, x + w - 1, x + w - 1, x + w - 3, x};
                int[] yp = new int[]{y - w + 2 + 2, y + 2, y + 5, y + h2 - 5, y + h2 - 2, y + h2 - 2};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            case 3: {
                if (leftToRight) {
                    int[] xp = new int[]{x - (tabIndex == 0 || isSelected ? h2 - 5 : 0), x, x + 4, x + w - 3, x + w - 1, x + w - 1};
                    int[] yp = new int[]{y, y + h2 - 5, y + h2 - 1, y + h2 - 1, y + h2 - 5, y};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x, x, x + 2, x + w - 5, x + w - 1, x + w - 1 + (tabIndex == 0 || isSelected ? h2 - 5 : 0)};
                int[] yp = new int[]{y, y + h2 - 5, y + h2 - 1, y + h2 - 1, y + h2 - 5, y};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            default: {
                if (leftToRight) {
                    int[] xp = new int[]{x - (tabIndex == 0 || isSelected ? h2 - 5 : 0), x, x + 4, x + w - 3, x + w - 1, x + w - 1};
                    int[] yp = new int[]{y + h2, y + 3, y + 1, y + 1, y + 3, y + h2};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x, x, x + 2, x + w - 5, x + w - 1, x + w - 1 + (tabIndex == 0 || isSelected ? h2 - 5 : 0)};
                int[] yp = new int[]{y + h2, y + 3, y + 1, y + 1, y + 3, y + h2};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
            }
        }
    }

    protected void paintExcelTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (tabPlacement) {
            case 2: {
                if (!isSelected) {
                    if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                        int[] xp = new int[]{x + w, x, x, x + w};
                        int[] yp = new int[]{y - 5, y + 5, y + h2 - 5, y + h2 + 6};
                        int np = yp.length;
                        this.tabRegion = new Polygon(xp, yp, np);
                        break;
                    }
                    int[] xp = new int[]{x + w, x + 9, x, x, x + w};
                    int[] yp = new int[]{y + 8, y + 2, y + 6, y + h2 - 5, y + h2 + 6};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x + w, x, x, x + w};
                int[] yp = new int[]{y - 5, y + 5, y + h2 - 5, y + h2 + 6};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            case 4: {
                if (!isSelected) {
                    if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                        int[] xp = new int[]{x, x + w - 1, x + w - 1, x};
                        int[] yp = new int[]{y - 5, y + 5, y + h2 - 5, y + h2 + 6};
                        int np = yp.length;
                        this.tabRegion = new Polygon(xp, yp, np);
                        break;
                    }
                    int[] xp = new int[]{x, x + w - 10, x + w - 1, x + w - 1, x};
                    int[] yp = new int[]{y + 8, y + 2, y + 6, y + h2 - 5, y + h2 + 6};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x, x + w - 1, x + w - 1, x};
                int[] yp = new int[]{y - 5, y + 5, y + h2 - 4, y + h2 + 6};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            case 3: {
                if (!isSelected) {
                    if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                        int[] xp = new int[]{x - 5, x + 5, x + w - 5, x + w + 5};
                        int[] yp = new int[]{y, y + h2 - 1, y + h2 - 1, y};
                        int np = yp.length;
                        this.tabRegion = new Polygon(xp, yp, np);
                        break;
                    }
                    int[] xp = new int[]{x + 7, x + 1, x + 5, x + w - 5, x + w + 5};
                    int[] yp = new int[]{y, y + h2 - 10, y + h2 - 1, y + h2 - 1, y};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x - 5, x + 5, x + w - 5, x + w + 5};
                int[] yp = new int[]{y, y + h2 - 1, y + h2 - 1, y};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            default: {
                if (!isSelected) {
                    if (leftToRight && tabIndex == 0 || !leftToRight && tabIndex == this._tabPane.getTabCount() - 1) {
                        int[] xp = new int[]{x - 6, x + 5, x + w - 5, x + w + 5};
                        int[] yp = new int[]{y + h2, y, y, y + h2};
                        int np = yp.length;
                        this.tabRegion = new Polygon(xp, yp, np);
                        break;
                    }
                    int[] xp = new int[]{x + 7, x + 1, x + 6, x + w - 5, x + w + 5};
                    int[] yp = new int[]{y + h2, y + 9, y, y, y + h2};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x - 6, x + 5, x + w - 5, x + w + 5};
                int[] yp = new int[]{y + h2, y, y, y + h2};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
            }
        }
    }

    protected void paintDefaultTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        switch (tabPlacement) {
            case 2: {
                if (isSelected) {
                    int[] xp = new int[]{++x + w, x, x - 2, x - 2, x + w};
                    int[] yp = new int[]{y - 1, y - 1, y + 1, y + h2 + 2, y + h2 + 2};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                if (tabIndex < this._tabPane.getSelectedIndex()) {
                    int[] xp = new int[]{x + w, x + 2, x, x, x + w};
                    int[] yp = new int[]{++y + 1, y + 1, y + 3, y + h2 - 1, y + h2 - 1};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x + w, x + 2, x, x, x + w};
                int[] yp = new int[]{y + 1, y + 1, y + 3, y + h2 - 2, y + h2 - 2};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            case 4: {
                if (isSelected) {
                    int[] xp = new int[]{x, x + w - 1, x + w, x + w, x};
                    int[] yp = new int[]{y - 1, y - 1, y + 1, y + h2 + 2, y + h2 + 2};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                if (tabIndex < this._tabPane.getSelectedIndex()) {
                    int[] xp = new int[]{x, x + w - 3, x + w - 1, x + w - 1, x};
                    int[] yp = new int[]{++y + 1, y + 1, y + 3, y + h2 - 1, y + h2 - 1};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x, x + w - 2, x + w - 1, x + w - 1, x};
                int[] yp = new int[]{y + 1, y + 1, y + 3, y + h2 - 2, y + h2 - 2};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            case 3: {
                if (isSelected) {
                    int[] xp = new int[]{x, x, x + 2, x + w + 2, x + w + 2};
                    int[] yp = new int[]{y + h2, y, y - 2, y - 2, y + h2};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x + 1, x + 1, x + 1, x + w - 1, x + w - 1};
                int[] yp = new int[]{y + h2 - 1, y + 2, y, y, y + h2 - 1};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
                break;
            }
            default: {
                if (isSelected) {
                    int[] xp = new int[]{x, x, x + 2, x + w + 2, x + w + 2};
                    int[] yp = new int[]{y + h2 + 1, y, y - 2, y - 2, y + h2 + 1};
                    int np = yp.length;
                    this.tabRegion = new Polygon(xp, yp, np);
                    break;
                }
                int[] xp = new int[]{x + 1, x + 1, x + 3, x + w - 1, x + w - 1};
                int[] yp = new int[]{y + h2, y + 2, y, y, y + h2};
                int np = yp.length;
                this.tabRegion = new Polygon(xp, yp, np);
            }
        }
    }

    protected void paintTabBackgroundMouseOver(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected, Color backgroundUnselectedColorStart, Color backgroundUnselectedColorEnd) {
        Graphics2D g2d = (Graphics2D)g2;
        switch (tabPlacement) {
            case 2: {
                Polygon polygon;
                if (tabIndex < this._tabPane.getSelectedIndex()) {
                    int[] xp = new int[]{x + w, x + 2, x, x, x + 2, x + w};
                    int[] yp = new int[]{y + 2, y + 2, y + 4, y + h2 - 1, y + h2, y + h2};
                    int np = yp.length;
                    polygon = new Polygon(xp, yp, np);
                } else {
                    int[] xp = new int[]{x + w, x + 2, x, x, x + 2, x + w};
                    int[] yp = new int[]{y + 1, y + 1, y + 3, y + h2 - 3, y + h2 - 2, y + h2 - 2};
                    int np = yp.length;
                    polygon = new Polygon(xp, yp, np);
                }
                JideSwingUtilities.fillGradient(g2d, polygon, backgroundUnselectedColorStart, backgroundUnselectedColorEnd, false);
                break;
            }
            case 4: {
                Polygon polygon;
                if (tabIndex < this._tabPane.getSelectedIndex()) {
                    int[] xp = new int[]{x, x + w - 3, x + w - 1, x + w - 1, x + w - 3, x};
                    int[] yp = new int[]{y + 2, y + 2, y + 4, y + h2 - 1, y + h2, y + h2};
                    int np = yp.length;
                    polygon = new Polygon(xp, yp, np);
                } else {
                    int[] xp = new int[]{x, x + w - 2, x + w - 1, x + w - 1, x + w - 3, x};
                    int[] yp = new int[]{y + 1, y + 1, y + 3, y + h2 - 3, y + h2 - 2, y + h2 - 2};
                    int np = yp.length;
                    polygon = new Polygon(xp, yp, np);
                }
                JideSwingUtilities.fillGradient(g2d, polygon, backgroundUnselectedColorEnd, backgroundUnselectedColorStart, false);
                break;
            }
            case 3: {
                int[] xp = new int[]{x + 1, x + 1, x + 1, x + w - 1, x + w - 1};
                int[] yp = new int[]{y + h2 - 2, y + 2, y, y, y + h2 - 2};
                int np = yp.length;
                Polygon polygon = new Polygon(xp, yp, np);
                JideSwingUtilities.fillGradient(g2d, polygon, backgroundUnselectedColorEnd, backgroundUnselectedColorStart, true);
                break;
            }
            default: {
                int[] xp1 = new int[]{x + 1, x + 1, x + 3, x + w - 1, x + w - 1};
                int[] yp1 = new int[]{y + h2, y + 2, y, y, y + h2};
                int np1 = yp1.length;
                Polygon polygon = new Polygon(xp1, yp1, np1);
                JideSwingUtilities.fillGradient(g2d, polygon, backgroundUnselectedColorStart, backgroundUnselectedColorEnd, true);
            }
        }
    }

    protected void paintVsnetTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        int[] yp;
        int[] xp;
        switch (tabPlacement) {
            case 2: {
                xp = new int[]{x + 1, x + 1, x + w, x + w};
                yp = new int[]{y + h2 - 1, y + 1, y + 1, y + h2 - 1};
                break;
            }
            case 4: {
                xp = new int[]{x, x, x + w - 1, x + w - 1};
                yp = new int[]{y + h2 - 1, y + 1, y + 1, y + h2 - 1};
                break;
            }
            case 3: {
                xp = new int[]{x + 1, x + 1, x + w - 1, x + w - 1};
                yp = new int[]{y + h2 - 1, y, y, y + h2 - 1};
                break;
            }
            default: {
                xp = new int[]{x + 1, x + 1, x + w - 1, x + w - 1};
                yp = new int[]{y + h2, y + 1, y + 1, y + h2};
            }
        }
        int np = yp.length;
        this.tabRegion = new Polygon(xp, yp, np);
    }

    protected void paintFlatTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        switch (tabPlacement) {
            case 2: {
                int[] xp1 = new int[]{x + 1, x + 1, x + w, x + w};
                int[] yp1 = new int[]{y + h2, y + 1, y + 1, y + h2};
                int np1 = yp1.length;
                this.tabRegion = new Polygon(xp1, yp1, np1);
                break;
            }
            case 4: {
                int[] xp2 = new int[]{x, x, x + w - 1, x + w - 1};
                int[] yp2 = new int[]{y + h2, y + 1, y + 1, y + h2};
                int np2 = yp2.length;
                this.tabRegion = new Polygon(xp2, yp2, np2);
                break;
            }
            case 3: {
                int[] xp3 = new int[]{x + 1, x + 1, x + w, x + w};
                int[] yp3 = new int[]{y + h2 - 1, y, y, y + h2 - 1};
                int np3 = yp3.length;
                this.tabRegion = new Polygon(xp3, yp3, np3);
                break;
            }
            default: {
                int[] xp4 = new int[]{x, x + 1, x + w, x + w};
                int[] yp4 = new int[]{y + h2, y + 1, y + 1, y + h2};
                int np4 = yp4.length;
                this.tabRegion = new Polygon(xp4, yp4, np4);
            }
        }
    }

    protected void paintButtonTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        int[] xp = new int[]{x, x, x + w, x + w};
        int[] yp = new int[]{y + h2, y, y, y + h2};
        int np = yp.length;
        this.tabRegion = new Polygon(xp, yp, np);
    }

    protected void paintContentBorder(Graphics g2, int tabPlacement, int selectedIndex) {
        int width = this._tabPane.getWidth();
        int height = this._tabPane.getHeight();
        Insets insets = this._tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h2 = height - insets.top - insets.bottom;
        Dimension lsize = new Dimension(0, 0);
        Dimension tsize = new Dimension(0, 0);
        if (this.isTabLeadingComponentVisible()) {
            lsize = this._tabLeadingComponent.getPreferredSize();
        }
        if (this.isTabTrailingComponentVisible()) {
            tsize = this._tabTrailingComponent.getPreferredSize();
        }
        switch (tabPlacement) {
            case 2: {
                int tabAreaWidth = this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth);
                if (this.isTabLeadingComponentVisible() && lsize.width > tabAreaWidth) {
                    tabAreaWidth = lsize.width;
                }
                if (this.isTabTrailingComponentVisible() && tsize.width > tabAreaWidth) {
                    tabAreaWidth = tsize.width;
                }
                if (this.scrollableTabLayoutEnabled()) {
                    this.paintTabAreaBackground(g2, new Rectangle(x, y, tabAreaWidth, h2), tabPlacement);
                }
                w -= (x += tabAreaWidth) - insets.left;
                break;
            }
            case 4: {
                int areaWidth = this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth);
                if (this.scrollableTabLayoutEnabled()) {
                    this.paintTabAreaBackground(g2, new Rectangle(x, y, areaWidth, h2), tabPlacement);
                }
                w -= areaWidth;
                break;
            }
            case 3: {
                int areaHeight = this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight);
                if (this.scrollableTabLayoutEnabled()) {
                    this.paintTabAreaBackground(g2, new Rectangle(x, y, w, areaHeight), tabPlacement);
                }
                h2 -= areaHeight;
                break;
            }
            default: {
                int tabAreaHeight = this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight);
                if (this.isTabLeadingComponentVisible() && lsize.height > tabAreaHeight) {
                    tabAreaHeight = lsize.height;
                }
                if (this.isTabTrailingComponentVisible() && tabAreaHeight < tsize.height) {
                    tabAreaHeight = tsize.height;
                }
                if (this.scrollableTabLayoutEnabled()) {
                    this.paintTabAreaBackground(g2, new Rectangle(x, y, w, tabAreaHeight), tabPlacement);
                }
                h2 -= (y += tabAreaHeight) - insets.top;
            }
        }
        if (this.getTabShape() != 3) {
            this.paintContentBorder(g2, x, y, w, h2);
            switch (tabPlacement) {
                case 2: {
                    this.paintContentBorderLeftEdge(g2, tabPlacement, selectedIndex, x, y, w, h2);
                    break;
                }
                case 4: {
                    this.paintContentBorderRightEdge(g2, tabPlacement, selectedIndex, x, y, w, h2);
                    break;
                }
                case 3: {
                    this.paintContentBorderBottomEdge(g2, tabPlacement, selectedIndex, x, y, w, h2);
                    break;
                }
                default: {
                    this.paintContentBorderTopEdge(g2, tabPlacement, selectedIndex, x, y, w, h2);
                }
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g2, int tabPlacement, int selectedIndex, int x, int y, int w, int h2) {
    }

    protected void paintContentBorderRightEdge(Graphics g2, int tabPlacement, int selectedIndex, int x, int y, int w, int h2) {
    }

    protected void paintContentBorder(Graphics g2, int x, int y, int w, int h2) {
        if (this._tabPane.isOpaque()) {
            g2.setColor(this._tabBackground);
            g2.fillRect(x, y, w, h2);
        }
    }

    protected Color getBorderEdgeColor() {
        if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
            return this._shadow;
        }
        return this._lightHighlight;
    }

    protected void paintContentBorderTopEdge(Graphics g2, int tabPlacement, int selectedIndex, int x, int y, int w, int h2) {
        if (selectedIndex < 0) {
            return;
        }
        if (!this._tabPane.isTabShown()) {
            return;
        }
        Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
        g2.setColor(this.getBorderEdgeColor());
        if (tabPlacement != 1 || selectedIndex < 0 || selRect.x < x || selRect.x > x + w) {
            g2.drawLine(x, y, x + w - 1, y);
        } else {
            g2.drawLine(x, y, selRect.x, y);
            if (!this.getBorderEdgeColor().equals(this._lightHighlight)) {
                if (selRect.x + selRect.width < x + w - 2) {
                    g2.drawLine(selRect.x + selRect.width - 1, y, selRect.x + selRect.width - 1, y);
                    g2.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
                } else {
                    g2.drawLine(x + w - 2, y, x + w - 1, y);
                }
            } else if (selRect.x + selRect.width < x + w - 2) {
                g2.setColor(this._darkShadow);
                g2.drawLine(selRect.x + selRect.width - 1, y, selRect.x + selRect.width - 1, y);
                g2.setColor(this._lightHighlight);
                g2.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
            } else {
                g2.setColor(this._selectedColor == null ? this._tabPane.getBackground() : this._selectedColor);
                g2.drawLine(x + w - 2, y, x + w - 1, y);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g2, int tabPlacement, int selectedIndex, int x, int y, int w, int h2) {
        if (selectedIndex < 0) {
            return;
        }
        if (!this._tabPane.isTabShown()) {
            return;
        }
        Rectangle selRect = this.getTabBounds(selectedIndex, this._calcRect);
        if (tabPlacement != 3 || selectedIndex < 0 || selRect.x < x || selRect.x > x + w) {
            g2.setColor(this.getBorderEdgeColor());
            g2.drawLine(x, y + h2 - 1, x + w - 2, y + h2 - 1);
        } else if (!this.getBorderEdgeColor().equals(this._lightHighlight)) {
            g2.setColor(this.getBorderEdgeColor());
            g2.drawLine(x, y + h2 - 1, selRect.x - 1, y + h2 - 1);
            g2.drawLine(selRect.x, y + h2 - 1, selRect.x, y + h2 - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g2.drawLine(selRect.x + selRect.width - 1, y + h2 - 1, x + w - 2, y + h2 - 1);
            }
        } else {
            g2.setColor(this._darkShadow);
            g2.drawLine(x, y + h2 - 1, selRect.x - 1, y + h2 - 1);
            g2.setColor(this._lightHighlight);
            g2.drawLine(selRect.x, y + h2 - 1, selRect.x, y + h2 - 1);
            if (selRect.x + selRect.width < x + w - 2) {
                g2.setColor(this._darkShadow);
                g2.drawLine(selRect.x + selRect.width - 1, y + h2 - 1, x + w - 2, y + h2 - 1);
            }
        }
    }

    protected void ensureCurrentLayout() {
        if (!this._tabPane.isValid()) {
            TabbedPaneLayout layout = (TabbedPaneLayout)this._tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    private void updateCloseButtons() {
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab()) {
            for (int i = 0; i < this._closeButtons.length; ++i) {
                Rectangle bounds;
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (i != this._tabPane.getSelectedIndex()) {
                        this._closeButtons[i].setBounds(0, 0, 0, 0);
                        continue;
                    }
                } else if (i >= this._rects.length) {
                    this._closeButtons[i].setBounds(0, 0, 0, 0);
                    continue;
                }
                if (!this._tabPane.isTabClosableAt(i)) {
                    this._closeButtons[i].setBounds(0, 0, 0, 0);
                    continue;
                }
                Dimension size = this._closeButtons[i].getPreferredSize();
                if (this._closeButtonAlignment == 11) {
                    if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
                        if (leftToRight) {
                            bounds = new Rectangle(this._rects[i].x + this._rects[i].width - size.width - this._closeButtonRightMargin, this._rects[i].y + (this._rects[i].height - size.height) / 2, size.width, size.height);
                            bounds.x -= this.getTabGap();
                            if (i > this._tabPane.getSelectedIndex() && (9 == this._tabPane.getTabShape() || 2 == this._tabPane.getTabShape())) {
                                --bounds.x;
                            }
                        } else {
                            bounds = new Rectangle(this._rects[i].x + this._closeButtonLeftMargin + this.getTabGap(), this._rects[i].y + (this._rects[i].height - size.height) / 2, size.width, size.height);
                        }
                    } else {
                        bounds = new Rectangle(this._rects[i].x + (this._rects[i].width - size.width) / 2, this._rects[i].y + this._rects[i].height - size.height - this._closeButtonRightMargin, size.width, size.height);
                        bounds.y -= this.getTabGap();
                    }
                } else if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
                    if (leftToRight) {
                        bounds = new Rectangle(this._rects[i].x + this._closeButtonLeftMargin + this.getTabGap(), this._rects[i].y + (this._rects[i].height - size.height) / 2, size.width, size.height);
                    } else {
                        bounds = new Rectangle(this._rects[i].x + this._rects[i].width - size.width - this._closeButtonRightMargin, this._rects[i].y + (this._rects[i].height - size.height) / 2, size.width, size.height);
                        bounds.x -= this.getTabGap();
                    }
                } else {
                    bounds = this._tabPane.getTabPlacement() == 2 ? new Rectangle(this._rects[i].x + (this._rects[i].width - size.width) / 2, this._rects[i].y + this._closeButtonLeftMargin, size.width, size.height) : new Rectangle(this._rects[i].x + (this._rects[i].width - size.width) / 2 - 2, this._rects[i].y + this._closeButtonLeftMargin, size.width, size.height);
                }
                if (this._closeButtons[i] instanceof JideTabbedPane.NoFocusButton) {
                    ((JideTabbedPane.NoFocusButton)this._closeButtons[i]).setIndex(i);
                }
                if (!bounds.equals(this._closeButtons[i].getBounds())) {
                    this._closeButtons[i].setBounds(bounds);
                }
                if (this._tabPane.getSelectedIndex() == i) {
                    this._closeButtons[i].setBackground(this._selectedColor == null ? this._tabPane.getBackgroundAt(i) : this._selectedColor);
                    continue;
                }
                this._closeButtons[i].setBackground(this._tabPane.getBackgroundAt(i));
            }
        }
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        this.ensureCurrentLayout();
        Rectangle tabRect = new Rectangle();
        return this.getTabBounds(i, tabRect);
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        this.ensureCurrentLayout();
        return this._runCount;
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        Component[] components;
        this.ensureCurrentLayout();
        Point p = new Point(x, y);
        if (!this._tabPane.isShowTabArea()) {
            return -1;
        }
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(x, y, p);
        }
        int tabCount = this._tabPane.getTabCount();
        boolean horizontalTab = this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3;
        boolean isRTL = horizontalTab && !this._tabPane.getComponentOrientation().isLeftToRight();
        int firstButtonPos = isRTL ? 0 : Integer.MAX_VALUE;
        for (Component component : components = this._tabPane.getComponents()) {
            if (!(component instanceof JideTabbedPane.NoFocusButton) || !component.isVisible()) continue;
            Rectangle bounds = component.getBounds();
            if (horizontalTab && bounds.x != 0) {
                if (isRTL) {
                    firstButtonPos = Math.max(firstButtonPos, bounds.x);
                    continue;
                }
                firstButtonPos = Math.min(firstButtonPos, bounds.x);
                continue;
            }
            if (horizontalTab || bounds.y == 0) continue;
            firstButtonPos = Math.min(firstButtonPos, bounds.y);
        }
        if (this._tabPane.getTabTrailingComponent() != null && this._tabPane.getTabTrailingComponent().isVisible()) {
            Rectangle bounds = this._tabPane.getTabTrailingComponent().getBounds();
            if (horizontalTab && bounds.x != 0) {
                firstButtonPos = isRTL ? Math.max(firstButtonPos, bounds.x) : Math.min(firstButtonPos, bounds.x);
            } else if (!horizontalTab && bounds.y != 0) {
                firstButtonPos = Math.min(firstButtonPos, bounds.y);
            }
        }
        if (horizontalTab ? isRTL && x <= firstButtonPos || !isRTL && x >= firstButtonPos : y >= firstButtonPos) {
            return -1;
        }
        for (int i = 0; i < tabCount; ++i) {
            if (!this._rects[i].contains(p.x, p.y)) continue;
            return i;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        if (this._rects.length == 0) {
            return null;
        }
        if (tabIndex > this._rects.length - 1) {
            tabIndex = this._rects.length - 1;
        }
        if (tabIndex < 0) {
            tabIndex = 0;
        }
        dest.width = this._rects[tabIndex].width;
        dest.height = this._rects[tabIndex].height;
        if (this.scrollableTabLayoutEnabled()) {
            int tabPlacement = this._tabPane.getTabPlacement();
            Point vpp = this._tabScroller.viewport.getLocation();
            Point viewp = this._tabScroller.viewport.getViewPosition();
            dest.x = this._rects[tabIndex].x + vpp.x - ((tabPlacement == 1 || tabPlacement == 3) && !this._tabPane.getComponentOrientation().isLeftToRight() ? -viewp.x : viewp.x);
            dest.y = this._rects[tabIndex].y + vpp.y - viewp.y;
        } else {
            dest.x = this._rects[tabIndex].x;
            dest.y = this._rects[tabIndex].y;
        }
        return dest;
    }

    public int getTabAtLocation(int x, int y) {
        this.ensureCurrentLayout();
        int tabCount = this._tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!this._rects[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmptyTabArea(int x, int y) {
        int tabCount = this._tabPane.getTabCount();
        if (this.getTabAtLocation(x, y) >= 0 || tabCount <= 0) {
            return false;
        }
        int tabPlacement = this._tabPane.getTabPlacement();
        return tabPlacement == 1 || tabPlacement == 3 ? this._rects[0].contains(this._rects[0].x + 1, y) : this._rects[0].contains(x, this._rects[0].y + 1);
    }

    private int getClosestTab(int x, int y) {
        int tabCount;
        int min2 = 0;
        int max = tabCount = Math.min(this._rects.length, this._tabPane.getTabCount());
        int tabPlacement = this._tabPane.getTabPlacement();
        boolean useX = tabPlacement == 1 || tabPlacement == 3;
        int want = useX ? x : y;
        Rectangle[] rects = new Rectangle[this._rects.length];
        boolean needConvert = false;
        if (!useX || this._tabPane.getComponentOrientation().isLeftToRight()) {
            System.arraycopy(this._rects, 0, rects, 0, this._rects.length);
        } else {
            needConvert = true;
            for (int i = 0; i < this._rects.length; ++i) {
                rects[i] = new Rectangle(this._rects[this._rects.length - 1 - i]);
                if (i != this._rects.length - 1) continue;
                rects[i].width += this._additionalWidth;
            }
        }
        while (min2 != max) {
            int maxLoc;
            int minLoc;
            int current = max + min2 >> 1;
            if (useX) {
                minLoc = rects[current].x;
                maxLoc = minLoc + rects[current].width;
            } else {
                minLoc = rects[current].y;
                maxLoc = minLoc + rects[current].height;
            }
            if (want < minLoc) {
                max = current;
                if (min2 != max) continue;
                int tabIndex = Math.max(0, current - 1);
                return needConvert ? rects.length - 1 - tabIndex : tabIndex;
            }
            if (want >= maxLoc) {
                min2 = current;
                if (max - min2 > 1) continue;
                int tabIndex = Math.max(current + 1, tabCount - 1);
                return needConvert ? rects.length - 1 - tabIndex : tabIndex;
            }
            return needConvert ? rects.length - 1 - current : current;
        }
        return needConvert ? rects.length - 1 - min2 : min2;
    }

    private Point translatePointToTabPanel(int srcx, int srcy, Point dest) {
        Point vpp = this._tabScroller.viewport.getLocation();
        Point viewp = this._tabScroller.viewport.getViewPosition();
        dest.x = srcx - vpp.x + viewp.x;
        dest.y = srcy - vpp.y + viewp.y;
        return dest;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this._tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int tabCount) {
        int rectArrayLen = this._rects.length;
        if (tabCount != rectArrayLen) {
            Rectangle[] tempRectArray = new Rectangle[tabCount];
            System.arraycopy(this._rects, 0, tempRectArray, 0, Math.min(rectArrayLen, tabCount));
            this._rects = tempRectArray;
            for (int rectIndex = rectArrayLen; rectIndex < tabCount; ++rectIndex) {
                this._rects[rectIndex] = new Rectangle();
            }
        }
    }

    protected void expandTabRunsArray() {
        int rectLen = this._tabRuns.length;
        int[] newArray = new int[rectLen + 10];
        System.arraycopy(this._tabRuns, 0, newArray, 0, this._runCount);
        this._tabRuns = newArray;
    }

    protected int getRunForTab(int tabCount, int tabIndex) {
        for (int i = 0; i < this._runCount; ++i) {
            int first = this._tabRuns[i];
            int last = this.lastTabInRun(tabCount, i);
            if (tabIndex < first || tabIndex > last) continue;
            return i;
        }
        return 0;
    }

    protected int lastTabInRun(int tabCount, int run) {
        int nextRun;
        if (this._runCount == 1) {
            return tabCount - 1;
        }
        int n = nextRun = run == this._runCount - 1 ? 0 : run + 1;
        if (this._tabRuns[nextRun] == 0) {
            return tabCount - 1;
        }
        return this._tabRuns[nextRun] - 1;
    }

    protected int getTabRunOverlay(int tabPlacement) {
        return this._tabRunOverlay;
    }

    protected int getTabRunIndent(int tabPlacement, int run) {
        return 0;
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this._runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return true;
    }

    protected View getTextViewForTab(int tabIndex) {
        if (this.htmlViews != null && tabIndex < this.htmlViews.size()) {
            return (View)this.htmlViews.elementAt(tabIndex);
        }
        return null;
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, FontMetrics metrics) {
        Component c;
        int height = 0;
        Component component = c = SystemInfo.isJdk6Above() ? this._tabPane.getTabComponentAt(tabIndex) : null;
        if (c != null) {
            height = c.getPreferredSize().height;
            return height;
        }
        if (tabPlacement == 1 || tabPlacement == 3) {
            View v = this.getTextViewForTab(tabIndex);
            height = v != null ? (height += (int)v.getPreferredSpan(1)) : (height += metrics.getHeight());
            Icon icon = this._tabPane.getIconForTab(tabIndex);
            Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
            if (icon != null) {
                height = Math.max(height, icon.getIconHeight());
            }
            height += tabInsets.top + tabInsets.bottom + 2;
        } else {
            View v;
            Icon icon = this._tabPane.getIconForTab(tabIndex);
            Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
            height = tabInsets.top + tabInsets.bottom + 3;
            if (icon != null) {
                height += icon.getIconHeight() + this._textIconGap;
            }
            if ((v = this.getTextViewForTab(tabIndex)) != null) {
                height += (int)v.getPreferredSpan(0);
            } else {
                String title = this.getCurrentDisplayTitleAt(this._tabPane, tabIndex);
                height += SwingUtilities.computeStringWidth(metrics, title);
            }
            if (this._tabPane.isShowGripper()) {
                height += this._gripperHeight;
            }
            if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this._tabPane.isTabClosableAt(tabIndex)) {
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (this._tabPane.getSelectedIndex() == tabIndex) {
                        height += this._closeButtons[tabIndex].getPreferredSize().height + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                    }
                } else {
                    height += this._closeButtons[tabIndex].getPreferredSize().height + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                }
            }
        }
        return height;
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        int tabCount = this._tabPane.getTabCount();
        int result = 0;
        for (int i = 0; i < tabCount; ++i) {
            FontMetrics metrics = this.getFontMetrics(i);
            result = Math.max(this.calculateTabHeight(tabPlacement, i, metrics), result);
        }
        return result;
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int width = 0;
        if (tabPlacement == 1 || tabPlacement == 3) {
            View v;
            Component tabComponent;
            Icon icon = this._tabPane.getIconForTab(tabIndex);
            Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
            width = tabInsets.left + tabInsets.right + 3 + this.getTabGap();
            Component component = tabComponent = SystemInfo.isJdk6Above() ? this._tabPane.getTabComponentAt(tabIndex) : null;
            if (tabComponent != null) {
                return width += tabComponent.getPreferredSize().width;
            }
            if (icon != null) {
                width += icon.getIconWidth() + this._textIconGap;
            }
            if ((v = this.getTextViewForTab(tabIndex)) != null) {
                width += (int)v.getPreferredSpan(0);
            } else {
                String title = this.getCurrentDisplayTitleAt(this._tabPane, tabIndex);
                width += SwingUtilities.computeStringWidth(metrics, title);
            }
            if (this._tabPane.isShowGripper()) {
                width += this._gripperWidth;
            }
            if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this._tabPane.isTabClosableAt(tabIndex)) {
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (this._tabPane.getSelectedIndex() == tabIndex) {
                        width += this._closeButtons[tabIndex].getPreferredSize().width + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                    }
                } else {
                    width += this._closeButtons[tabIndex].getPreferredSize().width + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                }
            }
        } else {
            Component tabComponent;
            Component component = tabComponent = SystemInfo.isJdk6Above() ? this._tabPane.getTabComponentAt(tabIndex) : null;
            if (tabComponent != null) {
                Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
                width = tabComponent.getPreferredSize().width + tabInsets.left + tabInsets.right + 3;
                return width;
            }
            View v = this.getTextViewForTab(tabIndex);
            width = v != null ? (width += (int)v.getPreferredSpan(1)) : (width += metrics.getHeight());
            Icon icon = this._tabPane.getIconForTab(tabIndex);
            Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
            if (icon != null) {
                width = Math.max(width, icon.getIconWidth());
            }
            width += tabInsets.left + tabInsets.right + 2;
        }
        return width;
    }

    protected int calculateMaxTabWidth(int tabPlacement) {
        int tabCount = this._tabPane.getTabCount();
        int result = 0;
        for (int i = 0; i < tabCount; ++i) {
            FontMetrics metrics = this.getFontMetrics(i);
            result = Math.max(this.calculateTabWidth(tabPlacement, i, metrics), result);
        }
        return result;
    }

    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        if (!this._tabPane.isTabShown()) {
            return 0;
        }
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        return horizRunCount > 0 ? horizRunCount * (maxTabHeight - tabRunOverlay) + tabRunOverlay + tabAreaInsets.top + tabAreaInsets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        if (!this._tabPane.isTabShown()) {
            return 0;
        }
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int tabRunOverlay = this.getTabRunOverlay(tabPlacement);
        return vertRunCount > 0 ? vertRunCount * (maxTabWidth - tabRunOverlay) + tabRunOverlay + tabAreaInsets.left + tabAreaInsets.right : 0;
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        BasicJideTabbedPaneUI.rotateInsets(this._tabPane.getTabInsets(), this._currentTabInsets, tabPlacement);
        return this._currentTabInsets;
    }

    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        BasicJideTabbedPaneUI.rotateInsets(this._selectedTabPadInsets, this._currentPadInsets, tabPlacement);
        return this._currentPadInsets;
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        BasicJideTabbedPaneUI.rotateInsets(this._tabPane.getTabAreaInsets(), this._currentTabAreaInsets, tabPlacement);
        return this._currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        BasicJideTabbedPaneUI.rotateInsets(this._tabPane.getContentBorderInsets(), this._currentContentBorderInsets, tabPlacement);
        if (this._ignoreContentBorderInsetsIfNoTabs && !this._tabPane.isTabShown()) {
            return new Insets(0, 0, 0, 0);
        }
        return this._currentContentBorderInsets;
    }

    protected FontMetrics getFontMetrics(int tab) {
        int selectedIndex = this._tabPane.getSelectedIndex();
        Font font = selectedIndex == tab ? (this._tabPane.getSelectedTabFont() != null ? this._tabPane.getSelectedTabFont() : this._selectedTabFont) : this._tabPane.getFont();
        if (selectedIndex == tab && this._tabPane.isBoldActiveTab() && font.getStyle() != 1) {
            font = font.deriveFont(1);
        }
        return this._tabPane.getFontMetrics(font);
    }

    protected void navigateSelectedTab(int direction) {
        int tabPlacement = this._tabPane.getTabPlacement();
        int current = this._tabPane.getSelectedIndex();
        int tabCount = this._tabPane.getTabCount();
        boolean leftToRight = this._tabPane.getComponentOrientation().isLeftToRight();
        if (tabCount <= 0) {
            return;
        }
        block0 : switch (tabPlacement) {
            case 12: {
                this.selectNextTab(current);
                break;
            }
            case 13: {
                this.selectPreviousTab(current);
                break;
            }
            case 2: 
            case 4: {
                switch (direction) {
                    case 1: {
                        this.selectPreviousTabInRun(current);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(current);
                        break block0;
                    }
                    case 7: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 3: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (direction) {
                    case 1: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, false);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 5: {
                        int offset = this.getTabRunOffset(tabPlacement, tabCount, current, true);
                        this.selectAdjacentRunTab(tabPlacement, current, offset);
                        break block0;
                    }
                    case 3: {
                        if (leftToRight) {
                            this.selectNextTabInRun(current);
                            break block0;
                        }
                        this.selectPreviousTabInRun(current);
                        break block0;
                    }
                    case 7: {
                        if (leftToRight) {
                            this.selectPreviousTabInRun(current);
                            break block0;
                        }
                        this.selectNextTabInRun(current);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int current) {
        int tabCount = this._tabPane.getTabCount();
        int tabIndex = this.getNextTabIndexInRun(tabCount, current);
        while (tabIndex != current && !this._tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndexInRun(tabCount, tabIndex);
        }
        this._tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectPreviousTabInRun(int current) {
        int tabCount = this._tabPane.getTabCount();
        int tabIndex = this.getPreviousTabIndexInRun(tabCount, current);
        while (tabIndex != current && !this._tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndexInRun(tabCount, tabIndex);
        }
        this._tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectNextTab(int current) {
        int tabIndex = this.getNextTabIndex(current);
        while (tabIndex != current && !this._tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getNextTabIndex(tabIndex);
        }
        this._tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectPreviousTab(int current) {
        int tabIndex = this.getPreviousTabIndex(current);
        while (tabIndex != current && !this._tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this.getPreviousTabIndex(tabIndex);
        }
        this._tabPane.setSelectedIndex(tabIndex);
    }

    protected void selectAdjacentRunTab(int tabPlacement, int tabIndex, int offset) {
        int newIndex;
        if (this._runCount < 2) {
            return;
        }
        Rectangle r = this._rects[tabIndex];
        switch (tabPlacement) {
            case 2: 
            case 4: {
                newIndex = this.getTabAtLocation(r.x + (r.width >> 1) + offset, r.y + (r.height >> 1));
                break;
            }
            default: {
                newIndex = this.getTabAtLocation(r.x + (r.width >> 1), r.y + (r.height >> 1) + offset);
            }
        }
        if (newIndex != -1) {
            while (!this._tabPane.isEnabledAt(newIndex) && newIndex != tabIndex) {
                newIndex = this.getNextTabIndex(newIndex);
            }
            this._tabPane.setSelectedIndex(newIndex);
        }
    }

    protected int getTabRunOffset(int tabPlacement, int tabCount, int tabIndex, boolean forward) {
        int offset;
        int run = this.getRunForTab(tabCount, tabIndex);
        switch (tabPlacement) {
            case 2: {
                if (run == 0) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth) - this._maxTabWidth) : -this._maxTabWidth;
                    break;
                }
                if (run == this._runCount - 1) {
                    offset = forward ? this._maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth) - this._maxTabWidth;
                    break;
                }
                offset = forward ? this._maxTabWidth : -this._maxTabWidth;
                break;
            }
            case 4: {
                if (run == 0) {
                    offset = forward ? this._maxTabWidth : this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth) - this._maxTabWidth;
                    break;
                }
                if (run == this._runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth) - this._maxTabWidth) : -this._maxTabWidth;
                    break;
                }
                offset = forward ? this._maxTabWidth : -this._maxTabWidth;
                break;
            }
            case 3: {
                if (run == 0) {
                    offset = forward ? this._maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight) - this._maxTabHeight;
                    break;
                }
                if (run == this._runCount - 1) {
                    offset = forward ? -(this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight) - this._maxTabHeight) : -this._maxTabHeight;
                    break;
                }
                offset = forward ? this._maxTabHeight : -this._maxTabHeight;
                break;
            }
            default: {
                offset = run == 0 ? (forward ? -(this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight) - this._maxTabHeight) : -this._maxTabHeight) : (run == this._runCount - 1 ? (forward ? this._maxTabHeight : this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight) - this._maxTabHeight) : (forward ? this._maxTabHeight : -this._maxTabHeight));
            }
        }
        return offset;
    }

    protected int getPreviousTabIndex(int base) {
        int tabIndex = base - 1 >= 0 ? base - 1 : this._tabPane.getTabCount() - 1;
        return tabIndex >= 0 ? tabIndex : 0;
    }

    protected int getNextTabIndex(int base) {
        return (base + 1) % this._tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int tabCount, int base) {
        if (this._runCount < 2) {
            return this.getNextTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        int next = this.getNextTabIndex(base);
        if (next == this._tabRuns[this.getNextTabRun(currentRun)]) {
            return this._tabRuns[currentRun];
        }
        return next;
    }

    protected int getPreviousTabIndexInRun(int tabCount, int base) {
        if (this._runCount < 2) {
            return this.getPreviousTabIndex(base);
        }
        int currentRun = this.getRunForTab(tabCount, base);
        if (base == this._tabRuns[currentRun]) {
            int previous = this._tabRuns[this.getNextTabRun(currentRun)] - 1;
            return previous != -1 ? previous : tabCount - 1;
        }
        return this.getPreviousTabIndex(base);
    }

    protected int getPreviousTabRun(int baseRun) {
        int runIndex = baseRun - 1 >= 0 ? baseRun - 1 : this._runCount - 1;
        return runIndex >= 0 ? runIndex : 0;
    }

    protected int getNextTabRun(int baseRun) {
        return (baseRun + 1) % this._runCount;
    }

    public static void rotateInsets(Insets topInsets, Insets targetInsets, int targetPlacement) {
        if (topInsets == null) {
            targetInsets.top = 0;
            targetInsets.left = 0;
            targetInsets.bottom = 0;
            targetInsets.right = 0;
            return;
        }
        switch (targetPlacement) {
            case 2: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.top;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.bottom;
                break;
            }
            case 3: {
                targetInsets.top = topInsets.bottom;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.top;
                targetInsets.right = topInsets.right;
                break;
            }
            case 4: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.top;
                break;
            }
            default: {
                targetInsets.top = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.bottom = topInsets.bottom;
                targetInsets.right = topInsets.right;
            }
        }
    }

    public boolean requestFocusForVisibleComponent() {
        Component visibleComponent = this.getVisibleComponent();
        Component lastFocused = this._tabPane.getLastFocusedComponent(visibleComponent);
        if (lastFocused != null && lastFocused.requestFocusInWindow()) {
            return true;
        }
        if (visibleComponent != null && JideSwingUtilities.passesFocusabilityTest(visibleComponent)) {
            JideSwingUtilities.compositeRequestFocus(visibleComponent);
            return true;
        }
        return visibleComponent != null && visibleComponent.requestFocusInWindow();
    }

    @Deprecated
    protected TabCloseButton createNoFocusButton(int type) {
        return new TabCloseButton(type);
    }

    private JButton createButton(int type) {
        return this._tabPane.createNoFocusButton(type);
    }

    protected void stopOrCancelEditing() {
        boolean isEditValid = true;
        if (this._tabPane != null && this._tabPane.isTabEditing() && this._tabPane.getTabEditingValidator() != null) {
            isEditValid = this._tabPane.getTabEditingValidator().isValid(this._editingTab, this._oldPrefix + this._tabEditor.getText() + this._oldPostfix);
        }
        if (isEditValid) {
            this._tabPane.stopTabEditing();
        } else {
            this._tabPane.cancelTabEditing();
        }
    }

    protected void ensureCurrentRects(int leftMargin, int tabCount) {
        int oldWidth;
        Dimension size = this._tabPane.getSize();
        Insets insets = this._tabPane.getInsets();
        int totalWidth = 0;
        int totalHeight = 0;
        boolean verticalTabRuns = this._tabPane.getTabPlacement() == 2 || this._tabPane.getTabPlacement() == 4;
        boolean ltr = this._tabPane.getComponentOrientation().isLeftToRight();
        if (tabCount == 0) {
            return;
        }
        Rectangle r = this._rects[tabCount - 1];
        Dimension lsize = new Dimension(0, 0);
        Dimension tsize = new Dimension(0, 0);
        if (this.isTabLeadingComponentVisible()) {
            lsize = this._tabLeadingComponent.getPreferredSize();
        }
        if (this.isTabTrailingComponentVisible()) {
            tsize = this._tabTrailingComponent.getPreferredSize();
        }
        if (verticalTabRuns) {
            totalHeight = r.y + r.height;
            if (this._tabLeadingComponent != null) {
                totalHeight -= lsize.height;
            }
        } else {
            for (Rectangle rect : this._rects) {
                totalWidth += rect.width;
            }
            totalWidth = ltr ? (totalWidth += this._rects[0].x) : (totalWidth += leftMargin);
            if (this._tabLeadingComponent != null) {
                totalWidth -= lsize.width;
            }
        }
        if (this.getTabResizeMode() == 2) {
            int numberOfButtons;
            if (verticalTabRuns) {
                int availHeight = this.getTabShape() != 3 ? (int)size.getHeight() - this._fitStyleBoundSize - insets.top - insets.bottom - leftMargin - this.getTabRightPadding() : (int)size.getHeight() - this._fitStyleBoundSize - insets.top - insets.bottom;
                if (this._tabPane.isShowCloseButton()) {
                    availHeight -= this._buttonSize;
                }
                if (this.isTabLeadingComponentVisible()) {
                    availHeight -= lsize.height;
                }
                if (this.isTabTrailingComponentVisible()) {
                    availHeight -= tsize.height;
                }
                if (totalHeight > (availHeight -= this._buttonSize * (numberOfButtons = this.getNumberOfTabButtons()))) {
                    int tabHeight = availHeight / tabCount;
                    totalHeight = this._fitStyleFirstTabMargin;
                    for (int k = 0; k < tabCount; ++k) {
                        this._rects[k].height = tabHeight;
                        Rectangle tabRect = this._rects[k];
                        tabRect.y = this.getTabShape() != 3 ? totalHeight + leftMargin : totalHeight;
                        totalHeight += tabRect.height;
                    }
                }
            } else {
                int availWidth = this.getTabShape() != 3 ? (int)size.getWidth() - this._fitStyleBoundSize - insets.left - insets.right - leftMargin - this.getTabRightPadding() : (int)size.getWidth() - this._fitStyleBoundSize - insets.left - insets.right;
                if (this._tabPane.isShowCloseButton()) {
                    availWidth -= this._buttonSize;
                }
                if (this.isTabLeadingComponentVisible()) {
                    availWidth -= lsize.width;
                }
                if (this.isTabTrailingComponentVisible()) {
                    availWidth -= tsize.width;
                }
                if (totalWidth > (availWidth -= this._buttonSize * (numberOfButtons = this.getNumberOfTabButtons()))) {
                    int gripperWidth;
                    int tabWidth = availWidth / tabCount;
                    int n = gripperWidth = this._tabPane.isShowGripper() ? this._gripperWidth : 0;
                    if (tabWidth < this._textIconGap + this._fitStyleTextMinWidth + this._fitStyleIconMinWidth + gripperWidth && tabWidth > this._fitStyleIconMinWidth + gripperWidth) {
                        tabWidth = this._fitStyleIconMinWidth + gripperWidth;
                    }
                    if (tabWidth < this._fitStyleIconMinWidth + gripperWidth && tabWidth > this._fitStyleFirstTabMargin + gripperWidth) {
                        tabWidth = this._fitStyleFirstTabMargin + gripperWidth;
                    }
                    this.tryTabSpacer.reArrange(this._rects, insets, availWidth);
                }
                totalWidth = this._fitStyleFirstTabMargin;
                for (int k = 0; k < tabCount; ++k) {
                    Rectangle tabRect = this._rects[k];
                    tabRect.x = this.getTabShape() != 3 ? totalWidth + leftMargin : totalWidth;
                    totalWidth += tabRect.width;
                }
                if (!ltr) {
                    Insets tabAreaInsets = this.getTabAreaInsets(this._tabPane.getTabPlacement());
                    int rightMargin = size.width - lsize.width - tsize.width - (insets.right + tabAreaInsets.right);
                    if (this._tabPane.isShowCloseButton()) {
                        rightMargin -= this._buttonSize;
                    }
                    for (int k = 0; k < tabCount; ++k) {
                        this._rects[k].x = rightMargin - this._rects[k].x - this._rects[k].width;
                    }
                }
            }
        }
        if (this.getTabResizeMode() == 3) {
            if (verticalTabRuns) {
                for (int k = 0; k < tabCount; ++k) {
                    this._rects[k].height = this._fixedStyleRectSize;
                    if (this.isShowCloseButton() && this._tabPane.isShowCloseButtonOnTab()) {
                        this._rects[k].height += this._closeButtons[k].getPreferredSize().height;
                    }
                    if (k != 0) {
                        this._rects[k].y = this._rects[k - 1].y + this._rects[k - 1].height;
                    }
                    totalHeight = this._rects[k].y + this._rects[k].height;
                }
            } else {
                for (int k = 0; k < tabCount; ++k) {
                    oldWidth = this._rects[k].width;
                    this._rects[k].width = this._fixedStyleRectSize;
                    if (this.isShowCloseButton() && this._tabPane.isShowCloseButtonOnTab()) {
                        this._rects[k].width += this._closeButtons[k].getPreferredSize().width;
                    }
                    if (k == 0 && !ltr) {
                        this._rects[k].x += oldWidth - this._rects[k].width;
                    }
                    if (k != 0) {
                        this._rects[k].x = ltr ? this._rects[k - 1].x + this._rects[k - 1].width : this._rects[k - 1].x - this._rects[k - 1].width;
                    }
                    totalWidth = this._rects[k].x + this._rects[k].width;
                }
            }
        }
        if (this.getTabResizeMode() == 4) {
            if (verticalTabRuns) {
                for (int k = 0; k < tabCount; ++k) {
                    if (k != this._tabPane.getSelectedIndex()) {
                        if (!this._tabPane.isShowIconsOnTab() && !this._tabPane.isUseDefaultShowIconsOnTab()) {
                            this._rects[k].height = this._compressedStyleNoIconRectSize;
                        } else {
                            Icon icon = this._tabPane.getIconForTab(k);
                            this._rects[k].height = (icon == null ? 0 : icon.getIconHeight()) + this._compressedStyleIconMargin;
                        }
                        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab()) {
                            this._rects[k].height = this._rects[k].height + this._closeButtons[k].getPreferredSize().height + this._compressedStyleCloseButtonMarginVertical;
                        }
                    }
                    if (k != 0) {
                        this._rects[k].y = this._rects[k - 1].y + this._rects[k - 1].height;
                    }
                    totalHeight = this._rects[k].y + this._rects[k].height;
                }
            } else {
                for (int k = 0; k < tabCount; ++k) {
                    oldWidth = this._rects[k].width;
                    if (k != this._tabPane.getSelectedIndex()) {
                        if (!this._tabPane.isShowIconsOnTab() && !this._tabPane.isUseDefaultShowIconsOnTab()) {
                            this._rects[k].width = this._compressedStyleNoIconRectSize;
                        } else {
                            Icon icon = this._tabPane.getIconForTab(k);
                            this._rects[k].width = (icon == null ? 0 : icon.getIconWidth()) + this._compressedStyleIconMargin;
                        }
                        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab()) {
                            this._rects[k].width = this._rects[k].width + this._closeButtons[k].getPreferredSize().width + this._compressedStyleCloseButtonMarginHorizon;
                        }
                    }
                    if (k == 0 && !ltr) {
                        this._rects[k].x += oldWidth - this._rects[k].width;
                    }
                    if (k != 0) {
                        this._rects[k].x = ltr ? this._rects[k - 1].x + this._rects[k - 1].width : this._rects[k - 1].x - this._rects[k - 1].width;
                    }
                    totalWidth = this._rects[k].x + this._rects[k].width;
                }
            }
        }
        if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
            totalWidth += this.getLayoutSize();
            if (this.isTabLeadingComponentVisible()) {
                totalWidth += lsize.width;
            }
        } else {
            totalHeight += this.getLayoutSize();
            if (this.isTabLeadingComponentVisible()) {
                totalHeight += tsize.height;
            }
        }
        if (this._tabPane.getTabAlignment() == 0 && (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3)) {
            int startX = this._rects[0].x;
            int endX = this._rects[this._rects.length - 1].x + this._rects[this._rects.length - 1].width;
            int width = this._tabPane.getWidth();
            int offset = width / 2 - (endX - startX) / 2 - startX;
            for (Rectangle rect : this._rects) {
                rect.x += offset;
            }
        }
        this._tabScroller.tabPanel.setPreferredSize(new Dimension(totalWidth, totalHeight));
    }

    protected ListCellRenderer getTabListCellRenderer() {
        return this._tabPane.getTabListCellRenderer();
    }

    protected void updateCloseAction() {
        this.ensureCloseButtonCreated();
    }

    private Vector createHTMLVector() {
        Vector<View> htmlViews = new Vector<View>();
        int count = this._tabPane.getTabCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                String title = this.getCurrentDisplayTitleAt(this._tabPane, i);
                if (BasicHTML.isHTMLString(title)) {
                    htmlViews.addElement(BasicHTML.createHTMLView(this._tabPane, title));
                    continue;
                }
                htmlViews.addElement(null);
            }
        }
        return htmlViews;
    }

    @Override
    public Component getTabPanel() {
        if (this.scrollableTabLayoutEnabled()) {
            return this._tabScroller.tabPanel;
        }
        return this._tabPane;
    }

    @Override
    public void ensureActiveTabIsVisible(boolean scrollLeft) {
        if (this._tabPane == null || this._tabPane.getWidth() == 0) {
            return;
        }
        if (this.scrollableTabLayoutEnabled()) {
            this.ensureCurrentLayout();
            int index = this._tabPane.getSelectedIndex();
            if (!(scrollLeft && index == 0 || index >= this._rects.length || index == -1)) {
                this._tabScroller.tabPanel.scrollIndexToVisible(index);
                if (this._tabPane.getTabPlacement() == 2 || this._tabPane.getTabPlacement() == 4 || this._tabPane.getComponentOrientation().isLeftToRight()) {
                    this._tabScroller.tabPanel.getParent().doLayout();
                }
            }
            if (this._tabPane.getTabPlacement() == 2 || this._tabPane.getTabPlacement() == 4 || this._tabPane.getComponentOrientation().isLeftToRight()) {
                this._tabPane.revalidate();
                this._tabPane.repaintTabAreaAndContentBorder();
            } else {
                this._tabPane.repaint();
            }
        }
    }

    protected boolean isShowCloseButtonOnTab() {
        if (this._tabPane.isUseDefaultShowCloseButtonOnTab()) {
            return this._showCloseButtonOnTab;
        }
        return this._tabPane.isShowCloseButtonOnTab();
    }

    protected boolean isShowCloseButton() {
        return this._tabPane.isShowCloseButton();
    }

    public void ensureCloseButtonCreated() {
        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this.scrollableTabLayoutEnabled()) {
            int i;
            JButton[] temp;
            if (this._closeButtons == null) {
                this._closeButtons = new JButton[this._tabPane.getTabCount()];
            } else if (this._closeButtons.length > this._tabPane.getTabCount()) {
                temp = new JButton[this._tabPane.getTabCount()];
                System.arraycopy(this._closeButtons, 0, temp, 0, temp.length);
                for (i = temp.length; i < this._closeButtons.length; ++i) {
                    JButton tabCloseButton = this._closeButtons[i];
                    this._tabScroller.tabPanel.remove(tabCloseButton);
                }
                this._closeButtons = temp;
            } else if (this._closeButtons.length < this._tabPane.getTabCount()) {
                temp = new JButton[this._tabPane.getTabCount()];
                System.arraycopy(this._closeButtons, 0, temp, 0, this._closeButtons.length);
                this._closeButtons = temp;
            }
            ActionMap am = this.getActionMap();
            for (i = 0; i < this._closeButtons.length; ++i) {
                JButton closeButton = this._closeButtons[i];
                if (closeButton == null) {
                    this._closeButtons[i] = closeButton = this.createButton(0);
                    if (closeButton instanceof JideTabbedPane.NoFocusButton) {
                        ((JideTabbedPane.NoFocusButton)closeButton).setIndex(i);
                    }
                    closeButton.setBounds(0, 0, 0, 0);
                    Action action = this._tabPane.getCloseAction();
                    Icon closeIcon = closeButton.getIcon();
                    closeButton.setAction(am.get("closeTabAction"));
                    this.updateButtonFromAction(closeButton, action);
                    if (closeIcon != null) {
                        this._tabScroller.closeButton.setIcon(closeIcon);
                    }
                    this._tabScroller.tabPanel.add(closeButton);
                }
                if (!(closeButton instanceof JideTabbedPane.NoFocusButton)) continue;
                ((JideTabbedPane.NoFocusButton)closeButton).setIndex(i);
            }
        }
    }

    private void updateButtonFromAction(JButton closeButton, Action action) {
        Object icon;
        if (action == null) {
            return;
        }
        closeButton.setEnabled(action.isEnabled());
        Object desc = action.getValue("ShortDescription");
        if (desc instanceof String) {
            closeButton.setToolTipText((String)desc);
        }
        if ((icon = action.getValue("SmallIcon")) instanceof Icon) {
            closeButton.setIcon((Icon)icon);
        }
    }

    protected boolean isShowTabButtons() {
        return this._tabPane.getTabCount() != 0 && this._tabPane.isShowTabArea() && this._tabPane.isShowTabButtons();
    }

    protected boolean isShrinkTabs() {
        return this._tabPane.getTabCount() != 0 && this._tabPane.getTabResizeMode() == 2;
    }

    @Override
    public boolean isTabEditing() {
        return this._isEditing;
    }

    protected TabEditor createDefaultTabEditor() {
        final TabEditor editor = new TabEditor();
        editor.getDocument().addDocumentListener(this);
        editor.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return true;
            }

            @Override
            public boolean shouldYieldFocus(JComponent input) {
                boolean shouldStopEditing = true;
                if (BasicJideTabbedPaneUI.this._tabPane != null && BasicJideTabbedPaneUI.this._tabPane.isTabEditing() && BasicJideTabbedPaneUI.this._tabPane.getTabEditingValidator() != null) {
                    shouldStopEditing = BasicJideTabbedPaneUI.this._tabPane.getTabEditingValidator().alertIfInvalid(BasicJideTabbedPaneUI.this._editingTab, BasicJideTabbedPaneUI.this._oldPrefix + BasicJideTabbedPaneUI.this._tabEditor.getText() + BasicJideTabbedPaneUI.this._oldPostfix);
                }
                if (shouldStopEditing && BasicJideTabbedPaneUI.this._tabPane != null && BasicJideTabbedPaneUI.this._tabPane.isTabEditing()) {
                    BasicJideTabbedPaneUI.this._tabPane.stopTabEditing();
                }
                return shouldStopEditing;
            }
        });
        editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BasicJideTabbedPaneUI.this._originalFocusComponent = e.getOppositeComponent();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                editor.transferFocus();
            }
        });
        editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BasicJideTabbedPaneUI.this._isEditing && e.getKeyCode() == 27) {
                    if (BasicJideTabbedPaneUI.this._editingTab >= 0 && BasicJideTabbedPaneUI.this._editingTab < BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                        BasicJideTabbedPaneUI.this._tabPane.setTitleAt(BasicJideTabbedPaneUI.this._editingTab, BasicJideTabbedPaneUI.this._oldValue);
                    }
                    BasicJideTabbedPaneUI.this._tabPane.cancelTabEditing();
                }
            }
        });
        editor.setFont(this._tabPane.getFont());
        return editor;
    }

    @Override
    public void stopTabEditing() {
        if (this._editingTab >= 0 && this._editingTab < this._tabPane.getTabCount()) {
            this._tabPane.setTitleAt(this._editingTab, this._oldPrefix + this._tabEditor.getText() + this._oldPostfix);
        }
        this.cancelTabEditing();
    }

    @Override
    public void cancelTabEditing() {
        if (this._tabEditor != null) {
            this._isEditing = false;
            ((Container)this.getTabPanel()).remove(this._tabEditor);
            if (this._editingTab >= 0 && this._editingTab < this._tabPane.getTabCount()) {
                Rectangle tabRect = this._tabPane.getBoundsAt(this._editingTab);
                this.getTabPanel().repaint(tabRect.x, tabRect.y, tabRect.width, tabRect.height);
            } else {
                this.getTabPanel().repaint();
            }
            if (this._originalFocusComponent != null) {
                this._originalFocusComponent.requestFocus();
            } else {
                this._tabPane.requestFocusForVisibleComponent();
            }
            this._editingTab = -1;
            this._oldValue = null;
            this._tabPane.doLayout();
        }
    }

    @Override
    public boolean editTabAt(int tabIndex) {
        if (this._isEditing) {
            return false;
        }
        if (this._tabEditor == null) {
            this._tabEditor = this.createDefaultTabEditor();
        }
        if (this._tabEditor != null) {
            this.prepareEditor(this._tabEditor, tabIndex);
            ((Container)this.getTabPanel()).add(this._tabEditor);
            this.resizeEditor(tabIndex);
            this._editingTab = tabIndex;
            this._isEditing = true;
            this._tabEditor.requestFocusInWindow();
            this._tabEditor.selectAll();
            return true;
        }
        return false;
    }

    @Override
    public int getEditingTabIndex() {
        return this._editingTab;
    }

    protected void prepareEditor(TabEditor e, int tabIndex) {
        Font font = this._tabPane.getSelectedTabFont() != null ? this._tabPane.getSelectedTabFont() : this._tabPane.getFont();
        if (this._tabPane.isBoldActiveTab() && font.getStyle() != 1) {
            font = font.deriveFont(1);
        }
        e.setFont(font);
        this._oldValue = this._tabPane.getTitleAt(tabIndex);
        if (this._oldValue.startsWith("<HTML>") && this._oldValue.endsWith("/HTML>")) {
            this._oldPrefix = "<HTML>";
            this._oldPostfix = "</HTML>";
            String title = this._oldValue.substring("<HTML>".length(), this._oldValue.length() - "</HTML>".length());
            if (title.startsWith("<B>") && title.endsWith("/B>")) {
                title = title.substring("<B>".length(), title.length() - "</B>".length());
                this._oldPrefix = this._oldPrefix + "<B>";
                this._oldPostfix = "</B>" + this._oldPostfix;
            }
            e.setText(title);
        } else {
            this._oldPrefix = "";
            this._oldPostfix = "";
            e.setText(this._oldValue);
        }
        e.selectAll();
        e.setForeground(this._tabPane.getForegroundAt(tabIndex));
    }

    protected Rectangle getTabsTextBoundsAt(int tabIndex) {
        String title;
        Rectangle tabRect = this._tabPane.getBoundsAt(tabIndex);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        if (tabRect.width < 200) {
            tabRect.width = 200;
        }
        if ((title = this.getCurrentDisplayTitleAt(this._tabPane, tabIndex)) == null || title.length() == 0) {
            title = "i";
        }
        Icon icon = this._tabPane.getIconForTab(tabIndex);
        Font font = this._tabPane.getFont();
        if (tabIndex == this._tabPane.getSelectedIndex() && this._tabPane.isBoldActiveTab()) {
            font = font.deriveFont(1);
        }
        SwingUtilities.layoutCompoundLabel(this._tabPane, this._tabPane.getGraphics().getFontMetrics(font), title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, icon == null ? 0 : this._textIconGap);
        if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
            iconRect.x = tabRect.x + this._iconMargin;
            textRect.x = icon != null ? iconRect.x + iconRect.width + this._textIconGap : tabRect.x + this._textPadding;
            textRect.width += 2;
        } else {
            iconRect.y = tabRect.y + this._iconMargin;
            textRect.y = icon != null ? iconRect.y + iconRect.height + this._textIconGap : tabRect.y + this._textPadding;
            iconRect.x = tabRect.x + 2;
            textRect.x = tabRect.x + 2;
            textRect.height += 2;
        }
        return textRect;
    }

    private void updateTab() {
        if (this._isEditing) {
            this.resizeEditor(this.getEditingTabIndex());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTab();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTab();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTab();
    }

    protected void resizeEditor(int tabIndex) {
        Rectangle tabsTextBoundsAt = this.getTabsTextBoundsAt(tabIndex);
        if (tabsTextBoundsAt.isEmpty()) {
            tabsTextBoundsAt = new Rectangle(14, 3);
        }
        tabsTextBoundsAt.x -= this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).left;
        tabsTextBoundsAt.width = tabsTextBoundsAt.width + this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).left + this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).right;
        tabsTextBoundsAt.y -= this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).top;
        tabsTextBoundsAt.height = tabsTextBoundsAt.height + this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).top + this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).bottom;
        this._tabEditor.setBounds(SwingUtilities.convertRectangle(this._tabPane, tabsTextBoundsAt, this.getTabPanel()));
        this._tabEditor.invalidate();
        this._tabEditor.validate();
        this._tabPane.doLayout();
        this.getTabPanel().getParent().getParent().repaint();
    }

    protected String getCurrentDisplayTitleAt(JideTabbedPane tp, int index) {
        String returnTitle = tp.getDisplayTitleAt(index);
        if (this._isEditing && index == this._editingTab) {
            returnTitle = this._tabEditor.getText();
        }
        return returnTitle;
    }

    public void startEditing(MouseEvent e) {
        int tabIndex = this.tabForCoordinate(this._tabPane, e.getX(), e.getY());
        if (!e.isPopupTrigger() && tabIndex >= 0 && this._tabPane.isEnabledAt(tabIndex) && this._tabPane.isTabEditingAllowed() && this._tabPane.isTabEditingAllowed(tabIndex) && e.getClickCount() == 2) {
            boolean shouldEdit = true;
            if (this._tabPane.getTabEditingValidator() != null) {
                shouldEdit = this._tabPane.getTabEditingValidator().shouldStartEdit(tabIndex, e);
            }
            if (shouldEdit) {
                e.consume();
                this._tabPane.editTabAt(tabIndex);
            }
        }
        if (e.getClickCount() == 1 && this._tabPane.isTabEditing()) {
            boolean shouldStopEdit = true;
            if (this._tabPane.getTabEditingValidator() != null) {
                shouldStopEdit = this._tabPane.getTabEditingValidator().alertIfInvalid(tabIndex, this._oldPrefix + this._tabEditor.getText() + this._oldPostfix);
            }
            if (shouldStopEdit) {
                this._tabPane.stopTabEditing();
            }
        }
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        int nudge;
        Rectangle tabRect = this._rects[tabIndex];
        switch (tabPlacement) {
            case 2: {
                nudge = isSelected ? -1 : 1;
                break;
            }
            case 4: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            default: {
                nudge = tabRect.width % 2;
            }
        }
        return nudge;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        int nudge;
        Rectangle tabRect = this._rects[tabIndex];
        switch (tabPlacement) {
            case 3: {
                nudge = isSelected ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                nudge = tabRect.height % 2;
                break;
            }
            default: {
                nudge = isSelected ? -1 : 1;
            }
        }
        return nudge;
    }

    protected void paintFocusIndicator(Graphics g2, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Rectangle tabRect = new Rectangle(rects[tabIndex]);
        if (this._tabPane.hasFocus() && isSelected) {
            int h2;
            int w;
            int y;
            int x;
            g2.setColor(this._focus);
            switch (tabPlacement) {
                case 2: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h2 = tabRect.height - 6 - this.getTabGap();
                    break;
                }
                case 4: {
                    x = tabRect.x + 2;
                    y = tabRect.y + 3;
                    w = tabRect.width - 5;
                    h2 = tabRect.height - 6 - this.getTabGap();
                    break;
                }
                case 3: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 2;
                    w = tabRect.width - 6 - this.getTabGap();
                    h2 = tabRect.height - 5;
                    break;
                }
                default: {
                    x = tabRect.x + 3;
                    y = tabRect.y + 3;
                    w = tabRect.width - 6 - this.getTabGap();
                    h2 = tabRect.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(g2, x, y, w, h2);
        }
    }

    protected boolean isRoundedCorner() {
        return "true".equals(SecurityUtils.getProperty("shadingtheme", "false"));
    }

    protected int getTabShape() {
        return this._tabPane.getTabShape();
    }

    protected int getTabResizeMode() {
        return this._tabPane.getTabResizeMode();
    }

    protected int getColorTheme() {
        return this._tabPane.getColorTheme();
    }

    protected int getLeftMargin() {
        if (this.getTabShape() == 4) {
            return 18;
        }
        if (this.getTabShape() == 8) {
            return 6;
        }
        return 0;
    }

    protected int getTabGap() {
        if (this.getTabShape() == 4) {
            return 4;
        }
        return 0;
    }

    protected int getLayoutSize() {
        int tabShape = this.getTabShape();
        if (tabShape == 8) {
            return 6;
        }
        if (tabShape == 7) {
            return 15;
        }
        if (this._tabPane.getTabShape() == 5 || this._tabPane.getTabShape() == 10) {
            return 2;
        }
        if (tabShape == 1 || tabShape == 11) {
            return 6;
        }
        return 0;
    }

    protected int getTabRightPadding() {
        if (this.getTabShape() == 8) {
            return 4;
        }
        return 0;
    }

    protected MouseListener createMouseListener() {
        if (this.getTabShape() == 1 || this.getTabShape() == 11 || this._tabPane.isShowCloseButtonOnMouseOver()) {
            return new RolloverMouseHandler();
        }
        return new MouseHandler();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        if (this.getTabShape() == 1 || this.getTabShape() == 11 || this._tabPane.isShowCloseButtonOnMouseOver()) {
            return new RolloverMouseMotionHandler();
        }
        return new MouseMotionHandler();
    }

    protected boolean isTabLeadingComponentVisible() {
        return this._tabPane.isTabShown() && this._tabLeadingComponent != null && this._tabLeadingComponent.isVisible();
    }

    protected boolean isTabTrailingComponentVisible() {
        return this._tabPane.isTabShown() && this._tabTrailingComponent != null && this._tabTrailingComponent.isVisible();
    }

    protected boolean isTabTopVisible(int tabPlacement) {
        switch (tabPlacement) {
            case 2: 
            case 4: {
                return this.isTabLeadingComponentVisible() && this._tabLeadingComponent.getPreferredSize().width > this.calculateMaxTabWidth(tabPlacement) || this.isTabTrailingComponentVisible() && this._tabTrailingComponent.getPreferredSize().width > this.calculateMaxTabWidth(tabPlacement);
            }
        }
        return this.isTabLeadingComponentVisible() && this._tabLeadingComponent.getPreferredSize().height > this.calculateMaxTabHeight(tabPlacement) || this.isTabTrailingComponentVisible() && this._tabTrailingComponent.getPreferredSize().height > this.calculateMaxTabHeight(tabPlacement);
    }

    protected boolean showFocusIndicator() {
        return this._tabPane.hasFocusComponent() && this._showFocusIndicator;
    }

    private int getNumberOfTabButtons() {
        int numberOfButtons;
        int n = numberOfButtons = !this.isShowTabButtons() || this.isShrinkTabs() ? 1 : 4;
        if (!this.isShowCloseButton() || this.isShowCloseButtonOnTab()) {
            --numberOfButtons;
        }
        return numberOfButtons;
    }

    protected String getResourceString(String key) {
        if (this._tabPane != null) {
            return this._tabPane.getResourceString(key);
        }
        return Resource.getResourceBundle(Locale.getDefault()).getString(key);
    }

    private void setMouseOverTabIndex(int index) {
        if (this._indexMouseOver != index) {
            this._indexMouseOver = index;
            this._tabPane.putClientProperty("JideTabbedPane.mouseOverTabIndex", this._indexMouseOver);
        }
    }

    public class RolloverMouseHandler
    extends MouseHandler {
        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            int tabIndex = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, e.getX(), e.getY());
            BasicJideTabbedPaneUI.this._mouseEnter = true;
            BasicJideTabbedPaneUI.this.setMouseOverTabIndex(tabIndex);
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            BasicJideTabbedPaneUI.this.setMouseOverTabIndex(-1);
            BasicJideTabbedPaneUI.this._mouseEnter = false;
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }
    }

    public class RolloverMouseMotionHandler
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            int tabIndex = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, e.getX(), e.getY());
            if (tabIndex != BasicJideTabbedPaneUI.this._indexMouseOver) {
                BasicJideTabbedPaneUI.this.setMouseOverTabIndex(tabIndex);
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            }
        }
    }

    public class DefaultMouseHandler
    extends MouseHandler {
        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            int tabIndex = BasicJideTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            BasicJideTabbedPaneUI.this._mouseEnter = true;
            BasicJideTabbedPaneUI.this.setMouseOverTabIndex(tabIndex);
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            BasicJideTabbedPaneUI.this.setMouseOverTabIndex(-1);
            BasicJideTabbedPaneUI.this._mouseEnter = false;
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }
    }

    public class DefaultMouseMotionHandler
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            int tabIndex = BasicJideTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex != BasicJideTabbedPaneUI.this._indexMouseOver) {
                BasicJideTabbedPaneUI.this.setMouseOverTabIndex(tabIndex);
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            }
        }
    }

    private class DropListener
    implements DropTargetListener {
        private DragOverTimer _timer;
        int _index = -1;

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (!BasicJideTabbedPaneUI.this._tabPane.isEnabled()) {
                return;
            }
            int tabIndex = BasicJideTabbedPaneUI.this.getTabAtLocation(dtde.getLocation().x, dtde.getLocation().y);
            if (tabIndex >= 0 && BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex != BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex() && tabIndex != this._index) {
                    this.stopTimer();
                    this.startTimer(tabIndex);
                    this._index = tabIndex;
                }
            } else {
                this.stopTimer();
            }
            dtde.rejectDrag();
        }

        private void startTimer(int tabIndex) {
            this._timer = new DragOverTimer(tabIndex);
            this._timer.start();
        }

        private void stopTimer() {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
                this._index = -1;
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.stopTimer();
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            this.stopTimer();
        }
    }

    private class DragOverTimer
    extends Timer
    implements ActionListener {
        private int _index;
        private static final long serialVersionUID = -2529347876574638854L;

        public DragOverTimer(int index) {
            super(500, null);
            this._index = index;
            this.addActionListener(this);
            this.setRepeats(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicJideTabbedPaneUI.this._tabPane.getTabCount() == 0) {
                return;
            }
            if (this._index == BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex()) {
                if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                    BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow();
                    BasicJideTabbedPaneUI.this._tabPane.repaint(BasicJideTabbedPaneUI.this.getTabBounds(BasicJideTabbedPaneUI.this._tabPane, this._index));
                }
            } else {
                if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                    BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow();
                }
                BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(this._index);
            }
            this.stop();
        }
    }

    protected class TabEditor
    extends JTextField
    implements UIResource {
        TabEditor() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createCompoundBorder(new PartialLineBorder(Color.BLACK, 1, true), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        }

        public boolean stopEditing() {
            return true;
        }

        @Override
        protected void paintComponent(Graphics g2) {
            Graphics2D g22 = (Graphics2D)g2;
            Composite orgComposite = g22.getComposite();
            Color orgColor = g22.getColor();
            g22.setComposite(AlphaComposite.getInstance(3, 0.7f));
            Object o = JideSwingUtilities.setupShapeAntialiasing(g2);
            g22.setColor(this.getBackground());
            g2.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, 1, 1);
            JideSwingUtilities.restoreShapeAntialiasing(g2, o);
            g22.setColor(orgColor);
            g22.setComposite(orgComposite);
            super.paintComponent(g2);
        }
    }

    public static class TabSpaceAllocator {
        static final int startOffset = 4;
        private Insets insets = null;
        static final int tabWidth = 24;
        static final int textIconGap = 8;
        private AbstractTab[] tabs;

        private void setInsets(Insets insets) {
            this.insets = (Insets)insets.clone();
        }

        private void init(Rectangle[] rects, Insets insets) {
            this.setInsets(insets);
            this.tabs = new AbstractTab[rects.length];
            for (int i = 0; i < rects.length; ++i) {
                this.tabs[i] = new AbstractTab();
                this.tabs[i].id = i;
                this.tabs[i].width = rects[i].width;
            }
            this.tabSort();
        }

        private void bestfit(AbstractTab[] tabs, int freeWidth, int startTab) {
            int tabCount = tabs.length;
            int currentTabWidth = tabs[startTab].width;
            int initialPos = startTab;
            if (startTab == tabCount - 1) {
                tabs[startTab].width = freeWidth;
                return;
            }
            int worstWidth = freeWidth / (tabCount - startTab);
            while (currentTabWidth < worstWidth) {
                freeWidth -= currentTabWidth;
                if (++startTab < tabCount - 1) {
                    currentTabWidth = tabs[startTab].width;
                    continue;
                }
                tabs[startTab].width = worstWidth;
                return;
            }
            if (startTab == initialPos) {
                for (int i = startTab; i < tabCount; ++i) {
                    tabs[i].width = worstWidth;
                }
            } else if (startTab < tabCount - 1) {
                this.bestfit(tabs, freeWidth, startTab);
            }
        }

        private void tabSort() {
            int tabCount = this.tabs.length;
            AbstractTab tempTab = new AbstractTab();
            for (int i = 0; i < tabCount - 1; ++i) {
                for (int j = i + 1; j < tabCount; ++j) {
                    if (this.tabs[i].width <= this.tabs[j].width) continue;
                    tempTab.copy(this.tabs[j]);
                    this.tabs[j].copy(this.tabs[i]);
                    this.tabs[i].copy(tempTab);
                }
            }
        }

        private void outpush(Rectangle[] rects) {
            for (AbstractTab tab : this.tabs) {
                rects[tab.id].width = tab.width;
            }
            rects[0].x = 4;
            for (int i = 1; i < rects.length; ++i) {
                rects[i].x = rects[i - 1].x + rects[i - 1].width;
            }
        }

        public void reArrange(Rectangle[] rects, Insets insets, int totalAvailableSpace) {
            this.init(rects, insets);
            this.bestfit(this.tabs, totalAvailableSpace, 0);
            this.outpush(rects);
            int totalUsedWidth = rects[rects.length - 1].x + rects[rects.length - 1].width;
            if (totalUsedWidth > totalAvailableSpace) {
                int gap = totalUsedWidth - totalAvailableSpace;
                rects[rects.length - 1].width -= gap;
            }
            this.clearup();
        }

        private void clearup() {
            for (int i = 0; i < this.tabs.length; ++i) {
                this.tabs[i] = null;
            }
            this.tabs = null;
        }
    }

    static class AbstractTab {
        int width;
        int id;

        AbstractTab() {
        }

        public void copy(AbstractTab tab) {
            this.width = tab.width;
            this.id = tab.id;
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            if (BasicJideTabbedPaneUI.this._tabPane == null) {
                return;
            }
            JideTabbedPane tp = (JideTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource || child == tp.getTabLeadingComponent() || child == tp.getTabTrailingComponent()) {
                return;
            }
            int index = tp.indexOfComponent(child);
            String title = BasicJideTabbedPaneUI.this.getCurrentDisplayTitleAt(tp, index);
            boolean isHTML = BasicHTML.isHTMLString(title);
            if (isHTML) {
                if (BasicJideTabbedPaneUI.this.htmlViews == null) {
                    BasicJideTabbedPaneUI.this.htmlViews = BasicJideTabbedPaneUI.this.createHTMLVector();
                } else {
                    View v = BasicHTML.createHTMLView(tp, title);
                    BasicJideTabbedPaneUI.this.htmlViews.insertElementAt(v, index);
                }
            } else if (BasicJideTabbedPaneUI.this.htmlViews != null) {
                BasicJideTabbedPaneUI.this.htmlViews.insertElementAt(null, index);
            }
            if (BasicJideTabbedPaneUI.this._tabPane.isTabEditing()) {
                if (index <= BasicJideTabbedPaneUI.this._tabPane.getEditingTabIndex()) {
                    ++((BasicJideTabbedPaneUI)BasicJideTabbedPaneUI.this._tabPane.getUI())._editingTab;
                }
                BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                ((BasicJideTabbedPaneUI)BasicJideTabbedPaneUI.this._tabPane.getUI()).stopOrCancelEditing();
            }
            BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            if (BasicJideTabbedPaneUI.this._tabPane == null) {
                return;
            }
            JideTabbedPane tp = (JideTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource || child == tp.getTabLeadingComponent() || child == tp.getTabTrailingComponent()) {
                return;
            }
            Integer index = (Integer)tp.getClientProperty("__index_to_remove__");
            if (index != null) {
                if (BasicJideTabbedPaneUI.this.htmlViews != null && BasicJideTabbedPaneUI.this.htmlViews.size() > index) {
                    BasicJideTabbedPaneUI.this.htmlViews.removeElementAt(index);
                }
                tp.putClientProperty("__index_to_remove__", null);
            }
            if (BasicJideTabbedPaneUI.this._tabPane.isTabEditing()) {
                ((BasicJideTabbedPaneUI)BasicJideTabbedPaneUI.this._tabPane.getUI()).stopOrCancelEditing();
            }
            BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
        }
    }

    private class ComponentHandler
    implements ComponentListener {
        private ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled() && (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 7 || BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight())) {
                BasicJideTabbedPaneUI.this._tabScroller.viewport.setViewSize(new Dimension(BasicJideTabbedPaneUI.this._tabPane.getWidth(), BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewSize().height));
                BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(true);
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }

    public class MouseWheelHandler
    implements MouseWheelListener {
        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            block3: {
                block4: {
                    block2: {
                        if (!BasicJideTabbedPaneUI.this._tabPane.isScrollSelectedTabOnWheel()) break block2;
                        BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(Math.min(BasicJideTabbedPaneUI.this._tabPane.getTabCount() - 1, Math.max(0, BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex() + e.getWheelRotation())));
                        break block3;
                    }
                    if (!BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled() || e.getWheelRotation() == 0) break block3;
                    if (e.getWheelRotation() <= 0) break block4;
                    for (int i = 0; i < e.getScrollAmount(); ++i) {
                        BasicJideTabbedPaneUI.this._tabScroller.scrollForward(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement());
                    }
                    break block3;
                }
                if (e.getWheelRotation() >= 0) break block3;
                for (int i = 0; i < e.getScrollAmount(); ++i) {
                    BasicJideTabbedPaneUI.this._tabScroller.scrollBackward(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement());
                }
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        @Override
        public void mouseReleased(MouseEvent e) {
            if (BasicJideTabbedPaneUI.this._tabPane == null || !BasicJideTabbedPaneUI.this._tabPane.isEnabled()) {
                return;
            }
            if (SwingUtilities.isMiddleMouseButton(e)) {
                int tabIndex = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, e.getX(), e.getY());
                Action action = BasicJideTabbedPaneUI.this.getActionMap().get("closeTabAction");
                if (action != null && tabIndex >= 0 && BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(tabIndex) && BasicJideTabbedPaneUI.this._tabPane.isCloseTabOnMouseMiddleButton() && BasicJideTabbedPaneUI.this._tabPane.isTabClosableAt(tabIndex)) {
                    ActionEvent event = new ActionEvent(BasicJideTabbedPaneUI.this._tabPane, tabIndex, "middleMouseButtonClicked");
                    action.actionPerformed(event);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int tabIndex;
            if (BasicJideTabbedPaneUI.this._tabPane == null || !BasicJideTabbedPaneUI.this._tabPane.isEnabled()) {
                return;
            }
            if ((SwingUtilities.isLeftMouseButton(e) || BasicJideTabbedPaneUI.this._tabPane.isRightClickSelect()) && (tabIndex = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, e.getX(), e.getY())) >= 0 && BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex == BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex() && JideSwingUtilities.isAncestorOfFocusOwner(BasicJideTabbedPaneUI.this._tabPane)) {
                    if (BasicJideTabbedPaneUI.this._tabPane.isAutoFocusOnTabHideClose() && BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                        BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                    }
                } else {
                    BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(tabIndex);
                    if (BasicJideTabbedPaneUI.this._tabPane == null) {
                        return;
                    }
                    BasicJideTabbedPaneUI.this._tabPane.processMouseSelection(tabIndex, e);
                    final Component comp = BasicJideTabbedPaneUI.this._tabPane.getComponentAt(tabIndex);
                    if (BasicJideTabbedPaneUI.this._tabPane.isAutoFocusOnTabHideClose() && comp != null && !comp.isVisible() && SystemInfo.isJdk15Above() && !SystemInfo.isJdk6Above()) {
                        comp.addComponentListener(new ComponentAdapter(){

                            @Override
                            public void componentShown(ComponentEvent e) {
                                comp.removeComponentListener(this);
                                Component lastFocused = BasicJideTabbedPaneUI.this._tabPane.getLastFocusedComponent(comp);
                                if (lastFocused != null) {
                                    lastFocused.requestFocus();
                                } else if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                                    BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                                }
                            }
                        });
                    } else {
                        Component lastFocused = BasicJideTabbedPaneUI.this._tabPane.getLastFocusedComponent(comp);
                        if (lastFocused != null) {
                            lastFocused.requestFocus();
                        } else {
                            boolean foundInTab = JideSwingUtilities.compositeRequestFocus(comp);
                            if (!foundInTab) {
                                BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                            }
                        }
                    }
                }
            }
            if (!BasicJideTabbedPaneUI.this.isTabEditing()) {
                BasicJideTabbedPaneUI.this.startEditing(e);
            }
        }
    }

    public class MouseMotionHandler
    extends MouseMotionAdapter {
    }

    public class TabFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            this.repaintSelectedTab();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.repaintSelectedTab();
        }

        private void repaintSelectedTab() {
            Rectangle rect;
            if (BasicJideTabbedPaneUI.this._tabPane.getTabCount() > 0 && (rect = BasicJideTabbedPaneUI.this.getTabBounds(BasicJideTabbedPaneUI.this._tabPane, BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex())) != null) {
                BasicJideTabbedPaneUI.this._tabPane.repaint(rect);
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            ((BasicJideTabbedPaneUI)BasicJideTabbedPaneUI.this._tabPane.getUI()).stopOrCancelEditing();
            BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(false);
                }
            };
            SwingUtilities.invokeLater(runnable2);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            String name = e.getPropertyName();
            if ("mnemonicAt".equals(name)) {
                BasicJideTabbedPaneUI.this.updateMnemonics();
                pane.repaint();
            } else if ("displayedMnemonicIndexAt".equals(name)) {
                pane.repaint();
            } else if (name.equals("indexForTitle")) {
                int index = (Integer)e.getNewValue();
                String title = BasicJideTabbedPaneUI.this.getCurrentDisplayTitleAt(BasicJideTabbedPaneUI.this._tabPane, index);
                if (BasicHTML.isHTMLString(title)) {
                    if (BasicJideTabbedPaneUI.this.htmlViews == null) {
                        BasicJideTabbedPaneUI.this.htmlViews = BasicJideTabbedPaneUI.this.createHTMLVector();
                    } else {
                        View v = BasicHTML.createHTMLView(BasicJideTabbedPaneUI.this._tabPane, title);
                        BasicJideTabbedPaneUI.this.htmlViews.setElementAt(v, index);
                    }
                } else if (BasicJideTabbedPaneUI.this.htmlViews != null && BasicJideTabbedPaneUI.this.htmlViews.elementAt(index) != null) {
                    BasicJideTabbedPaneUI.this.htmlViews.setElementAt(null, index);
                }
                BasicJideTabbedPaneUI.this.updateMnemonics();
                if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled() && (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 7 || BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight())) {
                    BasicJideTabbedPaneUI.this._tabScroller.viewport.setViewSize(new Dimension(BasicJideTabbedPaneUI.this._tabPane.getWidth(), BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewSize().height));
                    BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(false);
                }
            } else if (name.equals("indexForTabComponent")) {
                Component c;
                if (BasicJideTabbedPaneUI.this._tabContainer != null) {
                    BasicJideTabbedPaneUI.this._tabContainer.removeUnusedTabComponents();
                }
                Component component = c = SystemInfo.isJdk6Above() ? BasicJideTabbedPaneUI.this._tabPane.getTabComponentAt((Integer)e.getNewValue()) : null;
                if (c != null) {
                    if (BasicJideTabbedPaneUI.this._tabContainer == null) {
                        BasicJideTabbedPaneUI.this.installTabContainer();
                    } else {
                        BasicJideTabbedPaneUI.this._tabContainer.add(c);
                    }
                }
                BasicJideTabbedPaneUI.this._tabPane.revalidate();
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            } else if (name.equals("tabLayoutPolicy")) {
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (name.equals("closeTabAction")) {
                BasicJideTabbedPaneUI.this.updateCloseAction();
            } else if (name.equals("dragOverDisabled")) {
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (name.equals("tabColorProvider")) {
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            } else if (name.equals("locale")) {
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (name.equals("boldActiveTab")) {
                BasicJideTabbedPaneUI.this.getTabPanel().invalidate();
                BasicJideTabbedPaneUI.this._tabPane.invalidate();
                if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled() && (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 7 || BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight())) {
                    BasicJideTabbedPaneUI.this._tabScroller.viewport.setViewSize(new Dimension(BasicJideTabbedPaneUI.this._tabPane.getWidth(), BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewSize().height));
                    BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(true);
                }
            } else if (name.equals("tabLeadingComponent")) {
                BasicJideTabbedPaneUI.this.ensureCurrentLayout();
                if (BasicJideTabbedPaneUI.this._tabLeadingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setVisible(false);
                    BasicJideTabbedPaneUI.this._tabPane.remove(BasicJideTabbedPaneUI.this._tabLeadingComponent);
                }
                BasicJideTabbedPaneUI.this._tabLeadingComponent = (Component)e.getNewValue();
                if (BasicJideTabbedPaneUI.this._tabLeadingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setVisible(true);
                    BasicJideTabbedPaneUI.this._tabPane.add(BasicJideTabbedPaneUI.this._tabLeadingComponent);
                }
                BasicJideTabbedPaneUI.this._tabScroller.tabPanel.updateUI();
            } else if (name.equals("tabTrailingComponent")) {
                BasicJideTabbedPaneUI.this.ensureCurrentLayout();
                if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(false);
                    BasicJideTabbedPaneUI.this._tabPane.remove(BasicJideTabbedPaneUI.this._tabTrailingComponent);
                }
                BasicJideTabbedPaneUI.this._tabTrailingComponent = (Component)e.getNewValue();
                if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabPane.add(BasicJideTabbedPaneUI.this._tabTrailingComponent);
                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(true);
                }
                BasicJideTabbedPaneUI.this._tabScroller.tabPanel.updateUI();
            } else if (name.equals("shrinkTab") || name.equals("hideIfOneTab") || name.equals("showTabArea") || name.equals("showTabContent") || name.equals("boxStyle") || name.equals("showIconsOnTab") || name.equals("showCloseButton") || name.equals("useDefaultShowIconsOnTab") || name.equals("showCloseButtonOnTab") || name.equals("useDefaultShowCloseButtonOnTab") || name.equals("tabClosable") || name.equals("tabShape") || name.equals("colorTheme") || name.equals("tabResizeMode") || name.equals("showTabButtons")) {
                if ((name.equals("useDefaultShowCloseButtonOnTab") || name.equals("showCloseButtonOnTab")) && BasicJideTabbedPaneUI.this.isShowCloseButton() && BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab()) {
                    BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                }
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (name.equals("__index_to_remove__")) {
                BasicJideTabbedPaneUI.this.setVisibleComponent(null);
            } else if (name.equals("componentOrientation") && BasicJideTabbedPaneUI.this._tabPane != null) {
                if (BasicJideTabbedPaneUI.this._tabCount != BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                    BasicJideTabbedPaneUI.this._tabCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
                    BasicJideTabbedPaneUI.this.updateMnemonics();
                }
                if (BasicJideTabbedPaneUI.this._tabScroller != null && BasicJideTabbedPaneUI.this._tabScroller.tabPanel != null) {
                    BasicJideTabbedPaneUI.this._tabScroller.setLeadingTabIndex(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement(), BasicJideTabbedPaneUI.this._tabScroller.leadingTabIndex);
                }
            }
        }
    }

    @Deprecated
    public class TabCloseButton
    extends JButton
    implements MouseMotionListener,
    MouseListener,
    UIResource {
        @Deprecated
        public static final int CLOSE_BUTTON = 0;
        @Deprecated
        public static final int EAST_BUTTON = 1;
        @Deprecated
        public static final int WEST_BUTTON = 2;
        @Deprecated
        public static final int NORTH_BUTTON = 3;
        @Deprecated
        public static final int SOUTH_BUTTON = 4;
        @Deprecated
        public static final int LIST_BUTTON = 5;
        private int _type;
        private int _index = -1;
        private boolean _mouseOver = false;
        private boolean _mousePressed = false;

        @Override
        public void updateUI() {
            super.updateUI();
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
            String name = this.getName();
            if (name != null) {
                this.setToolTipText(BasicJideTabbedPaneUI.this.getResourceString(name));
            }
        }

        public TabCloseButton() {
            this(0);
        }

        public TabCloseButton(int type) {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setType(type);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int index) {
            this._index = index;
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            if (!this.isEnabled()) {
                this.setMouseOver(false);
                this.setMousePressed(false);
            }
            if (this.isMouseOver() && this.isMousePressed()) {
                g2.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                g2.drawLine(0, 0, this.getWidth() - 1, 0);
                g2.drawLine(0, this.getHeight() - 2, 0, 1);
                g2.setColor(UIDefaultsLookup.getColor("control"));
                g2.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                g2.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
            } else if (this.isMouseOver()) {
                g2.setColor(UIDefaultsLookup.getColor("control"));
                g2.drawLine(0, 0, this.getWidth() - 1, 0);
                g2.drawLine(0, this.getHeight() - 2, 0, 1);
                g2.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                g2.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                g2.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
            }
            g2.setColor(UIDefaultsLookup.getColor("controlShadow").darker());
            int centerX = this.getWidth() >> 1;
            int centerY = this.getHeight() >> 1;
            int type = this.getType();
            if (!(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() != 1 && BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() != 3 || BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight())) {
                if (type == 1) {
                    type = 2;
                } else if (type == 2) {
                    type = 1;
                }
            }
            switch (type) {
                case 0: {
                    if (this.isEnabled()) {
                        g2.drawLine(centerX - 3, centerY - 3, centerX + 3, centerY + 3);
                        g2.drawLine(centerX - 4, centerY - 3, centerX + 2, centerY + 3);
                        g2.drawLine(centerX + 3, centerY - 3, centerX - 3, centerY + 3);
                        g2.drawLine(centerX + 2, centerY - 3, centerX - 4, centerY + 3);
                        break;
                    }
                    g2.drawLine(centerX - 3, centerY - 3, centerX + 3, centerY + 3);
                    g2.drawLine(centerX + 3, centerY - 3, centerX - 3, centerY + 3);
                    break;
                }
                case 1: {
                    if (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int x = centerX + 2;
                        int y = centerY;
                        if (this.isEnabled()) {
                            g2.drawLine(x - 4, y - 4, x - 4, y + 4);
                            g2.drawLine(x - 3, y - 3, x - 3, y + 3);
                            g2.drawLine(x - 2, y - 2, x - 2, y + 2);
                            g2.drawLine(x - 1, y - 1, x - 1, y + 1);
                            g2.drawLine(x, y, x, y);
                            break;
                        }
                        g2.drawLine(x - 4, y - 4, x, y);
                        g2.drawLine(x - 4, y - 4, x - 4, y + 4);
                        g2.drawLine(x - 4, y + 4, x, y);
                        break;
                    }
                    int x = centerX + 3;
                    int y = centerY - 2;
                    if (this.isEnabled()) {
                        g2.drawLine(x - 8, y, x, y);
                        g2.drawLine(x - 7, y + 1, x - 1, y + 1);
                        g2.drawLine(x - 6, y + 2, x - 2, y + 2);
                        g2.drawLine(x - 5, y + 3, x - 3, y + 3);
                        g2.drawLine(x - 4, y + 4, x - 4, y + 4);
                        break;
                    }
                    g2.drawLine(x - 8, y, x, y);
                    g2.drawLine(x - 8, y, x - 4, y + 4);
                    g2.drawLine(x - 4, y + 4, x, y);
                    break;
                }
                case 2: {
                    if (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int x = centerX - 3;
                        int y = centerY;
                        if (this.isEnabled()) {
                            g2.drawLine(x, y, x, y);
                            g2.drawLine(x + 1, y - 1, x + 1, y + 1);
                            g2.drawLine(x + 2, y - 2, x + 2, y + 2);
                            g2.drawLine(x + 3, y - 3, x + 3, y + 3);
                            g2.drawLine(x + 4, y - 4, x + 4, y + 4);
                            break;
                        }
                        g2.drawLine(x, y, x + 4, y - 4);
                        g2.drawLine(x, y, x + 4, y + 4);
                        g2.drawLine(x + 4, y - 4, x + 4, y + 4);
                        break;
                    }
                    int x = centerX - 5;
                    int y = centerY + 3;
                    if (this.isEnabled()) {
                        g2.drawLine(x, y, x + 8, y);
                        g2.drawLine(x + 1, y - 1, x + 7, y - 1);
                        g2.drawLine(x + 2, y - 2, x + 6, y - 2);
                        g2.drawLine(x + 3, y - 3, x + 5, y - 3);
                        g2.drawLine(x + 4, y - 4, x + 4, y - 4);
                        break;
                    }
                    g2.drawLine(x, y, x + 8, y);
                    g2.drawLine(x, y, x + 4, y - 4);
                    g2.drawLine(x + 8, y, x + 4, y - 4);
                    break;
                }
                case 5: {
                    int x = centerX + 2;
                    int y = centerY;
                    g2.drawLine(x - 6, y - 4, x - 6, y + 4);
                    g2.drawLine(x + 1, y - 4, x + 1, y + 4);
                    g2.drawLine(x - 6, y - 4, x + 1, y - 4);
                    g2.drawLine(x - 4, y - 2, x - 1, y - 2);
                    g2.drawLine(x - 4, y, x - 1, y);
                    g2.drawLine(x - 4, y + 2, x - 1, y + 2);
                    g2.drawLine(x - 6, y + 4, x + 1, y + 4);
                    break;
                }
            }
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        public boolean scrollsForward() {
            return this.getType() == 1 || this.getType() == 4;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.setMousePressed(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMousePressed(true);
            this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMousePressed(false);
            this.setMouseOver(false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(false);
            this.setMousePressed(false);
            this.repaint();
            BasicJideTabbedPaneUI.this._tabScroller.tabPanel.repaint();
        }

        public int getType() {
            return this._type;
        }

        public void setType(int type) {
            this._type = type;
        }

        public boolean isMouseOver() {
            return this._mouseOver;
        }

        public void setMouseOver(boolean mouseOver) {
            this._mouseOver = mouseOver;
        }

        public boolean isMousePressed() {
            return this._mousePressed;
        }

        public void setMousePressed(boolean mousePressed) {
            this._mousePressed = mousePressed;
        }
    }

    public class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public void scrollIndexToVisible(int index) {
            Rectangle rect = new Rectangle(BasicJideTabbedPaneUI.this._rects[index]);
            if (!(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() != 1 && BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() != 3 || BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight() || index != 0)) {
                rect.width += BasicJideTabbedPaneUI.this.getLeftMargin();
            }
            this.scrollRectToVisible(rect);
        }

        @Override
        public void scrollRectToVisible(Rectangle aRect) {
            super.scrollRectToVisible(aRect);
        }

        @Override
        public Dimension getPreferredSize() {
            if (BasicJideTabbedPaneUI.this._rects == null || BasicJideTabbedPaneUI.this._rects.length <= 0) {
                return new Dimension(0, 0);
            }
            if (BasicJideTabbedPaneUI.this._tabPane != null && (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3)) {
                ComponentOrientation componentOrientation = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation();
                if (componentOrientation == null || componentOrientation.isLeftToRight()) {
                    return new Dimension(BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].x + BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].width + 10, BasicJideTabbedPaneUI.this._rects[0].y + BasicJideTabbedPaneUI.this._rects[0].height);
                }
                return new Dimension(BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width + BasicJideTabbedPaneUI.this.getLeftMargin(), BasicJideTabbedPaneUI.this._rects[0].y + BasicJideTabbedPaneUI.this._rects[0].height);
            }
            return new Dimension(BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width, BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].y + BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].height);
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 1;
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 1;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            if (BasicJideTabbedPaneUI.this._tabPane.isOpaque()) {
                if (BasicJideTabbedPaneUI.this.getTabShape() == 3) {
                    g2.setColor(UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground"));
                } else {
                    g2.setColor(UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackground"));
                }
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            BasicJideTabbedPaneUI.this.paintTabArea(g2, BasicJideTabbedPaneUI.this._tabPane.getTabPlacement(), BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex(), this);
        }

        @Override
        public void setToolTipText(String text) {
            BasicJideTabbedPaneUI.this._tabPane.setToolTipText(text);
        }

        @Override
        public String getToolTipText() {
            return BasicJideTabbedPaneUI.this._tabPane.getToolTipText();
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return BasicJideTabbedPaneUI.this._tabPane.getToolTipText(SwingUtilities.convertMouseEvent(this, event, BasicJideTabbedPaneUI.this._tabPane));
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            return BasicJideTabbedPaneUI.this._tabPane.getToolTipLocation(SwingUtilities.convertMouseEvent(this, event, BasicJideTabbedPaneUI.this._tabPane));
        }

        @Override
        public JToolTip createToolTip() {
            return BasicJideTabbedPaneUI.this._tabPane.createToolTip();
        }

        @Override
        public void doLayout() {
            if (BasicJideTabbedPaneUI.this._tabContainer != null && BasicJideTabbedPaneUI.this._tabContainer.getParent() == this) {
                BasicJideTabbedPaneUI.this._tabContainer.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    public class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setOpaque(false);
        }

        @Override
        public void setViewPosition(Point p) {
            super.setViewPosition(p);
        }

        @Override
        public Color getBackground() {
            return UIDefaultsLookup.getColor("JideTabbedPane.background");
        }
    }

    public class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public JButton scrollForwardButton;
        public JButton scrollBackwardButton;
        public JButton listButton;
        public JButton closeButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int tabPlacement) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.scrollForwardButton = BasicJideTabbedPaneUI.this.createButton(1);
            this.scrollBackwardButton = BasicJideTabbedPaneUI.this.createButton(2);
            this.scrollForwardButton.setBackground(this.viewport.getBackground());
            this.scrollBackwardButton.setBackground(this.viewport.getBackground());
            this.listButton = BasicJideTabbedPaneUI.this.createButton(5);
            this.listButton.setBackground(this.viewport.getBackground());
            this.closeButton = BasicJideTabbedPaneUI.this.createButton(0);
            this.closeButton.setBackground(this.viewport.getBackground());
        }

        public void createPopupMenu(int tabPlacement) {
            JPopupMenu popup = new JPopupMenu();
            int totalCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            int selectedIndex = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            for (int i = 0; i < totalCount; ++i) {
                if (!BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(i)) continue;
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(new ActivateTabAction(BasicJideTabbedPaneUI.this._tabPane.getTitleAt(i), BasicJideTabbedPaneUI.this._tabPane.getIconForTab(i), i));
                popup.add(item);
                item.setToolTipText(BasicJideTabbedPaneUI.this._tabPane.getToolTipTextAt(i));
                item.setSelected(selectedIndex == i);
                item.setHorizontalTextPosition(4);
            }
            Dimension preferredSize = popup.getPreferredSize();
            Rectangle bounds = this.listButton.getBounds();
            switch (tabPlacement) {
                case 1: {
                    popup.show(BasicJideTabbedPaneUI.this._tabPane, bounds.x + bounds.width - preferredSize.width, bounds.y + bounds.height);
                    break;
                }
                case 3: {
                    popup.show(BasicJideTabbedPaneUI.this._tabPane, bounds.x + bounds.width - preferredSize.width, bounds.y - preferredSize.height);
                    break;
                }
                case 2: {
                    popup.show(BasicJideTabbedPaneUI.this._tabPane, bounds.x + bounds.width, bounds.y + bounds.height - preferredSize.height);
                    break;
                }
                case 4: {
                    popup.show(BasicJideTabbedPaneUI.this._tabPane, bounds.x - preferredSize.width, bounds.y + bounds.height - preferredSize.height);
                }
            }
        }

        public void createPopup(int tabPlacement) {
            BasicJideTabbedPaneUI.this._tabPane.showTabListPopup(this.listButton);
        }

        public void scrollForward(int tabPlacement) {
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            if (tabPlacement == 1 || tabPlacement == 3 ? (BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight() ? viewRect.width >= viewSize.width - viewRect.x : viewRect.x <= 0) : viewRect.height >= viewSize.height - viewRect.y) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int tabPlacement) {
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex > 0 ? this.leadingTabIndex - 1 : 0);
        }

        public void setLeadingTabIndex(int tabPlacement, int index) {
            if (index < 0 || index >= BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                return;
            }
            this.leadingTabIndex = index;
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            switch (tabPlacement) {
                case 1: 
                case 3: {
                    this.tabViewPosition.y = 0;
                    if (BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight()) {
                        int n = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].x;
                        if (viewSize.width - this.tabViewPosition.x >= viewRect.width) break;
                        this.tabViewPosition.x = viewSize.width - viewRect.width;
                        break;
                    }
                    if (BasicJideTabbedPaneUI.this._rects.length <= 0) {
                        this.tabViewPosition.x = 0;
                        break;
                    }
                    if (BasicJideTabbedPaneUI.this._rects.length == 1) {
                        this.tabViewPosition.x = BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width + BasicJideTabbedPaneUI.this._additionalWidth - viewRect.width;
                        break;
                    }
                    Insets tabAreaInsets = BasicJideTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
                    Rectangle[] tempRects = BasicJideTabbedPaneUI.this._rects;
                    if (BasicJideTabbedPaneUI.this._rects[0].x < BasicJideTabbedPaneUI.this._rects[1].x) {
                        tempRects = new Rectangle[BasicJideTabbedPaneUI.this._rects.length];
                        int rightMargin = 0;
                        if (BasicJideTabbedPaneUI.this._rects.length > 0) {
                            rightMargin = BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].x + BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].width;
                            BasicJideTabbedPaneUI.this._additionalWidth = BasicJideTabbedPaneUI.this._rects[0].x;
                        }
                        for (int i = 0; i < BasicJideTabbedPaneUI.this._tabCount; ++i) {
                            tempRects[i] = new Rectangle(BasicJideTabbedPaneUI.this._rects[i]);
                            tempRects[i].x = rightMargin - BasicJideTabbedPaneUI.this._rects[i].x - BasicJideTabbedPaneUI.this._rects[i].width + tabAreaInsets.left;
                        }
                    }
                    this.tabViewPosition.x = tempRects[this.leadingTabIndex].x + tempRects[this.leadingTabIndex].width + (this.leadingTabIndex == 0 ? BasicJideTabbedPaneUI.this._additionalWidth : 0) - viewRect.width;
                    break;
                }
                case 2: 
                case 4: {
                    this.tabViewPosition.x = 0;
                    int n = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].y;
                    if (viewSize.height - this.tabViewPosition.y >= viewRect.height) break;
                    this.tabViewPosition.y = viewSize.height - viewRect.height;
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (BasicJideTabbedPaneUI.this._tabPane == null) {
                return;
            }
            int tabPlacement = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            if (BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight() || tabPlacement != 1 && tabPlacement != 3) {
                BasicJideTabbedPaneUI.this.ensureCurrentLayout();
            }
            JViewport viewport = (JViewport)e.getSource();
            int tabCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            Rectangle vpRect = viewport.getBounds();
            Dimension viewSize = viewport.getViewSize();
            Rectangle viewRect = viewport.getViewRect();
            if (!(tabPlacement != 1 && tabPlacement != 3 || BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight())) {
                this.leadingTabIndex = BasicJideTabbedPaneUI.this.getClosestTab(viewRect.x + viewRect.width - 1, viewRect.y + viewRect.height - 1);
                if (this.leadingTabIndex < 0) {
                    this.leadingTabIndex = 0;
                }
            } else {
                this.leadingTabIndex = BasicJideTabbedPaneUI.this.getClosestTab(viewRect.x, viewRect.y);
            }
            if (this.leadingTabIndex < BasicJideTabbedPaneUI.this._rects.length && this.leadingTabIndex >= BasicJideTabbedPaneUI.this._rects.length) {
                switch (tabPlacement) {
                    case 1: 
                    case 3: {
                        if (BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].x >= viewRect.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].y >= viewRect.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets contentInsets = BasicJideTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            if (BasicJideTabbedPaneUI.this._rects.length > 0) {
                Rectangle rect = BasicJideTabbedPaneUI.this._rects[0];
                switch (tabPlacement) {
                    case 2: {
                        BasicJideTabbedPaneUI.this._tabPane.repaint(vpRect.x + vpRect.width, vpRect.y, contentInsets.left, vpRect.height);
                        this.scrollBackwardButton.setEnabled(viewRect.y > 0 || this.leadingTabIndex > 0);
                        this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                        break;
                    }
                    case 4: {
                        BasicJideTabbedPaneUI.this._tabPane.repaint(vpRect.x - contentInsets.right, vpRect.y, contentInsets.right, vpRect.height);
                        this.scrollBackwardButton.setEnabled(viewRect.y > 0 || this.leadingTabIndex > 0);
                        this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                        break;
                    }
                    case 3: {
                        boolean enabled;
                        BasicJideTabbedPaneUI.this._tabPane.repaint(vpRect.x, vpRect.y - contentInsets.bottom, vpRect.width, contentInsets.bottom);
                        if (BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight()) {
                            this.scrollBackwardButton.setEnabled(viewRect.x > 0 || this.leadingTabIndex > 0);
                            this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                            break;
                        }
                        this.scrollBackwardButton.setEnabled(rect.x + rect.width + BasicJideTabbedPaneUI.this._additionalWidth - BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewPosition().x > viewRect.width);
                        boolean bl = enabled = this.leadingTabIndex < tabCount - 1 && BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewPosition().x > 0;
                        if (enabled && BasicJideTabbedPaneUI.this._rects.length > 0 && rect.x + rect.width + BasicJideTabbedPaneUI.this._additionalWidth - BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].x < viewRect.width) {
                            enabled = false;
                        }
                        this.scrollForwardButton.setEnabled(enabled);
                        break;
                    }
                    default: {
                        boolean enabled;
                        BasicJideTabbedPaneUI.this._tabPane.repaint(vpRect.x, vpRect.y + vpRect.height, vpRect.width, contentInsets.top);
                        if (BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight()) {
                            this.scrollBackwardButton.setEnabled(viewRect.x > 0 || this.leadingTabIndex > 0);
                            this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                            break;
                        }
                        this.scrollBackwardButton.setEnabled(rect.x + rect.width + BasicJideTabbedPaneUI.this._additionalWidth - BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewPosition().x > viewRect.width);
                        boolean bl = enabled = this.leadingTabIndex < tabCount - 1 && BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewPosition().x > 0;
                        if (enabled && BasicJideTabbedPaneUI.this._rects.length > 0 && rect.x + rect.width + BasicJideTabbedPaneUI.this._additionalWidth - BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].x < viewRect.width) {
                            enabled = false;
                        }
                        this.scrollForwardButton.setEnabled(enabled);
                    }
                }
            }
            if (SystemInfo.isJdk15Above()) {
                BasicJideTabbedPaneUI.this._tabPane.setComponentZOrder(BasicJideTabbedPaneUI.this._tabScroller.scrollForwardButton, 0);
                BasicJideTabbedPaneUI.this._tabPane.setComponentZOrder(BasicJideTabbedPaneUI.this._tabScroller.scrollBackwardButton, 0);
            }
            BasicJideTabbedPaneUI.this._tabScroller.scrollForwardButton.repaint();
            BasicJideTabbedPaneUI.this._tabScroller.scrollBackwardButton.repaint();
            int selectedIndex = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            if (selectedIndex >= 0 && selectedIndex < BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                this.closeButton.setEnabled(BasicJideTabbedPaneUI.this._tabPane.isTabClosableAt(selectedIndex));
            }
        }

        public String toString() {
            return "viewport.viewSize=" + this.viewport.getViewSize() + "\nviewport.viewRectangle=" + this.viewport.getViewRect() + "\nleadingTabIndex=" + this.leadingTabIndex + "\ntabViewPosition=" + this.tabViewPosition;
        }
    }

    protected class ActivateTabAction
    extends AbstractAction {
        int _tabIndex;
        private static final long serialVersionUID = 3270152106579039554L;

        public ActivateTabAction(String name, Icon icon, int tabIndex) {
            super(name, icon);
            this._tabIndex = tabIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(this._tabIndex);
        }
    }

    protected class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        protected TabbedPaneScrollLayout() {
        }

        @Override
        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return BasicJideTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
        }

        @Override
        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            int tabPlacement = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            int tabCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            int selectedIndex = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            Component visibleComponent = BasicJideTabbedPaneUI.this.getVisibleComponent();
            boolean leftToRight = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight();
            JViewport viewport = null;
            this.calculateLayoutInfo();
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    BasicJideTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component selectedComponent = selectedIndex >= BasicJideTabbedPaneUI.this._tabPane.getTabCount() ? null : BasicJideTabbedPaneUI.this._tabPane.getComponentAt(selectedIndex);
                boolean shouldChangeFocus = false;
                if (selectedComponent != null) {
                    if (selectedComponent != visibleComponent && visibleComponent != null && JideSwingUtilities.isAncestorOfFocusOwner(visibleComponent) && BasicJideTabbedPaneUI.this._tabPane.isAutoRequestFocus()) {
                        shouldChangeFocus = true;
                    }
                    BasicJideTabbedPaneUI.this.setVisibleComponent(selectedComponent);
                }
                Insets contentInsets = BasicJideTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
                Rectangle bounds = BasicJideTabbedPaneUI.this._tabPane.getBounds();
                int numChildren = BasicJideTabbedPaneUI.this._tabPane.getComponentCount();
                Dimension lsize = new Dimension(0, 0);
                Dimension tsize = new Dimension(0, 0);
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                    lsize = BasicJideTabbedPaneUI.this._tabLeadingComponent.getPreferredSize();
                }
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                    tsize = BasicJideTabbedPaneUI.this._tabTrailingComponent.getPreferredSize();
                }
                if (numChildren > 0) {
                    boolean verticalTabRuns;
                    int ch;
                    int cw;
                    int cy;
                    int cx;
                    int ty;
                    int tx;
                    int th;
                    int tw;
                    switch (tabPlacement) {
                        case 2: {
                            tw = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(1, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                            th = bounds.height - insets.top - insets.bottom;
                            tx = insets.left;
                            ty = insets.top;
                            if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                ty += lsize.height;
                                th -= lsize.height;
                                if (lsize.width > tw) {
                                    tw = lsize.width;
                                }
                            }
                            if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                th -= tsize.height;
                                if (tsize.width > tw) {
                                    tw = tsize.width;
                                }
                            }
                            cx = tx + tw + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        case 4: {
                            tw = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(1, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                            th = bounds.height - insets.top - insets.bottom;
                            tx = bounds.width - insets.right - tw;
                            ty = insets.top;
                            if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                ty += lsize.height;
                                th -= lsize.height;
                                if (lsize.width > tw) {
                                    tw = lsize.width;
                                    tx = bounds.width - insets.right - tw;
                                }
                            }
                            if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                th -= tsize.height;
                                if (tsize.width > tw) {
                                    tw = tsize.width;
                                    tx = bounds.width - insets.right - tw;
                                }
                            }
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        case 3: {
                            tw = bounds.width - insets.left - insets.right;
                            th = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                            tx = insets.left;
                            ty = bounds.height - insets.bottom - th;
                            if (leftToRight) {
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    tx += lsize.width;
                                    tw -= lsize.width;
                                    if (lsize.height > th) {
                                        th = lsize.height;
                                        ty = bounds.height - insets.bottom - th;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    tw -= tsize.width;
                                    if (tsize.height > th) {
                                        th = tsize.height;
                                        ty = bounds.height - insets.bottom - th;
                                    }
                                }
                            } else {
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    tx += tsize.width;
                                    tw -= tsize.width;
                                    if (tsize.height > th) {
                                        th = tsize.height;
                                        ty = bounds.height - insets.bottom - th;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    tw -= lsize.width;
                                    if (lsize.height > th) {
                                        th = lsize.height;
                                        ty = bounds.height - insets.bottom - th;
                                    }
                                }
                            }
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                            break;
                        }
                        default: {
                            tw = bounds.width - insets.left - insets.right;
                            th = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                            tx = insets.left;
                            ty = insets.top;
                            Insets tabAreaInsets = BasicJideTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
                            if (tabAreaInsets != null) {
                                tx += tabAreaInsets.left;
                                tw -= tabAreaInsets.left + tabAreaInsets.right;
                            }
                            if (leftToRight) {
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    tx += lsize.width;
                                    tw -= lsize.width;
                                    if (lsize.height > th) {
                                        th = lsize.height;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    tw -= tsize.width;
                                    if (tsize.height > th) {
                                        th = tsize.height;
                                    }
                                }
                            } else {
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    tx += tsize.width;
                                    tw -= tsize.width;
                                    if (tsize.height > th) {
                                        th = tsize.height;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    tw -= lsize.width;
                                    if (lsize.height > th) {
                                        th = lsize.height;
                                    }
                                }
                            }
                            cx = insets.left + contentInsets.left;
                            cy = insets.top + th + contentInsets.top;
                            cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                            ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                        }
                    }
                    for (int i = 0; i < numChildren; ++i) {
                        Component child = BasicJideTabbedPaneUI.this._tabPane.getComponent(i);
                        boolean tabButtonsVisible = true;
                        if (child instanceof ScrollableTabViewport) {
                            viewport = (JViewport)child;
                            int vx = tx;
                            int vw = tw;
                            int vy = ty;
                            int vh = th;
                            int numberOfButtons = BasicJideTabbedPaneUI.this.getNumberOfTabButtons();
                            switch (tabPlacement) {
                                case 2: 
                                case 4: {
                                    int totalTabHeight = BasicJideTabbedPaneUI.this._rects[tabCount - 1].y + BasicJideTabbedPaneUI.this._rects[tabCount - 1].height;
                                    if (totalTabHeight > th && BasicJideTabbedPaneUI.this._tabPane.getTabCount() > 1 || BasicJideTabbedPaneUI.this.isShowTabButtons()) {
                                        if (!BasicJideTabbedPaneUI.this.isShowTabButtons()) {
                                            numberOfButtons += 3;
                                        }
                                        vh = Math.max(th - BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons, 0);
                                    } else {
                                        vh = Math.max(th - BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons, 0);
                                        tabButtonsVisible = false;
                                    }
                                    if (vh + BasicJideTabbedPaneUI.this.getLayoutSize() >= th - BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons) break;
                                    vh += BasicJideTabbedPaneUI.this.getLayoutSize();
                                    break;
                                }
                                default: {
                                    boolean widthEnough;
                                    int totalTabWidth = 0;
                                    if (BasicJideTabbedPaneUI.this._rects.length > 0) {
                                        totalTabWidth = leftToRight ? BasicJideTabbedPaneUI.this._rects[tabCount - 1].x + BasicJideTabbedPaneUI.this._rects[tabCount - 1].width : BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width + BasicJideTabbedPaneUI.this.getLeftMargin();
                                    }
                                    boolean bl = widthEnough = totalTabWidth <= tw || BasicJideTabbedPaneUI.this._tabPane.getTabResizeMode() == 2;
                                    if (BasicJideTabbedPaneUI.this.isShowTabButtons() || !widthEnough && BasicJideTabbedPaneUI.this._tabPane.getTabCount() > 1) {
                                        if (!BasicJideTabbedPaneUI.this.isShowTabButtons()) {
                                            numberOfButtons += 3;
                                        }
                                        vw = Math.max(tw - BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons, 0);
                                        if (!leftToRight) {
                                            vx += BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons;
                                        }
                                    } else {
                                        tabButtonsVisible = false;
                                        vw = Math.max(tw - BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons, 0);
                                        if (!leftToRight) {
                                            vx += BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons;
                                        }
                                    }
                                    if (vw + BasicJideTabbedPaneUI.this.getLayoutSize() >= tw - BasicJideTabbedPaneUI.this._buttonSize * numberOfButtons) break;
                                    vw += BasicJideTabbedPaneUI.this.getLayoutSize();
                                    if (leftToRight) break;
                                    vx -= BasicJideTabbedPaneUI.this.getLayoutSize();
                                }
                            }
                            if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null && BasicJideTabbedPaneUI.this._tabPane.isHideTrailingWhileNoButtons()) {
                                BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(tabButtonsVisible);
                            }
                            child.setBounds(vx, vy, vw, vh);
                            try {
                                if (leftToRight || tabPlacement != 1 && tabPlacement != 3) continue;
                                if (BasicJideTabbedPaneUI.this.getTabResizeMode() == 2) {
                                    viewport.setViewPosition(new Point(0, 0));
                                    continue;
                                }
                                if (BasicJideTabbedPaneUI.this._layouted) continue;
                                BasicJideTabbedPaneUI.this._tabScroller.setLeadingTabIndex(tabPlacement, 0);
                                continue;
                            }
                            finally {
                                BasicJideTabbedPaneUI.this._layouted = true;
                            }
                        }
                        if (child instanceof JideTabbedPane.NoFocusButton) {
                            JideTabbedPane.NoFocusButton scrollbutton = (JideTabbedPane.NoFocusButton)child;
                            if (BasicJideTabbedPaneUI.this._tabPane.isTabShown() && (scrollbutton.getType() != 0 || !BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab())) {
                                Dimension bsize = scrollbutton.getPreferredSize();
                                int bx = 0;
                                int by = 0;
                                int bw = bsize.width;
                                int bh = bsize.height;
                                boolean visible = false;
                                switch (tabPlacement) {
                                    case 2: 
                                    case 4: {
                                        int dir;
                                        int totalTabHeight = BasicJideTabbedPaneUI.this._rects[tabCount - 1].y + BasicJideTabbedPaneUI.this._rects[tabCount - 1].height;
                                        if (BasicJideTabbedPaneUI.this._tabPane.isTabShown() && (BasicJideTabbedPaneUI.this.isShowTabButtons() || totalTabHeight > th && BasicJideTabbedPaneUI.this._tabPane.getTabCount() > 1)) {
                                            dir = scrollbutton.getType();
                                            scrollbutton.setType(dir);
                                            switch (dir) {
                                                case 0: {
                                                    if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                        visible = true;
                                                        by = bounds.height - insets.top - bsize.height - 5;
                                                        break;
                                                    }
                                                    visible = false;
                                                    by = 0;
                                                    break;
                                                }
                                                case 5: {
                                                    visible = true;
                                                    by = bounds.height - insets.top - (2 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.height - 5;
                                                    break;
                                                }
                                                case 1: {
                                                    visible = !BasicJideTabbedPaneUI.this.isShrinkTabs();
                                                    by = bounds.height - insets.top - (3 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.height - 5;
                                                    break;
                                                }
                                                case 2: {
                                                    visible = !BasicJideTabbedPaneUI.this.isShrinkTabs();
                                                    by = bounds.height - insets.top - (4 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.height - 5;
                                                }
                                            }
                                            bx = tx + 2;
                                        } else {
                                            tabButtonsVisible = false;
                                            dir = scrollbutton.getType();
                                            scrollbutton.setType(dir);
                                            if (dir == 0) {
                                                if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                    visible = true;
                                                    by = bounds.height - insets.top - bsize.height - 5;
                                                } else {
                                                    visible = false;
                                                    by = 0;
                                                }
                                                bx = tx + 2;
                                            }
                                        }
                                        if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null && BasicJideTabbedPaneUI.this._tabPane.isHideTrailingWhileNoButtons()) {
                                            BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(tabButtonsVisible);
                                        }
                                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                            by -= tsize.height;
                                        }
                                        int temp = -1;
                                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && lsize.width >= BasicJideTabbedPaneUI.this._rects[0].width && tabPlacement == 2) {
                                            bx += lsize.width - BasicJideTabbedPaneUI.this._rects[0].width;
                                            temp = lsize.width;
                                        }
                                        if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || tsize.width < BasicJideTabbedPaneUI.this._rects[0].width || temp >= tsize.width || tabPlacement != 2) break;
                                        bx += tsize.width - BasicJideTabbedPaneUI.this._rects[0].width;
                                        break;
                                    }
                                    default: {
                                        int dir;
                                        boolean widthEnough;
                                        int totalTabWidth = 0;
                                        if (BasicJideTabbedPaneUI.this._rects.length > 0) {
                                            totalTabWidth = leftToRight ? BasicJideTabbedPaneUI.this._rects[tabCount - 1].x + BasicJideTabbedPaneUI.this._rects[tabCount - 1].width : BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width + BasicJideTabbedPaneUI.this._additionalWidth;
                                        }
                                        boolean bl = widthEnough = totalTabWidth <= tw || BasicJideTabbedPaneUI.this._tabPane.getTabResizeMode() == 2;
                                        if (BasicJideTabbedPaneUI.this._tabPane.isTabShown() && (BasicJideTabbedPaneUI.this.isShowTabButtons() || !widthEnough && BasicJideTabbedPaneUI.this._tabPane.getTabCount() > 1 || scrollbutton.getType() == 0 && BasicJideTabbedPaneUI.this.isShowCloseButton())) {
                                            dir = scrollbutton.getType();
                                            scrollbutton.setType(dir);
                                            switch (dir) {
                                                case 0: {
                                                    if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                        visible = true;
                                                        if (leftToRight) {
                                                            bx = bounds.width - insets.left - bsize.width - 5;
                                                            break;
                                                        }
                                                        bx = insets.left - 5;
                                                        break;
                                                    }
                                                    visible = false;
                                                    bx = 0;
                                                    break;
                                                }
                                                case 5: {
                                                    visible = true;
                                                    if (leftToRight) {
                                                        bx = bounds.width - insets.left - (2 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.width - 5;
                                                        break;
                                                    }
                                                    bx = insets.left + (1 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.width + 5;
                                                    break;
                                                }
                                                case 1: {
                                                    boolean bl2 = visible = !BasicJideTabbedPaneUI.this.isShrinkTabs();
                                                    if (leftToRight) {
                                                        bx = bounds.width - insets.left - (3 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.width - 5;
                                                        break;
                                                    }
                                                    bx = insets.left + (2 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.width + 5;
                                                    break;
                                                }
                                                case 2: {
                                                    boolean bl3 = visible = !BasicJideTabbedPaneUI.this.isShrinkTabs();
                                                    bx = leftToRight ? bounds.width - insets.left - (4 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.width - 5 : insets.left + (3 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * bsize.width + 5;
                                                }
                                            }
                                            by = (th - bsize.height >> 1) + ty;
                                        } else {
                                            tabButtonsVisible = false;
                                            dir = scrollbutton.getType();
                                            scrollbutton.setType(dir);
                                            if (dir == 0) {
                                                if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                    visible = true;
                                                    bx = bounds.width - insets.left - bsize.width - 5;
                                                } else {
                                                    visible = false;
                                                    bx = 0;
                                                }
                                                by = (th - bsize.height >> 1) + ty;
                                            }
                                        }
                                        if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null && BasicJideTabbedPaneUI.this._tabPane.isHideTrailingWhileNoButtons()) {
                                            BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(tabButtonsVisible);
                                        }
                                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                            bx = leftToRight ? (bx -= tsize.width) : (bx += tsize.width);
                                        }
                                        int temp = -1;
                                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && lsize.height >= BasicJideTabbedPaneUI.this._rects[0].height) {
                                            if (tabPlacement == 1) {
                                                by = ty + 2 + lsize.height - BasicJideTabbedPaneUI.this._rects[0].height;
                                                temp = lsize.height;
                                            } else {
                                                by = ty + 2;
                                            }
                                        }
                                        if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || tsize.height < BasicJideTabbedPaneUI.this._rects[0].height || temp >= tsize.height) break;
                                        by = tabPlacement == 1 ? ty + 2 + tsize.height - BasicJideTabbedPaneUI.this._rects[0].height : ty + 2;
                                    }
                                }
                                child.setVisible(visible);
                                if (!visible) continue;
                                child.setBounds(bx, by, bw, bh);
                                continue;
                            }
                            scrollbutton.setBounds(0, 0, 0, 0);
                            continue;
                        }
                        if (child == BasicJideTabbedPaneUI.this._tabPane.getTabLeadingComponent() || child == BasicJideTabbedPaneUI.this._tabPane.getTabTrailingComponent()) continue;
                        if (BasicJideTabbedPaneUI.this._tabPane.isShowTabContent()) {
                            child.setBounds(cx, cy, cw, ch);
                            continue;
                        }
                        child.setBounds(0, 0, 0, 0);
                    }
                    if (leftToRight) {
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx + tw - lsize.width, ty - lsize.height, lsize.width, lsize.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx, ty - lsize.height, lsize.width, lsize.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx - lsize.width, ty, lsize.width, lsize.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx - lsize.width, ty + th - lsize.height, lsize.width, lsize.height);
                                }
                            }
                        }
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx + tw - tsize.width, ty + th, tsize.width, tsize.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx, ty + th, tsize.width, tsize.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx + tw, ty, tsize.width, tsize.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx + tw, ty + th - tsize.height, tsize.width, tsize.height);
                                    break;
                                }
                            }
                        }
                    } else {
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx + tw - tsize.width, ty - tsize.height, tsize.width, tsize.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx, ty - tsize.height, tsize.width, tsize.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx - tsize.width, ty, tsize.width, tsize.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(tx - tsize.width, ty + th - tsize.height, tsize.width, tsize.height);
                                }
                            }
                        }
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx + tw - lsize.width, ty + th, lsize.width, lsize.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx, ty + th, lsize.width, lsize.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx + tw, ty, lsize.width, lsize.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(tx + tw, ty + th - lsize.height, lsize.width, lsize.height);
                                }
                            }
                        }
                    }
                    boolean bl = verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
                    if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() && BasicJideTabbedPaneUI.this._tabPane.isLayoutTrailingComponentBeforeButtons()) {
                        ArrayList<JButton> buttons = new ArrayList<JButton>();
                        for (int i = 0; i < numChildren; ++i) {
                            Component child = BasicJideTabbedPaneUI.this._tabPane.getComponent(i);
                            if (!(child instanceof JButton) || !(child instanceof UIResource) || child == BasicJideTabbedPaneUI.this._tabLeadingComponent || child == BasicJideTabbedPaneUI.this._tabTrailingComponent || !child.isVisible() || child.getBounds().width == 0) continue;
                            buttons.add((JButton)child);
                        }
                        if (buttons.size() > 0) {
                            int offset;
                            Rectangle lastButtonRect = ((JButton)buttons.get(buttons.size() - 1)).getBounds();
                            Rectangle firstButtonRect = ((JButton)buttons.get(0)).getBounds();
                            Rectangle trailingCompRect = BasicJideTabbedPaneUI.this._tabTrailingComponent.getBounds();
                            if (!verticalTabRuns) {
                                BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(new Rectangle(firstButtonRect.x, trailingCompRect.y, trailingCompRect.width, trailingCompRect.height));
                                offset = BasicJideTabbedPaneUI.this._tabTrailingComponent.getWidth() - (lastButtonRect.x + lastButtonRect.width - firstButtonRect.x);
                                for (JButton button : buttons) {
                                    Rectangle buttonRect = button.getBounds();
                                    button.setBounds(trailingCompRect.x + offset + buttonRect.x - firstButtonRect.x, buttonRect.y, buttonRect.width, buttonRect.height);
                                }
                            } else {
                                BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(new Rectangle(trailingCompRect.x, firstButtonRect.y, trailingCompRect.width, trailingCompRect.height));
                                offset = BasicJideTabbedPaneUI.this._tabTrailingComponent.getHeight() - (lastButtonRect.y + lastButtonRect.height - firstButtonRect.y);
                                for (JButton button : buttons) {
                                    Rectangle buttonRect = button.getBounds();
                                    button.setBounds(buttonRect.x, trailingCompRect.y + offset + buttonRect.y - firstButtonRect.y, buttonRect.width, buttonRect.height);
                                }
                            }
                        }
                    }
                    if (!(leftToRight || verticalTabRuns || viewport == null || viewport.getSize().equals(BasicJideTabbedPaneUI.this._tabPane.getSize()))) {
                        int n = BasicJideTabbedPaneUI.this._tabScroller.tabPanel.getWidth() - viewport.getWidth();
                    }
                    BasicJideTabbedPaneUI.this.updateCloseButtons();
                    ((TabbedPaneLayout)this).layoutTabComponents();
                    if (shouldChangeFocus && !BasicJideTabbedPaneUI.this.requestFocusForVisibleComponent() && !BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow()) {
                        BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                    }
                }
            }
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Dimension size = BasicJideTabbedPaneUI.this._tabPane.getSize();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            Insets tabAreaInsets = BasicJideTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight();
            int x = tabAreaInsets.left;
            int y = tabAreaInsets.top;
            Dimension lsize = new Dimension(0, 0);
            Dimension tsize = new Dimension(0, 0);
            if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                lsize = BasicJideTabbedPaneUI.this._tabLeadingComponent.getPreferredSize();
            }
            if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                tsize = BasicJideTabbedPaneUI.this._tabTrailingComponent.getPreferredSize();
            }
            int calculatedMaxTabHeight = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && tabPlacement == 4 && BasicJideTabbedPaneUI.this._maxTabWidth < lsize.width) {
                        BasicJideTabbedPaneUI.this._maxTabWidth = lsize.width;
                    }
                    if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || tabPlacement != 4 || BasicJideTabbedPaneUI.this._maxTabWidth >= tsize.width) break;
                    BasicJideTabbedPaneUI.this._maxTabWidth = tsize.width;
                    break;
                }
                default: {
                    BasicJideTabbedPaneUI.this._maxTabHeight = calculatedMaxTabHeight;
                    if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && tabPlacement == 3 && BasicJideTabbedPaneUI.this._maxTabHeight < lsize.height) {
                        BasicJideTabbedPaneUI.this._maxTabHeight = lsize.height;
                    }
                    if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || tabPlacement != 3 || BasicJideTabbedPaneUI.this._maxTabHeight >= tsize.height) break;
                    BasicJideTabbedPaneUI.this._maxTabHeight = tsize.height;
                }
            }
            BasicJideTabbedPaneUI.this._runCount = 0;
            BasicJideTabbedPaneUI.this._selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            BasicJideTabbedPaneUI.this._selectedRun = 0;
            BasicJideTabbedPaneUI.this._runCount = 1;
            for (int i = 0; i < tabCount; ++i) {
                int temp;
                FontMetrics metrics = BasicJideTabbedPaneUI.this.getFontMetrics(i);
                Rectangle rect = BasicJideTabbedPaneUI.this._rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = BasicJideTabbedPaneUI.this._rects[i - 1].x + BasicJideTabbedPaneUI.this._rects[i - 1].width;
                    } else {
                        BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                        BasicJideTabbedPaneUI.this._maxTabWidth = 0;
                        rect.x = BasicJideTabbedPaneUI.this.getTabShape() != 3 ? x + BasicJideTabbedPaneUI.this.getLeftMargin() : x;
                    }
                    rect.width = BasicJideTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics) + BasicJideTabbedPaneUI.this._rectSizeExtend;
                    BasicJideTabbedPaneUI.this._maxTabWidth = Math.max(BasicJideTabbedPaneUI.this._maxTabWidth, rect.width);
                    rect.y = y;
                    temp = -1;
                    if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && tabPlacement == 1 && BasicJideTabbedPaneUI.this._maxTabHeight < lsize.height) {
                        rect.y = y + lsize.height - BasicJideTabbedPaneUI.this._maxTabHeight - 2;
                        temp = lsize.height;
                        if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                            rect.y += 2;
                        }
                    }
                    if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() && tabPlacement == 1 && BasicJideTabbedPaneUI.this._maxTabHeight < tsize.height && temp < tsize.height) {
                        rect.y = y + tsize.height - BasicJideTabbedPaneUI.this._maxTabHeight - 2;
                        if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                            rect.y += 2;
                        }
                    }
                    rect.height = calculatedMaxTabHeight;
                    continue;
                }
                if (i > 0) {
                    rect.y = BasicJideTabbedPaneUI.this._rects[i - 1].y + BasicJideTabbedPaneUI.this._rects[i - 1].height;
                } else {
                    BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                    BasicJideTabbedPaneUI.this._maxTabHeight = 0;
                    rect.y = BasicJideTabbedPaneUI.this.getTabShape() != 3 ? y + BasicJideTabbedPaneUI.this.getLeftMargin() : y;
                }
                rect.height = BasicJideTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, metrics) + BasicJideTabbedPaneUI.this._rectSizeExtend;
                BasicJideTabbedPaneUI.this._maxTabHeight = Math.max(BasicJideTabbedPaneUI.this._maxTabHeight, rect.height);
                rect.x = x;
                temp = -1;
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && tabPlacement == 2 && BasicJideTabbedPaneUI.this._maxTabWidth < lsize.width) {
                    rect.x = x + lsize.width - BasicJideTabbedPaneUI.this._maxTabWidth - 2;
                    temp = lsize.width;
                    if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                        rect.x += 2;
                    }
                }
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() && tabPlacement == 2 && BasicJideTabbedPaneUI.this._maxTabWidth < tsize.width && temp < tsize.width) {
                    rect.x = x + tsize.width - BasicJideTabbedPaneUI.this._maxTabWidth - 2;
                    if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                        rect.x += 2;
                    }
                }
                rect.width = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
            }
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = 0;
                if (BasicJideTabbedPaneUI.this._rects.length > 0) {
                    rightMargin = Math.max(BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].x + BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].width, size.width - tabAreaInsets.right);
                    BasicJideTabbedPaneUI.this._additionalWidth = BasicJideTabbedPaneUI.this.getLeftMargin();
                }
                for (int i = 0; i < tabCount; ++i) {
                    BasicJideTabbedPaneUI.this._rects[i].x = rightMargin - BasicJideTabbedPaneUI.this._rects[i].x - BasicJideTabbedPaneUI.this._rects[i].width + tabAreaInsets.left;
                }
            } else {
                BasicJideTabbedPaneUI.this._additionalWidth = 0;
            }
            BasicJideTabbedPaneUI.this.ensureCurrentRects(BasicJideTabbedPaneUI.this.getLeftMargin(), tabCount);
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.calculateSize(false);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.calculateSize(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Dimension calculateSize(boolean minimum) {
            int tabPlacement = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            Insets contentInsets = BasicJideTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            Insets tabAreaInsets = BasicJideTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Dimension zeroSize = new Dimension(0, 0);
            int height = contentInsets.top + contentInsets.bottom;
            int width = contentInsets.left + contentInsets.right;
            int cWidth = 0;
            int cHeight = 0;
            TabbedPaneLayout tabbedPaneLayout = this;
            synchronized (tabbedPaneLayout) {
                BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                this.calculateLayoutInfo();
                if (BasicJideTabbedPaneUI.this._tabPane.isShowTabContent()) {
                    for (int i = 0; i < BasicJideTabbedPaneUI.this._tabPane.getTabCount(); ++i) {
                        Component component = BasicJideTabbedPaneUI.this._tabPane.getComponentAt(i);
                        if (component == null) continue;
                        Dimension size = zeroSize;
                        Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
                        if (size == null) continue;
                        cHeight = Math.max(size.height, cHeight);
                        cWidth = Math.max(size.width, cWidth);
                    }
                    width += cWidth;
                    height += cHeight;
                }
                Dimension lsize = new Dimension(0, 0);
                Dimension tsize = new Dimension(0, 0);
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                    lsize = BasicJideTabbedPaneUI.this._tabLeadingComponent.getPreferredSize();
                }
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                    tsize = BasicJideTabbedPaneUI.this._tabTrailingComponent.getPreferredSize();
                }
                switch (tabPlacement) {
                    case 2: 
                    case 4: {
                        height = Math.max(height, (minimum ? 0 : BasicJideTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement)) + tabAreaInsets.top + tabAreaInsets.bottom);
                        int tabExtent = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            tabExtent = Math.max(lsize.width, tabExtent);
                        }
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            tabExtent = Math.max(tsize.width, tabExtent);
                        }
                        width += tabExtent;
                        break;
                    }
                    default: {
                        width = BasicJideTabbedPaneUI.this._tabPane.getTabResizeMode() == 2 ? Math.max(width, (BasicJideTabbedPaneUI.this._tabPane.getTabCount() << 2) + tabAreaInsets.left + tabAreaInsets.right) : Math.max(width, (minimum ? 0 : BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement)) + tabAreaInsets.left + tabAreaInsets.right);
                        if (!BasicJideTabbedPaneUI.this._tabPane.isTabShown()) break;
                        int tabExtent = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            tabExtent = Math.max(lsize.height, tabExtent);
                        }
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            tabExtent = Math.max(tsize.height, tabExtent);
                        }
                        height += tabExtent;
                    }
                }
            }
            return new Dimension(width + insets.left + insets.right, height + insets.bottom + insets.top);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            int tabCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int rows = 1;
                int x = 0;
                int maxTabHeight = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                for (int i = 0; i < tabCount; ++i) {
                    FontMetrics metrics = BasicJideTabbedPaneUI.this.getFontMetrics(i);
                    int tabWidth = BasicJideTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    if (x != 0 && x + tabWidth > width) {
                        ++rows;
                        x = 0;
                    }
                    x += tabWidth;
                }
                total = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, rows, maxTabHeight);
            }
            return total;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            int tabCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int columns = 1;
                int y = 0;
                BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                for (int i = 0; i < tabCount; ++i) {
                    FontMetrics metrics = BasicJideTabbedPaneUI.this.getFontMetrics(i);
                    int tabHeight = BasicJideTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, metrics);
                    if (y != 0 && y + tabHeight > height) {
                        ++columns;
                        y = 0;
                    }
                    y += tabHeight;
                }
                total = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, columns, BasicJideTabbedPaneUI.this._maxTabWidth);
            }
            return total;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            int tabPlacement = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            int selectedIndex = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            Component visibleComponent = BasicJideTabbedPaneUI.this.getVisibleComponent();
            TabbedPaneLayout tabbedPaneLayout = this;
            synchronized (tabbedPaneLayout) {
                BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                this.calculateLayoutInfo();
                if (selectedIndex < 0) {
                    if (visibleComponent != null) {
                        BasicJideTabbedPaneUI.this.setVisibleComponent(null);
                    }
                } else {
                    int totalTabWidth = 0;
                    int totalTabHeight = 0;
                    Insets contentInsets = BasicJideTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
                    Component selectedComponent = BasicJideTabbedPaneUI.this._tabPane.getComponentAt(selectedIndex);
                    boolean shouldChangeFocus = false;
                    if (selectedComponent != null) {
                        if (selectedComponent != visibleComponent && visibleComponent != null && JideSwingUtilities.isAncestorOfFocusOwner(visibleComponent) && BasicJideTabbedPaneUI.this._tabPane.isAutoRequestFocus()) {
                            shouldChangeFocus = true;
                        }
                        BasicJideTabbedPaneUI.this.setVisibleComponent(selectedComponent);
                    }
                    Rectangle bounds = BasicJideTabbedPaneUI.this._tabPane.getBounds();
                    int numChildren = BasicJideTabbedPaneUI.this._tabPane.getComponentCount();
                    if (numChildren > 0) {
                        int cy;
                        int cx;
                        switch (tabPlacement) {
                            case 2: {
                                totalTabWidth = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                                cx = insets.left + totalTabWidth + contentInsets.left;
                                cy = insets.top + contentInsets.top;
                                break;
                            }
                            case 4: {
                                totalTabWidth = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                                cx = insets.left + contentInsets.left;
                                cy = insets.top + contentInsets.top;
                                break;
                            }
                            case 3: {
                                totalTabHeight = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                                cx = insets.left + contentInsets.left;
                                cy = insets.top + contentInsets.top;
                                break;
                            }
                            default: {
                                totalTabHeight = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                                cx = insets.left + contentInsets.left;
                                cy = insets.top + totalTabHeight + contentInsets.top;
                            }
                        }
                        int cw = bounds.width - totalTabWidth - insets.left - insets.right - contentInsets.left - contentInsets.right;
                        int ch = bounds.height - totalTabHeight - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                        for (int i = 0; i < numChildren; ++i) {
                            Component child = BasicJideTabbedPaneUI.this._tabPane.getComponent(i);
                            if (child == BasicJideTabbedPaneUI.this._tabContainer) {
                                int tabContainerWidth = totalTabWidth == 0 ? bounds.width : totalTabWidth + insets.left + insets.right + contentInsets.left + contentInsets.right;
                                int tabContainerHeight = totalTabHeight == 0 ? bounds.height : totalTabHeight + insets.top + insets.bottom + contentInsets.top + contentInsets.bottom;
                                int tabContainerX = 0;
                                int tabContainerY = 0;
                                if (tabPlacement == 3) {
                                    tabContainerY = bounds.height - tabContainerHeight;
                                } else if (tabPlacement == 4) {
                                    tabContainerX = bounds.width - tabContainerWidth;
                                }
                                child.setBounds(tabContainerX, tabContainerY, tabContainerWidth, tabContainerHeight);
                                continue;
                            }
                            child.setBounds(cx, cy, cw, ch);
                        }
                    }
                    this.layoutTabComponents();
                    if (shouldChangeFocus && !BasicJideTabbedPaneUI.this.requestFocusForVisibleComponent() && !BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow()) {
                        BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                    }
                }
            }
        }

        public void calculateLayoutInfo() {
            int tabCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            BasicJideTabbedPaneUI.this.assureRectsCreated(tabCount);
            this.calculateTabRects(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement(), tabCount);
        }

        private void layoutTabComponents() {
            if (BasicJideTabbedPaneUI.this._tabContainer == null) {
                return;
            }
            Rectangle rect = new Rectangle();
            Point delta = new Point(-BasicJideTabbedPaneUI.this._tabContainer.getX(), -BasicJideTabbedPaneUI.this._tabContainer.getY());
            if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                BasicJideTabbedPaneUI.this.translatePointToTabPanel(0, 0, delta);
            }
            for (int i = 0; i < BasicJideTabbedPaneUI.this._tabPane.getTabCount(); ++i) {
                Component c;
                Component component = c = SystemInfo.isJdk6Above() ? BasicJideTabbedPaneUI.this._tabPane.getTabComponentAt(i) : null;
                if (c == null) continue;
                BasicJideTabbedPaneUI.this.getTabBounds(i, rect);
                Dimension preferredSize = c.getPreferredSize();
                Insets insets = BasicJideTabbedPaneUI.this.getTabInsets(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement(), i);
                int outerX = rect.x + insets.left + delta.x;
                int outerY = rect.y + insets.top + delta.y;
                int outerWidth = rect.width - insets.left - insets.right;
                int outerHeight = rect.height - insets.top - insets.bottom;
                int x = outerX + (outerWidth - preferredSize.width) / 2;
                int y = outerY + (outerHeight - preferredSize.height) / 2;
                int tabPlacement = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
                boolean isSeleceted = i == BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
                c.setBounds(x + BasicJideTabbedPaneUI.this.getTabLabelShiftX(tabPlacement, i, isSeleceted), y + BasicJideTabbedPaneUI.this.getTabLabelShiftY(tabPlacement, i, isSeleceted), preferredSize.width, preferredSize.height);
            }
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Rectangle rect;
            int i;
            int returnAt;
            int y;
            int x;
            Dimension size = BasicJideTabbedPaneUI.this._tabPane.getSize();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            Insets tabAreaInsets = BasicJideTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int selectedIndex = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight();
            int calculatedMaxTabHeight = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            switch (tabPlacement) {
                case 2: {
                    BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 4: {
                    BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = size.width - insets.right - tabAreaInsets.right - BasicJideTabbedPaneUI.this._maxTabWidth;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 3: {
                    BasicJideTabbedPaneUI.this._maxTabHeight = calculatedMaxTabHeight;
                    x = insets.left + tabAreaInsets.left;
                    y = size.height - insets.bottom - tabAreaInsets.bottom - BasicJideTabbedPaneUI.this._maxTabHeight;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                    break;
                }
                default: {
                    BasicJideTabbedPaneUI.this._maxTabHeight = calculatedMaxTabHeight;
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                }
            }
            int tabRunOverlay = BasicJideTabbedPaneUI.this.getTabRunOverlay(tabPlacement);
            BasicJideTabbedPaneUI.this._runCount = 0;
            BasicJideTabbedPaneUI.this._selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            for (i = 0; i < tabCount; ++i) {
                FontMetrics metrics = BasicJideTabbedPaneUI.this.getFontMetrics(i);
                rect = BasicJideTabbedPaneUI.this._rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = BasicJideTabbedPaneUI.this._rects[i - 1].x + BasicJideTabbedPaneUI.this._rects[i - 1].width;
                    } else {
                        BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                        BasicJideTabbedPaneUI.this._runCount = 1;
                        BasicJideTabbedPaneUI.this._maxTabWidth = 0;
                        rect.x = x;
                    }
                    rect.width = BasicJideTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    BasicJideTabbedPaneUI.this._maxTabWidth = Math.max(BasicJideTabbedPaneUI.this._maxTabWidth, rect.width);
                    if (rect.x != 2 + insets.left && rect.x + rect.width > returnAt) {
                        if (BasicJideTabbedPaneUI.this._runCount > BasicJideTabbedPaneUI.this._tabRuns.length - 1) {
                            BasicJideTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicJideTabbedPaneUI.this._tabRuns[BasicJideTabbedPaneUI.this._runCount] = i;
                        ++BasicJideTabbedPaneUI.this._runCount;
                        rect.x = x;
                    }
                    rect.y = y;
                    rect.height = BasicJideTabbedPaneUI.this._maxTabHeight;
                } else {
                    if (i > 0) {
                        rect.y = BasicJideTabbedPaneUI.this._rects[i - 1].y + BasicJideTabbedPaneUI.this._rects[i - 1].height;
                    } else {
                        BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                        BasicJideTabbedPaneUI.this._runCount = 1;
                        BasicJideTabbedPaneUI.this._maxTabHeight = 0;
                        rect.y = y;
                    }
                    rect.height = BasicJideTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, metrics);
                    BasicJideTabbedPaneUI.this._maxTabHeight = Math.max(BasicJideTabbedPaneUI.this._maxTabHeight, rect.height);
                    if (rect.y != 2 + insets.top && rect.y + rect.height > returnAt) {
                        if (BasicJideTabbedPaneUI.this._runCount > BasicJideTabbedPaneUI.this._tabRuns.length - 1) {
                            BasicJideTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicJideTabbedPaneUI.this._tabRuns[BasicJideTabbedPaneUI.this._runCount] = i;
                        ++BasicJideTabbedPaneUI.this._runCount;
                        rect.y = y;
                    }
                    rect.x = x;
                    rect.width = BasicJideTabbedPaneUI.this._maxTabWidth;
                }
                if (i != selectedIndex) continue;
                BasicJideTabbedPaneUI.this._selectedRun = BasicJideTabbedPaneUI.this._runCount - 1;
            }
            if (BasicJideTabbedPaneUI.this._runCount > 1) {
                this.normalizeTabRuns(tabPlacement, tabCount, verticalTabRuns ? y : x, returnAt);
                BasicJideTabbedPaneUI.this._selectedRun = BasicJideTabbedPaneUI.this.getRunForTab(tabCount, selectedIndex);
                if (BasicJideTabbedPaneUI.this.shouldRotateTabRuns(tabPlacement)) {
                    this.rotateTabRuns(tabPlacement, BasicJideTabbedPaneUI.this._selectedRun);
                }
            }
            for (i = BasicJideTabbedPaneUI.this._runCount - 1; i >= 0; --i) {
                int j;
                int end;
                int start = BasicJideTabbedPaneUI.this._tabRuns[i];
                int next = BasicJideTabbedPaneUI.this._tabRuns[i == BasicJideTabbedPaneUI.this._runCount - 1 ? 0 : i + 1];
                int n = end = next != 0 ? next - 1 : tabCount - 1;
                if (!verticalTabRuns) {
                    for (j = start; j <= end; ++j) {
                        rect = BasicJideTabbedPaneUI.this._rects[j];
                        rect.y = y;
                        rect.x += BasicJideTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                    }
                    if (BasicJideTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                        this.padTabRun(tabPlacement, start, end, returnAt);
                    }
                    if (tabPlacement == 3) {
                        y -= BasicJideTabbedPaneUI.this._maxTabHeight - tabRunOverlay;
                        continue;
                    }
                    y += BasicJideTabbedPaneUI.this._maxTabHeight - tabRunOverlay;
                    continue;
                }
                for (j = start; j <= end; ++j) {
                    rect = BasicJideTabbedPaneUI.this._rects[j];
                    rect.x = x;
                    rect.y += BasicJideTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                }
                if (BasicJideTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                    this.padTabRun(tabPlacement, start, end, returnAt);
                }
                if (tabPlacement == 4) {
                    x -= BasicJideTabbedPaneUI.this._maxTabWidth - tabRunOverlay;
                    continue;
                }
                x += BasicJideTabbedPaneUI.this._maxTabWidth - tabRunOverlay;
            }
            this.padSelectedTab(tabPlacement, selectedIndex);
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (i = 0; i < tabCount; ++i) {
                    BasicJideTabbedPaneUI.this._rects[i].x = rightMargin - BasicJideTabbedPaneUI.this._rects[i].x - BasicJideTabbedPaneUI.this._rects[i].width;
                }
            }
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            for (int i = 0; i < selectedRun; ++i) {
                int save = BasicJideTabbedPaneUI.this._tabRuns[0];
                for (int j = 1; j < BasicJideTabbedPaneUI.this._runCount; ++j) {
                    BasicJideTabbedPaneUI.this._tabRuns[j - 1] = BasicJideTabbedPaneUI.this._tabRuns[j];
                }
                BasicJideTabbedPaneUI.this._tabRuns[BasicJideTabbedPaneUI.this._runCount - 1] = save;
            }
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            int run = BasicJideTabbedPaneUI.this._runCount - 1;
            boolean keepAdjusting = true;
            double weight = 1.25;
            while (keepAdjusting) {
                int prevLastLen;
                int end;
                int last = BasicJideTabbedPaneUI.this.lastTabInRun(tabCount, run);
                int prevLast = BasicJideTabbedPaneUI.this.lastTabInRun(tabCount, run - 1);
                if (!verticalTabRuns) {
                    end = BasicJideTabbedPaneUI.this._rects[last].x + BasicJideTabbedPaneUI.this._rects[last].width;
                    prevLastLen = (int)((double)BasicJideTabbedPaneUI.this._maxTabWidth * weight);
                } else {
                    end = BasicJideTabbedPaneUI.this._rects[last].y + BasicJideTabbedPaneUI.this._rects[last].height;
                    prevLastLen = (int)((double)BasicJideTabbedPaneUI.this._maxTabHeight * weight * 2.0);
                }
                if (max - end > prevLastLen) {
                    BasicJideTabbedPaneUI.this._tabRuns[run] = prevLast;
                    if (!verticalTabRuns) {
                        BasicJideTabbedPaneUI.this._rects[prevLast].x = start;
                    } else {
                        BasicJideTabbedPaneUI.this._rects[prevLast].y = start;
                    }
                    for (int i = prevLast + 1; i <= last; ++i) {
                        if (!verticalTabRuns) {
                            BasicJideTabbedPaneUI.this._rects[i].x = BasicJideTabbedPaneUI.this._rects[i - 1].x + BasicJideTabbedPaneUI.this._rects[i - 1].width;
                            continue;
                        }
                        BasicJideTabbedPaneUI.this._rects[i].y = BasicJideTabbedPaneUI.this._rects[i - 1].y + BasicJideTabbedPaneUI.this._rects[i - 1].height;
                    }
                } else if (run == BasicJideTabbedPaneUI.this._runCount - 1) {
                    keepAdjusting = false;
                }
                if (run - 1 > 0) {
                    --run;
                    continue;
                }
                run = BasicJideTabbedPaneUI.this._runCount - 1;
                weight += 0.25;
            }
        }

        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            Rectangle lastRect = BasicJideTabbedPaneUI.this._rects[end];
            if (tabPlacement == 1 || tabPlacement == 3) {
                int runWidth = lastRect.x + lastRect.width - BasicJideTabbedPaneUI.this._rects[start].x;
                int deltaWidth = max - (lastRect.x + lastRect.width);
                float factor = (float)deltaWidth / (float)runWidth;
                for (int j = start; j <= end; ++j) {
                    Rectangle pastRect = BasicJideTabbedPaneUI.this._rects[j];
                    if (j > start) {
                        pastRect.x = BasicJideTabbedPaneUI.this._rects[j - 1].x + BasicJideTabbedPaneUI.this._rects[j - 1].width;
                    }
                    pastRect.width += Math.round((float)pastRect.width * factor);
                }
                lastRect.width = max - lastRect.x;
            } else {
                int runHeight = lastRect.y + lastRect.height - BasicJideTabbedPaneUI.this._rects[start].y;
                int deltaHeight = max - (lastRect.y + lastRect.height);
                float factor = (float)deltaHeight / (float)runHeight;
                for (int j = start; j <= end; ++j) {
                    Rectangle pastRect = BasicJideTabbedPaneUI.this._rects[j];
                    if (j > start) {
                        pastRect.y = BasicJideTabbedPaneUI.this._rects[j - 1].y + BasicJideTabbedPaneUI.this._rects[j - 1].height;
                    }
                    pastRect.height += Math.round((float)pastRect.height * factor);
                }
                lastRect.height = max - lastRect.y;
            }
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
            if (selectedIndex >= 0) {
                Rectangle selRect = BasicJideTabbedPaneUI.this._rects[selectedIndex];
                Insets padInsets = BasicJideTabbedPaneUI.this.getSelectedTabPadInsets(tabPlacement);
                selRect.x -= padInsets.left;
                selRect.width += padInsets.left + padInsets.right;
                selRect.y -= padInsets.top;
                selRect.height += padInsets.top + padInsets.bottom;
            }
        }
    }

    private class TabContainer
    extends JPanel
    implements UIResource {
        private boolean notifyTabbedPane;

        public TabContainer() {
            super(null);
            this.notifyTabbedPane = true;
            this.setOpaque(false);
        }

        @Override
        public void remove(Component comp) {
            int index = BasicJideTabbedPaneUI.this._tabPane.indexOfTabComponent(comp);
            super.remove(comp);
            if (this.notifyTabbedPane && index != -1) {
                BasicJideTabbedPaneUI.this._tabPane.setTabComponentAt(index, null);
            }
        }

        private void removeUnusedTabComponents() {
            for (Component c : this.getComponents()) {
                int index;
                if (c instanceof UIResource || (index = BasicJideTabbedPaneUI.this._tabPane.indexOfTabComponent(c)) != -1) continue;
                super.remove(c);
            }
        }

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return BasicJideTabbedPaneUI.this._tabScroller != null;
        }

        @Override
        public void doLayout() {
            if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                BasicJideTabbedPaneUI.this._tabScroller.tabPanel.repaint();
            } else {
                BasicJideTabbedPaneUI.this._tabPane.repaint(this.getBounds());
            }
        }
    }

    private static class CloseTabAction
    extends AbstractAction {
        private static final long serialVersionUID = 7779678389793199733L;

        public CloseTabAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_CLOSE));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            Component compSrc;
            int index;
            JideTabbedPane pane;
            Object src = e.getSource();
            boolean closeSelected = false;
            if (src instanceof JideTabbedPane) {
                pane = (JideTabbedPane)src;
            } else if (src instanceof JideTabbedPane.NoFocusButton && ((JideTabbedPane.NoFocusButton)src).getParent() instanceof JideTabbedPane) {
                pane = (JideTabbedPane)((JideTabbedPane.NoFocusButton)src).getParent();
                closeSelected = true;
            } else if (src instanceof JideTabbedPane.NoFocusButton && ((JideTabbedPane.NoFocusButton)src).getParent() instanceof ScrollableTabPanel) {
                pane = (JideTabbedPane)SwingUtilities.getAncestorOfClass(JideTabbedPane.class, (JideTabbedPane.NoFocusButton)src);
                closeSelected = false;
            } else {
                return;
            }
            if (pane.isTabEditing()) {
                ((BasicJideTabbedPaneUI)pane.getUI()).stopOrCancelEditing();
            }
            ActionEvent e2 = e;
            if (src instanceof JideTabbedPane.NoFocusButton) {
                index = ((JideTabbedPane.NoFocusButton)src).getIndex();
                Component component = compSrc = index != -1 ? pane.getComponentAt(index) : pane.getSelectedComponent();
                if (compSrc != null) {
                    e2 = new ActionEvent(compSrc, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
                }
            } else if ("middleMouseButtonClicked".equals(e.getActionCommand())) {
                index = e.getID();
                Component component = compSrc = index != -1 ? pane.getComponentAt(index) : pane.getSelectedComponent();
                if (compSrc != null) {
                    e2 = new ActionEvent(compSrc, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
                }
            }
            if (pane.getCloseAction() != null) {
                e2 = new ActionEvent(e2.getSource(), e2.getID(), (String)pane.getCloseAction().getValue("ActionCommandKey"), e2.getWhen(), e2.getModifiers());
                pane.getCloseAction().actionPerformed(e2);
            } else if ("middleMouseButtonClicked".equals(e.getActionCommand())) {
                index = e.getID();
                if (index >= 0) {
                    pane.removeTabAt(index);
                }
                if (pane.getTabCount() == 0) {
                    pane.updateUI();
                }
                pane.doLayout();
                if (pane.getSelectedIndex() >= 0) {
                    ((BasicJideTabbedPaneUI)pane.getUI())._tabScroller.tabPanel.scrollIndexToVisible(pane.getSelectedIndex());
                }
            } else if (closeSelected) {
                if (pane.getSelectedIndex() >= 0) {
                    pane.removeTabAt(pane.getSelectedIndex());
                }
                if (pane.getTabCount() == 0) {
                    pane.updateUI();
                }
                pane.doLayout();
                if (pane.getSelectedIndex() >= 0) {
                    ((BasicJideTabbedPaneUI)pane.getUI())._tabScroller.tabPanel.scrollIndexToVisible(pane.getSelectedIndex());
                }
            } else if (src instanceof JideTabbedPane.NoFocusButton && (i = ((JideTabbedPane.NoFocusButton)src).getIndex()) != -1) {
                int tabIndex = pane.getSelectedIndex();
                pane.removeTabAt(i);
                if (i < tabIndex) {
                    pane.setSelectedIndex(tabIndex - 1);
                }
                if (pane.getTabCount() == 0) {
                    pane.updateUI();
                }
                pane.doLayout();
                if (pane.getSelectedIndex() >= 0) {
                    ((BasicJideTabbedPaneUI)pane.getUI())._tabScroller.tabPanel.scrollIndexToVisible(pane.getSelectedIndex());
                }
            }
        }
    }

    private static class ScrollTabsListAction
    extends AbstractAction {
        private static final long serialVersionUID = 246103712600916771L;

        public ScrollTabsListAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_TAB_LIST));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicJideTabbedPaneUI ui;
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof JideTabbedPane.NoFocusButton) {
                pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, (JideTabbedPane.NoFocusButton)src);
            }
            if (pane instanceof JideTabbedPane && (ui = (BasicJideTabbedPaneUI)pane.getUI()).scrollableTabLayoutEnabled()) {
                if (((JideTabbedPane)pane).isTabListPopupVisible()) {
                    ((JideTabbedPane)pane).hideTabListPopup();
                } else {
                    ui._tabScroller.createPopup(pane.getTabPlacement());
                }
            }
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private static final long serialVersionUID = -426408621939940046L;

        public ScrollTabsBackwardAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_SCROLL_BACKWARD));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicJideTabbedPaneUI ui;
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof JideTabbedPane.NoFocusButton) {
                pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, (JideTabbedPane.NoFocusButton)src);
            }
            if (pane != null && (ui = (BasicJideTabbedPaneUI)pane.getUI()).scrollableTabLayoutEnabled()) {
                ui._tabScroller.scrollBackward(pane.getTabPlacement());
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private static final long serialVersionUID = 8772616556895545931L;

        public ScrollTabsForwardAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_SCROLL_FORWARD));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicJideTabbedPaneUI ui;
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof JideTabbedPane.NoFocusButton) {
                pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, (JideTabbedPane.NoFocusButton)src);
            }
            if (pane != null && (ui = (BasicJideTabbedPaneUI)pane.getUI()).scrollableTabLayoutEnabled()) {
                ui._tabScroller.scrollForward(pane.getTabPlacement());
            }
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private static final long serialVersionUID = 6216635910156115469L;

        private SetSelectedIndexAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            if (pane != null && pane.getUI() instanceof BasicJideTabbedPaneUI) {
                BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
                String command = e.getActionCommand();
                if (command != null && command.length() > 0) {
                    Integer index;
                    int mnemonic = e.getActionCommand().charAt(0);
                    if (mnemonic >= 97 && mnemonic <= 122) {
                        mnemonic -= 32;
                    }
                    if ((index = (Integer)ui._mnemonicToIndexMap.get(new Integer(mnemonic))) != null && pane.isEnabledAt(index)) {
                        pane.setSelectedIndex(index);
                    }
                }
            }
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private static final long serialVersionUID = 6677797853998039155L;

        private RequestFocusForVisibleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.requestFocusForVisibleComponent();
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private static final long serialVersionUID = 3791111435639724577L;

        private RequestFocusAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            if (!pane.requestFocusInWindow()) {
                pane.requestFocus();
            }
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private static final long serialVersionUID = 4895454480954468453L;

        private PageDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(3);
            } else {
                ui.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1154273528778779166L;

        private PageUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(7);
            } else {
                ui.navigateSelectedTab(1);
            }
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private static final long serialVersionUID = 2095403667386334865L;

        private PreviousAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(13);
        }
    }

    private static class NextAction
    extends AbstractAction {
        private static final long serialVersionUID = -154035573464933924L;

        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(12);
        }
    }

    private static class DownAction
    extends AbstractAction {
        private static final long serialVersionUID = -453174268282628886L;

        private DownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(5);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6961702501242792445L;

        private UpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(1);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private static final long serialVersionUID = 8670680299012169408L;

        private LeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(7);
        }
    }

    private static class RightAction
    extends AbstractAction {
        private static final long serialVersionUID = -1759791760116532857L;

        private RightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            BasicJideTabbedPaneUI ui = (BasicJideTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(3);
        }
    }
}

