/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.spinner;

import java.awt.Point;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;

public class PointFormatter
extends DefaultFormatter {
    private static JFormattedTextField.AbstractFormatter formatter;

    public static synchronized JFormattedTextField.AbstractFormatter getInstance() {
        if (formatter == null) {
            formatter = new PointFormatter();
        }
        return formatter;
    }

    private PointFormatter() {
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        if ((text = text.trim()).startsWith("(") && text.endsWith(")")) {
            text = text.substring(1, text.length() - 1);
        }
        try {
            String[] splition = text.split(",");
            return new Point(Integer.parseInt(splition[0].trim()), Integer.parseInt(splition[1].trim()));
        }
        catch (Exception e) {
            throw new ParseException(text, 0);
        }
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value instanceof Point) {
            Point point = (Point)value;
            return "(" + point.x + ", " + point.y + ")";
        }
        return super.valueToString(value);
    }

    public static void main(String[] args2) {
        String value;
        Point point = new Point(5, -5);
        JFormattedTextField.AbstractFormatter formatter = PointFormatter.getInstance();
        try {
            value = formatter.valueToString(point);
        }
        catch (ParseException e) {
            value = null;
        }
        System.out.println(value);
        value = "(3, -3)";
        try {
            point = (Point)formatter.stringToValue(value);
        }
        catch (ParseException e) {
            point = null;
        }
        System.out.println(point);
    }
}

