/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions.export;

import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import mediathek.config.Daten;
import mediathek.filmlisten.writer.FilmListWriter;
import mediathek.mainwindow.MediathekGui;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nJ\r\u0010\u000b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lmediathek/gui/actions/export/FilmlistExportWorker;", "Ljavax/swing/SwingWorker;", "", "", "exportAction", "Ljavax/swing/AbstractAction;", "selectedFile", "Ljava/io/File;", "compressSender", "compressThema", "(Ljavax/swing/AbstractAction;Ljava/io/File;ZZ)V", "doInBackground", "()Ljava/lang/Boolean;", "done", "", "showError", "showSuccess", "MediathekView"})
public final class FilmlistExportWorker
extends SwingWorker<Boolean, Double> {
    @NotNull
    private final AbstractAction exportAction;
    @Nullable
    private final File selectedFile;
    private final boolean compressSender;
    private final boolean compressThema;

    public FilmlistExportWorker(@NotNull AbstractAction exportAction, @NotNull File selectedFile, boolean compressSender, boolean compressThema) {
        Intrinsics.checkNotNullParameter(exportAction, "exportAction");
        Intrinsics.checkNotNullParameter(selectedFile, "selectedFile");
        this.exportAction = exportAction;
        this.selectedFile = selectedFile;
        this.compressSender = compressSender;
        this.compressThema = compressThema;
    }

    private final void showError() {
        JOptionPane.showMessageDialog(MediathekGui.ui(), "Es gab einen Fehler beim Export der Filmliste.", "MediathekView", 0);
    }

    private final void showSuccess() {
        JOptionPane.showMessageDialog(MediathekGui.ui(), "Der Export wurde erfolgreich abgeschlossen.", "MediathekView", 1);
    }

    @Override
    protected void done() {
        try {
            Boolean result;
            Boolean bl = result = (Boolean)this.get();
            Intrinsics.checkNotNull(bl);
            if (bl.booleanValue()) {
                this.showSuccess();
            } else {
                this.showError();
            }
        }
        catch (Exception e) {
            this.showError();
        }
        this.exportAction.setEnabled(true);
    }

    @Override
    @NotNull
    protected Boolean doInBackground() throws Exception {
        if (this.selectedFile != null) {
            FilmListWriter writer = new FilmListWriter(true);
            writer.setCompressSenderTag(this.compressSender);
            writer.setCompressThemaTag(this.compressThema);
            writer.setDecompressUrls(true);
            writer.writeFilmList(this.selectedFile.getAbsolutePath(), Daten.getInstance().getListeFilme(), arg_0 -> FilmlistExportWorker.doInBackground$lambda$0(this, arg_0));
        }
        return true;
    }

    private static final void doInBackground$lambda$0(FilmlistExportWorker this$0, double prog) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.setProgress(MathKt.roundToInt(100.0 * prog));
    }
}

