/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film.helpers;

import java.util.concurrent.TimeUnit;
import javax.swing.table.TableModel;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.gui.tabs.tab_film.SearchFieldData;
import mediathek.gui.tabs.tab_film.helpers.SliderRange;
import mediathek.javafx.filterpanel.FilmActionPanel;

public abstract class GuiModelHelper {
    protected SliderRange sliderRange;
    protected long maxLength;
    protected FilmActionPanel filmActionPanel;
    protected SeenHistoryController historyController;
    protected SearchFieldData searchFieldData;

    public abstract TableModel getFilteredTableModel();

    protected boolean maxLengthCheck(DatenFilm film) {
        return (long)film.getFilmLength() < this.sliderRange.maxLengthInSeconds();
    }

    protected boolean minLengthCheck(DatenFilm film) {
        int filmLength = film.getFilmLength();
        if (filmLength == 0) {
            return true;
        }
        return (long)filmLength >= this.sliderRange.minLengthInSeconds();
    }

    protected abstract boolean noFiltersAreSet();

    protected boolean seenCheck(DatenFilm film) {
        return !this.historyController.hasBeenSeenFromCache(film);
    }

    protected void calculateFilmLengthSliderValues() {
        long minLength = (long)this.filmActionPanel.getFilmLengthSlider().getLowValue();
        this.maxLength = (long)this.filmActionPanel.getFilmLengthSlider().getHighValue();
        long minLengthInSeconds = TimeUnit.SECONDS.convert(minLength, TimeUnit.MINUTES);
        long maxLengthInSeconds = TimeUnit.SECONDS.convert(this.maxLength, TimeUnit.MINUTES);
        this.sliderRange = new SliderRange(minLengthInSeconds, maxLengthInSeconds);
    }
}

