/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filterpanel;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransactionList;
import ca.odell.glazedlists.javafx.EventObservableList;
import impl.org.controlsfx.autocompletion.SuggestionProvider;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.daten.ListeFilme;
import mediathek.javafx.filterpanel.CommonViewSettingsPane;
import mediathek.javafx.filterpanel.OldSwingJavaFxFilterDialog;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.FilterConfiguration;
import mediathek.tool.FilterDTO;
import mediathek.tool.GermanStringSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.RangeSlider;
import org.controlsfx.control.textfield.TextFields;
import org.jetbrains.annotations.NotNull;

public class FilmActionPanel {
    private static final Logger logger = LogManager.getLogger();
    private final FilterConfiguration filterConfig;
    private final ObservableList<FilterDTO> availableFilters;
    private final EventList<String> sourceThemaList = new BasicEventList<String>();
    private final EventObservableList<String> themaListItems = new EventObservableList<String>(this.sourceThemaList);
    private OldSwingJavaFxFilterDialog filterDialog;
    private RangeSlider filmLengthSlider;
    private ReadOnlyObjectProperty<String> zeitraumProperty;
    private BooleanProperty dontShowAudioVersions;
    private BooleanProperty dontShowSignLanguage;
    private BooleanProperty dontShowTrailers;
    private BooleanProperty dontShowAbos;
    private BooleanProperty showLivestreamsOnly;
    private BooleanProperty showUnseenOnly;
    private BooleanProperty showBookMarkedOnly;
    private BooleanProperty showSubtitlesOnly;
    private BooleanProperty showOnlyHighQuality;
    private BooleanProperty showNewOnly;
    private SuggestionProvider<String> themaSuggestionProvider;
    private CommonViewSettingsPane viewSettingsPane;

    public FilmActionPanel(@NotNull JToggleButton filterToggleBtn) {
        this.filterConfig = new FilterConfiguration();
        this.setupViewSettingsPane();
        this.setupDeleteFilterButton();
        SwingUtilities.invokeLater(() -> {
            this.filterDialog = new OldSwingJavaFxFilterDialog((Frame)MediathekGui.ui(), this.viewSettingsPane, filterToggleBtn);
        });
        this.restoreConfigSettings();
        this.setupConfigListeners();
        this.availableFilters = FXCollections.observableArrayList(this.filterConfig.getAvailableFilters());
        this.setupFilterSelection();
        this.setupDeleteCurrentFilterButton();
        this.setupAddNewFilterButton();
    }

    public OldSwingJavaFxFilterDialog getFilterDialog() {
        return this.filterDialog;
    }

    public RangeSlider getFilmLengthSlider() {
        return this.filmLengthSlider;
    }

    public ReadOnlyObjectProperty<String> zeitraumProperty() {
        return this.zeitraumProperty;
    }

    public boolean isDontShowAudioVersions() {
        return this.dontShowAudioVersions.get();
    }

    public BooleanProperty dontShowAudioVersionsProperty() {
        return this.dontShowAudioVersions;
    }

    public boolean isDontShowSignLanguage() {
        return this.dontShowSignLanguage.get();
    }

    public BooleanProperty dontShowSignLanguageProperty() {
        return this.dontShowSignLanguage;
    }

    public boolean isDontShowTrailers() {
        return this.dontShowTrailers.get();
    }

    public BooleanProperty dontShowTrailersProperty() {
        return this.dontShowTrailers;
    }

    public boolean isDontShowAbos() {
        return this.dontShowAbos.get();
    }

    public BooleanProperty dontShowAbosProperty() {
        return this.dontShowAbos;
    }

    public boolean isShowLivestreamsOnly() {
        return this.showLivestreamsOnly.get();
    }

    public BooleanProperty showLivestreamsOnlyProperty() {
        return this.showLivestreamsOnly;
    }

    public boolean isShowUnseenOnly() {
        return this.showUnseenOnly.get();
    }

    public BooleanProperty showUnseenOnlyProperty() {
        return this.showUnseenOnly;
    }

    public boolean isShowBookMarkedOnly() {
        return this.showBookMarkedOnly.get();
    }

    public BooleanProperty showBookMarkedOnlyProperty() {
        return this.showBookMarkedOnly;
    }

    public boolean isShowSubtitlesOnly() {
        return this.showSubtitlesOnly.get();
    }

    public BooleanProperty showSubtitlesOnlyProperty() {
        return this.showSubtitlesOnly;
    }

    public boolean isShowOnlyHighQuality() {
        return this.showOnlyHighQuality.get();
    }

    public BooleanProperty showOnlyHighQualityProperty() {
        return this.showOnlyHighQuality;
    }

    public boolean isShowNewOnly() {
        return this.showNewOnly.get();
    }

    public BooleanProperty showNewOnlyProperty() {
        return this.showNewOnly;
    }

    private void setupAddNewFilterButton() {
        this.viewSettingsPane.setAddNewFilterButtonEventHandler(event -> {
            FilterDTO newFilter = new FilterDTO(UUID.randomUUID(), String.format("Filter %d", this.availableFilters.size() + 1));
            this.filterConfig.addNewFilter(newFilter);
            this.viewSettingsPane.disableDeleteCurrentFilterButton(false);
            this.viewSettingsPane.selectFilter(newFilter);
        });
    }

    private void setupDeleteCurrentFilterButton() {
        if (this.availableFilters.size() <= 1) {
            this.viewSettingsPane.disableDeleteCurrentFilterButton(true);
        }
        this.viewSettingsPane.btnDeleteCurrentFilter.setOnAction(event -> {
            FilterDTO filterToDelete = this.filterConfig.getCurrentFilter();
            this.filterConfig.deleteFilter(filterToDelete);
            if (this.availableFilters.size() <= 1) {
                this.viewSettingsPane.disableDeleteCurrentFilterButton(true);
            }
        });
    }

    private void setupFilterSelection() {
        this.viewSettingsPane.setAvailableFilters(this.availableFilters);
        FilterConfiguration.addAvailableFiltersObserver(() -> {
            this.availableFilters.clear();
            this.availableFilters.addAll((Collection<FilterDTO>)this.filterConfig.getAvailableFilters());
        });
        FilterConfiguration.addCurrentFiltersObserver(filter -> {
            this.viewSettingsPane.selectFilter((FilterDTO)filter);
            this.restoreConfigSettings();
        });
        this.viewSettingsPane.setFilterSelectionChangeListener((observableValue, oldValue, newValue) -> {
            if (newValue != null && !newValue.equals(oldValue)) {
                this.filterConfig.setCurrentFilter((FilterDTO)newValue);
            }
        });
        this.viewSettingsPane.setFilterSelectionStringConverter(new StringConverter<FilterDTO>(){

            @Override
            public String toString(FilterDTO filter) {
                if (filter == null) {
                    return null;
                }
                return filter.name();
            }

            @Override
            public FilterDTO fromString(String name) {
                return FilmActionPanel.this.filterConfig.findFilterForName(name).orElseGet(() -> FilmActionPanel.this.renameCurrentFilter(name));
            }
        });
    }

    private FilterDTO renameCurrentFilter(String newValue) {
        FilterDTO currentFilter = this.filterConfig.getCurrentFilter();
        logger.debug("Can't find a filter with name \"{}\". Renaming the current filter \"{}\" to it.", (Object)newValue, (Object)currentFilter.name());
        this.filterConfig.renameCurrentFilter(newValue);
        return this.filterConfig.getCurrentFilter();
    }

    private void setupDeleteFilterButton() {
        this.viewSettingsPane.btnDeleteFilterSettings.setOnAction(e -> {
            this.filterConfig.clearCurrentFilter();
            this.restoreConfigSettings();
        });
    }

    private void setupViewSettingsPane() {
        this.viewSettingsPane = new CommonViewSettingsPane();
        this.showOnlyHighQuality = this.viewSettingsPane.cbShowOnlyHd.selectedProperty();
        this.showSubtitlesOnly = this.viewSettingsPane.cbShowSubtitlesOnly.selectedProperty();
        this.showNewOnly = this.viewSettingsPane.cbShowNewOnly.selectedProperty();
        this.showBookMarkedOnly = this.viewSettingsPane.cbShowBookMarkedOnly.selectedProperty();
        this.showLivestreamsOnly = this.viewSettingsPane.cbShowOnlyLivestreams.selectedProperty();
        this.showUnseenOnly = this.viewSettingsPane.cbShowUnseenOnly.selectedProperty();
        this.dontShowAbos = this.viewSettingsPane.cbDontShowAbos.selectedProperty();
        this.dontShowSignLanguage = this.viewSettingsPane.cbDontShowGebaerdensprache.selectedProperty();
        this.dontShowTrailers = this.viewSettingsPane.cbDontShowTrailers.selectedProperty();
        this.dontShowAudioVersions = this.viewSettingsPane.cbDontShowAudioVersions.selectedProperty();
        this.setupThemaComboBox();
        this.viewSettingsPane.senderCheckList.getCheckModel().getCheckedItems().addListener(c -> this.updateThemaComboBox());
        this.filmLengthSlider = this.viewSettingsPane.filmLengthSliderNode._filmLengthSlider;
        this.zeitraumProperty = this.viewSettingsPane.zeitraumSpinner.valueProperty();
    }

    private void setupThemaComboBox() {
        this.viewSettingsPane.themaComboBox.setItems(this.themaListItems);
        this.themaSuggestionProvider = SuggestionProvider.create(this.themaListItems);
        TextFields.bindAutoCompletion(this.viewSettingsPane.themaComboBox.getEditor(), this.themaSuggestionProvider);
    }

    public CommonViewSettingsPane getViewSettingsPane() {
        return this.viewSettingsPane;
    }

    private void restoreConfigSettings() {
        this.viewSettingsPane.selectFilter(this.filterConfig.getCurrentFilter());
        this.showOnlyHighQuality.set(this.filterConfig.isShowHdOnly());
        this.showSubtitlesOnly.set(this.filterConfig.isShowSubtitlesOnly());
        this.showNewOnly.set(this.filterConfig.isShowNewOnly());
        this.showBookMarkedOnly.set(this.filterConfig.isShowBookMarkedOnly());
        this.showUnseenOnly.set(this.filterConfig.isShowUnseenOnly());
        this.showLivestreamsOnly.set(this.filterConfig.isShowLivestreamsOnly());
        this.dontShowAbos.set(this.filterConfig.isDontShowAbos());
        this.dontShowTrailers.set(this.filterConfig.isDontShowTrailers());
        this.dontShowSignLanguage.set(this.filterConfig.isDontShowSignLanguage());
        this.dontShowAudioVersions.set(this.filterConfig.isDontShowAudioVersions());
        try {
            double loadedMin = this.filterConfig.getFilmLengthMin();
            if (loadedMin > this.filmLengthSlider.getHighValue()) {
                this.filmLengthSlider.setHighValueChanging(true);
                this.filmLengthSlider.setHighValue(this.filterConfig.getFilmLengthMax());
                this.filmLengthSlider.setHighValueChanging(false);
                this.filmLengthSlider.setLowValueChanging(true);
                this.filmLengthSlider.setLowValue(loadedMin);
                this.filmLengthSlider.setLowValueChanging(false);
            } else {
                this.filmLengthSlider.setLowValueChanging(true);
                this.filmLengthSlider.setLowValue(loadedMin);
                this.filmLengthSlider.setLowValueChanging(false);
                this.filmLengthSlider.setHighValueChanging(true);
                this.filmLengthSlider.setHighValue(this.filterConfig.getFilmLengthMax());
                this.filmLengthSlider.setHighValueChanging(false);
            }
        }
        catch (Exception exception) {
            logger.debug("Beim wiederherstellen der Filter Einstellungen f\u00fcr die Filml\u00e4nge ist ein Fehler aufgetreten!", (Throwable)exception);
        }
        try {
            this.viewSettingsPane.zeitraumSpinner.getValueFactory().setValue(this.filterConfig.getZeitraum());
        }
        catch (Exception exception) {
            logger.debug("Beim wiederherstellen der Filter Einstellungen f\u00fcr den Zeitraum ist ein Fehler aufgetreten!", (Throwable)exception);
        }
    }

    private void setupConfigListeners() {
        this.showOnlyHighQuality.addListener((observable2, oldValue, newValue) -> this.filterConfig.setShowHdOnly((boolean)newValue));
        this.showSubtitlesOnly.addListener((observable2, oldValue, newValue) -> this.filterConfig.setShowSubtitlesOnly((boolean)newValue));
        this.showBookMarkedOnly.addListener((observable2, oldValue, newValue) -> this.filterConfig.setShowBookMarkedOnly((boolean)newValue));
        this.showNewOnly.addListener((observable2, oldValue, newValue) -> this.filterConfig.setShowNewOnly((boolean)newValue));
        this.showUnseenOnly.addListener((observable2, oldValue, newValue) -> this.filterConfig.setShowUnseenOnly((boolean)newValue));
        this.showLivestreamsOnly.addListener((observable2, oldValue, newValue) -> this.filterConfig.setShowLivestreamsOnly((boolean)newValue));
        this.dontShowAbos.addListener((observable2, oldValue, newValue) -> this.filterConfig.setDontShowAbos((boolean)newValue));
        this.dontShowTrailers.addListener((observable2, oldValue, newValue) -> this.filterConfig.setDontShowTrailers((boolean)newValue));
        this.dontShowSignLanguage.addListener((observable2, oldValue, newValue) -> this.filterConfig.setDontShowSignLanguage((boolean)newValue));
        this.dontShowAudioVersions.addListener((observable2, oldValue, newValue) -> this.filterConfig.setDontShowAudioVersions((boolean)newValue));
        this.filmLengthSlider.lowValueProperty().addListener((observable2, oldValue, newValue) -> this.filterConfig.setFilmLengthMin(newValue.doubleValue()));
        this.filmLengthSlider.highValueProperty().addListener((observable2, oldValue, newValue) -> this.filterConfig.setFilmLengthMax(newValue.doubleValue()));
        this.zeitraumProperty.addListener((os, oV, newValue) -> this.filterConfig.setZeitraum((String)newValue));
    }

    private List<String> getThemaList(@NotNull List<String> selectedSenders) {
        ArrayList<String> finalList = new ArrayList<String>();
        ListeFilme blackList = Daten.getInstance().getListeFilmeNachBlackList();
        if (selectedSenders.isEmpty()) {
            finalList.addAll(blackList.getThemen(""));
        } else {
            for (String sender : selectedSenders) {
                finalList.addAll(blackList.getThemen(sender));
            }
        }
        return finalList;
    }

    public void updateThemaComboBox() {
        TransactionList<String> transactionThemaList = new TransactionList<String>(this.sourceThemaList);
        transactionThemaList.beginEvent(true);
        transactionThemaList.clear();
        transactionThemaList.add("");
        ObservableList<String> selectedSenders = this.viewSettingsPane.senderCheckList.getCheckModel().getCheckedItems();
        List<String> tempThemaList = this.getThemaList(selectedSenders).stream().sorted(GermanStringSorter.getInstance()).toList();
        transactionThemaList.addAll(tempThemaList);
        transactionThemaList.commitEvent();
        this.themaSuggestionProvider.clearSuggestions();
        this.themaSuggestionProvider.addPossibleSuggestions((Collection<String>)this.themaListItems);
        this.viewSettingsPane.themaComboBox.getSelectionModel().select(0);
    }
}

