/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RoutePlanner;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lokhttp3/internal/connection/SequentialExchangeFinder;", "Lokhttp3/internal/connection/ExchangeFinder;", "routePlanner", "Lokhttp3/internal/connection/RoutePlanner;", "(Lokhttp3/internal/connection/RoutePlanner;)V", "getRoutePlanner", "()Lokhttp3/internal/connection/RoutePlanner;", "find", "Lokhttp3/internal/connection/RealConnection;", "okhttp"})
public final class SequentialExchangeFinder
implements ExchangeFinder {
    @NotNull
    private final RoutePlanner routePlanner;

    public SequentialExchangeFinder(@NotNull RoutePlanner routePlanner) {
        Intrinsics.checkNotNullParameter(routePlanner, "routePlanner");
        this.routePlanner = routePlanner;
    }

    @Override
    @NotNull
    public RoutePlanner getRoutePlanner() {
        return this.routePlanner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public RealConnection find() {
        IOException firstException = null;
        while (true) {
            if (this.getRoutePlanner().isCanceled()) {
                throw new IOException("Canceled");
            }
            try {
                Throwable failure;
                RoutePlanner.Plan plan = this.getRoutePlanner().plan();
                if (plan.isReady()) return plan.handleSuccess();
                RoutePlanner.ConnectResult tcpConnectResult = plan.connectTcp();
                RoutePlanner.ConnectResult connectResult = tcpConnectResult.isSuccess() ? plan.connectTlsEtc() : tcpConnectResult;
                RoutePlanner.Plan nextPlan = connectResult.component2();
                Throwable throwable = failure = connectResult.component3();
                if (throwable != null) {
                    throw throwable;
                }
                if (nextPlan == null) return plan.handleSuccess();
                this.getRoutePlanner().getDeferredPlans().addFirst(nextPlan);
                continue;
            }
            catch (IOException e) {
                if (firstException == null) {
                    firstException = e;
                } else {
                    ExceptionsKt.addSuppressed(firstException, e);
                }
                if (!RoutePlanner.hasNext$default(this.getRoutePlanner(), null, 1, null)) throw firstException;
                continue;
            }
            break;
        }
    }
}

