# Unicode 字符支持

ZenUML 现在完全支持 Unicode 字符，包括中文、日文、韩文、阿拉伯文、俄文等多种语言的标识符。

## 功能特性

### 1. 直接使用 Unicode 字符作为标识符

您可以直接使用任何 Unicode 字母字符作为：
- 参与者名称
- 方法名称
- 变量名称
- 参数名称

**示例：**

```zenuml
// 中文标识符
用户 订单服务 数据库

用户.登录()
订单服务.创建订单()
数据库.保存数据()
return 成功
```

### 2. 包含空格的文本使用引号

如果标识符中需要包含空格或特殊字符，请使用双引号：

```zenuml
// 使用引号处理包含空格的名称
"用户 服务" "订单 管理系统"

"用户 服务"."获取 用户信息"()
"订单 管理系统"."创建 新订单"()
return "操作 成功"
```

### 3. 中英文混合支持

您可以自由混合使用中文和英文：

```zenuml
UserService 数据库 CacheManager

UserService.获取用户()
数据库.query("SELECT * FROM users")
CacheManager.缓存结果()
```

## 支持的 Unicode 范围

当前实现支持所有 Unicode 字母字符，包括但不限于：

- **中文**：汉字字符
- **日文**：平假名、片假名、汉字
- **韩文**：韩文字母
- **阿拉伯文**：阿拉伯字母
- **俄文**：西里尔字母
- **其他**：所有 Unicode 定义的字母字符

## 使用规则

1. **标识符规则**：
   - 必须以 Unicode 字母或下划线 `_` 开头
   - 可以包含 Unicode 字母、数字和下划线
   - 不能包含空格（需要空格请使用引号）

2. **引号字符串**：
   - 可以包含任何字符（除了换行符）
   - 适用于包含空格或特殊字符的文本

3. **保留关键字**：
   - 英文关键字（如 `if`, `while`, `return` 等）保持不变
   - 不能使用保留关键字作为标识符

## 实际应用示例

### 示例 1：订单处理流程

```zenuml
title "订单处理流程"

@Actor 用户
@Service 订单服务
@Database 数据库

用户->订单服务: 创建订单
订单服务.验证订单() {
    if (库存充足) {
        数据库.保存订单()
        return "订单创建成功"
    } else {
        return "库存不足"
    }
}
```

### 示例 2：用户认证流程

```zenuml
用户 认证服务 令牌管理器

用户.登录(用户名, 密码)
认证服务.验证凭据(用户名, 密码) {
    if (验证成功) {
        令牌 = 令牌管理器.生成令牌()
        return 令牌
    } else {
        return "认证失败"
    }
}
```

### 示例 3：多语言混合

```zenuml
// 混合多种语言的示例
ユーザー // 日文
사용자   // 韩文
用户     // 中文
User     // 英文

ユーザー.ログイン()
사용자.로그인()
用户.登录()
User.login()
```

## 技术实现

### 词法分析器更改

在 `SequenceLexer.g4` 中，ID token 定义已更新为：

```antlr
ID
 : [\p{L}_] [\p{L}\p{Nd}_]*
 ;
```

- `\p{L}` 匹配任何 Unicode 字母
- `\p{Nd}` 匹配任何 Unicode 十进制数字
- 保持了对下划线 `_` 的支持

### 向后兼容性

所有现有的 ASCII 标识符仍然完全支持：
- 英文字母 (a-z, A-Z)
- 数字 (0-9)
- 下划线 (_)

现有的 ZenUML 代码无需任何修改即可继续工作。

## 测试

您可以通过以下方式测试 Unicode 支持：

1. **开发服务器测试**：
   ```bash
   pnpm dev
   ```
   然后访问 http://localhost:8080/test-chinese.html

2. **单元测试**：
   ```bash
   pnpm test src/parser/ChineseSupport.spec.ts
   ```

## 注意事项

1. **编码**：确保您的文件使用 UTF-8 编码保存
2. **字体支持**：渲染时需要系统或浏览器支持相应的字体
3. **方向性**：某些语言（如阿拉伯文）是从右到左书写，但在 ZenUML 中仍按从左到右的顺序处理

## 贡献

如果您发现任何 Unicode 相关的问题或有改进建议，欢迎提交 issue 或 pull request。