```Msf::Exploit::FILEFORMAT``` is the mixin to use to create a file format exploit. There actually isn't much in the mixin, but the most important method is this: ```file_create```:

### Usage for file_create

As the name implies, the ```file_create``` method allows you to create a file. You should be using this method because it does more than just writing data to disk. One of the important things it does is it will report the file creation to the database in the format of ```#{ltype}.localpath```, and the file will always be written to Metasploit's local directory defined in ```Msf::Config.local_directory``` (by default this path is ```~/.msf4/local```), which keep files nice and organized.

To use the mixin, first include ```Msf::Exploit::FILEFORMAT``` under the scope of your ```Metasploit3``` class:

```ruby
include Msf::Exploit::FILEFORMAT
```

And here's an example of using ```file_create``` to build an imaginary exploit:

```ruby
# This is my imaginary exploit
buf = ""
buf << "A" * 1024
buf << [0x40201f01].pack("V")
buf << "\x90" * 10
buf << payload.encoded

file_create(buf)
```

### Custom filename

The ```Msf::Exploit::FILENAME``` mixin by default has a registered ```FILENAME``` datastore option, and it is actually optional. If there's no filename provided, the mixin will set the name in this format: ```"exploit.fileformat.#{self.shortname}"```, where ```self.shortname``` means the shorter version of the module name.

If you wish to set a default one (but still changeable by the user), then you simply register it again in the module, like this:

```ruby
register_options(
  [
    OptString.new('FILENAME', [true, 'The malicious file name',  'msf.jpg'])
  ], self.class)
```

### Fixed filename

Occasionally, you might not want your user to change the filename at all. A lazy trick to do that is by modifying the ```FILENAME``` datastore option at runtime, but this is very much not recommended. In fact, if you do this, you will not pass [[msftidy|./Guidelines-for-Accepting-Modules-and-Enhancements.md]]. Instead, here's how it's done properly:

1 - Deregister the ```FILENAME``` option

```ruby
deregister_options('FILENAME')
```

2 - Next, override the ```file_format_filename``` method, and make it return the filename you want:

```ruby
def file_format_filename
  'something.jpg'
end
```

3 - Finally, please leave a note about this in the module description.

### References

- <https://github.com/rapid7/metasploit-framework/blob/master/lib/msf/core/exploit/fileformat.rb>
- <https://github.com/rapid7/metasploit-framework/tree/master/modules/exploits/windows/local>
