# @deprecated use {Mdm::ExploitAttempt} instead.
#
# When a {#host} or {#service} on a {#host} is exploited.
class Mdm::ExploitedHost < ApplicationRecord
  #
  # Associations
  #

  # The host that was exploited.
  belongs_to :host,
             class_name: 'Mdm::Host',
             inverse_of: :exploited_hosts

  # The service on {#host} that was exploited.
  belongs_to :service,
             class_name: 'Mdm::Service',
             inverse_of: :exploited_hosts

  #
  # Attributes
  #

  # @!attribute name
  #   Name of exploit.
  #
  #   @return [String]

  # @!attribute payload
  #   {Mdm::Module::Class#full_name Full name of the payload module} used to exploit the {#host} or {#service} on
  #   {#host}.
  #
  #   @return [String]

  # @!attribute session_uuid
  #   UUID of local session.
  #
  #   @return [String]
  #   @deprecated Sessions no longer have UUIDs.  They have {Mdm::Session#local_id} that reflects the in-memory
  #     Msf::Session ID and an in-database {Mdm::Session#id}.

  Metasploit::Concern.run(self)
end
