/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2024-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: LicenseRef-NvidiaProprietary
 *
 * NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
 * property and proprietary rights in and to this material, related
 * documentation and any modifications thereto. Any use, reproduction,
 * disclosure or distribution of this material and related documentation
 * without an express license agreement from NVIDIA CORPORATION or
 * its affiliates is strictly prohibited.
 */

#pragma once

// std
#include <chrono>
#include <string>
// sharp_am
#include "metrics.h"

class Fabric;

class Telemetry
{
   public:
    Telemetry(std::string end_point, std::chrono::seconds publish_interval);

    //! publish telemetry values to clients (currently done by saving a JSON to a file)
    void Publish(const Metrics& metrics);

    //! return true if we need to publish telemetry data
    bool IsEnabled() const { return (not m_end_point.empty()) and (m_publish_interval > std::chrono::seconds(0)); }

    //! interval to publish telemetry data
    std::chrono::seconds GetPublishInterval() const { return m_publish_interval; }

    //! gather live metrics (current time, invalid agg nodes, etc.) + accumulated metrics and publish
    void GatherAndPublish(const Fabric& fabric);

   private:
    std::string m_end_point;
    std::chrono::seconds m_publish_interval{};
};
