/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNumEquivalence;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.base.Equivalence;

public final class EnumValidator
extends AbstractKeywordValidator {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquivalence.getInstance();
    private final JsonNode values;

    public EnumValidator(JsonNode digest) {
        super("enum");
        this.values = digest.get(this.keyword);
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        JsonNode node = data.getInstance().getNode();
        for (JsonNode enumValue : this.values) {
            if (!EQUIVALENCE.equivalent(enumValue, node)) continue;
            return;
        }
        report.error(this.newMsg(data, bundle, "err.common.enum.notInEnum").putArgument("value", node).putArgument(this.keyword, this.values));
    }

    @Override
    public String toString() {
        return this.keyword + '(' + this.values.size() + " possible values)";
    }
}

