/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedContent;
import org.openapitools.openapidiff.core.model.ChangedExtensions;
import org.openapitools.openapidiff.core.model.ChangedMetadata;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedRequestBody
implements ComposedChanged {
    private final RequestBody oldRequestBody;
    private final RequestBody newRequestBody;
    private final DiffContext context;
    private boolean changeRequired;
    private ChangedMetadata description;
    private ChangedContent content;
    private ChangedExtensions extensions;

    public ChangedRequestBody(RequestBody oldRequestBody, RequestBody newRequestBody, DiffContext context) {
        this.oldRequestBody = oldRequestBody;
        this.newRequestBody = newRequestBody;
        this.context = context;
    }

    @Override
    public List<Changed> getChangedElements() {
        return Arrays.asList(this.description, this.content, this.extensions);
    }

    @Override
    public DiffResult isCoreChanged() {
        if (!this.changeRequired) {
            return DiffResult.NO_CHANGES;
        }
        if (BackwardIncompatibleProp.OPENAPI_ENDPOINTS_DECREASED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        return DiffResult.COMPATIBLE;
    }

    public RequestBody getOldRequestBody() {
        return this.oldRequestBody;
    }

    public RequestBody getNewRequestBody() {
        return this.newRequestBody;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public boolean isChangeRequired() {
        return this.changeRequired;
    }

    public ChangedMetadata getDescription() {
        return this.description;
    }

    public ChangedContent getContent() {
        return this.content;
    }

    public ChangedExtensions getExtensions() {
        return this.extensions;
    }

    public ChangedRequestBody setChangeRequired(boolean changeRequired) {
        this.changeRequired = changeRequired;
        return this;
    }

    public ChangedRequestBody setDescription(ChangedMetadata description) {
        this.description = description;
        return this;
    }

    public ChangedRequestBody setContent(ChangedContent content) {
        this.content = content;
        return this;
    }

    public ChangedRequestBody setExtensions(ChangedExtensions extensions) {
        this.extensions = extensions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedRequestBody that = (ChangedRequestBody)o;
        return this.changeRequired == that.changeRequired && Objects.equals(this.oldRequestBody, that.oldRequestBody) && Objects.equals(this.newRequestBody, that.newRequestBody) && Objects.equals(this.context, that.context) && Objects.equals(this.description, that.description) && Objects.equals(this.content, that.content) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.oldRequestBody, this.newRequestBody, this.context, this.changeRequired, this.description, this.content, this.extensions);
    }

    public String toString() {
        return "ChangedRequestBody(oldRequestBody=" + this.getOldRequestBody() + ", newRequestBody=" + this.getNewRequestBody() + ", context=" + this.getContext() + ", changeRequired=" + this.isChangeRequired() + ", description=" + this.getDescription() + ", content=" + this.getContent() + ", extensions=" + this.getExtensions() + ")";
    }
}

