/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.schema;

import java.util.Objects;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedPattern
implements Changed {
    private final String oldPattern;
    private final String newPattern;
    private final DiffContext context;

    public ChangedPattern(String oldPattern, String newPattern, DiffContext context) {
        this.oldPattern = oldPattern;
        this.newPattern = newPattern;
        this.context = context;
    }

    @Override
    public DiffResult isChanged() {
        return Objects.equals(this.oldPattern, this.newPattern) ? DiffResult.NO_CHANGES : DiffResult.INCOMPATIBLE;
    }

    @Override
    public boolean isCompatible() {
        return Objects.equals(this.oldPattern, this.newPattern);
    }

    public DiffResult isDiffBackwardCompatible() {
        if (!Objects.equals(this.oldPattern, this.newPattern)) {
            return DiffResult.INCOMPATIBLE;
        }
        return DiffResult.COMPATIBLE;
    }

    public String getOldPattern() {
        return this.oldPattern;
    }

    public String getNewPattern() {
        return this.newPattern;
    }

    public DiffContext getContext() {
        return this.context;
    }
}

