/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.driver.BinaryDoubleCopyingBinder;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;

class BinaryDoubleBinder
extends Binder {
    double paramVal;
    Binder theBinaryDoubleCopyingBinder = null;

    static void init(Binder x) {
        x.type = (short)101;
        x.bytelen = 8;
    }

    BinaryDoubleBinder(double x) {
        BinaryDoubleBinder.init(this);
        this.paramVal = x;
    }

    @Override
    Binder copyingBinder() {
        if (this.theBinaryDoubleCopyingBinder == null) {
            this.theBinaryDoubleCopyingBinder = new BinaryDoubleCopyingBinder(this.paramVal);
        }
        return this.theBinaryDoubleCopyingBinder;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        int offset;
        byte[] b = null;
        int fixedLength = 8;
        long pos = 0L;
        if (bindUseDBA) {
            bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
            stmt.lastBoundDataOffsets[bindPosition] = pos;
            b = stmt.connection.methodTempLittleByteBuffer;
            offset = 0;
        } else {
            b = bindBytes;
            offset = byteoffset;
        }
        double val = this.paramVal;
        fixedLength = this.getDatumBytes(stmt, val, b, offset);
        if (bindUseDBA) {
            bindData.put(b, 0, fixedLength);
            bindDataLengths[bindDataIndex] = fixedLength;
            stmt.lastBoundDataLengths[bindPosition] = fixedLength;
        }
        bindIndicators[indoffset] = 0;
        bindIndicators[lenoffset] = (short)fixedLength;
        return localCheckSum;
    }

    private int getDatumBytes(OraclePreparedStatement stmt, double val, byte[] b, int offset) throws SQLException {
        int fixedLength = 8;
        if (val == 0.0) {
            val = 0.0;
        } else if (val != val) {
            val = Double.NaN;
        }
        long longBits = Double.doubleToLongBits(val);
        int lowInt = (int)longBits;
        int highInt = (int)(longBits >> 32);
        int b7 = lowInt;
        int b6 = lowInt >>= 8;
        int b5 = lowInt >>= 8;
        int b4 = lowInt >>= 8;
        int b3 = highInt;
        int b2 = highInt >>= 8;
        int b1 = highInt >>= 8;
        int b0 = highInt >>= 8;
        if ((b0 & 0x80) == 0) {
            b0 |= 0x80;
        } else {
            b0 ^= 0xFFFFFFFF;
            b1 ^= 0xFFFFFFFF;
            b2 ^= 0xFFFFFFFF;
            b3 ^= 0xFFFFFFFF;
            b4 ^= 0xFFFFFFFF;
            b5 ^= 0xFFFFFFFF;
            b6 ^= 0xFFFFFFFF;
            b7 ^= 0xFFFFFFFF;
        }
        b[offset + 7] = (byte)b7;
        b[offset + 6] = (byte)b6;
        b[offset + 5] = (byte)b5;
        b[offset + 4] = (byte)b4;
        b[offset + 3] = (byte)b3;
        b[offset + 2] = (byte)b2;
        b[offset + 1] = (byte)b1;
        b[offset] = (byte)b0;
        return fixedLength;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        byte[] b = stmt.connection.methodTempLittleByteBuffer;
        int len = this.getDatumBytes(stmt, this.paramVal, b, 0);
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, Arrays.copyOf(b, len), internalType, null, 0);
    }
}

