/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import oracle.jdbc.driver.Chain;
import oracle.jdbc.driver.OracleResultSet;

public final class LRUCache<T> {
    private Chain.Link<T>[] vacant = new Chain.Link[]{null};
    private int highWaterMark = 0;
    private final boolean implicit;
    private static final int NSTMTS = 3;
    private static final int MRSETS = LRUCache.computeMaxResultSetType() + 1;
    private final Map<String, Chain<T>>[] cache;
    private Chain<T> history = new Chain<T>(this.vacant, this.highWaterMark);
    private boolean removingLeastRecentEntry = false;

    private static int computeMaxResultSetType() {
        return Arrays.stream(OracleResultSet.ResultSetType.values()).mapToInt(p -> p.ordinal()).max().getAsInt();
    }

    public LRUCache(boolean implicit) {
        int arrSize;
        this.implicit = implicit;
        int n = arrSize = implicit ? 3 * MRSETS : 1;
        if (arrSize > 1000) {
            throw new IllegalStateException("internal error: LRUCache map array size is " + arrSize + ", watch ordinals for stmptType/RsetType");
        }
        this.cache = new Map[arrSize];
        Arrays.fill(this.cache, null);
    }

    public void vacancy(int size) {
        if (size > 1) {
            this.vacant = new Chain.Link[Math.min(size, 1000)];
            this.highWaterMark = 0;
        }
    }

    public T removeMostRecent(int stmtType, int rsetType, String sql) {
        int index;
        if (stmtType >= 3) {
            throw new IllegalArgumentException("wrong stmtType");
        }
        if (rsetType >= MRSETS) {
            throw new IllegalArgumentException("wrong rsetType");
        }
        int n = index = this.implicit ? stmtType * MRSETS + rsetType : 0;
        if (this.cache[index] != null) {
            Chain<T> res = this.cache[index].get(sql);
            return res == null ? null : (T)res.removeHead();
        }
        return null;
    }

    public boolean hasKey(int stmtType, int rsetType, String sql) {
        if (stmtType >= 3) {
            throw new IllegalArgumentException("wrong stmtType");
        }
        if (rsetType >= MRSETS) {
            throw new IllegalArgumentException("wrong rsetType");
        }
        int index = this.implicit ? stmtType * MRSETS + rsetType : 0;
        return this.cache[index] != null && this.cache[index].get(sql) != null;
    }

    public T removeLeastRecent() {
        this.removingLeastRecentEntry = true;
        try {
            T t = this.history.removeTail();
            return t;
        }
        finally {
            this.removingLeastRecentEntry = false;
        }
    }

    public void add(T value, int stmtType, int rsetType, String sql) {
        Objects.requireNonNull(value, "value is null");
        if (stmtType >= 3) {
            throw new IllegalArgumentException("wrong stmtType");
        }
        if (rsetType >= MRSETS) {
            throw new IllegalArgumentException("wrong rsetType");
        }
        Objects.requireNonNull(sql, "sql is null");
        int index = this.implicit ? stmtType * MRSETS + rsetType : 0;
        Map<String, Chain<T>> mapToOperate = Objects.isNull(this.cache[index]) ? new HashMap<String, Chain<T>>() : this.cache[index];
        Runnable chainEmptyingTrigger = () -> {
            if (this.removingLeastRecentEntry) {
                mapToOperate.remove(sql);
            }
        };
        Function<String, Chain> chainProvider = key -> new Chain<T>(this.vacant, this.highWaterMark, chainEmptyingTrigger);
        Chain chainToAdd = mapToOperate.computeIfAbsent(sql, chainProvider);
        Chain.addHead(value, chainToAdd, this.history);
    }

    public int size() {
        return this.history.size();
    }

    public int historySize() {
        return this.history.size();
    }

    public int mapSize() {
        return Arrays.stream(this.cache).filter(Objects::nonNull).mapToInt(Map::size).sum();
    }

    public void forEach(Consumer<? super T> action) {
        if (Objects.nonNull(this.history)) {
            this.history.forEach(action);
        }
    }

    public String toString() {
        return "cache=" + Arrays.deepToString(this.cache) + ", history=" + this.history;
    }

    public void close() {
        for (int i = 0; i < this.cache.length; ++i) {
            if (this.cache[i] == null) continue;
            this.cache[i].clear();
            this.cache[i] = null;
        }
        this.history = null;
        this.vacant = null;
        this.highWaterMark = 0;
    }
}

