/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Condition;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.NTFDCNConnectionGroup;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoaqnfy;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.pool.OracleDataSource;

public class NTFDCNConnection
extends Thread
implements Monitor.WaitableMonitor,
Diagnosable {
    private static final String CLASS_NAME = NTFDCNConnection.class.getName();
    private String clientId;
    private String instanceName;
    private String serviceName;
    private String userName;
    private OpaqueString password;
    private String connClass;
    private ArrayList<String> listenerAddresses;
    private static final int MAX_NUMBER_OF_TRIES = 5;
    private Connection conn = null;
    private T4CTTIoaqnfy oaqnfy = null;
    private volatile boolean needToBeClosed = false;
    private boolean safeToClose = true;
    private int numberOfRegistrations = 0;
    private NTFDCNConnectionGroup connectionGroup = null;
    static final int STARTED = 0;
    static final int NOT_STARTED = 1;
    int status = 1;
    boolean dcnStartedException = false;
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();
    private final Condition monitorCondition = this.newMonitorCondition();
    private Properties connectionProps = null;

    NTFDCNConnection(String clientId, ArrayList<String> listenerAddresses, String instanceName, String serviceName, String userName, OpaqueString password, Properties _connectionProps, String connClass, int numberOfRegistrations) {
        this.userName = userName;
        this.password = password;
        this.connectionProps = _connectionProps;
        this.serviceName = serviceName;
        this.clientId = clientId;
        this.listenerAddresses = listenerAddresses;
        this.instanceName = instanceName;
        this.connClass = connClass;
        this.numberOfRegistrations = numberOfRegistrations;
        assert (listenerAddresses != null) : "listenerAddresses is null";
        assert (instanceName != null) : "instancename is null";
    }

    @Override
    public void run() {
        boolean retry = false;
        boolean reConnect = false;
        int conAttempt = 0;
        int errorCode = 0;
        int maxRetryCnt = 1;
        for (int cnt = 0; cnt < maxRetryCnt && !this.needToBeClosed; ++cnt) {
            Level logLevel;
            try {
                if (cnt == 0 || reConnect) {
                    this.conn = this.getConnection(conAttempt);
                    this.oaqnfy = new T4CTTIoaqnfy((T4CConnection)this.conn, this.clientId, true);
                    this.oaqnfy.setDCNConnection(this);
                }
                if (retry || !this.needToBeClosed) {
                    retry = false;
                    reConnect = false;
                    cnt = 0;
                }
                try (Monitor.CloseableLock lock = ((T4CConnection)this.conn).acquireCloseableLock();){
                    this.oaqnfy.doRPC();
                    continue;
                }
            }
            catch (IOException eIo) {
                logLevel = this.needToBeClosed ? Level.FINE : Level.WARNING;
                this.debug(logLevel, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "connectionId={0}, userName={1}, connClass={2}, instnaceName={3}. ", (String)null, eIo, (Object)this.clientId, (Object)this.userName, (Object)this.connClass, (Object)this.instanceName);
                this.needToBeClosed = true;
                continue;
            }
            catch (Exception e) {
                logLevel = this.needToBeClosed ? Level.FINE : Level.WARNING;
                this.debug(logLevel, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "connectionId={0}, userName={1}, connClass={2}, instnaceName={3}. ", (String)null, e, (Object)this.clientId, (Object)this.userName, (Object)this.connClass, (Object)this.instanceName);
                if (this.needToBeClosed || retry) {
                    this.dcnStartedException = true;
                    break;
                }
                if (e instanceof SQLException) {
                    errorCode = ((SQLException)e).getErrorCode();
                }
                if (errorCode == 17410) {
                    reConnect = true;
                    errorCode = 0;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {}
                } else {
                    reConnect = false;
                }
                retry = true;
            }
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "run", "connectionId={0}, userName={1}. End of run method. Thread will be closed. ", (String)null, (Throwable)null, (Object)this.clientId, (Object)this.userName);
    }

    Connection getConnection(int noOfTries) throws SQLException, InterruptedException {
        Connection notificationConnection = null;
        OracleDataSource ods = new OracleDataSource();
        Properties props = new Properties();
        if (this.connectionProps != null) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getConnection", "Using connection properties for listener connection. ", null, null);
            props.putAll((Map<?, ?>)this.connectionProps);
        }
        if (this.userName != null) {
            ods.setUser(this.userName);
            ods.setPassword(this.password.get());
        }
        if (this.connClass != null) {
            props.put("oracle.jdbc.DRCPConnectionClass", this.connClass);
            props.put("oracle.jdbc.jmsNotification", "true");
            props.put("oracle.jdbc.ReadTimeout", (Object)0);
            props.put("oracle.net.CONNECT_TIMEOUT", (Object)0);
        }
        props.put("oracle.jdbc.enableACSupport", "false");
        ods.setConnectionProperties(props);
        while (notificationConnection == null && noOfTries++ < 5 && !this.needToBeClosed) {
            notificationConnection = this.tryListenerAddressesToGetConnection(ods);
            if (notificationConnection != null || noOfTries >= 5) continue;
            Thread.sleep(noOfTries * 5000);
        }
        if (notificationConnection == null && !this.needToBeClosed) {
            throw new SQLException("Failed to create notification connection to emon server");
        }
        return notificationConnection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Connection tryListenerAddressesToGetConnection(OracleDataSource ods) {
        Iterator<String> iterator = this.listenerAddresses.iterator();
        while (iterator.hasNext()) {
            String listenerAddress = iterator.next();
            String url = "jdbc:oracle:thin:@(DESCRIPTION=" + listenerAddress + "(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")(SERVER=EMON)(INSTANCE_NAME=" + this.instanceName + ")))";
            ods.setURL(url);
            try {
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    if (this.needToBeClosed) {
                        Connection connection = null;
                        return connection;
                    }
                    Connection notificationConnection = ods.getConnection();
                    if (notificationConnection == null) continue;
                    Connection connection = notificationConnection;
                    return connection;
                }
                finally {
                    if (lock == null) continue;
                    lock.close();
                }
            }
            catch (SQLException sqe) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "tryListenerAddressesToGetConnection", "NTFDCNConnectionURL={0}, userName={1}. ", (String)null, sqe, (Object)url, (Object)this.userName);
            }
        }
        return null;
    }

    void closeThisListener() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.needToBeClosed = true;
            try {
                if (this.oaqnfy != null) {
                    this.oaqnfy.stopListening();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException ex) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "closeThisListener", "dcnConnectionId={0}, userName={1}. ", (String)null, ex, (Object)this.clientId, (Object)this.userName);
            }
        }
    }

    void signalConnectionStarted() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.status = 0;
            this.monitorNotify();
        }
    }

    void setNeedToBeClosed(boolean _needToBeClosed) {
        this.needToBeClosed = _needToBeClosed;
    }

    String getClientId() {
        return this.clientId;
    }

    int getNumberOfRegistrations() {
        return this.numberOfRegistrations;
    }

    void incrementNumberOfRegistrations(int n) {
        this.numberOfRegistrations += n;
    }

    void decrementNumberOfRegistrations(int n) {
        this.numberOfRegistrations -= n;
    }

    void setConnectionGroup(NTFDCNConnectionGroup connGroup) {
        this.connectionGroup = connGroup;
    }

    NTFDCNConnectionGroup getConnectionGroup() {
        if (this.connectionGroup == null) {
            this.connectionGroup = PhysicalConnection.ntfManager.getDCNConnectionGroup(this.userName + this.instanceName);
        }
        return this.connectionGroup;
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public final Condition getMonitorCondition() {
        return this.monitorCondition;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

