/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;

class T4C8TTILobd
extends T4CTTIMsg {
    private static final String CLASS_NAME = T4C8TTILobd.class.getName();
    static final int LOBD_STATE0 = 0;
    static final int LOBD_STATE1 = 1;
    static final int LOBD_STATE2 = 2;
    static final int LOBD_STATE3 = 3;
    static final int LOBD_STATE_EXIT = 4;
    static final short TTCG_LNG = 254;
    static final short LOBDATALENGTH = 252;
    static byte[] ucs2Char = new byte[2];

    T4C8TTILobd(T4CConnection _conn) {
        super(_conn, (byte)14);
    }

    void marshalLobData(byte[] inBuffer, long inBufferOffset, long numBytes, boolean useZeroCopyIO) throws IOException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalLobData", "inBufferOffset={0}, numBytes={1}, useZeroCopyIO={2}", (String)null, (Throwable)null, (Object)inBufferOffset, (Object)numBytes, (Object)useZeroCopyIO);
        long length = numBytes;
        this.marshalTTCcode();
        if (useZeroCopyIO) {
            this.meg.writeZeroCopyIO(inBuffer, (int)inBufferOffset, (int)numBytes);
        } else {
            this.meg.marshalCLR(inBuffer, (int)inBufferOffset, (int)numBytes);
        }
    }

    void marshalClobUB2_For9iDB(byte[] inBuffer, long inBufferOffset, long numChars) throws IOException {
        long numUB2 = numChars;
        boolean ttcgLong = false;
        this.marshalTTCcode();
        if (numUB2 > 84L) {
            ttcgLong = true;
            this.meg.marshalUB1((short)254);
        }
        long count = 0L;
        while (numUB2 > 84L) {
            this.meg.marshalUB1((short)252);
            for (int j = 0; j < 84; ++j) {
                this.meg.marshalUB1((short)2);
                this.meg.marshalB1Array(inBuffer, (int)(inBufferOffset + count * 168L + (long)(j * 2)), 2);
            }
            ++count;
            numUB2 -= 84L;
        }
        if (numUB2 > 0L) {
            long length = numUB2 * 3L;
            this.meg.marshalUB1((short)length);
            int j = 0;
            while ((long)j < numUB2) {
                this.meg.marshalUB1((short)2);
                this.meg.marshalB1Array(inBuffer, (int)(inBufferOffset + count * 168L + (long)(j * 2)), 2);
                ++j;
            }
        }
        if (ttcgLong) {
            this.meg.marshalUB1((short)0);
        }
    }

    long unmarshalLobData(byte[] outBuffer, int offsetInOutBuffer, boolean useZeroCopyIO) throws SQLException, IOException {
        int bytesRead = 0;
        if (useZeroCopyIO) {
            int nbOfBytesReadSoFar = 0;
            int[] nbOfByteRead = new int[1];
            boolean isMarked = false;
            while (!isMarked) {
                try {
                    isMarked = this.meg.readZeroCopyIO(outBuffer, offsetInOutBuffer + nbOfBytesReadSoFar, nbOfByteRead);
                }
                catch (SocketTimeoutException toe) {
                    this.connection.doAsynchronousClose();
                    throw toe;
                }
                nbOfBytesReadSoFar += nbOfByteRead[0];
            }
            bytesRead = nbOfBytesReadSoFar;
        } else {
            int offset = offsetInOutBuffer;
            boolean length = false;
            int[] readBytes = new int[1];
            this.meg.unmarshalCLR(outBuffer, offset, readBytes);
            bytesRead = readBytes[0];
        }
        return bytesRead;
    }

    long unmarshalClobUB2_For9iDB(byte[] outBuffer, int offsetInOutBuffer) throws SQLException, IOException {
        long bytesRead = 0L;
        long offset = offsetInOutBuffer;
        int length = 0;
        int i = 0;
        int numBytes = 0;
        int state = 0;
        block6: while (state != 4) {
            switch (state) {
                case 0: {
                    length = this.meg.unmarshalUB1();
                    if (length == 254) {
                        state = 2;
                        continue block6;
                    }
                    state = 1;
                    continue block6;
                }
                case 1: {
                    i = 0;
                    while (i < length) {
                        numBytes = this.meg.unmarshalUCS2(outBuffer, offset);
                        i += numBytes;
                        offset += 2L;
                        bytesRead += 2L;
                    }
                    state = 4;
                    continue block6;
                }
                case 2: {
                    length = this.meg.unmarshalUB1();
                    if (length > 0) {
                        state = 3;
                        continue block6;
                    }
                    state = 4;
                    continue block6;
                }
                case 3: {
                    i = 0;
                    while (i < length) {
                        numBytes = this.meg.unmarshalUCS2(outBuffer, offset);
                        i += numBytes;
                        offset += 2L;
                        bytesRead += 2L;
                    }
                    state = 2;
                    continue block6;
                }
            }
        }
        return bytesRead;
    }
}

