/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import javax.security.auth.x500.X500Principal;
import oracle.security.pki.C041;
import oracle.security.pki.FileLockProvider;
import oracle.security.pki.OracleKeyStoreSpi;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWalletPermission;
import oracle.security.pki.internal.cert.CertificateRequest;
import oracle.security.pki.util.InvalidFormatException;

public class OracleSSOKeyStoreSpi
extends OracleKeyStoreSpi {
    private C041 b = new C041();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleSSOKeyStoreImpl: engineLoad");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkPermission(new OracleWalletPermission("load"));
                }
                return null;
            }
        });
        FileChannel fileChannel = null;
        FileLock fileLock = null;
        try {
            if (inputStream instanceof FileInputStream) {
                fileChannel = ((FileInputStream)inputStream).getChannel();
                OraclePKIDebug.a("OracleSSOKeyStoreSpi.engineLoad:locking file (shared)..");
                fileLock = FileLockProvider.a(null, fileChannel, 0L, inputStream.available(), true);
                OraclePKIDebug.a("OracleSSOKeyStoreSpi.engineLoad:locked file.");
            }
            char[] cArray2 = null;
            try {
                byte[] byArray = this.b.a(inputStream);
                int n = this.b.a(byArray);
                byte[] byArray2 = this.b.d(inputStream);
                int n2 = this.b.b(byArray2);
                if (n == 3 && n2 == 7) {
                    byte[] byArray3 = new byte[112];
                    System.arraycopy(byArray, 0, byArray3, 0, 4);
                    System.arraycopy(byArray2, 0, byArray3, 4, 4);
                    inputStream.read(byArray3, 8, 104);
                    if (OraclePKIDebug.getDebugFlag()) {
                        this.a(byArray3);
                    }
                    cArray2 = this.b.f(byArray3);
                } else {
                    cArray2 = this.b.b(inputStream);
                    if (n == 3) {
                        cArray2 = this.b.a(cArray2);
                        OraclePKIDebug.a("OracleSSOKeyStoreImpl: an LSSO wallet");
                    }
                }
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
            super.engineLoadForSSO(inputStream, cArray2);
        }
        finally {
            if (fileLock != null) {
                OraclePKIDebug.a("OracleSSOKeyStoreSpi.engineLoad:releasing lock..");
                fileLock.release();
            }
            if (fileChannel != null) {
                OraclePKIDebug.a("OracleSSOKeyStoreSpi.engineLoad:closing channel..");
                fileChannel.close();
            }
        }
    }

    void a(byte[] byArray) {
        OraclePKIDebug.a("OracleSSOKeyStoreSpi.trace_lsso(): enter");
        C041 c041 = new C041();
        try {
            int n = c041.c(byArray);
            String string = c041.d(byArray);
            String string2 = c041.e(byArray);
            if ((n & 1) == 1) {
                OraclePKIDebug.a("  SSV_HOSTNAME is set");
            }
            if ((n & 2) == 2) {
                OraclePKIDebug.a("  SSV_USERNAME is set");
            }
            if ((n & 0x10) == 16) {
                OraclePKIDebug.a("  SSV_MACHINEID is set");
            }
            if ((n & 0x80) == 128) {
                OraclePKIDebug.a("  SSV_MACNAME0:" + string + "  is set");
            }
            if ((n & 0x100) == 256) {
                OraclePKIDebug.a("  SSV_MACNAME1:" + string2 + "  is set");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        OraclePKIDebug.a("OracleSSOKeyStoreSpi.trace_lsso(): exit");
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray) throws IOException, OracleSecretStoreException {
        char[] cArray2 = null;
        int n = 0;
        int n2 = 0;
        try {
            n = this.b.c(inputStream);
            n2 = this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        byte[] byArray = super.a(inputStream, cArray2);
        byte[] byArray2 = null;
        try {
            byArray2 = this.b.a(cArray2, n);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray2.length + byArray.length);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(byArray);
        return byteArrayOutputStream.toByteArray();
    }

    static void a(InputStream inputStream, char[] cArray, OutputStream outputStream, char[] cArray2, int n) throws IOException {
        OracleSSOKeyStoreSpi.a(inputStream, cArray, outputStream, cArray2, n, (byte)0);
    }

    static void a(InputStream inputStream, char[] cArray, OutputStream outputStream, char[] cArray2, int n, byte by) throws IOException {
        OracleSSOKeyStoreSpi.a(inputStream, cArray, outputStream, cArray2, n, (byte)0, 0, null, null);
    }

    static void a(InputStream inputStream, char[] cArray, OutputStream outputStream, char[] cArray2, int n, byte by, int n2, String string, String string2) throws IOException {
        char[] cArray3 = null;
        byte[] byArray = new byte[1024];
        byte[] byArray2 = null;
        C041 c041 = new C041();
        try {
            if (n == 3) {
                byArray2 = c041.a(n, n2, string, string2);
                cArray3 = c041.f(byArray2);
            } else {
                cArray3 = c041.g(byArray);
                byArray2 = c041.a(cArray3, n);
                if (n == 3) {
                    cArray3 = c041.a(cArray3);
                    OraclePKIDebug.a("OracleSSOKeyStoreImpl: an LSSO wallet");
                }
            }
        }
        catch (IOException iOException) {
            OraclePKIDebug.a("OracleSSOKeyStoreSpi.storeAs():" + iOException.getMessage());
            throw new IOException(iOException.getMessage());
        }
        boolean bl = true;
        for (int i = 0; i < byArray2.length && bl; ++i) {
            bl = byArray2[i] == byArray[i];
        }
        outputStream.write(byArray2);
        OracleKeyStoreSpi.a(inputStream, cArray, outputStream, cArray3, by);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, CertificateRequest certificateRequest, PrivateKey privateKey, String string) throws IOException, KeyStoreException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, certificateRequest, privateKey, string);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, boolean bl) throws IOException, KeyStoreException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, oraclePKIX509CertImpl, string, string2, bl);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, HashMap hashMap, boolean bl) throws IOException, KeyStoreException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, oraclePKIX509CertImpl, string, hashMap, bl);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException, InvalidFormatException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, x500Principal);
    }

    @Override
    byte[] e(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.e(inputStream, cArray2, string);
    }

    @Override
    byte[] b(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException, InvalidFormatException {
        return this.a(inputStream, cArray, x500Principal, null, null);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, CertificateEncodingException, InvalidFormatException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, x500Principal, string, string2);
    }

    @Override
    byte[] h(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.h(inputStream, cArray2, string);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2) throws IOException, KeyStoreException, CertificateEncodingException, InvalidFormatException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, oraclePKIX509CertImpl, string, string2);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, String string, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, string, hashMap);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException, InvalidFormatException {
        return this.a(inputStream, cArray, x500Principal, null, null, hashMap);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal, String string, String string2, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException, InvalidFormatException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, x500Principal, string, string2, hashMap);
    }

    @Override
    byte[] b(InputStream inputStream, char[] cArray, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.b(inputStream, cArray2, hashMap);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, HashMap hashMap) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, oraclePKIX509CertImpl, string, string2, hashMap);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, String string3, HashMap hashMap) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, InvalidFormatException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, oraclePKIX509CertImpl, string, string2, string3, hashMap);
    }

    @Override
    public byte[] internalAddPrivateKeyAndCertificateChain(InputStream inputStream, char[] cArray, String string, Key key, Certificate[] certificateArray) throws IOException, CertificateEncodingException, InvalidFormatException {
        char[] cArray2 = null;
        try {
            int n = this.b.c(inputStream);
            int n2 = this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
            if (n == 3) {
                cArray2 = this.b.a(cArray2);
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.internalAddPrivateKeyAndCertificateChain(inputStream, cArray2, string, key, certificateArray);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, HashMap hashMap) throws IOException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            byte[] byArray = this.b.a(inputStream);
            int n = this.b.a(byArray);
            byte[] byArray2 = this.b.d(inputStream);
            int n2 = this.b.b(byArray2);
            if (n == 3 && n2 == 7) {
                byte[] byArray3 = new byte[112];
                System.arraycopy(byArray, 0, byArray3, 0, 4);
                System.arraycopy(byArray2, 0, byArray3, 4, 4);
                inputStream.read(byArray3, 8, 104);
                cArray2 = this.b.f(byArray3);
            } else {
                cArray2 = this.b.b(inputStream);
                if (n == 3) {
                    cArray2 = this.b.a(cArray2);
                }
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, hashMap);
    }

    @Override
    boolean b(InputStream inputStream, char[] cArray) throws IOException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            byte[] byArray = this.b.a(inputStream);
            int n = this.b.a(byArray);
            byte[] byArray2 = this.b.d(inputStream);
            int n2 = this.b.b(byArray2);
            if (n == 3 && n2 == 7) {
                byte[] byArray3 = new byte[112];
                System.arraycopy(byArray, 0, byArray3, 0, 4);
                System.arraycopy(byArray2, 0, byArray3, 4, 4);
                inputStream.read(byArray3, 8, 104);
                cArray2 = this.b.f(byArray3);
            } else {
                cArray2 = this.b.b(inputStream);
                if (n == 3) {
                    cArray2 = this.b.a(cArray2);
                }
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.b(inputStream, cArray2);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, String string, String string2, String string3, String string4, HashMap hashMap) throws IOException, CertificateEncodingException, InvalidFormatException {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, string, string2, string3, string4, hashMap);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, HashMap hashMap, boolean bl) throws Exception {
        char[] cArray2 = null;
        try {
            this.b.c(inputStream);
            this.b.e(inputStream);
            cArray2 = this.b.b(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, hashMap, bl);
    }
}

