/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.asn1.ASN1String;
import oracle.security.pki.internal.cert.PKIX;
import oracle.security.pki.util.Utils;

public class X509PolicyInformation
implements Externalizable,
ASN1Object {
    private ASN1ObjectID a;
    private ArrayList<ASN1Object> b;
    private ASN1Sequence c;

    public X509PolicyInformation() {
    }

    public X509PolicyInformation(ASN1ObjectID aSN1ObjectID) {
        this.a = aSN1ObjectID;
    }

    public X509PolicyInformation(ASN1ObjectID aSN1ObjectID, List<ASN1Object> list) {
        this.a = aSN1ObjectID;
        this.b = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<ASN1Object>(list));
    }

    public X509PolicyInformation(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void a(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        if (this.a.equals(PKIX.aa) && !aSN1ObjectID.equals(PKIX.ab) && !aSN1ObjectID.equals(PKIX.ac)) {
            throw new IllegalArgumentException("Illegal qualifier type for anyPolicy policy");
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.a(aSN1ObjectID);
        aSN1Sequence.a(aSN1Object);
        if (this.b == null) {
            this.b = new ArrayList();
        }
        this.b.add(aSN1Sequence);
        this.d();
    }

    public void a(String string) {
        this.a(PKIX.ab, new ASN1String(string, 22));
    }

    public void a(String string, int[] nArray, String string2) {
        if (string == null ^ nArray == null) {
            throw new IllegalArgumentException("Both or neither of organization and noticeNumbers must be present");
        }
        if (string == null && string2 == null) {
            throw new IllegalArgumentException("No user notice content given");
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (string != null) {
            ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
            aSN1Sequence2.a(new ASN1String(string));
            ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                aSN1Sequence3.a(new ASN1Integer(nArray[i]));
            }
            aSN1Sequence2.a(aSN1Sequence3);
            aSN1Sequence.a(aSN1Sequence2);
        }
        if (string2 != null) {
            aSN1Sequence.a(new ASN1String(string2));
        }
        this.a(PKIX.ac, aSN1Sequence);
    }

    public ASN1ObjectID a() {
        return this.a;
    }

    public ArrayList<ASN1Object> b() {
        return this.b;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.a = new ASN1ObjectID(aSN1SequenceInputStream);
        this.b = aSN1SequenceInputStream.a() ? new ASN1Sequence(aSN1SequenceInputStream).b() : null;
        aSN1SequenceInputStream.b();
        this.d();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.c().output(outputStream);
    }

    private ASN1Sequence c() {
        if (this.c == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.a(this.a);
            if (this.b != null) {
                aSN1Sequence.a(new ASN1Sequence((List<? extends ASN1Object>)this.b));
            }
            this.c = aSN1Sequence;
        }
        return this.c;
    }

    @Override
    public int length() {
        return this.c().length();
    }

    private void d() {
        this.c = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("id = " + this.a);
        if (this.b != null) {
            stringBuffer.append(", policyQualifiers = " + Utils.toHexString(Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.b))));
        }
        return stringBuffer.toString();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

