/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.fileformats.meta;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.compositeindex.CompositeIndexMetadata;
import org.opensearch.index.compositeindex.datacube.DimensionDataType;
import org.opensearch.index.compositeindex.datacube.Metric;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeFieldConfiguration;
import org.opensearch.index.compositeindex.datacube.startree.fileformats.meta.DimensionConfig;
import org.opensearch.index.mapper.CompositeMappedFieldType;

@ExperimentalApi
public class StarTreeMetadata
extends CompositeIndexMetadata {
    private static final Logger logger = LogManager.getLogger(StarTreeMetadata.class);
    private final IndexInput meta;
    private final int version;
    private final int numberOfNodes;
    private final String starTreeFieldName;
    private final String starTreeFieldType;
    private LinkedHashMap<String, DimensionConfig> dimensionFieldToDimensionConfigMap;
    private final List<Metric> metrics;
    private final int segmentAggregatedDocCount;
    private final int maxLeafDocs;
    private final Set<String> skipStarNodeCreationInDims;
    private final StarTreeFieldConfiguration.StarTreeBuildMode starTreeBuildMode;
    private final long dataStartFilePointer;
    private final long dataLength;
    private final int starTreeDocCount;

    public StarTreeMetadata(IndexInput metaIn, String compositeFieldName, CompositeMappedFieldType.CompositeFieldType compositeFieldType, Integer version) throws IOException {
        super(compositeFieldName, compositeFieldType);
        this.meta = metaIn;
        try {
            this.starTreeFieldName = this.getCompositeFieldName();
            this.starTreeFieldType = this.getCompositeFieldType().getName();
            this.version = version;
            this.numberOfNodes = this.readNumberOfNodes();
            this.dimensionFieldToDimensionConfigMap = this.readStarTreeDimensions();
            this.metrics = this.readMetricEntries();
            this.segmentAggregatedDocCount = this.readSegmentAggregatedDocCount();
            this.starTreeDocCount = this.readStarTreeDocCount();
            this.maxLeafDocs = this.readMaxLeafDocs();
            this.skipStarNodeCreationInDims = this.readSkipStarNodeCreationInDims();
            this.starTreeBuildMode = this.readBuildMode();
            this.dataStartFilePointer = this.readDataStartFilePointer();
            this.dataLength = this.readDataLength();
        }
        catch (Exception e) {
            logger.error("Unable to read star-tree metadata from the file");
            throw new CorruptIndexException("Unable to read star-tree metadata from the file", (DataInput)metaIn);
        }
    }

    public StarTreeMetadata(String compositeFieldName, CompositeMappedFieldType.CompositeFieldType compositeFieldType, IndexInput meta, Integer version, Integer numberOfNodes, LinkedHashMap<String, DimensionConfig> dimensionFieldToDimensionConfigMap, List<Metric> metrics, Integer segmentAggregatedDocCount, Integer starTreeDocCount, Integer maxLeafDocs, Set<String> skipStarNodeCreationInDims, StarTreeFieldConfiguration.StarTreeBuildMode starTreeBuildMode, long dataStartFilePointer, long dataLength) {
        super(compositeFieldName, compositeFieldType);
        this.meta = meta;
        this.starTreeFieldName = compositeFieldName;
        this.starTreeFieldType = compositeFieldType.getName();
        this.version = version;
        this.numberOfNodes = numberOfNodes;
        this.dimensionFieldToDimensionConfigMap = dimensionFieldToDimensionConfigMap;
        this.metrics = metrics;
        this.segmentAggregatedDocCount = segmentAggregatedDocCount;
        this.starTreeDocCount = starTreeDocCount;
        this.maxLeafDocs = maxLeafDocs;
        this.skipStarNodeCreationInDims = skipStarNodeCreationInDims;
        this.starTreeBuildMode = starTreeBuildMode;
        this.dataStartFilePointer = dataStartFilePointer;
        this.dataLength = dataLength;
    }

    private int readNumberOfNodes() throws IOException {
        return this.meta.readVInt();
    }

    private int readDimensionsCount() throws IOException {
        return this.meta.readVInt();
    }

    private LinkedHashMap<String, DimensionConfig> readStarTreeDimensions() throws IOException {
        int dimensionCount = this.readDimensionsCount();
        LinkedHashMap<String, DimensionConfig> dimensionFieldToDimensionConfigMap = new LinkedHashMap<String, DimensionConfig>();
        for (int i = 0; i < dimensionCount; ++i) {
            if (this.getVersion() >= 1) {
                dimensionFieldToDimensionConfigMap.put(this.meta.readString(), new DimensionConfig(StarTreeMetadata.getDocValuesType(this.meta, this.meta.readByte()), StarTreeMetadata.getDimensionDataType(this.meta, this.meta.readByte())));
                continue;
            }
            dimensionFieldToDimensionConfigMap.put(this.meta.readString(), new DimensionConfig(StarTreeMetadata.getDocValuesType(this.meta, this.meta.readByte()), DimensionDataType.LONG));
        }
        return dimensionFieldToDimensionConfigMap;
    }

    private int readMetricsCount() throws IOException {
        return this.meta.readVInt();
    }

    private List<Metric> readMetricEntries() throws IOException {
        int metricCount = this.readMetricsCount();
        LinkedHashMap<String, List> starTreeMetricStatMap = new LinkedHashMap<String, List>();
        for (int i = 0; i < metricCount; ++i) {
            String metricName = this.meta.readString();
            int metricStatOrdinal = this.meta.readVInt();
            MetricStat metricStat = MetricStat.fromMetricOrdinal(metricStatOrdinal);
            List metricStats = starTreeMetricStatMap.computeIfAbsent(metricName, field -> new ArrayList());
            metricStats.add(metricStat);
        }
        ArrayList<Metric> starTreeMetricMap = new ArrayList<Metric>();
        for (Map.Entry metricStatsEntry : starTreeMetricStatMap.entrySet()) {
            this.addEligibleDerivedMetrics((List)metricStatsEntry.getValue());
            starTreeMetricMap.add(new Metric((String)metricStatsEntry.getKey(), (List)metricStatsEntry.getValue()));
        }
        return starTreeMetricMap;
    }

    private void addEligibleDerivedMetrics(List<MetricStat> metricStatsList) {
        HashSet<MetricStat> metricStatsSet = new HashSet<MetricStat>(metricStatsList);
        for (MetricStat metric : MetricStat.values()) {
            List<MetricStat> sourceMetrics;
            if (!metric.isDerivedMetric() || metricStatsSet.contains((Object)metric) || !metricStatsSet.containsAll(sourceMetrics = metric.getBaseMetrics())) continue;
            metricStatsList.add(metric);
            metricStatsSet.add(metric);
        }
    }

    private int readSegmentAggregatedDocCount() throws IOException {
        return this.meta.readVInt();
    }

    private Integer readStarTreeDocCount() throws IOException {
        return this.meta.readVInt();
    }

    private int readMaxLeafDocs() throws IOException {
        return this.meta.readVInt();
    }

    private int readSkipStarNodeCreationInDimsCount() throws IOException {
        return this.meta.readVInt();
    }

    private Set<String> readSkipStarNodeCreationInDims() throws IOException {
        int skipStarNodeCreationInDimsCount = this.readSkipStarNodeCreationInDimsCount();
        HashSet<String> skipStarNodeCreationInDims = new HashSet<String>();
        for (int i = 0; i < skipStarNodeCreationInDimsCount; ++i) {
            skipStarNodeCreationInDims.add(this.meta.readString());
        }
        return skipStarNodeCreationInDims;
    }

    private StarTreeFieldConfiguration.StarTreeBuildMode readBuildMode() throws IOException {
        return StarTreeFieldConfiguration.StarTreeBuildMode.fromBuildModeOrdinal(this.meta.readByte());
    }

    private long readDataStartFilePointer() throws IOException {
        return this.meta.readVLong();
    }

    private long readDataLength() throws IOException {
        return this.meta.readVLong();
    }

    public String getStarTreeFieldName() {
        return this.starTreeFieldName;
    }

    public String getStarTreeFieldType() {
        return this.starTreeFieldType;
    }

    public Map<String, DimensionConfig> getDimensionFields() {
        return this.dimensionFieldToDimensionConfigMap;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public int getSegmentAggregatedDocCount() {
        return this.segmentAggregatedDocCount;
    }

    public int getStarTreeDocCount() {
        return this.starTreeDocCount;
    }

    public int getMaxLeafDocs() {
        return this.maxLeafDocs;
    }

    public Set<String> getSkipStarNodeCreationInDims() {
        return this.skipStarNodeCreationInDims;
    }

    public StarTreeFieldConfiguration.StarTreeBuildMode getStarTreeBuildMode() {
        return this.starTreeBuildMode;
    }

    public long getDataStartFilePointer() {
        return this.dataStartFilePointer;
    }

    public long getDataLength() {
        return this.dataLength;
    }

    public int getVersion() {
        return this.version;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    private static DocValuesType getDocValuesType(IndexInput input, byte b) throws IOException {
        switch (b) {
            case 0: {
                return DocValuesType.NONE;
            }
            case 1: {
                return DocValuesType.NUMERIC;
            }
            case 2: {
                return DocValuesType.BINARY;
            }
            case 3: {
                return DocValuesType.SORTED;
            }
            case 4: {
                return DocValuesType.SORTED_SET;
            }
            case 5: {
                return DocValuesType.SORTED_NUMERIC;
            }
        }
        throw new CorruptIndexException("invalid docvalues byte: " + b, (DataInput)input);
    }

    private static DimensionDataType getDimensionDataType(IndexInput input, byte b) throws IOException {
        switch (b) {
            case 0: {
                return DimensionDataType.LONG;
            }
            case 1: {
                return DimensionDataType.UNSIGNED_LONG;
            }
        }
        throw new CorruptIndexException("invalid dimensionDataType byte: " + b, (DataInput)input);
    }
}

