/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.commons.alerting.model.ClusterMetricsInput;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.Input;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.SearchInput;
import org.opensearch.transport.client.Client;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/opensearch/alerting/util/CrossClusterMonitorUtils;", "", "()V", "Companion", "opensearch-alerting"})
public final class CrossClusterMonitorUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final boolean isRemoteMonitor(@NotNull Monitor monitor, @NotNull String localClusterName) {
        return Companion.isRemoteMonitor(monitor, localClusterName);
    }

    @JvmStatic
    public static final boolean isRemoteMonitor(@NotNull Monitor monitor, @NotNull ClusterService clusterService) {
        return Companion.isRemoteMonitor(monitor, clusterService);
    }

    @JvmStatic
    @NotNull
    public static final HashMap<String, List<String>> separateClusterIndexes(@NotNull List<String> indexes, @NotNull String localClusterName) {
        return Companion.separateClusterIndexes(indexes, localClusterName);
    }

    @JvmStatic
    @NotNull
    public static final HashMap<String, List<String>> separateClusterIndexes(@NotNull List<String> indexes, @NotNull ClusterService clusterService) {
        return Companion.separateClusterIndexes(indexes, clusterService);
    }

    @JvmStatic
    @NotNull
    public static final List<String> parseIndexesForRemoteSearch(@NotNull List<String> indexes, @NotNull String localClusterName) {
        return Companion.parseIndexesForRemoteSearch(indexes, localClusterName);
    }

    @JvmStatic
    @NotNull
    public static final List<String> parseIndexesForRemoteSearch(@NotNull List<String> indexes, @NotNull ClusterService clusterService) {
        return Companion.parseIndexesForRemoteSearch(indexes, clusterService);
    }

    @JvmStatic
    @NotNull
    public static final Client getClientForCluster(@NotNull String clusterName, @NotNull Client client, @NotNull String localClusterName) {
        return Companion.getClientForCluster(clusterName, client, localClusterName);
    }

    @JvmStatic
    @NotNull
    public static final Client getClientForCluster(@NotNull String clusterName, @NotNull Client client, @NotNull ClusterService clusterService) {
        return Companion.getClientForCluster(clusterName, client, clusterService);
    }

    @JvmStatic
    @NotNull
    public static final Client getClientForIndex(@NotNull String index, @NotNull Client client, @NotNull String localClusterName) {
        return Companion.getClientForIndex(index, client, localClusterName);
    }

    @JvmStatic
    @NotNull
    public static final Client getClientForIndex(@NotNull String index, @NotNull Client client, @NotNull ClusterService clusterService) {
        return Companion.getClientForIndex(index, client, clusterService);
    }

    @JvmStatic
    @NotNull
    public static final String parseClusterName(@NotNull String index) {
        return Companion.parseClusterName(index);
    }

    @JvmStatic
    @NotNull
    public static final String parseIndexName(@NotNull String index) {
        return Companion.parseIndexName(index);
    }

    @JvmStatic
    @NotNull
    public static final String formatClusterAndIndexName(@NotNull String clusterName, @NotNull String indexName) {
        return Companion.formatClusterAndIndexName(clusterName, indexName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0007J \u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004H\u0007J \u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004H\u0007J \u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0004H\u0007J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\n\u001a\u00020\u0004H\u0007J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0007JF\u0010\u0019\u001a*\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001b0\u001aj\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001b`\u001c2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\n\u001a\u00020\u0004H\u0007JF\u0010\u0019\u001a*\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001b0\u001aj\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001b`\u001c2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/alerting/util/CrossClusterMonitorUtils$Companion;", "", "()V", "formatClusterAndIndexName", "", "clusterName", "indexName", "getClientForCluster", "Lorg/opensearch/transport/client/Client;", "client", "localClusterName", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "getClientForIndex", "index", "isRemoteClusterIndex", "", "isRemoteMonitor", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "parseClusterName", "parseIndexName", "parseIndexesForRemoteSearch", "", "indexes", "separateClusterIndexes", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "opensearch-alerting"})
    @SourceDebugExtension(value={"SMAP\nCrossClusterMonitorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrossClusterMonitorUtils.kt\norg/opensearch/alerting/util/CrossClusterMonitorUtils$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1855#2:238\n1855#2,2:239\n1855#2,2:241\n1856#2:243\n1855#2:244\n1856#2:252\n1549#2:253\n1620#2,3:254\n372#3,7:245\n1#4:257\n*S KotlinDebug\n*F\n+ 1 CrossClusterMonitorUtils.kt\norg/opensearch/alerting/util/CrossClusterMonitorUtils$Companion\n*L\n29#1:238\n32#1:239,2\n42#1:241,2\n29#1:243\n82#1:244\n82#1:252\n117#1:253\n117#1:254,3\n89#1:245,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isRemoteMonitor(@NotNull Monitor monitor, @NotNull String localClusterName) {
            Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
            Intrinsics.checkNotNullParameter((Object)localClusterName, (String)"localClusterName");
            boolean isRemoteMonitor = false;
            Iterable $this$forEach$iv = monitor.getInputs();
            boolean $i$f$forEach = false;
            block0: for (Object element$iv : $this$forEach$iv) {
                boolean $i$f$forEach2;
                Iterable $this$forEach$iv2;
                Input it = (Input)element$iv;
                boolean bl = false;
                Input input = it;
                if (input instanceof ClusterMetricsInput) {
                    $this$forEach$iv2 = ((ClusterMetricsInput)it).getClusters();
                    $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        String clusterName = (String)element$iv2;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)clusterName, (Object)localClusterName)) continue;
                        isRemoteMonitor = true;
                        continue block0;
                    }
                    continue;
                }
                if (input instanceof SearchInput) {
                    $this$forEach$iv2 = ((SearchInput)it).getIndices();
                    $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        String index = (String)element$iv2;
                        boolean bl3 = false;
                        String clusterName = Companion.parseClusterName(index);
                        if (Intrinsics.areEqual((Object)clusterName, (Object)localClusterName)) continue;
                        isRemoteMonitor = true;
                        continue block0;
                    }
                    continue;
                }
                if (input instanceof DocLevelMonitorInput) {
                    throw new IllegalArgumentException("Per document monitors do not currently support cross-cluster search.");
                }
                throw new IllegalArgumentException("Unsupported input type: " + it.name() + ".");
            }
            return isRemoteMonitor;
        }

        @JvmStatic
        public final boolean isRemoteMonitor(@NotNull Monitor monitor, @NotNull ClusterService clusterService) {
            Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
            Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
            String string = clusterService.getClusterName().value();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value(...)");
            return this.isRemoteMonitor(monitor, string);
        }

        @JvmStatic
        @NotNull
        public final HashMap<String, List<String>> separateClusterIndexes(@NotNull List<String> indexes, @NotNull String localClusterName) {
            Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
            Intrinsics.checkNotNullParameter((Object)localClusterName, (String)"localClusterName");
            HashMap<String, List<String>> output = new HashMap<String, List<String>>();
            Iterable $this$forEach$iv = indexes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                String index = (String)element$iv;
                boolean bl = false;
                String clusterName = Companion.parseClusterName(index);
                String indexName = Companion.parseIndexName(index);
                if (((CharSequence)clusterName).length() == 0) {
                    clusterName = localClusterName;
                }
                Map $this$getOrPut$iv = output;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(clusterName);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(clusterName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(indexName);
            }
            return output;
        }

        @JvmStatic
        @NotNull
        public final HashMap<String, List<String>> separateClusterIndexes(@NotNull List<String> indexes, @NotNull ClusterService clusterService) {
            Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
            Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
            String string = clusterService.getClusterName().value();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value(...)");
            return this.separateClusterIndexes(indexes, string);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<String> parseIndexesForRemoteSearch(@NotNull List<String> indexes, @NotNull String localClusterName) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
            Intrinsics.checkNotNullParameter((Object)localClusterName, (String)"localClusterName");
            Iterable $this$map$iv = indexes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String index = it;
                String clusterName = Companion.parseClusterName((String)it);
                if (((CharSequence)clusterName).length() > 0 && Intrinsics.areEqual((Object)clusterName, (Object)localClusterName)) {
                    index = Companion.parseIndexName((String)it);
                }
                collection.add(index);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @NotNull
        public final List<String> parseIndexesForRemoteSearch(@NotNull List<String> indexes, @NotNull ClusterService clusterService) {
            Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
            Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
            String string = clusterService.getClusterName().value();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value(...)");
            return this.parseIndexesForRemoteSearch(indexes, string);
        }

        @JvmStatic
        @NotNull
        public final Client getClientForCluster(@NotNull String clusterName, @NotNull Client client, @NotNull String localClusterName) {
            Client client2;
            Intrinsics.checkNotNullParameter((Object)clusterName, (String)"clusterName");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)localClusterName, (String)"localClusterName");
            if (Intrinsics.areEqual((Object)clusterName, (Object)localClusterName)) {
                client2 = client;
            } else {
                Client client3 = client.getRemoteClusterClient(clusterName);
                client2 = client3;
                Intrinsics.checkNotNullExpressionValue((Object)client3, (String)"getRemoteClusterClient(...)");
            }
            return client2;
        }

        @JvmStatic
        @NotNull
        public final Client getClientForCluster(@NotNull String clusterName, @NotNull Client client, @NotNull ClusterService clusterService) {
            Intrinsics.checkNotNullParameter((Object)clusterName, (String)"clusterName");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
            String string = clusterService.getClusterName().value();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value(...)");
            return this.getClientForCluster(clusterName, client, string);
        }

        @JvmStatic
        @NotNull
        public final Client getClientForIndex(@NotNull String index, @NotNull Client client, @NotNull String localClusterName) {
            Client client2;
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)localClusterName, (String)"localClusterName");
            String clusterName = this.parseClusterName(index);
            if (((CharSequence)clusterName).length() > 0 && !Intrinsics.areEqual((Object)clusterName, (Object)localClusterName)) {
                Client client3 = client.getRemoteClusterClient(clusterName);
                client2 = client3;
                Intrinsics.checkNotNullExpressionValue((Object)client3, (String)"getRemoteClusterClient(...)");
            } else {
                client2 = client;
            }
            return client2;
        }

        @JvmStatic
        @NotNull
        public final Client getClientForIndex(@NotNull String index, @NotNull Client client, @NotNull ClusterService clusterService) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
            String string = clusterService.getClusterName().value();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value(...)");
            return this.getClientForIndex(index, client, string);
        }

        @JvmStatic
        @NotNull
        public final String parseClusterName(@NotNull String index) {
            String string;
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            if (StringsKt.contains$default((CharSequence)index, (CharSequence)":", (boolean)false, (int)2, null)) {
                Object object;
                Object object2 = new String[]{":"};
                int n = 0;
                if (n <= CollectionsKt.getLastIndex((List)(object2 = StringsKt.split$default((CharSequence)index, (String[])object2, (boolean)false, (int)0, (int)6, null)))) {
                    object = object2.get(n);
                } else {
                    int it = n;
                    boolean bl = false;
                    object = "";
                }
                string = (String)object;
            } else {
                string = "";
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final String parseIndexName(@NotNull String index) {
            String string;
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            if (StringsKt.contains$default((CharSequence)index, (CharSequence)":", (boolean)false, (int)2, null)) {
                Object object;
                Object object2 = new String[]{":"};
                int n = 1;
                if (n <= CollectionsKt.getLastIndex((List)(object2 = StringsKt.split$default((CharSequence)index, (String[])object2, (boolean)false, (int)0, (int)6, null)))) {
                    object = object2.get(n);
                } else {
                    int it = n;
                    boolean bl = false;
                    object = index;
                }
                string = (String)object;
            } else {
                string = index;
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final String formatClusterAndIndexName(@NotNull String clusterName, @NotNull String indexName) {
            Intrinsics.checkNotNullParameter((Object)clusterName, (String)"clusterName");
            Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
            return ((CharSequence)clusterName).length() > 0 ? clusterName + ":" + indexName : indexName;
        }

        public final boolean isRemoteClusterIndex(@NotNull String index, @NotNull ClusterService clusterService) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
            String clusterName = this.parseClusterName(index);
            return ((CharSequence)clusterName).length() > 0 && !Intrinsics.areEqual((Object)clusterService.getClusterName().value(), (Object)clusterName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

