/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.opensearch.index.analysis.Analysis;
import org.opensearch.index.analysis.KuromojiTokenizerFactory;

public class KuromojiAnalyzerProvider
extends AbstractIndexAnalyzerProvider<JapaneseAnalyzer> {
    private final JapaneseAnalyzer analyzer;

    public KuromojiAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        CharArraySet stopWords = Analysis.parseStopWords((Environment)env, (Settings)settings, (CharArraySet)JapaneseAnalyzer.getDefaultStopSet());
        JapaneseTokenizer.Mode mode = KuromojiTokenizerFactory.getMode(settings);
        UserDictionary userDictionary = KuromojiTokenizerFactory.getUserDictionary(env, settings);
        this.analyzer = new JapaneseAnalyzer(userDictionary, mode, CharArraySet.copy((Set)stopWords), JapaneseAnalyzer.getDefaultStopTags());
    }

    public JapaneseAnalyzer get() {
        return this.analyzer;
    }
}

