"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.uInt32BE = exports.uInt16BE = exports.uInt8 = void 0;
const material_management_1 = require("@aws-crypto/material-management");
const UINT8_OVERFLOW = 2 ** 8;
function uInt8(number) {
    /* Precondition: Number must be 0-(2^8 - 1). */
    (0, material_management_1.needs)(number < UINT8_OVERFLOW && number >= 0, 'number out of bounds.');
    const buff = new Uint8Array(1);
    const view = new DataView(buff.buffer, buff.byteOffset, buff.byteLength);
    view.setUint8(0, number);
    return buff;
}
exports.uInt8 = uInt8;
const UINT16__OVERFLOW = 2 ** 16;
function uInt16BE(number) {
    /* Precondition: Number must be 0-(2^16 - 1). */
    (0, material_management_1.needs)(number < UINT16__OVERFLOW && number >= 0, 'number out of bounds.');
    const buff = new Uint8Array(2);
    const view = new DataView(buff.buffer, buff.byteOffset, buff.byteLength);
    view.setUint16(0, number, false); // big-endian
    return buff;
}
exports.uInt16BE = uInt16BE;
const UINT32__OVERFLOW = 2 ** 32;
function uInt32BE(number) {
    /* Precondition: Number must be 0-(2^32 - 1). */
    (0, material_management_1.needs)(number < UINT32__OVERFLOW && number >= 0, 'number out of bounds.');
    const buff = new Uint8Array(4);
    const view = new DataView(buff.buffer, buff.byteOffset, buff.byteLength);
    view.setUint32(0, number, false); // big-endian
    return buff;
}
exports.uInt32BE = uInt32BE;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidWludF91dGlsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3VpbnRfdXRpbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQzs7O0FBRXRDLHlFQUF1RDtBQUV2RCxNQUFNLGNBQWMsR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFBO0FBQzdCLFNBQWdCLEtBQUssQ0FBQyxNQUFjO0lBQ2xDLCtDQUErQztJQUMvQyxJQUFBLDJCQUFLLEVBQUMsTUFBTSxHQUFHLGNBQWMsSUFBSSxNQUFNLElBQUksQ0FBQyxFQUFFLHVCQUF1QixDQUFDLENBQUE7SUFFdEUsTUFBTSxJQUFJLEdBQUcsSUFBSSxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUE7SUFDOUIsTUFBTSxJQUFJLEdBQUcsSUFBSSxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQTtJQUN4RSxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUMsRUFBRSxNQUFNLENBQUMsQ0FBQTtJQUN4QixPQUFPLElBQUksQ0FBQTtBQUNiLENBQUM7QUFSRCxzQkFRQztBQUVELE1BQU0sZ0JBQWdCLEdBQUcsQ0FBQyxJQUFJLEVBQUUsQ0FBQTtBQUNoQyxTQUFnQixRQUFRLENBQUMsTUFBYztJQUNyQyxnREFBZ0Q7SUFDaEQsSUFBQSwyQkFBSyxFQUFDLE1BQU0sR0FBRyxnQkFBZ0IsSUFBSSxNQUFNLElBQUksQ0FBQyxFQUFFLHVCQUF1QixDQUFDLENBQUE7SUFFeEUsTUFBTSxJQUFJLEdBQUcsSUFBSSxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUE7SUFDOUIsTUFBTSxJQUFJLEdBQUcsSUFBSSxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQTtJQUN4RSxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsRUFBRSxNQUFNLEVBQUUsS0FBSyxDQUFDLENBQUEsQ0FBQyxhQUFhO0lBQzlDLE9BQU8sSUFBSSxDQUFBO0FBQ2IsQ0FBQztBQVJELDRCQVFDO0FBRUQsTUFBTSxnQkFBZ0IsR0FBRyxDQUFDLElBQUksRUFBRSxDQUFBO0FBQ2hDLFNBQWdCLFFBQVEsQ0FBQyxNQUFjO0lBQ3JDLGdEQUFnRDtJQUNoRCxJQUFBLDJCQUFLLEVBQUMsTUFBTSxHQUFHLGdCQUFnQixJQUFJLE1BQU0sSUFBSSxDQUFDLEVBQUUsdUJBQXVCLENBQUMsQ0FBQTtJQUV4RSxNQUFNLElBQUksR0FBRyxJQUFJLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQTtJQUM5QixNQUFNLElBQUksR0FBRyxJQUFJLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFBO0lBQ3hFLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQyxFQUFFLE1BQU0sRUFBRSxLQUFLLENBQUMsQ0FBQSxDQUFDLGFBQWE7SUFDOUMsT0FBTyxJQUFJLENBQUE7QUFDYixDQUFDO0FBUkQsNEJBUUMifQ==