"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestActions = void 0;
var _base_action = require("../base_action");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class TestActions extends _base_action.BaseActions {
  increment() {
    this.updateState(state => ({
      ...state,
      counter: state.counter + 1
    }));
  }
  decrement() {
    this.updateState(state => ({
      ...state,
      counter: state.counter - 1
    }));
  }
  reset() {
    this.updateState(() => ({
      counter: 0
    }));
  }
}
exports.TestActions = TestActions;