/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.2.0/LICENSE.txt
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).maplibregl={})}(this,(function(t){"use strict";var e,i,r="5.2.0";function n(t,e,i,r){return new(i||(i=Promise))((function(n,s){function o(t){try{l(r.next(t))}catch(t){s(t)}}function a(t){try{l(r.throw(t))}catch(t){s(t)}}function l(t){var e;t.done?n(t.value):(e=t.value,e instanceof i?e:new i((function(t){t(e)}))).then(o,a)}l((r=r.apply(t,e||[])).next())}))}function s(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}function o(){if(i)return e;function t(t,e){this.x=t,this.y=e}return i=1,e=t,t.prototype={clone:function(){return new t(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,i=t.y-this.y;return e*e+i*i},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),i=Math.sin(t),r=i*this.x+e*this.y;return this.x=e*this.x-i*this.y,this.y=r,this},_rotateAround:function(t,e){var i=Math.cos(t),r=Math.sin(t),n=e.y+r*(this.x-e.x)+i*(this.y-e.y);return this.x=e.x+i*(this.x-e.x)-r*(this.y-e.y),this.y=n,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},t.convert=function(e){return e instanceof t?e:Array.isArray(e)?new t(e[0],e[1]):e},e}"function"==typeof SuppressedError&&SuppressedError;var a,l,c=s(o()),h=function(){if(l)return a;function t(t,e,i,r){this.cx=3*t,this.bx=3*(i-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(r-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=i,this.p2y=r}return l=1,a=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var i=t,r=0;r<8;r++){var n=this.sampleCurveX(i)-t;if(Math.abs(n)<e)return i;var s=this.sampleCurveDerivativeX(i);if(Math.abs(s)<1e-6)break;i-=n/s}var o=0,a=1;for(i=t,r=0;r<20&&(n=this.sampleCurveX(i),!(Math.abs(n-t)<e));r++)t>n?o=i:a=i,i=.5*(a-o)+o;return i},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},a}(),u=s(h);let p,d;function f(){return null==p&&(p="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),p}var m=1e-6,_="undefined"!=typeof Float32Array?Float32Array:Array;function g(){var t=new _(4);return _!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t}function y(){var t=new _(9);return _!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function x(){var t=new _(16);return _!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t}function v(t){var e=new _(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e}function b(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function w(t,e){var i=e[0],r=e[1],n=e[2],s=e[3],o=e[4],a=e[5],l=e[6],c=e[7],h=e[8],u=e[9],p=e[10],d=e[11],f=e[12],m=e[13],_=e[14],g=e[15],y=i*a-r*o,x=i*l-n*o,v=i*c-s*o,b=r*l-n*a,w=r*c-s*a,T=n*c-s*l,P=h*m-u*f,M=h*_-p*f,C=h*g-d*f,I=u*_-p*m,S=u*g-d*m,E=p*g-d*_,A=y*E-x*S+v*I+b*C-w*M+T*P;return A?(t[0]=(a*E-l*S+c*I)*(A=1/A),t[1]=(n*S-r*E-s*I)*A,t[2]=(m*T-_*w+g*b)*A,t[3]=(p*w-u*T-d*b)*A,t[4]=(l*C-o*E-c*M)*A,t[5]=(i*E-n*C+s*M)*A,t[6]=(_*v-f*T-g*x)*A,t[7]=(h*T-p*v+d*x)*A,t[8]=(o*S-a*C+c*P)*A,t[9]=(r*C-i*S-s*P)*A,t[10]=(f*w-m*v+g*y)*A,t[11]=(u*v-h*w-d*y)*A,t[12]=(a*M-o*I-l*P)*A,t[13]=(i*I-r*M+n*P)*A,t[14]=(m*x-f*b-_*y)*A,t[15]=(h*b-u*x+p*y)*A,t):null}function T(t,e,i){var r=e[0],n=e[1],s=e[2],o=e[3],a=e[4],l=e[5],c=e[6],h=e[7],u=e[8],p=e[9],d=e[10],f=e[11],m=e[12],_=e[13],g=e[14],y=e[15],x=i[0],v=i[1],b=i[2],w=i[3];return t[0]=x*r+v*a+b*u+w*m,t[1]=x*n+v*l+b*p+w*_,t[2]=x*s+v*c+b*d+w*g,t[3]=x*o+v*h+b*f+w*y,t[4]=(x=i[4])*r+(v=i[5])*a+(b=i[6])*u+(w=i[7])*m,t[5]=x*n+v*l+b*p+w*_,t[6]=x*s+v*c+b*d+w*g,t[7]=x*o+v*h+b*f+w*y,t[8]=(x=i[8])*r+(v=i[9])*a+(b=i[10])*u+(w=i[11])*m,t[9]=x*n+v*l+b*p+w*_,t[10]=x*s+v*c+b*d+w*g,t[11]=x*o+v*h+b*f+w*y,t[12]=(x=i[12])*r+(v=i[13])*a+(b=i[14])*u+(w=i[15])*m,t[13]=x*n+v*l+b*p+w*_,t[14]=x*s+v*c+b*d+w*g,t[15]=x*o+v*h+b*f+w*y,t}function P(t,e,i){var r,n,s,o,a,l,c,h,u,p,d,f,m=i[0],_=i[1],g=i[2];return e===t?(t[12]=e[0]*m+e[4]*_+e[8]*g+e[12],t[13]=e[1]*m+e[5]*_+e[9]*g+e[13],t[14]=e[2]*m+e[6]*_+e[10]*g+e[14],t[15]=e[3]*m+e[7]*_+e[11]*g+e[15]):(n=e[1],s=e[2],o=e[3],a=e[4],l=e[5],c=e[6],h=e[7],u=e[8],p=e[9],d=e[10],f=e[11],t[0]=r=e[0],t[1]=n,t[2]=s,t[3]=o,t[4]=a,t[5]=l,t[6]=c,t[7]=h,t[8]=u,t[9]=p,t[10]=d,t[11]=f,t[12]=r*m+a*_+u*g+e[12],t[13]=n*m+l*_+p*g+e[13],t[14]=s*m+c*_+d*g+e[14],t[15]=o*m+h*_+f*g+e[15]),t}function M(t,e,i){var r=i[0],n=i[1],s=i[2];return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t[4]=e[4]*n,t[5]=e[5]*n,t[6]=e[6]*n,t[7]=e[7]*n,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t}function C(t,e,i){var r=Math.sin(i),n=Math.cos(i),s=e[4],o=e[5],a=e[6],l=e[7],c=e[8],h=e[9],u=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*n+c*r,t[5]=o*n+h*r,t[6]=a*n+u*r,t[7]=l*n+p*r,t[8]=c*n-s*r,t[9]=h*n-o*r,t[10]=u*n-a*r,t[11]=p*n-l*r,t}function I(t,e,i){var r=Math.sin(i),n=Math.cos(i),s=e[0],o=e[1],a=e[2],l=e[3],c=e[8],h=e[9],u=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*n-c*r,t[1]=o*n-h*r,t[2]=a*n-u*r,t[3]=l*n-p*r,t[8]=s*r+c*n,t[9]=o*r+h*n,t[10]=a*r+u*n,t[11]=l*r+p*n,t}function S(t,e,i){var r=Math.sin(i),n=Math.cos(i),s=e[0],o=e[1],a=e[2],l=e[3],c=e[4],h=e[5],u=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*n+c*r,t[1]=o*n+h*r,t[2]=a*n+u*r,t[3]=l*n+p*r,t[4]=c*n-s*r,t[5]=h*n-o*r,t[6]=u*n-a*r,t[7]=p*n-l*r,t}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var E=function(t,e,i,r,n){var s,o=1/Math.tan(e/2);return t[0]=o/i,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=o,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=n&&n!==1/0?(t[10]=(n+r)*(s=1/(r-n)),t[14]=2*n*r*s):(t[10]=-1,t[14]=-2*r),t},A=function(t,e,i,r,n,s,o){var a=1/(e-i),l=1/(r-n),c=1/(s-o);return t[0]=-2*a,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*c,t[11]=0,t[12]=(e+i)*a,t[13]=(n+r)*l,t[14]=(o+s)*c,t[15]=1,t};function z(){var t=new _(3);return _!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function k(t){var e=new _(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e}function D(t,e,i){var r=new _(3);return r[0]=t,r[1]=e,r[2]=i,r}function R(t,e,i){return t[0]=e[0]+i[0],t[1]=e[1]+i[1],t[2]=e[2]+i[2],t}function L(t,e,i){return t[0]=e[0]*i,t[1]=e[1]*i,t[2]=e[2]*i,t}function B(t,e){var i=e[0],r=e[1],n=e[2],s=i*i+r*r+n*n;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t}function F(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function O(t,e,i){var r=e[0],n=e[1],s=e[2],o=i[0],a=i[1],l=i[2];return t[0]=n*l-s*a,t[1]=s*o-r*l,t[2]=r*a-n*o,t}function j(t,e,i,r){var n=[],s=[];return n[0]=e[0]-i[0],n[1]=e[1]-i[1],n[2]=e[2]-i[2],s[0]=n[0],s[1]=n[1]*Math.cos(r)-n[2]*Math.sin(r),s[2]=n[1]*Math.sin(r)+n[2]*Math.cos(r),t[0]=s[0]+i[0],t[1]=s[1]+i[1],t[2]=s[2]+i[2],t}function V(t,e,i,r){var n=[],s=[];return n[0]=e[0]-i[0],n[1]=e[1]-i[1],n[2]=e[2]-i[2],s[0]=n[2]*Math.sin(r)+n[0]*Math.cos(r),s[1]=n[1],s[2]=n[2]*Math.cos(r)-n[0]*Math.sin(r),t[0]=s[0]+i[0],t[1]=s[1]+i[1],t[2]=s[2]+i[2],t}function N(t,e,i,r){var n=[],s=[];return n[0]=e[0]-i[0],n[1]=e[1]-i[1],n[2]=e[2]-i[2],s[0]=n[0]*Math.cos(r)-n[1]*Math.sin(r),s[1]=n[0]*Math.sin(r)+n[1]*Math.cos(r),s[2]=n[2],t[0]=s[0]+i[0],t[1]=s[1]+i[1],t[2]=s[2]+i[2],t}var U,Z=function(t,e,i){return t[0]=e[0]-i[0],t[1]=e[1]-i[1],t[2]=e[2]-i[2],t};function G(t,e,i){var r=e[0],n=e[1],s=e[2],o=e[3];return t[0]=i[0]*r+i[4]*n+i[8]*s+i[12]*o,t[1]=i[1]*r+i[5]*n+i[9]*s+i[13]*o,t[2]=i[2]*r+i[6]*n+i[10]*s+i[14]*o,t[3]=i[3]*r+i[7]*n+i[11]*s+i[15]*o,t}function $(){var t=new _(4);return _!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function q(){var t=new _(2);return _!=Float32Array&&(t[0]=0,t[1]=0),t}function W(t,e){var i=new _(2);return i[0]=t,i[1]=e,i}function H(t,e,i){return t[0]=e[0]*i,t[1]=e[1]*i,t}function X(t){return Math.hypot(t[0],t[1])}function K(t){return t[0]=0,t[1]=0,t}z(),U=new _(4),_!=Float32Array&&(U[0]=0,U[1]=0,U[2]=0,U[3]=0),z(),D(1,0,0),D(0,1,0),$(),$(),y();var Y=function(t){var e=t[0],i=t[1];return e*e+i*i};q();const J=8192;function Q(t,e,i){return e*(J/(t.tileSize*Math.pow(2,i-t.tileID.overscaledZ)))}function tt(){return new Float64Array(4)}function et(){return new Float64Array(3)}function it(){return new Float64Array(16)}function rt(){const t=new Float64Array(16);return b(t),t}function nt(){const t=new Float32Array(16);return b(t),t}function st(t,e,i,r,n=!1){if(!i[0]&&!i[1])return[0,0];const s=n?"map"===r?-t.bearingInRadians:0:"viewport"===r?t.bearingInRadians:0;if(s){const t=Math.sin(s),e=Math.cos(s);i=[i[0]*e-i[1]*t,i[0]*t+i[1]*e]}return[n?i[0]:Q(e,i[0],t.zoom),n?i[1]:Q(e,i[1],t.zoom)]}function ot(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]}function at(t,e,i,r){const n=Math.sqrt(t*t+e*e),s=Math.sqrt(i*i+r*r);t/=n,e/=n,i/=s,r/=s;const o=Math.acos(t*i+e*r);return-e*i+t*r>0?o:-o}function lt(t,e){const i=ht(t,360),r=ht(e,360),n=r-i,s=r>i?n-360:n+360;return Math.abs(n)<Math.abs(s)?n:s}function ct(t,e){const i=ht(t,2*Math.PI),r=ht(e,2*Math.PI);return Math.min(Math.abs(i-r),Math.abs(i-r+2*Math.PI),Math.abs(i-r-2*Math.PI))}function ht(t,e){return(t%e+e)%e}function ut(t,e,i,r,n){return pt(r,n,gt((t-e)/(i-e),0,1))}function pt(t,e,i){return t*(1-i)+e*i}function dt(t){let e=1/0,i=1/0,r=-1/0,n=-1/0;for(const s of t)e=Math.min(e,s.x),i=Math.min(i,s.y),r=Math.max(r,s.x),n=Math.max(n,s.y);return[e,i,r,n]}function ft(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,i=e*t;return 4*(t<.5?i:3*(t-e)+i-.75)}function mt(t,e,i,r){const n=new u(t,e,i,r);return t=>n.solve(t)}const _t=mt(.25,.1,.25,1);function gt(t,e,i){return Math.min(i,Math.max(e,t))}function yt(t,e,i){const r=i-e,n=((t-e)%r+r)%r+e;return n===e?i:n}function xt(t,...e){for(const i of e)for(const e in i)t[e]=i[e];return t}function vt(t,e){const i={};for(let r=0;r<e.length;r++){const n=e[r];n in t&&(i[n]=t[n])}return i}let bt=1;function wt(){return bt++}function Tt(t){return Math.pow(2,t)}function Pt(t){return Math.log(t)/Math.LN2}function Mt(t,e,i){const r={};for(const i in t)r[i]=e.call(this,t[i],i,t);return r}function Ct(t,e,i){const r={};for(const i in t)e.call(this,t[i],i,t)&&(r[i]=t[i]);return r}function It(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return!1;for(let i=0;i<t.length;i++)if(!It(t[i],e[i]))return!1;return!0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return!1;if(Object.keys(t).length!==Object.keys(e).length)return!1;for(const i in t)if(!It(t[i],e[i]))return!1;return!0}return t===e}function St(t){return Array.isArray(t)?t.map(St):"object"==typeof t&&t?Mt(t,St):t}const Et={};function At(t){Et[t]||("undefined"!=typeof console&&console.warn(t),Et[t]=!0)}function zt(t,e,i){return(i.y-t.y)*(e.x-t.x)>(e.y-t.y)*(i.x-t.x)}function kt(t){return"undefined"!=typeof WorkerGlobalScope&&void 0!==t&&t instanceof WorkerGlobalScope}let Dt=null;function Rt(t){return"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap}const Lt="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";function Bt(t,e,i,r){return t.addEventListener(e,i,r),{unsubscribe:()=>{t.removeEventListener(e,i,r)}}}function Ft(t){return t*Math.PI/180}function Ot(t){return t/Math.PI*180}function jt(t,e){return t.roll==e.roll&&t.pitch==e.pitch&&t.bearing==e.bearing}function Vt(t,e,i){const r=W(e.x-i.x,e.y-i.y),n=W(t.x-i.x,t.y-i.y);var s,o;return Ot(Math.atan2(r[0]*n[1]-r[1]*n[0],(s=r)[0]*(o=n)[0]+s[1]*o[1]))}function Nt(t,e,i){const r=new Float64Array(4);return function(t,e,i,r){var n=.5*Math.PI/180;e*=n,i*=n,r*=n;var s=Math.sin(e),o=Math.cos(e),a=Math.sin(i),l=Math.cos(i),c=Math.sin(r),h=Math.cos(r);t[0]=s*l*h-o*a*c,t[1]=o*a*h+s*l*c,t[2]=o*l*c-s*a*h,t[3]=o*l*h+s*a*c}(r,t,e-90,i),r}const Ut=85.051129,Zt="AbortError";function Gt(){return new Error(Zt)}let $t,qt;const Wt={now:"undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),frame(t,e,i){const r=requestAnimationFrame((t=>{n(),e(t)})),{unsubscribe:n}=Bt(t.signal,"abort",(()=>{n(),cancelAnimationFrame(r),i(Gt())}),!1)},frameAsync(t){return new Promise(((e,i)=>{this.frame(t,e,i)}))},getImageData(t,e=0){return this.getImageCanvasContext(t).getImageData(-e,-e,t.width+2*e,t.height+2*e)},getImageCanvasContext(t){const e=window.document.createElement("canvas"),i=e.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return e.width=t.width,e.height=t.height,i.drawImage(t,0,0,t.width,t.height),i},resolveURL:t=>($t||($t=document.createElement("a")),$t.href=t,$t.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return!!matchMedia&&(null==qt&&(qt=matchMedia("(prefers-reduced-motion: reduce)")),qt.matches)}};class Ht{static testProp(t){if(!Ht.docStyle)return t[0];for(let e=0;e<t.length;e++)if(t[e]in Ht.docStyle)return t[e];return t[0]}static create(t,e,i){const r=window.document.createElement(t);return void 0!==e&&(r.className=e),i&&i.appendChild(r),r}static createNS(t,e){return window.document.createElementNS(t,e)}static disableDrag(){Ht.docStyle&&Ht.selectProp&&(Ht.userSelect=Ht.docStyle[Ht.selectProp],Ht.docStyle[Ht.selectProp]="none")}static enableDrag(){Ht.docStyle&&Ht.selectProp&&(Ht.docStyle[Ht.selectProp]=Ht.userSelect)}static setTransform(t,e){t.style[Ht.transformProp]=e}static addEventListener(t,e,i,r={}){t.addEventListener(e,i,"passive"in r?r:r.capture)}static removeEventListener(t,e,i,r={}){t.removeEventListener(e,i,"passive"in r?r:r.capture)}static suppressClickInternal(t){t.preventDefault(),t.stopPropagation(),window.removeEventListener("click",Ht.suppressClickInternal,!0)}static suppressClick(){window.addEventListener("click",Ht.suppressClickInternal,!0),window.setTimeout((()=>{window.removeEventListener("click",Ht.suppressClickInternal,!0)}),0)}static getScale(t){const e=t.getBoundingClientRect();return{x:e.width/t.offsetWidth||1,y:e.height/t.offsetHeight||1,boundingClientRect:e}}static getPoint(t,e,i){const r=e.boundingClientRect;return new c((i.clientX-r.left)/e.x-t.clientLeft,(i.clientY-r.top)/e.y-t.clientTop)}static mousePos(t,e){const i=Ht.getScale(t);return Ht.getPoint(t,i,e)}static touchPos(t,e){const i=[],r=Ht.getScale(t);for(let n=0;n<e.length;n++)i.push(Ht.getPoint(t,r,e[n]));return i}static mouseButton(t){return t.button}static remove(t){t.parentNode&&t.parentNode.removeChild(t)}static sanitize(t){const e=(new DOMParser).parseFromString(t,"text/html").body||document.createElement("body"),i=e.querySelectorAll("script");for(const t of i)t.remove();return Ht.clean(e),e.innerHTML}static isPossiblyDangerous(t,e){const i=e.replace(/\s+/g,"").toLowerCase();return!(!["src","href","xlink:href"].includes(t)||!i.includes("javascript:")&&!i.includes("data:"))||!!t.startsWith("on")||void 0}static clean(t){const e=t.children;for(const t of e)Ht.removeAttributes(t),Ht.clean(t)}static removeAttributes(t){for(const{name:e,value:i}of t.attributes)Ht.isPossiblyDangerous(e,i)&&t.removeAttribute(e)}}Ht.docStyle="undefined"!=typeof window&&window.document&&window.document.documentElement.style,Ht.selectProp=Ht.testProp(["userSelect","MozUserSelect","WebkitUserSelect","msUserSelect"]),Ht.transformProp=Ht.testProp(["transform","WebkitTransform"]);const Xt={MAX_PARALLEL_IMAGE_REQUESTS:16,MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:8,MAX_TILE_CACHE_ZOOM_LEVELS:5,REGISTERED_PROTOCOLS:{},WORKER_URL:""};function Kt(t){return Xt.REGISTERED_PROTOCOLS[t.substring(0,t.indexOf("://"))]}const Yt="global-dispatcher";class Jt extends Error{constructor(t,e,i,r){super(`AJAXError: ${e} (${t}): ${i}`),this.status=t,this.statusText=e,this.url=i,this.body=r}}const Qt=()=>kt(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,te=function(t,e){if(/:\/\//.test(t.url)&&!/^https?:|^file:/.test(t.url)){const i=Kt(t.url);if(i)return i(t,e);if(kt(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,targetMapId:Yt},e)}if(!(/^file:/.test(i=t.url)||/^file:/.test(Qt())&&!/^\w+:/.test(i))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(t,e){return n(this,void 0,void 0,(function*(){const i=new Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,cache:t.cache,referrer:Qt(),signal:e.signal});let r,n;"json"!==t.type||i.headers.has("Accept")||i.headers.set("Accept","application/json");try{r=yield fetch(i)}catch(e){throw new Jt(0,e.message,t.url,new Blob)}if(!r.ok){const e=yield r.blob();throw new Jt(r.status,r.statusText,t.url,e)}n="arrayBuffer"===t.type||"image"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text();const s=yield n;if(e.signal.aborted)throw Gt();return{data:s,cacheControl:r.headers.get("Cache-Control"),expires:r.headers.get("Expires")}}))}(t,e);if(kt(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:t,mustQueue:!0,targetMapId:Yt},e)}var i;return function(t,e){return new Promise(((i,r)=>{var n;const s=new XMLHttpRequest;s.open(t.method||"GET",t.url,!0),"arrayBuffer"!==t.type&&"image"!==t.type||(s.responseType="arraybuffer");for(const e in t.headers)s.setRequestHeader(e,t.headers[e]);"json"===t.type&&(s.responseType="text",(null===(n=t.headers)||void 0===n?void 0:n.Accept)||s.setRequestHeader("Accept","application/json")),s.withCredentials="include"===t.credentials,s.onerror=()=>{r(new Error(s.statusText))},s.onload=()=>{if(!e.signal.aborted)if((s.status>=200&&s.status<300||0===s.status)&&null!==s.response){let e=s.response;if("json"===t.type)try{e=JSON.parse(s.response)}catch(t){return void r(t)}i({data:e,cacheControl:s.getResponseHeader("Cache-Control"),expires:s.getResponseHeader("Expires")})}else{const e=new Blob([s.response],{type:s.getResponseHeader("Content-Type")});r(new Jt(s.status,s.statusText,t.url,e))}},e.signal.addEventListener("abort",(()=>{s.abort(),r(Gt())})),s.send(t.body)}))}(t,e)},ee=(t,e)=>te(xt(t,{type:"json"}),e);function ie(t){if(!t||t.indexOf("://")<=0||0===t.indexOf("data:image/")||0===t.indexOf("blob:"))return!0;const e=new URL(t),i=window.location;return e.protocol===i.protocol&&e.host===i.host}const re={supported:!1,testSupport:function(t){!oe&&se&&(ae?le(t):ne=t)}};let ne,se,oe=!1,ae=!1;function le(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,se),t.isContextLost())return;re.supported=!0}catch(t){}t.deleteTexture(e),oe=!0}var ce;"undefined"!=typeof document&&(se=document.createElement("img"),se.onload=()=>{ne&&le(ne),ne=null,ae=!0},se.onerror=()=>{oe=!0,ne=null},se.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA="),function(t){let e,i,r,s;t.resetRequestQueue=()=>{e=[],i=0,r=0,s={}},t.addThrottleControl=t=>{const e=r++;return s[e]=t,e},t.removeThrottleControl=t=>{delete s[t],a()},t.getImage=(t,i,r=!0)=>new Promise(((n,s)=>{re.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),xt(t,{type:"image"});const o={abortController:i,requestParameters:t,supportImageRefresh:r,state:"queued",onError:t=>{s(t)},onSuccess:t=>{n(t)}};e.push(o),a()}));const o=t=>n(this,void 0,void 0,(function*(){t.state="running";const{requestParameters:e,supportImageRefresh:r,onError:s,onSuccess:o,abortController:c}=t,h=!1===r&&!kt(self)&&!Kt(e.url)&&(!e.headers||Object.keys(e.headers).reduce(((t,e)=>t&&"accept"===e),!0));i++;const u=h?l(e,c):te(e,c);try{const e=yield u;delete t.abortController,t.state="completed",e.data instanceof HTMLImageElement||Rt(e.data)?o(e):e.data&&o({data:yield(p=e.data,"function"==typeof createImageBitmap?(t=>n(void 0,void 0,void 0,(function*(){if(0===t.byteLength)return createImageBitmap(new ImageData(1,1));const e=new Blob([new Uint8Array(t)],{type:"image/png"});try{return createImageBitmap(e)}catch(t){throw new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`)}})))(p):(t=>new Promise(((e,i)=>{const r=new Image;r.onload=()=>{e(r),URL.revokeObjectURL(r.src),r.onload=null,window.requestAnimationFrame((()=>{r.src=Lt}))},r.onerror=()=>i(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const n=new Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?URL.createObjectURL(n):Lt})))(p)),cacheControl:e.cacheControl,expires:e.expires})}catch(e){delete t.abortController,s(e)}finally{i--,a()}var p})),a=()=>{const t=(()=>{for(const t of Object.keys(s))if(s[t]())return!0;return!1})()?Xt.MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:Xt.MAX_PARALLEL_IMAGE_REQUESTS;for(let r=i;r<t&&e.length>0;r++){const t=e.shift();t.abortController.signal.aborted?r--:o(t)}},l=(t,e)=>new Promise(((i,r)=>{const n=new Image,s=t.url,o=t.credentials;o&&"include"===o?n.crossOrigin="use-credentials":(o&&"same-origin"===o||!ie(s))&&(n.crossOrigin="anonymous"),e.signal.addEventListener("abort",(()=>{n.src="",r(Gt())})),n.fetchPriority="high",n.onload=()=>{n.onerror=n.onload=null,i({data:n})},n.onerror=()=>{n.onerror=n.onload=null,e.signal.aborted||r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."))},n.src=s}))}(ce||(ce={})),ce.resetRequestQueue();class he{constructor(t){this._transformRequestFn=t}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}setTransformRequest(t){this._transformRequestFn=t}}function ue(t,e,i){i[t]&&-1!==i[t].indexOf(e)||(i[t]=i[t]||[],i[t].push(e))}function pe(t,e,i){if(i&&i[t]){const r=i[t].indexOf(e);-1!==r&&i[t].splice(r,1)}}class de{constructor(t,e={}){xt(this,e),this.type=t}}class fe extends de{constructor(t,e={}){super("error",xt({error:t},e))}}class me{on(t,e){return this._listeners=this._listeners||{},ue(t,e,this._listeners),{unsubscribe:()=>{this.off(t,e)}}}off(t,e){return pe(t,e,this._listeners),pe(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},ue(t,e,this._oneTimeListeners),this):new Promise((e=>this.once(t,e)))}fire(t,e){"string"==typeof t&&(t=new de(t,e||{}));const i=t.type;if(this.listens(i)){t.target=this;const e=this._listeners&&this._listeners[i]?this._listeners[i].slice():[];for(const i of e)i.call(this,t);const r=this._oneTimeListeners&&this._oneTimeListeners[i]?this._oneTimeListeners[i].slice():[];for(const e of r)pe(i,e,this._oneTimeListeners),e.call(this,t);const n=this._eventedParent;n&&(xt(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),n.fire(t))}else t instanceof fe&&console.error(t.error);return this}listens(t){return this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t)}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var _e={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"number",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"color",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const ge=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function ye(t,e){const i={};for(const e in t)"ref"!==e&&(i[e]=t[e]);return ge.forEach((t=>{t in e&&(i[t]=e[t])})),i}function xe(t){t=t.slice();const e=Object.create(null);for(let i=0;i<t.length;i++)e[t[i].id]=t[i];for(let i=0;i<t.length;i++)"ref"in t[i]&&(t[i]=ye(t[i],e[t[i].ref]));return t}function ve(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return!1;for(let i=0;i<t.length;i++)if(!ve(t[i],e[i]))return!1;return!0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return!1;if(Object.keys(t).length!==Object.keys(e).length)return!1;for(const i in t)if(!ve(t[i],e[i]))return!1;return!0}return t===e}function be(t,e){t.push(e)}function we(t,e,i){be(i,{command:"addSource",args:[t,e[t]]})}function Te(t,e,i){be(e,{command:"removeSource",args:[t]}),i[t]=!0}function Pe(t,e,i,r){Te(t,i,r),we(t,e,i)}function Me(t,e,i){let r;for(r in t[i])if(Object.prototype.hasOwnProperty.call(t[i],r)&&"data"!==r&&!ve(t[i][r],e[i][r]))return!1;for(r in e[i])if(Object.prototype.hasOwnProperty.call(e[i],r)&&"data"!==r&&!ve(t[i][r],e[i][r]))return!1;return!0}function Ce(t,e,i,r,n,s){t=t||{},e=e||{};for(const o in t)Object.prototype.hasOwnProperty.call(t,o)&&(ve(t[o],e[o])||i.push({command:s,args:[r,o,e[o],n]}));for(const o in e)Object.prototype.hasOwnProperty.call(e,o)&&!Object.prototype.hasOwnProperty.call(t,o)&&(ve(t[o],e[o])||i.push({command:s,args:[r,o,e[o],n]}))}function Ie(t){return t.id}function Se(t,e){return t[e.id]=e,t}class Ee{constructor(t,e,i,r){this.message=(t?`${t}: `:"")+i,r&&(this.identifier=r),null!=e&&e.__line__&&(this.line=e.__line__)}}function Ae(t,...e){for(const i of e)for(const e in i)t[e]=i[e];return t}class ze extends Error{constructor(t,e){super(e),this.message=e,this.key=t}}class ke{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,i]of e)this.bindings[t]=i}concat(t){return new ke(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return!!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const De={kind:"null"},Re={kind:"number"},Le={kind:"string"},Be={kind:"boolean"},Fe={kind:"color"},Oe={kind:"projectionDefinition"},je={kind:"object"},Ve={kind:"value"},Ne={kind:"collator"},Ue={kind:"formatted"},Ze={kind:"padding"},Ge={kind:"resolvedImage"},$e={kind:"variableAnchorOffsetCollection"};function qe(t,e){return{kind:"array",itemType:t,N:e}}function We(t){if("array"===t.kind){const e=We(t.itemType);return"number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const He=[De,Re,Le,Be,Fe,Oe,Ue,je,qe(Ve),Ze,Ge,$e];function Xe(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!Xe(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else{if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of He)if(!Xe(t,e))return null}return`Expected ${We(t)} but found ${We(e)} instead.`}function Ke(t,e){return e.some((e=>e.kind===t.kind))}function Ye(t,e){return e.some((e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t))}function Je(t,e){return"array"===t.kind&&"array"===e.kind?t.itemType.kind===e.itemType.kind&&"number"==typeof t.N:t.kind===e.kind}const Qe=.96422,ti=.82521,ei=4/29,ii=6/29,ri=3*ii*ii,ni=ii*ii*ii,si=Math.PI/180,oi=180/Math.PI;function ai(t){return(t%=360)<0&&(t+=360),t}function li([t,e,i,r]){let n,s;const o=hi((.2225045*(t=ci(t))+.7168786*(e=ci(e))+.0606169*(i=ci(i)))/1);t===e&&e===i?n=s=o:(n=hi((.4360747*t+.3850649*e+.1430804*i)/Qe),s=hi((.0139322*t+.0971045*e+.7141733*i)/ti));const a=116*o-16;return[a<0?0:a,500*(n-o),200*(o-s),r]}function ci(t){return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function hi(t){return t>ni?Math.pow(t,1/3):t/ri+ei}function ui([t,e,i,r]){let n=(t+16)/116,s=isNaN(e)?n:n+e/500,o=isNaN(i)?n:n-i/200;return n=1*di(n),s=Qe*di(s),o=ti*di(o),[pi(3.1338561*s-1.6168667*n-.4906146*o),pi(-.9787684*s+1.9161415*n+.033454*o),pi(.0719453*s-.2289914*n+1.4052427*o),r]}function pi(t){return(t=t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055)<0?0:t>1?1:t}function di(t){return t>ii?t*t*t:ri*(t-ei)}function fi(t){return parseInt(t.padEnd(2,t),16)/255}function mi(t,e){return _i(e?t/100:t,0,1)}function _i(t,e,i){return Math.min(Math.max(e,t),i)}function gi(t){return!t.some(Number.isNaN)}const yi={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function xi(t,e,i){return t+i*(e-t)}function vi(t,e,i){return t.map(((t,r)=>xi(t,e[r],i)))}class bi{constructor(t,e,i,r=1,n=!0){this.r=t,this.g=e,this.b=i,this.a=r,n||(this.r*=r,this.g*=r,this.b*=r,r||this.overwriteGetter("rgb",[t,e,i,r]))}static parse(t){if(t instanceof bi)return t;if("string"!=typeof t)return;const e=function(t){if("transparent"===(t=t.toLowerCase().trim()))return[0,0,0,0];const e=yi[t];if(e){const[t,i,r]=e;return[t/255,i/255,r/255,1]}if(t.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(t)){const e=t.length<6?1:2;let i=1;return[fi(t.slice(i,i+=e)),fi(t.slice(i,i+=e)),fi(t.slice(i,i+=e)),fi(t.slice(i,i+e)||"ff")]}if(t.startsWith("rgb")){const e=t.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(e){const[t,i,r,n,s,o,a,l,c,h,u,p]=e,d=[n||" ",a||" ",h].join("");if("  "===d||"  /"===d||",,"===d||",,,"===d){const t=[r,o,c].join(""),e="%%%"===t?100:""===t?255:0;if(e){const t=[_i(+i/e,0,1),_i(+s/e,0,1),_i(+l/e,0,1),u?mi(+u,p):1];if(gi(t))return t}}return}}const i=t.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(i){const[t,e,r,n,s,o,a,l,c]=i,h=[r||" ",s||" ",a].join("");if("  "===h||"  /"===h||",,"===h||",,,"===h){const t=[+e,_i(+n,0,100),_i(+o,0,100),l?mi(+l,c):1];if(gi(t))return function([t,e,i,r]){function n(r){const n=(r+t/30)%12,s=e*Math.min(i,1-i);return i-s*Math.max(-1,Math.min(n-3,9-n,1))}return t=ai(t),e/=100,i/=100,[n(0),n(8),n(4),r]}(t)}}}(t);return e?new bi(...e,!1):void 0}get rgb(){const{r:t,g:e,b:i,a:r}=this,n=r||1/0;return this.overwriteGetter("rgb",[t/n,e/n,i/n,r])}get hcl(){return this.overwriteGetter("hcl",function(t){const[e,i,r,n]=li(t),s=Math.sqrt(i*i+r*r);return[Math.round(1e4*s)?ai(Math.atan2(r,i)*oi):NaN,s,e,n]}(this.rgb))}get lab(){return this.overwriteGetter("lab",li(this.rgb))}overwriteGetter(t,e){return Object.defineProperty(this,t,{value:e}),e}toString(){const[t,e,i,r]=this.rgb;return`rgba(${[t,e,i].map((t=>Math.round(255*t))).join(",")},${r})`}static interpolate(t,e,i,r="rgb"){switch(r){case"rgb":{const[r,n,s,o]=vi(t.rgb,e.rgb,i);return new bi(r,n,s,o,!1)}case"hcl":{const[r,n,s,o]=t.hcl,[a,l,c,h]=e.hcl;let u,p;if(isNaN(r)||isNaN(a))isNaN(r)?isNaN(a)?u=NaN:(u=a,1!==s&&0!==s||(p=l)):(u=r,1!==c&&0!==c||(p=n));else{let t=a-r;a>r&&t>180?t-=360:a<r&&r-a>180&&(t+=360),u=r+i*t}const[d,f,m,_]=function([t,e,i,r]){return t=isNaN(t)?0:t*si,ui([i,Math.cos(t)*e,Math.sin(t)*e,r])}([u,null!=p?p:xi(n,l,i),xi(s,c,i),xi(o,h,i)]);return new bi(d,f,m,_,!1)}case"lab":{const[r,n,s,o]=ui(vi(t.lab,e.lab,i));return new bi(r,n,s,o,!1)}}}}bi.black=new bi(0,0,0,1),bi.white=new bi(1,1,1,1),bi.transparent=new bi(0,0,0,0),bi.red=new bi(1,0,0,1);class wi{constructor(t,e,i){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=i,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"})}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}const Ti=["bottom","center","top"];class Pi{constructor(t,e,i,r,n,s){this.text=t,this.image=e,this.scale=i,this.fontStack=r,this.textColor=n,this.verticalAlign=s}}class Mi{constructor(t){this.sections=t}static fromString(t){return new Mi([new Pi(t,null,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((t=>0!==t.text.length||t.image&&0!==t.image.name.length))}static factory(t){return t instanceof Mi?t:Mi.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map((t=>t.text)).join("")}}class Ci{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Ci)return t;if("number"==typeof t)return new Ci([t,t,t,t]);if(Array.isArray(t)&&!(t.length<1||t.length>4)){for(const e of t)if("number"!=typeof e)return;switch(t.length){case 1:t=[t[0],t[0],t[0],t[0]];break;case 2:t=[t[0],t[1],t[0],t[1]];break;case 3:t=[t[0],t[1],t[2],t[1]]}return new Ci(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i){return new Ci(vi(t.values,e.values,i))}}class Ii{constructor(t){this.name="ExpressionEvaluationError",this.message=t}toJSON(){return this.message}}const Si=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class Ei{constructor(t){this.values=t.slice()}static parse(t){if(t instanceof Ei)return t;if(Array.isArray(t)&&!(t.length<1)&&t.length%2==0){for(let e=0;e<t.length;e+=2){const i=t[e],r=t[e+1];if("string"!=typeof i||!Si.has(i))return;if(!Array.isArray(r)||2!==r.length||"number"!=typeof r[0]||"number"!=typeof r[1])return}return new Ei(t)}}toString(){return JSON.stringify(this.values)}static interpolate(t,e,i){const r=t.values,n=e.values;if(r.length!==n.length)throw new Ii(`Cannot interpolate values of different length. from: ${t.toString()}, to: ${e.toString()}`);const s=[];for(let t=0;t<r.length;t+=2){if(r[t]!==n[t])throw new Ii(`Cannot interpolate values containing mismatched anchors. from[${t}]: ${r[t]}, to[${t}]: ${n[t]}`);s.push(r[t]);const[e,o]=r[t+1],[a,l]=n[t+1];s.push([xi(e,a,i),xi(o,l,i)])}return new Ei(s)}}class Ai{constructor(t){this.name=t.name,this.available=t.available}toString(){return this.name}static fromString(t){return t?new Ai({name:t,available:!1}):null}}class zi{constructor(t,e,i){this.from=t,this.to=e,this.transition=i}static interpolate(t,e,i){return new zi(t,e,i)}static parse(t){return t instanceof zi?t:Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]?new zi(t[0],t[1],t[2]):"object"==typeof t&&"string"==typeof t.from&&"string"==typeof t.to&&"number"==typeof t.transition?new zi(t.from,t.to,t.transition):"string"==typeof t?new zi(t,t,1):void 0}}function ki(t,e,i,r){return"number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof i&&i>=0&&i<=255?void 0===r||"number"==typeof r&&r>=0&&r<=1?null:`Invalid rgba value [${[t,e,i,r].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof r?[t,e,i,r]:[t,e,i]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Di(t){if(null===t||"string"==typeof t||"boolean"==typeof t||"number"==typeof t||t instanceof zi||t instanceof bi||t instanceof wi||t instanceof Mi||t instanceof Ci||t instanceof Ei||t instanceof Ai)return!0;if(Array.isArray(t)){for(const e of t)if(!Di(e))return!1;return!0}if("object"==typeof t){for(const e in t)if(!Di(t[e]))return!1;return!0}return!1}function Ri(t){if(null===t)return De;if("string"==typeof t)return Le;if("boolean"==typeof t)return Be;if("number"==typeof t)return Re;if(t instanceof bi)return Fe;if(t instanceof zi)return Oe;if(t instanceof wi)return Ne;if(t instanceof Mi)return Ue;if(t instanceof Ci)return Ze;if(t instanceof Ei)return $e;if(t instanceof Ai)return Ge;if(Array.isArray(t)){const e=t.length;let i;for(const e of t){const t=Ri(e);if(i){if(i===t)continue;i=Ve;break}i=t}return qe(i||Ve,e)}return je}function Li(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof bi||t instanceof zi||t instanceof Mi||t instanceof Ci||t instanceof Ei||t instanceof Ai?t.toString():JSON.stringify(t)}class Bi{constructor(t,e){this.type=t,this.value=e}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!Di(t[1]))return e.error("invalid value");const i=t[1];let r=Ri(i);const n=e.expectedType;return"array"!==r.kind||0!==r.N||!n||"array"!==n.kind||"number"==typeof n.N&&0!==n.N||(r=n),new Bi(r,i)}evaluate(){return this.value}eachChild(){}outputDefined(){return!0}}const Fi={string:Le,number:Re,boolean:Be,object:je};class Oi{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let i,r=1;const n=t[0];if("array"===n){let n,s;if(t.length>2){const i=t[1];if("string"!=typeof i||!(i in Fi)||"object"===i)return e.error('The item type argument of "array" must be one of string, number, boolean',1);n=Fi[i],r++}else n=Ve;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],r++}i=qe(n,s)}else{if(!Fi[n])throw new Error(`Types doesn't contain name = ${n}`);i=Fi[n]}const s=[];for(;r<t.length;r++){const i=e.parse(t[r],r,Ve);if(!i)return null;s.push(i)}return new Oi(i,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const i=this.args[e].evaluate(t);if(!Xe(this.type,Ri(i)))return i;if(e===this.args.length-1)throw new Ii(`Expected value to be of type ${We(this.type)}, but found ${We(Ri(i))} instead.`)}throw new Error}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const ji={"to-boolean":Be,"to-color":Fe,"to-number":Re,"to-string":Le};class Vi{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const i=t[0];if(!ji[i])throw new Error(`Can't parse ${i} as it is not part of the known types`);if(("to-boolean"===i||"to-string"===i)&&2!==t.length)return e.error("Expected one argument.");const r=ji[i],n=[];for(let i=1;i<t.length;i++){const r=e.parse(t[i],i,Ve);if(!r)return null;n.push(r)}return new Vi(r,n)}evaluate(t){switch(this.type.kind){case"boolean":return Boolean(this.args[0].evaluate(t));case"color":{let e,i;for(const r of this.args){if(e=r.evaluate(t),i=null,e instanceof bi)return e;if("string"==typeof e){const i=t.parseColor(e);if(i)return i}else if(Array.isArray(e)&&(i=e.length<3||e.length>4?`Invalid rgba value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:ki(e[0],e[1],e[2],e[3]),!i))return new bi(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new Ii(i||`Could not parse color from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"padding":{let e;for(const i of this.args){e=i.evaluate(t);const r=Ci.parse(e);if(r)return r}throw new Ii(`Could not parse padding from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"variableAnchorOffsetCollection":{let e;for(const i of this.args){e=i.evaluate(t);const r=Ei.parse(e);if(r)return r}throw new Ii(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof e?e:JSON.stringify(e)}'`)}case"number":{let e=null;for(const i of this.args){if(e=i.evaluate(t),null===e)return 0;const r=Number(e);if(!isNaN(r))return r}throw new Ii(`Could not convert ${JSON.stringify(e)} to number.`)}case"formatted":return Mi.fromString(Li(this.args[0].evaluate(t)));case"resolvedImage":return Ai.fromString(Li(this.args[0].evaluate(t)));case"projectionDefinition":return this.args[0].evaluate(t);default:return Li(this.args[0].evaluate(t))}}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}const Ni=["Unknown","Point","LineString","Polygon"];class Ui{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Ni[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=bi.parse(t)),e}}class Zi{constructor(t,e,i=[],r,n=new ke,s=[]){this.registry=t,this.path=i,this.key=i.map((t=>`[${t}]`)).join(""),this.scope=n,this.errors=s,this.expectedType=r,this._isConstant=e}parse(t,e,i,r,n={}){return e?this.concat(e,i,r)._parse(t,n):this._parse(t,n)}_parse(t,e){function i(t,e,i){return"assert"===i?new Oi(e,[t]):"coerce"===i?new Vi(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const r=t[0];if("string"!=typeof r)return this.error(`Expression name must be a string, but found ${typeof r} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const n=this.registry[r];if(n){let r=n.parse(t,this);if(!r)return null;if(this.expectedType){const t=this.expectedType,n=r.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==n.kind)if("projectionDefinition"!==t.kind||"string"!==n.kind&&"array"!==n.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==n.kind&&"string"!==n.kind)if("padding"!==t.kind||"value"!==n.kind&&"number"!==n.kind&&"array"!==n.kind)if("variableAnchorOffsetCollection"!==t.kind||"value"!==n.kind&&"array"!==n.kind){if(this.checkSubtype(t,n))return null}else r=i(r,t,e.typeAnnotation||"coerce");else r=i(r,t,e.typeAnnotation||"coerce");else r=i(r,t,e.typeAnnotation||"coerce");else r=i(r,t,e.typeAnnotation||"coerce");else r=i(r,t,e.typeAnnotation||"assert")}if(!(r instanceof Bi)&&"resolvedImage"!==r.type.kind&&this._isConstant(r)){const t=new Ui;try{r=new Bi(r.type,r.evaluate(t))}catch(t){return this.error(t.message),null}}return r}return this.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,i){const r="number"==typeof t?this.path.concat(t):this.path,n=i?this.scope.concat(i):this.scope;return new Zi(this.registry,this._isConstant,r,e||null,n,this.errors)}error(t,...e){const i=`${this.key}${e.map((t=>`[${t}]`)).join("")}`;this.errors.push(new ze(i,t))}checkSubtype(t,e){const i=Xe(t,e);return i&&this.error(i),i}}class Gi{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result)}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const i=[];for(let r=1;r<t.length-1;r+=2){const n=t[r];if("string"!=typeof n)return e.error(`Expected string, but found ${typeof n} instead.`,r);if(/[^a-zA-Z0-9_]/.test(n))return e.error("Variable names must contain only alphanumeric characters or '_'.",r);const s=e.parse(t[r+1],r+1);if(!s)return null;i.push([n,s])}const r=e.parse(t[t.length-1],t.length-1,e.expectedType,i);return r?new Gi(i,r):null}outputDefined(){return this.result.outputDefined()}}class $i{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const i=t[1];return e.scope.has(i)?new $i(i,e.scope.get(i)):e.error(`Unknown variable "${i}". Make sure "${i}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return!1}}class qi{constructor(t,e,i){this.type=t,this.index=e,this.input=i}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,Re),r=e.parse(t[2],2,qe(e.expectedType||Ve));return i&&r?new qi(r.type.itemType,i,r):null}evaluate(t){const e=this.index.evaluate(t),i=this.input.evaluate(t);if(e<0)throw new Ii(`Array index out of bounds: ${e} < 0.`);if(e>=i.length)throw new Ii(`Array index out of bounds: ${e} > ${i.length-1}.`);if(e!==Math.floor(e))throw new Ii(`Array index must be an integer, but found ${e} instead.`);return i[e]}eachChild(t){t(this.index),t(this.input)}outputDefined(){return!1}}class Wi{constructor(t,e){this.type=Be,this.needle=t,this.haystack=e}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,Ve),r=e.parse(t[2],2,Ve);return i&&r?Ke(i.type,[Be,Le,Re,De,Ve])?new Wi(i,r):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${We(i.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),i=this.haystack.evaluate(t);if(!i)return!1;if(!Ye(e,["boolean","string","number","null"]))throw new Ii(`Expected first argument to be of type boolean, string, number or null, but found ${We(Ri(e))} instead.`);if(!Ye(i,["string","array"]))throw new Ii(`Expected second argument to be of type array or string, but found ${We(Ri(i))} instead.`);return i.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack)}outputDefined(){return!0}}class Hi{constructor(t,e,i){this.type=Re,this.needle=t,this.haystack=e,this.fromIndex=i}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,Ve),r=e.parse(t[2],2,Ve);if(!i||!r)return null;if(!Ke(i.type,[Be,Le,Re,De,Ve]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${We(i.type)} instead`);if(4===t.length){const n=e.parse(t[3],3,Re);return n?new Hi(i,r,n):null}return new Hi(i,r)}evaluate(t){const e=this.needle.evaluate(t),i=this.haystack.evaluate(t);if(!Ye(e,["boolean","string","number","null"]))throw new Ii(`Expected first argument to be of type boolean, string, number or null, but found ${We(Ri(e))} instead.`);let r;if(this.fromIndex&&(r=this.fromIndex.evaluate(t)),Ye(i,["string"])){const t=i.indexOf(e,r);return-1===t?-1:[...i.slice(0,t)].length}if(Ye(i,["array"]))return i.indexOf(e,r);throw new Ii(`Expected second argument to be of type array or string, but found ${We(Ri(i))} instead.`)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex)}outputDefined(){return!1}}class Xi{constructor(t,e,i,r,n,s){this.inputType=t,this.type=e,this.input=i,this.cases=r,this.outputs=n,this.otherwise=s}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let i,r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const n={},s=[];for(let o=2;o<t.length-1;o+=2){let a=t[o];const l=t[o+1];Array.isArray(a)||(a=[a]);const c=e.concat(o);if(0===a.length)return c.error("Expected at least one branch label.");for(const t of a){if("number"!=typeof t&&"string"!=typeof t)return c.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return c.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return c.error("Numeric branch labels must be integer values.");if(i){if(c.checkSubtype(i,Ri(t)))return null}else i=Ri(t);if(void 0!==n[String(t)])return c.error("Branch labels must be unique.");n[String(t)]=s.length}const h=e.parse(l,o,r);if(!h)return null;r=r||h.type,s.push(h)}const o=e.parse(t[1],1,Ve);if(!o)return null;const a=e.parse(t[t.length-1],t.length-1,r);return a?"value"!==o.type.kind&&e.concat(1).checkSubtype(i,o.type)?null:new Xi(i,r,o,n,s,a):null}evaluate(t){const e=this.input.evaluate(t);return(Ri(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))&&this.otherwise.outputDefined()}}class Ki{constructor(t,e,i){this.type=t,this.branches=e,this.otherwise=i}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let i;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);const r=[];for(let n=1;n<t.length-1;n+=2){const s=e.parse(t[n],n,Be);if(!s)return null;const o=e.parse(t[n+1],n+1,i);if(!o)return null;r.push([s,o]),i=i||o.type}const n=e.parse(t[t.length-1],t.length-1,i);if(!n)return null;if(!i)throw new Error("Can't infer output type");return new Ki(i,r,n)}evaluate(t){for(const[e,i]of this.branches)if(e.evaluate(t))return i.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,i]of this.branches)t(e),t(i);t(this.otherwise)}outputDefined(){return this.branches.every((([t,e])=>e.outputDefined()))&&this.otherwise.outputDefined()}}class Yi{constructor(t,e,i,r){this.type=t,this.input=e,this.beginIndex=i,this.endIndex=r}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const i=e.parse(t[1],1,Ve),r=e.parse(t[2],2,Re);if(!i||!r)return null;if(!Ke(i.type,[qe(Ve),Le,Ve]))return e.error(`Expected first argument to be of type array or string, but found ${We(i.type)} instead`);if(4===t.length){const n=e.parse(t[3],3,Re);return n?new Yi(i.type,i,r,n):null}return new Yi(i.type,i,r)}evaluate(t){const e=this.input.evaluate(t),i=this.beginIndex.evaluate(t);let r;if(this.endIndex&&(r=this.endIndex.evaluate(t)),Ye(e,["string"]))return[...e].slice(i,r).join("");if(Ye(e,["array"]))return e.slice(i,r);throw new Ii(`Expected first argument to be of type array or string, but found ${We(Ri(e))} instead.`)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex)}outputDefined(){return!1}}function Ji(t,e){const i=t.length-1;let r,n,s=0,o=i,a=0;for(;s<=o;)if(a=Math.floor((s+o)/2),r=t[a],n=t[a+1],r<=e){if(a===i||e<n)return a;s=a+1}else{if(!(r>e))throw new Ii("Input is not a number.");o=a-1}return 0}class Qi{constructor(t,e,i){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of i)this.labels.push(t),this.outputs.push(e)}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const i=e.parse(t[1],1,Re);if(!i)return null;const r=[];let n=null;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);for(let i=1;i<t.length;i+=2){const s=1===i?-1/0:t[i],o=t[i+1],a=i,l=i+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',a);if(r.length&&r[r.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',a);const c=e.parse(o,l,n);if(!c)return null;n=n||c.type,r.push([s,c])}return new Qi(n,i,r)}evaluate(t){const e=this.labels,i=this.outputs;if(1===e.length)return i[0].evaluate(t);const r=this.input.evaluate(t);if(r<=e[0])return i[0].evaluate(t);const n=e.length;return r>=e[n-1]?i[n-1].evaluate(t):i[Ji(e,r)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function tr(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}var er,ir,rr=function(){if(ir)return er;function t(t,e,i,r){this.cx=3*t,this.bx=3*(i-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(r-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=e,this.p2x=i,this.p2y=r}return ir=1,er=t,t.prototype={sampleCurveX:function(t){return((this.ax*t+this.bx)*t+this.cx)*t},sampleCurveY:function(t){return((this.ay*t+this.by)*t+this.cy)*t},sampleCurveDerivativeX:function(t){return(3*this.ax*t+2*this.bx)*t+this.cx},solveCurveX:function(t,e){if(void 0===e&&(e=1e-6),t<0)return 0;if(t>1)return 1;for(var i=t,r=0;r<8;r++){var n=this.sampleCurveX(i)-t;if(Math.abs(n)<e)return i;var s=this.sampleCurveDerivativeX(i);if(Math.abs(s)<1e-6)break;i-=n/s}var o=0,a=1;for(i=t,r=0;r<20&&(n=this.sampleCurveX(i),!(Math.abs(n-t)<e));r++)t>n?o=i:a=i,i=.5*(a-o)+o;return i},solve:function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))}},er}(),nr=tr(rr);class sr{constructor(t,e,i,r,n){this.type=t,this.operator=e,this.interpolation=i,this.input=r,this.labels=[],this.outputs=[];for(const[t,e]of n)this.labels.push(t),this.outputs.push(e)}static interpolationFactor(t,e,i,r){let n=0;if("exponential"===t.name)n=or(e,t.base,i,r);else if("linear"===t.name)n=or(e,1,i,r);else if("cubic-bezier"===t.name){const s=t.controlPoints;n=new nr(s[0],s[1],s[2],s[3]).solve(or(e,1,i,r))}return n}static parse(t,e){let[i,r,n,...s]=t;if(!Array.isArray(r)||0===r.length)return e.error("Expected an interpolation type expression.",1);if("linear"===r[0])r={name:"linear"};else if("exponential"===r[0]){const t=r[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);r={name:"exponential",base:t}}else{if("cubic-bezier"!==r[0])return e.error(`Unknown interpolation type ${String(r[0])}`,1,0);{const t=r.slice(1);if(4!==t.length||t.some((t=>"number"!=typeof t||t<0||t>1)))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);r={name:"cubic-bezier",controlPoints:t}}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(n=e.parse(n,2,Re),!n)return null;const o=[];let a=null;"interpolate-hcl"===i||"interpolate-lab"===i?a=Fe:e.expectedType&&"value"!==e.expectedType.kind&&(a=e.expectedType);for(let t=0;t<s.length;t+=2){const i=s[t],r=s[t+1],n=t+3,l=t+4;if("number"!=typeof i)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',n);if(o.length&&o[o.length-1][0]>=i)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',n);const c=e.parse(r,l,a);if(!c)return null;a=a||c.type,o.push([i,c])}return Je(a,Re)||Je(a,Oe)||Je(a,Fe)||Je(a,Ze)||Je(a,$e)||Je(a,qe(Re))?new sr(a,i,r,n,o):e.error(`Type ${We(a)} is not interpolatable.`)}evaluate(t){const e=this.labels,i=this.outputs;if(1===e.length)return i[0].evaluate(t);const r=this.input.evaluate(t);if(r<=e[0])return i[0].evaluate(t);const n=e.length;if(r>=e[n-1])return i[n-1].evaluate(t);const s=Ji(e,r),o=sr.interpolationFactor(this.interpolation,r,e[s],e[s+1]),a=i[s].evaluate(t),l=i[s+1].evaluate(t);switch(this.operator){case"interpolate":switch(this.type.kind){case"number":return xi(a,l,o);case"color":return bi.interpolate(a,l,o);case"padding":return Ci.interpolate(a,l,o);case"variableAnchorOffsetCollection":return Ei.interpolate(a,l,o);case"array":return vi(a,l,o);case"projectionDefinition":return zi.interpolate(a,l,o)}case"interpolate-hcl":return bi.interpolate(a,l,o,"hcl");case"interpolate-lab":return bi.interpolate(a,l,o,"lab")}}eachChild(t){t(this.input);for(const e of this.outputs)t(e)}outputDefined(){return this.outputs.every((t=>t.outputDefined()))}}function or(t,e,i,r){const n=r-i,s=t-i;return 0===n?0:1===e?s/n:(Math.pow(e,s)-1)/(Math.pow(e,n)-1)}const ar={color:bi.interpolate,number:xi,padding:Ci.interpolate,variableAnchorOffsetCollection:Ei.interpolate,array:vi};class lr{constructor(t,e){this.type=t,this.args=e}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let i=null;const r=e.expectedType;r&&"value"!==r.kind&&(i=r);const n=[];for(const r of t.slice(1)){const t=e.parse(r,1+n.length,i,void 0,{typeAnnotation:"omit"});if(!t)return null;i=i||t.type,n.push(t)}if(!i)throw new Error("No output type");const s=r&&n.some((t=>Xe(r,t.type)));return new lr(s?Ve:i,n)}evaluate(t){let e,i=null,r=0;for(const n of this.args)if(r++,i=n.evaluate(t),i&&i instanceof Ai&&!i.available&&(e||(e=i.name),i=null,r===this.args.length&&(i=e)),null!==i)break;return i}eachChild(t){this.args.forEach(t)}outputDefined(){return this.args.every((t=>t.outputDefined()))}}function cr(t,e){return"=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function hr(t,e,i,r){return 0===r.compare(e,i)}function ur(t,e,i){const r="=="!==t&&"!="!==t;return class n{constructor(t,e,i){this.type=Be,this.lhs=t,this.rhs=e,this.collator=i,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const i=t[0];let s=e.parse(t[1],1,Ve);if(!s)return null;if(!cr(i,s.type))return e.concat(1).error(`"${i}" comparisons are not supported for type '${We(s.type)}'.`);let o=e.parse(t[2],2,Ve);if(!o)return null;if(!cr(i,o.type))return e.concat(2).error(`"${i}" comparisons are not supported for type '${We(o.type)}'.`);if(s.type.kind!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error(`Cannot compare types '${We(s.type)}' and '${We(o.type)}'.`);r&&("value"===s.type.kind&&"value"!==o.type.kind?s=new Oi(o.type,[s]):"value"!==s.type.kind&&"value"===o.type.kind&&(o=new Oi(s.type,[o])));let a=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return e.error("Cannot use collator to compare non-string types.");if(a=e.parse(t[3],3,Ne),!a)return null}return new n(s,o,a)}evaluate(n){const s=this.lhs.evaluate(n),o=this.rhs.evaluate(n);if(r&&this.hasUntypedArgument){const e=Ri(s),i=Ri(o);if(e.kind!==i.kind||"string"!==e.kind&&"number"!==e.kind)throw new Ii(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${i.kind}) instead.`)}if(this.collator&&!r&&this.hasUntypedArgument){const t=Ri(s),i=Ri(o);if("string"!==t.kind||"string"!==i.kind)return e(n,s,o)}return this.collator?i(n,s,o,this.collator.evaluate(n)):e(n,s,o)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator)}outputDefined(){return!0}}}const pr=ur("==",(function(t,e,i){return e===i}),hr),dr=ur("!=",(function(t,e,i){return e!==i}),(function(t,e,i,r){return!hr(0,e,i,r)})),fr=ur("<",(function(t,e,i){return e<i}),(function(t,e,i,r){return r.compare(e,i)<0})),mr=ur(">",(function(t,e,i){return e>i}),(function(t,e,i,r){return r.compare(e,i)>0})),_r=ur("<=",(function(t,e,i){return e<=i}),(function(t,e,i,r){return r.compare(e,i)<=0})),gr=ur(">=",(function(t,e,i){return e>=i}),(function(t,e,i,r){return r.compare(e,i)>=0}));class yr{constructor(t,e,i){this.type=Ne,this.locale=i,this.caseSensitive=t,this.diacriticSensitive=e}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const i=t[1];if("object"!=typeof i||Array.isArray(i))return e.error("Collator options argument must be an object.");const r=e.parse(void 0!==i["case-sensitive"]&&i["case-sensitive"],1,Be);if(!r)return null;const n=e.parse(void 0!==i["diacritic-sensitive"]&&i["diacritic-sensitive"],1,Be);if(!n)return null;let s=null;return i.locale&&(s=e.parse(i.locale,1,Le),!s)?null:new yr(r,n,s)}evaluate(t){return new wi(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale)}outputDefined(){return!1}}class xr{constructor(t,e,i,r,n){this.type=Le,this.number=t,this.locale=e,this.currency=i,this.minFractionDigits=r,this.maxFractionDigits=n}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const i=e.parse(t[1],1,Re);if(!i)return null;const r=t[2];if("object"!=typeof r||Array.isArray(r))return e.error("NumberFormat options argument must be an object.");let n=null;if(r.locale&&(n=e.parse(r.locale,1,Le),!n))return null;let s=null;if(r.currency&&(s=e.parse(r.currency,1,Le),!s))return null;let o=null;if(r["min-fraction-digits"]&&(o=e.parse(r["min-fraction-digits"],1,Re),!o))return null;let a=null;return r["max-fraction-digits"]&&(a=e.parse(r["max-fraction-digits"],1,Re),!a)?null:new xr(i,n,s,o,a)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits)}outputDefined(){return!1}}class vr{constructor(t){this.type=Ue,this.sections=t}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const i=t[1];if(!Array.isArray(i)&&"object"==typeof i)return e.error("First argument must be an image or text section.");const r=[];let n=!1;for(let i=1;i<=t.length-1;++i){const s=t[i];if(n&&"object"==typeof s&&!Array.isArray(s)){n=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,Re),!t))return null;let i=null;if(s["text-font"]&&(i=e.parse(s["text-font"],1,qe(Le)),!i))return null;let o=null;if(s["text-color"]&&(o=e.parse(s["text-color"],1,Fe),!o))return null;let a=null;if(s["vertical-align"]){if("string"==typeof s["vertical-align"]&&!Ti.includes(s["vertical-align"]))return e.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${s["vertical-align"]}' instead.`);if(a=e.parse(s["vertical-align"],1,Le),!a)return null}const l=r[r.length-1];l.scale=t,l.font=i,l.textColor=o,l.verticalAlign=a}else{const s=e.parse(t[i],1,Ve);if(!s)return null;const o=s.type.kind;if("string"!==o&&"value"!==o&&"null"!==o&&"resolvedImage"!==o)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");n=!0,r.push({content:s,scale:null,font:null,textColor:null,verticalAlign:null})}}return new vr(r)}evaluate(t){return new Mi(this.sections.map((e=>{const i=e.content.evaluate(t);return Ri(i)===Ge?new Pi("",i,null,null,null,e.verticalAlign?e.verticalAlign.evaluate(t):null):new Pi(Li(i),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null,e.verticalAlign?e.verticalAlign.evaluate(t):null)})))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor),e.verticalAlign&&t(e.verticalAlign)}outputDefined(){return!1}}class br{constructor(t){this.type=Ge,this.input=t}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const i=e.parse(t[1],1,Le);return i?new br(i):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),i=Ai.fromString(e);return i&&t.availableImages&&(i.available=t.availableImages.indexOf(e)>-1),i}eachChild(t){t(this.input)}outputDefined(){return!1}}class wr{constructor(t){this.type=Re,this.input=t}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const i=e.parse(t[1],1);return i?"array"!==i.type.kind&&"string"!==i.type.kind&&"value"!==i.type.kind?e.error(`Expected argument of type string or array, but found ${We(i.type)} instead.`):new wr(i):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return[...e].length;if(Array.isArray(e))return e.length;throw new Ii(`Expected value to be of type string or array, but found ${We(Ri(e))} instead.`)}eachChild(t){t(this.input)}outputDefined(){return!1}}const Tr=8192;function Pr(t,e){const i=(180+t[0])/360,r=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,n=Math.pow(2,e.z);return[Math.round(i*n*Tr),Math.round(r*n*Tr)]}function Mr(t,e){const i=Math.pow(2,e.z);return[(n=(t[0]/Tr+e.x)/i,360*n-180),(r=(t[1]/Tr+e.y)/i,360/Math.PI*Math.atan(Math.exp((180-360*r)*Math.PI/180))-90)];var r,n}function Cr(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1])}function Ir(t,e){return!(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Sr(t,e,i){const r=t[0]-e[0],n=t[1]-e[1],s=t[0]-i[0],o=t[1]-i[1];return r*o-s*n==0&&r*s<=0&&n*o<=0}function Er(t,e,i,r){return 0!=(n=[r[0]-i[0],r[1]-i[1]])[0]*(s=[e[0]-t[0],e[1]-t[1]])[1]-n[1]*s[0]&&!(!Lr(t,e,i,r)||!Lr(i,r,t,e));var n,s}function Ar(t,e,i){for(const r of i)for(let i=0;i<r.length-1;++i)if(Er(t,e,r[i],r[i+1]))return!0;return!1}function zr(t,e,i=!1){let r=!1;for(const a of e)for(let e=0;e<a.length-1;e++){if(Sr(t,a[e],a[e+1]))return i;(s=a[e])[1]>(n=t)[1]!=(o=a[e+1])[1]>n[1]&&n[0]<(o[0]-s[0])*(n[1]-s[1])/(o[1]-s[1])+s[0]&&(r=!r)}var n,s,o;return r}function kr(t,e){for(const i of e)if(zr(t,i))return!0;return!1}function Dr(t,e){for(const i of t)if(!zr(i,e))return!1;for(let i=0;i<t.length-1;++i)if(Ar(t[i],t[i+1],e))return!1;return!0}function Rr(t,e){for(const i of e)if(Dr(t,i))return!0;return!1}function Lr(t,e,i,r){const n=r[0]-i[0],s=r[1]-i[1],o=(t[0]-i[0])*s-n*(t[1]-i[1]),a=(e[0]-i[0])*s-n*(e[1]-i[1]);return o>0&&a<0||o<0&&a>0}function Br(t,e,i){const r=[];for(let n=0;n<t.length;n++){const s=[];for(let r=0;r<t[n].length;r++){const o=Pr(t[n][r],i);Cr(e,o),s.push(o)}r.push(s)}return r}function Fr(t,e,i){const r=[];for(let n=0;n<t.length;n++){const s=Br(t[n],e,i);r.push(s)}return r}function Or(t,e,i,r){if(t[0]<i[0]||t[0]>i[2]){const e=.5*r;let n=t[0]-i[0]>e?-r:i[0]-t[0]>e?r:0;0===n&&(n=t[0]-i[2]>e?-r:i[2]-t[0]>e?r:0),t[0]+=n}Cr(e,t)}function jr(t,e,i,r){const n=Math.pow(2,r.z)*Tr,s=[r.x*Tr,r.y*Tr],o=[];for(const r of t)for(const t of r){const r=[t.x+s[0],t.y+s[1]];Or(r,e,i,n),o.push(r)}return o}function Vr(t,e,i,r){const n=Math.pow(2,r.z)*Tr,s=[r.x*Tr,r.y*Tr],o=[];for(const i of t){const t=[];for(const r of i){const i=[r.x+s[0],r.y+s[1]];Cr(e,i),t.push(i)}o.push(t)}if(e[2]-e[0]<=n/2){(a=e)[0]=a[1]=1/0,a[2]=a[3]=-1/0;for(const t of o)for(const r of t)Or(r,e,i,n)}var a;return o}class Nr{constructor(t,e){this.type=Be,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Di(t[1])){const e=t[1];if("FeatureCollection"===e.type){const t=[];for(const i of e.features){const{type:e,coordinates:r}=i.geometry;"Polygon"===e&&t.push(r),"MultiPolygon"===e&&t.push(...r)}if(t.length)return new Nr(e,{type:"MultiPolygon",coordinates:t})}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new Nr(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new Nr(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=t.canonicalID();if("Polygon"===e.type){const s=Br(e.coordinates,r,n),o=jr(t.geometry(),i,r,n);if(!Ir(i,r))return!1;for(const t of o)if(!zr(t,s))return!1}if("MultiPolygon"===e.type){const s=Fr(e.coordinates,r,n),o=jr(t.geometry(),i,r,n);if(!Ir(i,r))return!1;for(const t of o)if(!kr(t,s))return!1}return!0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=t.canonicalID();if("Polygon"===e.type){const s=Br(e.coordinates,r,n),o=Vr(t.geometry(),i,r,n);if(!Ir(i,r))return!1;for(const t of o)if(!Dr(t,s))return!1}if("MultiPolygon"===e.type){const s=Fr(e.coordinates,r,n),o=Vr(t.geometry(),i,r,n);if(!Ir(i,r))return!1;for(const t of o)if(!Rr(t,s))return!1}return!0}(t,this.geometries)}return!1}eachChild(){}outputDefined(){return!0}}class Ur{constructor(t=[],e=((t,e)=>t<e?-1:t>e?1:0)){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t)}push(t){this.data.push(t),this._up(this.length++)}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return--this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:i}=this,r=e[t];for(;t>0;){const n=t-1>>1,s=e[n];if(i(r,s)>=0)break;e[t]=s,t=n}e[t]=r}_down(t){const{data:e,compare:i}=this,r=this.length>>1,n=e[t];for(;t<r;){let r=1+(t<<1);const s=r+1;if(s<this.length&&i(e[s],e[r])<0&&(r=s),i(e[r],n)>=0)break;e[t]=e[r],t=r}e[t]=n}}function Zr(t,e,i=0,r=t.length-1,n=$r){for(;r>i;){if(r-i>600){const s=r-i+1,o=e-i+1,a=Math.log(s),l=.5*Math.exp(2*a/3),c=.5*Math.sqrt(a*l*(s-l)/s)*(o-s/2<0?-1:1);Zr(t,e,Math.max(i,Math.floor(e-o*l/s+c)),Math.min(r,Math.floor(e+(s-o)*l/s+c)),n)}const s=t[e];let o=i,a=r;for(Gr(t,i,e),n(t[r],s)>0&&Gr(t,i,r);o<a;){for(Gr(t,o,a),o++,a--;n(t[o],s)<0;)o++;for(;n(t[a],s)>0;)a--}0===n(t[i],s)?Gr(t,i,a):(a++,Gr(t,a,r)),a<=e&&(i=a+1),e<=a&&(r=a-1)}}function Gr(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}function $r(t,e){return t<e?-1:t>e?1:0}function qr(t,e){if(t.length<=1)return[t];const i=[];let r,n;for(const e of t){const t=Hr(e);0!==t&&(e.area=Math.abs(t),void 0===n&&(n=t<0),n===t<0?(r&&i.push(r),r=[e]):r.push(e))}if(r&&i.push(r),e>1)for(let t=0;t<i.length;t++)i[t].length<=e||(Zr(i[t],e,1,i[t].length-1,Wr),i[t]=i[t].slice(0,e));return i}function Wr(t,e){return e.area-t.area}function Hr(t){let e=0;for(let i,r,n=0,s=t.length,o=s-1;n<s;o=n++)i=t[n],r=t[o],e+=(r.x-i.x)*(i.y+r.y);return e}const Xr=1/298.257223563,Kr=Xr*(2-Xr),Yr=Math.PI/180;class Jr{constructor(t){const e=6378.137*Yr*1e3,i=Math.cos(t*Yr),r=1/(1-Kr*(1-i*i)),n=Math.sqrt(r);this.kx=e*n*i,this.ky=e*n*r*(1-Kr)}distance(t,e){const i=this.wrap(t[0]-e[0])*this.kx,r=(t[1]-e[1])*this.ky;return Math.sqrt(i*i+r*r)}pointOnLine(t,e){let i,r,n,s,o=1/0;for(let a=0;a<t.length-1;a++){let l=t[a][0],c=t[a][1],h=this.wrap(t[a+1][0]-l)*this.kx,u=(t[a+1][1]-c)*this.ky,p=0;0===h&&0===u||(p=(this.wrap(e[0]-l)*this.kx*h+(e[1]-c)*this.ky*u)/(h*h+u*u),p>1?(l=t[a+1][0],c=t[a+1][1]):p>0&&(l+=h/this.kx*p,c+=u/this.ky*p)),h=this.wrap(e[0]-l)*this.kx,u=(e[1]-c)*this.ky;const d=h*h+u*u;d<o&&(o=d,i=l,r=c,n=a,s=p)}return{point:[i,r],index:n,t:Math.max(0,Math.min(1,s))}}wrap(t){for(;t<-180;)t+=360;for(;t>180;)t-=360;return t}}function Qr(t,e){return e[0]-t[0]}function tn(t){return t[1]-t[0]+1}function en(t,e){return t[1]>=t[0]&&t[1]<e}function rn(t,e){if(t[0]>t[1])return[null,null];const i=tn(t);if(e){if(2===i)return[t,null];const e=Math.floor(i/2);return[[t[0],t[0]+e],[t[0]+e,t[1]]]}if(1===i)return[t,null];const r=Math.floor(i/2)-1;return[[t[0],t[0]+r],[t[0]+r+1,t[1]]]}function nn(t,e){if(!en(e,t.length))return[1/0,1/0,-1/0,-1/0];const i=[1/0,1/0,-1/0,-1/0];for(let r=e[0];r<=e[1];++r)Cr(i,t[r]);return i}function sn(t){const e=[1/0,1/0,-1/0,-1/0];for(const i of t)for(const t of i)Cr(e,t);return e}function on(t){return t[0]!==-1/0&&t[1]!==-1/0&&t[2]!==1/0&&t[3]!==1/0}function an(t,e,i){if(!on(t)||!on(e))return NaN;let r=0,n=0;return t[2]<e[0]&&(r=e[0]-t[2]),t[0]>e[2]&&(r=t[0]-e[2]),t[1]>e[3]&&(n=t[1]-e[3]),t[3]<e[1]&&(n=e[1]-t[3]),i.distance([0,0],[r,n])}function ln(t,e,i){const r=i.pointOnLine(e,t);return i.distance(t,r.point)}function cn(t,e,i,r,n){const s=Math.min(ln(t,[i,r],n),ln(e,[i,r],n)),o=Math.min(ln(i,[t,e],n),ln(r,[t,e],n));return Math.min(s,o)}function hn(t,e,i,r,n){if(!en(e,t.length)||!en(r,i.length))return 1/0;let s=1/0;for(let o=e[0];o<e[1];++o){const e=t[o],a=t[o+1];for(let t=r[0];t<r[1];++t){const r=i[t],o=i[t+1];if(Er(e,a,r,o))return 0;s=Math.min(s,cn(e,a,r,o,n))}}return s}function un(t,e,i,r,n){if(!en(e,t.length)||!en(r,i.length))return NaN;let s=1/0;for(let o=e[0];o<=e[1];++o)for(let e=r[0];e<=r[1];++e)if(s=Math.min(s,n.distance(t[o],i[e])),0===s)return s;return s}function pn(t,e,i){if(zr(t,e,!0))return 0;let r=1/0;for(const n of e){const e=n[0],s=n[n.length-1];if(e!==s&&(r=Math.min(r,ln(t,[s,e],i)),0===r))return r;const o=i.pointOnLine(n,t);if(r=Math.min(r,i.distance(t,o.point)),0===r)return r}return r}function dn(t,e,i,r){if(!en(e,t.length))return NaN;for(let r=e[0];r<=e[1];++r)if(zr(t[r],i,!0))return 0;let n=1/0;for(let s=e[0];s<e[1];++s){const e=t[s],o=t[s+1];for(const t of i)for(let i=0,s=t.length,a=s-1;i<s;a=i++){const s=t[a],l=t[i];if(Er(e,o,s,l))return 0;n=Math.min(n,cn(e,o,s,l,r))}}return n}function fn(t,e){for(const i of t)for(const t of i)if(zr(t,e,!0))return!0;return!1}function mn(t,e,i,r=1/0){const n=sn(t),s=sn(e);if(r!==1/0&&an(n,s,i)>=r)return r;if(Ir(n,s)){if(fn(t,e))return 0}else if(fn(e,t))return 0;let o=1/0;for(const r of t)for(let t=0,n=r.length,s=n-1;t<n;s=t++){const n=r[s],a=r[t];for(const t of e)for(let e=0,r=t.length,s=r-1;e<r;s=e++){const r=t[s],l=t[e];if(Er(n,a,r,l))return 0;o=Math.min(o,cn(n,a,r,l,i))}}return o}function _n(t,e,i,r,n,s){if(!s)return;const o=an(nn(r,s),n,i);o<e&&t.push([o,s,[0,0]])}function gn(t,e,i,r,n,s,o){if(!s||!o)return;const a=an(nn(r,s),nn(n,o),i);a<e&&t.push([a,s,o])}function yn(t,e,i,r,n=1/0){let s=Math.min(r.distance(t[0],i[0][0]),n);if(0===s)return s;const o=new Ur([[0,[0,t.length-1],[0,0]]],Qr),a=sn(i);for(;o.length>0;){const n=o.pop();if(n[0]>=s)continue;const l=n[1],c=e?50:100;if(tn(l)<=c){if(!en(l,t.length))return NaN;if(e){const e=dn(t,l,i,r);if(isNaN(e)||0===e)return e;s=Math.min(s,e)}else for(let e=l[0];e<=l[1];++e){const n=pn(t[e],i,r);if(s=Math.min(s,n),0===s)return 0}}else{const i=rn(l,e);_n(o,s,r,t,a,i[0]),_n(o,s,r,t,a,i[1])}}return s}function xn(t,e,i,r,n,s=1/0){let o=Math.min(s,n.distance(t[0],i[0]));if(0===o)return o;const a=new Ur([[0,[0,t.length-1],[0,i.length-1]]],Qr);for(;a.length>0;){const s=a.pop();if(s[0]>=o)continue;const l=s[1],c=s[2],h=e?50:100,u=r?50:100;if(tn(l)<=h&&tn(c)<=u){if(!en(l,t.length)&&en(c,i.length))return NaN;let s;if(e&&r)s=hn(t,l,i,c,n),o=Math.min(o,s);else if(e&&!r){const e=t.slice(l[0],l[1]+1);for(let t=c[0];t<=c[1];++t)if(s=ln(i[t],e,n),o=Math.min(o,s),0===o)return o}else if(!e&&r){const e=i.slice(c[0],c[1]+1);for(let i=l[0];i<=l[1];++i)if(s=ln(t[i],e,n),o=Math.min(o,s),0===o)return o}else s=un(t,l,i,c,n),o=Math.min(o,s)}else{const s=rn(l,e),h=rn(c,r);gn(a,o,n,t,i,s[0],h[0]),gn(a,o,n,t,i,s[0],h[1]),gn(a,o,n,t,i,s[1],h[0]),gn(a,o,n,t,i,s[1],h[1])}}return o}function vn(t){return"MultiPolygon"===t.type?t.coordinates.map((t=>({type:"Polygon",coordinates:t}))):"MultiLineString"===t.type?t.coordinates.map((t=>({type:"LineString",coordinates:t}))):"MultiPoint"===t.type?t.coordinates.map((t=>({type:"Point",coordinates:t}))):[t]}class bn{constructor(t,e){this.type=Re,this.geojson=t,this.geometries=e}static parse(t,e){if(2!==t.length)return e.error(`'distance' expression requires exactly one argument, but found ${t.length-1} instead.`);if(Di(t[1])){const e=t[1];if("FeatureCollection"===e.type)return new bn(e,e.features.map((t=>vn(t.geometry))).flat());if("Feature"===e.type)return new bn(e,vn(e.geometry));if("type"in e&&"coordinates"in e)return new bn(e,vn(e))}return e.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const i=t.geometry(),r=i.flat().map((e=>Mr([e.x,e.y],t.canonical)));if(0===i.length)return NaN;const n=new Jr(r[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,xn(r,!1,[t.coordinates],!1,n,s));break;case"LineString":s=Math.min(s,xn(r,!1,t.coordinates,!0,n,s));break;case"Polygon":s=Math.min(s,yn(r,!1,t.coordinates,n,s))}if(0===s)return s}return s}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const i=t.geometry(),r=i.flat().map((e=>Mr([e.x,e.y],t.canonical)));if(0===i.length)return NaN;const n=new Jr(r[0][1]);let s=1/0;for(const t of e){switch(t.type){case"Point":s=Math.min(s,xn(r,!0,[t.coordinates],!1,n,s));break;case"LineString":s=Math.min(s,xn(r,!0,t.coordinates,!0,n,s));break;case"Polygon":s=Math.min(s,yn(r,!0,t.coordinates,n,s))}if(0===s)return s}return s}(t,this.geometries);if("Polygon"===t.geometryType())return function(t,e){const i=t.geometry();if(0===i.length||0===i[0].length)return NaN;const r=qr(i,0).map((e=>e.map((e=>e.map((e=>Mr([e.x,e.y],t.canonical))))))),n=new Jr(r[0][0][0][1]);let s=1/0;for(const t of e)for(const e of r){switch(t.type){case"Point":s=Math.min(s,yn([t.coordinates],!1,e,n,s));break;case"LineString":s=Math.min(s,yn(t.coordinates,!0,e,n,s));break;case"Polygon":s=Math.min(s,mn(e,t.coordinates,n,s))}if(0===s)return s}return s}(t,this.geometries)}return NaN}eachChild(){}outputDefined(){return!0}}const wn={"==":pr,"!=":dr,">":mr,"<":fr,">=":gr,"<=":_r,array:Oi,at:qi,boolean:Oi,case:Ki,coalesce:lr,collator:yr,format:vr,image:br,in:Wi,"index-of":Hi,interpolate:sr,"interpolate-hcl":sr,"interpolate-lab":sr,length:wr,let:Gi,literal:Bi,match:Xi,number:Oi,"number-format":xr,object:Oi,slice:Yi,step:Qi,string:Oi,"to-boolean":Vi,"to-color":Vi,"to-number":Vi,"to-string":Vi,var:$i,within:Nr,distance:bn};class Tn{constructor(t,e,i,r){this.name=t,this.type=e,this._evaluate=i,this.args=r}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t)}outputDefined(){return!1}static parse(t,e){const i=t[0],r=Tn.definitions[i];if(!r)return e.error(`Unknown expression "${i}". If you wanted a literal array, use ["literal", [...]].`,0);const n=Array.isArray(r)?r[0]:r.type,s=Array.isArray(r)?[[r[1],r[2]]]:r.overloads,o=s.filter((([e])=>!Array.isArray(e)||e.length===t.length-1));let a=null;for(const[r,s]of o){a=new Zi(e.registry,Sn,e.path,null,e.scope);const o=[];let l=!1;for(let e=1;e<t.length;e++){const i=t[e],n=Array.isArray(r)?r[e-1]:r.type,s=a.parse(i,1+o.length,n);if(!s){l=!0;break}o.push(s)}if(!l)if(Array.isArray(r)&&r.length!==o.length)a.error(`Expected ${r.length} arguments, but found ${o.length} instead.`);else{for(let t=0;t<o.length;t++){const e=Array.isArray(r)?r[t]:r.type,i=o[t];a.concat(t+1).checkSubtype(e,i.type)}if(0===a.errors.length)return new Tn(i,n,s,o)}}if(1===o.length)e.errors.push(...a.errors);else{const i=(o.length?o:s).map((([t])=>{return e=t,Array.isArray(e)?`(${e.map(We).join(", ")})`:`(${We(e.type)}...)`;var e})).join(" | "),r=[];for(let i=1;i<t.length;i++){const n=e.parse(t[i],1+r.length);if(!n)return null;r.push(We(n.type))}e.error(`Expected arguments of type ${i}, but found (${r.join(", ")}) instead.`)}return null}static register(t,e){Tn.definitions=e;for(const i in e)t[i]=Tn}}function Pn(t,[e,i,r,n]){e=e.evaluate(t),i=i.evaluate(t),r=r.evaluate(t);const s=n?n.evaluate(t):1,o=ki(e,i,r,s);if(o)throw new Ii(o);return new bi(e/255,i/255,r/255,s,!1)}function Mn(t,e){return t in e}function Cn(t,e){const i=e[t];return void 0===i?null:i}function In(t){return{type:t}}function Sn(t){if(t instanceof $i)return Sn(t.boundExpression);if(t instanceof Tn&&"error"===t.name)return!1;if(t instanceof yr)return!1;if(t instanceof Nr)return!1;if(t instanceof bn)return!1;const e=t instanceof Vi||t instanceof Oi;let i=!0;return t.eachChild((t=>{i=e?i&&Sn(t):i&&t instanceof Bi})),!!i&&En(t)&&zn(t,["zoom","heatmap-density","line-progress","accumulated","is-supported-script"])}function En(t){if(t instanceof Tn){if("get"===t.name&&1===t.args.length)return!1;if("feature-state"===t.name)return!1;if("has"===t.name&&1===t.args.length)return!1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return!1;if(/^filter-/.test(t.name))return!1}if(t instanceof Nr)return!1;if(t instanceof bn)return!1;let e=!0;return t.eachChild((t=>{e&&!En(t)&&(e=!1)})),e}function An(t){if(t instanceof Tn&&"feature-state"===t.name)return!1;let e=!0;return t.eachChild((t=>{e&&!An(t)&&(e=!1)})),e}function zn(t,e){if(t instanceof Tn&&e.indexOf(t.name)>=0)return!1;let i=!0;return t.eachChild((t=>{i&&!zn(t,e)&&(i=!1)})),i}function kn(t){return{result:"success",value:t}}function Dn(t){return{result:"error",value:t}}function Rn(t){return"data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function Ln(t){return!!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function Bn(t){return!!t.expression&&t.expression.interpolated}function Fn(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function On(t){return"object"==typeof t&&null!==t&&!Array.isArray(t)}function jn(t){return t}function Vn(t,e){const i="color"===e.type,r=t.stops&&"object"==typeof t.stops[0][0],n=r||!(r||void 0!==t.property),s=t.type||(Bn(e)?"exponential":"interval");if(i||"padding"===e.type){const r=i?bi.parse:Ci.parse;(t=Ae({},t)).stops&&(t.stops=t.stops.map((t=>[t[0],r(t[1])]))),t.default=r(t.default?t.default:e.default)}if(t.colorSpace&&"rgb"!==(o=t.colorSpace)&&"hcl"!==o&&"lab"!==o)throw new Error(`Unknown color space: "${t.colorSpace}"`);var o;let a,l,c;if("exponential"===s)a=Gn;else if("interval"===s)a=Zn;else if("categorical"===s){a=Un,l=Object.create(null);for(const e of t.stops)l[e[0]]=e[1];c=typeof t.stops[0][0]}else{if("identity"!==s)throw new Error(`Unknown function type "${s}"`);a=$n}if(r){const i={},r=[];for(let e=0;e<t.stops.length;e++){const n=t.stops[e],s=n[0].zoom;void 0===i[s]&&(i[s]={zoom:s,type:t.type,property:t.property,default:t.default,stops:[]},r.push(s)),i[s].stops.push([n[0].value,n[1]])}const n=[];for(const t of r)n.push([i[t].zoom,Vn(i[t],e)]);const s={name:"linear"};return{kind:"composite",interpolationType:s,interpolationFactor:sr.interpolationFactor.bind(void 0,s),zoomStops:n.map((t=>t[0])),evaluate:({zoom:i},r)=>Gn({stops:n,base:t.base},e,i).evaluate(i,r)}}if(n){const i="exponential"===s?{name:"exponential",base:void 0!==t.base?t.base:1}:null;return{kind:"camera",interpolationType:i,interpolationFactor:sr.interpolationFactor.bind(void 0,i),zoomStops:t.stops.map((t=>t[0])),evaluate:({zoom:i})=>a(t,e,i,l,c)}}return{kind:"source",evaluate(i,r){const n=r&&r.properties?r.properties[t.property]:void 0;return void 0===n?Nn(t.default,e.default):a(t,e,n,l,c)}}}function Nn(t,e,i){return void 0!==t?t:void 0!==e?e:void 0!==i?i:void 0}function Un(t,e,i,r,n){return Nn(typeof i===n?r[i]:void 0,t.default,e.default)}function Zn(t,e,i){if("number"!==Fn(i))return Nn(t.default,e.default);const r=t.stops.length;if(1===r)return t.stops[0][1];if(i<=t.stops[0][0])return t.stops[0][1];if(i>=t.stops[r-1][0])return t.stops[r-1][1];const n=Ji(t.stops.map((t=>t[0])),i);return t.stops[n][1]}function Gn(t,e,i){const r=void 0!==t.base?t.base:1;if("number"!==Fn(i))return Nn(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(i<=t.stops[0][0])return t.stops[0][1];if(i>=t.stops[n-1][0])return t.stops[n-1][1];const s=Ji(t.stops.map((t=>t[0])),i),o=function(t,e,i,r){const n=r-i,s=t-i;return 0===n?0:1===e?s/n:(Math.pow(e,s)-1)/(Math.pow(e,n)-1)}(i,r,t.stops[s][0],t.stops[s+1][0]),a=t.stops[s][1],l=t.stops[s+1][1],c=ar[e.type]||jn;return"function"==typeof a.evaluate?{evaluate(...e){const i=a.evaluate.apply(void 0,e),r=l.evaluate.apply(void 0,e);if(void 0!==i&&void 0!==r)return c(i,r,o,t.colorSpace)}}:c(a,l,o,t.colorSpace)}function $n(t,e,i){switch(e.type){case"color":i=bi.parse(i);break;case"formatted":i=Mi.fromString(i.toString());break;case"resolvedImage":i=Ai.fromString(i.toString());break;case"padding":i=Ci.parse(i);break;default:Fn(i)===e.type||"enum"===e.type&&e.values[i]||(i=void 0)}return Nn(i,t.default,e.default)}Tn.register(wn,{error:[{kind:"error"},[Le],(t,[e])=>{throw new Ii(e.evaluate(t))}],typeof:[Le,[Ve],(t,[e])=>We(Ri(e.evaluate(t)))],"to-rgba":[qe(Re,4),[Fe],(t,[e])=>{const[i,r,n,s]=e.evaluate(t).rgb;return[255*i,255*r,255*n,s]}],rgb:[Fe,[Re,Re,Re],Pn],rgba:[Fe,[Re,Re,Re,Re],Pn],has:{type:Be,overloads:[[[Le],(t,[e])=>Mn(e.evaluate(t),t.properties())],[[Le,je],(t,[e,i])=>Mn(e.evaluate(t),i.evaluate(t))]]},get:{type:Ve,overloads:[[[Le],(t,[e])=>Cn(e.evaluate(t),t.properties())],[[Le,je],(t,[e,i])=>Cn(e.evaluate(t),i.evaluate(t))]]},"feature-state":[Ve,[Le],(t,[e])=>Cn(e.evaluate(t),t.featureState||{})],properties:[je,[],t=>t.properties()],"geometry-type":[Le,[],t=>t.geometryType()],id:[Ve,[],t=>t.id()],zoom:[Re,[],t=>t.globals.zoom],"heatmap-density":[Re,[],t=>t.globals.heatmapDensity||0],"line-progress":[Re,[],t=>t.globals.lineProgress||0],accumulated:[Ve,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[Re,In(Re),(t,e)=>{let i=0;for(const r of e)i+=r.evaluate(t);return i}],"*":[Re,In(Re),(t,e)=>{let i=1;for(const r of e)i*=r.evaluate(t);return i}],"-":{type:Re,overloads:[[[Re,Re],(t,[e,i])=>e.evaluate(t)-i.evaluate(t)],[[Re],(t,[e])=>-e.evaluate(t)]]},"/":[Re,[Re,Re],(t,[e,i])=>e.evaluate(t)/i.evaluate(t)],"%":[Re,[Re,Re],(t,[e,i])=>e.evaluate(t)%i.evaluate(t)],ln2:[Re,[],()=>Math.LN2],pi:[Re,[],()=>Math.PI],e:[Re,[],()=>Math.E],"^":[Re,[Re,Re],(t,[e,i])=>Math.pow(e.evaluate(t),i.evaluate(t))],sqrt:[Re,[Re],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[Re,[Re],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[Re,[Re],(t,[e])=>Math.log(e.evaluate(t))],log2:[Re,[Re],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[Re,[Re],(t,[e])=>Math.sin(e.evaluate(t))],cos:[Re,[Re],(t,[e])=>Math.cos(e.evaluate(t))],tan:[Re,[Re],(t,[e])=>Math.tan(e.evaluate(t))],asin:[Re,[Re],(t,[e])=>Math.asin(e.evaluate(t))],acos:[Re,[Re],(t,[e])=>Math.acos(e.evaluate(t))],atan:[Re,[Re],(t,[e])=>Math.atan(e.evaluate(t))],min:[Re,In(Re),(t,e)=>Math.min(...e.map((e=>e.evaluate(t))))],max:[Re,In(Re),(t,e)=>Math.max(...e.map((e=>e.evaluate(t))))],abs:[Re,[Re],(t,[e])=>Math.abs(e.evaluate(t))],round:[Re,[Re],(t,[e])=>{const i=e.evaluate(t);return i<0?-Math.round(-i):Math.round(i)}],floor:[Re,[Re],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[Re,[Re],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[Be,[Le,Ve],(t,[e,i])=>t.properties()[e.value]===i.value],"filter-id-==":[Be,[Ve],(t,[e])=>t.id()===e.value],"filter-type-==":[Be,[Le],(t,[e])=>t.geometryType()===e.value],"filter-<":[Be,[Le,Ve],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r<n}],"filter-id-<":[Be,[Ve],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i<r}],"filter->":[Be,[Le,Ve],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r>n}],"filter-id->":[Be,[Ve],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i>r}],"filter-<=":[Be,[Le,Ve],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r<=n}],"filter-id-<=":[Be,[Ve],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i<=r}],"filter->=":[Be,[Le,Ve],(t,[e,i])=>{const r=t.properties()[e.value],n=i.value;return typeof r==typeof n&&r>=n}],"filter-id->=":[Be,[Ve],(t,[e])=>{const i=t.id(),r=e.value;return typeof i==typeof r&&i>=r}],"filter-has":[Be,[Ve],(t,[e])=>e.value in t.properties()],"filter-has-id":[Be,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[Be,[qe(Le)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[Be,[qe(Ve)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[Be,[Le,qe(Ve)],(t,[e,i])=>i.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[Be,[Le,qe(Ve)],(t,[e,i])=>function(t,e,i,r){for(;i<=r;){const n=i+r>>1;if(e[n]===t)return!0;e[n]>t?r=n-1:i=n+1}return!1}(t.properties()[e.value],i.value,0,i.value.length-1)],all:{type:Be,overloads:[[[Be,Be],(t,[e,i])=>e.evaluate(t)&&i.evaluate(t)],[In(Be),(t,e)=>{for(const i of e)if(!i.evaluate(t))return!1;return!0}]]},any:{type:Be,overloads:[[[Be,Be],(t,[e,i])=>e.evaluate(t)||i.evaluate(t)],[In(Be),(t,e)=>{for(const i of e)if(i.evaluate(t))return!0;return!1}]]},"!":[Be,[Be],(t,[e])=>!e.evaluate(t)],"is-supported-script":[Be,[Le],(t,[e])=>{const i=t.globals&&t.globals.isSupportedScript;return!i||i(e.evaluate(t))}],upcase:[Le,[Le],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Le,[Le],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Le,In(Ve),(t,e)=>e.map((e=>Li(e.evaluate(t)))).join("")],"resolved-locale":[Le,[Ne],(t,[e])=>e.evaluate(t).resolvedLocale()]});class qn{constructor(t,e){var i;this.expression=t,this._warningHistory={},this._evaluator=new Ui,this._defaultValue=e?"color"===(i=e).type&&On(i.default)?new bi(0,0,0,0):"color"===i.type?bi.parse(i.default)||null:"padding"===i.type?Ci.parse(i.default)||null:"variableAnchorOffsetCollection"===i.type?Ei.parse(i.default)||null:"projectionDefinition"===i.type?zi.parse(i.default)||null:void 0===i.default?null:i.default:null,this._enumValues=e&&"enum"===e.type?e.values:null}evaluateWithoutErrorHandling(t,e,i,r,n,s){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=i,this._evaluator.canonical=r,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(t,e,i,r,n,s){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=i||null,this._evaluator.canonical=r,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new Ii(`Expected value to be one of ${Object.keys(this._enumValues).map((t=>JSON.stringify(t))).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function Wn(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in wn}function Hn(t,e){const i=new Zi(wn,Sn,[],e?function(t){const e={color:Fe,string:Le,number:Re,enum:Le,boolean:Be,formatted:Ue,padding:Ze,projectionDefinition:Oe,resolvedImage:Ge,variableAnchorOffsetCollection:$e};return"array"===t.type?qe(e[t.value]||Ve,t.length):e[t.type]}(e):void 0),r=i.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return r?kn(new qn(r,e)):Dn(i.errors)}class Xn{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!An(e.expression)}evaluateWithoutErrorHandling(t,e,i,r,n,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,i,r,n,s)}evaluate(t,e,i,r,n,s){return this._styleExpression.evaluate(t,e,i,r,n,s)}}class Kn{constructor(t,e,i,r){this.kind=t,this.zoomStops=i,this._styleExpression=e,this.isStateDependent="camera"!==t&&!An(e.expression),this.interpolationType=r}evaluateWithoutErrorHandling(t,e,i,r,n,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,i,r,n,s)}evaluate(t,e,i,r,n,s){return this._styleExpression.evaluate(t,e,i,r,n,s)}interpolationFactor(t,e,i){return this.interpolationType?sr.interpolationFactor(this.interpolationType,t,e,i):0}}function Yn(t,e){const i=Hn(t,e);if("error"===i.result)return i;const r=i.value.expression,n=En(r);if(!n&&!Rn(e))return Dn([new ze("","data expressions not supported")]);const s=zn(r,["zoom"]);if(!s&&!Ln(e))return Dn([new ze("","zoom expressions not supported")]);const o=Qn(r);return o||s?o instanceof ze?Dn([o]):o instanceof sr&&!Bn(e)?Dn([new ze("",'"interpolate" expressions cannot be used with this property')]):kn(o?new Kn(n?"camera":"composite",i.value,o.labels,o instanceof sr?o.interpolation:void 0):new Xn(n?"constant":"source",i.value)):Dn([new ze("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class Jn{constructor(t,e){this._parameters=t,this._specification=e,Ae(this,Vn(this._parameters,this._specification))}static deserialize(t){return new Jn(t._parameters,t._specification)}static serialize(t){return{_parameters:t._parameters,_specification:t._specification}}}function Qn(t){let e=null;if(t instanceof Gi)e=Qn(t.result);else if(t instanceof lr){for(const i of t.args)if(e=Qn(i),e)break}else(t instanceof Qi||t instanceof sr)&&t.input instanceof Tn&&"zoom"===t.input.name&&(e=t);return e instanceof ze||t.eachChild((t=>{const i=Qn(t);i instanceof ze?e=i:!e&&i?e=new ze("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):e&&i&&e!==i&&(e=new ze("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'))})),e}function ts(t){if(!0===t||!1===t)return!0;if(!Array.isArray(t)||0===t.length)return!1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return!1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!ts(e)&&"boolean"!=typeof e)return!1;return!0;default:return!0}}const es={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function is(t){if(null==t)return{filter:()=>!0,needGeometry:!1};ts(t)||(t=ss(t));const e=Hn(t,es);if("error"===e.result)throw new Error(e.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return{filter:(t,i,r)=>e.value.evaluate(t,i,{},r),needGeometry:ns(t)}}function rs(t,e){return t<e?-1:t>e?1:0}function ns(t){if(!Array.isArray(t))return!1;if("within"===t[0]||"distance"===t[0])return!0;for(let e=1;e<t.length;e++)if(ns(t[e]))return!0;return!1}function ss(t){if(!t)return!0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?os(t[1],t[2],"=="):"!="===e?cs(os(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?os(t[1],t[2],e):"any"===e?(i=t.slice(1),["any"].concat(i.map(ss))):"all"===e?["all"].concat(t.slice(1).map(ss)):"none"===e?["all"].concat(t.slice(1).map(ss).map(cs)):"in"===e?as(t[1],t.slice(2)):"!in"===e?cs(as(t[1],t.slice(2))):"has"===e?ls(t[1]):"!has"!==e||cs(ls(t[1]));var i}function os(t,e,i){switch(t){case"$type":return[`filter-type-${i}`,e];case"$id":return[`filter-id-${i}`,e];default:return[`filter-${i}`,t,e]}}function as(t,e){if(0===e.length)return!1;switch(t){case"$type":return["filter-type-in",["literal",e]];case"$id":return["filter-id-in",["literal",e]];default:return e.length>200&&!e.some((t=>typeof t!=typeof e[0]))?["filter-in-large",t,["literal",e.sort(rs)]]:["filter-in-small",t,["literal",e]]}}function ls(t){switch(t){case"$type":return!0;case"$id":return["filter-has-id"];default:return["filter-has",t]}}function cs(t){return["!",t]}function hs(t){const e=t.value;return e?[new Ee(t.key,e,"constants have been deprecated as of v8")]:[]}function us(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function ps(t){if(Array.isArray(t))return t.map(ps);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const i in t)e[i]=ps(t[i]);return e}return us(t)}function ds(t){const e=t.key,i=t.value,r=t.valueSpec||{},n=t.objectElementValidators||{},s=t.style,o=t.styleSpec,a=t.validateSpec;let l=[];const c=Fn(i);if("object"!==c)return[new Ee(e,i,`object expected, ${c} found`)];for(const t in i){const c=t.split(".")[0],h=r[c]||r["*"];let u;if(n[c])u=n[c];else if(r[c])u=a;else if(n["*"])u=n["*"];else{if(!r["*"]){l.push(new Ee(e,i[t],`unknown property "${t}"`));continue}u=a}l=l.concat(u({key:(e?`${e}.`:e)+t,value:i[t],valueSpec:h,style:s,styleSpec:o,object:i,objectKey:t,validateSpec:a},i))}for(const t in r)n[t]||r[t].required&&void 0===r[t].default&&void 0===i[t]&&l.push(new Ee(e,i,`missing required property "${t}"`));return l}function fs(t){const e=t.value,i=t.valueSpec,r=t.style,n=t.styleSpec,s=t.key,o=t.arrayElementValidator||t.validateSpec;if("array"!==Fn(e))return[new Ee(s,e,`array expected, ${Fn(e)} found`)];if(i.length&&e.length!==i.length)return[new Ee(s,e,`array length ${i.length} expected, length ${e.length} found`)];if(i["min-length"]&&e.length<i["min-length"])return[new Ee(s,e,`array length at least ${i["min-length"]} expected, length ${e.length} found`)];let a={type:i.value,values:i.values};n.$version<7&&(a.function=i.function),"object"===Fn(i.value)&&(a=i.value);let l=[];for(let i=0;i<e.length;i++)l=l.concat(o({array:e,arrayIndex:i,value:e[i],valueSpec:a,validateSpec:t.validateSpec,style:r,styleSpec:n,key:`${s}[${i}]`}));return l}function ms(t){const e=t.key,i=t.value,r=t.valueSpec;let n=Fn(i);return"number"===n&&i!=i&&(n="NaN"),"number"!==n?[new Ee(e,i,`number expected, ${n} found`)]:"minimum"in r&&i<r.minimum?[new Ee(e,i,`${i} is less than the minimum value ${r.minimum}`)]:"maximum"in r&&i>r.maximum?[new Ee(e,i,`${i} is greater than the maximum value ${r.maximum}`)]:[]}function _s(t){const e=t.valueSpec,i=us(t.value.type);let r,n,s,o={};const a="categorical"!==i&&void 0===t.value.property,l=!a,c="array"===Fn(t.value.stops)&&"array"===Fn(t.value.stops[0])&&"object"===Fn(t.value.stops[0][0]),h=ds({key:t.key,value:t.value,valueSpec:t.styleSpec.function,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===i)return[new Ee(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const r=t.value;return e=e.concat(fs({key:t.key,value:r,valueSpec:t.valueSpec,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:u})),"array"===Fn(r)&&0===r.length&&e.push(new Ee(t.key,r,"array must have at least one stop")),e},default:function(t){return t.validateSpec({key:t.key,value:t.value,valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec})}}});return"identity"===i&&a&&h.push(new Ee(t.key,t.value,'missing required property "property"')),"identity"===i||t.value.stops||h.push(new Ee(t.key,t.value,'missing required property "stops"')),"exponential"===i&&t.valueSpec.expression&&!Bn(t.valueSpec)&&h.push(new Ee(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!Rn(t.valueSpec)?h.push(new Ee(t.key,t.value,"property functions not supported")):a&&!Ln(t.valueSpec)&&h.push(new Ee(t.key,t.value,"zoom functions not supported"))),"categorical"!==i&&!c||void 0!==t.value.property||h.push(new Ee(t.key,t.value,'"property" property is required')),h;function u(t){let i=[];const r=t.value,a=t.key;if("array"!==Fn(r))return[new Ee(a,r,`array expected, ${Fn(r)} found`)];if(2!==r.length)return[new Ee(a,r,`array length 2 expected, length ${r.length} found`)];if(c){if("object"!==Fn(r[0]))return[new Ee(a,r,`object expected, ${Fn(r[0])} found`)];if(void 0===r[0].zoom)return[new Ee(a,r,"object stop key must have zoom")];if(void 0===r[0].value)return[new Ee(a,r,"object stop key must have value")];if(s&&s>us(r[0].zoom))return[new Ee(a,r[0].zoom,"stop zoom values must appear in ascending order")];us(r[0].zoom)!==s&&(s=us(r[0].zoom),n=void 0,o={}),i=i.concat(ds({key:`${a}[0]`,value:r[0],valueSpec:{zoom:{}},validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:ms,value:p}}))}else i=i.concat(p({key:`${a}[0]`,value:r[0],validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec},r));return Wn(ps(r[1]))?i.concat([new Ee(`${a}[1]`,r[1],"expressions are not allowed in function stops.")]):i.concat(t.validateSpec({key:`${a}[1]`,value:r[1],valueSpec:e,validateSpec:t.validateSpec,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const a=Fn(t.value),l=us(t.value),c=null!==t.value?t.value:s;if(r){if(a!==r)return[new Ee(t.key,c,`${a} stop domain type must match previous stop domain type ${r}`)]}else r=a;if("number"!==a&&"string"!==a&&"boolean"!==a)return[new Ee(t.key,c,"stop domain value must be a number, string, or boolean")];if("number"!==a&&"categorical"!==i){let r=`number expected, ${a} found`;return Rn(e)&&void 0===i&&(r+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new Ee(t.key,c,r)]}return"categorical"!==i||"number"!==a||isFinite(l)&&Math.floor(l)===l?"categorical"!==i&&"number"===a&&void 0!==n&&l<n?[new Ee(t.key,c,"stop domain values must appear in ascending order")]:(n=l,"categorical"===i&&l in o?[new Ee(t.key,c,"stop domain values must be unique")]:(o[l]=!0,[])):[new Ee(t.key,c,`integer expected, found ${l}`)]}}function gs(t){const e=("property"===t.expressionContext?Yn:Hn)(ps(t.value),t.valueSpec);if("error"===e.result)return e.value.map((e=>new Ee(`${t.key}${e.key}`,t.value,e.message)));const i=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!i.outputDefined())return[new Ee(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!An(i))return[new Ee(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!An(i))return[new Ee(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!zn(i,["zoom","feature-state"]))return[new Ee(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!En(i))return[new Ee(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return[]}function ys(t){const e=t.key,i=t.value,r=t.valueSpec,n=[];return Array.isArray(r.values)?-1===r.values.indexOf(us(i))&&n.push(new Ee(e,i,`expected one of [${r.values.join(", ")}], ${JSON.stringify(i)} found`)):-1===Object.keys(r.values).indexOf(us(i))&&n.push(new Ee(e,i,`expected one of [${Object.keys(r.values).join(", ")}], ${JSON.stringify(i)} found`)),n}function xs(t){return ts(ps(t.value))?gs(Ae({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):vs(t)}function vs(t){const e=t.value,i=t.key;if("array"!==Fn(e))return[new Ee(i,e,`array expected, ${Fn(e)} found`)];const r=t.styleSpec;let n,s=[];if(e.length<1)return[new Ee(i,e,"filter array must have at least 1 element")];switch(s=s.concat(ys({key:`${i}[0]`,value:e[0],valueSpec:r.filter_operator,style:t.style,styleSpec:t.styleSpec})),us(e[0])){case"<":case"<=":case">":case">=":e.length>=2&&"$type"===us(e[1])&&s.push(new Ee(i,e,`"$type" cannot be use with operator "${e[0]}"`));case"==":case"!=":3!==e.length&&s.push(new Ee(i,e,`filter array for operator "${e[0]}" must have 3 elements`));case"in":case"!in":e.length>=2&&(n=Fn(e[1]),"string"!==n&&s.push(new Ee(`${i}[1]`,e[1],`string expected, ${n} found`)));for(let o=2;o<e.length;o++)n=Fn(e[o]),"$type"===us(e[1])?s=s.concat(ys({key:`${i}[${o}]`,value:e[o],valueSpec:r.geometry_type,style:t.style,styleSpec:t.styleSpec})):"string"!==n&&"number"!==n&&"boolean"!==n&&s.push(new Ee(`${i}[${o}]`,e[o],`string, number, or boolean expected, ${n} found`));break;case"any":case"all":case"none":for(let r=1;r<e.length;r++)s=s.concat(vs({key:`${i}[${r}]`,value:e[r],style:t.style,styleSpec:t.styleSpec}));break;case"has":case"!has":n=Fn(e[1]),2!==e.length?s.push(new Ee(i,e,`filter array for "${e[0]}" operator must have 2 elements`)):"string"!==n&&s.push(new Ee(`${i}[1]`,e[1],`string expected, ${n} found`))}return s}function bs(t,e){const i=t.key,r=t.validateSpec,n=t.style,s=t.styleSpec,o=t.value,a=t.objectKey,l=s[`${e}_${t.layerType}`];if(!l)return[];const c=a.match(/^(.*)-transition$/);if("paint"===e&&c&&l[c[1]]&&l[c[1]].transition)return r({key:i,value:o,valueSpec:s.transition,style:n,styleSpec:s});const h=t.valueSpec||l[a];if(!h)return[new Ee(i,o,`unknown property "${a}"`)];let u;if("string"===Fn(o)&&Rn(h)&&!h.tokens&&(u=/^{([^}]+)}$/.exec(o)))return[new Ee(i,o,`"${a}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(u[1])} }\`.`)];const p=[];return"symbol"===t.layerType&&("text-field"===a&&n&&!n.glyphs&&p.push(new Ee(i,o,'use of "text-field" requires a style "glyphs" property')),"text-font"===a&&On(ps(o))&&"identity"===us(o.type)&&p.push(new Ee(i,o,'"text-font" does not support identity functions'))),p.concat(r({key:t.key,value:o,valueSpec:h,style:n,styleSpec:s,expressionContext:"property",propertyType:e,propertyKey:a}))}function ws(t){return bs(t,"paint")}function Ts(t){return bs(t,"layout")}function Ps(t){let e=[];const i=t.value,r=t.key,n=t.style,s=t.styleSpec;i.type||i.ref||e.push(new Ee(r,i,'either "type" or "ref" is required'));let o=us(i.type);const a=us(i.ref);if(i.id){const s=us(i.id);for(let o=0;o<t.arrayIndex;o++){const t=n.layers[o];us(t.id)===s&&e.push(new Ee(r,i.id,`duplicate layer id "${i.id}", previously used at line ${t.id.__line__}`))}}if("ref"in i){let t;["type","source","source-layer","filter","layout"].forEach((t=>{t in i&&e.push(new Ee(r,i[t],`"${t}" is prohibited for ref layers`))})),n.layers.forEach((e=>{us(e.id)===a&&(t=e)})),t?t.ref?e.push(new Ee(r,i.ref,"ref cannot reference another ref layer")):o=us(t.type):e.push(new Ee(r,i.ref,`ref layer "${a}" not found`))}else if("background"!==o)if(i.source){const t=n.sources&&n.sources[i.source],s=t&&us(t.type);t?"vector"===s&&"raster"===o?e.push(new Ee(r,i.source,`layer "${i.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===o?e.push(new Ee(r,i.source,`layer "${i.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==o?e.push(new Ee(r,i.source,`layer "${i.id}" requires a vector source`)):"vector"!==s||i["source-layer"]?"raster-dem"===s&&"hillshade"!==o?e.push(new Ee(r,i.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==o||!i.paint||!i.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new Ee(r,i,`layer "${i.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new Ee(r,i,`layer "${i.id}" must specify a "source-layer"`)):e.push(new Ee(r,i.source,`source "${i.source}" not found`))}else e.push(new Ee(r,i,'missing required property "source"'));return e=e.concat(ds({key:r,value:i,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":()=>[],type:()=>t.validateSpec({key:`${r}.type`,value:i.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,object:i,objectKey:"type"}),filter:xs,layout:t=>ds({layer:i,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>Ts(Ae({layerType:o},t))}}),paint:t=>ds({layer:i,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,validateSpec:t.validateSpec,objectElementValidators:{"*":t=>ws(Ae({layerType:o},t))}})}})),e}function Ms(t){const e=t.value,i=t.key,r=Fn(e);return"string"!==r?[new Ee(i,e,`string expected, ${r} found`)]:[]}const Cs={promoteId:function({key:t,value:e}){if("string"===Fn(e))return Ms({key:t,value:e});{const i=[];for(const r in e)i.push(...Ms({key:`${t}.${r}`,value:e[r]}));return i}}};function Is(t){const e=t.value,i=t.key,r=t.styleSpec,n=t.style,s=t.validateSpec;if(!e.type)return[new Ee(i,e,'"type" is required')];const o=us(e.type);let a;switch(o){case"vector":case"raster":return a=ds({key:i,value:e,valueSpec:r[`source_${o.replace("-","_")}`],style:t.style,styleSpec:r,objectElementValidators:Cs,validateSpec:s}),a;case"raster-dem":return a=function(t){var e;const i=null!==(e=t.sourceName)&&void 0!==e?e:"",r=t.value,n=t.styleSpec,s=n.source_raster_dem,o=t.style;let a=[];const l=Fn(r);if(void 0===r)return a;if("object"!==l)return a.push(new Ee("source_raster_dem",r,`object expected, ${l} found`)),a;const c="custom"===us(r.encoding),h=["redFactor","greenFactor","blueFactor","baseShift"],u=t.value.encoding?`"${t.value.encoding}"`:"Default";for(const e in r)!c&&h.includes(e)?a.push(new Ee(e,r[e],`In "${i}": "${e}" is only valid when "encoding" is set to "custom". ${u} encoding found`)):s[e]?a=a.concat(t.validateSpec({key:e,value:r[e],valueSpec:s[e],validateSpec:t.validateSpec,style:o,styleSpec:n})):a.push(new Ee(e,r[e],`unknown property "${e}"`));return a}({sourceName:i,value:e,style:t.style,styleSpec:r,validateSpec:s}),a;case"geojson":if(a=ds({key:i,value:e,valueSpec:r.source_geojson,style:n,styleSpec:r,validateSpec:s,objectElementValidators:Cs}),e.cluster)for(const t in e.clusterProperties){const[r,n]=e.clusterProperties[t],s="string"==typeof r?[r,["accumulated"],["get",t]]:r;a.push(...gs({key:`${i}.${t}.map`,value:n,expressionContext:"cluster-map"})),a.push(...gs({key:`${i}.${t}.reduce`,value:s,expressionContext:"cluster-reduce"}))}return a;case"video":return ds({key:i,value:e,valueSpec:r.source_video,style:n,validateSpec:s,styleSpec:r});case"image":return ds({key:i,value:e,valueSpec:r.source_image,style:n,validateSpec:s,styleSpec:r});case"canvas":return[new Ee(i,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return ys({key:`${i}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]}})}}function Ss(t){const e=t.value,i=t.styleSpec,r=i.light,n=t.style;let s=[];const o=Fn(e);if(void 0===e)return s;if("object"!==o)return s=s.concat([new Ee("light",e,`object expected, ${o} found`)]),s;for(const o in e){const a=o.match(/^(.*)-transition$/);s=s.concat(a&&r[a[1]]&&r[a[1]].transition?t.validateSpec({key:o,value:e[o],valueSpec:i.transition,validateSpec:t.validateSpec,style:n,styleSpec:i}):r[o]?t.validateSpec({key:o,value:e[o],valueSpec:r[o],validateSpec:t.validateSpec,style:n,styleSpec:i}):[new Ee(o,e[o],`unknown property "${o}"`)])}return s}function Es(t){const e=t.value,i=t.styleSpec,r=i.sky,n=t.style,s=Fn(e);if(void 0===e)return[];if("object"!==s)return[new Ee("sky",e,`object expected, ${s} found`)];let o=[];for(const s in e)o=o.concat(r[s]?t.validateSpec({key:s,value:e[s],valueSpec:r[s],style:n,styleSpec:i}):[new Ee(s,e[s],`unknown property "${s}"`)]);return o}function As(t){const e=t.value,i=t.styleSpec,r=i.terrain,n=t.style;let s=[];const o=Fn(e);if(void 0===e)return s;if("object"!==o)return s=s.concat([new Ee("terrain",e,`object expected, ${o} found`)]),s;for(const o in e)s=s.concat(r[o]?t.validateSpec({key:o,value:e[o],valueSpec:r[o],validateSpec:t.validateSpec,style:n,styleSpec:i}):[new Ee(o,e[o],`unknown property "${o}"`)]);return s}function zs(t){let e=[];const i=t.value,r=t.key;if(Array.isArray(i)){const n=[],s=[];for(const o in i)i[o].id&&n.includes(i[o].id)&&e.push(new Ee(r,i,`all the sprites' ids must be unique, but ${i[o].id} is duplicated`)),n.push(i[o].id),i[o].url&&s.includes(i[o].url)&&e.push(new Ee(r,i,`all the sprites' URLs must be unique, but ${i[o].url} is duplicated`)),s.push(i[o].url),e=e.concat(ds({key:`${r}[${o}]`,value:i[o],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:t.validateSpec}));return e}return Ms({key:r,value:i})}const ks={"*":()=>[],array:fs,boolean:function(t){const e=t.value,i=t.key,r=Fn(e);return"boolean"!==r?[new Ee(i,e,`boolean expected, ${r} found`)]:[]},number:ms,color:function(t){const e=t.key,i=t.value,r=Fn(i);return"string"!==r?[new Ee(e,i,`color expected, ${r} found`)]:bi.parse(String(i))?[]:[new Ee(e,i,`color expected, "${i}" found`)]},constants:hs,enum:ys,filter:xs,function:_s,layer:Ps,object:ds,source:Is,light:Ss,sky:Es,terrain:As,projection:function(t){const e=t.value,i=t.styleSpec,r=i.projection,n=t.style,s=Fn(e);if(void 0===e)return[];if("object"!==s)return[new Ee("projection",e,`object expected, ${s} found`)];let o=[];for(const s in e)o=o.concat(r[s]?t.validateSpec({key:s,value:e[s],valueSpec:r[s],style:n,styleSpec:i}):[new Ee(s,e[s],`unknown property "${s}"`)]);return o},projectionDefinition:function(t){const e=t.key;let i=t.value;i=i instanceof String?i.valueOf():i;const r=Fn(i);return"array"!==r||function(t){return Array.isArray(t)&&3===t.length&&"string"==typeof t[0]&&"string"==typeof t[1]&&"number"==typeof t[2]}(i)||function(t){return!!["interpolate","step","literal"].includes(t[0])}(i)?["array","string"].includes(r)?[]:[new Ee(e,i,`projection expected, invalid type "${r}" found`)]:[new Ee(e,i,`projection expected, invalid array ${JSON.stringify(i)} found`)]},string:Ms,formatted:function(t){return 0===Ms(t).length?[]:gs(t)},resolvedImage:function(t){return 0===Ms(t).length?[]:gs(t)},padding:function(t){const e=t.key,i=t.value;if("array"===Fn(i)){if(i.length<1||i.length>4)return[new Ee(e,i,`padding requires 1 to 4 values; ${i.length} values found`)];const r={type:"number"};let n=[];for(let s=0;s<i.length;s++)n=n.concat(t.validateSpec({key:`${e}[${s}]`,value:i[s],validateSpec:t.validateSpec,valueSpec:r}));return n}return ms({key:e,value:i,valueSpec:{}})},variableAnchorOffsetCollection:function(t){const e=t.key,i=t.value,r=Fn(i),n=t.styleSpec;if("array"!==r||i.length<1||i.length%2!=0)return[new Ee(e,i,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let r=0;r<i.length;r+=2)s=s.concat(ys({key:`${e}[${r}]`,value:i[r],valueSpec:n.layout_symbol["text-anchor"]})),s=s.concat(fs({key:`${e}[${r+1}]`,value:i[r+1],valueSpec:{length:2,value:"number"},validateSpec:t.validateSpec,style:t.style,styleSpec:n}));return s},sprite:zs};function Ds(t){const e=t.value,i=t.valueSpec,r=t.styleSpec;return t.validateSpec=Ds,i.expression&&On(us(e))?_s(t):i.expression&&Wn(ps(e))?gs(t):i.type&&ks[i.type]?ks[i.type](t):ds(Ae({},t,{valueSpec:i.type?r[i.type]:i}))}function Rs(t){const e=t.value,i=t.key,r=Ms(t);return r.length||(-1===e.indexOf("{fontstack}")&&r.push(new Ee(i,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&r.push(new Ee(i,e,'"glyphs" url must include a "{range}" token'))),r}function Ls(t,e=_e){let i=[];return i=i.concat(Ds({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,validateSpec:Ds,objectElementValidators:{glyphs:Rs,"*":()=>[]}})),t.constants&&(i=i.concat(hs({key:"constants",value:t.constants}))),Fs(i)}function Bs(t){return function(e){return t({...e,validateSpec:Ds})}}function Fs(t){return[].concat(t).sort(((t,e)=>t.line-e.line))}function Os(t){return function(...e){return Fs(t.apply(this,e))}}Ls.source=Os(Bs(Is)),Ls.sprite=Os(Bs(zs)),Ls.glyphs=Os(Bs(Rs)),Ls.light=Os(Bs(Ss)),Ls.sky=Os(Bs(Es)),Ls.terrain=Os(Bs(As)),Ls.layer=Os(Bs(Ps)),Ls.filter=Os(Bs(xs)),Ls.paintProperty=Os(Bs(ws)),Ls.layoutProperty=Os(Bs(Ts));const js=Ls,Vs=js.light,Ns=js.sky,Us=js.paintProperty,Zs=js.layoutProperty;function Gs(t,e){let i=!1;if(e&&e.length)for(const r of e)t.fire(new fe(new Error(r.message))),i=!0;return i}class $s{constructor(t,e,i){const r=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;const n=new Int32Array(this.arrayBuffer);t=n[0],this.d=(e=n[1])+2*(i=n[2]);for(let t=0;t<this.d*this.d;t++){const e=n[3+t],i=n[3+t+1];r.push(e===i?null:n.subarray(e,i))}const s=n[3+r.length+1];this.keys=n.subarray(n[3+r.length],s),this.bboxes=n.subarray(s),this.insert=this._insertReadonly}else{this.d=e+2*i;for(let t=0;t<this.d*this.d;t++)r.push([]);this.keys=[],this.bboxes=[]}this.n=e,this.extent=t,this.padding=i,this.scale=e/t,this.uid=0;const n=i/e*t;this.min=-n,this.max=t+n}insert(t,e,i,r,n){this._forEachCell(e,i,r,n,this._insertCell,this.uid++,void 0,void 0),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(t,e,i,r,n,s){this.cells[n].push(s)}query(t,e,i,r,n){const s=this.min,o=this.max;if(t<=s&&e<=s&&o<=i&&o<=r&&!n)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(t,e,i,r,this._queryCell,s,{},n),s}}_queryCell(t,e,i,r,n,s,o,a){const l=this.cells[n];if(null!==l){const n=this.keys,c=this.bboxes;for(let h=0;h<l.length;h++){const u=l[h];if(void 0===o[u]){const l=4*u;(a?a(c[l+0],c[l+1],c[l+2],c[l+3]):t<=c[l+2]&&e<=c[l+3]&&i>=c[l+0]&&r>=c[l+1])?(o[u]=!0,s.push(n[u])):o[u]=!1}}}}_forEachCell(t,e,i,r,n,s,o,a){const l=this._convertToCellCoord(t),c=this._convertToCellCoord(e),h=this._convertToCellCoord(i),u=this._convertToCellCoord(r);for(let p=l;p<=h;p++)for(let l=c;l<=u;l++){const c=this.d*l+p;if((!a||a(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&n.call(this,t,e,i,r,c,s,o,a))return}}_convertFromCellCoord(t){return(t-this.padding)/this.scale}_convertToCellCoord(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const t=this.cells,e=3+this.cells.length+1+1;let i=0;for(let t=0;t<this.cells.length;t++)i+=this.cells[t].length;const r=new Int32Array(e+i+this.keys.length+this.bboxes.length);r[0]=this.extent,r[1]=this.n,r[2]=this.padding;let n=e;for(let e=0;e<t.length;e++){const i=t[e];r[3+e]=n,r.set(i,n),n+=i.length}return r[3+t.length]=n,r.set(this.keys,n),n+=this.keys.length,r[3+t.length+1]=n,r.set(this.bboxes,n),n+=this.bboxes.length,r.buffer}static serialize(t,e){const i=t.toArrayBuffer();return e&&e.push(i),{buffer:i}}static deserialize(t){return new $s(t.buffer)}}const qs={};function Ws(t,e,i={}){if(qs[t])throw new Error(`${t} is already registered.`);Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),qs[t]={klass:e,omit:i.omit||[],shallow:i.shallow||[]}}Ws("Object",Object),Ws("TransferableGridIndex",$s),Ws("Color",bi),Ws("Error",Error),Ws("AJAXError",Jt),Ws("ResolvedImage",Ai),Ws("StylePropertyFunction",Jn),Ws("StyleExpression",qn,{omit:["_evaluator"]}),Ws("ZoomDependentExpression",Kn),Ws("ZoomConstantExpression",Xn),Ws("CompoundExpression",Tn,{omit:["_evaluate"]});for(const t in wn)wn[t]._classRegistryKey||Ws(`Expression_${t}`,wn[t]);function Hs(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function Xs(t){return t.$name||t.constructor._classRegistryKey}function Ks(t){return!function(t){if(null===t||"object"!=typeof t)return!1;const e=Xs(t);return!(!e||"Object"===e)}(t)&&(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||t instanceof Blob||t instanceof Error||Hs(t)||Rt(t)||ArrayBuffer.isView(t)||t instanceof ImageData)}function Ys(t,e){if(Ks(t))return(Hs(t)||Rt(t))&&e&&e.push(t),ArrayBuffer.isView(t)&&e&&e.push(t.buffer),t instanceof ImageData&&e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const i=[];for(const r of t)i.push(Ys(r,e));return i}if("object"!=typeof t)throw new Error("can't serialize object of type "+typeof t);const i=Xs(t);if(!i)throw new Error(`can't serialize object of unregistered class ${t.constructor.name}`);if(!qs[i])throw new Error(`${i} is not registered.`);const{klass:r}=qs[i],n=r.serialize?r.serialize(t,e):{};if(r.serialize){if(e&&n===e[e.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else{for(const r in t){if(!t.hasOwnProperty(r))continue;if(qs[i].omit.indexOf(r)>=0)continue;const s=t[r];n[r]=qs[i].shallow.indexOf(r)>=0?s:Ys(s,e)}t instanceof Error&&(n.message=t.message)}if(n.$name)throw new Error("$name property is reserved for worker serialization logic.");return"Object"!==i&&(n.$name=i),n}function Js(t){if(Ks(t))return t;if(Array.isArray(t))return t.map(Js);if("object"!=typeof t)throw new Error("can't deserialize object of type "+typeof t);const e=Xs(t)||"Object";if(!qs[e])throw new Error(`can't deserialize unregistered class ${e}`);const{klass:i}=qs[e];if(!i)throw new Error(`can't deserialize unregistered class ${e}`);if(i.deserialize)return i.deserialize(t);const r=Object.create(i.prototype);for(const i of Object.keys(t)){if("$name"===i)continue;const n=t[i];r[i]=qs[e].shallow.indexOf(i)>=0?n:Js(n)}return r}class Qs{constructor(){this.first=!0}update(t,e){const i=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=i,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=i,!0):(this.lastFloorZoom>i?(this.lastIntegerZoom=i+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<i&&(this.lastIntegerZoom=i,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=i,!0))}}const to={"Latin-1 Supplement":t=>t>=128&&t<=255,"Hangul Jamo":t=>t>=4352&&t<=4607,Khmer:t=>t>=6016&&t<=6143,"General Punctuation":t=>t>=8192&&t<=8303,"Letterlike Symbols":t=>t>=8448&&t<=8527,"Number Forms":t=>t>=8528&&t<=8591,"Miscellaneous Technical":t=>t>=8960&&t<=9215,"Control Pictures":t=>t>=9216&&t<=9279,"Optical Character Recognition":t=>t>=9280&&t<=9311,"Enclosed Alphanumerics":t=>t>=9312&&t<=9471,"Geometric Shapes":t=>t>=9632&&t<=9727,"Miscellaneous Symbols":t=>t>=9728&&t<=9983,"Miscellaneous Symbols and Arrows":t=>t>=11008&&t<=11263,"Ideographic Description Characters":t=>t>=12272&&t<=12287,"CJK Symbols and Punctuation":t=>t>=12288&&t<=12351,Hiragana:t=>t>=12352&&t<=12447,Katakana:t=>t>=12448&&t<=12543,Kanbun:t=>t>=12688&&t<=12703,"CJK Strokes":t=>t>=12736&&t<=12783,"Enclosed CJK Letters and Months":t=>t>=12800&&t<=13055,"CJK Compatibility":t=>t>=13056&&t<=13311,"Yijing Hexagram Symbols":t=>t>=19904&&t<=19967,"CJK Unified Ideographs":t=>t>=19968&&t<=40959,"Hangul Syllables":t=>t>=44032&&t<=55215,"Private Use Area":t=>t>=57344&&t<=63743,"Vertical Forms":t=>t>=65040&&t<=65055,"CJK Compatibility Forms":t=>t>=65072&&t<=65103,"Small Form Variants":t=>t>=65104&&t<=65135,"Halfwidth and Fullwidth Forms":t=>t>=65280&&t<=65519};function eo(t){for(const e of t)if(no(e.charCodeAt(0)))return!0;return!1}function io(t){const e=t.map((t=>{try{return new RegExp(`\\p{sc=${t}}`,"u").source}catch(t){return null}})).filter((t=>t));return new RegExp(e.join("|"),"u")}io(["Arab","Dupl","Mong","Ougr","Syrc"]);const ro=io(["Bopo","Hani","Hira","Kana","Kits","Nshu","Tang","Yiii"]);function no(t){return!(746!==t&&747!==t&&(t<4352||!(to["CJK Compatibility Forms"](t)&&!(t>=65097&&t<=65103)||to["CJK Compatibility"](t)||to["CJK Strokes"](t)||!(!to["CJK Symbols and Punctuation"](t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||to["Enclosed CJK Letters and Months"](t)||to["Ideographic Description Characters"](t)||to.Kanbun(t)||to.Katakana(t)&&12540!==t||!(!to["Halfwidth and Fullwidth Forms"](t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!to["Small Form Variants"](t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||to["Vertical Forms"](t)||to["Yijing Hexagram Symbols"](t)||/\p{sc=Cans}/u.test(String.fromCodePoint(t))||/\p{sc=Hang}/u.test(String.fromCodePoint(t))||ro.test(String.fromCodePoint(t)))))}const so=io(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function oo(t){return so.test(String.fromCodePoint(t))}function ao(t,e){return!(!e&&oo(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||to.Khmer(t))}function lo(t){for(const e of t)if(oo(e.charCodeAt(0)))return!0;return!1}const co=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{}}setState(t){this.pluginStatus=t.pluginStatus,this.pluginURL=t.pluginURL}getState(){return{pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(t){if(co.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=t.applyArabicShaping,this.processBidirectionalText=t.processBidirectionalText,this.processStyledBidirectionalText=t.processStyledBidirectionalText,this.loadScriptResolve()}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getRTLTextPluginStatus(){return this.pluginStatus}syncState(t,e){return n(this,void 0,void 0,(function*(){if(this.isParsed())return this.getState();if("loading"!==t.pluginStatus)return this.setState(t),t;const i=t.pluginURL,r=new Promise((t=>{this.loadScriptResolve=t}));e(i);const n=new Promise((t=>setTimeout((()=>t()),this.TIMEOUT)));if(yield Promise.race([r,n]),this.isParsed()){const t={pluginStatus:"loaded",pluginURL:i};return this.setState(t),t}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${i}`)}))}};class ho{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.zoomHistory=e.zoomHistory,this.transition=e.transition):(this.now=0,this.fadeDuration=0,this.zoomHistory=new Qs,this.transition={})}isSupportedScript(t){return function(t,e){for(const i of t)if(!ao(i.charCodeAt(0),e))return!1;return!0}(t,"loaded"===co.getRTLTextPluginStatus())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),i=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*i}:{fromScale:.5,toScale:1,t:1-(1-i)*e}}}class uo{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(On(t))return new Jn(t,e);if(Wn(t)){const i=Yn(t,e);if("error"===i.result)throw new Error(i.value.map((t=>`${t.key}: ${t.message}`)).join(", "));return i.value}{let i=t;return"color"===e.type&&"string"==typeof t?i=bi.parse(t):"padding"!==e.type||"number"!=typeof t&&!Array.isArray(t)?"variableAnchorOffsetCollection"===e.type&&Array.isArray(t)?i=Ei.parse(t):"projectionDefinition"===e.type&&"string"==typeof t&&(i=zi.parse(t)):i=Ci.parse(t),{kind:"constant",evaluate:()=>i}}}(void 0===e?t.specification.default:e,t.specification)}isDataDriven(){return"source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,i){return this.property.possiblyEvaluate(this,t,e,i)}}class po{constructor(t){this.property=t,this.value=new uo(t,void 0)}transitioned(t,e){return new mo(this.property,this.value,e,xt({},t.transition,this.transition),t.now)}untransitioned(){return new mo(this.property,this.value,null,{},0)}}class fo{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues)}getValue(t){return St(this._values[t].value.value)}setValue(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new po(this._values[t].property)),this._values[t].value=new uo(this._values[t].property,null===e?void 0:St(e))}getTransition(t){return St(this._values[t].transition)}setTransition(t,e){Object.prototype.hasOwnProperty.call(this._values,t)||(this._values[t]=new po(this._values[t].property)),this._values[t].transition=St(e)||void 0}serialize(){const t={};for(const e of Object.keys(this._values)){const i=this.getValue(e);void 0!==i&&(t[e]=i);const r=this.getTransition(e);void 0!==r&&(t[`${e}-transition`]=r)}return t}transitioned(t,e){const i=new _o(this._properties);for(const r of Object.keys(this._values))i._values[r]=this._values[r].transitioned(t,e._values[r]);return i}untransitioned(){const t=new _o(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class mo{constructor(t,e,i,r,n){this.property=t,this.value=e,this.begin=n+r.delay||0,this.end=this.begin+r.duration||0,t.specification.transition&&(r.delay||r.duration)&&(this.prior=i)}possiblyEvaluate(t,e,i){const r=t.now||0,n=this.value.possiblyEvaluate(t,e,i),s=this.prior;if(s){if(r>this.end)return this.prior=null,n;if(this.value.isDataDriven())return this.prior=null,n;if(r<this.begin)return s.possiblyEvaluate(t,e,i);{const o=(r-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,i),n,ft(o))}}return n}}class _o{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues)}possiblyEvaluate(t,e,i){const r=new xo(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(t,e,i);return r}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return!0;return!1}}class go{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues)}hasValue(t){return void 0!==this._values[t].value}getValue(t){return St(this._values[t].value)}setValue(t,e){this._values[t]=new uo(this._values[t].property,null===e?void 0:St(e))}serialize(){const t={};for(const e of Object.keys(this._values)){const i=this.getValue(e);void 0!==i&&(t[e]=i)}return t}possiblyEvaluate(t,e,i){const r=new xo(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(t,e,i);return r}}class yo{constructor(t,e,i){this.property=t,this.value=e,this.parameters=i}isConstant(){return"constant"===this.value.kind}constantOr(t){return"constant"===this.value.kind?this.value.value:t}evaluate(t,e,i,r){return this.property.evaluate(this.value,this.parameters,t,e,i,r)}}class xo{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues)}get(t){return this._values[t]}}class vo{constructor(t){this.specification=t}possiblyEvaluate(t,e){if(t.isDataDriven())throw new Error("Value should not be data driven");return t.expression.evaluate(e)}interpolate(t,e,i){const r=ar[this.specification.type];return r?r(t,e,i):t}}class bo{constructor(t,e){this.specification=t,this.overrides=e}possiblyEvaluate(t,e,i,r){return new yo(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},i,r)}:t.expression,e)}interpolate(t,e,i){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new yo(this,{kind:"constant",value:void 0},t.parameters);const r=ar[this.specification.type];if(r){const n=r(t.value.value,e.value.value,i);return new yo(this,{kind:"constant",value:n},t.parameters)}return t}evaluate(t,e,i,r,n,s){return"constant"===t.kind?t.value:t.evaluate(e,i,r,n,s)}}class wo extends bo{possiblyEvaluate(t,e,i,r){if(void 0===t.value)return new yo(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const n=t.expression.evaluate(e,null,{},i,r),s="resolvedImage"===t.property.specification.type&&"string"!=typeof n?n.name:n,o=this._calculate(s,s,s,e);return new yo(this,{kind:"constant",value:o},e)}if("camera"===t.expression.kind){const i=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new yo(this,{kind:"constant",value:i},e)}return new yo(this,t.expression,e)}evaluate(t,e,i,r,n,s){if("source"===t.kind){const o=t.evaluate(e,i,r,n,s);return this._calculate(o,o,o,e)}return"composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},i,r),t.evaluate({zoom:Math.floor(e.zoom)},i,r),t.evaluate({zoom:Math.floor(e.zoom)+1},i,r),e):t.value}_calculate(t,e,i,r){return r.zoom>r.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:i,to:e}}interpolate(t){return t}}class To{constructor(t){this.specification=t}possiblyEvaluate(t,e,i,r){if(void 0!==t.value){if("constant"===t.expression.kind){const n=t.expression.evaluate(e,null,{},i,r);return this._calculate(n,n,n,e)}return this._calculate(t.expression.evaluate(new ho(Math.floor(e.zoom-1),e)),t.expression.evaluate(new ho(Math.floor(e.zoom),e)),t.expression.evaluate(new ho(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,i,r){return r.zoom>r.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:i,to:e}}interpolate(t){return t}}class Po{constructor(t){this.specification=t}possiblyEvaluate(t,e,i,r){return!!t.expression.evaluate(e,null,{},i,r)}interpolate(){return!1}}class Mo{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const i=t[e];i.specification.overridable&&this.overridableProperties.push(e);const r=this.defaultPropertyValues[e]=new uo(i,void 0),n=this.defaultTransitionablePropertyValues[e]=new po(i);this.defaultTransitioningPropertyValues[e]=n.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=r.possiblyEvaluate({})}}}Ws("DataDrivenProperty",bo),Ws("DataConstantProperty",vo),Ws("CrossFadedDataDrivenProperty",wo),Ws("CrossFadedProperty",To),Ws("ColorRampProperty",Po);const Co="-transition";class Io extends me{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1},"custom"!==t.type&&(this.metadata=t.metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter),e.layout&&(this._unevaluatedLayout=new go(e.layout)),e.paint)){this._transitionablePaint=new fo(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new xo(e.paint)}}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return"visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e,i={}){null!=e&&this._validate(Zs,`layers.${this.id}.layout.${t}`,t,e,i)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e)}getPaintProperty(t){return t.endsWith(Co)?this._transitionablePaint.getTransition(t.slice(0,-11)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,i={}){if(null!=e&&this._validate(Us,`layers.${this.id}.paint.${t}`,t,e,i))return!1;if(t.endsWith(Co))return this._transitionablePaint.setTransition(t.slice(0,-11),e||void 0),!1;{const i=this._transitionablePaint._values[t],r="cross-faded-data-driven"===i.property.specification["property-type"],n=i.value.isDataDriven(),s=i.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const o=this._transitionablePaint._values[t].value;return o.isDataDriven()||n||r||this._handleOverridablePaintPropertyUpdate(t,s,o)}}_handleSpecialPaintPropertyUpdate(t){}_handleOverridablePaintPropertyUpdate(t,e,i){return!1}isHidden(t){return!!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint)}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e)}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),Ct(t,((t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length)))}_validate(t,e,i,r,n={}){return(!n||!1!==n.validate)&&Gs(this,t.call(js,{key:e,layerType:this.type,objectKey:i,value:r,styleSpec:_e,style:{glyphs:!0,sprite:!0}}))}is3D(){return!1}isTileClipped(){return!1}hasOffscreenPass(){return!1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof yo&&Rn(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return!0}return!1}}const So={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class Eo{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8}}class Ao{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0)}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews())}clear(){this.length=0}resize(t){this.reserve(t),this.length=t}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e)}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function zo(t,e=1){let i=0,r=0;return{members:t.map((t=>{const n=So[t.type].BYTES_PER_ELEMENT,s=i=ko(i,Math.max(e,n)),o=t.components||1;return r=Math.max(r,n),i+=n*o,{name:t.name,type:t.type,components:o,offset:s}})),size:ko(i,Math.max(r,e)),alignment:e}}function ko(t,e){return Math.ceil(t/e)*e}class Do extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.int16[r+0]=e,this.int16[r+1]=i,t}}Do.prototype.bytesPerElement=4,Ws("StructArrayLayout2i4",Do);class Ro extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.int16[n+0]=e,this.int16[n+1]=i,this.int16[n+2]=r,t}}Ro.prototype.bytesPerElement=6,Ws("StructArrayLayout3i6",Ro);class Lo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,i,r)}emplace(t,e,i,r,n){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=i,this.int16[s+2]=r,this.int16[s+3]=n,t}}Lo.prototype.bytesPerElement=8,Ws("StructArrayLayout4i8",Lo);class Bo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,i,r,n,s)}emplace(t,e,i,r,n,s,o){const a=6*t;return this.int16[a+0]=e,this.int16[a+1]=i,this.int16[a+2]=r,this.int16[a+3]=n,this.int16[a+4]=s,this.int16[a+5]=o,t}}Bo.prototype.bytesPerElement=12,Ws("StructArrayLayout2i4i12",Bo);class Fo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,i,r,n,s)}emplace(t,e,i,r,n,s,o){const a=4*t,l=8*t;return this.int16[a+0]=e,this.int16[a+1]=i,this.uint8[l+4]=r,this.uint8[l+5]=n,this.uint8[l+6]=s,this.uint8[l+7]=o,t}}Fo.prototype.bytesPerElement=8,Ws("StructArrayLayout2i4ub8",Fo);class Oo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.float32[r+0]=e,this.float32[r+1]=i,t}}Oo.prototype.bytesPerElement=8,Ws("StructArrayLayout2f8",Oo);class jo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l,c){const h=this.length;return this.resize(h+1),this.emplace(h,t,e,i,r,n,s,o,a,l,c)}emplace(t,e,i,r,n,s,o,a,l,c,h){const u=10*t;return this.uint16[u+0]=e,this.uint16[u+1]=i,this.uint16[u+2]=r,this.uint16[u+3]=n,this.uint16[u+4]=s,this.uint16[u+5]=o,this.uint16[u+6]=a,this.uint16[u+7]=l,this.uint16[u+8]=c,this.uint16[u+9]=h,t}}jo.prototype.bytesPerElement=20,Ws("StructArrayLayout10ui20",jo);class Vo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l,c,h,u){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,i,r,n,s,o,a,l,c,h,u)}emplace(t,e,i,r,n,s,o,a,l,c,h,u,p){const d=12*t;return this.int16[d+0]=e,this.int16[d+1]=i,this.int16[d+2]=r,this.int16[d+3]=n,this.uint16[d+4]=s,this.uint16[d+5]=o,this.uint16[d+6]=a,this.uint16[d+7]=l,this.int16[d+8]=c,this.int16[d+9]=h,this.int16[d+10]=u,this.int16[d+11]=p,t}}Vo.prototype.bytesPerElement=24,Ws("StructArrayLayout4i4ui4i24",Vo);class No extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.float32[n+0]=e,this.float32[n+1]=i,this.float32[n+2]=r,t}}No.prototype.bytesPerElement=12,Ws("StructArrayLayout3f12",No);class Uo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}Uo.prototype.bytesPerElement=4,Ws("StructArrayLayout1ul4",Uo);class Zo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,i,r,n,s,o,a,l)}emplace(t,e,i,r,n,s,o,a,l,c){const h=10*t,u=5*t;return this.int16[h+0]=e,this.int16[h+1]=i,this.int16[h+2]=r,this.int16[h+3]=n,this.int16[h+4]=s,this.int16[h+5]=o,this.uint32[u+3]=a,this.uint16[h+8]=l,this.uint16[h+9]=c,t}}Zo.prototype.bytesPerElement=20,Ws("StructArrayLayout6i1ul2ui20",Zo);class Go extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,i,r,n,s)}emplace(t,e,i,r,n,s,o){const a=6*t;return this.int16[a+0]=e,this.int16[a+1]=i,this.int16[a+2]=r,this.int16[a+3]=n,this.int16[a+4]=s,this.int16[a+5]=o,t}}Go.prototype.bytesPerElement=12,Ws("StructArrayLayout2i2i2i12",Go);class $o extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,i,r,n)}emplace(t,e,i,r,n,s){const o=4*t,a=8*t;return this.float32[o+0]=e,this.float32[o+1]=i,this.float32[o+2]=r,this.int16[a+6]=n,this.int16[a+7]=s,t}}$o.prototype.bytesPerElement=16,Ws("StructArrayLayout2f1f2i16",$o);class qo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,i,r,n,s)}emplace(t,e,i,r,n,s,o){const a=16*t,l=4*t,c=8*t;return this.uint8[a+0]=e,this.uint8[a+1]=i,this.float32[l+1]=r,this.float32[l+2]=n,this.int16[c+6]=s,this.int16[c+7]=o,t}}qo.prototype.bytesPerElement=16,Ws("StructArrayLayout2ub2f2i16",qo);class Wo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.uint16[n+0]=e,this.uint16[n+1]=i,this.uint16[n+2]=r,t}}Wo.prototype.bytesPerElement=6,Ws("StructArrayLayout3ui6",Wo);class Ho extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_)}emplace(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g){const y=24*t,x=12*t,v=48*t;return this.int16[y+0]=e,this.int16[y+1]=i,this.uint16[y+2]=r,this.uint16[y+3]=n,this.uint32[x+2]=s,this.uint32[x+3]=o,this.uint32[x+4]=a,this.uint16[y+10]=l,this.uint16[y+11]=c,this.uint16[y+12]=h,this.float32[x+7]=u,this.float32[x+8]=p,this.uint8[v+36]=d,this.uint8[v+37]=f,this.uint8[v+38]=m,this.uint32[x+10]=_,this.int16[y+22]=g,t}}Ho.prototype.bytesPerElement=48,Ws("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",Ho);class Xo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x,v,b,w,T,P,M,C,I){const S=this.length;return this.resize(S+1),this.emplace(S,t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x,v,b,w,T,P,M,C,I)}emplace(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x,v,b,w,T,P,M,C,I,S){const E=32*t,A=16*t;return this.int16[E+0]=e,this.int16[E+1]=i,this.int16[E+2]=r,this.int16[E+3]=n,this.int16[E+4]=s,this.int16[E+5]=o,this.int16[E+6]=a,this.int16[E+7]=l,this.uint16[E+8]=c,this.uint16[E+9]=h,this.uint16[E+10]=u,this.uint16[E+11]=p,this.uint16[E+12]=d,this.uint16[E+13]=f,this.uint16[E+14]=m,this.uint16[E+15]=_,this.uint16[E+16]=g,this.uint16[E+17]=y,this.uint16[E+18]=x,this.uint16[E+19]=v,this.uint16[E+20]=b,this.uint16[E+21]=w,this.uint16[E+22]=T,this.uint32[A+12]=P,this.float32[A+13]=M,this.float32[A+14]=C,this.uint16[E+30]=I,this.uint16[E+31]=S,t}}Xo.prototype.bytesPerElement=64,Ws("StructArrayLayout8i15ui1ul2f2ui64",Xo);class Ko extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}Ko.prototype.bytesPerElement=4,Ws("StructArrayLayout1f4",Ko);class Yo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=3*t;return this.uint16[6*t+0]=e,this.float32[n+1]=i,this.float32[n+2]=r,t}}Yo.prototype.bytesPerElement=12,Ws("StructArrayLayout1ui2f12",Yo);class Jo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e,i){const r=this.length;return this.resize(r+1),this.emplace(r,t,e,i)}emplace(t,e,i,r){const n=4*t;return this.uint32[2*t+0]=e,this.uint16[n+2]=i,this.uint16[n+3]=r,t}}Jo.prototype.bytesPerElement=8,Ws("StructArrayLayout1ul2ui8",Jo);class Qo extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t,e){const i=this.length;return this.resize(i+1),this.emplace(i,t,e)}emplace(t,e,i){const r=2*t;return this.uint16[r+0]=e,this.uint16[r+1]=i,t}}Qo.prototype.bytesPerElement=4,Ws("StructArrayLayout2ui4",Qo);class ta extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}ta.prototype.bytesPerElement=2,Ws("StructArrayLayout1ui2",ta);class ea extends Ao{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(t,e,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,i,r)}emplace(t,e,i,r,n){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=i,this.float32[s+2]=r,this.float32[s+3]=n,t}}ea.prototype.bytesPerElement=16,Ws("StructArrayLayout4f16",ea);class ia extends Eo{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new c(this.anchorPointX,this.anchorPointY)}}ia.prototype.size=20;class ra extends Zo{get(t){return new ia(this,t)}}Ws("CollisionBoxArray",ra);class na extends Eo{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}na.prototype.size=48;class sa extends Ho{get(t){return new na(this,t)}}Ws("PlacedSymbolArray",sa);class oa extends Eo{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}oa.prototype.size=64;class aa extends Xo{get(t){return new oa(this,t)}}Ws("SymbolInstanceArray",aa);class la extends Ko{getoffsetX(t){return this.float32[1*t+0]}}Ws("GlyphOffsetArray",la);class ca extends Ro{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}Ws("SymbolLineVertexArray",ca);class ha extends Eo{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}ha.prototype.size=12;class ua extends Yo{get(t){return new ha(this,t)}}Ws("TextAnchorOffsetArray",ua);class pa extends Eo{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}pa.prototype.size=8;class da extends Jo{get(t){return new pa(this,t)}}Ws("FeatureIndexArray",da);class fa extends Do{}class ma extends Ro{}class _a extends Lo{}class ga extends Do{}class ya extends Do{}class xa extends Bo{}class va extends Fo{}class ba extends Oo{}class wa extends jo{}class Ta extends Vo{}class Pa extends No{}class Ma extends Uo{}class Ca extends Go{}class Ia extends $o{}class Sa extends qo{}class Ea extends Wo{}class Aa extends Wo{}class za extends Qo{}class ka extends ta{}const Da=zo([{name:"a_pos",components:2,type:"Int16"}],4),{members:Ra}=Da;class La{constructor(t=[]){this._forceNewSegmentOnNextPrepare=!1,this.segments=t}prepareSegment(t,e,i,r){const n=this.segments[this.segments.length-1];return t>La.MAX_VERTEX_ARRAY_LENGTH&&At(`Max vertices per segment is ${La.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${La.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!n||n.vertexLength+t>La.MAX_VERTEX_ARRAY_LENGTH||n.sortKey!==r?this.createNewSegment(e,i,r):n}createNewSegment(t,e,i){const r={vertexOffset:t.length,primitiveOffset:e.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==i&&(r.sortKey=i),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(r),r}getOrCreateLatestSegment(t,e,i){return this.prepareSegment(0,t,e,i)}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy()}static simpleSegment(t,e,i,r){return new La([{vertexOffset:t,primitiveOffset:e,vertexLength:i,primitiveLength:r,vaos:{},sortKey:0}])}}function Ba(t,e){return 256*(t=gt(Math.floor(t),0,255))+gt(Math.floor(e),0,255)}La.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,Ws("SegmentVector",La);const Fa=zo([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]);var Oa,ja,Va,Na={exports:{}},Ua={exports:{}},Za={exports:{}},Ga=function(){if(Va)return Na.exports;Va=1;var t=(Oa||(Oa=1,function(t){t.exports=function(t,e){var i,r,n,s,o,a,l,c;for(r=t.length-(i=3&t.length),n=e,o=3432918353,a=461845907,c=0;c<r;)l=255&t.charCodeAt(c)|(255&t.charCodeAt(++c))<<8|(255&t.charCodeAt(++c))<<16|(255&t.charCodeAt(++c))<<24,++c,n=27492+(65535&(s=5*(65535&(n=(n^=l=(65535&(l=(l=(65535&l)*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<13|n>>>19))+((5*(n>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,i){case 3:l^=(255&t.charCodeAt(c+2))<<16;case 2:l^=(255&t.charCodeAt(c+1))<<8;case 1:n^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(c)))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295}return n^=t.length,n=2246822507*(65535&(n^=n>>>16))+((2246822507*(n>>>16)&65535)<<16)&4294967295,n=3266489909*(65535&(n^=n>>>13))+((3266489909*(n>>>16)&65535)<<16)&4294967295,(n^=n>>>16)>>>0}}(Ua)),Ua.exports),e=(ja||(ja=1,function(t){t.exports=function(t,e){for(var i,r=t.length,n=e^r,s=0;r>=4;)i=1540483477*(65535&(i=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(i>>>16)&65535)<<16),n=1540483477*(65535&n)+((1540483477*(n>>>16)&65535)<<16)^(i=1540483477*(65535&(i^=i>>>24))+((1540483477*(i>>>16)&65535)<<16)),r-=4,++s;switch(r){case 3:n^=(255&t.charCodeAt(s+2))<<16;case 2:n^=(255&t.charCodeAt(s+1))<<8;case 1:n=1540483477*(65535&(n^=255&t.charCodeAt(s)))+((1540483477*(n>>>16)&65535)<<16)}return n=1540483477*(65535&(n^=n>>>13))+((1540483477*(n>>>16)&65535)<<16),(n^=n>>>15)>>>0}}(Za)),Za.exports);return Na.exports=t,Na.exports.murmur3=t,Na.exports.murmur2=e,Na.exports}(),$a=s(Ga);class qa{constructor(){this.ids=[],this.positions=[],this.indexed=!1}add(t,e,i,r){this.ids.push(Wa(t)),this.positions.push(e,i,r)}getPositions(t){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const e=Wa(t);let i=0,r=this.ids.length-1;for(;i<r;){const t=i+r>>1;this.ids[t]>=e?r=t:i=t+1}const n=[];for(;this.ids[i]===e;)n.push({index:this.positions[3*i],start:this.positions[3*i+1],end:this.positions[3*i+2]}),i++;return n}static serialize(t,e){const i=new Float64Array(t.ids),r=new Uint32Array(t.positions);return Ha(i,r,0,i.length-1),e&&e.push(i.buffer,r.buffer),{ids:i,positions:r}}static deserialize(t){const e=new qa;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function Wa(t){const e=+t;return!isNaN(e)&&e<=Number.MAX_SAFE_INTEGER?e:$a(String(t))}function Ha(t,e,i,r){for(;i<r;){const n=t[i+r>>1];let s=i-1,o=r+1;for(;;){do{s++}while(t[s]<n);do{o--}while(t[o]>n);if(s>=o)break;Xa(t,s,o),Xa(e,3*s,3*o),Xa(e,3*s+1,3*o+1),Xa(e,3*s+2,3*o+2)}o-i<r-o?(Ha(t,e,i,o),i=o+1):(Ha(t,e,o+1,r),r=o)}}function Xa(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}Ws("FeaturePositionMap",qa);class Ka{constructor(t,e){this.gl=t.gl,this.location=e}}class Ya extends Ka{constructor(t,e){super(t,e),this.current=0}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t))}}class Ja extends Ka{constructor(t,e){super(t,e),this.current=0}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t))}}class Qa extends Ka{constructor(t,e){super(t,e),this.current=[0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]))}}class tl extends Ka{constructor(t,e){super(t,e),this.current=[0,0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]))}}class el extends Ka{constructor(t,e){super(t,e),this.current=[0,0,0,0]}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]))}}class il extends Ka{constructor(t,e){super(t,e),this.current=bi.transparent}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a))}}const rl=new Float32Array(16);class nl extends Ka{constructor(t,e){super(t,e),this.current=rl}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}}function sl(t){return[Ba(255*t.r,255*t.g),Ba(255*t.b,255*t.a)]}class ol{constructor(t,e,i){this.value=t,this.uniformNames=e.map((t=>`u_${t}`)),this.type=i}setUniform(t,e,i){t.set(i.constantOr(this.value))}getBinding(t,e,i){return"color"===this.type?new il(t,e):new Ja(t,e)}}class al{constructor(t,e){this.uniformNames=e.map((t=>`u_${t}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr}setUniform(t,e,i,r){const n="u_pattern_to"===r?this.patternTo:"u_pattern_from"===r?this.patternFrom:"u_pixel_ratio_to"===r?this.pixelRatioTo:"u_pixel_ratio_from"===r?this.pixelRatioFrom:null;n&&t.set(n)}getBinding(t,e,i){return"u_pattern"===i.substr(0,9)?new el(t,e):new Ja(t,e)}}class ll{constructor(t,e,i,r){this.expression=t,this.type=i,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===i?2:1,offset:0}))),this.paintVertexArray=new r}populatePaintArray(t,e,i,r,n){const s=this.paintVertexArray.length,o=this.expression.evaluate(new ho(0),e,{},r,[],n);this.paintVertexArray.resize(t),this._setPaintValue(s,t,o)}updatePaintArray(t,e,i,r){const n=this.expression.evaluate({zoom:0},i,r);this._setPaintValue(t,e,n)}_setPaintValue(t,e,i){if("color"===this.type){const r=sl(i);for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r[0],r[1])}else{for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i);this.maxValue=Math.max(this.maxValue,Math.abs(i))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class cl{constructor(t,e,i,r,n,s){this.expression=t,this.uniformNames=e.map((t=>`u_${t}_t`)),this.type=i,this.useIntegerZoom=r,this.zoom=n,this.maxValue=0,this.paintVertexAttributes=e.map((t=>({name:`a_${t}`,type:"Float32",components:"color"===i?4:2,offset:0}))),this.paintVertexArray=new s}populatePaintArray(t,e,i,r,n){const s=this.expression.evaluate(new ho(this.zoom),e,{},r,[],n),o=this.expression.evaluate(new ho(this.zoom+1),e,{},r,[],n),a=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(a,t,s,o)}updatePaintArray(t,e,i,r){const n=this.expression.evaluate({zoom:this.zoom},i,r),s=this.expression.evaluate({zoom:this.zoom+1},i,r);this._setPaintValue(t,e,n,s)}_setPaintValue(t,e,i,r){if("color"===this.type){const n=sl(i),s=sl(r);for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,n[0],n[1],s[0],s[1])}else{for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,i,r);this.maxValue=Math.max(this.maxValue,Math.abs(i),Math.abs(r))}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}setUniform(t,e){const i=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,r=gt(this.expression.interpolationFactor(i,this.zoom,this.zoom+1),0,1);t.set(r)}getBinding(t,e,i){return new Ja(t,e)}}class hl{constructor(t,e,i,r,n,s){this.expression=t,this.type=e,this.useIntegerZoom=i,this.zoom=r,this.layerId=s,this.zoomInPaintVertexArray=new n,this.zoomOutPaintVertexArray=new n}populatePaintArray(t,e,i){const r=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(r,t,e.patterns&&e.patterns[this.layerId],i)}updatePaintArray(t,e,i,r,n){this._setPaintValues(t,e,i.patterns&&i.patterns[this.layerId],n)}_setPaintValues(t,e,i,r){if(!r||!i)return;const{min:n,mid:s,max:o}=i,a=r[n],l=r[s],c=r[o];if(a&&l&&c)for(let i=t;i<e;i++)this.zoomInPaintVertexArray.emplace(i,l.tl[0],l.tl[1],l.br[0],l.br[1],a.tl[0],a.tl[1],a.br[0],a.br[1],l.pixelRatio,a.pixelRatio),this.zoomOutPaintVertexArray.emplace(i,l.tl[0],l.tl[1],l.br[0],l.br[1],c.tl[0],c.tl[1],c.br[0],c.br[1],l.pixelRatio,c.pixelRatio)}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,Fa.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,Fa.members,this.expression.isStateDependent))}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy()}}class ul{constructor(t,e,i){this.binders={},this._buffers=[];const r=[];for(const n in t.paint._values){if(!i(n))continue;const s=t.paint.get(n);if(!(s instanceof yo&&Rn(s.property.specification)))continue;const o=dl(n,t.type),a=s.value,l=s.property.specification.type,c=s.property.useIntegerZoom,h=s.property.specification["property-type"],u="cross-faded"===h||"cross-faded-data-driven"===h;if("constant"===a.kind)this.binders[n]=u?new al(a.value,o):new ol(a.value,o,l),r.push(`/u_${n}`);else if("source"===a.kind||u){const i=fl(n,l,"source");this.binders[n]=u?new hl(a,l,c,e,i,t.id):new ll(a,o,l,i),r.push(`/a_${n}`)}else{const t=fl(n,l,"composite");this.binders[n]=new cl(a,o,l,c,e,t),r.push(`/z_${n}`)}}this.cacheKey=r.sort().join("")}getMaxValue(t){const e=this.binders[t];return e instanceof ll||e instanceof cl?e.maxValue:0}populatePaintArrays(t,e,i,r,n){for(const s in this.binders){const o=this.binders[s];(o instanceof ll||o instanceof cl||o instanceof hl)&&o.populatePaintArray(t,e,i,r,n)}}setConstantPatternPositions(t,e){for(const i in this.binders){const r=this.binders[i];r instanceof al&&r.setConstantPatternPositions(t,e)}}updatePaintArrays(t,e,i,r,n){let s=!1;for(const o in t){const a=e.getPositions(o);for(const e of a){const a=i.feature(e.index);for(const i in this.binders){const l=this.binders[i];if((l instanceof ll||l instanceof cl||l instanceof hl)&&!0===l.expression.isStateDependent){const c=r.paint.get(i);l.expression=c.value,l.updatePaintArray(e.start,e.end,a,t[o],n),s=!0}}}}return s}defines(){const t=[];for(const e in this.binders){const i=this.binders[e];(i instanceof ol||i instanceof al)&&t.push(...i.uniformNames.map((t=>`#define HAS_UNIFORM_${t}`)))}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const i=this.binders[e];if(i instanceof ll||i instanceof cl)for(let e=0;e<i.paintVertexAttributes.length;e++)t.push(i.paintVertexAttributes[e].name);else if(i instanceof hl)for(let e=0;e<Fa.members.length;e++)t.push(Fa.members[e].name)}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const i=this.binders[e];if(i instanceof ol||i instanceof al||i instanceof cl)for(const e of i.uniformNames)t.push(e)}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const i=[];for(const r in this.binders){const n=this.binders[r];if(n instanceof ol||n instanceof al||n instanceof cl)for(const s of n.uniformNames)if(e[s]){const o=n.getBinding(t,e[s],s);i.push({name:s,property:r,binding:o})}}return i}setUniforms(t,e,i,r){for(const{name:t,property:n,binding:s}of e)this.binders[n].setUniform(s,r,i.get(n),t)}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const i=this.binders[e];if(t&&i instanceof hl){const e=2===t.fromScale?i.zoomInPaintVertexBuffer:i.zoomOutPaintVertexBuffer;e&&this._buffers.push(e)}else(i instanceof ll||i instanceof cl)&&i.paintVertexBuffer&&this._buffers.push(i.paintVertexBuffer)}}upload(t){for(const e in this.binders){const i=this.binders[e];(i instanceof ll||i instanceof cl||i instanceof hl)&&i.upload(t)}this.updatePaintBuffers()}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof ll||e instanceof cl||e instanceof hl)&&e.destroy()}}}class pl{constructor(t,e,i=(()=>!0)){this.programConfigurations={};for(const r of t)this.programConfigurations[r.id]=new ul(r,e,i);this.needsUpload=!1,this._featureMap=new qa,this._bufferOffset=0}populatePaintArrays(t,e,i,r,n,s){for(const i in this.programConfigurations)this.programConfigurations[i].populatePaintArrays(t,e,r,n,s);void 0!==e.id&&this._featureMap.add(e.id,i,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0}updatePaintArrays(t,e,i,r){for(const n of i)this.needsUpload=this.programConfigurations[n.id].updatePaintArrays(t,this._featureMap,e,n,r)||this.needsUpload}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy()}}function dl(t,e){return{"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function fl(t,e,i){const r={color:{source:Oo,composite:ea},number:{source:Ko,composite:Oo}},n=function(t){return{"line-pattern":{source:wa,composite:wa},"fill-pattern":{source:wa,composite:wa},"fill-extrusion-pattern":{source:wa,composite:wa}}[t]}(t);return n&&n[i]||r[e][i]}Ws("ConstantBinder",ol),Ws("CrossFadedConstantBinder",al),Ws("SourceExpressionBinder",ll),Ws("CrossFadedCompositeBinder",hl),Ws("CompositeExpressionBinder",cl),Ws("ProgramConfiguration",ul,{omit:["_buffers"]}),Ws("ProgramConfigurationSet",pl);const ml=Math.pow(2,14)-1,_l=-ml-1;function gl(t){const e=J/t.extent,i=t.loadGeometry();for(let t=0;t<i.length;t++){const r=i[t];for(let t=0;t<r.length;t++){const i=r[t],n=Math.round(i.x*e),s=Math.round(i.y*e);i.x=gt(n,_l,ml),i.y=gt(s,_l,ml),(n<i.x||n>i.x+1||s<i.y||s>i.y+1)&&At("Geometry exceeds allowed extent, reduce your vector tile buffer size")}}return i}function yl(t,e){return{type:t.type,id:t.id,properties:t.properties,geometry:e?gl(t):[]}}const xl=-32768;function vl(t,e,i,r,n){t.emplaceBack(xl+8*e+r,xl+8*i+n)}class bl{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new ga,this.indexArray=new Aa,this.segments=new La,this.programConfigurations=new pl(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){const r=this.layers[0],n=[];let s=null,o=!1,a="heatmap"===r.type;if("circle"===r.type){const t=r;s=t.layout.get("circle-sort-key"),o=!s.isConstant(),a=a||"map"===t.paint.get("circle-pitch-alignment")}const l=a?e.subdivisionGranularity.circle:1;for(const{feature:e,id:r,index:a,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,c=yl(e,t);if(!this.layers[0]._featureFilter.filter(new ho(this.zoom),c,i))continue;const h=o?s.evaluate(c,{},i):void 0,u={id:r,properties:e.properties,type:e.type,sourceLayerIndex:l,index:a,geometry:t?c.geometry:gl(e),patterns:{},sortKey:h};n.push(u)}o&&n.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of n){const{geometry:n,index:s,sourceLayerIndex:o}=r,a=t[s].feature;this.addFeature(r,n,s,i,l),e.featureIndex.insert(a,n,s,o,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,i)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Ra),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}addFeature(t,e,i,r,n=1){let s;switch(n){case 1:s=[0,7];break;case 3:s=[0,2,5,7];break;case 5:s=[0,1,3,4,6,7];break;case 7:s=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${n}; valid values are 1, 3, 5, 7.`)}const o=s.length;for(const i of e)for(const e of i){const i=e.x,r=e.y;if(i<0||i>=J||r<0||r>=J)continue;const n=this.segments.prepareSegment(o*o,this.layoutVertexArray,this.indexArray,t.sortKey),a=n.vertexLength;for(let t=0;t<o;t++)for(let e=0;e<o;e++)vl(this.layoutVertexArray,i,r,s[e],s[t]);for(let t=0;t<o-1;t++)for(let e=0;e<o-1;e++){const i=a+t*o+e,r=a+(t+1)*o+e;this.indexArray.emplaceBack(i,r+1,i+1),this.indexArray.emplaceBack(i,r,r+1)}n.vertexLength+=o*o,n.primitiveLength+=(o-1)*(o-1)*2}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,{},r)}}function wl(t,e){for(let i=0;i<t.length;i++)if(zl(e,t[i]))return!0;for(let i=0;i<e.length;i++)if(zl(t,e[i]))return!0;return!!Cl(t,e)}function Tl(t,e,i){return!!zl(t,e)||!!Sl(e,t,i)}function Pl(t,e){if(1===t.length)return Al(e,t[0]);for(let i=0;i<e.length;i++){const r=e[i];for(let e=0;e<r.length;e++)if(zl(t,r[e]))return!0}for(let i=0;i<t.length;i++)if(Al(e,t[i]))return!0;for(let i=0;i<e.length;i++)if(Cl(t,e[i]))return!0;return!1}function Ml(t,e,i){if(t.length>1){if(Cl(t,e))return!0;for(let r=0;r<e.length;r++)if(Sl(e[r],t,i))return!0}for(let r=0;r<t.length;r++)if(Sl(t[r],e,i))return!0;return!1}function Cl(t,e){if(0===t.length||0===e.length)return!1;for(let i=0;i<t.length-1;i++){const r=t[i],n=t[i+1];for(let t=0;t<e.length-1;t++)if(Il(r,n,e[t],e[t+1]))return!0}return!1}function Il(t,e,i,r){return zt(t,i,r)!==zt(e,i,r)&&zt(t,e,i)!==zt(t,e,r)}function Sl(t,e,i){const r=i*i;if(1===e.length)return t.distSqr(e[0])<r;for(let i=1;i<e.length;i++)if(El(t,e[i-1],e[i])<r)return!0;return!1}function El(t,e,i){const r=e.distSqr(i);if(0===r)return t.distSqr(e);const n=((t.x-e.x)*(i.x-e.x)+(t.y-e.y)*(i.y-e.y))/r;return t.distSqr(n<0?e:n>1?i:i.sub(e)._mult(n)._add(e))}function Al(t,e){let i,r,n,s=!1;for(let o=0;o<t.length;o++){i=t[o];for(let t=0,o=i.length-1;t<i.length;o=t++)r=i[t],n=i[o],r.y>e.y!=n.y>e.y&&e.x<(n.x-r.x)*(e.y-r.y)/(n.y-r.y)+r.x&&(s=!s)}return s}function zl(t,e){let i=!1;for(let r=0,n=t.length-1;r<t.length;n=r++){const s=t[r],o=t[n];s.y>e.y!=o.y>e.y&&e.x<(o.x-s.x)*(e.y-s.y)/(o.y-s.y)+s.x&&(i=!i)}return i}function kl(t,e,i){const r=i[0],n=i[2];if(t.x<r.x&&e.x<r.x||t.x>n.x&&e.x>n.x||t.y<r.y&&e.y<r.y||t.y>n.y&&e.y>n.y)return!1;const s=zt(t,e,i[0]);return s!==zt(t,e,i[1])||s!==zt(t,e,i[2])||s!==zt(t,e,i[3])}function Dl(t,e,i){const r=e.paint.get(t).value;return"constant"===r.kind?r.value:i.programConfigurations.get(e.id).getMaxValue(t)}function Rl(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function Ll(t,e,i,r,n){if(!e[0]&&!e[1])return t;const s=c.convert(e)._mult(n);"viewport"===i&&s._rotate(-r);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(s));return o}let Bl,Fl;Ws("CircleBucket",bl,{omit:["layers"]});var Ol={get paint(){return Fl=Fl||new Mo({"circle-radius":new bo(_e.paint_circle["circle-radius"]),"circle-color":new bo(_e.paint_circle["circle-color"]),"circle-blur":new bo(_e.paint_circle["circle-blur"]),"circle-opacity":new bo(_e.paint_circle["circle-opacity"]),"circle-translate":new vo(_e.paint_circle["circle-translate"]),"circle-translate-anchor":new vo(_e.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new vo(_e.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new vo(_e.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new bo(_e.paint_circle["circle-stroke-width"]),"circle-stroke-color":new bo(_e.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new bo(_e.paint_circle["circle-stroke-opacity"])})},get layout(){return Bl=Bl||new Mo({"circle-sort-key":new bo(_e.layout_circle["circle-sort-key"])})}};class jl extends Io{constructor(t){super(t,Ol)}createBucket(t){return new bl(t)}queryRadius(t){const e=t;return Dl("circle-radius",this,e)+Dl("circle-stroke-width",this,e)+Rl(this.paint.get("circle-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:s,pixelPosMatrix:o}){const a=Ll(t,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-n.bearingInRadians,s),l=this.paint.get("circle-radius").evaluate(e,i)+this.paint.get("circle-stroke-width").evaluate(e,i),c="map"===this.paint.get("circle-pitch-alignment"),h=c?a:function(t,e){return t.map((t=>Vl(t,e)))}(a,o),u=c?l*s:l;for(const t of r)for(const e of t){const t=c?e:Vl(e,o);let i=u;const r=G([],[e.x,e.y,0,1],o);if("viewport"===this.paint.get("circle-pitch-scale")&&"map"===this.paint.get("circle-pitch-alignment")?i*=r[3]/n.cameraToCenterDistance:"map"===this.paint.get("circle-pitch-scale")&&"viewport"===this.paint.get("circle-pitch-alignment")&&(i*=n.cameraToCenterDistance/r[3]),Tl(h,t,i))return!0}return!1}}function Vl(t,e){const i=G([],[t.x,t.y,0,1],e);return new c(i[0]/i[3],i[1]/i[3])}class Nl extends bl{}let Ul;Ws("HeatmapBucket",Nl,{omit:["layers"]});var Zl={get paint(){return Ul=Ul||new Mo({"heatmap-radius":new bo(_e.paint_heatmap["heatmap-radius"]),"heatmap-weight":new bo(_e.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new vo(_e.paint_heatmap["heatmap-intensity"]),"heatmap-color":new Po(_e.paint_heatmap["heatmap-color"]),"heatmap-opacity":new vo(_e.paint_heatmap["heatmap-opacity"])})}};function Gl(t,{width:e,height:i},r,n){if(n){if(n instanceof Uint8ClampedArray)n=new Uint8Array(n.buffer);else if(n.length!==e*i*r)throw new RangeError(`mismatched image size. expected: ${n.length} but got: ${e*i*r}`)}else n=new Uint8Array(e*i*r);return t.width=e,t.height=i,t.data=n,t}function $l(t,{width:e,height:i},r){if(e===t.width&&i===t.height)return;const n=Gl({},{width:e,height:i},r);ql(t,n,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,i)},r),t.width=e,t.height=i,t.data=n.data}function ql(t,e,i,r,n,s){if(0===n.width||0===n.height)return e;if(n.width>t.width||n.height>t.height||i.x>t.width-n.width||i.y>t.height-n.height)throw new RangeError("out of range source coordinates for image copy");if(n.width>e.width||n.height>e.height||r.x>e.width-n.width||r.y>e.height-n.height)throw new RangeError("out of range destination coordinates for image copy");const o=t.data,a=e.data;if(o===a)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<n.height;l++){const c=((i.y+l)*t.width+i.x)*s,h=((r.y+l)*e.width+r.x)*s;for(let t=0;t<n.width*s;t++)a[h+t]=o[c+t]}return e}class Wl{constructor(t,e){Gl(this,t,1,e)}resize(t){$l(this,t,1)}clone(){return new Wl({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,i,r,n){ql(t,e,i,r,n,1)}}class Hl{constructor(t,e){Gl(this,t,4,e)}resize(t){$l(this,t,4)}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t}clone(){return new Hl({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,i,r,n){ql(t,e,i,r,n,4)}}function Xl(t){const e={},i=t.resolution||256,r=t.clips?t.clips.length:1,n=t.image||new Hl({width:i,height:r});if(Math.log(i)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${i}`);const s=(i,r,s)=>{e[t.evaluationKey]=s;const o=t.expression.evaluate(e);n.data[i+r+0]=Math.floor(255*o.r/o.a),n.data[i+r+1]=Math.floor(255*o.g/o.a),n.data[i+r+2]=Math.floor(255*o.b/o.a),n.data[i+r+3]=Math.floor(255*o.a)};if(t.clips)for(let e=0,n=0;e<r;++e,n+=4*i)for(let r=0,o=0;r<i;r++,o+=4){const a=r/(i-1),{start:l,end:c}=t.clips[e];s(n,o,l*(1-a)+c*a)}else for(let t=0,e=0;t<i;t++,e+=4)s(0,e,t/(i-1));return n}Ws("AlphaImage",Wl),Ws("RGBAImage",Hl);const Kl="big-fb";class Yl extends Io{createBucket(t){return new Nl(t)}constructor(t){super(t,Zl),this.heatmapFbos=new Map,this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp()}_updateColorRamp(){this.colorRamp=Xl({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null}resize(){this.heatmapFbos.has(Kl)&&this.heatmapFbos.delete(Kl)}queryRadius(){return 0}queryIntersectsFeature(){return!1}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}}let Jl;var Ql={get paint(){return Jl=Jl||new Mo({"hillshade-illumination-direction":new vo(_e.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new vo(_e.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new vo(_e.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new vo(_e.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new vo(_e.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new vo(_e.paint_hillshade["hillshade-accent-color"])})}};class tc extends Io{constructor(t){super(t,Ql)}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}}const ec=zo([{name:"a_pos",components:2,type:"Int16"}],4),{members:ic}=ec;function rc(t,e,i){const r=i.patternDependencies;let n=!1;for(const i of e){const e=i.paint.get(`${t}-pattern`);e.isConstant()||(n=!0);const s=e.constantOr(null);s&&(n=!0,r[s.to]=!0,r[s.from]=!0)}return n}function nc(t,e,i,r,n){const s=n.patternDependencies;for(const o of e){const e=o.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:r-1},i,{},n.availableImages),a=e.evaluate({zoom:r},i,{},n.availableImages),l=e.evaluate({zoom:r+1},i,{},n.availableImages);t=t&&t.name?t.name:t,a=a&&a.name?a.name:a,l=l&&l.name?l.name:l,s[t]=!0,s[a]=!0,s[l]=!0,i.patterns[o.id]={min:t,mid:a,max:l}}}return i}function sc(t,e,i,r,n){let s;if(n===function(t,e,i,r){let n=0;for(let s=e,o=i-r;s<i;s+=r)n+=(t[o]-t[s])*(t[s+1]+t[o+1]),o=s;return n}(t,e,i,r)>0)for(let n=e;n<i;n+=r)s=Ic(n/r|0,t[n],t[n+1],s);else for(let n=i-r;n>=e;n-=r)s=Ic(n/r|0,t[n],t[n+1],s);return s&&bc(s,s.next)&&(Sc(s),s=s.next),s}function oc(t,e){if(!t)return t;e||(e=t);let i,r=t;do{if(i=!1,r.steiner||!bc(r,r.next)&&0!==vc(r.prev,r,r.next))r=r.next;else{if(Sc(r),r=e=r.prev,r===r.next)break;i=!0}}while(i||r!==e);return e}function ac(t,e,i,r,n,s,o){if(!t)return;!o&&s&&function(t,e,i,r){let n=t;do{0===n.z&&(n.z=mc(n.x,n.y,e,i,r)),n.prevZ=n.prev,n.nextZ=n.next,n=n.next}while(n!==t);n.prevZ.nextZ=null,n.prevZ=null,function(t){let e,i=1;do{let r,n=t;t=null;let s=null;for(e=0;n;){e++;let o=n,a=0;for(let t=0;t<i&&(a++,o=o.nextZ,o);t++);let l=i;for(;a>0||l>0&&o;)0!==a&&(0===l||!o||n.z<=o.z)?(r=n,n=n.nextZ,a--):(r=o,o=o.nextZ,l--),s?s.nextZ=r:t=r,r.prevZ=s,s=r;n=o}s.nextZ=null,i*=2}while(e>1)}(n)}(t,r,n,s);let a=t;for(;t.prev!==t.next;){const l=t.prev,c=t.next;if(s?cc(t,r,n,s):lc(t))e.push(l.i,t.i,c.i),Sc(t),t=c.next,a=c.next;else if((t=c)===a){o?1===o?ac(t=hc(oc(t),e),e,i,r,n,s,2):2===o&&uc(t,e,i,r,n,s):ac(oc(t),e,i,r,n,s,1);break}}}function lc(t){const e=t.prev,i=t,r=t.next;if(vc(e,i,r)>=0)return!1;const n=e.x,s=i.x,o=r.x,a=e.y,l=i.y,c=r.y,h=Math.min(n,s,o),u=Math.min(a,l,c),p=Math.max(n,s,o),d=Math.max(a,l,c);let f=r.next;for(;f!==e;){if(f.x>=h&&f.x<=p&&f.y>=u&&f.y<=d&&yc(n,a,s,l,o,c,f.x,f.y)&&vc(f.prev,f,f.next)>=0)return!1;f=f.next}return!0}function cc(t,e,i,r){const n=t.prev,s=t,o=t.next;if(vc(n,s,o)>=0)return!1;const a=n.x,l=s.x,c=o.x,h=n.y,u=s.y,p=o.y,d=Math.min(a,l,c),f=Math.min(h,u,p),m=Math.max(a,l,c),_=Math.max(h,u,p),g=mc(d,f,e,i,r),y=mc(m,_,e,i,r);let x=t.prevZ,v=t.nextZ;for(;x&&x.z>=g&&v&&v.z<=y;){if(x.x>=d&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==o&&yc(a,h,l,u,c,p,x.x,x.y)&&vc(x.prev,x,x.next)>=0)return!1;if(x=x.prevZ,v.x>=d&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==o&&yc(a,h,l,u,c,p,v.x,v.y)&&vc(v.prev,v,v.next)>=0)return!1;v=v.nextZ}for(;x&&x.z>=g;){if(x.x>=d&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==o&&yc(a,h,l,u,c,p,x.x,x.y)&&vc(x.prev,x,x.next)>=0)return!1;x=x.prevZ}for(;v&&v.z<=y;){if(v.x>=d&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==o&&yc(a,h,l,u,c,p,v.x,v.y)&&vc(v.prev,v,v.next)>=0)return!1;v=v.nextZ}return!0}function hc(t,e){let i=t;do{const r=i.prev,n=i.next.next;!bc(r,n)&&wc(r,i,i.next,n)&&Mc(r,n)&&Mc(n,r)&&(e.push(r.i,i.i,n.i),Sc(i),Sc(i.next),i=t=n),i=i.next}while(i!==t);return oc(i)}function uc(t,e,i,r,n,s){let o=t;do{let t=o.next.next;for(;t!==o.prev;){if(o.i!==t.i&&xc(o,t)){let a=Cc(o,t);return o=oc(o,o.next),a=oc(a,a.next),ac(o,e,i,r,n,s,0),void ac(a,e,i,r,n,s,0)}t=t.next}o=o.next}while(o!==t)}function pc(t,e){let i=t.x-e.x;return 0===i&&(i=t.y-e.y,0===i)&&(i=(t.next.y-t.y)/(t.next.x-t.x)-(e.next.y-e.y)/(e.next.x-e.x)),i}function dc(t,e){const i=function(t,e){let i=e;const r=t.x,n=t.y;let s,o=-1/0;if(bc(t,i))return i;do{if(bc(t,i.next))return i.next;if(n<=i.y&&n>=i.next.y&&i.next.y!==i.y){const t=i.x+(n-i.y)*(i.next.x-i.x)/(i.next.y-i.y);if(t<=r&&t>o&&(o=t,s=i.x<i.next.x?i:i.next,t===r))return s}i=i.next}while(i!==e);if(!s)return null;const a=s,l=s.x,c=s.y;let h=1/0;i=s;do{if(r>=i.x&&i.x>=l&&r!==i.x&&gc(n<c?r:o,n,l,c,n<c?o:r,n,i.x,i.y)){const e=Math.abs(n-i.y)/(r-i.x);Mc(i,t)&&(e<h||e===h&&(i.x>s.x||i.x===s.x&&fc(s,i)))&&(s=i,h=e)}i=i.next}while(i!==a);return s}(t,e);if(!i)return e;const r=Cc(i,t);return oc(r,r.next),oc(i,i.next)}function fc(t,e){return vc(t.prev,t,e.prev)<0&&vc(e.next,t,t.next)<0}function mc(t,e,i,r,n){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-i)*n|0)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-r)*n|0)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function _c(t){let e=t,i=t;do{(e.x<i.x||e.x===i.x&&e.y<i.y)&&(i=e),e=e.next}while(e!==t);return i}function gc(t,e,i,r,n,s,o,a){return(n-o)*(e-a)>=(t-o)*(s-a)&&(t-o)*(r-a)>=(i-o)*(e-a)&&(i-o)*(s-a)>=(n-o)*(r-a)}function yc(t,e,i,r,n,s,o,a){return!(t===o&&e===a)&&gc(t,e,i,r,n,s,o,a)}function xc(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let i=t;do{if(i.i!==t.i&&i.next.i!==t.i&&i.i!==e.i&&i.next.i!==e.i&&wc(i,i.next,t,e))return!0;i=i.next}while(i!==t);return!1}(t,e)&&(Mc(t,e)&&Mc(e,t)&&function(t,e){let i=t,r=!1;const n=(t.x+e.x)/2,s=(t.y+e.y)/2;do{i.y>s!=i.next.y>s&&i.next.y!==i.y&&n<(i.next.x-i.x)*(s-i.y)/(i.next.y-i.y)+i.x&&(r=!r),i=i.next}while(i!==t);return r}(t,e)&&(vc(t.prev,t,e.prev)||vc(t,e.prev,e))||bc(t,e)&&vc(t.prev,t,t.next)>0&&vc(e.prev,e,e.next)>0)}function vc(t,e,i){return(e.y-t.y)*(i.x-e.x)-(e.x-t.x)*(i.y-e.y)}function bc(t,e){return t.x===e.x&&t.y===e.y}function wc(t,e,i,r){const n=Pc(vc(t,e,i)),s=Pc(vc(t,e,r)),o=Pc(vc(i,r,t)),a=Pc(vc(i,r,e));return n!==s&&o!==a||!(0!==n||!Tc(t,i,e))||!(0!==s||!Tc(t,r,e))||!(0!==o||!Tc(i,t,r))||!(0!==a||!Tc(i,e,r))}function Tc(t,e,i){return e.x<=Math.max(t.x,i.x)&&e.x>=Math.min(t.x,i.x)&&e.y<=Math.max(t.y,i.y)&&e.y>=Math.min(t.y,i.y)}function Pc(t){return t>0?1:t<0?-1:0}function Mc(t,e){return vc(t.prev,t,t.next)<0?vc(t,e,t.next)>=0&&vc(t,t.prev,e)>=0:vc(t,e,t.prev)<0||vc(t,t.next,e)<0}function Cc(t,e){const i=Ec(t.i,t.x,t.y),r=Ec(e.i,e.x,e.y),n=t.next,s=e.prev;return t.next=e,e.prev=t,i.next=n,n.prev=i,r.next=i,i.prev=r,s.next=r,r.prev=s,r}function Ic(t,e,i,r){const n=Ec(t,e,i);return r?(n.next=r.next,n.prev=r,r.next.prev=n,r.next=n):(n.prev=n,n.next=n),n}function Sc(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function Ec(t,e,i){return{i:t,x:e,y:i,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}class Ac{constructor(t,e){if(e>t)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=t,this._minGranularity=e}getGranularityForZoomLevel(t){return Math.max(Math.floor(this._baseZoomGranularity/(1<<t)),this._minGranularity,1)}}class zc{constructor(t){this.fill=t.fill,this.line=t.line,this.tile=t.tile,this.stencil=t.stencil,this.circle=t.circle}}zc.noSubdivision=new zc({fill:new Ac(0,0),line:new Ac(0,0),tile:new Ac(0,0),stencil:new Ac(0,0),circle:1}),Ws("SubdivisionGranularityExpression",Ac),Ws("SubdivisionGranularitySetting",zc);const kc=-32768,Dc=32767;class Rc{constructor(t,e){this._vertexBuffer=[],this._vertexDictionary=new Map,this._used=!1,this._granularity=t,this._granularityCellSize=J/t,this._canonical=e}_getKey(t,e){return(t+=32768)<<16|(e+=32768)<<0}_vertexToIndex(t,e){if(t<-32768||e<-32768||t>32767||e>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const i=0|Math.round(t),r=0|Math.round(e),n=this._getKey(i,r);if(this._vertexDictionary.has(n))return this._vertexDictionary.get(n);const s=this._vertexBuffer.length/2;return this._vertexDictionary.set(n,s),this._vertexBuffer.push(i,r),s}_subdivideTrianglesScanline(t){if(this._granularity<2)return function(t,e){const i=[];for(let r=0;r<e.length;r+=3){const n=e[r],s=e[r+1],o=e[r+2],a=t[2*n],l=t[2*n+1];(t[2*s]-a)*(t[2*o+1]-l)-(t[2*s+1]-l)*(t[2*o]-a)>0?(i.push(n),i.push(o),i.push(s)):(i.push(n),i.push(s),i.push(o))}return i}(this._vertexBuffer,t);const e=[],i=t.length;for(let r=0;r<i;r+=3){const i=[t[r+0],t[r+1],t[r+2]],n=[this._vertexBuffer[2*t[r+0]+0],this._vertexBuffer[2*t[r+0]+1],this._vertexBuffer[2*t[r+1]+0],this._vertexBuffer[2*t[r+1]+1],this._vertexBuffer[2*t[r+2]+0],this._vertexBuffer[2*t[r+2]+1]];let s=1/0,o=1/0,a=-1/0,l=-1/0;for(let t=0;t<3;t++){const e=n[2*t],i=n[2*t+1];s=Math.min(s,e),a=Math.max(a,e),o=Math.min(o,i),l=Math.max(l,i)}if(s===a||o===l)continue;const c=Math.floor(s/this._granularityCellSize),h=Math.ceil(a/this._granularityCellSize),u=Math.floor(o/this._granularityCellSize),p=Math.ceil(l/this._granularityCellSize);if(c!==h||u!==p)for(let t=u;t<p;t++){const r=this._scanlineGenerateVertexRingForCellRow(t,n,i);Fc(this._vertexBuffer,r,e)}else e.push(...i)}return e}_scanlineGenerateVertexRingForCellRow(t,e,i){const r=t*this._granularityCellSize,n=r+this._granularityCellSize,s=[];for(let t=0;t<3;t++){const o=e[2*t],a=e[2*t+1],l=e[2*(t+1)%6],c=e[(2*(t+1)+1)%6],h=e[2*(t+2)%6],u=e[(2*(t+2)+1)%6],p=l-o,d=c-a,f=0===p,m=0===d,_=(r-a)/d,g=(n-a)/d,y=Math.min(_,g),x=Math.max(_,g);if(!m&&(y>=1||x<=0)||m&&(a<r||a>n)){c>=r&&c<=n&&s.push(i[(t+1)%3]);continue}!m&&y>0&&s.push(this._vertexToIndex(o+p*y,a+d*y));const v=o+p*Math.max(y,0),b=o+p*Math.min(x,1);f||this._generateIntraEdgeVertices(s,o,a,l,c,v,b),!m&&x<1&&s.push(this._vertexToIndex(o+p*x,a+d*x)),(m||c>=r&&c<=n)&&s.push(i[(t+1)%3]),!m&&(c<=r||c>=n)&&this._generateInterEdgeVertices(s,o,a,l,c,h,u,b,r,n)}return s}_generateIntraEdgeVertices(t,e,i,r,n,s,o){const a=r-e,l=n-i,c=0===l,h=c?Math.min(e,r):Math.min(s,o),u=c?Math.max(e,r):Math.max(s,o),p=Math.floor(h/this._granularityCellSize)+1,d=Math.ceil(u/this._granularityCellSize)-1;if(c?e<r:s<o)for(let r=p;r<=d;r++){const n=r*this._granularityCellSize;t.push(this._vertexToIndex(n,i+l*(n-e)/a))}else for(let r=d;r>=p;r--){const n=r*this._granularityCellSize;t.push(this._vertexToIndex(n,i+l*(n-e)/a))}}_generateInterEdgeVertices(t,e,i,r,n,s,o,a,l,c){const h=n-i,u=s-r,p=o-n,d=(l-n)/p,f=(c-n)/p,m=Math.min(d,f),_=Math.max(d,f),g=r+u*m;let y=Math.floor(Math.min(g,a)/this._granularityCellSize)+1,x=Math.ceil(Math.max(g,a)/this._granularityCellSize)-1,v=a<g;const b=0===p;if(b&&(o===l||o===c))return;if(b||m>=1||_<=0){const t=i-o,r=s+(e-s)*Math.min((l-o)/t,(c-o)/t);y=Math.floor(Math.min(r,a)/this._granularityCellSize)+1,x=Math.ceil(Math.max(r,a)/this._granularityCellSize)-1,v=a<r}const w=h>0?c:l;if(v)for(let e=y;e<=x;e++)t.push(this._vertexToIndex(e*this._granularityCellSize,w));else for(let e=x;e>=y;e--)t.push(this._vertexToIndex(e*this._granularityCellSize,w))}_generateOutline(t){const e=[];for(const i of t){const t=Bc(i,this._granularity,!0),r=this._pointArrayToIndices(t),n=[];for(let t=1;t<r.length;t++)n.push(r[t-1]),n.push(r[t]);e.push(n)}return e}_handlePoles(t){let e=!1,i=!1;this._canonical&&(0===this._canonical.y&&(e=!0),this._canonical.y===(1<<this._canonical.z)-1&&(i=!0)),(e||i)&&this._fillPoles(t,e,i)}_ensureNoPoleVertices(){const t=this._vertexBuffer;for(let e=0;e<t.length;e+=2){const i=t[e+1];i===kc&&(t[e+1]=-32767),i===Dc&&(t[e+1]=32766)}}_generatePoleQuad(t,e,i,r,n,s){r>n!=(s===kc)?(t.push(e),t.push(i),t.push(this._vertexToIndex(r,s)),t.push(i),t.push(this._vertexToIndex(n,s)),t.push(this._vertexToIndex(r,s))):(t.push(i),t.push(e),t.push(this._vertexToIndex(r,s)),t.push(this._vertexToIndex(n,s)),t.push(i),t.push(this._vertexToIndex(r,s)))}_fillPoles(t,e,i){const r=this._vertexBuffer,n=J,s=t.length;for(let o=2;o<s;o+=3){const s=t[o-2],a=t[o-1],l=t[o],c=r[2*s],h=r[2*s+1],u=r[2*a],p=r[2*a+1],d=r[2*l],f=r[2*l+1];e&&(0===h&&0===p&&this._generatePoleQuad(t,s,a,c,u,kc),0===p&&0===f&&this._generatePoleQuad(t,a,l,u,d,kc),0===f&&0===h&&this._generatePoleQuad(t,l,s,d,c,kc)),i&&(h===n&&p===n&&this._generatePoleQuad(t,s,a,c,u,Dc),p===n&&f===n&&this._generatePoleQuad(t,a,l,u,d,Dc),f===n&&h===n&&this._generatePoleQuad(t,l,s,d,c,Dc))}}_initializeVertices(t){for(let e=0;e<t.length;e+=2)this._vertexToIndex(t[e],t[e+1])}subdividePolygonInternal(t,e){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:i,holeIndices:r}=function(t){const e=[],i=[];for(const r of t)if(0!==r.length){r!==t[0]&&e.push(i.length/2);for(let t=0;t<r.length;t++)i.push(r[t].x),i.push(r[t].y)}return{flattened:i,holeIndices:e}}(t);let n;this._initializeVertices(i);try{const t=function(t,e,i=2){const r=e&&e.length,n=r?e[0]*i:t.length;let s=sc(t,0,n,i,!0);const o=[];if(!s||s.next===s.prev)return o;let a,l,c;if(r&&(s=function(t,e,i,r){const n=[];for(let i=0,s=e.length;i<s;i++){const o=sc(t,e[i]*r,i<s-1?e[i+1]*r:t.length,r,!1);o===o.next&&(o.steiner=!0),n.push(_c(o))}n.sort(pc);for(let t=0;t<n.length;t++)i=dc(n[t],i);return i}(t,e,s,i)),t.length>80*i){a=1/0,l=1/0;let e=-1/0,r=-1/0;for(let s=i;s<n;s+=i){const i=t[s],n=t[s+1];i<a&&(a=i),n<l&&(l=n),i>e&&(e=i),n>r&&(r=n)}c=Math.max(e-a,r-l),c=0!==c?32767/c:0}return ac(s,o,i,a,l,c,0),o}(i,r),e=this._convertIndices(i,t);n=this._subdivideTrianglesScanline(e)}catch(t){console.error(t)}let s=[];return e&&(s=this._generateOutline(t)),this._ensureNoPoleVertices(),this._handlePoles(n),{verticesFlattened:this._vertexBuffer,indicesTriangles:n,indicesLineList:s}}_convertIndices(t,e){const i=[];for(let r=0;r<e.length;r++)i.push(this._vertexToIndex(t[2*e[r]],t[2*e[r]+1]));return i}_pointArrayToIndices(t){const e=[];for(let i=0;i<t.length;i++){const r=t[i];e.push(this._vertexToIndex(r.x,r.y))}return e}}function Lc(t,e,i,r=!0){return new Rc(i,e).subdividePolygonInternal(t,r)}function Bc(t,e,i=!1){if(!t||t.length<1)return[];if(t.length<2)return[];const r=t[0],n=t[t.length-1],s=i&&(r.x!==n.x||r.y!==n.y);if(e<2)return s?[...t,t[0]]:[...t];const o=Math.floor(J/e),a=[];a.push(new c(t[0].x,t[0].y));const l=t.length,h=s?l:l-1;for(let e=0;e<h;e++){const i=t[e],r=e<l-1?t[e+1]:t[0],n=i.x,s=i.y,h=r.x,u=r.y,p=n!==h,d=s!==u;if(!p&&!d)continue;const f=h-n,m=u-s,_=Math.abs(f),g=Math.abs(m);let y=n,x=s;for(;;){const t=f>0?(Math.floor(y/o)+1)*o:(Math.ceil(y/o)-1)*o,e=m>0?(Math.floor(x/o)+1)*o:(Math.ceil(x/o)-1)*o,i=Math.abs(y-t),r=Math.abs(x-e),n=Math.abs(y-h),s=Math.abs(x-u),l=p?i/_:Number.POSITIVE_INFINITY,v=d?r/g:Number.POSITIVE_INFINITY;if((n<=i||!p)&&(s<=r||!d))break;if(l<v&&p||!d){y=t,x+=m*l;const e=new c(y,Math.round(x));a[a.length-1].x===e.x&&a[a.length-1].y===e.y||a.push(e)}else{y+=f*v,x=e;const t=new c(Math.round(y),x);a[a.length-1].x===t.x&&a[a.length-1].y===t.y||a.push(t)}}const v=new c(h,u);a[a.length-1].x===v.x&&a[a.length-1].y===v.y||a.push(v)}return a}function Fc(t,e,i){if(0===e.length)throw new Error("Subdivision vertex ring is empty.");let r=0,n=t[2*e[0]];for(let i=1;i<e.length;i++){const s=t[2*e[i]];s<n&&(n=s,r=i)}const s=e.length;let o=r,a=(o+1)%s;for(;;){const r=o-1>=0?o-1:s-1,n=(a+1)%s,l=t[2*e[r]],c=t[2*e[n]],h=t[2*e[o]],u=t[2*e[o]+1],p=t[2*e[a]+1];let d=!1;if(l<c)d=!0;else if(l>c)d=!1;else{const i=p-u,s=-(t[2*e[a]]-h),o=u<p?1:-1;((l-h)*i+(t[2*e[r]+1]-u)*s)*o>((c-h)*i+(t[2*e[n]+1]-u)*s)*o&&(d=!0)}if(d){const t=e[r],n=e[o],l=e[a];t!==n&&t!==l&&n!==l&&i.push(l,n,t),o--,o<0&&(o=s-1)}else{const t=e[n],r=e[o],l=e[a];t!==r&&t!==l&&r!==l&&i.push(l,r,t),a++,a>=s&&(a=0)}if(r===n)break}}function Oc(t,e,i,r,n,s,o,a,l){const c=n.length/2,h=o&&a&&l;if(c<La.MAX_VERTEX_ARRAY_LENGTH){const u=e.prepareSegment(c,i,r),p=u.vertexLength;for(let t=0;t<s.length;t+=3)r.emplaceBack(p+s[t],p+s[t+1],p+s[t+2]);let d,f;u.vertexLength+=c,u.primitiveLength+=s.length/3,h&&(f=o.prepareSegment(c,i,a),d=f.vertexLength,f.vertexLength+=c);for(let e=0;e<n.length;e+=2)t(n[e],n[e+1]);if(h)for(let t=0;t<l.length;t++){const e=l[t];for(let t=1;t<e.length;t+=2)a.emplaceBack(d+e[t-1],d+e[t]);f.primitiveLength+=e.length/2}}else!function(t,e,i,r,n,s){const o=[];for(let t=0;t<r.length/2;t++)o.push(-1);const a={count:0};let l=0,c=t.getOrCreateLatestSegment(e,i),h=c.vertexLength;for(let u=2;u<n.length;u+=3){const p=n[u-2],d=n[u-1],f=n[u];let m=o[p]<l,_=o[d]<l,g=o[f]<l;c.vertexLength+((m?1:0)+(_?1:0)+(g?1:0))>La.MAX_VERTEX_ARRAY_LENGTH&&(c=t.createNewSegment(e,i),l=a.count,m=!0,_=!0,g=!0,h=0);const y=jc(o,r,s,a,p,m,c),x=jc(o,r,s,a,d,_,c),v=jc(o,r,s,a,f,g,c);i.emplaceBack(h+y-l,h+x-l,h+v-l),c.primitiveLength++}}(e,i,r,n,s,t),h&&function(t,e,i,r,n,s){const o=[];for(let t=0;t<r.length/2;t++)o.push(-1);const a={count:0};let l=0,c=t.getOrCreateLatestSegment(e,i),h=c.vertexLength;for(let u=0;u<n.length;u++){const p=n[u];for(let d=1;d<n[u].length;d+=2){const n=p[d-1],u=p[d];let f=o[n]<l,m=o[u]<l;c.vertexLength+((f?1:0)+(m?1:0))>La.MAX_VERTEX_ARRAY_LENGTH&&(c=t.createNewSegment(e,i),l=a.count,f=!0,m=!0,h=0);const _=jc(o,r,s,a,n,f,c),g=jc(o,r,s,a,u,m,c);i.emplaceBack(h+_-l,h+g-l),c.primitiveLength++}}}(o,i,a,n,l,t),e.forceNewSegmentOnNextPrepare(),null==o||o.forceNewSegmentOnNextPrepare()}function jc(t,e,i,r,n,s,o){if(s){const s=r.count;return i(e[2*n],e[2*n+1]),t[n]=r.count,r.count++,o.vertexLength++,s}return t[n]}class Vc{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new ya,this.indexArray=new Aa,this.indexArray2=new za,this.programConfigurations=new pl(t.layers,t.zoom),this.segments=new La,this.segments2=new La,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.hasPattern=rc("fill",this.layers,e);const r=this.layers[0].layout.get("fill-sort-key"),n=!r.isConstant(),s=[];for(const{feature:o,id:a,index:l,sourceLayerIndex:c}of t){const t=this.layers[0]._featureFilter.needGeometry,h=yl(o,t);if(!this.layers[0]._featureFilter.filter(new ho(this.zoom),h,i))continue;const u=n?r.evaluate(h,{},i,e.availableImages):void 0,p={id:a,properties:o.properties,type:o.type,sourceLayerIndex:c,index:l,geometry:t?h.geometry:gl(o),patterns:{},sortKey:u};s.push(p)}n&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of s){const{geometry:n,index:s,sourceLayerIndex:o}=r;if(this.hasPattern){const t=nc("fill",this.layers,r,this.zoom,e);this.patternFeatures.push(t)}else this.addFeature(r,n,s,i,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,n,s,o,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,i)}addFeatures(t,e,i){for(const r of this.patternFeatures)this.addFeature(r,r.geometry,r.index,e,i,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,ic),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy())}addFeature(t,e,i,r,n,s){for(const t of qr(e,500)){const e=Lc(t,r,s.fill.getGranularityForZoomLevel(r.z)),i=this.layoutVertexArray;Oc(((t,e)=>{i.emplaceBack(t,e)}),this.segments,this.layoutVertexArray,this.indexArray,e.verticesFlattened,e.indicesTriangles,this.segments2,this.indexArray2,e.indicesLineList)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,n,r)}}let Nc,Uc;Ws("FillBucket",Vc,{omit:["layers","patternFeatures"]});var Zc={get paint(){return Uc=Uc||new Mo({"fill-antialias":new vo(_e.paint_fill["fill-antialias"]),"fill-opacity":new bo(_e.paint_fill["fill-opacity"]),"fill-color":new bo(_e.paint_fill["fill-color"]),"fill-outline-color":new bo(_e.paint_fill["fill-outline-color"]),"fill-translate":new vo(_e.paint_fill["fill-translate"]),"fill-translate-anchor":new vo(_e.paint_fill["fill-translate-anchor"]),"fill-pattern":new wo(_e.paint_fill["fill-pattern"])})},get layout(){return Nc=Nc||new Mo({"fill-sort-key":new bo(_e.layout_fill["fill-sort-key"])})}};class Gc extends Io{constructor(t){super(t,Zc)}recalculate(t,e){super.recalculate(t,e);const i=this.paint._values["fill-outline-color"];"constant"===i.value.kind&&void 0===i.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"])}createBucket(t){return new Vc(t)}queryRadius(){return Rl(this.paint.get("fill-translate"))}queryIntersectsFeature({queryGeometry:t,geometry:e,transform:i,pixelsToTileUnits:r}){return Pl(Ll(t,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-i.bearingInRadians,r),e)}isTileClipped(){return!0}}const $c=zo([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),qc=zo([{name:"a_centroid",components:2,type:"Int16"}],4),{members:Wc}=$c;var Hc,Xc,Kc,Yc,Jc,Qc,th,eh={};function ih(){if(Xc)return Hc;Xc=1;var t=o();function e(t,e,r,n,s){this.properties={},this.extent=r,this.type=0,this._pbf=t,this._geometry=-1,this._keys=n,this._values=s,t.readFields(i,this,e)}function i(t,e,i){1==t?e.id=i.readVarint():2==t?function(t,e){for(var i=t.readVarint()+t.pos;t.pos<i;){var r=e._keys[t.readVarint()],n=e._values[t.readVarint()];e.properties[r]=n}}(i,e):3==t?e.type=i.readVarint():4==t&&(e._geometry=i.pos)}function r(t){for(var e,i,r=0,n=0,s=t.length,o=s-1;n<s;o=n++)r+=((i=t[o]).x-(e=t[n]).x)*(e.y+i.y);return r}return Hc=e,e.types=["Unknown","Point","LineString","Polygon"],e.prototype.loadGeometry=function(){var e=this._pbf;e.pos=this._geometry;for(var i,r=e.readVarint()+e.pos,n=1,s=0,o=0,a=0,l=[];e.pos<r;){if(s<=0){var c=e.readVarint();n=7&c,s=c>>3}if(s--,1===n||2===n)o+=e.readSVarint(),a+=e.readSVarint(),1===n&&(i&&l.push(i),i=[]),i.push(new t(o,a));else{if(7!==n)throw new Error("unknown command "+n);i&&i.push(i[0].clone())}}return i&&l.push(i),l},e.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,i=1,r=0,n=0,s=0,o=1/0,a=-1/0,l=1/0,c=-1/0;t.pos<e;){if(r<=0){var h=t.readVarint();i=7&h,r=h>>3}if(r--,1===i||2===i)(n+=t.readSVarint())<o&&(o=n),n>a&&(a=n),(s+=t.readSVarint())<l&&(l=s),s>c&&(c=s);else if(7!==i)throw new Error("unknown command "+i)}return[o,l,a,c]},e.prototype.toGeoJSON=function(t,i,n){var s,o,a=this.extent*Math.pow(2,n),l=this.extent*t,c=this.extent*i,h=this.loadGeometry(),u=e.types[this.type];function p(t){for(var e=0;e<t.length;e++){var i=t[e];t[e]=[360*(i.x+l)/a-180,360/Math.PI*Math.atan(Math.exp((180-360*(i.y+c)/a)*Math.PI/180))-90]}}switch(this.type){case 1:var d=[];for(s=0;s<h.length;s++)d[s]=h[s][0];p(h=d);break;case 2:for(s=0;s<h.length;s++)p(h[s]);break;case 3:for(h=function(t){var e=t.length;if(e<=1)return[t];for(var i,n,s=[],o=0;o<e;o++){var a=r(t[o]);0!==a&&(void 0===n&&(n=a<0),n===a<0?(i&&s.push(i),i=[t[o]]):i.push(t[o]))}return i&&s.push(i),s}(h),s=0;s<h.length;s++)for(o=0;o<h[s].length;o++)p(h[s][o])}1===h.length?h=h[0]:u="Multi"+u;var f={type:"Feature",geometry:{type:u,coordinates:h},properties:this.properties};return"id"in this&&(f.id=this.id),f},Hc}function rh(){if(Yc)return Kc;Yc=1;var t=ih();function e(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(i,this,e),this.length=this._features.length}function i(t,e,i){15===t?e.version=i.readVarint():1===t?e.name=i.readString():5===t?e.extent=i.readVarint():2===t?e._features.push(i.pos):3===t?e._keys.push(i.readString()):4===t&&e._values.push(function(t){for(var e=null,i=t.readVarint()+t.pos;t.pos<i;){var r=t.readVarint()>>3;e=1===r?t.readString():2===r?t.readFloat():3===r?t.readDouble():4===r?t.readVarint64():5===r?t.readVarint():6===r?t.readSVarint():7===r?t.readBoolean():null}return e}(i))}return Kc=e,e.prototype.feature=function(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];var i=this._pbf.readVarint()+this._pbf.pos;return new t(this._pbf,i,this.extent,this._keys,this._values)},Kc}var nh=(th||(th=1,eh.VectorTile=function(){if(Qc)return Jc;Qc=1;var t=rh();function e(e,i,r){if(3===e){var n=new t(r,r.readVarint()+r.pos);n.length&&(i[n.name]=n)}}return Jc=function(t,i){this.layers=t.readFields(e,{},i)},Jc}(),eh.VectorTileFeature=ih(),eh.VectorTileLayer=rh()),eh),sh=s(nh);const oh=sh.VectorTileFeature.types,ah=Math.pow(2,13);function lh(t,e,i,r,n,s,o,a){t.emplaceBack(e,i,2*Math.floor(r*ah)+o,n*ah*2,s*ah*2,Math.round(a))}class ch{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new xa,this.centroidVertexArray=new fa,this.indexArray=new Aa,this.programConfigurations=new pl(t.layers,t.zoom),this.segments=new La,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.features=[],this.hasPattern=rc("fill-extrusion",this.layers,e);for(const{feature:r,id:n,index:s,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,a=yl(r,t);if(!this.layers[0]._featureFilter.filter(new ho(this.zoom),a,i))continue;const l={id:n,sourceLayerIndex:o,index:s,geometry:t?a.geometry:gl(r),properties:r.properties,type:r.type,patterns:{}};this.hasPattern?this.features.push(nc("fill-extrusion",this.layers,l,this.zoom,e)):this.addFeature(l,l.geometry,s,i,{},e.subdivisionGranularity),e.featureIndex.insert(r,l.geometry,s,o,this.index,!0)}}addFeatures(t,e,i){for(const r of this.features){const{geometry:n}=r;this.addFeature(r,n,r.index,e,i,t.subdivisionGranularity)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,i)}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Wc),this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,qc.members,!0),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy())}addFeature(t,e,i,r,n,s){for(const i of qr(e,500)){const e={x:0,y:0,sampleCount:0},n=this.layoutVertexArray.length;this.processPolygon(e,r,t,i,s);const o=this.layoutVertexArray.length-n,a=Math.floor(e.x/e.sampleCount),l=Math.floor(e.y/e.sampleCount);for(let t=0;t<o;t++)this.centroidVertexArray.emplaceBack(a,l)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,n,r)}processPolygon(t,e,i,r,n){if(r.length<1)return;if(ph(r[0]))return;for(const e of r)0!==e.length&&hh(t,e);const s={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},o=n.fill.getGranularityForZoomLevel(e.z),a="Polygon"===oh[i.type];for(const t of r){if(0===t.length)continue;if(ph(t))continue;const e=Bc(t,o,a);this._generateSideFaces(e,s)}if(!a)return;const l=Lc(r,e,o,!1),c=this.layoutVertexArray;Oc(((t,e)=>{lh(c,t,e,0,0,1,1,0)}),this.segments,this.layoutVertexArray,this.indexArray,l.verticesFlattened,l.indicesTriangles)}_generateSideFaces(t,e){let i=0;for(let r=1;r<t.length;r++){const n=t[r],s=t[r-1];if(uh(n,s))continue;e.segment.vertexLength+4>La.MAX_VERTEX_ARRAY_LENGTH&&(e.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const o=n.sub(s)._perp()._unit(),a=s.dist(n);i+a>32768&&(i=0),lh(this.layoutVertexArray,n.x,n.y,o.x,o.y,0,0,i),lh(this.layoutVertexArray,n.x,n.y,o.x,o.y,0,1,i),i+=a,lh(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,0,i),lh(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,1,i);const l=e.segment.vertexLength;this.indexArray.emplaceBack(l,l+2,l+1),this.indexArray.emplaceBack(l+1,l+2,l+3),e.segment.vertexLength+=4,e.segment.primitiveLength+=2}}}function hh(t,e){for(let i=0;i<e.length;i++){const r=e[i];i===e.length-1&&e[0].x===r.x&&e[0].y===r.y||(t.x+=r.x,t.y+=r.y,t.sampleCount++)}}function uh(t,e){return t.x===e.x&&(t.x<0||t.x>J)||t.y===e.y&&(t.y<0||t.y>J)}function ph(t){return t.every((t=>t.x<0))||t.every((t=>t.x>J))||t.every((t=>t.y<0))||t.every((t=>t.y>J))}let dh;Ws("FillExtrusionBucket",ch,{omit:["layers","features"]});var fh={get paint(){return dh=dh||new Mo({"fill-extrusion-opacity":new vo(_e["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new bo(_e["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new vo(_e["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new vo(_e["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new wo(_e["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new bo(_e["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new bo(_e["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new vo(_e["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class mh extends Io{constructor(t){super(t,fh)}createBucket(t){return new ch(t)}queryRadius(){return Rl(this.paint.get("fill-extrusion-translate"))}is3D(){return!0}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:s,pixelPosMatrix:o}){const a=Ll(t,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-n.bearingInRadians,s),l=this.paint.get("fill-extrusion-height").evaluate(e,i),h=this.paint.get("fill-extrusion-base").evaluate(e,i),u=function(t,e,i){const r=[];for(const i of t){const t=[i.x,i.y,0,1];G(t,t,e),r.push(new c(t[0]/t[3],t[1]/t[3]))}return r}(a,o),p=function(t,e,i,r){const n=[],s=[],o=r[8]*e,a=r[9]*e,l=r[10]*e,h=r[11]*e,u=r[8]*i,p=r[9]*i,d=r[10]*i,f=r[11]*i;for(const e of t){const t=[],i=[];for(const n of e){const e=n.x,s=n.y,m=r[0]*e+r[4]*s+r[12],_=r[1]*e+r[5]*s+r[13],g=r[2]*e+r[6]*s+r[14],y=r[3]*e+r[7]*s+r[15],x=g+l,v=y+h,b=m+u,w=_+p,T=g+d,P=y+f,M=new c((m+o)/v,(_+a)/v);M.z=x/v,t.push(M);const C=new c(b/P,w/P);C.z=T/P,i.push(C)}n.push(t),s.push(i)}return[n,s]}(r,h,l,o);return function(t,e,i){let r=1/0;Pl(i,e)&&(r=gh(i,e[0]));for(let n=0;n<e.length;n++){const s=e[n],o=t[n];for(let t=0;t<s.length-1;t++){const e=s[t],n=[e,s[t+1],o[t+1],o[t],e];wl(i,n)&&(r=Math.min(r,gh(i,n)))}}return r!==1/0&&r}(p[0],p[1],u)}}function _h(t,e){return t.x*e.x+t.y*e.y}function gh(t,e){if(1===t.length){let i=0;const r=e[i++];let n;for(;!n||r.equals(n);)if(n=e[i++],!n)return 1/0;for(;i<e.length;i++){const s=e[i],o=t[0],a=n.sub(r),l=s.sub(r),c=o.sub(r),h=_h(a,a),u=_h(a,l),p=_h(l,l),d=_h(c,a),f=_h(c,l),m=h*p-u*u,_=(p*d-u*f)/m,g=(h*f-u*d)/m,y=r.z*(1-_-g)+n.z*_+s.z*g;if(isFinite(y))return y}return 1/0}{let t=1/0;for(const i of e)t=Math.min(t,i.z);return t}}const yh=zo([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:xh}=yh,vh=zo([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:bh}=vh,wh=sh.VectorTileFeature.types,Th=Math.cos(Math.PI/180*37.5),Ph=Math.pow(2,14)/.5;class Mh{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((t=>{this.gradients[t.id]={}})),this.layoutVertexArray=new va,this.layoutVertexArray2=new ba,this.indexArray=new Aa,this.programConfigurations=new pl(t.layers,t.zoom),this.segments=new La,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id))}populate(t,e,i){this.hasPattern=rc("line",this.layers,e);const r=this.layers[0].layout.get("line-sort-key"),n=!r.isConstant(),s=[];for(const{feature:e,id:o,index:a,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,c=yl(e,t);if(!this.layers[0]._featureFilter.filter(new ho(this.zoom),c,i))continue;const h=n?r.evaluate(c,{},i):void 0,u={id:o,properties:e.properties,type:e.type,sourceLayerIndex:l,index:a,geometry:t?c.geometry:gl(e),patterns:{},sortKey:h};s.push(u)}n&&s.sort(((t,e)=>t.sortKey-e.sortKey));for(const r of s){const{geometry:n,index:s,sourceLayerIndex:o}=r;if(this.hasPattern){const t=nc("line",this.layers,r,this.zoom,e);this.patternFeatures.push(t)}else this.addFeature(r,n,s,i,{},e.subdivisionGranularity);e.featureIndex.insert(t[s].feature,n,s,o,this.index)}}update(t,e,i){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,i)}addFeatures(t,e,i){for(const r of this.patternFeatures)this.addFeature(r,r.geometry,r.index,e,i,t.subdivisionGranularity)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,bh)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,xh),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}lineFeatureClips(t){if(t.properties&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(t.properties,"mapbox_clip_end"))return{start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,i,r,n,s){const o=this.layers[0].layout,a=o.get("line-join").evaluate(t,{}),l=o.get("line-cap"),c=o.get("line-miter-limit"),h=o.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const i of e)this.addLine(i,t,a,l,c,h,r,s);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,i,n,r)}addLine(t,e,i,r,n,s,o,a){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,t=Bc(t,o?a.line.getGranularityForZoomLevel(o.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance)}const l="Polygon"===wh[e.type];let c=t.length;for(;c>=2&&t[c-1].equals(t[c-2]);)c--;let h=0;for(;h<c-1&&t[h].equals(t[h+1]);)h++;if(c<(l?3:2))return;"bevel"===i&&(n=1.05);const u=this.overscaling<=16?15*J/(512*this.overscaling):0,p=this.segments.prepareSegment(10*c,this.layoutVertexArray,this.indexArray);let d,f,m,_,g;this.e1=this.e2=-1,l&&(d=t[c-2],g=t[h].sub(d)._unit()._perp());for(let e=h;e<c;e++){if(m=e===c-1?l?t[h+1]:void 0:t[e+1],m&&t[e].equals(m))continue;g&&(_=g),d&&(f=d),d=t[e],g=m?m.sub(d)._unit()._perp():_,_=_||g;let o=_.add(g);0===o.x&&0===o.y||o._unit();const a=_.x*g.x+_.y*g.y,y=o.x*g.x+o.y*g.y,x=0!==y?1/y:1/0,v=2*Math.sqrt(2-2*y),b=y<Th&&f&&m,w=_.x*g.y-_.y*g.x>0;if(b&&e>h){const t=d.dist(f);if(t>2*u){const e=d.sub(d.sub(f)._mult(u/t)._round());this.updateDistance(f,e),this.addCurrentVertex(e,_,0,0,p),f=e}}const T=f&&m;let P=T?i:l?"butt":r;if(T&&"round"===P&&(x<s?P="miter":x<=2&&(P="fakeround")),"miter"===P&&x>n&&(P="bevel"),"bevel"===P&&(x>2&&(P="flipbevel"),x<n&&(P="miter")),f&&this.updateDistance(f,d),"miter"===P)o._mult(x),this.addCurrentVertex(d,o,0,0,p);else if("flipbevel"===P){if(x>100)o=g.mult(-1);else{const t=x*_.add(g).mag()/_.sub(g).mag();o._perp()._mult(t*(w?-1:1))}this.addCurrentVertex(d,o,0,0,p),this.addCurrentVertex(d,o.mult(-1),0,0,p)}else if("bevel"===P||"fakeround"===P){const t=-Math.sqrt(x*x-1),e=w?t:0,i=w?0:t;if(f&&this.addCurrentVertex(d,_,e,i,p),"fakeround"===P){const t=Math.round(180*v/Math.PI/20);for(let e=1;e<t;e++){let i=e/t;if(.5!==i){const t=i-.5;i+=i*t*(i-1)*((1.0904+a*(a*(3.55645-1.43519*a)-3.2452))*t*t+(.848013+a*(.215638*a-1.06021)))}const r=g.sub(_)._mult(i)._add(_)._unit()._mult(w?-1:1);this.addHalfVertex(d,r.x,r.y,!1,w,0,p)}}m&&this.addCurrentVertex(d,g,-e,-i,p)}else if("butt"===P)this.addCurrentVertex(d,o,0,0,p);else if("square"===P){const t=f?1:-1;this.addCurrentVertex(d,o,t,t,p)}else"round"===P&&(f&&(this.addCurrentVertex(d,_,0,0,p),this.addCurrentVertex(d,_,1,1,p,!0)),m&&(this.addCurrentVertex(d,g,-1,-1,p,!0),this.addCurrentVertex(d,g,0,0,p)));if(b&&e<c-1){const t=d.dist(m);if(t>2*u){const e=d.add(m.sub(d)._mult(u/t)._round());this.updateDistance(d,e),this.addCurrentVertex(e,g,0,0,p),d=e}}}}addCurrentVertex(t,e,i,r,n,s=!1){const o=e.y*r-e.x,a=-e.y-e.x*r;this.addHalfVertex(t,e.x+e.y*i,e.y-e.x*i,s,!1,i,n),this.addHalfVertex(t,o,a,s,!0,-r,n),this.distance>Ph/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(t,e,i,r,n,s))}addHalfVertex({x:t,y:e},i,r,n,s,o,a){const l=.5*(this.lineClips?this.scaledDistance*(Ph-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((t<<1)+(n?1:0),(e<<1)+(s?1:0),Math.round(63*i)+128,Math.round(63*r)+128,1+(0===o?0:o<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const c=a.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,c,this.e2),a.primitiveLength++),s?this.e2=c:this.e1=c}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance()}}let Ch,Ih;Ws("LineBucket",Mh,{omit:["layers","patternFeatures"]});var Sh={get paint(){return Ih=Ih||new Mo({"line-opacity":new bo(_e.paint_line["line-opacity"]),"line-color":new bo(_e.paint_line["line-color"]),"line-translate":new vo(_e.paint_line["line-translate"]),"line-translate-anchor":new vo(_e.paint_line["line-translate-anchor"]),"line-width":new bo(_e.paint_line["line-width"]),"line-gap-width":new bo(_e.paint_line["line-gap-width"]),"line-offset":new bo(_e.paint_line["line-offset"]),"line-blur":new bo(_e.paint_line["line-blur"]),"line-dasharray":new To(_e.paint_line["line-dasharray"]),"line-pattern":new wo(_e.paint_line["line-pattern"]),"line-gradient":new Po(_e.paint_line["line-gradient"])})},get layout(){return Ch=Ch||new Mo({"line-cap":new vo(_e.layout_line["line-cap"]),"line-join":new bo(_e.layout_line["line-join"]),"line-miter-limit":new vo(_e.layout_line["line-miter-limit"]),"line-round-limit":new vo(_e.layout_line["line-round-limit"]),"line-sort-key":new bo(_e.layout_line["line-sort-key"])})}};class Eh extends bo{possiblyEvaluate(t,e){return e=new ho(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,i,r){return e=xt({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,i,r)}}let Ah;class zh extends Io{constructor(t){super(t,Sh),this.gradientVersion=0,Ah||(Ah=new Eh(Sh.paint.properties["line-width"].specification),Ah.useIntegerZoom=!0)}_handleSpecialPaintPropertyUpdate(t){if("line-gradient"===t){const t=this.gradientExpression();this.stepInterpolant=!!function(t){return void 0!==t._styleExpression}(t)&&t._styleExpression.expression instanceof Qi,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=Ah.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t)}createBucket(t){return new Mh(t)}queryRadius(t){const e=t,i=kh(Dl("line-width",this,e),Dl("line-gap-width",this,e)),r=Dl("line-offset",this,e);return i/2+Math.abs(r)+Rl(this.paint.get("line-translate"))}queryIntersectsFeature({queryGeometry:t,feature:e,featureState:i,geometry:r,transform:n,pixelsToTileUnits:s}){const o=Ll(t,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-n.bearingInRadians,s),a=s/2*kh(this.paint.get("line-width").evaluate(e,i),this.paint.get("line-gap-width").evaluate(e,i)),l=this.paint.get("line-offset").evaluate(e,i);return l&&(r=function(t,e){const i=[];for(let r=0;r<t.length;r++){const n=t[r],s=[];for(let t=0;t<n.length;t++){const i=n[t-1],r=n[t],o=n[t+1],a=0===t?new c(0,0):r.sub(i)._unit()._perp(),l=t===n.length-1?new c(0,0):o.sub(r)._unit()._perp(),h=a._add(l)._unit(),u=h.x*l.x+h.y*l.y;0!==u&&h._mult(1/u),s.push(h._mult(e)._add(r))}i.push(s)}return i}(r,l*s)),function(t,e,i){for(let r=0;r<e.length;r++){const n=e[r];if(t.length>=3)for(let e=0;e<n.length;e++)if(zl(t,n[e]))return!0;if(Ml(t,n,i))return!0}return!1}(o,r,a)}isTileClipped(){return!0}}function kh(t,e){return e>0?e+2*t:t}const Dh=zo([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),Rh=zo([{name:"a_projected_pos",components:3,type:"Float32"}],4);zo([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const Lh=zo([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);zo([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const Bh=zo([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),Fh=zo([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function Oh(t,e,i){return t.sections.forEach((t=>{t.text=function(t,e,i){const r=e.layout.get("text-transform").evaluate(i,{});return"uppercase"===r?t=t.toLocaleUpperCase():"lowercase"===r&&(t=t.toLocaleLowerCase()),co.applyArabicShaping&&(t=co.applyArabicShaping(t)),t}(t.text,e,i)})),t}zo([{name:"triangle",components:3,type:"Uint16"}]),zo([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),zo([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),zo([{type:"Float32",name:"offsetX"}]),zo([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),zo([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);const jh={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var Vh,Nh,Uh,Zh={};function Gh(){return Vh||(Vh=1,Zh.read=function(t,e,i,r,n){var s,o,a=8*n-r-1,l=(1<<a)-1,c=l>>1,h=-7,u=i?n-1:0,p=i?-1:1,d=t[e+u];for(u+=p,s=d&(1<<-h)-1,d>>=-h,h+=a;h>0;s=256*s+t[e+u],u+=p,h-=8);for(o=s&(1<<-h)-1,s>>=-h,h+=r;h>0;o=256*o+t[e+u],u+=p,h-=8);if(0===s)s=1-c;else{if(s===l)return o?NaN:1/0*(d?-1:1);o+=Math.pow(2,r),s-=c}return(d?-1:1)*o*Math.pow(2,s-r)},Zh.write=function(t,e,i,r,n,s){var o,a,l,c=8*s-n-1,h=(1<<c)-1,u=h>>1,p=23===n?Math.pow(2,-24)-Math.pow(2,-77):0,d=r?0:s-1,f=r?1:-1,m=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(a=isNaN(e)?1:0,o=h):(o=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-o))<1&&(o--,l*=2),(e+=o+u>=1?p/l:p*Math.pow(2,1-u))*l>=2&&(o++,l/=2),o+u>=h?(a=0,o=h):o+u>=1?(a=(e*l-1)*Math.pow(2,n),o+=u):(a=e*Math.pow(2,u-1)*Math.pow(2,n),o=0));n>=8;t[i+d]=255&a,d+=f,a/=256,n-=8);for(o=o<<n|a,c+=n;c>0;t[i+d]=255&o,d+=f,o/=256,c-=8);t[i+d-f]|=128*m}),Zh}var $h=function(){if(Uh)return Nh;Uh=1,Nh=e;var t=Gh();function e(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length}e.Varint=0,e.Fixed64=1,e.Bytes=2,e.Fixed32=5;var i=4294967296,r=1/i,n="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");function s(t){return t.type===e.Bytes?t.readVarint()+t.pos:t.pos+1}function o(t,e,i){return i?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function a(t,e,i){var r=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));i.realloc(r);for(var n=i.pos-1;n>=t;n--)i.buf[n+r]=i.buf[n]}function l(t,e){for(var i=0;i<t.length;i++)e.writeVarint(t[i])}function c(t,e){for(var i=0;i<t.length;i++)e.writeSVarint(t[i])}function h(t,e){for(var i=0;i<t.length;i++)e.writeFloat(t[i])}function u(t,e){for(var i=0;i<t.length;i++)e.writeDouble(t[i])}function p(t,e){for(var i=0;i<t.length;i++)e.writeBoolean(t[i])}function d(t,e){for(var i=0;i<t.length;i++)e.writeFixed32(t[i])}function f(t,e){for(var i=0;i<t.length;i++)e.writeSFixed32(t[i])}function m(t,e){for(var i=0;i<t.length;i++)e.writeFixed64(t[i])}function _(t,e){for(var i=0;i<t.length;i++)e.writeSFixed64(t[i])}function g(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function y(t,e,i){t[i]=e,t[i+1]=e>>>8,t[i+2]=e>>>16,t[i+3]=e>>>24}function x(t,e){return(t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}return e.prototype={destroy:function(){this.buf=null},readFields:function(t,e,i){for(i=i||this.length;this.pos<i;){var r=this.readVarint(),n=r>>3,s=this.pos;this.type=7&r,t(n,e,this),this.pos===s&&this.skip(r)}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=g(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=x(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=g(this.buf,this.pos)+g(this.buf,this.pos+4)*i;return this.pos+=8,t},readSFixed64:function(){var t=g(this.buf,this.pos)+x(this.buf,this.pos+4)*i;return this.pos+=8,t},readFloat:function(){var e=t.read(this.buf,this.pos,!0,23,4);return this.pos+=4,e},readDouble:function(){var e=t.read(this.buf,this.pos,!0,52,8);return this.pos+=8,e},readVarint:function(t){var e,i,r=this.buf;return e=127&(i=r[this.pos++]),i<128?e:(e|=(127&(i=r[this.pos++]))<<7,i<128?e:(e|=(127&(i=r[this.pos++]))<<14,i<128?e:(e|=(127&(i=r[this.pos++]))<<21,i<128?e:function(t,e,i){var r,n,s=i.buf;if(r=(112&(n=s[i.pos++]))>>4,n<128)return o(t,r,e);if(r|=(127&(n=s[i.pos++]))<<3,n<128)return o(t,r,e);if(r|=(127&(n=s[i.pos++]))<<10,n<128)return o(t,r,e);if(r|=(127&(n=s[i.pos++]))<<17,n<128)return o(t,r,e);if(r|=(127&(n=s[i.pos++]))<<24,n<128)return o(t,r,e);if(r|=(1&(n=s[i.pos++]))<<31,n<128)return o(t,r,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(i=r[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&n?function(t,e,i){return n.decode(t.subarray(e,i))}(this.buf,e,t):function(t,e,i){for(var r="",n=e;n<i;){var s,o,a,l=t[n],c=null,h=l>239?4:l>223?3:l>191?2:1;if(n+h>i)break;1===h?l<128&&(c=l):2===h?128==(192&(s=t[n+1]))&&(c=(31&l)<<6|63&s)<=127&&(c=null):3===h?(o=t[n+2],128==(192&(s=t[n+1]))&&128==(192&o)&&((c=(15&l)<<12|(63&s)<<6|63&o)<=2047||c>=55296&&c<=57343)&&(c=null)):4===h&&(o=t[n+2],a=t[n+3],128==(192&(s=t[n+1]))&&128==(192&o)&&128==(192&a)&&((c=(15&l)<<18|(63&s)<<12|(63&o)<<6|63&a)<=65535||c>=1114112)&&(c=null)),null===c?(c=65533,h=1):c>65535&&(c-=65536,r+=String.fromCharCode(c>>>10&1023|55296),c=56320|1023&c),r+=String.fromCharCode(c),n+=h}return r}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,i){if(this.type!==e.Bytes)return t.push(this.readVarint(i));var r=s(this);for(t=t||[];this.pos<r;)t.push(this.readVarint(i));return t},readPackedSVarint:function(t){if(this.type!==e.Bytes)return t.push(this.readSVarint());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==e.Bytes)return t.push(this.readBoolean());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==e.Bytes)return t.push(this.readFloat());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==e.Bytes)return t.push(this.readDouble());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed32());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed32());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readFixed64());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==e.Bytes)return t.push(this.readSFixed64());var i=s(this);for(t=t||[];this.pos<i;)t.push(this.readSFixed64());return t},skip:function(t){var i=7&t;if(i===e.Varint)for(;this.buf[this.pos++]>127;);else if(i===e.Bytes)this.pos=this.readVarint()+this.pos;else if(i===e.Fixed32)this.pos+=4;else{if(i!==e.Fixed64)throw new Error("Unimplemented type: "+i);this.pos+=8}},writeTag:function(t,e){this.writeVarint(t<<3|e)},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var i=new Uint8Array(e);i.set(this.buf),this.buf=i,this.length=e}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),y(this.buf,t,this.pos),this.pos+=4},writeSFixed32:function(t){this.realloc(4),y(this.buf,t,this.pos),this.pos+=4},writeFixed64:function(t){this.realloc(8),y(this.buf,-1&t,this.pos),y(this.buf,Math.floor(t*r),this.pos+4),this.pos+=8},writeSFixed64:function(t){this.realloc(8),y(this.buf,-1&t,this.pos),y(this.buf,Math.floor(t*r),this.pos+4),this.pos+=8},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var i,r;if(t>=0?(i=t%4294967296|0,r=t/4294967296|0):(r=~(-t/4294967296),4294967295^(i=~(-t%4294967296))?i=i+1|0:(i=0,r=r+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,i){i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,t>>>=7,i.buf[i.pos++]=127&t|128,i.buf[i.pos]=127&(t>>>=7)}(i,0,e),function(t,e){var i=(7&t)<<4;e.buf[e.pos++]|=i|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))))}(r,e)}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))))},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t)},writeBoolean:function(t){this.writeVarint(Boolean(t))},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,i){for(var r,n,s=0;s<e.length;s++){if((r=e.charCodeAt(s))>55295&&r<57344){if(!n){r>56319||s+1===e.length?(t[i++]=239,t[i++]=191,t[i++]=189):n=r;continue}if(r<56320){t[i++]=239,t[i++]=191,t[i++]=189,n=r;continue}r=n-55296<<10|r-56320|65536,n=null}else n&&(t[i++]=239,t[i++]=191,t[i++]=189,n=null);r<128?t[i++]=r:(r<2048?t[i++]=r>>6|192:(r<65536?t[i++]=r>>12|224:(t[i++]=r>>18|240,t[i++]=r>>12&63|128),t[i++]=r>>6&63|128),t[i++]=63&r|128)}return i}(this.buf,t,this.pos);var i=this.pos-e;i>=128&&a(e,i,this),this.pos=e-1,this.writeVarint(i),this.pos+=i},writeFloat:function(e){this.realloc(4),t.write(this.buf,e,this.pos,!0,23,4),this.pos+=4},writeDouble:function(e){this.realloc(8),t.write(this.buf,e,this.pos,!0,52,8),this.pos+=8},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var i=0;i<e;i++)this.buf[this.pos++]=t[i]},writeRawMessage:function(t,e){this.pos++;var i=this.pos;t(e,this);var r=this.pos-i;r>=128&&a(i,r,this),this.pos=i-1,this.writeVarint(r),this.pos+=r},writeMessage:function(t,i,r){this.writeTag(t,e.Bytes),this.writeRawMessage(i,r)},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,l,e)},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,c,e)},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,p,e)},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,h,e)},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,u,e)},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,d,e)},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,f,e)},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,m,e)},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,_,e)},writeBytesField:function(t,i){this.writeTag(t,e.Bytes),this.writeBytes(i)},writeFixed32Field:function(t,i){this.writeTag(t,e.Fixed32),this.writeFixed32(i)},writeSFixed32Field:function(t,i){this.writeTag(t,e.Fixed32),this.writeSFixed32(i)},writeFixed64Field:function(t,i){this.writeTag(t,e.Fixed64),this.writeFixed64(i)},writeSFixed64Field:function(t,i){this.writeTag(t,e.Fixed64),this.writeSFixed64(i)},writeVarintField:function(t,i){this.writeTag(t,e.Varint),this.writeVarint(i)},writeSVarintField:function(t,i){this.writeTag(t,e.Varint),this.writeSVarint(i)},writeStringField:function(t,i){this.writeTag(t,e.Bytes),this.writeString(i)},writeFloatField:function(t,i){this.writeTag(t,e.Fixed32),this.writeFloat(i)},writeDoubleField:function(t,i){this.writeTag(t,e.Fixed64),this.writeDouble(i)},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e))}},Nh}(),qh=s($h);const Wh=3;function Hh(t,e,i){1===t&&i.readMessage(Xh,e)}function Xh(t,e,i){if(3===t){const{id:t,bitmap:r,width:n,height:s,left:o,top:a,advance:l}=i.readMessage(Kh,{});e.push({id:t,bitmap:new Wl({width:n+2*Wh,height:s+2*Wh},r),metrics:{width:n,height:s,left:o,top:a,advance:l}})}}function Kh(t,e,i){1===t?e.id=i.readVarint():2===t?e.bitmap=i.readBytes():3===t?e.width=i.readVarint():4===t?e.height=i.readVarint():5===t?e.left=i.readSVarint():6===t?e.top=i.readSVarint():7===t&&(e.advance=i.readVarint())}function Yh(t){let e=0,i=0;for(const r of t)e+=r.w*r.h,i=Math.max(i,r.w);t.sort(((t,e)=>e.h-t.h));const r=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),i),h:1/0}];let n=0,s=0;for(const e of t)for(let t=r.length-1;t>=0;t--){const i=r[t];if(!(e.w>i.w||e.h>i.h)){if(e.x=i.x,e.y=i.y,s=Math.max(s,e.y+e.h),n=Math.max(n,e.x+e.w),e.w===i.w&&e.h===i.h){const e=r.pop();t<r.length&&(r[t]=e)}else e.h===i.h?(i.x+=e.w,i.w-=e.w):e.w===i.w?(i.y+=e.h,i.h-=e.h):(r.push({x:i.x+e.w,y:i.y,w:i.w-e.w,h:e.h}),i.y+=e.h,i.h-=e.h);break}}return{w:n,h:s,fill:e/(n*s)||0}}class Jh{constructor(t,{pixelRatio:e,version:i,stretchX:r,stretchY:n,content:s,textFitWidth:o,textFitHeight:a}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=r,this.stretchY=n,this.content=s,this.version=i,this.textFitWidth=o,this.textFitHeight=a}get tl(){return[this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return[this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return[(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}var Qh;function tu(t){let e=.5,i=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0}switch(t){case"bottom":case"bottom-right":case"bottom-left":i=1;break;case"top":case"top-right":case"top-left":i=0}return{horizontalAlign:e,verticalAlign:i}}Ws("ImagePosition",Jh),Ws("ImageAtlas",class{constructor(t,e){const i={},r={};this.haveRenderCallbacks=[];const n=[];this.addImages(t,i,n),this.addImages(e,r,n);const{w:s,h:o}=Yh(n),a=new Hl({width:s||1,height:o||1});for(const e in t){const r=t[e],n=i[e].paddedRect;Hl.copy(r.data,a,{x:0,y:0},{x:n.x+1,y:n.y+1},r.data)}for(const t in e){const i=e[t],n=r[t].paddedRect,s=n.x+1,o=n.y+1,l=i.data.width,c=i.data.height;Hl.copy(i.data,a,{x:0,y:0},{x:s,y:o},i.data),Hl.copy(i.data,a,{x:0,y:c-1},{x:s,y:o-1},{width:l,height:1}),Hl.copy(i.data,a,{x:0,y:0},{x:s,y:o+c},{width:l,height:1}),Hl.copy(i.data,a,{x:l-1,y:0},{x:s-1,y:o},{width:1,height:c}),Hl.copy(i.data,a,{x:0,y:0},{x:s+l,y:o},{width:1,height:c})}this.image=a,this.iconPositions=i,this.patternPositions=r}addImages(t,e,i){for(const r in t){const n=t[r],s={x:0,y:0,w:n.data.width+2,h:n.data.height+2};i.push(s),e[r]=new Jh(s,n),n.hasRenderCallback&&this.haveRenderCallbacks.push(r)}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const i in t.updatedImages)this.patchUpdatedImage(this.iconPositions[i],t.getImage(i),e),this.patchUpdatedImage(this.patternPositions[i],t.getImage(i),e)}patchUpdatedImage(t,e,i){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[r,n]=t.tl;i.update(e.data,void 0,{x:r,y:n})}}),function(t){t[t.none=0]="none",t[t.horizontal=1]="horizontal",t[t.vertical=2]="vertical",t[t.horizontalOnly=3]="horizontalOnly"}(Qh||(Qh={}));const eu=128,iu=255*eu;function ru(t,e){const{expression:i}=e;if("constant"===i.kind)return{kind:"constant",layoutSize:i.evaluate(new ho(t+1))};if("source"===i.kind)return{kind:"source"};{const{zoomStops:e,interpolationType:r}=i;let n=0;for(;n<e.length&&e[n]<=t;)n++;n=Math.max(0,n-1);let s=n;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const o=e[n],a=e[s];return"composite"===i.kind?{kind:"composite",minZoom:o,maxZoom:a,interpolationType:r}:{kind:"camera",minZoom:o,maxZoom:a,minSize:i.evaluate(new ho(o)),maxSize:i.evaluate(new ho(a)),interpolationType:r}}}function nu(t,{uSize:e,uSizeT:i},{lowerSize:r,upperSize:n}){return"source"===t.kind?r/eu:"composite"===t.kind?ar.number(r/eu,n/eu,i):e}function su(t,e){let i=0,r=0;if("constant"===t.kind)r=t.layoutSize;else if("source"!==t.kind){const{interpolationType:n,minZoom:s,maxZoom:o}=t,a=n?gt(sr.interpolationFactor(n,e,s,o),0,1):0;"camera"===t.kind?r=ar.number(t.minSize,t.maxSize,a):i=a}return{uSizeT:i,uSize:r}}function ou(t,e,i){let r="never";const n=t.get(e);return n?r=n:t.get(i)&&(r="always"),r}const au=sh.VectorTileFeature.types,lu=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function cu(t,e,i,r,n,s,o,a,l,c,h,u,p){const d=a?Math.min(iu,Math.round(a[0])):0,f=a?Math.min(iu,Math.round(a[1])):0;t.emplaceBack(e,i,Math.round(32*r),Math.round(32*n),s,o,(d<<1)+(l?1:0),f,16*c,16*h,256*u,256*p)}function hu(t,e,i){t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i),t.emplaceBack(e.x,e.y,i)}function uu(t){for(const e of t.sections)if(lo(e.text))return!0;return!1}class pu{constructor(t){this.layoutVertexArray=new Ta,this.indexArray=new Aa,this.programConfigurations=t,this.segments=new La,this.dynamicLayoutVertexArray=new Pa,this.opacityVertexArray=new Ma,this.hasVisibleVertices=!1,this.placedSymbolArray=new sa}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,i,r){this.isEmpty()||(i&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Dh.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,Rh.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,lu,!0),this.opacityVertexBuffer.itemSize=1),(i||r)&&this.programConfigurations.upload(t))}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy())}}Ws("SymbolBuffers",pu);class du{constructor(t,e,i){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new i,this.segments=new La,this.collisionVertexArray=new Sa}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,Lh.members,!0)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy())}}Ws("CollisionBuffers",du);class fu{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((t=>t.id)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=ru(this.zoom,e["text-size"]),this.iconSizeData=ru(this.zoom,e["icon-size"]);const i=this.layers[0].layout,r=i.get("symbol-sort-key"),n=i.get("symbol-z-order");this.canOverlap="never"!==ou(i,"text-overlap","text-allow-overlap")||"never"!==ou(i,"icon-overlap","icon-allow-overlap")||i.get("text-ignore-placement")||i.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==n&&!r.isConstant(),this.sortFeaturesByY=("viewport-y"===n||"auto"===n&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===i.get("symbol-placement")&&(this.writingModes=i.get("text-writing-mode").map((t=>Qh[t]))),this.stateDependentLayerIds=this.layers.filter((t=>t.isStateDependent())).map((t=>t.id)),this.sourceID=t.sourceID}createArrays(){this.text=new pu(new pl(this.layers,this.zoom,(t=>/^text/.test(t)))),this.icon=new pu(new pl(this.layers,this.zoom,(t=>/^icon/.test(t)))),this.glyphOffsetArray=new la,this.lineVertexArray=new ca,this.symbolInstances=new aa,this.textAnchorOffsets=new ua}calculateGlyphDependencies(t,e,i,r,n){for(let s=0;s<t.length;s++)if(e[t.charCodeAt(s)]=!0,(i||r)&&n){const i=jh[t.charAt(s)];i&&(e[i.charCodeAt(0)]=!0)}}populate(t,e,i){const r=this.layers[0],n=r.layout,s=n.get("text-font"),o=n.get("text-field"),a=n.get("icon-image"),l=("constant"!==o.value.kind||o.value.value instanceof Mi&&!o.value.value.isEmpty()||o.value.value.toString().length>0)&&("constant"!==s.value.kind||s.value.value.length>0),c="constant"!==a.value.kind||!!a.value.value||Object.keys(a.parameters).length>0,h=n.get("symbol-sort-key");if(this.features=[],!l&&!c)return;const u=e.iconDependencies,p=e.glyphDependencies,d=e.availableImages,f=new ho(this.zoom);for(const{feature:e,id:o,index:a,sourceLayerIndex:m}of t){const t=r._featureFilter.needGeometry,_=yl(e,t);if(!r._featureFilter.filter(f,_,i))continue;let g,y;if(t||(_.geometry=gl(e)),l){const t=r.getValueAndResolveTokens("text-field",_,i,d),e=Mi.factory(t),n=this.hasRTLText=this.hasRTLText||uu(e);(!n||"unavailable"===co.getRTLTextPluginStatus()||n&&co.isParsed())&&(g=Oh(e,r,_))}if(c){const t=r.getValueAndResolveTokens("icon-image",_,i,d);y=t instanceof Ai?t:Ai.fromString(t)}if(!g&&!y)continue;const x=this.sortFeaturesByKey?h.evaluate(_,{},i):void 0;if(this.features.push({id:o,text:g,icon:y,index:a,sourceLayerIndex:m,geometry:_.geometry,properties:e.properties,type:au[e.type],sortKey:x}),y&&(u[y.name]=!0),g){const t=s.evaluate(_,{},i).join(","),e="viewport"!==n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(Qh.vertical)>=0;for(const i of g.sections)if(i.image)u[i.image.name]=!0;else{const r=eo(g.toString()),n=i.fontStack||t,s=p[n]=p[n]||{};this.calculateGlyphDependencies(i.text,s,e,this.allowVerticalPlacement,r)}}}"line"===n.get("symbol-placement")&&(this.features=function(t){const e={},i={},r=[];let n=0;function s(e){r.push(t[e]),n++}function o(t,e,n){const s=i[t];return delete i[t],i[e]=s,r[s].geometry[0].pop(),r[s].geometry[0]=r[s].geometry[0].concat(n[0]),s}function a(t,i,n){const s=e[i];return delete e[i],e[t]=s,r[s].geometry[0].shift(),r[s].geometry[0]=n[0].concat(r[s].geometry[0]),s}function l(t,e,i){const r=i?e[0][e[0].length-1]:e[0][0];return`${t}:${r.x}:${r.y}`}for(let c=0;c<t.length;c++){const h=t[c],u=h.geometry,p=h.text?h.text.toString():null;if(!p){s(c);continue}const d=l(p,u),f=l(p,u,!0);if(d in i&&f in e&&i[d]!==e[f]){const t=a(d,f,u),n=o(d,f,r[t].geometry);delete e[d],delete i[f],i[l(p,r[n].geometry,!0)]=n,r[t].geometry=null}else d in i?o(d,f,u):f in e?a(d,f,u):(s(c),e[d]=n-1,i[f]=n-1)}return r.filter((t=>t.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((t,e)=>t.sortKey-e.sortKey))}update(t,e,i){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,i),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,i))}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return!this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy()}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData()}addToLineVertexArray(t,e){const i=this.lineVertexArray.length;if(void 0!==t.segment){let i=t.dist(e[t.segment+1]),r=t.dist(e[t.segment]);const n={};for(let r=t.segment+1;r<e.length;r++)n[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:i},r<e.length-1&&(i+=e[r+1].dist(e[r]));for(let i=t.segment||0;i>=0;i--)n[i]={x:e[i].x,y:e[i].y,tileUnitDistanceFromAnchor:r},i>0&&(r+=e[i-1].dist(e[i]));for(let t=0;t<e.length;t++){const e=n[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor)}}return{lineStartIndex:i,lineLength:this.lineVertexArray.length-i}}addSymbols(t,e,i,r,n,s,o,a,l,c,h,u){const p=t.indexArray,d=t.layoutVertexArray,f=t.segments.prepareSegment(4*e.length,d,p,this.canOverlap?s.sortKey:void 0),m=this.glyphOffsetArray.length,_=f.vertexLength,g=this.allowVerticalPlacement&&o===Qh.vertical?Math.PI/2:0,y=s.text&&s.text.sections;for(let r=0;r<e.length;r++){const{tl:n,tr:o,bl:l,br:c,tex:h,pixelOffsetTL:m,pixelOffsetBR:_,minFontScaleX:x,minFontScaleY:v,glyphOffset:b,isSDF:w,sectionIndex:T}=e[r],P=f.vertexLength,M=b[1];cu(d,a.x,a.y,n.x,M+n.y,h.x,h.y,i,w,m.x,m.y,x,v),cu(d,a.x,a.y,o.x,M+o.y,h.x+h.w,h.y,i,w,_.x,m.y,x,v),cu(d,a.x,a.y,l.x,M+l.y,h.x,h.y+h.h,i,w,m.x,_.y,x,v),cu(d,a.x,a.y,c.x,M+c.y,h.x+h.w,h.y+h.h,i,w,_.x,_.y,x,v),hu(t.dynamicLayoutVertexArray,a,g),p.emplaceBack(P,P+2,P+1),p.emplaceBack(P+1,P+2,P+3),f.vertexLength+=4,f.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(b[0]),r!==e.length-1&&T===e[r+1].sectionIndex||t.programConfigurations.populatePaintArrays(d.length,s,s.index,{},u,y&&y[T])}t.placedSymbolArray.emplaceBack(a.x,a.y,m,this.glyphOffsetArray.length-m,_,l,c,a.segment,i?i[0]:0,i?i[1]:0,r[0],r[1],o,0,!1,0,h)}_addCollisionDebugVertex(t,e,i,r,n,s){return e.emplaceBack(0,0),t.emplaceBack(i.x,i.y,r,n,Math.round(s.x),Math.round(s.y))}addCollisionDebugVertices(t,e,i,r,n,s,o){const a=n.segments.prepareSegment(4,n.layoutVertexArray,n.indexArray),l=a.vertexLength,h=n.layoutVertexArray,u=n.collisionVertexArray,p=o.anchorX,d=o.anchorY;this._addCollisionDebugVertex(h,u,s,p,d,new c(t,e)),this._addCollisionDebugVertex(h,u,s,p,d,new c(i,e)),this._addCollisionDebugVertex(h,u,s,p,d,new c(i,r)),this._addCollisionDebugVertex(h,u,s,p,d,new c(t,r)),a.vertexLength+=4;const f=n.indexArray;f.emplaceBack(l,l+1),f.emplaceBack(l+1,l+2),f.emplaceBack(l+2,l+3),f.emplaceBack(l+3,l),a.primitiveLength+=4}addDebugCollisionBoxes(t,e,i,r){for(let n=t;n<e;n++){const t=this.collisionBoxArray.get(n);this.addCollisionDebugVertices(t.x1,t.y1,t.x2,t.y2,r?this.textCollisionBox:this.iconCollisionBox,t.anchorPoint,i)}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new du(Ca,Bh.members,za),this.iconCollisionBox=new du(Ca,Bh.members,za);for(let t=0;t<this.symbolInstances.length;t++){const e=this.symbolInstances.get(t);this.addDebugCollisionBoxes(e.textBoxStartIndex,e.textBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.verticalTextBoxStartIndex,e.verticalTextBoxEndIndex,e,!0),this.addDebugCollisionBoxes(e.iconBoxStartIndex,e.iconBoxEndIndex,e,!1),this.addDebugCollisionBoxes(e.verticalIconBoxStartIndex,e.verticalIconBoxEndIndex,e,!1)}}_deserializeCollisionBoxesForSymbol(t,e,i,r,n,s,o,a,l){const c={};for(let r=e;r<i;r++){const e=t.get(r);c.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},c.textFeatureIndex=e.featureIndex;break}for(let e=r;e<n;e++){const i=t.get(e);c.verticalTextBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.verticalTextFeatureIndex=i.featureIndex;break}for(let e=s;e<o;e++){const i=t.get(e);c.iconBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.iconFeatureIndex=i.featureIndex;break}for(let e=a;e<l;e++){const i=t.get(e);c.verticalIconBox={x1:i.x1,y1:i.y1,x2:i.x2,y2:i.y2,anchorPointX:i.anchorPointX,anchorPointY:i.anchorPointY},c.verticalIconFeatureIndex=i.featureIndex;break}return c}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const i=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,i.textBoxStartIndex,i.textBoxEndIndex,i.verticalTextBoxStartIndex,i.verticalTextBoxEndIndex,i.iconBoxStartIndex,i.iconBoxEndIndex,i.verticalIconBoxStartIndex,i.verticalIconBoxEndIndex))}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const i=t.placedSymbolArray.get(e),r=i.vertexStartIndex+4*i.numGlyphs;for(let e=i.vertexStartIndex;e<r;e+=4)t.indexArray.emplaceBack(e,e+2,e+1),t.indexArray.emplaceBack(e+1,e+2,e+3)}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),i=Math.cos(t),r=[],n=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const o=this.symbolInstances.get(t);r.push(0|Math.round(e*o.anchorX+i*o.anchorY)),n.push(o.featureIndex)}return s.sort(((t,e)=>r[t]-r[e]||n[e]-n[t])),s}addToSortKeyRanges(t,e){const i=this.sortKeyRanges[this.sortKeyRanges.length-1];i&&i.sortKey===e?i.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1})}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach(((t,e,i)=>{t>=0&&i.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t)})),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex)}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray)}}}let mu,_u;Ws("SymbolBucket",fu,{omit:["layers","collisionBoxArray","features","compareText"]}),fu.MAX_GLYPHS=65535,fu.addDynamicAttributes=hu;var gu={get paint(){return _u=_u||new Mo({"icon-opacity":new bo(_e.paint_symbol["icon-opacity"]),"icon-color":new bo(_e.paint_symbol["icon-color"]),"icon-halo-color":new bo(_e.paint_symbol["icon-halo-color"]),"icon-halo-width":new bo(_e.paint_symbol["icon-halo-width"]),"icon-halo-blur":new bo(_e.paint_symbol["icon-halo-blur"]),"icon-translate":new vo(_e.paint_symbol["icon-translate"]),"icon-translate-anchor":new vo(_e.paint_symbol["icon-translate-anchor"]),"text-opacity":new bo(_e.paint_symbol["text-opacity"]),"text-color":new bo(_e.paint_symbol["text-color"],{runtimeType:Fe,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new bo(_e.paint_symbol["text-halo-color"]),"text-halo-width":new bo(_e.paint_symbol["text-halo-width"]),"text-halo-blur":new bo(_e.paint_symbol["text-halo-blur"]),"text-translate":new vo(_e.paint_symbol["text-translate"]),"text-translate-anchor":new vo(_e.paint_symbol["text-translate-anchor"])})},get layout(){return mu=mu||new Mo({"symbol-placement":new vo(_e.layout_symbol["symbol-placement"]),"symbol-spacing":new vo(_e.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new vo(_e.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new bo(_e.layout_symbol["symbol-sort-key"]),"symbol-z-order":new vo(_e.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new vo(_e.layout_symbol["icon-allow-overlap"]),"icon-overlap":new vo(_e.layout_symbol["icon-overlap"]),"icon-ignore-placement":new vo(_e.layout_symbol["icon-ignore-placement"]),"icon-optional":new vo(_e.layout_symbol["icon-optional"]),"icon-rotation-alignment":new vo(_e.layout_symbol["icon-rotation-alignment"]),"icon-size":new bo(_e.layout_symbol["icon-size"]),"icon-text-fit":new vo(_e.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new vo(_e.layout_symbol["icon-text-fit-padding"]),"icon-image":new bo(_e.layout_symbol["icon-image"]),"icon-rotate":new bo(_e.layout_symbol["icon-rotate"]),"icon-padding":new bo(_e.layout_symbol["icon-padding"]),"icon-keep-upright":new vo(_e.layout_symbol["icon-keep-upright"]),"icon-offset":new bo(_e.layout_symbol["icon-offset"]),"icon-anchor":new bo(_e.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new vo(_e.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new vo(_e.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new vo(_e.layout_symbol["text-rotation-alignment"]),"text-field":new bo(_e.layout_symbol["text-field"]),"text-font":new bo(_e.layout_symbol["text-font"]),"text-size":new bo(_e.layout_symbol["text-size"]),"text-max-width":new bo(_e.layout_symbol["text-max-width"]),"text-line-height":new vo(_e.layout_symbol["text-line-height"]),"text-letter-spacing":new bo(_e.layout_symbol["text-letter-spacing"]),"text-justify":new bo(_e.layout_symbol["text-justify"]),"text-radial-offset":new bo(_e.layout_symbol["text-radial-offset"]),"text-variable-anchor":new vo(_e.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new bo(_e.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new bo(_e.layout_symbol["text-anchor"]),"text-max-angle":new vo(_e.layout_symbol["text-max-angle"]),"text-writing-mode":new vo(_e.layout_symbol["text-writing-mode"]),"text-rotate":new bo(_e.layout_symbol["text-rotate"]),"text-padding":new vo(_e.layout_symbol["text-padding"]),"text-keep-upright":new vo(_e.layout_symbol["text-keep-upright"]),"text-transform":new bo(_e.layout_symbol["text-transform"]),"text-offset":new bo(_e.layout_symbol["text-offset"]),"text-allow-overlap":new vo(_e.layout_symbol["text-allow-overlap"]),"text-overlap":new vo(_e.layout_symbol["text-overlap"]),"text-ignore-placement":new vo(_e.layout_symbol["text-ignore-placement"]),"text-optional":new vo(_e.layout_symbol["text-optional"])})}};class yu{constructor(t){if(void 0===t.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=t.property.overrides?t.property.overrides.runtimeType:De,this.defaultValue=t}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression)}outputDefined(){return!1}serialize(){return null}}Ws("FormatSectionOverride",yu,{omit:["defaultValue"]});class xu extends Io{constructor(t){super(t,gu)}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const i of t)e.indexOf(i)<0&&e.push(i);this.layout._values["text-writing-mode"]=e}else this.layout._values["text-writing-mode"]=["horizontal"]}this._setPaintOverrides()}getValueAndResolveTokens(t,e,i,r){const n=this.layout.get(t).evaluate(e,{},i,r),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||Wn(s.value)||!n?n:function(t,e){return e.replace(/{([^{}]+)}/g,((e,i)=>t&&i in t?String(t[i]):""))}(e.properties,n)}createBucket(t){return new fu(t)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const t of gu.paint.overridableProperties){if(!xu.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),i=new yu(e),r=new qn(i,e.property.specification);let n=null;n="constant"===e.value.kind||"source"===e.value.kind?new Xn("source",r):new Kn("composite",r,e.value.zoomStops),this.paint._values[t]=new yo(e.property,n,e.parameters)}}_handleOverridablePaintPropertyUpdate(t,e,i){return!(!this.layout||e.isDataDriven()||i.isDataDriven())&&xu.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const i=t.get("text-field"),r=gu.paint.properties[e];let n=!1;const s=t=>{for(const e of t)if(r.overrides&&r.overrides.hasOverride(e))return void(n=!0)};if("constant"===i.value.kind&&i.value.value instanceof Mi)s(i.value.value.sections);else if("source"===i.value.kind){const t=e=>{n||(e instanceof Bi&&Ri(e.value)===Ue?s(e.value.sections):e instanceof vr?s(e.sections):e.eachChild(t))},e=i.value;e._styleExpression&&t(e._styleExpression.expression)}return n}}let vu;var bu={get paint(){return vu=vu||new Mo({"background-color":new vo(_e.paint_background["background-color"]),"background-pattern":new To(_e.paint_background["background-pattern"]),"background-opacity":new vo(_e.paint_background["background-opacity"])})}};class wu extends Io{constructor(t){super(t,bu)}}let Tu;var Pu={get paint(){return Tu=Tu||new Mo({"raster-opacity":new vo(_e.paint_raster["raster-opacity"]),"raster-hue-rotate":new vo(_e.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new vo(_e.paint_raster["raster-brightness-min"]),"raster-brightness-max":new vo(_e.paint_raster["raster-brightness-max"]),"raster-saturation":new vo(_e.paint_raster["raster-saturation"]),"raster-contrast":new vo(_e.paint_raster["raster-contrast"]),"raster-resampling":new vo(_e.paint_raster["raster-resampling"]),"raster-fade-duration":new vo(_e.paint_raster["raster-fade-duration"])})}};class Mu extends Io{constructor(t){super(t,Pu)}}class Cu extends Io{constructor(t){super(t,{}),this.onAdd=t=>{this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl)},this.onRemove=t=>{this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl)},this.implementation=t}is3D(){return"3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return!1}serialize(){throw new Error("Custom layers cannot be serialized")}}function Iu(t){if("custom"===t.type)return new Cu(t);switch(t.type){case"background":return new wu(t);case"circle":return new jl(t);case"fill":return new Gc(t);case"fill-extrusion":return new mh(t);case"heatmap":return new Yl(t);case"hillshade":return new tc(t);case"line":return new zh(t);case"raster":return new Mu(t);case"symbol":return new xu(t)}}function Su(t){const e=[];if("string"==typeof t)e.push({id:"default",url:t});else if(t&&t.length>0){const i=[];for(const{id:r,url:n}of t){const t=`${r}${n}`;-1===i.indexOf(t)&&(i.push(t),e.push({id:r,url:n}))}}return e}function Eu(t,e,i){try{const r=new URL(t);return r.pathname+=`${e}${i}`,r.toString()}catch(e){throw new Error(`Invalid sprite URL "${t}", must be absolute. Modify style specification directly or use TransformStyleFunction to correct the issue dynamically`)}}class Au{constructor(t,e,i,r){this.context=t,this.format=i,this.texture=t.gl.createTexture(),this.update(e,r)}update(t,e,i){const{width:r,height:n}=t,s=!(this.size&&this.size[0]===r&&this.size[1]===n||i),{context:o}=this,{gl:a}=o;if(this.useMipmap=Boolean(e&&e.useMipmap),a.bindTexture(a.TEXTURE_2D,this.texture),o.pixelStoreUnpackFlipY.set(!1),o.pixelStoreUnpack.set(1),o.pixelStoreUnpackPremultiplyAlpha.set(this.format===a.RGBA&&(!e||!1!==e.premultiply)),s)this.size=[r,n],t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||Rt(t)?a.texImage2D(a.TEXTURE_2D,0,this.format,this.format,a.UNSIGNED_BYTE,t):a.texImage2D(a.TEXTURE_2D,0,this.format,r,n,0,this.format,a.UNSIGNED_BYTE,t.data);else{const{x:e,y:s}=i||{x:0,y:0};t instanceof HTMLImageElement||t instanceof HTMLCanvasElement||t instanceof HTMLVideoElement||t instanceof ImageData||Rt(t)?a.texSubImage2D(a.TEXTURE_2D,0,e,s,a.RGBA,a.UNSIGNED_BYTE,t):a.texSubImage2D(a.TEXTURE_2D,0,e,s,r,n,a.RGBA,a.UNSIGNED_BYTE,t.data)}this.useMipmap&&this.isSizePowerOfTwo()&&a.generateMipmap(a.TEXTURE_2D)}bind(t,e,i){const{context:r}=this,{gl:n}=r;n.bindTexture(n.TEXTURE_2D,this.texture),i!==n.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(i=n.LINEAR),t!==this.filter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,i||t),this.filter=t),e!==this.wrap&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrap=e)}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null}}function zu(t){const{userImage:e}=t;return!!(e&&e.render&&e.render())&&(t.data.replace(new Uint8Array(e.data.buffer)),!0)}class ku extends me{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new Hl({width:1,height:1}),this.dirty=!0}isLoaded(){return this.loaded}setLoaded(t){if(this.loaded!==t&&(this.loaded=t,t)){for(const{ids:t,promiseResolve:e}of this.requestors)e(this._getImagesForIds(t));this.requestors=[]}}getImage(t){const e=this.images[t];if(e&&!e.data&&e.spriteData){const t=e.spriteData;e.data=new Hl({width:t.width,height:t.height},t.context.getImageData(t.x,t.y,t.width,t.height).data),e.spriteData=null}return e}addImage(t,e){if(this.images[t])throw new Error(`Image id ${t} already exist, use updateImage instead`);this._validate(t,e)&&(this.images[t]=e)}_validate(t,e){let i=!0;const r=e.data||e.spriteData;return this._validateStretch(e.stretchX,r&&r.width)||(this.fire(new fe(new Error(`Image "${t}" has invalid "stretchX" value`))),i=!1),this._validateStretch(e.stretchY,r&&r.height)||(this.fire(new fe(new Error(`Image "${t}" has invalid "stretchY" value`))),i=!1),this._validateContent(e.content,e)||(this.fire(new fe(new Error(`Image "${t}" has invalid "content" value`))),i=!1),i}_validateStretch(t,e){if(!t)return!0;let i=0;for(const r of t){if(r[0]<i||r[1]<r[0]||e<r[1])return!1;i=r[1]}return!0}_validateContent(t,e){if(!t)return!0;if(4!==t.length)return!1;const i=e.spriteData,r=i&&i.width||e.data.width,n=i&&i.height||e.data.height;return!(t[0]<0||r<t[0]||t[1]<0||n<t[1]||t[2]<0||r<t[2]||t[3]<0||n<t[3]||t[2]<t[0]||t[3]<t[1])}updateImage(t,e,i=!0){const r=this.getImage(t);if(i&&(r.data.width!==e.data.width||r.data.height!==e.data.height))throw new Error(`size mismatch between old image (${r.data.width}x${r.data.height}) and new image (${e.data.width}x${e.data.height}).`);e.version=r.version+1,this.images[t]=e,this.updatedImages[t]=!0}removeImage(t){const e=this.images[t];delete this.images[t],delete this.patterns[t],e.userImage&&e.userImage.onRemove&&e.userImage.onRemove()}listImages(){return Object.keys(this.images)}getImages(t){return new Promise(((e,i)=>{let r=!0;if(!this.isLoaded())for(const e of t)this.images[e]||(r=!1);this.isLoaded()||r?e(this._getImagesForIds(t)):this.requestors.push({ids:t,promiseResolve:e})}))}_getImagesForIds(t){const e={};for(const i of t){let t=this.getImage(i);t||(this.fire(new de("styleimagemissing",{id:i})),t=this.getImage(i)),t?e[i]={data:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,textFitWidth:t.textFitWidth,textFitHeight:t.textFitHeight,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)}:At(`Image "${i}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`)}return e}getPixelSize(){const{width:t,height:e}=this.atlasImage;return{width:t,height:e}}getPattern(t){const e=this.patterns[t],i=this.getImage(t);if(!i)return null;if(e&&e.position.version===i.version)return e.position;if(e)e.position.version=i.version;else{const e={w:i.data.width+2,h:i.data.height+2,x:0,y:0},r=new Jh(e,i);this.patterns[t]={bin:e,position:r}}return this._updatePatternAtlas(),this.patterns[t].position}bind(t){const e=t.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new Au(t,this.atlasImage,e.RGBA),this.atlasTexture.bind(e.LINEAR,e.CLAMP_TO_EDGE)}_updatePatternAtlas(){const t=[];for(const e in this.patterns)t.push(this.patterns[e].bin);const{w:e,h:i}=Yh(t),r=this.atlasImage;r.resize({width:e||1,height:i||1});for(const t in this.patterns){const{bin:e}=this.patterns[t],i=e.x+1,n=e.y+1,s=this.getImage(t).data,o=s.width,a=s.height;Hl.copy(s,r,{x:0,y:0},{x:i,y:n},{width:o,height:a}),Hl.copy(s,r,{x:0,y:a-1},{x:i,y:n-1},{width:o,height:1}),Hl.copy(s,r,{x:0,y:0},{x:i,y:n+a},{width:o,height:1}),Hl.copy(s,r,{x:o-1,y:0},{x:i-1,y:n},{width:1,height:a}),Hl.copy(s,r,{x:0,y:0},{x:i+o,y:n},{width:1,height:a})}this.dirty=!0}beginFrame(){this.callbackDispatchedThisFrame={}}dispatchRenderCallbacks(t){for(const e of t){if(this.callbackDispatchedThisFrame[e])continue;this.callbackDispatchedThisFrame[e]=!0;const t=this.getImage(e);t||At(`Image with ID: "${e}" was not found`),zu(t)&&this.updateImage(e,t)}}}const Du=1e20;function Ru(t,e,i,r,n,s,o,a,l){for(let c=e;c<e+r;c++)Lu(t,i*s+c,s,n,o,a,l);for(let c=i;c<i+n;c++)Lu(t,c*s+e,1,r,o,a,l)}function Lu(t,e,i,r,n,s,o){s[0]=0,o[0]=-1e20,o[1]=Du,n[0]=t[e];for(let a=1,l=0,c=0;a<r;a++){n[a]=t[e+a*i];const r=a*a;do{const t=s[l];c=(n[a]-n[t]+r-t*t)/(a-t)/2}while(c<=o[l]&&--l>-1);l++,s[l]=a,o[l]=c,o[l+1]=Du}for(let a=0,l=0;a<r;a++){for(;o[l+1]<a;)l++;const r=s[l],c=a-r;t[e+a*i]=n[r]+c*c}}class Bu{constructor(t,e){this.requestManager=t,this.localIdeographFontFamily=e,this.entries={}}setURL(t){this.url=t}getGlyphs(t){return n(this,void 0,void 0,(function*(){const e=[];for(const i in t)for(const r of t[i])e.push(this._getAndCacheGlyphsPromise(i,r));const i=yield Promise.all(e),r={};for(const{stack:t,id:e,glyph:n}of i)r[t]||(r[t]={}),r[t][e]=n&&{id:n.id,bitmap:n.bitmap.clone(),metrics:n.metrics};return r}))}_getAndCacheGlyphsPromise(t,e){return n(this,void 0,void 0,(function*(){let i=this.entries[t];i||(i=this.entries[t]={glyphs:{},requests:{},ranges:{}});let r=i.glyphs[e];if(void 0!==r)return{stack:t,id:e,glyph:r};if(r=this._tinySDF(i,t,e),r)return i.glyphs[e]=r,{stack:t,id:e,glyph:r};const n=Math.floor(e/256);if(256*n>65535)throw new Error("glyphs > 65535 not supported");if(i.ranges[n])return{stack:t,id:e,glyph:r};if(!this.url)throw new Error("glyphsUrl is not set");if(!i.requests[n]){const e=Bu.loadGlyphRange(t,n,this.url,this.requestManager);i.requests[n]=e}const s=yield i.requests[n];for(const t in s)this._doesCharSupportLocalGlyph(+t)||(i.glyphs[+t]=s[+t]);return i.ranges[n]=!0,{stack:t,id:e,glyph:s[e]||null}}))}_doesCharSupportLocalGlyph(t){return!!this.localIdeographFontFamily&&(/\p{Ideo}|\p{sc=Hang}|\p{sc=Hira}|\p{sc=Kana}/u.test(String.fromCodePoint(t))||to["CJK Unified Ideographs"](t)||to["Hangul Syllables"](t)||to.Hiragana(t)||to.Katakana(t)||to["CJK Symbols and Punctuation"](t)||to["Halfwidth and Fullwidth Forms"](t))}_tinySDF(t,e,i){const r=this.localIdeographFontFamily;if(!r)return;if(!this._doesCharSupportLocalGlyph(i))return;let n=t.tinySDF;if(!n){let i="400";/bold/i.test(e)?i="900":/medium/i.test(e)?i="500":/light/i.test(e)&&(i="200"),n=t.tinySDF=new Bu.TinySDF({fontSize:48,buffer:6,radius:16,cutoff:.25,fontFamily:r,fontWeight:i})}const s=n.draw(String.fromCharCode(i));return{id:i,bitmap:new Wl({width:s.width||60,height:s.height||60},s.data),metrics:{width:s.glyphWidth/2||24,height:s.glyphHeight/2||24,left:s.glyphLeft/2+.5||0,top:s.glyphTop/2-27.5||-8,advance:s.glyphAdvance/2||24,isDoubleResolution:!0}}}}Bu.loadGlyphRange=function(t,e,i,r){return n(this,void 0,void 0,(function*(){const n=256*e,s=n+255,o=r.transformRequest(i.replace("{fontstack}",t).replace("{range}",`${n}-${s}`),"Glyphs"),a=yield(l=o,c=new AbortController,te(xt(l,{type:"arrayBuffer"}),c));var l,c;if(!a||!a.data)throw new Error(`Could not load glyph range. range: ${e}, ${n}-${s}`);const h={};for(const t of new qh(a.data).readFields(Hh,[]))h[t.id]=t;return h}))},Bu.TinySDF=class{constructor({fontSize:t=24,buffer:e=3,radius:i=8,cutoff:r=.25,fontFamily:n="sans-serif",fontWeight:s="normal",fontStyle:o="normal"}={}){this.buffer=e,this.cutoff=r,this.radius=i;const a=this.size=t+4*e,l=this._createCanvas(a),c=this.ctx=l.getContext("2d",{willReadFrequently:!0});c.font=`${o} ${s} ${t}px ${n}`,c.textBaseline="alphabetic",c.textAlign="left",c.fillStyle="black",this.gridOuter=new Float64Array(a*a),this.gridInner=new Float64Array(a*a),this.f=new Float64Array(a),this.z=new Float64Array(a+1),this.v=new Uint16Array(a)}_createCanvas(t){const e=document.createElement("canvas");return e.width=e.height=t,e}draw(t){const{width:e,actualBoundingBoxAscent:i,actualBoundingBoxDescent:r,actualBoundingBoxLeft:n,actualBoundingBoxRight:s}=this.ctx.measureText(t),o=Math.ceil(i),a=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(s-n))),l=Math.min(this.size-this.buffer,o+Math.ceil(r)),c=a+2*this.buffer,h=l+2*this.buffer,u=Math.max(c*h,0),p=new Uint8ClampedArray(u),d={data:p,width:c,height:h,glyphWidth:a,glyphHeight:l,glyphTop:o,glyphLeft:0,glyphAdvance:e};if(0===a||0===l)return d;const{ctx:f,buffer:m,gridInner:_,gridOuter:g}=this;f.clearRect(m,m,a,l),f.fillText(t,m,m+o);const y=f.getImageData(m,m,a,l);g.fill(Du,0,u),_.fill(0,0,u);for(let t=0;t<l;t++)for(let e=0;e<a;e++){const i=y.data[4*(t*a+e)+3]/255;if(0===i)continue;const r=(t+m)*c+e+m;if(1===i)g[r]=0,_[r]=Du;else{const t=.5-i;g[r]=t>0?t*t:0,_[r]=t<0?t*t:0}}Ru(g,0,0,c,h,c,this.f,this.v,this.z),Ru(_,m,m,a,l,c,this.f,this.v,this.z);for(let t=0;t<u;t++){const e=Math.sqrt(g[t])-Math.sqrt(_[t]);p[t]=Math.round(255-255*(e/this.radius+this.cutoff))}return d}};class Fu{constructor(){this.specification=_e.light.position}possiblyEvaluate(t,e){return function([t,e,i]){return e+=90,e*=Math.PI/180,i*=Math.PI/180,{x:t*Math.cos(e)*Math.sin(i),y:t*Math.sin(e)*Math.sin(i),z:t*Math.cos(i)}}(t.expression.evaluate(e))}interpolate(t,e,i){return{x:ar.number(t.x,e.x,i),y:ar.number(t.y,e.y,i),z:ar.number(t.z,e.z,i)}}}let Ou;class ju extends me{constructor(t){super(),Ou=Ou||new Mo({anchor:new vo(_e.light.anchor),position:new Fu,color:new vo(_e.light.color),intensity:new vo(_e.light.intensity)}),this._transitionable=new fo(Ou),this.setLight(t),this._transitioning=this._transitionable.untransitioned()}getLight(){return this._transitionable.serialize()}setLight(t,e={}){if(!this._validate(Vs,t,e))for(const e in t){const i=t[e];e.endsWith("-transition")?this._transitionable.setTransition(e.slice(0,-11),i):this._transitionable.setValue(e,i)}}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}_validate(t,e,i){return(!i||!1!==i.validate)&&Gs(this,t.call(js,{value:e,style:{glyphs:!0,sprite:!0},styleSpec:_e}))}}const Vu=new Mo({"sky-color":new vo(_e.sky["sky-color"]),"horizon-color":new vo(_e.sky["horizon-color"]),"fog-color":new vo(_e.sky["fog-color"]),"fog-ground-blend":new vo(_e.sky["fog-ground-blend"]),"horizon-fog-blend":new vo(_e.sky["horizon-fog-blend"]),"sky-horizon-blend":new vo(_e.sky["sky-horizon-blend"]),"atmosphere-blend":new vo(_e.sky["atmosphere-blend"])});class Nu extends me{constructor(t){super(),this._transitionable=new fo(Vu),this.setSky(t),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new ho(0))}setSky(t,e={}){if(!this._validate(Ns,t,e)){t||(t={"sky-color":"transparent","horizon-color":"transparent","fog-color":"transparent","fog-ground-blend":1,"atmosphere-blend":0});for(const e in t){const i=t[e];e.endsWith("-transition")?this._transitionable.setTransition(e.slice(0,-11),i):this._transitionable.setValue(e,i)}}}getSky(){return this._transitionable.serialize()}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}_validate(t,e,i={}){return!1!==(null==i?void 0:i.validate)&&Gs(this,t.call(js,xt({value:e,style:{glyphs:!0,sprite:!0},styleSpec:_e})))}calculateFogBlendOpacity(t){return t<60?0:t<70?(t-60)/10:1}}class Uu{constructor(t,e){this.width=t,this.height=e,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={}}getDash(t,e){const i=t.join(",")+String(e);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(t,e)),this.dashEntry[i]}getDashRanges(t,e,i){const r=[];let n=t.length%2==1?-t[t.length-1]*i:0,s=t[0]*i,o=!0;r.push({left:n,right:s,isDash:o,zeroLength:0===t[0]});let a=t[0];for(let e=1;e<t.length;e++){o=!o;const l=t[e];n=a*i,a+=l,s=a*i,r.push({left:n,right:s,isDash:o,zeroLength:0===l})}return r}addRoundDash(t,e,i){const r=e/2;for(let e=-i;e<=i;e++){const n=this.width*(this.nextRow+i+e);let s=0,o=t[s];for(let a=0;a<this.width;a++){a/o.right>1&&(o=t[++s]);const l=Math.abs(a-o.left),c=Math.abs(a-o.right),h=Math.min(l,c);let u;const p=e/i*(r+1);if(o.isDash){const t=r-Math.abs(p);u=Math.sqrt(h*h+t*t)}else u=r-Math.sqrt(h*h+p*p);this.data[n+a]=Math.max(0,Math.min(255,u+128))}}}addRegularDash(t){for(let e=t.length-1;e>=0;--e){const i=t[e],r=t[e+1];i.zeroLength?t.splice(e,1):r&&r.isDash===i.isDash&&(r.left=i.left,t.splice(e,1))}const e=t[0],i=t[t.length-1];e.isDash===i.isDash&&(e.left=i.left-this.width,i.right=e.right+this.width);const r=this.width*this.nextRow;let n=0,s=t[n];for(let e=0;e<this.width;e++){e/s.right>1&&(s=t[++n]);const i=Math.abs(e-s.left),o=Math.abs(e-s.right),a=Math.min(i,o);this.data[r+e]=Math.max(0,Math.min(255,(s.isDash?a:-a)+128))}}addDash(t,e){const i=e?7:0,r=2*i+1;if(this.nextRow+r>this.height)return At("LineAtlas out of space"),null;let n=0;for(let e=0;e<t.length;e++)n+=t[e];if(0!==n){const r=this.width/n,s=this.getDashRanges(t,this.width,r);e?this.addRoundDash(s,r,i):this.addRegularDash(s)}const s={y:(this.nextRow+i+.5)/this.height,height:2*i/this.height,width:n};return this.nextRow+=r,this.dirty=!0,s}bind(t){const e=t.gl;this.texture?(e.bindTexture(e.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,e.texSubImage2D(e.TEXTURE_2D,0,0,0,this.width,this.height,e.ALPHA,e.UNSIGNED_BYTE,this.data))):(this.texture=e.createTexture(),e.bindTexture(e.TEXTURE_2D,this.texture),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.REPEAT),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texImage2D(e.TEXTURE_2D,0,e.ALPHA,this.width,this.height,0,e.ALPHA,e.UNSIGNED_BYTE,this.data))}}class Zu{constructor(t){this._methodToThrottle=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle()})}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle()}),0))}remove(){delete this._channel,this._methodToThrottle=()=>{}}}const Gu={once:!0};class $u{constructor(t,e){this.target=t,this.mapId=e,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new Zu((()=>this.process())),this.subscription=Bt(this.target,"message",(t=>this.receive(t)),!1),this.globalScope=kt(self)?t:window}registerMessageHandler(t,e){this.messageHandlers[t]=e}sendAsync(t,e){return new Promise(((i,r)=>{const n=Math.round(1e18*Math.random()).toString(36).substring(0,10),s=e?Bt(e.signal,"abort",(()=>{null==s||s.unsubscribe(),delete this.resolveRejects[n];const e={id:n,type:"<cancel>",origin:location.origin,targetMapId:t.targetMapId,sourceMapId:this.mapId};this.target.postMessage(e)}),Gu):null;this.resolveRejects[n]={resolve:t=>{null==s||s.unsubscribe(),i(t)},reject:t=>{null==s||s.unsubscribe(),r(t)}};const o=[],a=Object.assign(Object.assign({},t),{id:n,sourceMapId:this.mapId,origin:location.origin,data:Ys(t.data,o)});this.target.postMessage(a,{transfer:o})}))}receive(t){const e=t.data,i=e.id;if(!("file://"!==e.origin&&"file://"!==location.origin&&"resource://android"!==e.origin&&"resource://android"!==location.origin&&e.origin!==location.origin||e.targetMapId&&this.mapId!==e.targetMapId)){if("<cancel>"===e.type){delete this.tasks[i];const t=this.abortControllers[i];return delete this.abortControllers[i],void(t&&t.abort())}if(kt(self)||e.mustQueue)return this.tasks[i]=e,this.taskQueue.push(i),void this.invoker.trigger();this.processTask(i,e)}}process(){if(0===this.taskQueue.length)return;const t=this.taskQueue.shift(),e=this.tasks[t];delete this.tasks[t],this.taskQueue.length>0&&this.invoker.trigger(),e&&this.processTask(t,e)}processTask(t,e){return n(this,void 0,void 0,(function*(){if("<response>"===e.type){const i=this.resolveRejects[t];if(delete this.resolveRejects[t],!i)return;return void(e.error?i.reject(Js(e.error)):i.resolve(Js(e.data)))}if(!this.messageHandlers[e.type])return void this.completeTask(t,new Error(`Could not find a registered handler for ${e.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const i=Js(e.data),r=new AbortController;this.abortControllers[t]=r;try{const n=yield this.messageHandlers[e.type](e.sourceMapId,i,r);this.completeTask(t,null,n)}catch(e){this.completeTask(t,e)}}))}completeTask(t,e,i){const r=[];delete this.abortControllers[t];const n={id:t,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:e?Ys(e):null,data:Ys(i,r)};this.target.postMessage(n,{transfer:r})}remove(){this.invoker.remove(),this.subscription.unsubscribe()}}const qu="maplibre_preloaded_worker_pool";class Wu{constructor(){this.active={}}acquire(t){if(!this.workers)for(this.workers=[];this.workers.length<Wu.workerCount;)this.workers.push(new Worker(Xt.WORKER_URL));return this.active[t]=!0,this.workers.slice()}release(t){delete this.active[t],0===this.numActive()&&(this.workers.forEach((t=>{t.terminate()})),this.workers=null)}isPreloaded(){return!!this.active[qu]}numActive(){return Object.keys(this.active).length}}const Hu=Math.floor(Wt.hardwareConcurrency/2);let Xu,Ku;function Yu(){return Xu||(Xu=new Wu),Xu}Wu.workerCount=function(t){if(null==Dt){const e=t.navigator?t.navigator.userAgent:null;Dt=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")))}return Dt}(globalThis)?Math.max(Math.min(Hu,3),1):1;class Ju{constructor(t,e){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=e;const i=this.workerPool.acquire(e);for(let t=0;t<i.length;t++){const r=new $u(i[t],e);r.name=`Worker ${t}`,this.actors.push(r)}if(!this.actors.length)throw new Error("No actors found")}broadcast(t,e){const i=[];for(const r of this.actors)i.push(r.sendAsync({type:t,data:e}));return Promise.all(i)}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(t=!0){this.actors.forEach((t=>{t.remove()})),this.actors=[],t&&this.workerPool.release(this.id)}registerMessageHandler(t,e){for(const i of this.actors)i.registerMessageHandler(t,e)}}function Qu(){return Ku||(Ku=new Ju(Yu(),Yt),Ku.registerMessageHandler("GR",((t,e,i)=>te(e,i)))),Ku}function tp(t,e){const i=x();return P(i,i,[1,1,0]),M(i,i,[.5*t.width,.5*t.height,1]),t.calculatePosMatrix?T(i,i,t.calculatePosMatrix(e.toUnwrapped())):i}function ep(t,e,i,r,n,s){var o;const a=function(t,e,i){if(t)for(const r of t){const t=e[r];if(t&&t.source===i&&"fill-extrusion"===t.type)return!0}else for(const t in e){const r=e[t];if(r.source===i&&"fill-extrusion"===r.type)return!0}return!1}(null!==(o=null==n?void 0:n.layers)&&void 0!==o?o:null,e,t.id),l=s.maxPitchScaleFactor(),c=t.tilesIn(r,l,a);c.sort(ip);const h=[];for(const r of c)h.push({wrappedTileID:r.tileID.wrapped().key,queryResults:r.tile.queryRenderedFeatures(e,i,t._state,r.queryGeometry,r.cameraQueryGeometry,r.scale,n,s,l,tp(t.transform,r.tileID))});return function(t,e){for(const i in t)for(const r of t[i])rp(r,e);return t}(function(t){const e={},i={};for(const r of t){const t=r.queryResults,n=r.wrappedTileID,s=i[n]=i[n]||{};for(const i in t){const r=t[i],n=s[i]=s[i]||{},o=e[i]=e[i]||[];for(const t of r)n[t.featureIndex]||(n[t.featureIndex]=!0,o.push(t))}}return e}(h),t)}function ip(t,e){const i=t.tileID,r=e.tileID;return i.overscaledZ-r.overscaledZ||i.canonical.y-r.canonical.y||i.wrap-r.wrap||i.canonical.x-r.canonical.x}function rp(t,e){const i=t.feature,r=e.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=r}function np(t,e,i){return n(this,void 0,void 0,(function*(){let r=t;if(t.url?r=(yield ee(e.transformRequest(t.url,"Source"),i)).data:yield Wt.frameAsync(i),!r)return null;const n=vt(xt(r,t),["tiles","minzoom","maxzoom","attribution","bounds","scheme","tileSize","encoding"]);return"vector_layers"in r&&r.vector_layers&&(n.vectorLayerIds=r.vector_layers.map((t=>t.id))),n}))}const sp=6371008.8;class op{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new op(yt(this.lng,-180,180),this.lat)}toArray(){return[this.lng,this.lat]}toString(){return`LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,i=this.lat*e,r=t.lat*e,n=Math.sin(i)*Math.sin(r)+Math.cos(i)*Math.cos(r)*Math.cos((t.lng-this.lng)*e);return sp*Math.acos(Math.min(n,1))}static convert(t){if(t instanceof op)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new op(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new op(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}class ap{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):Array.isArray(t)&&(4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1])))}setNorthEast(t){return this._ne=t instanceof op?new op(t.lng,t.lat):op.convert(t),this}setSouthWest(t){return this._sw=t instanceof op?new op(t.lng,t.lat):op.convert(t),this}extend(t){const e=this._sw,i=this._ne;let r,n;if(t instanceof op)r=t,n=t;else{if(!(t instanceof ap))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(ap.convert(t)):this.extend(op.convert(t)):t&&("lng"in t||"lon"in t)&&"lat"in t?this.extend(op.convert(t)):this;if(r=t._sw,n=t._ne,!r||!n)return this}return e||i?(e.lng=Math.min(r.lng,e.lng),e.lat=Math.min(r.lat,e.lat),i.lng=Math.max(n.lng,i.lng),i.lat=Math.max(n.lat,i.lat)):(this._sw=new op(r.lng,r.lat),this._ne=new op(n.lng,n.lat)),this}getCenter(){return new op((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new op(this.getWest(),this.getNorth())}getSouthEast(){return new op(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return[this._sw.toArray(),this._ne.toArray()]}toString(){return`LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return!(this._sw&&this._ne)}contains(t){const{lng:e,lat:i}=op.convert(t);let r=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(r=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=i&&i<=this._ne.lat&&r}static convert(t){return t instanceof ap?t:t?new ap(t):t}static fromLngLat(t,e=0){const i=360*e/40075017,r=i/Math.cos(Math.PI/180*t.lat);return new ap(new op(t.lng-r,t.lat-i),new op(t.lng+r,t.lat+i))}adjustAntiMeridian(){const t=new op(this._sw.lng,this._sw.lat),e=new op(this._ne.lng,this._ne.lat);return new ap(t,t.lng>e.lng?new op(e.lng+360,e.lat):e)}}const lp=2*Math.PI*sp;function cp(t){return lp*Math.cos(t*Math.PI/180)}function hp(t){return(180+t)/360}function up(t){return(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function pp(t,e){return t/cp(e)}function dp(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function fp(t,e){return t*cp(dp(e))}class mp{constructor(t,e,i=0){this.x=+t,this.y=+e,this.z=+i}static fromLngLat(t,e=0){const i=op.convert(t);return new mp(hp(i.lng),up(i.lat),pp(e,i.lat))}toLngLat(){return new op(360*this.x-180,dp(this.y))}toAltitude(){return fp(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/lp*(t=dp(this.y),1/Math.cos(t*Math.PI/180));var t}}class _p{constructor(t,e,i){this.bounds=ap.convert(this.validateBounds(t)),this.minzoom=e||0,this.maxzoom=i||24}validateBounds(t){return Array.isArray(t)&&4===t.length?[Math.max(-180,t[0]),Math.max(-90,t[1]),Math.min(180,t[2]),Math.min(90,t[3])]:[-180,-90,180,90]}contains(t){const e=Math.pow(2,t.z),i=Math.floor(hp(this.bounds.getWest())*e),r=Math.floor(up(this.bounds.getNorth())*e),n=Math.ceil(hp(this.bounds.getEast())*e),s=Math.ceil(up(this.bounds.getSouth())*e);return t.x>=i&&t.x<n&&t.y>=r&&t.y<s}}class gp extends me{constructor(t,e,i,r){if(super(),this.id=t,this.dispatcher=i,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,xt(this,vt(e,["url","scheme","tileSize","promoteId"])),this._options=xt({type:"vector"},e),this._collectResourceTiming=e.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r)}load(){return n(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new de("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const t=yield np(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,this.map.style.sourceCaches[this.id].clearTiles(),t&&(xt(this,t),t.bounds&&(this.tileBounds=new _p(t.bounds,this.minzoom,this.maxzoom)),this.fire(new de("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new de("data",{dataType:"source",sourceDataType:"content"})))}catch(t){this._tileJSONRequest=null,this.fire(new fe(t))}}))}loaded(){return this._loaded}hasTile(t){return!this.tileBounds||this.tileBounds.contains(t.canonical)}onAdd(t){this.map=t,this.load()}setSourceProperty(t){this._tileJSONRequest&&this._tileJSONRequest.abort(),t(),this.load()}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null)}serialize(){return xt({},this._options)}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i={request:this.map._requestManager.transformRequest(e,"Tile"),uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity};i.request.collectResourceTiming=this._collectResourceTiming;let r="RT";if(t.actor&&"expired"!==t.state){if("loading"===t.state)return new Promise(((e,i)=>{t.reloadPromise={resolve:e,reject:i}}))}else t.actor=this.dispatcher.getActor(),r="LT";t.abortController=new AbortController;try{const e=yield t.actor.sendAsync({type:r,data:i},t.abortController);if(delete t.abortController,t.aborted)return;this._afterTileLoadWorkerResponse(t,e)}catch(e){if(delete t.abortController,t.aborted)return;if(e&&404!==e.status)throw e;this._afterTileLoadWorkerResponse(t,null)}}))}_afterTileLoadWorkerResponse(t,e){if(e&&e.resourceTiming&&(t.resourceTiming=e.resourceTiming),e&&this.map._refreshExpiredTiles&&t.setExpiryData(e),t.loadVectorData(e,this.map.painter),t.reloadPromise){const e=t.reloadPromise;t.reloadPromise=null,this.loadTile(t).then(e.resolve).catch(e.reject)}}abortTile(t){return n(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.actor&&(yield t.actor.sendAsync({type:"AT",data:{uid:t.uid,type:this.type,source:this.id}}))}))}unloadTile(t){return n(this,void 0,void 0,(function*(){t.unloadVectorData(),t.actor&&(yield t.actor.sendAsync({type:"RMT",data:{uid:t.uid,type:this.type,source:this.id}}))}))}hasTransition(){return!1}}class yp extends me{constructor(t,e,i,r){super(),this.id=t,this.dispatcher=i,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=xt({type:"raster"},e),xt(this,vt(e,["url","scheme","tileSize"]))}load(){return n(this,arguments,void 0,(function*(t=!1){this._loaded=!1,this.fire(new de("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const e=yield np(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,e&&(xt(this,e),e.bounds&&(this.tileBounds=new _p(e.bounds,this.minzoom,this.maxzoom)),this.fire(new de("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new de("data",{dataType:"source",sourceDataType:"content",sourceDataChanged:t})))}catch(t){this._tileJSONRequest=null,this.fire(new fe(t))}}))}loaded(){return this._loaded}onAdd(t){this.map=t,this.load()}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null)}setSourceProperty(t){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null),t(),this.load(!0)}setTiles(t){return this.setSourceProperty((()=>{this._options.tiles=t})),this}setUrl(t){return this.setSourceProperty((()=>{this.url=t,this._options.url=t})),this}serialize(){return xt({},this._options)}hasTile(t){return!this.tileBounds||this.tileBounds.contains(t.canonical)}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme);t.abortController=new AbortController;try{const i=yield ce.getImage(this.map._requestManager.transformRequest(e,"Tile"),t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(i&&i.data){this.map._refreshExpiredTiles&&i.cacheControl&&i.expires&&t.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const e=this.map.painter.context,r=e.gl,n=i.data;t.texture=this.map.painter.getTileTexture(n.width),t.texture?t.texture.update(n,{useMipmap:!0}):(t.texture=new Au(e,n,r.RGBA,{useMipmap:!0}),t.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE,r.LINEAR_MIPMAP_NEAREST)),t.state="loaded"}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}abortTile(t){return n(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController)}))}unloadTile(t){return n(this,void 0,void 0,(function*(){t.texture&&this.map.painter.saveTileTexture(t.texture)}))}hasTransition(){return!1}}function xp(t,e,i){var r=2*Math.PI*6378137/256/Math.pow(2,i);return[t*r-2*Math.PI*6378137/2,e*r-2*Math.PI*6378137/2]}class vp{constructor(t,e,i){if(!function(t,e,i){return!(t<0||t>25||i<0||i>=Math.pow(2,t)||e<0||e>=Math.pow(2,t))}(t,e,i))throw new Error(`x=${e}, y=${i}, z=${t} outside of bounds. 0<=x<${Math.pow(2,t)}, 0<=y<${Math.pow(2,t)} 0<=z<=25 `);this.z=t,this.x=e,this.y=i,this.key=Tp(0,t,t,e,i)}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e,i){const r=(s=this.y,o=this.z,a=xp(256*(n=this.x),256*(s=Math.pow(2,o)-s-1),o),l=xp(256*(n+1),256*(s+1),o),a[0]+","+a[1]+","+l[0]+","+l[1]);var n,s,o,a,l;const c=function(t,e,i){let r,n="";for(let s=t;s>0;s--)r=1<<s-1,n+=(e&r?1:0)+(i&r?2:0);return n}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===i?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,e>1?"@2x":"").replace(/{quadkey}/g,c).replace(/{bbox-epsg-3857}/g,r)}isChildOf(t){const e=this.z-t.z;return e>0&&t.x===this.x>>e&&t.y===this.y>>e}getTilePoint(t){const e=Math.pow(2,this.z);return new c((t.x*e-this.x)*J,(t.y*e-this.y)*J)}toString(){return`${this.z}/${this.x}/${this.y}`}}class bp{constructor(t,e){this.wrap=t,this.canonical=e,this.key=Tp(t,e.z,e.z,e.x,e.y)}}class wp{constructor(t,e,i,r,n){if(this.terrainRttPosMatrix32f=null,t<i)throw new Error(`overscaledZ should be >= z; overscaledZ = ${t}; z = ${i}`);this.overscaledZ=t,this.wrap=e,this.canonical=new vp(i,+r,+n),this.key=Tp(e,t,i,r,n)}clone(){return new wp(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const e=this.canonical.z-t;return t>this.canonical.z?new wp(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new wp(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e){if(t>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${t}; overscaledZ = ${this.overscaledZ}`);const i=this.canonical.z-t;return t>this.canonical.z?Tp(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y):Tp(this.wrap*+e,t,t,this.canonical.x>>i,this.canonical.y>>i)}isChildOf(t){if(t.wrap!==this.wrap)return!1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return[new wp(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,i=2*this.canonical.x,r=2*this.canonical.y;return[new wp(e,this.wrap,e,i,r),new wp(e,this.wrap,e,i+1,r),new wp(e,this.wrap,e,i,r+1),new wp(e,this.wrap,e,i+1,r+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new wp(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new wp(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new bp(this.wrap,this.canonical)}toString(){return`${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new mp(t.x-this.wrap,t.y))}}function Tp(t,e,i,r,n){(t*=2)<0&&(t=-1*t-1);const s=1<<i;return(s*s*t+s*n+r).toString(36)+i.toString(36)+e.toString(36)}Ws("CanonicalTileID",vp),Ws("OverscaledTileID",wp,{omit:["terrainRttPosMatrix32f"]}),Ws("DEMData",class{constructor(t,e,i,r=1,n=1,s=1,o=0){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(i&&!["mapbox","terrarium","custom"].includes(i))return void At(`"${i}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=e.height;const a=this.dim=e.height-2;switch(this.data=new Uint32Array(e.data.buffer),i){case"terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case"custom":this.redFactor=r,this.greenFactor=n,this.blueFactor=s,this.baseShift=o;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4}for(let t=0;t<a;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(a,t)]=this.data[this._idx(a-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,a)]=this.data[this._idx(t,a-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(a,-1)]=this.data[this._idx(a-1,0)],this.data[this._idx(-1,a)]=this.data[this._idx(0,a-1)],this.data[this._idx(a,a)]=this.data[this._idx(a-1,a-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let t=0;t<a;t++)for(let e=0;e<a;e++){const i=this.get(t,e);i>this.max&&(this.max=i),i<this.min&&(this.min=i)}}get(t,e){const i=new Uint8Array(this.data.buffer),r=4*this._idx(t,e);return this.unpack(i[r],i[r+1],i[r+2])}getUnpackVector(){return[this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return(e+1)*this.stride+(t+1)}unpack(t,e,i){return t*this.redFactor+e*this.greenFactor+i*this.blueFactor-this.baseShift}getPixels(){return new Hl({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,i){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let r=e*this.dim,n=e*this.dim+this.dim,s=i*this.dim,o=i*this.dim+this.dim;switch(e){case-1:r=n-1;break;case 1:n=r+1}switch(i){case-1:s=o-1;break;case 1:o=s+1}const a=-e*this.dim,l=-i*this.dim;for(let e=s;e<o;e++)for(let i=r;i<n;i++)this.data[this._idx(i,e)]=t.data[this._idx(i+a,e+l)]}});class Pp extends yp{constructor(t,e,i,r){super(t,e,i,r),this.type="raster-dem",this.maxzoom=22,this._options=xt({type:"raster-dem"},e),this.encoding=e.encoding||"mapbox",this.redFactor=e.redFactor,this.greenFactor=e.greenFactor,this.blueFactor=e.blueFactor,this.baseShift=e.baseShift}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i=this.map._requestManager.transformRequest(e,"Tile");t.neighboringTiles=this._getNeighboringTiles(t.tileID),t.abortController=new AbortController;try{const e=yield ce.getImage(i,t.abortController,this.map._refreshExpiredTiles);if(delete t.abortController,t.aborted)return void(t.state="unloaded");if(e&&e.data){const i=e.data;this.map._refreshExpiredTiles&&e.cacheControl&&e.expires&&t.setExpiryData({cacheControl:e.cacheControl,expires:e.expires});const r=Rt(i)&&f()?i:yield this.readImageNow(i),n={type:this.type,uid:t.uid,source:this.id,rawImageData:r,encoding:this.encoding,redFactor:this.redFactor,greenFactor:this.greenFactor,blueFactor:this.blueFactor,baseShift:this.baseShift};if(!t.actor||"expired"===t.state){t.actor=this.dispatcher.getActor();const e=yield t.actor.sendAsync({type:"LDT",data:n});t.dem=e,t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0,t.state="loaded"}}}catch(e){if(delete t.abortController,t.aborted)t.state="unloaded";else if(e)throw t.state="errored",e}}))}readImageNow(t){return n(this,void 0,void 0,(function*(){if("undefined"!=typeof VideoFrame&&function(){if(null==d&&(d=!1,f())){const t=5,e=new OffscreenCanvas(t,t).getContext("2d",{willReadFrequently:!0});if(e){for(let i=0;i<t*t;i++){const r=4*i;e.fillStyle=`rgb(${r},${r+1},${r+2})`,e.fillRect(i%t,Math.floor(i/t),1,1)}const i=e.getImageData(0,0,t,t).data;for(let e=0;e<t*t*4;e++)if(e%4!=3&&i[e]!==e){d=!0;break}}}return d||!1}()){const e=t.width+2,i=t.height+2;try{return new Hl({width:e,height:i},yield function(t,e,i,r,s){return n(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const e=new VideoFrame(t,{timestamp:0});try{const i=null==e?void 0:e.format;if(!i||!i.startsWith("BGR")&&!i.startsWith("RGB"))throw new Error(`Unrecognized format ${i}`);const n=i.startsWith("BGR"),o=new Uint8ClampedArray(r*s*4);if(yield e.copyTo(o,function(t,e,i,r,n){const s=4*Math.max(1,0),o=(Math.max(0,-1)- -1)*r*4+s,a=4*r,l=Math.max(0,-1),c=Math.max(0,-1);return{rect:{x:l,y:c,width:Math.min(t.width,-1+r)-l,height:Math.min(t.height,-1+n)-c},layout:[{offset:o,stride:a}]}}(t,0,0,r,s)),n)for(let t=0;t<o.length;t+=4){const e=o[t];o[t]=o[t+2],o[t+2]=e}return o}finally{e.close()}}))}(t,0,0,e,i))}catch(t){}}return Wt.getImageData(t,1)}))}_getNeighboringTiles(t){const e=t.canonical,i=Math.pow(2,e.z),r=(e.x-1+i)%i,n=0===e.x?t.wrap-1:t.wrap,s=(e.x+1+i)%i,o=e.x+1===i?t.wrap+1:t.wrap,a={};return a[new wp(t.overscaledZ,n,e.z,r,e.y).key]={backfilled:!1},a[new wp(t.overscaledZ,o,e.z,s,e.y).key]={backfilled:!1},e.y>0&&(a[new wp(t.overscaledZ,n,e.z,r,e.y-1).key]={backfilled:!1},a[new wp(t.overscaledZ,t.wrap,e.z,e.x,e.y-1).key]={backfilled:!1},a[new wp(t.overscaledZ,o,e.z,s,e.y-1).key]={backfilled:!1}),e.y+1<i&&(a[new wp(t.overscaledZ,n,e.z,r,e.y+1).key]={backfilled:!1},a[new wp(t.overscaledZ,t.wrap,e.z,e.x,e.y+1).key]={backfilled:!1},a[new wp(t.overscaledZ,o,e.z,s,e.y+1).key]={backfilled:!1}),a}unloadTile(t){return n(this,void 0,void 0,(function*(){t.demTexture&&this.map.painter.saveTileTexture(t.demTexture),t.fbo&&(t.fbo.destroy(),delete t.fbo),t.dem&&delete t.dem,delete t.neighboringTiles,t.state="unloaded",t.actor&&(yield t.actor.sendAsync({type:"RDT",data:{type:this.type,uid:t.uid,source:this.id}}))}))}}class Mp extends me{constructor(t,e,i,r){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._pendingLoads=0,this.actor=i.getActor(),this.setEventedParent(r),this._data=e.data,this._options=xt({},e),this._collectResourceTiming=e.collectResourceTiming,void 0!==e.maxzoom&&(this.maxzoom=e.maxzoom),e.type&&(this.type=e.type),e.attribution&&(this.attribution=e.attribution),this.promoteId=e.promoteId,void 0!==e.clusterMaxZoom&&this.maxzoom<=e.clusterMaxZoom&&At(`The maxzoom value "${this.maxzoom}" is expected to be greater than the clusterMaxZoom value "${e.clusterMaxZoom}".`),this.workerOptions=xt({source:this.id,cluster:e.cluster||!1,geojsonVtOptions:{buffer:this._pixelsToTileUnits(void 0!==e.buffer?e.buffer:128),tolerance:this._pixelsToTileUnits(void 0!==e.tolerance?e.tolerance:.375),extent:J,maxZoom:this.maxzoom,lineMetrics:e.lineMetrics||!1,generateId:e.generateId||!1},superclusterOptions:{maxZoom:void 0!==e.clusterMaxZoom?e.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,e.clusterMinPoints||2),extent:J,radius:this._pixelsToTileUnits(e.clusterRadius||50),log:!1,generateId:e.generateId||!1},clusterProperties:e.clusterProperties,filter:e.filter},e.workerOptions),"string"==typeof this.promoteId&&(this.workerOptions.promoteId=this.promoteId)}_pixelsToTileUnits(t){return t*(J/this.tileSize)}load(){return n(this,void 0,void 0,(function*(){yield this._updateWorkerData()}))}onAdd(t){this.map=t,this.load()}setData(t){return this._data=t,this._updateWorkerData(),this}updateData(t){return this._updateWorkerData(t),this}getData(){return n(this,void 0,void 0,(function*(){const t=xt({type:this.type},this.workerOptions);return this.actor.sendAsync({type:"GD",data:t})}))}setClusterOptions(t){return this.workerOptions.cluster=t.cluster,t&&(void 0!==t.clusterRadius&&(this.workerOptions.superclusterOptions.radius=this._pixelsToTileUnits(t.clusterRadius)),void 0!==t.clusterMaxZoom&&(this.workerOptions.superclusterOptions.maxZoom=t.clusterMaxZoom)),this._updateWorkerData(),this}getClusterExpansionZoom(t){return this.actor.sendAsync({type:"GCEZ",data:{type:this.type,clusterId:t,source:this.id}})}getClusterChildren(t){return this.actor.sendAsync({type:"GCC",data:{type:this.type,clusterId:t,source:this.id}})}getClusterLeaves(t,e,i){return this.actor.sendAsync({type:"GCL",data:{type:this.type,source:this.id,clusterId:t,limit:e,offset:i}})}_updateWorkerData(t){return n(this,void 0,void 0,(function*(){const e=xt({type:this.type},this.workerOptions);t?e.dataDiff=t:"string"==typeof this._data?(e.request=this.map._requestManager.transformRequest(Wt.resolveURL(this._data),"Source"),e.request.collectResourceTiming=this._collectResourceTiming):e.data=JSON.stringify(this._data),this._pendingLoads++,this.fire(new de("dataloading",{dataType:"source"}));try{const t=yield this.actor.sendAsync({type:"LD",data:e});if(this._pendingLoads--,this._removed||t.abandoned)return void this.fire(new de("dataabort",{dataType:"source"}));let i=null;t.resourceTiming&&t.resourceTiming[this.id]&&(i=t.resourceTiming[this.id].slice(0));const r={dataType:"source"};this._collectResourceTiming&&i&&i.length>0&&xt(r,{resourceTiming:i}),this.fire(new de("data",Object.assign(Object.assign({},r),{sourceDataType:"metadata"}))),this.fire(new de("data",Object.assign(Object.assign({},r),{sourceDataType:"content"})))}catch(t){if(this._pendingLoads--,this._removed)return void this.fire(new de("dataabort",{dataType:"source"}));this.fire(new fe(t))}}))}loaded(){return 0===this._pendingLoads}loadTile(t){return n(this,void 0,void 0,(function*(){const e=t.actor?"RT":"LT";t.actor=this.actor;const i={type:this.type,uid:t.uid,tileID:t.tileID,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity};t.abortController=new AbortController;const r=yield this.actor.sendAsync({type:e,data:i},t.abortController);delete t.abortController,t.unloadVectorData(),t.aborted||t.loadVectorData(r,this.map.painter,"RT"===e)}))}abortTile(t){return n(this,void 0,void 0,(function*(){t.abortController&&(t.abortController.abort(),delete t.abortController),t.aborted=!0}))}unloadTile(t){return n(this,void 0,void 0,(function*(){t.unloadVectorData(),yield this.actor.sendAsync({type:"RMT",data:{uid:t.uid,type:this.type,source:this.id}})}))}onRemove(){this._removed=!0,this.actor.sendAsync({type:"RS",data:{type:this.type,source:this.id}})}serialize(){return xt({},this._options,{type:this.type,data:this._data})}hasTransition(){return!1}}class Cp extends me{constructor(t,e,i,r){super(),this.flippedWindingOrder=!1,this.id=t,this.dispatcher=i,this.coordinates=e.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(r),this.options=e}load(t){return n(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new de("dataloading",{dataType:"source"})),this.url=this.options.url,this._request=new AbortController;try{const e=yield ce.getImage(this.map._requestManager.transformRequest(this.url,"Image"),this._request);this._request=null,this._loaded=!0,e&&e.data&&(this.image=e.data,t&&(this.coordinates=t),this._finishLoading())}catch(t){this._request=null,this._loaded=!0,this.fire(new fe(t))}}))}loaded(){return this._loaded}updateImage(t){return t.url?(this._request&&(this._request.abort(),this._request=null),this.options.url=t.url,this.load(t.coordinates).finally((()=>{this.texture=null})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new de("data",{dataType:"source",sourceDataType:"metadata"})))}onAdd(t){this.map=t,this.load()}onRemove(){this._request&&(this._request.abort(),this._request=null)}setCoordinates(t){this.coordinates=t;const e=t.map(mp.fromLngLat);var i;return this.tileID=function(t){let e=1/0,i=1/0,r=-1/0,n=-1/0;for(const s of t)e=Math.min(e,s.x),i=Math.min(i,s.y),r=Math.max(r,s.x),n=Math.max(n,s.y);const s=Math.max(r-e,n-i),o=Math.max(0,Math.floor(-Math.log(s)/Math.LN2)),a=Math.pow(2,o);return new vp(o,Math.floor((e+r)/2*a),Math.floor((i+n)/2*a))}(e),this.minzoom=this.maxzoom=this.tileID.z,this.tileCoords=e.map((t=>this.tileID.getTilePoint(t)._round())),this.flippedWindingOrder=((i=this.tileCoords)[1].x-i[0].x)*(i[2].y-i[0].y)-(i[1].y-i[0].y)*(i[2].x-i[0].x)<0,this.fire(new de("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const t=this.map.painter.context,e=t.gl;this.texture||(this.texture=new Au(t,this.image,e.RGBA),this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE));let i=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,i=!0)}i&&this.fire(new de("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}loadTile(t){return n(this,void 0,void 0,(function*(){this.tileID&&this.tileID.equals(t.tileID.canonical)?(this.tiles[String(t.tileID.wrap)]=t,t.buckets={}):t.state="errored"}))}serialize(){return{type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return!1}}class Ip extends Cp{constructor(t,e,i,r){super(t,e,i,r),this.roundZoom=!0,this.type="video",this.options=e}load(){return n(this,void 0,void 0,(function*(){this._loaded=!1;const t=this.options;this.urls=[];for(const e of t.urls)this.urls.push(this.map._requestManager.transformRequest(e,"Source").url);try{const t=yield(t=>{const e=window.document.createElement("video");return e.muted=!0,new Promise((i=>{e.onloadstart=()=>{i(e)};for(const i of t){const t=window.document.createElement("source");ie(i)||(e.crossOrigin="Anonymous"),t.src=i,e.appendChild(t)}}))})(this.urls);if(this._loaded=!0,!t)return;this.video=t,this.video.loop=!0,this.video.addEventListener("playing",(()=>{this.map.triggerRepaint()})),this.map&&this.video.play(),this._finishLoading()}catch(t){this.fire(new fe(t))}}))}pause(){this.video&&this.video.pause()}play(){this.video&&this.video.play()}seek(t){if(this.video){const e=this.video.seekable;t<e.start(0)||t>e.end(0)?this.fire(new fe(new Ee(`sources.${this.id}`,null,`Playback for this video can be set only between the ${e.start(0)} and ${e.end(0)}-second mark.`))):this.video.currentTime=t}}getVideo(){return this.video}onAdd(t){this.map||(this.map=t,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)))}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,e=t.gl;this.texture?this.video.paused||(this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE),e.texSubImage2D(e.TEXTURE_2D,0,0,0,e.RGBA,e.UNSIGNED_BYTE,this.video)):(this.texture=new Au(t,this.video,e.RGBA),this.texture.bind(e.LINEAR,e.CLAMP_TO_EDGE));let i=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,i=!0)}i&&this.fire(new de("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}serialize(){return{type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}}class Sp extends Cp{constructor(t,e,i,r){super(t,e,i,r),e.coordinates?Array.isArray(e.coordinates)&&4===e.coordinates.length&&!e.coordinates.some((t=>!Array.isArray(t)||2!==t.length||t.some((t=>"number"!=typeof t))))||this.fire(new fe(new Ee(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new fe(new Ee(`sources.${t}`,null,'missing required property "coordinates"'))),e.animate&&"boolean"!=typeof e.animate&&this.fire(new fe(new Ee(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),e.canvas?"string"==typeof e.canvas||e.canvas instanceof HTMLCanvasElement||this.fire(new fe(new Ee(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new fe(new Ee(`sources.${t}`,null,'missing required property "canvas"'))),this.options=e,this.animate=void 0===e.animate||e.animate}load(){return n(this,void 0,void 0,(function*(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new fe(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint()},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1)},this._finishLoading())}))}getCanvas(){return this.canvas}onAdd(t){this.map=t,this.load(),this.canvas&&this.animate&&this.play()}onRemove(){this.pause()}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const e=this.map.painter.context,i=e.gl;this.texture?(t||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new Au(e,this.canvas,i.RGBA,{premultiply:!0});let r=!1;for(const t in this.tiles){const e=this.tiles[t];"loaded"!==e.state&&(e.state="loaded",e.texture=this.texture,r=!0)}r&&this.fire(new de("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}))}serialize(){return{type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const t of[this.canvas.width,this.canvas.height])if(isNaN(t)||t<=0)return!0;return!1}}const Ep={},Ap=t=>{switch(t){case"geojson":return Mp;case"image":return Cp;case"raster":return yp;case"raster-dem":return Pp;case"vector":return gp;case"video":return Ip;case"canvas":return Sp}return Ep[t]};class zp{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const i=t[e];this._stringToNumber[i]=e,this._numberToString[e]=i}}encode(t){return this._stringToNumber[t]}decode(t){if(t>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${t} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[t]}}class kp{constructor(t,e,i,r,n){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=i,t._y=r,this.properties=t.properties,this.id=n}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}function Dp(t,e,i,r,n){return Mt(t,((t,s)=>{const o=e instanceof xo?e.get(s):null;return o&&o.evaluate?o.evaluate(i,r,n):o}))}function Rp(t){let e=1/0,i=1/0,r=-1/0,n=-1/0;for(const s of t)e=Math.min(e,s.x),i=Math.min(i,s.y),r=Math.max(r,s.x),n=Math.max(n,s.y);return{minX:e,minY:i,maxX:r,maxY:n}}function Lp(t,e){return e-t}Ws("FeatureIndex",class{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new $s(J,16,0),this.grid3D=new $s(J,16,0),this.featureIndexArray=new da,this.promoteId=e}insert(t,e,i,r,n,s){const o=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(i,r,n);const a=s?this.grid3D:this.grid;for(let t=0;t<e.length;t++){const i=e[t],r=[1/0,1/0,-1/0,-1/0];for(let t=0;t<i.length;t++){const e=i[t];r[0]=Math.min(r[0],e.x),r[1]=Math.min(r[1],e.y),r[2]=Math.max(r[2],e.x),r[3]=Math.max(r[3],e.y)}r[0]<J&&r[1]<J&&r[2]>=0&&r[3]>=0&&a.insert(o,r[0],r[1],r[2],r[3])}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new sh.VectorTile(new qh(this.rawTileData)).layers,this.sourceLayerCoder=new zp(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,i,r){this.loadVTLayers();const n=t.params,s=J/t.tileSize/t.scale,o=is(n.filter),a=t.queryGeometry,l=t.queryPadding*s,h=Rp(a),u=this.grid.query(h.minX-l,h.minY-l,h.maxX+l,h.maxY+l),p=Rp(t.cameraQueryGeometry),d=this.grid3D.query(p.minX-l,p.minY-l,p.maxX+l,p.maxY+l,((e,i,r,n)=>function(t,e,i,r,n){for(const s of t)if(e<=s.x&&i<=s.y&&r>=s.x&&n>=s.y)return!0;const s=[new c(e,i),new c(e,n),new c(r,n),new c(r,i)];if(t.length>2)for(const e of s)if(zl(t,e))return!0;for(let e=0;e<t.length-1;e++)if(kl(t[e],t[e+1],s))return!0;return!1}(t.cameraQueryGeometry,e-l,i-l,r+l,n+l)));for(const t of d)u.push(t);u.sort(Lp);const f={};let m;for(let l=0;l<u.length;l++){const c=u[l];if(c===m)continue;m=c;const h=this.featureIndexArray.get(c);let p=null;this.loadMatchingFeature(f,h.bucketIndex,h.sourceLayerIndex,h.featureIndex,o,n.layers,n.availableImages,e,i,r,((e,i,r)=>(p||(p=gl(e)),i.queryIntersectsFeature({queryGeometry:a,feature:e,featureState:r,geometry:p,zoom:this.z,transform:t.transform,pixelsToTileUnits:s,pixelPosMatrix:t.pixelPosMatrix}))))}return f}loadMatchingFeature(t,e,i,r,n,s,o,a,l,c,h){const u=this.bucketLayerIDs[e];if(s&&!u.some((t=>s.has(t))))return;const p=this.sourceLayerCoder.decode(i),d=this.vtLayers[p].feature(r);if(n.needGeometry){const t=yl(d,!0);if(!n.filter(new ho(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!n.filter(new ho(this.tileID.overscaledZ),d))return;const f=this.getId(d,p);for(let e=0;e<u.length;e++){const i=u[e];if(s&&!s.has(i))continue;const n=a[i];if(!n)continue;let p={};f&&c&&(p=c.getState(n.sourceLayer||"_geojsonTileLayer",f));const m=xt({},l[i]);m.paint=Dp(m.paint,n.paint,d,p,o),m.layout=Dp(m.layout,n.layout,d,p,o);const _=!h||h(d,n,p);if(!_)continue;const g=new kp(d,this.z,this.x,this.y,f);g.layer=m;let y=t[i];void 0===y&&(y=t[i]=[]),y.push({featureIndex:r,feature:g,intersectionZ:_})}}lookupSymbolFeatures(t,e,i,r,n,s,o,a){const l={};this.loadVTLayers();const c=is(n);for(const n of t)this.loadMatchingFeature(l,i,r,n,c,s,o,a,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const i of e)if(t===i)return!0;return!1}getId(t,e){var i;let r=t.id;return this.promoteId&&(r=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof r&&(r=Number(r)),void 0===r&&(null===(i=t.properties)||void 0===i?void 0:i.cluster)&&this.promoteId&&(r=Number(t.properties.cluster_id))),r}},{omit:["rawTileData","sourceLayerCoder"]});const Bp="RTLPluginLoaded";class Fp extends me{constructor(){super(...arguments),this.status="unavailable",this.url=null,this.dispatcher=Qu()}_syncState(t){return this.status=t,this.dispatcher.broadcast("SRPS",{pluginStatus:t,pluginURL:this.url}).catch((t=>{throw this.status="error",t}))}getRTLTextPluginStatus(){return this.status}clearRTLTextPlugin(){this.status="unavailable",this.url=null}setRTLTextPlugin(t){return n(this,arguments,void 0,(function*(t,e=!1){if(this.url)throw new Error("setRTLTextPlugin cannot be called multiple times.");if(this.url=Wt.resolveURL(t),!this.url)throw new Error(`requested url ${t} is invalid`);if("unavailable"===this.status){if(!e)return this._requestImport();this.status="deferred",this._syncState(this.status)}else if("requested"===this.status)return this._requestImport()}))}_requestImport(){return n(this,void 0,void 0,(function*(){yield this._syncState("loading"),this.status="loaded",this.fire(new de(Bp))}))}lazyLoad(){"unavailable"===this.status?this.status="requested":"deferred"===this.status&&this._requestImport()}}let Op=null;function jp(){return Op||(Op=new Fp),Op}class Vp{constructor(t,e){this.timeAdded=0,this.fadeEndTime=0,this.tileID=t,this.uid=wt(),this.uses=0,this.tileSize=e,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.rtt=[],this.rttCoords={},this.expiredRequestCount=0,this.state="loading"}registerFadeDuration(t){const e=t+this.timeAdded;e<this.fadeEndTime||(this.fadeEndTime=e)}wasRequested(){return"errored"===this.state||"loaded"===this.state||"reloading"===this.state}clearTextures(t){this.demTexture&&t.saveTileTexture(this.demTexture),this.demTexture=null}loadVectorData(t,e,i){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(t,e){const i={};if(!e)return i;for(const r of t){const t=r.layerIds.map((t=>e.getLayer(t))).filter(Boolean);if(0!==t.length){r.layers=t,r.stateDependentLayerIds&&(r.stateDependentLayers=r.stateDependentLayerIds.map((e=>t.filter((t=>t.id===e))[0])));for(const e of t)i[e.id]=r}}return i}(t.buckets,null==e?void 0:e.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const e=this.buckets[t];if(e instanceof fu){if(this.hasSymbolBuckets=!0,!i)break;e.justReloaded=!0}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const e=this.buckets[t];if(e instanceof fu&&e.hasRTLText){this.hasRTLText=!0,jp().lazyLoad();break}}this.queryPadding=0;for(const t in this.buckets){const i=this.buckets[t];this.queryPadding=Math.max(this.queryPadding,e.style.getLayer(t).queryRadius(i))}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage)}else this.collisionBoxArray=new ra}unloadVectorData(){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.latestFeatureIndex=null,this.state="unloaded"}getBucket(t){return this.buckets[t.id]}upload(t){for(const e in this.buckets){const i=this.buckets[e];i.uploadPending()&&i.upload(t)}const e=t.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new Au(t,this.imageAtlas.image,e.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new Au(t,this.glyphAtlasImage,e.ALPHA),this.glyphAtlasImage=null)}prepare(t){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(t,this.imageAtlasTexture)}queryRenderedFeatures(t,e,i,r,n,s,o,a,l,c){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({queryGeometry:r,cameraQueryGeometry:n,scale:s,tileSize:this.tileSize,pixelPosMatrix:c,transform:a,params:o,queryPadding:this.queryPadding*l},t,e,i):{}}querySourceFeatures(t,e){const i=this.latestFeatureIndex;if(!i||!i.rawTileData)return;const r=i.loadVTLayers(),n=e&&e.sourceLayer?e.sourceLayer:"",s=r._geojsonTileLayer||r[n];if(!s)return;const o=is(e&&e.filter),{z:a,x:l,y:c}=this.tileID.canonical,h={z:a,x:l,y:c};for(let e=0;e<s.length;e++){const r=s.feature(e);if(o.needGeometry){const t=yl(r,!0);if(!o.filter(new ho(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!o.filter(new ho(this.tileID.overscaledZ),r))continue;const u=i.getId(r,n),p=new kp(r,a,l,c,u);p.tile=h,t.push(p)}}hasData(){return"loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const e=this.expirationTime;if(t.cacheControl){const e=function(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((t,i,r,n)=>{const s=r||n;return e[i]=!s||s.toLowerCase(),""})),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t}return e}(t.cacheControl);e["max-age"]&&(this.expirationTime=Date.now()+1e3*e["max-age"])}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const t=Date.now();let i=!1;if(this.expirationTime>t)i=!1;else if(e)if(this.expirationTime<e)i=!0;else{const r=this.expirationTime-e;r?this.expirationTime=t+Math.max(r,3e4):i=!0}else i=!0;i?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(t,e){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(t).length)return;const i=this.latestFeatureIndex.loadVTLayers();for(const r in this.buckets){if(!e.style.hasLayer(r))continue;const n=this.buckets[r],s=n.layers[0].sourceLayer||"_geojsonTileLayer",o=i[s],a=t[s];if(!o||!a||0===Object.keys(a).length)continue;n.update(a,o,this.imageAtlas&&this.imageAtlas.patternPositions||{});const l=e&&e.style&&e.style.getLayer(r);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(n)))}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return!this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<Wt.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0}setHoldDuration(t){this.symbolFadeHoldUntil=Wt.now()+t}setDependencies(t,e){const i={};for(const t of e)i[t]=!0;this.dependencies[t]=i}hasDependency(t,e){for(const i of t){const t=this.dependencies[i];if(t)for(const i of e)if(t[i])return!0}return!1}}class Np{constructor(t,e){this.max=t,this.onRemove=e,this.reset()}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,i){const r=t.wrapped().key;void 0===this.data[r]&&(this.data[r]=[]);const n={value:e,timeout:void 0};if(void 0!==i&&(n.timeout=setTimeout((()=>{this.remove(t,n)}),i)),this.data[r].push(n),this.order.push(r),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t)}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const i=t.wrapped().key,r=void 0===e?0:this.data[i].indexOf(e),n=this.data[i][r];return this.data[i].splice(r,1),n.timeout&&clearTimeout(n.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(n.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t)}return this}filter(t){const e=[];for(const i in this.data)for(const r of this.data[i])t(r.value)||e.push(r);for(const t of e)this.remove(t.value.tileID,t)}}class Up{constructor(){this.state={},this.stateChanges={},this.deletedStates={}}updateState(t,e,i){const r=String(e);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][r]=this.stateChanges[t][r]||{},xt(this.stateChanges[t][r],i),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==r&&(this.deletedStates[t][e]=null)}else if(this.deletedStates[t]&&null===this.deletedStates[t][r]){this.deletedStates[t][r]={};for(const e in this.state[t][r])i[e]||(this.deletedStates[t][r][e]=null)}else for(const e in i)this.deletedStates[t]&&this.deletedStates[t][r]&&null===this.deletedStates[t][r][e]&&delete this.deletedStates[t][r][e]}removeFeatureState(t,e,i){if(null===this.deletedStates[t])return;const r=String(e);if(this.deletedStates[t]=this.deletedStates[t]||{},i&&void 0!==e)null!==this.deletedStates[t][r]&&(this.deletedStates[t][r]=this.deletedStates[t][r]||{},this.deletedStates[t][r][i]=null);else if(void 0!==e)if(this.stateChanges[t]&&this.stateChanges[t][r])for(i in this.deletedStates[t][r]={},this.stateChanges[t][r])this.deletedStates[t][r][i]=null;else this.deletedStates[t][r]=null;else this.deletedStates[t]=null}getState(t,e){const i=String(e),r=xt({},(this.state[t]||{})[i],(this.stateChanges[t]||{})[i]);if(null===this.deletedStates[t])return{};if(this.deletedStates[t]){const i=this.deletedStates[t][e];if(null===i)return{};for(const t in i)delete r[t]}return r}initializeTileState(t,e){t.setFeatureState(this.state,e)}coalesceChanges(t,e){const i={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const e={};for(const i in this.stateChanges[t])this.state[t][i]||(this.state[t][i]={}),xt(this.state[t][i],this.stateChanges[t][i]),e[i]=this.state[t][i];i[t]=e}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const e={};if(null===this.deletedStates[t])for(const i in this.state[t])e[i]={},this.state[t][i]={};else for(const i in this.deletedStates[t]){if(null===this.deletedStates[t][i])this.state[t][i]={};else for(const e of Object.keys(this.deletedStates[t][i]))delete this.state[t][i][e];e[i]=this.state[t][i]}i[t]=i[t]||{},xt(i[t],e)}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(i).length)for(const r in t)t[r].setFeatureState(i,e)}}function Zp(t,e,i){const r=e.intersectsFrustum(t);if(!i)return r;const n=e.intersectsPlane(i);return 0===r||0===n?0:2===r&&2===n?2:1}function Gp(t,e,i,r,n){let s=t;const o=Math.atan(e/i);return s=t+Pt(r/Math.hypot(e,i)/Math.max(.5,Math.cos(Ft(n/2)))),s+=1*Pt(Math.cos(o))/2,s+=gt(t-s,-0,0),s}function $p(t,e){const i=(e.roundZoom?Math.round:Math.floor)(t.zoom+Pt(t.tileSize/e.tileSize));return Math.max(0,i)}function qp(t,e){const i=t.getCameraFrustum(),r=t.getClippingPlane(),n=t.screenPointToMercatorCoordinate(t.getCameraPoint()),s=mp.fromLngLat(t.center,t.elevation);n.z=s.z+Math.cos(t.pitchInRadians)*t.cameraToCenterDistance/t.worldSize;const o=t.getCoveringTilesDetailsProvider(),a=o.allowVariableZoom(t,e),l=$p(t,e),c=e.minzoom||0,h=void 0!==e.maxzoom?e.maxzoom:t.maxZoom,u=Math.min(Math.max(0,l),h),p=Math.pow(2,u),d=[p*n.x,p*n.y,0],f=[p*s.x,p*s.y,0],m=Math.hypot(s.x-n.x,s.y-n.y),_=Math.abs(s.z-n.z),g=Math.hypot(m,_),y=t=>({zoom:0,x:0,y:0,wrap:t,fullyVisible:!1}),x=[],v=[];if(t.renderWorldCopies&&o.allowWorldCopies())for(let t=1;t<=3;t++)x.push(y(-t)),x.push(y(t));for(x.push(y(0));x.length>0;){const p=x.pop(),m=p.x,y=p.y;let b=p.fullyVisible;const w={x:m,y:y,z:p.zoom},T=o.getTileAABB(w,p.wrap,t.elevation,e);if(!b){const t=Zp(i,T,r);if(0===t)continue;b=2===t}const P=o.distanceToTile2d(n.x,n.y,w,T);let M=l;a&&(M=(e.calculateTileZoom||Gp)(t.zoom+Pt(t.tileSize/e.tileSize),P,_,g,t.fov)),M=(e.roundZoom?Math.round:Math.floor)(M),M=Math.max(0,M);const C=Math.min(M,h);if(p.wrap=o.getWrap(s,w,p.wrap),p.zoom>=C){if(p.zoom<c)continue;const t=u-p.zoom,i=d[0]-.5-(m<<t),r=d[1]-.5-(y<<t),n=e.reparseOverscaled?Math.max(p.zoom,M):p.zoom;v.push({tileID:new wp(p.zoom===h?n:p.zoom,p.wrap,p.zoom,m,y),distanceSq:Y([f[0]-.5-m,f[1]-.5-y]),tileDistanceToCamera:Math.sqrt(i*i+r*r)})}else for(let t=0;t<4;t++)x.push({zoom:p.zoom+1,x:(m<<1)+t%2,y:(y<<1)+(t>>1),wrap:p.wrap,fullyVisible:b})}return v.sort(((t,e)=>t.distanceSq-e.distanceSq)).map((t=>t.tileID))}class Wp extends me{constructor(t,e,i){super(),this.id=t,this.dispatcher=i,this.on("data",(t=>this._dataHandler(t))),this.on("dataloading",(()=>{this._sourceErrored=!1})),this.on("error",(()=>{this._sourceErrored=this._source.loaded()})),this._source=((t,e,i,r)=>{const n=new(Ap(e.type))(t,e,i,r);if(n.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${n.id}`);return n})(t,e,i,this),this._tiles={},this._cache=new Np(0,(t=>this._unloadTile(t))),this._timers={},this._cacheTimers={},this._maxTileCacheSize=null,this._maxTileCacheZoomLevels=null,this._loadedParentTiles={},this._coveredTiles={},this._state=new Up,this._didEmitContent=!1,this._updated=!1}onAdd(t){this.map=t,this._maxTileCacheSize=t?t._maxTileCacheSize:null,this._maxTileCacheZoomLevels=t?t._maxTileCacheZoomLevels:null,this._source&&this._source.onAdd&&this._source.onAdd(t)}onRemove(t){this.clearTiles(),this._source&&this._source.onRemove&&this._source.onRemove(t)}loaded(){if(this._sourceErrored)return!0;if(!this._sourceLoaded)return!1;if(!this._source.loaded())return!1;if(!(void 0===this.used&&void 0===this.usedForTerrain||this.used||this.usedForTerrain))return!0;if(!this._updated)return!1;for(const t in this._tiles){const e=this._tiles[t];if("loaded"!==e.state&&"errored"!==e.state)return!1}return!0}getSource(){return this._source}pause(){this._paused=!0}resume(){if(!this._paused)return;const t=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,t&&this.reload(),this.transform&&this.update(this.transform,this.terrain)}_loadTile(t,e,i){return n(this,void 0,void 0,(function*(){try{yield this._source.loadTile(t),this._tileLoaded(t,e,i)}catch(e){t.state="errored",404!==e.status?this._source.fire(new fe(e,{tile:t})):this.update(this.transform,this.terrain)}}))}_unloadTile(t){this._source.unloadTile&&this._source.unloadTile(t)}_abortTile(t){this._source.abortTile&&this._source.abortTile(t),this._source.fire(new de("dataabort",{tile:t,coord:t.tileID,dataType:"source"}))}serialize(){return this._source.serialize()}prepare(t){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const e in this._tiles){const i=this._tiles[e];i.upload(t),i.prepare(this.map.style.imageManager)}}getIds(){return Object.values(this._tiles).map((t=>t.tileID)).sort(Hp).map((t=>t.key))}getRenderableIds(t){const e=[];for(const i in this._tiles)this._isIdRenderable(i,t)&&e.push(this._tiles[i]);return t?e.sort(((t,e)=>{const i=t.tileID,r=e.tileID,n=new c(i.canonical.x,i.canonical.y)._rotate(-this.transform.bearingInRadians),s=new c(r.canonical.x,r.canonical.y)._rotate(-this.transform.bearingInRadians);return i.overscaledZ-r.overscaledZ||s.y-n.y||s.x-n.x})).map((t=>t.tileID.key)):e.map((t=>t.tileID)).sort(Hp).map((t=>t.key))}hasRenderableParent(t){const e=this.findLoadedParent(t,0);return!!e&&this._isIdRenderable(e.tileID.key)}_isIdRenderable(t,e){return this._tiles[t]&&this._tiles[t].hasData()&&!this._coveredTiles[t]&&(e||!this._tiles[t].holdingForFade())}reload(t){if(this._paused)this._shouldReloadOnResume=!0;else{this._cache.reset();for(const e in this._tiles)(t||"errored"!==this._tiles[e].state)&&this._reloadTile(e,"reloading")}}_reloadTile(t,e){return n(this,void 0,void 0,(function*(){const i=this._tiles[t];i&&("loading"!==i.state&&(i.state=e),yield this._loadTile(i,t,e))}))}_tileLoaded(t,e,i){t.timeAdded=Wt.now(),"expired"===i&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(e,t),"raster-dem"===this.getSource().type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),t.aborted||this._source.fire(new de("data",{dataType:"source",tile:t,coord:t.tileID}))}_backfillDEM(t){const e=this.getRenderableIds();for(let r=0;r<e.length;r++){const n=e[r];if(t.neighboringTiles&&t.neighboringTiles[n]){const e=this.getTileByID(n);i(t,e),i(e,t)}}function i(t,e){t.needsHillshadePrepare=!0,t.needsTerrainPrepare=!0;let i=e.tileID.canonical.x-t.tileID.canonical.x;const r=e.tileID.canonical.y-t.tileID.canonical.y,n=Math.pow(2,t.tileID.canonical.z),s=e.tileID.key;0===i&&0===r||Math.abs(r)>1||(Math.abs(i)>1&&(1===Math.abs(i+n)?i+=n:1===Math.abs(i-n)&&(i-=n)),e.dem&&t.dem&&(t.dem.backfillBorder(e.dem,i,r),t.neighboringTiles&&t.neighboringTiles[s]&&(t.neighboringTiles[s].backfilled=!0)))}}getTile(t){return this.getTileByID(t.key)}getTileByID(t){return this._tiles[t]}_retainLoadedChildren(t,e,i,r){for(const n in this._tiles){let s=this._tiles[n];if(r[n]||!s.hasData()||s.tileID.overscaledZ<=e||s.tileID.overscaledZ>i)continue;let o=s.tileID;for(;s&&s.tileID.overscaledZ>e+1;){const t=s.tileID.scaledTo(s.tileID.overscaledZ-1);s=this._tiles[t.key],s&&s.hasData()&&(o=t)}let a=o;for(;a.overscaledZ>e;)if(a=a.scaledTo(a.overscaledZ-1),t[a.key]||t[a.canonical.key]){r[o.key]=o;break}}}findLoadedParent(t,e){if(t.key in this._loadedParentTiles){const i=this._loadedParentTiles[t.key];return i&&i.tileID.overscaledZ>=e?i:null}for(let i=t.overscaledZ-1;i>=e;i--){const e=t.scaledTo(i),r=this._getLoadedTile(e);if(r)return r}}findLoadedSibling(t){return this._getLoadedTile(t)}_getLoadedTile(t){const e=this._tiles[t.key];return e&&e.hasData()?e:this._cache.getByKey(t.wrapped().key)}updateCacheSize(t){const e=Math.ceil(t.width/this._source.tileSize)+1,i=Math.ceil(t.height/this._source.tileSize)+1,r=Math.floor(e*i*(null===this._maxTileCacheZoomLevels?Xt.MAX_TILE_CACHE_ZOOM_LEVELS:this._maxTileCacheZoomLevels)),n="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,r):r;this._cache.setMaxSize(n)}handleWrapJump(t){const e=Math.round((t-(void 0===this._prevLng?t:this._prevLng))/360);if(this._prevLng=t,e){const t={};for(const i in this._tiles){const r=this._tiles[i];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+e),t[r.tileID.key]=r}this._tiles=t;for(const t in this._timers)clearTimeout(this._timers[t]),delete this._timers[t];for(const t in this._tiles)this._setTileReloadTimer(t,this._tiles[t])}}_updateCoveredAndRetainedTiles(t,e,i,r,n,s){const o={},a={},l=Object.keys(t),c=Wt.now();for(const i of l){const r=t[i],n=this._tiles[i];if(!n||0!==n.fadeEndTime&&n.fadeEndTime<=c)continue;const s=this.findLoadedParent(r,e),l=this.findLoadedSibling(r),h=s||l||null;h&&(this._addTile(h.tileID),o[h.tileID.key]=h.tileID),a[i]=r}this._retainLoadedChildren(a,r,i,t);for(const e in o)t[e]||(this._coveredTiles[e]=!0,t[e]=o[e]);if(s){const e={},i={};for(const t of n)this._tiles[t.key].hasData()?e[t.key]=t:i[t.key]=t;for(const r in i){const n=i[r].children(this._source.maxzoom);this._tiles[n[0].key]&&this._tiles[n[1].key]&&this._tiles[n[2].key]&&this._tiles[n[3].key]&&(e[n[0].key]=t[n[0].key]=n[0],e[n[1].key]=t[n[1].key]=n[1],e[n[2].key]=t[n[2].key]=n[2],e[n[3].key]=t[n[3].key]=n[3],delete i[r])}for(const r in i){const n=i[r],s=this.findLoadedParent(n,this._source.minzoom),o=this.findLoadedSibling(n),a=s||o||null;if(a){e[a.tileID.key]=t[a.tileID.key]=a.tileID;for(const t in e)e[t].isChildOf(a.tileID)&&delete e[t]}}for(const t in this._tiles)e[t]||(this._coveredTiles[t]=!0)}}update(t,e){if(!this._sourceLoaded||this._paused)return;let i;this.transform=t,this.terrain=e,this.updateCacheSize(t),this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?i=t.getVisibleUnwrappedCoordinates(this._source.tileID).map((t=>new wp(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y))):(i=qp(t,{tileSize:this.usedForTerrain?this.tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:!this.usedForTerrain&&this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,terrain:e,calculateTileZoom:this._source.calculateTileZoom}),this._source.hasTile&&(i=i.filter((t=>this._source.hasTile(t))))):i=[];const r=$p(t,this._source),n=Math.max(r-Wp.maxOverzooming,this._source.minzoom),s=Math.max(r+Wp.maxUnderzooming,this._source.minzoom);if(this.usedForTerrain){const t={};for(const e of i)if(e.canonical.z>this._source.minzoom){const i=e.scaledTo(e.canonical.z-1);t[i.key]=i;const r=e.scaledTo(Math.max(this._source.minzoom,Math.min(e.canonical.z,5)));t[r.key]=r}i=i.concat(Object.values(t))}const o=0===i.length&&!this._updated&&this._didEmitContent;this._updated=!0,o&&this.fire(new de("data",{sourceDataType:"idle",dataType:"source",sourceId:this.id}));const a=this._updateRetainedTiles(i,r);Xp(this._source.type)&&this._updateCoveredAndRetainedTiles(a,n,s,r,i,e);for(const t in a)this._tiles[t].clearFadeHold();const l=function(t,e){const i=[];for(const r in t)r in e||i.push(r);return i}(this._tiles,a);for(const t of l){const e=this._tiles[t];e.hasSymbolBuckets&&!e.holdingForFade()?e.setHoldDuration(this.map._fadeDuration):e.hasSymbolBuckets&&!e.symbolFadeFinished()||this._removeTile(t)}this._updateLoadedParentTileCache(),this._updateLoadedSiblingTileCache()}releaseSymbolFadeTiles(){for(const t in this._tiles)this._tiles[t].holdingForFade()&&this._removeTile(t)}_updateRetainedTiles(t,e){var i;const r={},n={},s=Math.max(e-Wp.maxOverzooming,this._source.minzoom),o=Math.max(e+Wp.maxUnderzooming,this._source.minzoom),a={};for(const i of t){const t=this._addTile(i);r[i.key]=i,t.hasData()||e<this._source.maxzoom&&(a[i.key]=i)}this._retainLoadedChildren(a,e,o,r);for(const o of t){let t=this._tiles[o.key];if(t.hasData())continue;if(e+1>this._source.maxzoom){const t=o.children(this._source.maxzoom)[0],e=this.getTile(t);if(e&&e.hasData()){r[t.key]=t;continue}}else{const t=o.children(this._source.maxzoom);if(r[t[0].key]&&r[t[1].key]&&r[t[2].key]&&r[t[3].key])continue}let a=t.wasRequested();for(let e=o.overscaledZ-1;e>=s;--e){const s=o.scaledTo(e);if(n[s.key])break;if(n[s.key]=!0,t=this.getTile(s),!t&&a&&(t=this._addTile(s)),t){const e=t.hasData();if((e||!(null===(i=this.map)||void 0===i?void 0:i.cancelPendingTileRequestsWhileZooming)||a)&&(r[s.key]=s),a=t.wasRequested(),e)break}}}return r}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const t in this._tiles){const e=[];let i,r=this._tiles[t].tileID;for(;r.overscaledZ>0;){if(r.key in this._loadedParentTiles){i=this._loadedParentTiles[r.key];break}e.push(r.key);const t=r.scaledTo(r.overscaledZ-1);if(i=this._getLoadedTile(t),i)break;r=t}for(const t of e)this._loadedParentTiles[t]=i}}_updateLoadedSiblingTileCache(){this._loadedSiblingTiles={};for(const t in this._tiles){const e=this._tiles[t].tileID,i=this._getLoadedTile(e);this._loadedSiblingTiles[e.key]=i}}_addTile(t){let e=this._tiles[t.key];if(e)return e;e=this._cache.getAndRemove(t),e&&(this._setTileReloadTimer(t.key,e),e.tileID=t,this._state.initializeTileState(e,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,e)));const i=e;return e||(e=new Vp(t,this._source.tileSize*t.overscaleFactor()),this._loadTile(e,t.key,e.state)),e.uses++,this._tiles[t.key]=e,i||this._source.fire(new de("dataloading",{tile:e,coord:e.tileID,dataType:"source"})),e}_setTileReloadTimer(t,e){t in this._timers&&(clearTimeout(this._timers[t]),delete this._timers[t]);const i=e.getExpiryTimeout();i&&(this._timers[t]=setTimeout((()=>{this._reloadTile(t,"expired"),delete this._timers[t]}),i))}_removeTile(t){const e=this._tiles[t];e&&(e.uses--,delete this._tiles[t],this._timers[t]&&(clearTimeout(this._timers[t]),delete this._timers[t]),e.uses>0||(e.hasData()&&"reloading"!==e.state?this._cache.add(e.tileID,e,e.getExpiryTimeout()):(e.aborted=!0,this._abortTile(e),this._unloadTile(e))))}_dataHandler(t){const e=t.sourceDataType;"source"===t.dataType&&"metadata"===e&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===t.dataType&&"content"===e&&(this.reload(t.sourceDataChanged),this.transform&&this.update(this.transform,this.terrain),this._didEmitContent=!0)}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const t in this._tiles)this._removeTile(t);this._cache.reset()}tilesIn(t,e,i){const r=[],n=this.transform;if(!n)return r;const s=i?n.getCameraQueryGeometry(t):t,o=t.map((t=>n.screenPointToMercatorCoordinate(t,this.terrain))),a=s.map((t=>n.screenPointToMercatorCoordinate(t,this.terrain))),l=this.getIds();let c=1/0,h=1/0,u=-1/0,p=-1/0;for(const t of a)c=Math.min(c,t.x),h=Math.min(h,t.y),u=Math.max(u,t.x),p=Math.max(p,t.y);for(let t=0;t<l.length;t++){const i=this._tiles[l[t]];if(i.holdingForFade())continue;const s=i.tileID,d=Math.pow(2,n.zoom-i.tileID.overscaledZ),f=e*i.queryPadding*J/i.tileSize/d,m=[s.getTilePoint(new mp(c,h)),s.getTilePoint(new mp(u,p))];if(m[0].x-f<J&&m[0].y-f<J&&m[1].x+f>=0&&m[1].y+f>=0){const t=o.map((t=>s.getTilePoint(t))),e=a.map((t=>s.getTilePoint(t)));r.push({tile:i,tileID:s,queryGeometry:t,cameraQueryGeometry:e,scale:d})}}return r}getVisibleCoordinates(t){const e=this.getRenderableIds(t).map((t=>this._tiles[t].tileID));return this.transform&&this.transform.populateCache(e),e}hasTransition(){if(this._source.hasTransition())return!0;if(Xp(this._source.type)){const t=Wt.now();for(const e in this._tiles)if(this._tiles[e].fadeEndTime>=t)return!0}return!1}setFeatureState(t,e,i){this._state.updateState(t=t||"_geojsonTileLayer",e,i)}removeFeatureState(t,e,i){this._state.removeFeatureState(t=t||"_geojsonTileLayer",e,i)}getFeatureState(t,e){return this._state.getState(t=t||"_geojsonTileLayer",e)}setDependencies(t,e,i){const r=this._tiles[t];r&&r.setDependencies(e,i)}reloadTilesForDependencies(t,e){for(const i in this._tiles)this._tiles[i].hasDependency(t,e)&&this._reloadTile(i,"reloading");this._cache.filter((i=>!i.hasDependency(t,e)))}}function Hp(t,e){const i=Math.abs(2*t.wrap)-+(t.wrap<0),r=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||r-i||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x}function Xp(t){return"raster"===t||"image"===t||"video"===t}Wp.maxOverzooming=10,Wp.maxUnderzooming=3;class Kp{constructor(t,e){this.reset(t,e)}reset(t,e){this.points=t||[],this._distances=[0];for(let t=1;t<this.points.length;t++)this._distances[t]=this._distances[t-1]+this.points[t].dist(this.points[t-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(e||0,.5*this.length),this.paddedLength=this.length-2*this.padding}lerp(t){if(1===this.points.length)return this.points[0];t=gt(t,0,1);let e=1,i=this._distances[e];const r=t*this.paddedLength+this.padding;for(;i<r&&e<this._distances.length;)i=this._distances[++e];const n=e-1,s=this._distances[n],o=i-s,a=o>0?(r-s)/o:0;return this.points[n].mult(1-a).add(this.points[e].mult(a))}}function Yp(t,e){let i=!0;return"always"===t||"never"!==t&&"never"!==e||(i=!1),i}class Jp{constructor(t,e,i){const r=this.boxCells=[],n=this.circleCells=[];this.xCellCount=Math.ceil(t/i),this.yCellCount=Math.ceil(e/i);for(let t=0;t<this.xCellCount*this.yCellCount;t++)r.push([]),n.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=t,this.height=e,this.xScale=this.xCellCount/t,this.yScale=this.yCellCount/e,this.boxUid=0,this.circleUid=0}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(t,e,i,r,n){this._forEachCell(e,i,r,n,this._insertBoxCell,this.boxUid++),this.boxKeys.push(t),this.bboxes.push(e),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)}insertCircle(t,e,i,r){this._forEachCell(e-r,i-r,e+r,i+r,this._insertCircleCell,this.circleUid++),this.circleKeys.push(t),this.circles.push(e),this.circles.push(i),this.circles.push(r)}_insertBoxCell(t,e,i,r,n,s){this.boxCells[n].push(s)}_insertCircleCell(t,e,i,r,n,s){this.circleCells[n].push(s)}_query(t,e,i,r,n,s,o){if(i<0||t>this.width||r<0||e>this.height)return[];const a=[];if(t<=0&&e<=0&&this.width<=i&&this.height<=r){if(n)return[{key:null,x1:t,y1:e,x2:i,y2:r}];for(let t=0;t<this.boxKeys.length;t++)a.push({key:this.boxKeys[t],x1:this.bboxes[4*t],y1:this.bboxes[4*t+1],x2:this.bboxes[4*t+2],y2:this.bboxes[4*t+3]});for(let t=0;t<this.circleKeys.length;t++){const e=this.circles[3*t],i=this.circles[3*t+1],r=this.circles[3*t+2];a.push({key:this.circleKeys[t],x1:e-r,y1:i-r,x2:e+r,y2:i+r})}}else this._forEachCell(t,e,i,r,this._queryCell,a,{hitTest:n,overlapMode:s,seenUids:{box:{},circle:{}}},o);return a}query(t,e,i,r){return this._query(t,e,i,r,!1,null)}hitTest(t,e,i,r,n,s){return this._query(t,e,i,r,!0,n,s).length>0}hitTestCircle(t,e,i,r,n){const s=t-i,o=t+i,a=e-i,l=e+i;if(o<0||s>this.width||l<0||a>this.height)return!1;const c=[];return this._forEachCell(s,a,o,l,this._queryCellCircle,c,{hitTest:!0,overlapMode:r,circle:{x:t,y:e,radius:i},seenUids:{box:{},circle:{}}},n),c.length>0}_queryCell(t,e,i,r,n,s,o,a){const{seenUids:l,hitTest:c,overlapMode:h}=o,u=this.boxCells[n];if(null!==u){const n=this.bboxes;for(const o of u)if(!l.box[o]){l.box[o]=!0;const u=4*o,p=this.boxKeys[o];if(t<=n[u+2]&&e<=n[u+3]&&i>=n[u+0]&&r>=n[u+1]&&(!a||a(p))&&(!c||!Yp(h,p.overlapMode))&&(s.push({key:p,x1:n[u],y1:n[u+1],x2:n[u+2],y2:n[u+3]}),c))return!0}}const p=this.circleCells[n];if(null!==p){const n=this.circles;for(const o of p)if(!l.circle[o]){l.circle[o]=!0;const u=3*o,p=this.circleKeys[o];if(this._circleAndRectCollide(n[u],n[u+1],n[u+2],t,e,i,r)&&(!a||a(p))&&(!c||!Yp(h,p.overlapMode))){const t=n[u],e=n[u+1],i=n[u+2];if(s.push({key:p,x1:t-i,y1:e-i,x2:t+i,y2:e+i}),c)return!0}}}return!1}_queryCellCircle(t,e,i,r,n,s,o,a){const{circle:l,seenUids:c,overlapMode:h}=o,u=this.boxCells[n];if(null!==u){const t=this.bboxes;for(const e of u)if(!c.box[e]){c.box[e]=!0;const i=4*e,r=this.boxKeys[e];if(this._circleAndRectCollide(l.x,l.y,l.radius,t[i+0],t[i+1],t[i+2],t[i+3])&&(!a||a(r))&&!Yp(h,r.overlapMode))return s.push(!0),!0}}const p=this.circleCells[n];if(null!==p){const t=this.circles;for(const e of p)if(!c.circle[e]){c.circle[e]=!0;const i=3*e,r=this.circleKeys[e];if(this._circlesCollide(t[i],t[i+1],t[i+2],l.x,l.y,l.radius)&&(!a||a(r))&&!Yp(h,r.overlapMode))return s.push(!0),!0}}}_forEachCell(t,e,i,r,n,s,o,a){const l=this._convertToXCellCoord(t),c=this._convertToYCellCoord(e),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(r);for(let p=l;p<=h;p++)for(let l=c;l<=u;l++)if(n.call(this,t,e,i,r,this.xCellCount*l+p,s,o,a))return}_convertToXCellCoord(t){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(t*this.xScale)))}_convertToYCellCoord(t){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(t*this.yScale)))}_circlesCollide(t,e,i,r,n,s){const o=r-t,a=n-e,l=i+s;return l*l>o*o+a*a}_circleAndRectCollide(t,e,i,r,n,s,o){const a=(s-r)/2,l=Math.abs(t-(r+a));if(l>a+i)return!1;const c=(o-n)/2,h=Math.abs(e-(n+c));if(h>c+i)return!1;if(l<=a||h<=c)return!0;const u=l-a,p=h-c;return u*u+p*p<=i*i}}function Qp(t,e,i){const r=x();if(!t){const{vecSouth:t,vecEast:i}=ed(e),u=g();u[0]=i[0],u[1]=i[1],u[2]=t[0],u[3]=t[1],n=u,(h=(o=(s=u)[0])*(c=s[3])-(l=s[2])*(a=s[1]))&&(n[0]=c*(h=1/h),n[1]=-a*h,n[2]=-l*h,n[3]=o*h),r[0]=u[0],r[1]=u[1],r[4]=u[2],r[5]=u[3]}var n,s,o,a,l,c,h;return M(r,r,[1/i,1/i,1]),r}function td(t,e,i,r){if(t){const t=x();if(!e){const{vecSouth:e,vecEast:r}=ed(i);t[0]=r[0],t[1]=r[1],t[4]=e[0],t[5]=e[1]}return M(t,t,[r,r,1]),t}return i.pixelsToClipSpaceMatrix}function ed(t){const e=Math.cos(t.rollInRadians),i=Math.sin(t.rollInRadians),r=Math.cos(t.pitchInRadians),n=Math.cos(t.bearingInRadians),s=Math.sin(t.bearingInRadians),o=q();o[0]=-n*r*i-s*e,o[1]=-s*r*i+n*e;const a=X(o);a<1e-9?K(o):H(o,o,1/a);const l=q();l[0]=n*r*e-s*i,l[1]=s*r*e+n*i;const c=X(l);return c<1e-9?K(l):H(l,l,1/c),{vecEast:l,vecSouth:o}}function id(t,e,i,r){let n;r?(n=[t,e,r(t,e),1],G(n,n,i)):(n=[t,e,0,1],xd(n,n,i));const s=n[3];return{point:new c(n[0]/s,n[1]/s),signedDistanceFromCamera:s,isOccluded:!1}}function rd(t,e){return.5+t/e*.5}function nd(t,e){return t.x>=-e[0]&&t.x<=e[0]&&t.y>=-e[1]&&t.y<=e[1]}function sd(t,e,i,r,n,s,o,a,l,h,u,p,d){const f=i?t.textSizeData:t.iconSizeData,m=su(f,e.transform.zoom),_=[256/e.width*2+1,256/e.height*2+1],g=i?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;g.clear();const y=t.lineVertexArray,x=i?t.text.placedSymbolArray:t.icon.placedSymbolArray,v=e.transform.width/e.transform.height;let b=!1;for(let i=0;i<x.length;i++){const w=x.get(i);if(w.hidden||w.writingMode===Qh.vertical&&!b){yd(w.numGlyphs,g);continue}b=!1;const T=new c(w.anchorX,w.anchorY),P={getElevation:d,pitchedLabelPlaneMatrix:r,lineVertexArray:y,pitchWithMap:s,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:e.transform,tileAnchorPoint:T,unwrappedTileID:l,width:h,height:u,translation:p},M=dd(w.anchorX,w.anchorY,P);if(!nd(M.point,_)){yd(w.numGlyphs,g);continue}const C=rd(e.transform.cameraToCenterDistance,M.signedDistanceFromCamera),I=nu(f,m,w),S=s?I*e.transform.getPitchedTextCorrection(w.anchorX,w.anchorY,l)/C:I*C,E=ld({projectionContext:P,pitchedLabelPlaneMatrixInverse:n,symbol:w,fontSize:S,flip:!1,keepUpright:o,glyphOffsetArray:t.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:v,rotateToLine:a});b=E.useVertical,(E.notEnoughRoom||b||E.needsFlipping&&ld({projectionContext:P,pitchedLabelPlaneMatrixInverse:n,symbol:w,fontSize:S,flip:!0,keepUpright:o,glyphOffsetArray:t.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:v,rotateToLine:a}).notEnoughRoom)&&yd(w.numGlyphs,g)}i?t.text.dynamicLayoutVertexBuffer.updateData(g):t.icon.dynamicLayoutVertexBuffer.updateData(g)}function od(t,e,i,r,n,s,o,a){const l=s.glyphStartIndex+s.numGlyphs,c=s.lineStartIndex,h=s.lineStartIndex+s.lineLength,u=e.getoffsetX(s.glyphStartIndex),p=e.getoffsetX(l-1),d=_d(t*u,i,r,n,s.segment,c,h,a,o);if(!d)return null;const f=_d(t*p,i,r,n,s.segment,c,h,a,o);return f?a.projectionCache.anyProjectionOccluded?null:{first:d,last:f}:null}function ad(t,e,i,r){return t===Qh.horizontal&&Math.abs(i.y-e.y)>Math.abs(i.x-e.x)*r?{useVertical:!0}:(t===Qh.vertical?e.y<i.y:e.x>i.x)?{needsFlipping:!0}:null}function ld(t){const{projectionContext:e,pitchedLabelPlaneMatrixInverse:i,symbol:r,fontSize:n,flip:s,keepUpright:o,glyphOffsetArray:a,dynamicLayoutVertexArray:l,aspectRatio:h,rotateToLine:u}=t,p=n/24,d=r.lineOffsetX*p,f=r.lineOffsetY*p;let m;if(r.numGlyphs>1){const t=r.glyphStartIndex+r.numGlyphs,n=r.lineStartIndex,l=r.lineStartIndex+r.lineLength,c=od(p,a,d,f,s,r,u,e);if(!c)return{notEnoughRoom:!0};const _=pd(c.first.point.x,c.first.point.y,e,i),g=pd(c.last.point.x,c.last.point.y,e,i);if(o&&!s){const t=ad(r.writingMode,_,g,h);if(t)return t}m=[c.first];for(let i=r.glyphStartIndex+1;i<t-1;i++)m.push(_d(p*a.getoffsetX(i),d,f,s,r.segment,n,l,e,u));m.push(c.last)}else{if(o&&!s){const t=ud(e.tileAnchorPoint.x,e.tileAnchorPoint.y,e).point,n=r.lineStartIndex+r.segment+1,s=new c(e.lineVertexArray.getx(n),e.lineVertexArray.gety(n)),o=ud(s.x,s.y,e),a=o.signedDistanceFromCamera>0?o.point:cd(e.tileAnchorPoint,s,t,1,e),l=pd(t.x,t.y,e,i),u=pd(a.x,a.y,e,i),p=ad(r.writingMode,l,u,h);if(p)return p}const t=_d(p*a.getoffsetX(r.glyphStartIndex),d,f,s,r.segment,r.lineStartIndex,r.lineStartIndex+r.lineLength,e,u);if(!t||e.projectionCache.anyProjectionOccluded)return{notEnoughRoom:!0};m=[t]}for(const t of m)hu(l,t.point,t.angle);return{}}function cd(t,e,i,r,n){const s=t.add(t.sub(e)._unit()),o=ud(s.x,s.y,n).point,a=i.sub(o);return i.add(a._mult(r/a.mag()))}function hd(t,e,i){const r=e.projectionCache;if(r.projections[t])return r.projections[t];const n=new c(e.lineVertexArray.getx(t),e.lineVertexArray.gety(t)),s=ud(n.x,n.y,e);if(s.signedDistanceFromCamera>0)return r.projections[t]=s.point,r.anyProjectionOccluded=r.anyProjectionOccluded||s.isOccluded,s.point;const o=t-i.direction;return cd(0===i.distanceFromAnchor?e.tileAnchorPoint:new c(e.lineVertexArray.getx(o),e.lineVertexArray.gety(o)),n,i.previousVertex,i.absOffsetX-i.distanceFromAnchor+1,e)}function ud(t,e,i){const r=t+i.translation[0],n=e+i.translation[1];let s;return i.pitchWithMap?(s=id(r,n,i.pitchedLabelPlaneMatrix,i.getElevation),s.isOccluded=!1):(s=i.transform.projectTileCoordinates(r,n,i.unwrappedTileID,i.getElevation),s.point.x=(.5*s.point.x+.5)*i.width,s.point.y=(.5*-s.point.y+.5)*i.height),s}function pd(t,e,i,r){if(i.pitchWithMap){const n=[t,e,0,1];return G(n,n,r),i.transform.projectTileCoordinates(n[0]/n[3],n[1]/n[3],i.unwrappedTileID,i.getElevation).point}return{x:t/i.width*2-1,y:e/i.height*2-1}}function dd(t,e,i){return i.transform.projectTileCoordinates(t,e,i.unwrappedTileID,i.getElevation)}function fd(t,e,i){return t._unit()._perp()._mult(e*i)}function md(t,e,i,r,n,s,o,a,l){if(a.projectionCache.offsets[t])return a.projectionCache.offsets[t];const h=i.add(e);if(t+l.direction<r||t+l.direction>=n)return a.projectionCache.offsets[t]=h,h;const u=hd(t+l.direction,a,l),p=fd(u.sub(i),o,l.direction),d=i.add(p),f=u.add(p);return a.projectionCache.offsets[t]=function(t,e,i,r){const n=e.y-t.y,s=e.x-t.x,o=r.y-i.y,a=r.x-i.x,l=o*s-a*n;if(0===l)return null;const h=(a*(t.y-i.y)-o*(t.x-i.x))/l;return new c(t.x+h*s,t.y+h*n)}(s,h,d,f)||h,a.projectionCache.offsets[t]}function _d(t,e,i,r,n,s,o,a,l){const c=r?t-e:t+e;let h=c>0?1:-1,u=0;r&&(h*=-1,u=Math.PI),h<0&&(u+=Math.PI);let p,d=h>0?s+n:s+n+1;a.projectionCache.cachedAnchorPoint?p=a.projectionCache.cachedAnchorPoint:(p=ud(a.tileAnchorPoint.x,a.tileAnchorPoint.y,a).point,a.projectionCache.cachedAnchorPoint=p);let f,m,_=p,g=p,y=0,x=0;const v=Math.abs(c),b=[];let w;for(;y+x<=v;){if(d+=h,d<s||d>=o)return null;y+=x,g=_,m=f;const t={absOffsetX:v,direction:h,distanceFromAnchor:y,previousVertex:g};if(_=hd(d,a,t),0===i)b.push(g),w=_.sub(g);else{let e;const r=_.sub(g);e=0===r.mag()?fd(hd(d+h,a,t).sub(_),i,h):fd(r,i,h),m||(m=g.add(e)),f=md(d,e,_,s,o,m,i,a,t),b.push(m),w=f.sub(m)}x=w.mag()}const T=w._mult((v-y)/x)._add(m||g),P=u+Math.atan2(_.y-g.y,_.x-g.x);return b.push(T),{point:T,angle:l?P:0,path:b}}const gd=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function yd(t,e){for(let i=0;i<t;i++){const t=e.length;e.resize(t+4),e.float32.set(gd,3*t)}}function xd(t,e,i){const r=e[0],n=e[1];return t[0]=i[0]*r+i[4]*n+i[12],t[1]=i[1]*r+i[5]*n+i[13],t[3]=i[3]*r+i[7]*n+i[15],t}const vd=100;class bd{constructor(t,e=new Jp(t.width+200,t.height+200,25),i=new Jp(t.width+200,t.height+200,25)){this.transform=t,this.grid=e,this.ignoredGrid=i,this.pitchFactor=Math.cos(t.pitch*Math.PI/180)*t.cameraToCenterDistance,this.screenRightBoundary=t.width+vd,this.screenBottomBoundary=t.height+vd,this.gridRightBoundary=t.width+200,this.gridBottomBoundary=t.height+200,this.perspectiveRatioCutoff=.6}placeCollisionBox(t,e,i,r,n,s,o,a,l,c,h,u){const p=this.projectAndGetPerspectiveRatio(t.anchorPointX+a[0],t.anchorPointY+a[1],n,c,u),d=i*p.perspectiveRatio;let f;if(s||o)f=this._projectCollisionBox(t,d,r,n,s,o,a,p,c,h,u);else{const e=p.x+(h?h.x*d:0),i=p.y+(h?h.y*d:0);f={allPointsOccluded:!1,box:[e+t.x1*d,i+t.y1*d,e+t.x2*d,i+t.y2*d]}}const[m,_,g,y]=f.box,x=s?f.allPointsOccluded:p.isOccluded;let v=x;return v||(v=p.perspectiveRatio<this.perspectiveRatioCutoff),v||(v=!this.isInsideGrid(m,_,g,y)),v||"always"!==e&&this.grid.hitTest(m,_,g,y,e,l)?{box:[m,_,g,y],placeable:!1,offscreen:!1,occluded:x}:{box:[m,_,g,y],placeable:!0,offscreen:this.isOffscreen(m,_,g,y),occluded:x}}placeCollisionCircles(t,e,i,r,n,s,o,a,l,h,u,p,d,f){const m=[],_=new c(e.anchorX,e.anchorY),g=this.getPerspectiveRatio(_.x,_.y,s,f),y=(l?n*this.transform.getPitchedTextCorrection(e.anchorX,e.anchorY,s)/g:n*g)/24,x={getElevation:f,pitchedLabelPlaneMatrix:o,lineVertexArray:i,pitchWithMap:l,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:this.transform,tileAnchorPoint:_,unwrappedTileID:s,width:this.transform.width,height:this.transform.height,translation:d},v=od(y,r,e.lineOffsetX*y,e.lineOffsetY*y,!1,e,!1,x);let b=!1,w=!1,T=!0;if(v){const e=.5*u*g+p,i=new c(-100,-100),r=new c(this.screenRightBoundary,this.screenBottomBoundary),n=new Kp,s=v.first,o=v.last;let d=[];for(let t=s.path.length-1;t>=1;t--)d.push(s.path[t]);for(let t=1;t<o.path.length;t++)d.push(o.path[t]);const f=2.5*e;if(l){const t=this.projectPathToScreenSpace(d,x);d=t.some((t=>t.signedDistanceFromCamera<=0))?[]:t.map((t=>t.point))}let _=[];if(d.length>0){const t=d[0].clone(),e=d[0].clone();for(let i=1;i<d.length;i++)t.x=Math.min(t.x,d[i].x),t.y=Math.min(t.y,d[i].y),e.x=Math.max(e.x,d[i].x),e.y=Math.max(e.y,d[i].y);_=t.x>=i.x&&e.x<=r.x&&t.y>=i.y&&e.y<=r.y?[d]:e.x<i.x||t.x>r.x||e.y<i.y||t.y>r.y?[]:function(t,e,i,r,n){const s=[];for(let o=0;o<t.length;o++){const a=t[o];let l;for(let t=0;t<a.length-1;t++){let o=a[t],h=a[t+1];o.x<e&&h.x<e||(o.x<e?o=new c(e,o.y+(e-o.x)/(h.x-o.x)*(h.y-o.y))._round():h.x<e&&(h=new c(e,o.y+(e-o.x)/(h.x-o.x)*(h.y-o.y))._round()),o.y<i&&h.y<i||(o.y<i?o=new c(o.x+(i-o.y)/(h.y-o.y)*(h.x-o.x),i)._round():h.y<i&&(h=new c(o.x+(i-o.y)/(h.y-o.y)*(h.x-o.x),i)._round()),o.x>=r&&h.x>=r||(o.x>=r?o=new c(r,o.y+(r-o.x)/(h.x-o.x)*(h.y-o.y))._round():h.x>=r&&(h=new c(r,o.y+(r-o.x)/(h.x-o.x)*(h.y-o.y))._round()),o.y>=n&&h.y>=n||(o.y>=n?o=new c(o.x+(n-o.y)/(h.y-o.y)*(h.x-o.x),n)._round():h.y>=n&&(h=new c(o.x+(n-o.y)/(h.y-o.y)*(h.x-o.x),n)._round()),l&&o.equals(l[l.length-1])||(l=[o],s.push(l)),l.push(h)))))}}return s}([d],i.x,i.y,r.x,r.y)}for(const i of _){n.reset(i,.25*e);let r=0;r=n.length<=.5*e?1:Math.ceil(n.paddedLength/f)+1;for(let i=0;i<r;i++){const s=i/Math.max(r-1,1),o=n.lerp(s),l=o.x+vd,c=o.y+vd;m.push(l,c,e,0);const u=l-e,p=c-e,d=l+e,f=c+e;if(T=T&&this.isOffscreen(u,p,d,f),w=w||this.isInsideGrid(u,p,d,f),"always"!==t&&this.grid.hitTestCircle(l,c,e,t,h)&&(b=!0,!a))return{circles:[],offscreen:!1,collisionDetected:b}}}}return{circles:!a&&b||!w||g<this.perspectiveRatioCutoff?[]:m,offscreen:T,collisionDetected:b}}projectPathToScreenSpace(t,e){const i=function(t,e){const i=x();return w(i,e.pitchedLabelPlaneMatrix),t.map((t=>{const r=id(t.x,t.y,i,e.getElevation),n=e.transform.projectTileCoordinates(r.point.x,r.point.y,e.unwrappedTileID,e.getElevation);return n.point.x=(.5*n.point.x+.5)*e.width,n.point.y=(.5*-n.point.y+.5)*e.height,n}))}(t,e);return function(t){let e=0,i=0,r=0,n=0;for(let s=0;s<t.length;s++)t[s].isOccluded?(r=s+1,n=0):(n++,n>i&&(i=n,e=r));return t.slice(e,e+i)}(i)}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return{};const e=[];let i=1/0,r=1/0,n=-1/0,s=-1/0;for(const o of t){const t=new c(o.x+vd,o.y+vd);i=Math.min(i,t.x),r=Math.min(r,t.y),n=Math.max(n,t.x),s=Math.max(s,t.y),e.push(t)}const o=this.grid.query(i,r,n,s).concat(this.ignoredGrid.query(i,r,n,s)),a={},l={};for(const t of o){const i=t.key;void 0===a[i.bucketInstanceId]&&(a[i.bucketInstanceId]={}),a[i.bucketInstanceId][i.featureIndex]||wl(e,[new c(t.x1,t.y1),new c(t.x2,t.y1),new c(t.x2,t.y2),new c(t.x1,t.y2)])&&(a[i.bucketInstanceId][i.featureIndex]=!0,void 0===l[i.bucketInstanceId]&&(l[i.bucketInstanceId]=[]),l[i.bucketInstanceId].push(i.featureIndex))}return l}insertCollisionBox(t,e,i,r,n,s){(i?this.ignoredGrid:this.grid).insert({bucketInstanceId:r,featureIndex:n,collisionGroupID:s,overlapMode:e},t[0],t[1],t[2],t[3])}insertCollisionCircles(t,e,i,r,n,s){const o=i?this.ignoredGrid:this.grid,a={bucketInstanceId:r,featureIndex:n,collisionGroupID:s,overlapMode:e};for(let e=0;e<t.length;e+=4)o.insertCircle(a,t[e],t[e+1],t[e+2])}projectAndGetPerspectiveRatio(t,e,i,r,n){if(n){let i;r?(i=[t,e,r(t,e),1],G(i,i,n)):(i=[t,e,0,1],xd(i,i,n));const s=i[3];return{x:(i[0]/s+1)/2*this.transform.width+vd,y:(-i[1]/s+1)/2*this.transform.height+vd,perspectiveRatio:.5+this.transform.cameraToCenterDistance/s*.5,isOccluded:!1,signedDistanceFromCamera:s}}{const n=this.transform.projectTileCoordinates(t,e,i,r);return{x:(n.point.x+1)/2*this.transform.width+vd,y:(1-n.point.y)/2*this.transform.height+vd,perspectiveRatio:.5+this.transform.cameraToCenterDistance/n.signedDistanceFromCamera*.5,isOccluded:n.isOccluded,signedDistanceFromCamera:n.signedDistanceFromCamera}}}getPerspectiveRatio(t,e,i,r){const n=this.transform.projectTileCoordinates(t,e,i,r);return.5+this.transform.cameraToCenterDistance/n.signedDistanceFromCamera*.5}isOffscreen(t,e,i,r){return i<vd||t>=this.screenRightBoundary||r<vd||e>this.screenBottomBoundary}isInsideGrid(t,e,i,r){return i>=0&&t<this.gridRightBoundary&&r>=0&&e<this.gridBottomBoundary}getViewportMatrix(){const t=b([]);return P(t,t,[-100,-100,0]),t}_projectCollisionBox(t,e,i,r,n,s,o,a,l,h,u){let p=1,d=0,f=0,m=1;const _=t.anchorPointX+o[0],g=t.anchorPointY+o[1];if(s&&!n){const t=this.projectAndGetPerspectiveRatio(_+1,g,r,l,u),e=t.x-a.x,i=Math.atan((t.y-a.y)/e)+(e<0?Math.PI:0),n=Math.sin(i),s=Math.cos(i);p=s,d=n,f=-n,m=s}else if(!s&&n){const t=ed(this.transform);p=t.vecEast[0],d=t.vecEast[1],f=t.vecSouth[0],m=t.vecSouth[1]}let y=a.x,x=a.y,v=e;n&&(y=_,x=g,v=Math.pow(2,-(this.transform.zoom-i.overscaledZ)),v*=this.transform.getPitchedTextCorrection(_,g,r),h||(v*=gt(.5+a.signedDistanceFromCamera/this.transform.cameraToCenterDistance*.5,0,4))),h&&(y+=p*h.x*v+f*h.y*v,x+=d*h.x*v+m*h.y*v);const b=t.x1*v,w=t.x2*v,T=(b+w)/2,P=t.y1*v,M=t.y2*v,C=(P+M)/2,I=[{offsetX:b,offsetY:P},{offsetX:T,offsetY:P},{offsetX:w,offsetY:P},{offsetX:w,offsetY:C},{offsetX:w,offsetY:M},{offsetX:T,offsetY:M},{offsetX:b,offsetY:M},{offsetX:b,offsetY:C}];let S=[];for(const{offsetX:t,offsetY:e}of I)S.push(new c(y+p*t+f*e,x+d*t+m*e));let E=!1;if(n){const t=S.map((t=>this.projectAndGetPerspectiveRatio(t.x,t.y,r,l,u)));E=t.some((t=>!t.isOccluded)),S=t.map((t=>new c(t.x,t.y)))}else E=!0;return{box:dt(S),allPointsOccluded:!E}}}class wd extends c{constructor(t,e,i,r){super(t,e),this.angle=i,void 0!==r&&(this.segment=r)}clone(){return new wd(this.x,this.y,this.angle,this.segment)}}var Td;Ws("Anchor",wd),function(t){t[t.center=1]="center",t[t.left=2]="left",t[t.right=3]="right",t[t.top=4]="top",t[t.bottom=5]="bottom",t[t["top-left"]=6]="top-left",t[t["top-right"]=7]="top-right",t[t["bottom-left"]=8]="bottom-left",t[t["bottom-right"]=9]="bottom-right"}(Td||(Td={}));class Pd{constructor(t,e,i,r){this.opacity=t?Math.max(0,Math.min(1,t.opacity+(t.placed?e:-e))):r&&i?1:0,this.placed=i}isHidden(){return 0===this.opacity&&!this.placed}}class Md{constructor(t,e,i,r,n){this.text=new Pd(t?t.text:null,e,i,n),this.icon=new Pd(t?t.icon:null,e,r,n)}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class Cd{constructor(t,e,i){this.text=t,this.icon=e,this.skipFade=i}}class Id{constructor(t,e,i,r,n){this.bucketInstanceId=t,this.featureIndex=e,this.sourceLayerIndex=i,this.bucketIndex=r,this.tileID=n}}class Sd{constructor(t){this.crossSourceCollisions=t,this.maxGroupID=0,this.collisionGroups={}}get(t){if(this.crossSourceCollisions)return{ID:0,predicate:null};if(!this.collisionGroups[t]){const e=++this.maxGroupID;this.collisionGroups[t]={ID:e,predicate:t=>t.collisionGroupID===e}}return this.collisionGroups[t]}}function Ed(t,e,i,r,n){const{horizontalAlign:s,verticalAlign:o}=tu(t);return new c(-(s-.5)*e+r[0]*n,-(o-.5)*i+r[1]*n)}class Ad{constructor(t,e,i,r,n){this.transform=t.clone(),this.terrain=e,this.collisionIndex=new bd(this.transform),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=i,this.retainedQueryData={},this.collisionGroups=new Sd(r),this.collisionCircleArrays={},this.collisionBoxArrays=new Map,this.prevPlacement=n,n&&(n.prevPlacement=void 0),this.placedOrientations={}}_getTerrainElevationFunc(t){const e=this.terrain;return e?(i,r)=>e.getElevation(t,i,r):null}getBucketParts(t,e,i,r){const n=i.getBucket(e),s=i.latestFeatureIndex;if(!n||!s||e.id!==n.layerIds[0])return;const o=i.collisionBoxArray,a=n.layers[0].layout,l=n.layers[0].paint,c=Math.pow(2,this.transform.zoom-i.tileID.overscaledZ),h=i.tileSize/J,u=i.tileID.toUnwrapped(),p="map"===a.get("text-rotation-alignment"),d=Q(i,1,this.transform.zoom),f=st(this.collisionIndex.transform,i,l.get("text-translate"),l.get("text-translate-anchor")),m=st(this.collisionIndex.transform,i,l.get("icon-translate"),l.get("icon-translate-anchor")),_=Qp(p,this.transform,d);this.retainedQueryData[n.bucketInstanceId]=new Id(n.bucketInstanceId,s,n.sourceLayerIndex,n.index,i.tileID);const g={bucket:n,layout:a,translationText:f,translationIcon:m,unwrappedTileID:u,pitchedLabelPlaneMatrix:_,scale:c,textPixelRatio:h,holdingForFade:i.holdingForFade(),collisionBoxArray:o,partiallyEvaluatedTextSize:su(n.textSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(n.sourceID)};if(r)for(const e of n.sortKeyRanges){const{sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n}=e;t.push({sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n,parameters:g})}else t.push({symbolInstanceStart:0,symbolInstanceEnd:n.symbolInstances.length,parameters:g})}attemptAnchorPlacement(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x){const v=Td[t.textAnchor],b=[t.textOffset0,t.textOffset1],w=Ed(v,i,r,b,n),T=this.collisionIndex.placeCollisionBox(e,u,a,l,c,o,s,m,h.predicate,y,w,x);if((!g||this.collisionIndex.placeCollisionBox(g,u,a,l,c,o,s,_,h.predicate,y,w,x).placeable)&&T.placeable){let t;if(this.prevPlacement&&this.prevPlacement.variableOffsets[p.crossTileID]&&this.prevPlacement.placements[p.crossTileID]&&this.prevPlacement.placements[p.crossTileID].text&&(t=this.prevPlacement.variableOffsets[p.crossTileID].anchor),0===p.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");return this.variableOffsets[p.crossTileID]={textOffset:b,width:i,height:r,anchor:v,textBoxScale:n,prevAnchor:t},this.markUsedJustification(d,v,p,f),d.allowVerticalPlacement&&(this.markUsedOrientation(d,f,p),this.placedOrientations[p.crossTileID]=f),{shift:w,placedGlyphBoxes:T}}}placeLayerBucketPart(t,e,i){const{bucket:r,layout:n,translationText:s,translationIcon:o,unwrappedTileID:a,pitchedLabelPlaneMatrix:l,textPixelRatio:c,holdingForFade:h,collisionBoxArray:u,partiallyEvaluatedTextSize:p,collisionGroup:d}=t.parameters,f=n.get("text-optional"),m=n.get("icon-optional"),_=ou(n,"text-overlap","text-allow-overlap"),g="always"===_,y=ou(n,"icon-overlap","icon-allow-overlap"),x="always"===y,v="map"===n.get("text-rotation-alignment"),b="map"===n.get("text-pitch-alignment"),w="none"!==n.get("icon-text-fit"),T="viewport-y"===n.get("symbol-z-order"),P=g&&(x||!r.hasIconData()||m),M=x&&(g||!r.hasTextData()||f);!r.collisionArrays&&u&&r.deserializeCollisionBoxes(u);const C=this.retainedQueryData[r.bucketInstanceId].tileID,I=this._getTerrainElevationFunc(C),S=this.transform.getFastPathSimpleProjectionMatrix(C),E=(t,u,x)=>{var T,E;if(e[t.crossTileID])return;if(h)return void(this.placements[t.crossTileID]=new Cd(!1,!1,!1));let A=!1,z=!1,k=!0,D=null,R={box:null,placeable:!1,offscreen:null,occluded:!1},L={placeable:!1},B=null,F=null,O=null,j=0,V=0,N=0;u.textFeatureIndex?j=u.textFeatureIndex:t.useRuntimeCollisionCircles&&(j=t.featureIndex),u.verticalTextFeatureIndex&&(V=u.verticalTextFeatureIndex);const U=u.textBox;if(U){const e=e=>{let i=Qh.horizontal;if(r.allowVerticalPlacement&&!e&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[t.crossTileID];e&&(this.placedOrientations[t.crossTileID]=e,i=e,this.markUsedOrientation(r,i,t))}return i},n=(e,i)=>{if(r.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&u.verticalTextBox){for(const t of r.writingModes)if(t===Qh.vertical?(R=i(),L=R):R=e(),R&&R.placeable)break}else R=e()},l=t.textAnchorOffsetStartIndex,h=t.textAnchorOffsetEndIndex;if(h===l){const i=(e,i)=>{const n=this.collisionIndex.placeCollisionBox(e,_,c,C,a,b,v,s,d.predicate,I,void 0,S);return n&&n.placeable&&(this.markUsedOrientation(r,i,t),this.placedOrientations[t.crossTileID]=i),n};n((()=>i(U,Qh.horizontal)),(()=>{const e=u.verticalTextBox;return r.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&e?i(e,Qh.vertical):{box:null,offscreen:null}})),e(R&&R.placeable)}else{let p=Td[null===(E=null===(T=this.prevPlacement)||void 0===T?void 0:T.variableOffsets[t.crossTileID])||void 0===E?void 0:E.anchor];const f=(e,n,u)=>{const f=e.x2-e.x1,m=e.y2-e.y1,g=t.textBoxScale,x=w&&"never"===y?n:null;let T=null,P="never"===_?1:2,M="never";p&&P++;for(let i=0;i<P;i++){for(let i=l;i<h;i++){const n=r.textAnchorOffsets.get(i);if(p&&n.textAnchor!==p)continue;const l=this.attemptAnchorPlacement(n,e,f,m,g,v,b,c,C,a,d,M,t,r,u,s,o,x,I);if(l&&(T=l.placedGlyphBoxes,T&&T.placeable))return A=!0,D=l.shift,T}p?p=null:M=_}return i&&!T&&(T={box:this.collisionIndex.placeCollisionBox(U,"always",c,C,a,b,v,s,d.predicate,I,void 0,S).box,offscreen:!1,placeable:!1,occluded:!1}),T};n((()=>f(U,u.iconBox,Qh.horizontal)),(()=>{const e=u.verticalTextBox;return r.allowVerticalPlacement&&(!R||!R.placeable)&&t.numVerticalGlyphVertices>0&&e?f(e,u.verticalIconBox,Qh.vertical):{box:null,occluded:!0,offscreen:null}})),R&&(A=R.placeable,k=R.offscreen);const m=e(R&&R.placeable);if(!A&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[t.crossTileID];e&&(this.variableOffsets[t.crossTileID]=e,this.markUsedJustification(r,e.anchor,t,m))}}}if(B=R,A=B&&B.placeable,k=B&&B.offscreen,t.useRuntimeCollisionCircles){const e=r.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex),o=nu(r.textSizeData,p,e),c=n.get("text-padding");F=this.collisionIndex.placeCollisionCircles(_,e,r.lineVertexArray,r.glyphOffsetArray,o,a,l,i,b,d.predicate,t.collisionCircleDiameter,c,s,I),F.circles.length&&F.collisionDetected&&!i&&At("Collisions detected, but collision boxes are not shown"),A=g||F.circles.length>0&&!F.collisionDetected,k=k&&F.offscreen}if(u.iconFeatureIndex&&(N=u.iconFeatureIndex),u.iconBox){const t=t=>this.collisionIndex.placeCollisionBox(t,y,c,C,a,b,v,o,d.predicate,I,w&&D?D:void 0,S);L&&L.placeable&&u.verticalIconBox?(O=t(u.verticalIconBox),z=O.placeable):(O=t(u.iconBox),z=O.placeable),k=k&&O.offscreen}const Z=f||0===t.numHorizontalGlyphVertices&&0===t.numVerticalGlyphVertices,G=m||0===t.numIconVertices;Z||G?G?Z||(z=z&&A):A=z&&A:z=A=z&&A;const $=z&&O.placeable;if(A&&B.placeable&&this.collisionIndex.insertCollisionBox(B.box,_,n.get("text-ignore-placement"),r.bucketInstanceId,L&&L.placeable&&V?V:j,d.ID),$&&this.collisionIndex.insertCollisionBox(O.box,y,n.get("icon-ignore-placement"),r.bucketInstanceId,N,d.ID),F&&A&&this.collisionIndex.insertCollisionCircles(F.circles,_,n.get("text-ignore-placement"),r.bucketInstanceId,j,d.ID),i&&this.storeCollisionData(r.bucketInstanceId,x,u,B,O,F),0===t.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");if(0===r.bucketInstanceId)throw new Error("bucket.bucketInstanceId can't be 0");this.placements[t.crossTileID]=new Cd((A||P)&&!(null==B?void 0:B.occluded),(z||M)&&!(null==O?void 0:O.occluded),k||r.justReloaded),e[t.crossTileID]=!0};if(T){if(0!==t.symbolInstanceStart)throw new Error("bucket.bucketInstanceId should be 0");const e=r.getSortedSymbolIndexes(-this.transform.bearingInRadians);for(let t=e.length-1;t>=0;--t){const i=e[t];E(r.symbolInstances.get(i),r.collisionArrays[i],i)}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)E(r.symbolInstances.get(e),r.collisionArrays[e],e);r.justReloaded=!1}storeCollisionData(t,e,i,r,n,s){if(i.textBox||i.iconBox){let s,o;this.collisionBoxArrays.has(t)?s=this.collisionBoxArrays.get(t):(s=new Map,this.collisionBoxArrays.set(t,s)),s.has(e)?o=s.get(e):(o={text:null,icon:null},s.set(e,o)),i.textBox&&(o.text=r.box),i.iconBox&&(o.icon=n.box)}if(s){let e=this.collisionCircleArrays[t];void 0===e&&(e=this.collisionCircleArrays[t]=[]);for(let t=0;t<s.circles.length;t+=4)e.push(s.circles[t+0]-vd),e.push(s.circles[t+1]-vd),e.push(s.circles[t+2]),e.push(s.collisionDetected?1:0)}}markUsedJustification(t,e,i,r){let n;n=r===Qh.vertical?i.verticalPlacedTextSymbolIndex:{left:i.leftJustifiedTextSymbolIndex,center:i.centerJustifiedTextSymbolIndex,right:i.rightJustifiedTextSymbolIndex}[function(t){switch(t){case"right":case"top-right":case"bottom-right":return"right";case"left":case"top-left":case"bottom-left":return"left"}return"center"}(e)];const s=[i.leftJustifiedTextSymbolIndex,i.centerJustifiedTextSymbolIndex,i.rightJustifiedTextSymbolIndex,i.verticalPlacedTextSymbolIndex];for(const e of s)e>=0&&(t.text.placedSymbolArray.get(e).crossTileID=n>=0&&e!==n?0:i.crossTileID)}markUsedOrientation(t,e,i){const r=e===Qh.horizontal||e===Qh.horizontalOnly?e:0,n=e===Qh.vertical?e:0,s=[i.leftJustifiedTextSymbolIndex,i.centerJustifiedTextSymbolIndex,i.rightJustifiedTextSymbolIndex];for(const e of s)t.text.placedSymbolArray.get(e).placedOrientation=r;i.verticalPlacedTextSymbolIndex&&(t.text.placedSymbolArray.get(i.verticalPlacedTextSymbolIndex).placedOrientation=n)}commit(t){this.commitTime=t,this.zoomAtLastRecencyCheck=this.transform.zoom;const e=this.prevPlacement;let i=!1;this.prevZoomAdjustment=e?e.zoomAdjustment(this.transform.zoom):0;const r=e?e.symbolFadeChange(t):1,n=e?e.opacities:{},s=e?e.variableOffsets:{},o=e?e.placedOrientations:{};for(const t in this.placements){const e=this.placements[t],s=n[t];s?(this.opacities[t]=new Md(s,r,e.text,e.icon),i=i||e.text!==s.text.placed||e.icon!==s.icon.placed):(this.opacities[t]=new Md(null,r,e.text,e.icon,e.skipFade),i=i||e.text||e.icon)}for(const t in n){const e=n[t];if(!this.opacities[t]){const n=new Md(e,r,!1,!1);n.isHidden()||(this.opacities[t]=n,i=i||e.text.placed||e.icon.placed)}}for(const t in s)this.variableOffsets[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.variableOffsets[t]=s[t]);for(const t in o)this.placedOrientations[t]||!this.opacities[t]||this.opacities[t].isHidden()||(this.placedOrientations[t]=o[t]);if(e&&void 0===e.lastPlacementChangeTime)throw new Error("Last placement time for previous placement is not defined");i?this.lastPlacementChangeTime=t:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=e?e.lastPlacementChangeTime:t)}updateLayerOpacities(t,e){const i={};for(const r of e){const e=r.getBucket(t);e&&r.latestFeatureIndex&&t.id===e.layerIds[0]&&this.updateBucketOpacities(e,r.tileID,i,r.collisionBoxArray)}}updateBucketOpacities(t,e,i,r){t.hasTextData()&&(t.text.opacityVertexArray.clear(),t.text.hasVisibleVertices=!1),t.hasIconData()&&(t.icon.opacityVertexArray.clear(),t.icon.hasVisibleVertices=!1),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const n=t.layers[0],s=n.layout,o=new Md(null,0,!1,!1,!0),a=s.get("text-allow-overlap"),l=s.get("icon-allow-overlap"),h=n._unevaluatedLayout.hasValue("text-variable-anchor")||n._unevaluatedLayout.hasValue("text-variable-anchor-offset"),u="map"===s.get("text-rotation-alignment"),p="map"===s.get("text-pitch-alignment"),d="none"!==s.get("icon-text-fit"),f=new Md(null,0,a&&(l||!t.hasIconData()||s.get("icon-optional")),l&&(a||!t.hasTextData()||s.get("text-optional")),!0);!t.collisionArrays&&r&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(r);const m=(t,e,i)=>{for(let r=0;r<e/4;r++)t.opacityVertexArray.emplaceBack(i);t.hasVisibleVertices=t.hasVisibleVertices||i!==Vd},_=this.collisionBoxArrays.get(t.bucketInstanceId);for(let e=0;e<t.symbolInstances.length;e++){const r=t.symbolInstances.get(e),{numHorizontalGlyphVertices:n,numVerticalGlyphVertices:s,crossTileID:a}=r;let l=this.opacities[a];i[a]?l=o:l||(l=f,this.opacities[a]=l),i[a]=!0;const g=r.numIconVertices>0,y=this.placedOrientations[r.crossTileID],x=y===Qh.vertical,v=y===Qh.horizontal||y===Qh.horizontalOnly;if(n>0||s>0){const e=jd(l.text);m(t.text,n,x?Vd:e),m(t.text,s,v?Vd:e);const i=l.text.isHidden();[r.rightJustifiedTextSymbolIndex,r.centerJustifiedTextSymbolIndex,r.leftJustifiedTextSymbolIndex].forEach((e=>{e>=0&&(t.text.placedSymbolArray.get(e).hidden=i||x?1:0)})),r.verticalPlacedTextSymbolIndex>=0&&(t.text.placedSymbolArray.get(r.verticalPlacedTextSymbolIndex).hidden=i||v?1:0);const o=this.variableOffsets[r.crossTileID];o&&this.markUsedJustification(t,o.anchor,r,y);const a=this.placedOrientations[r.crossTileID];a&&(this.markUsedJustification(t,"left",r,a),this.markUsedOrientation(t,a,r))}if(g){const e=jd(l.icon),i=!(d&&r.verticalPlacedIconSymbolIndex&&x);r.placedIconSymbolIndex>=0&&(m(t.icon,r.numIconVertices,i?e:Vd),t.icon.placedSymbolArray.get(r.placedIconSymbolIndex).hidden=l.icon.isHidden()),r.verticalPlacedIconSymbolIndex>=0&&(m(t.icon,r.numVerticalIconVertices,i?Vd:e),t.icon.placedSymbolArray.get(r.verticalPlacedIconSymbolIndex).hidden=l.icon.isHidden())}const b=_&&_.has(e)?_.get(e):{text:null,icon:null};if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[e];if(i){let e=new c(0,0);if(i.textBox||i.verticalTextBox){let r=!0;if(h){const t=this.variableOffsets[a];t?(e=Ed(t.anchor,t.width,t.height,t.textOffset,t.textBoxScale),u&&e._rotate(p?-this.transform.bearingInRadians:this.transform.bearingInRadians)):r=!1}if(i.textBox||i.verticalTextBox){let n;i.textBox&&(n=x),i.verticalTextBox&&(n=v),zd(t.textCollisionBox.collisionVertexArray,l.text.placed,!r||n,b.text,e.x,e.y)}}if(i.iconBox||i.verticalIconBox){const r=Boolean(!v&&i.verticalIconBox);let n;i.iconBox&&(n=r),i.verticalIconBox&&(n=!r),zd(t.iconCollisionBox.collisionVertexArray,l.icon.placed,n,b.icon,d?e.x:0,d?e.y:0)}}}}if(t.sortFeatures(-this.transform.bearingInRadians),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.text.opacityVertexArray.length!==t.text.layoutVertexArray.length/4)throw new Error(`bucket.text.opacityVertexArray.length (= ${t.text.opacityVertexArray.length}) !== bucket.text.layoutVertexArray.length (= ${t.text.layoutVertexArray.length}) / 4`);if(t.icon.opacityVertexArray.length!==t.icon.layoutVertexArray.length/4)throw new Error(`bucket.icon.opacityVertexArray.length (= ${t.icon.opacityVertexArray.length}) !== bucket.icon.layoutVertexArray.length (= ${t.icon.layoutVertexArray.length}) / 4`);t.bucketInstanceId in this.collisionCircleArrays&&(t.collisionCircleArray=this.collisionCircleArrays[t.bucketInstanceId],delete this.collisionCircleArrays[t.bucketInstanceId])}symbolFadeChange(t){return 0===this.fadeDuration?1:(t-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(t){return Math.max(0,(this.transform.zoom-t)/1.5)}hasTransitions(t){return this.stale||t-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(t,e){const i=this.zoomAtLastRecencyCheck===e?1-this.zoomAdjustment(e):1;return this.zoomAtLastRecencyCheck=e,this.commitTime+this.fadeDuration*i>t}setStale(){this.stale=!0}}function zd(t,e,i,r,n,s){r&&0!==r.length||(r=[0,0,0,0]);const o=r[0]-vd,a=r[1]-vd,l=r[2]-vd,c=r[3]-vd;t.emplaceBack(e?1:0,i?1:0,n||0,s||0,o,a),t.emplaceBack(e?1:0,i?1:0,n||0,s||0,l,a),t.emplaceBack(e?1:0,i?1:0,n||0,s||0,l,c),t.emplaceBack(e?1:0,i?1:0,n||0,s||0,o,c)}const kd=Math.pow(2,25),Dd=Math.pow(2,24),Rd=Math.pow(2,17),Ld=Math.pow(2,16),Bd=Math.pow(2,9),Fd=Math.pow(2,8),Od=Math.pow(2,1);function jd(t){if(0===t.opacity&&!t.placed)return 0;if(1===t.opacity&&t.placed)return 4294967295;const e=t.placed?1:0,i=Math.floor(127*t.opacity);return i*kd+e*Dd+i*Rd+e*Ld+i*Bd+e*Fd+i*Od+e}const Vd=0;class Nd{constructor(t){this._sortAcrossTiles="viewport-y"!==t.layout.get("symbol-z-order")&&!t.layout.get("symbol-sort-key").isConstant(),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[]}continuePlacement(t,e,i,r,n){const s=this._bucketParts;for(;this._currentTileIndex<t.length;)if(e.getBucketParts(s,r,t[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,n())return!0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,s.sort(((t,e)=>t.sortKey-e.sortKey)));this._currentPartIndex<s.length;)if(e.placeLayerBucketPart(s[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,n())return!0;return!1}}class Ud{constructor(t,e,i,r,n,s,o,a){this.placement=new Ad(t,e,s,o,a),this._currentPlacementIndex=i.length-1,this._forceFullPlacement=r,this._showCollisionBoxes=n,this._done=!1}isDone(){return this._done}continuePlacement(t,e,i){const r=Wt.now(),n=()=>!this._forceFullPlacement&&Wt.now()-r>2;for(;this._currentPlacementIndex>=0;){const r=e[t[this._currentPlacementIndex]],s=this.placement.collisionIndex.transform.zoom;if("symbol"===r.type&&(!r.minzoom||r.minzoom<=s)&&(!r.maxzoom||r.maxzoom>s)){if(this._inProgressLayer||(this._inProgressLayer=new Nd(r)),this._inProgressLayer.continuePlacement(i[r.source],this.placement,this._showCollisionBoxes,r,n))return;delete this._inProgressLayer}this._currentPlacementIndex--}this._done=!0}commit(t){return this.placement.commit(t),this.placement}}const Zd=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class Gd{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[e,i]=new Uint8Array(t,0,2);if(219!==e)throw new Error("Data does not appear to be in a KDBush format.");const r=i>>4;if(1!==r)throw new Error(`Got v${r} data when expected v1.`);const n=Zd[15&i];if(!n)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(t,2,1),[o]=new Uint32Array(t,4,1);return new Gd(o,s,n,t)}constructor(t,e=64,i=Float64Array,r){if(isNaN(t)||t<0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+e,2),65535),this.ArrayType=i,this.IndexArrayType=t<65536?Uint16Array:Uint32Array;const n=Zd.indexOf(this.ArrayType),s=2*t*this.ArrayType.BYTES_PER_ELEMENT,o=t*this.IndexArrayType.BYTES_PER_ELEMENT,a=(8-o%8)%8;if(n<0)throw new Error(`Unexpected typed array class: ${i}.`);r&&r instanceof ArrayBuffer?(this.data=r,this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=2*t,this._finished=!0):(this.data=new ArrayBuffer(8+s+o+a),this.ids=new this.IndexArrayType(this.data,8,t),this.coords=new this.ArrayType(this.data,8+o+a,2*t),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+n]),new Uint16Array(this.data,2,1)[0]=e,new Uint32Array(this.data,4,1)[0]=t)}add(t,e){const i=this._pos>>1;return this.ids[i]=i,this.coords[this._pos++]=t,this.coords[this._pos++]=e,i}finish(){const t=this._pos>>1;if(t!==this.numItems)throw new Error(`Added ${t} items when expected ${this.numItems}.`);return $d(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(t,e,i,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:s,nodeSize:o}=this,a=[0,n.length-1,0],l=[];for(;a.length;){const c=a.pop()||0,h=a.pop()||0,u=a.pop()||0;if(h-u<=o){for(let o=u;o<=h;o++){const a=s[2*o],c=s[2*o+1];a>=t&&a<=i&&c>=e&&c<=r&&l.push(n[o])}continue}const p=u+h>>1,d=s[2*p],f=s[2*p+1];d>=t&&d<=i&&f>=e&&f<=r&&l.push(n[p]),(0===c?t<=d:e<=f)&&(a.push(u),a.push(p-1),a.push(1-c)),(0===c?i>=d:r>=f)&&(a.push(p+1),a.push(h),a.push(1-c))}return l}within(t,e,i){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:r,coords:n,nodeSize:s}=this,o=[0,r.length-1,0],a=[],l=i*i;for(;o.length;){const c=o.pop()||0,h=o.pop()||0,u=o.pop()||0;if(h-u<=s){for(let i=u;i<=h;i++)Xd(n[2*i],n[2*i+1],t,e)<=l&&a.push(r[i]);continue}const p=u+h>>1,d=n[2*p],f=n[2*p+1];Xd(d,f,t,e)<=l&&a.push(r[p]),(0===c?t-i<=d:e-i<=f)&&(o.push(u),o.push(p-1),o.push(1-c)),(0===c?t+i>=d:e+i>=f)&&(o.push(p+1),o.push(h),o.push(1-c))}return a}}function $d(t,e,i,r,n,s){if(n-r<=i)return;const o=r+n>>1;qd(t,e,o,r,n,s),$d(t,e,i,r,o-1,1-s),$d(t,e,i,o+1,n,1-s)}function qd(t,e,i,r,n,s){for(;n>r;){if(n-r>600){const o=n-r+1,a=i-r+1,l=Math.log(o),c=.5*Math.exp(2*l/3),h=.5*Math.sqrt(l*c*(o-c)/o)*(a-o/2<0?-1:1);qd(t,e,i,Math.max(r,Math.floor(i-a*c/o+h)),Math.min(n,Math.floor(i+(o-a)*c/o+h)),s)}const o=e[2*i+s];let a=r,l=n;for(Wd(t,e,r,i),e[2*n+s]>o&&Wd(t,e,r,n);a<l;){for(Wd(t,e,a,l),a++,l--;e[2*a+s]<o;)a++;for(;e[2*l+s]>o;)l--}e[2*r+s]===o?Wd(t,e,r,l):(l++,Wd(t,e,l,n)),l<=i&&(r=l+1),i<=l&&(n=l-1)}}function Wd(t,e,i,r){Hd(t,i,r),Hd(e,2*i,2*r),Hd(e,2*i+1,2*r+1)}function Hd(t,e,i){const r=t[e];t[e]=t[i],t[i]=r}function Xd(t,e,i,r){const n=t-i,s=e-r;return n*n+s*s}const Kd=512/J/2;class Yd{constructor(t,e,i){this.tileID=t,this.bucketInstanceId=i,this._symbolsByKey={};const r=new Map;for(let t=0;t<e.length;t++){const i=e.get(t),n=i.key,s=r.get(n);s?s.push(i):r.set(n,[i])}for(const[t,e]of r){const i={positions:e.map((t=>({x:Math.floor(t.anchorX*Kd),y:Math.floor(t.anchorY*Kd)}))),crossTileIDs:e.map((t=>t.crossTileID))};if(i.positions.length>128){const t=new Gd(i.positions.length,16,Uint16Array);for(const{x:e,y:r}of i.positions)t.add(e,r);t.finish(),delete i.positions,i.index=t}this._symbolsByKey[t]=i}}getScaledCoordinates(t,e){const{x:i,y:r,z:n}=this.tileID.canonical,{x:s,y:o,z:a}=e.canonical,l=Kd/Math.pow(2,a-n),c=(o*J+t.anchorY)*l,h=r*J*Kd;return{x:Math.floor((s*J+t.anchorX)*l-i*J*Kd),y:Math.floor(c-h)}}findMatches(t,e,i){const r=this.tileID.canonical.z<e.canonical.z?1:Math.pow(2,this.tileID.canonical.z-e.canonical.z);for(let n=0;n<t.length;n++){const s=t.get(n);if(s.crossTileID)continue;const o=this._symbolsByKey[s.key];if(!o)continue;const a=this.getScaledCoordinates(s,e);if(o.index){const t=o.index.range(a.x-r,a.y-r,a.x+r,a.y+r).sort();for(const e of t){const t=o.crossTileIDs[e];if(!i[t]){i[t]=!0,s.crossTileID=t;break}}}else if(o.positions)for(let t=0;t<o.positions.length;t++){const e=o.positions[t],n=o.crossTileIDs[t];if(Math.abs(e.x-a.x)<=r&&Math.abs(e.y-a.y)<=r&&!i[n]){i[n]=!0,s.crossTileID=n;break}}}}getCrossTileIDsLists(){return Object.values(this._symbolsByKey).map((({crossTileIDs:t})=>t))}}class Jd{constructor(){this.maxCrossTileID=0}generate(){return++this.maxCrossTileID}}class Qd{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0}handleWrapJump(t){const e=Math.round((t-this.lng)/360);if(0!==e)for(const t in this.indexes){const i=this.indexes[t],r={};for(const t in i){const n=i[t];n.tileID=n.tileID.unwrapTo(n.tileID.wrap+e),r[n.tileID.key]=n}this.indexes[t]=r}this.lng=t}addBucket(t,e,i){if(this.indexes[t.overscaledZ]&&this.indexes[t.overscaledZ][t.key]){if(this.indexes[t.overscaledZ][t.key].bucketInstanceId===e.bucketInstanceId)return!1;this.removeBucketCrossTileIDs(t.overscaledZ,this.indexes[t.overscaledZ][t.key])}for(let t=0;t<e.symbolInstances.length;t++)e.symbolInstances.get(t).crossTileID=0;this.usedCrossTileIDs[t.overscaledZ]||(this.usedCrossTileIDs[t.overscaledZ]={});const r=this.usedCrossTileIDs[t.overscaledZ];for(const i in this.indexes){const n=this.indexes[i];if(Number(i)>t.overscaledZ)for(const i in n){const s=n[i];s.tileID.isChildOf(t)&&s.findMatches(e.symbolInstances,t,r)}else{const s=n[t.scaledTo(Number(i)).key];s&&s.findMatches(e.symbolInstances,t,r)}}for(let t=0;t<e.symbolInstances.length;t++){const n=e.symbolInstances.get(t);n.crossTileID||(n.crossTileID=i.generate(),r[n.crossTileID]=!0)}return void 0===this.indexes[t.overscaledZ]&&(this.indexes[t.overscaledZ]={}),this.indexes[t.overscaledZ][t.key]=new Yd(t,e.symbolInstances,e.bucketInstanceId),!0}removeBucketCrossTileIDs(t,e){for(const i of e.getCrossTileIDsLists())for(const e of i)delete this.usedCrossTileIDs[t][e]}removeStaleBuckets(t){let e=!1;for(const i in this.indexes){const r=this.indexes[i];for(const n in r)t[r[n].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,r[n]),delete r[n],e=!0)}return e}}class tf{constructor(){this.layerIndexes={},this.crossTileIDs=new Jd,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={}}addLayer(t,e,i){let r=this.layerIndexes[t.id];void 0===r&&(r=this.layerIndexes[t.id]=new Qd);let n=!1;const s={};r.handleWrapJump(i);for(const i of e){const e=i.getBucket(t);e&&t.id===e.layerIds[0]&&(e.bucketInstanceId||(e.bucketInstanceId=++this.maxBucketInstanceId),r.addBucket(i.tileID,e,this.crossTileIDs)&&(n=!0),s[e.bucketInstanceId]=!0)}return r.removeStaleBuckets(s)&&(n=!0),n}pruneUnusedLayers(t){const e={};t.forEach((t=>{e[t]=!0}));for(const t in this.layerIndexes)e[t]||delete this.layerIndexes[t]}}var ef="void main() {fragColor=vec4(1.0);}";const rf={prelude:nf("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nout highp vec4 fragColor;","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(unpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}mat3 rotationMatrixFromAxisAngle(vec3 u,float angle) {float c=cos(angle);float s=sin(angle);float c2=1.0-c;return mat3(u.x*u.x*c2+      c,u.x*u.y*c2-u.z*s,u.x*u.z*c2+u.y*s,u.y*u.x*c2+u.z*s,u.y*u.y*c2+    c,u.y*u.z*c2-u.x*s,u.z*u.x*c2-u.y*s,u.z*u.y*c2+u.x*s,u.z*u.z*c2+    c\n);}\n#ifdef TERRAIN3D\nuniform sampler2D u_terrain;uniform float u_terrain_dim;uniform mat4 u_terrain_matrix;uniform vec4 u_terrain_unpack;uniform float u_terrain_exaggeration;uniform highp sampler2D u_depth;\n#endif\nconst highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitShifts=vec4(1.)/bitSh;highp float unpack(highp vec4 color) {return dot(color,bitShifts);}highp float depthOpacity(vec3 frag) {\n#ifdef TERRAIN3D\nhighp float d=unpack(texture(u_depth,frag.xy*0.5+0.5))+0.0001-frag.z;return 1.0-max(0.0,min(1.0,-d*500.0));\n#else\nreturn 1.0;\n#endif\n}float calculate_visibility(vec4 pos) {\n#ifdef TERRAIN3D\nvec3 frag=pos.xyz/pos.w;highp float d=depthOpacity(frag);if (d > 0.95) return 1.0;return (d+depthOpacity(frag+vec3(0.0,0.01,0.0)))/2.0;\n#else\nreturn 1.0;\n#endif\n}float ele(vec2 pos) {\n#ifdef TERRAIN3D\nvec4 rgb=(texture(u_terrain,pos)*255.0)*u_terrain_unpack;return rgb.r+rgb.g+rgb.b-u_terrain_unpack.a;\n#else\nreturn 0.0;\n#endif\n}float get_elevation(vec2 pos) {\n#ifdef TERRAIN3D\n#ifdef GLOBE\nif ((pos.y <-32767.5) || (pos.y > 32766.5)) {return 0.0;}\n#endif\nvec2 coord=(u_terrain_matrix*vec4(pos,0.0,1.0)).xy*u_terrain_dim+1.0;vec2 f=fract(coord);vec2 c=(floor(coord)+0.5)/(u_terrain_dim+2.0);float d=1.0/(u_terrain_dim+2.0);float tl=ele(c);float tr=ele(c+vec2(d,0.0));float bl=ele(c+vec2(0.0,d));float br=ele(c+vec2(d,d));float elevation=mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);return elevation*u_terrain_exaggeration;\n#else\nreturn 0.0;\n#endif\n}const float PI=3.141592653589793;uniform mat4 u_projection_matrix;"),projectionMercator:nf("","float projectLineThickness(float tileY) {return 1.0;}float projectCircleRadius(float tileY) {return 1.0;}vec4 projectTile(vec2 p) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);return result;}vec4 projectTile(vec2 p,vec2 rawPos) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);if (rawPos.y <-32767.5 || rawPos.y > 32766.5) {result.z=-10000000.0;}return result;}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_projection_matrix*vec4(posInTile,elevation,1.0);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {return projectTileWithElevation(posInTile,elevation);}"),projectionGlobe:nf("","#define GLOBE_RADIUS 6371008.8\nuniform highp vec4 u_projection_tile_mercator_coords;uniform highp vec4 u_projection_clipping_plane;uniform highp float u_projection_transition;uniform mat4 u_projection_fallback_matrix;vec3 globeRotateVector(vec3 vec,vec2 angles) {vec3 axisRight=vec3(vec.z,0.0,-vec.x);vec3 axisUp=cross(axisRight,vec);axisRight=normalize(axisRight);axisUp=normalize(axisUp);vec2 t=tan(angles);return normalize(vec+axisRight*t.x+axisUp*t.y);}mat3 globeGetRotationMatrix(vec3 spherePos) {vec3 axisRight=vec3(spherePos.z,0.0,-spherePos.x);vec3 axisDown=cross(axisRight,spherePos);axisRight=normalize(axisRight);axisDown=normalize(axisDown);return mat3(axisRight,axisDown,spherePos\n);}float circumferenceRatioAtTileY(float tileY) {float mercator_pos_y=u_projection_tile_mercator_coords.y+u_projection_tile_mercator_coords.w*tileY;float spherical_y=2.0*atan(exp(PI-(mercator_pos_y*PI*2.0)))-PI*0.5;return cos(spherical_y);}float projectLineThickness(float tileY) {float thickness=1.0/circumferenceRatioAtTileY(tileY); \nif (u_projection_transition < 0.999) {return mix(1.0,thickness,u_projection_transition);} else {return thickness;}}vec3 projectToSphere(vec2 translatedPos,vec2 rawPos) {vec2 mercator_pos=u_projection_tile_mercator_coords.xy+u_projection_tile_mercator_coords.zw*translatedPos;vec2 spherical;spherical.x=mercator_pos.x*PI*2.0+PI;spherical.y=2.0*atan(exp(PI-(mercator_pos.y*PI*2.0)))-PI*0.5;float len=cos(spherical.y);vec3 pos=vec3(sin(spherical.x)*len,sin(spherical.y),cos(spherical.x)*len\n);if (rawPos.y <-32767.5) {pos=vec3(0.0,1.0,0.0);}if (rawPos.y > 32766.5) {pos=vec3(0.0,-1.0,0.0);}return pos;}vec3 projectToSphere(vec2 posInTile) {return projectToSphere(posInTile,vec2(0.0,0.0));}float globeComputeClippingZ(vec3 spherePos) {return (1.0-(dot(spherePos,u_projection_clipping_plane.xyz)+u_projection_clipping_plane.w));}vec4 interpolateProjection(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);globePosition.z=globeComputeClippingZ(elevatedPos)*globePosition.w;if (u_projection_transition > 0.999) {return globePosition;}vec4 flatPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);const float z_globeness_threshold=0.2;vec4 result=globePosition;result.z=mix(0.0,globePosition.z,clamp((u_projection_transition-z_globeness_threshold)/(1.0-z_globeness_threshold),0.0,1.0));result.xyw=mix(flatPosition.xyw,globePosition.xyw,u_projection_transition);if ((posInTile.y <-32767.5) || (posInTile.y > 32766.5)) {result=globePosition;const float poles_hidden_anim_percentage=0.02;result.z=mix(globePosition.z,100.0,pow(max((1.0-u_projection_transition)/poles_hidden_anim_percentage,0.0),8.0));}return result;}vec4 interpolateProjectionFor3D(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);if (u_projection_transition > 0.999) {return globePosition;}vec4 fallbackPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);return mix(fallbackPosition,globePosition,u_projection_transition);}vec4 projectTile(vec2 posInTile) {return interpolateProjection(posInTile,projectToSphere(posInTile),0.0);}vec4 projectTile(vec2 posInTile,vec2 rawPos) {return interpolateProjection(posInTile,projectToSphere(posInTile,rawPos),0.0);}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return interpolateProjection(posInTile,projectToSphere(posInTile),elevation);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {vec3 spherePos=projectToSphere(posInTile,posInTile);return interpolateProjectionFor3D(posInTile,spherePos,elevation);}"),background:nf("uniform vec4 u_color;uniform float u_opacity;void main() {fragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),backgroundPattern:nf("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;void main() {gl_Position=projectTile(a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),circle:nf("in vec3 v_data;in float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);float antialiased_blur=v_data.z;float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(antialiased_blur,0.0,extrude_length-radius/(radius+stroke_width));fragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);const float epsilon=0.5/255.0;if (fragColor.r < epsilon && fragColor.g < epsilon && fragColor.b < epsilon && fragColor.a < epsilon) {discard;}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform bool u_scale_with_map;uniform bool u_pitch_with_map;uniform vec2 u_extrude_scale;uniform highp float u_globe_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;uniform vec2 u_translate;in vec2 a_pos;out vec3 v_data;out float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 pos_raw=a_pos+32768.0;vec2 extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);vec2 circle_center=floor(pos_raw/8.0)+u_translate;float ele=get_elevation(circle_center);v_visibility=calculate_visibility(projectTileWithElevation(circle_center,ele));if (u_pitch_with_map) {\n#ifdef GLOBE\nvec3 center_vector=projectToSphere(circle_center);\n#endif\nfloat angle_scale=u_globe_extrude_scale;vec2 corner_position=circle_center;if (u_scale_with_map) {angle_scale*=(radius+stroke_width);corner_position+=extrude*u_extrude_scale*(radius+stroke_width);} else {\n#ifdef GLOBE\nvec4 projected_center=interpolateProjection(circle_center,center_vector,ele);\n#else\nvec4 projected_center=projectTileWithElevation(circle_center,ele);\n#endif\ncorner_position+=extrude*u_extrude_scale*(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);angle_scale*=(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);}\n#ifdef GLOBE\nvec2 angles=extrude*angle_scale;vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(corner_position,corner_vector,ele);\n#else\ngl_Position=projectTileWithElevation(corner_position,ele);\n#endif\n} else {gl_Position=projectTileWithElevation(circle_center,ele);if (gl_Position.z/gl_Position.w > 1.0) {gl_Position.xy=vec2(10000.0);}if (u_scale_with_map) {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*u_camera_to_center_distance;} else {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*gl_Position.w;}}float antialiasblur=-max(1.0/u_device_pixel_ratio/(radius+stroke_width),blur);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),clippingMask:nf(ef,"in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),heatmap:nf("uniform highp float u_intensity;in vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);fragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;uniform highp float u_globe_extrude_scale;in vec2 a_pos;out vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 pos_raw=a_pos+32768.0;vec2 unscaled_extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 circle_center=floor(pos_raw/8.0);\n#ifdef GLOBE\nvec2 angles=v_extrude*radius*u_globe_extrude_scale;vec3 center_vector=projectToSphere(circle_center);vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(circle_center+extrude,corner_vector,0.0);\n#else\ngl_Position=projectTileFor3D(circle_center+extrude,get_elevation(circle_center));\n#endif\n}"),heatmapTexture:nf("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;in vec2 v_pos;void main() {float t=texture(u_image,v_pos).r;vec4 color=texture(u_color_ramp,vec2(t,0.5));fragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),collisionBox:nf("in float v_placed;in float v_notUsed;void main() {float alpha=0.5;fragColor=vec4(1.0,0.0,0.0,1.0)*alpha;if (v_placed > 0.5) {fragColor=vec4(0.0,0.0,1.0,0.5)*alpha;}if (v_notUsed > 0.5) {fragColor*=.1;}}","in vec2 a_anchor_pos;in vec2 a_placed;in vec2 a_box_real;uniform vec2 u_pixel_extrude_scale;out float v_placed;out float v_notUsed;void main() {gl_Position=projectTileWithElevation(a_anchor_pos,get_elevation(a_anchor_pos));gl_Position.xy=((a_box_real+0.5)*u_pixel_extrude_scale*2.0-1.0)*vec2(1.0,-1.0)*gl_Position.w;if (gl_Position.z/gl_Position.w < 1.1) {gl_Position.z=0.5;}v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:nf("in float v_radius;in vec2 v_extrude;in float v_collision;void main() {float alpha=0.5;float stroke_radius=0.9;float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);fragColor=color*alpha*opacity_t;}","in vec2 a_pos;in float a_radius;in vec2 a_flags;uniform vec2 u_viewport_size;out float v_radius;out vec2 v_extrude;out float v_collision;void main() {float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(mix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_collision=collision;gl_Position=vec4((a_pos/u_viewport_size*2.0-1.0)*vec2(1.0,-1.0),0.0,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),debug:nf("uniform highp vec4 u_color;uniform sampler2D u_overlay;in vec2 v_uv;void main() {vec4 overlay_color=texture(u_overlay,v_uv);fragColor=mix(u_color,overlay_color,overlay_color.a);}","in vec2 a_pos;out vec2 v_uv;uniform float u_overlay_scale;void main() {v_uv=a_pos/8192.0;gl_Position=projectTileWithElevation(a_pos*u_overlay_scale,get_elevation(a_pos));}"),depth:nf(ef,"in vec2 a_pos;void main() {\n#ifdef GLOBE\ngl_Position=projectTileFor3D(a_pos,0.0);\n#else\ngl_Position=u_projection_matrix*vec4(a_pos,0.0,1.0);\n#endif\n}"),fill:nf("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nfragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_fill_translate;in vec2 a_pos;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);}"),fillOutline:nf("in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=outline_color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillOutlinePattern:nf("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;in vec2 v_pos_a;in vec2 v_pos_b;in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillPattern:nf("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),fillExtrusion:nf("in vec4 v_color;void main() {fragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\nout vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 normal=a_normal_ed.xyz;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nfloat colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;vec3 normalForLighting=normal/16384.0;float directional=clamp(dot(normalForLighting,u_lightpos),0.0,1.0);\n#ifdef GLOBE\nmat3 rotMatrix=globeGetRotationMatrix(spherePos);normalForLighting=rotMatrix*normalForLighting;directional=mix(directional,clamp(dot(normalForLighting,u_lightpos_globe),0.0,1.0),u_projection_transition);\n#endif\ndirectional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),fillExtrusionPattern:nf("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;in vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);fragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\n#ifdef GLOBE\nout vec3 v_sphere_pos;\n#endif\nout vec2 v_pos_a;out vec2 v_pos_b;out vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 normal=a_normal_ed.xyz;float edgedistance=a_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);v_sphere_pos=elevatedPos;gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nvec2 pos=normal.x==1.0 && normal.y==0.0 && normal.z==16384.0\n? a_pos\n: vec2(edgedistance,elevation*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal/16383.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),hillshadePrepare:nf("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack)/4.0;}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2((c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c))/pow(2.0,exaggeration+(19.2562-u_zoom));fragColor=clamp(vec4(deriv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;in vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:nf("uniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;\n#define PI 3.141592653589793\nvoid main() {vec4 pixel=texture(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);fragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);v_pos=a_pos/8192.0;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),line:nf("uniform lowp float u_device_pixel_ratio;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp float v_linesofar;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;v_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*2.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),lineGradient:nf("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;in highp vec2 v_uv;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture(u_image,v_uv);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;in float a_uv_x;in float a_split_index;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec2 v_uv;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),linePattern:nf("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;in vec2 v_normal;in vec2 v_width2;in float v_linesofar;in float v_gamma_scale;in float v_width;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture(u_image,pos_a),texture(u_image,pos_b),u_fade);fragColor=color*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_linesofar;out float v_gamma_scale;out float v_width;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),lineSDF:nf("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform float u_sdfgamma;uniform float u_mix;in vec2 v_normal;in vec2 v_width2;in vec2 v_tex_a;in vec2 v_tex_b;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture(u_image,v_tex_a).a;float sdfdist_b=texture(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);alpha*=smoothstep(0.5-u_sdfgamma/floorwidth,0.5+u_sdfgamma/floorwidth,sdfdist);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_patternscale_a;uniform float u_tex_y_a;uniform vec2 u_patternscale_b;uniform float u_tex_y_b;uniform vec2 u_units_to_pixels;out vec2 v_normal;out vec2 v_width2;out vec2 v_tex_a;out vec2 v_tex_b;out float v_gamma_scale;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_tex_a=vec2(a_linesofar*u_patternscale_a.x/floorwidth,normal.y*u_patternscale_a.y+u_tex_y_a);v_tex_b=vec2(a_linesofar*u_patternscale_b.x/floorwidth,normal.y*u_patternscale_b.y+u_tex_y_b);v_width2=vec2(outset,inset);}"),raster:nf("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;in vec2 v_pos0;in vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture(u_image0,v_pos0);vec4 color1=texture(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(dot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);fragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;uniform vec4 u_coords_top;uniform vec4 u_coords_bottom;in vec2 a_pos;out vec2 v_pos0;out vec2 v_pos1;void main() {vec2 fractionalPos=a_pos/8192.0;vec2 position=mix(mix(u_coords_top.xy,u_coords_top.zw,fractionalPos.x),mix(u_coords_bottom.xy,u_coords_bottom.zw,fractionalPos.x),fractionalPos.y);gl_Position=projectTile(position,position);v_pos0=((fractionalPos-0.5)/u_buffer_scale)+0.5;\n#ifdef GLOBE\nif (a_pos.y <-32767.5) {v_pos0.y=0.0;}if (a_pos.y > 32766.5) {v_pos0.y=1.0;}\n#endif\nv_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),symbolIcon:nf("uniform sampler2D u_texture;in vec2 v_tex;in float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;fragColor=texture(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_tex;out float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}gl_Position=finalPos;v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float visibility=calculate_visibility(projectedPoint);v_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));}"),symbolSDF:nf("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;in vec2 v_data0;in vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float inner_edge=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);inner_edge=inner_edge+gamma*gamma_scale;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(inner_edge-gamma_scaled,inner_edge+gamma_scaled,dist);if (u_is_halo) {lowp float halo_edge=(6.0-halo_width/fontScale)/SDF_PX;alpha=min(smoothstep(halo_edge-gamma_scaled,halo_edge+gamma_scaled,dist),1.0-alpha);}fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_data0;out vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),symbolTextAndIcon:nf("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;in vec4 v_data0;in vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;fragColor=texture(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec4 v_data0;out vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map && !u_is_along_line) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),terrain:nf("uniform sampler2D u_texture;uniform vec4 u_fog_color;uniform vec4 u_horizon_color;uniform float u_fog_ground_blend;uniform float u_fog_ground_blend_opacity;uniform float u_horizon_fog_blend;uniform bool u_is_globe_mode;in vec2 v_texture_pos;in float v_fog_depth;const float gamma=2.2;vec4 gammaToLinear(vec4 color) {return pow(color,vec4(gamma));}vec4 linearToGamma(vec4 color) {return pow(color,vec4(1.0/gamma));}void main() {vec4 surface_color=texture(u_texture,vec2(v_texture_pos.x,1.0-v_texture_pos.y));if (!u_is_globe_mode && v_fog_depth > u_fog_ground_blend) {vec4 surface_color_linear=gammaToLinear(surface_color);float blend_color=smoothstep(0.0,1.0,max((v_fog_depth-u_horizon_fog_blend)/(1.0-u_horizon_fog_blend),0.0));vec4 fog_horizon_color_linear=mix(gammaToLinear(u_fog_color),gammaToLinear(u_horizon_color),blend_color);float factor_fog=max(v_fog_depth-u_fog_ground_blend,0.0)/(1.0-u_fog_ground_blend);fragColor=linearToGamma(mix(surface_color_linear,fog_horizon_color_linear,pow(factor_fog,2.0)*u_fog_ground_blend_opacity));} else {fragColor=surface_color;}}","in vec3 a_pos3d;uniform mat4 u_fog_matrix;uniform float u_ele_delta;out vec2 v_texture_pos;out float v_fog_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,get_elevation(a_pos3d.xy)-ele_delta);vec4 pos=u_fog_matrix*vec4(a_pos3d.xy,ele,1.0);v_fog_depth=pos.z/pos.w*0.5+0.5;}"),terrainDepth:nf("in float v_depth;const highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitMsk=vec4(0.,vec3(1./256.0));highp vec4 pack(highp float value) {highp vec4 comp=fract(value*bitSh);comp-=comp.xxyz*bitMsk;return comp;}void main() {fragColor=pack(v_depth);}","in vec3 a_pos3d;uniform float u_ele_delta;out float v_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);v_depth=gl_Position.z/gl_Position.w;}"),terrainCoords:nf("precision mediump float;uniform sampler2D u_texture;uniform float u_terrain_coords_id;in vec2 v_texture_pos;void main() {vec4 rgba=texture(u_texture,v_texture_pos);fragColor=vec4(rgba.r,rgba.g,rgba.b,u_terrain_coords_id);}","in vec3 a_pos3d;uniform float u_ele_delta;out vec2 v_texture_pos;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);}"),projectionErrorMeasurement:nf("in vec4 v_output_error_encoded;void main() {fragColor=v_output_error_encoded;}","in vec2 a_pos;uniform highp float u_input;uniform highp float u_output_expected;out vec4 v_output_error_encoded;void main() {float real_output=2.0*atan(exp(PI-(u_input*PI*2.0)))-PI*0.5;float error=real_output-u_output_expected;float abs_error=abs(error)*128.0;v_output_error_encoded.x=min(floor(abs_error*256.0),255.0)/255.0;abs_error-=v_output_error_encoded.x;v_output_error_encoded.y=min(floor(abs_error*65536.0),255.0)/255.0;abs_error-=v_output_error_encoded.x/255.0;v_output_error_encoded.z=min(floor(abs_error*16777216.0),255.0)/255.0;v_output_error_encoded.w=error >=0.0 ? 1.0 : 0.0;gl_Position=vec4(a_pos,0.0,1.0);}"),atmosphere:nf("in vec3 view_direction;uniform vec3 u_sun_pos;uniform vec3 u_globe_position;uniform float u_globe_radius;uniform float u_atmosphere_blend;/**Shader use from https:*Made some change to adapt to MapLibre Globe geometry*/const float PI=3.141592653589793;const int iSteps=5;const int jSteps=3;/*radius of the planet*/const float EARTH_RADIUS=6371e3;/*radius of the atmosphere*/const float ATMOS_RADIUS=6471e3;vec2 rsi(vec3 r0,vec3 rd,float sr) {float a=dot(rd,rd);float b=2.0*dot(rd,r0);float c=dot(r0,r0)-(sr*sr);float d=(b*b)-4.0*a*c;if (d < 0.0) return vec2(1e5,-1e5);return vec2((-b-sqrt(d))/(2.0*a),(-b+sqrt(d))/(2.0*a));}vec4 atmosphere(vec3 r,vec3 r0,vec3 pSun,float iSun,float rPlanet,float rAtmos,vec3 kRlh,float kMie,float shRlh,float shMie,float g) {pSun=normalize(pSun);r=normalize(r);vec2 p=rsi(r0,r,rAtmos);if (p.x > p.y) {return vec4(0.0,0.0,0.0,1.0);}if (p.x < 0.0) {p.x=0.0;}vec3 pos=r0+r*p.x;vec2 p2=rsi(r0,r,rPlanet);if (p2.x <=p2.y && p2.x > 0.0) {p.y=min(p.y,p2.x);}float iStepSize=(p.y-p.x)/float(iSteps);float iTime=p.x+iStepSize*0.5;vec3 totalRlh=vec3(0,0,0);vec3 totalMie=vec3(0,0,0);float iOdRlh=0.0;float iOdMie=0.0;float mu=dot(r,pSun);float mumu=mu*mu;float gg=g*g;float pRlh=3.0/(16.0*PI)*(1.0+mumu);float pMie=3.0/(8.0*PI)*((1.0-gg)*(mumu+1.0))/(pow(1.0+gg-2.0*mu*g,1.5)*(2.0+gg));for (int i=0; i < iSteps; i++) {vec3 iPos=r0+r*iTime;float iHeight=length(iPos)-rPlanet;float odStepRlh=exp(-iHeight/shRlh)*iStepSize;float odStepMie=exp(-iHeight/shMie)*iStepSize;iOdRlh+=odStepRlh;iOdMie+=odStepMie;float jStepSize=rsi(iPos,pSun,rAtmos).y/float(jSteps);float jTime=jStepSize*0.5;float jOdRlh=0.0;float jOdMie=0.0;for (int j=0; j < jSteps; j++) {vec3 jPos=iPos+pSun*jTime;float jHeight=length(jPos)-rPlanet;jOdRlh+=exp(-jHeight/shRlh)*jStepSize;jOdMie+=exp(-jHeight/shMie)*jStepSize;jTime+=jStepSize;}vec3 attn=exp(-(kMie*(iOdMie+jOdMie)+kRlh*(iOdRlh+jOdRlh)));totalRlh+=odStepRlh*attn;totalMie+=odStepMie*attn;iTime+=iStepSize;}float opacity=exp(-(length(kRlh)*length(totalRlh)+kMie*length(totalMie)));vec3 color=iSun*(pRlh*kRlh*totalRlh+pMie*kMie*totalMie);return vec4(color,opacity);}void main() {vec3 scale_camera_pos=-u_globe_position*EARTH_RADIUS/u_globe_radius;vec4 color=atmosphere(normalize(view_direction),scale_camera_pos,u_sun_pos,22.0,EARTH_RADIUS,ATMOS_RADIUS,vec3(5.5e-6,13.0e-6,22.4e-6),21e-6,8e3,1.2e3,0.758\n);color.rgb=1.0-exp(-1.0*color.rgb);color=pow(color,vec4(1.0/2.2));fragColor=vec4(color.rgb,1.0-color.a)*u_atmosphere_blend;}","in vec2 a_pos;uniform mat4 u_inv_proj_matrix;out vec3 view_direction;void main() {view_direction=(u_inv_proj_matrix*vec4(a_pos,0.0,1.0)).xyz;gl_Position=vec4(a_pos,0.0,1.0);}"),sky:nf("uniform vec4 u_sky_color;uniform vec4 u_horizon_color;uniform vec2 u_horizon;uniform vec2 u_horizon_normal;uniform float u_sky_horizon_blend;uniform float u_sky_blend;void main() {float x=gl_FragCoord.x;float y=gl_FragCoord.y;float blend=(y-u_horizon.y)*u_horizon_normal.y+(x-u_horizon.x)*u_horizon_normal.x;if (blend > 0.0) {if (blend < u_sky_horizon_blend) {fragColor=mix(u_sky_color,u_horizon_color,pow(1.0-blend/u_sky_horizon_blend,2.0));} else {fragColor=u_sky_color;}}fragColor=mix(fragColor,vec4(vec3(0.0),0.0),u_sky_blend);}","in vec2 a_pos;void main() {gl_Position=vec4(a_pos,1.0,1.0);}")};function nf(t,e){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,r=e.match(/in ([\w]+) ([\w]+)/g),n=t.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),s=e.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),o=s?s.concat(n):n,a={};return{fragmentSource:t=t.replace(i,((t,e,i,r,n)=>(a[n]=!0,"define"===e?`\n#ifndef HAS_UNIFORM_u_${n}\nin ${i} ${r} ${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = u_${n};\n#endif\n`))),vertexSource:e=e.replace(i,((t,e,i,r,n)=>{const s="float"===r?"vec2":"vec4",o=n.match(/color/)?"color":s;return a[n]?"define"===e?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nin ${i} ${s} a_${n};\nout ${i} ${r} ${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"vec4"===o?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = a_${n};\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = unpack_mix_${o}(a_${n}, u_${n}_t);\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:"define"===e?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nin ${i} ${s} a_${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"vec4"===o?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = a_${n};\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = unpack_mix_${o}(a_${n}, u_${n}_t);\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`})),staticAttributes:r,staticUniforms:o}}class sf{constructor(t,e,i){this.vertexBuffer=t,this.indexBuffer=e,this.segments=i}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.vertexBuffer=null,this.indexBuffer=null,this.segments=null}}var of=zo([{name:"a_pos",type:"Int16",components:2}]);const af="#define PROJECTION_MERCATOR",lf="mercator";class cf{constructor(){this._cachedMesh=null}get name(){return"mercator"}get useSubdivision(){return!1}get shaderVariantName(){return lf}get shaderDefine(){return af}get shaderPreludeCode(){return rf.projectionMercator}get vertexShaderPreludeCode(){return rf.projectionMercator.vertexSource}get subdivisionGranularity(){return zc.noSubdivision}get useGlobeControls(){return!1}get transitionState(){return 0}get latitudeErrorCorrectionRadians(){return 0}destroy(){}updateGPUdependent(t){}getMeshFromTileID(t,e,i,r,n){if(this._cachedMesh)return this._cachedMesh;const s=new fa;s.emplaceBack(0,0),s.emplaceBack(J,0),s.emplaceBack(0,J),s.emplaceBack(J,J);const o=t.createVertexBuffer(s,of.members),a=La.simpleSegment(0,0,4,2),l=new Aa;l.emplaceBack(1,0,2),l.emplaceBack(1,2,3);const c=t.createIndexBuffer(l);return this._cachedMesh=new sf(o,c,a),this._cachedMesh}recalculate(){}hasTransition(){return!1}setErrorQueryLatitudeDegrees(t){}}function hf(t,e){const i=gt(e.lat,-85.051129,Ut);return new c(hp(e.lng)*t,up(i)*t)}function uf(t,e){return new mp(e.x/t,e.y/t).toLngLat()}function pf(t){return t.cameraToCenterDistance*Math.min(.85*Math.tan(Ft(90-t.pitch)),Math.tan(Ft(89.25-t.pitch)))}function df(t,e){const i=t.canonical,r=e/Tt(i.z),n=i.x+Math.pow(2,i.z)*t.wrap,s=b(new Float64Array(16));return P(s,s,[n*r,i.y*r,0]),M(s,s,[r/J,r/J,1]),s}function ff(t,e,i,r,n){const s=mp.fromLngLat(t,e),o=n*pp(1,t.lat),a=o*Math.cos(Ft(i)),l=Math.sqrt(o*o-a*a),c=l*Math.sin(Ft(-r)),h=l*Math.cos(Ft(-r));return new mp(s.x+c,s.y+h,s.z+a)}class mf{constructor(t=0,e=0,i=0,r=0){if(isNaN(t)||t<0||isNaN(e)||e<0||isNaN(i)||i<0||isNaN(r)||r<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=t,this.bottom=e,this.left=i,this.right=r}interpolate(t,e,i){return null!=e.top&&null!=t.top&&(this.top=ar.number(t.top,e.top,i)),null!=e.bottom&&null!=t.bottom&&(this.bottom=ar.number(t.bottom,e.bottom,i)),null!=e.left&&null!=t.left&&(this.left=ar.number(t.left,e.left,i)),null!=e.right&&null!=t.right&&(this.right=ar.number(t.right,e.right,i)),this}getCenter(t,e){const i=gt((this.left+t-this.right)/2,0,t),r=gt((this.top+e-this.bottom)/2,0,e);return new c(i,r)}equals(t){return this.top===t.top&&this.bottom===t.bottom&&this.left===t.left&&this.right===t.right}clone(){return new mf(this.top,this.bottom,this.left,this.right)}toJSON(){return{top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function _f(t,e){if(!t.renderWorldCopies||t.lngRange)return;const i=e.lng-t.center.lng;e.lng+=i>180?-360:i<-180?360:0}function gf(t){return Math.max(0,Math.floor(t))}class yf{constructor(t,e,i,r,n,s){this._callbacks=t,this._tileSize=512,this._renderWorldCopies=void 0===s||!!s,this._minZoom=e||0,this._maxZoom=i||22,this._minPitch=null==r?0:r,this._maxPitch=null==n?60:n,this.setMaxBounds(),this._width=0,this._height=0,this._center=new op(0,0),this._elevation=0,this._zoom=0,this._tileZoom=gf(this._zoom),this._scale=Tt(this._zoom),this._bearingInRadians=0,this._fovInRadians=.6435011087932844,this._pitchInRadians=0,this._rollInRadians=0,this._unmodified=!0,this._edgeInsets=new mf,this._minElevationForCurrentTile=0,this._autoCalculateNearFarZ=!0}apply(t,e,i){this._latRange=t.latRange,this._lngRange=t.lngRange,this._width=t.width,this._height=t.height,this._center=t.center,this._elevation=t.elevation,this._minElevationForCurrentTile=t.minElevationForCurrentTile,this._zoom=t.zoom,this._tileZoom=gf(this._zoom),this._scale=Tt(this._zoom),this._bearingInRadians=t.bearingInRadians,this._fovInRadians=t.fovInRadians,this._pitchInRadians=t.pitchInRadians,this._rollInRadians=t.rollInRadians,this._unmodified=t.unmodified,this._edgeInsets=new mf(t.padding.top,t.padding.bottom,t.padding.left,t.padding.right),this._minZoom=t.minZoom,this._maxZoom=t.maxZoom,this._minPitch=t.minPitch,this._maxPitch=t.maxPitch,this._renderWorldCopies=t.renderWorldCopies,this._cameraToCenterDistance=t.cameraToCenterDistance,this._nearZ=t.nearZ,this._farZ=t.farZ,this._autoCalculateNearFarZ=!i&&t.autoCalculateNearFarZ,e&&this._constrain(),this._calcMatrices()}get pixelsToClipSpaceMatrix(){return this._pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._clipSpaceToPixelsMatrix}get minElevationForCurrentTile(){return this._minElevationForCurrentTile}setMinElevationForCurrentTile(t){this._minElevationForCurrentTile=t}get tileSize(){return this._tileSize}get tileZoom(){return this._tileZoom}get scale(){return this._scale}get width(){return this._width}get height(){return this._height}get bearingInRadians(){return this._bearingInRadians}get lngRange(){return this._lngRange}get latRange(){return this._latRange}get pixelsToGLUnits(){return this._pixelsToGLUnits}get minZoom(){return this._minZoom}setMinZoom(t){this._minZoom!==t&&(this._minZoom=t,this.setZoom(this.getConstrained(this._center,this.zoom).zoom))}get maxZoom(){return this._maxZoom}setMaxZoom(t){this._maxZoom!==t&&(this._maxZoom=t,this.setZoom(this.getConstrained(this._center,this.zoom).zoom))}get minPitch(){return this._minPitch}setMinPitch(t){this._minPitch!==t&&(this._minPitch=t,this.setPitch(Math.max(this.pitch,t)))}get maxPitch(){return this._maxPitch}setMaxPitch(t){this._maxPitch!==t&&(this._maxPitch=t,this.setPitch(Math.min(this.pitch,t)))}get renderWorldCopies(){return this._renderWorldCopies}setRenderWorldCopies(t){void 0===t?t=!0:null===t&&(t=!1),this._renderWorldCopies=t}get worldSize(){return this._tileSize*this._scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new c(this._width,this._height)}get bearing(){return this._bearingInRadians/Math.PI*180}setBearing(t){const e=yt(t,-180,180)*Math.PI/180;var i,r,n,s,o,a,l,c,h;this._bearingInRadians!==e&&(this._unmodified=!1,this._bearingInRadians=e,this._calcMatrices(),this._rotationMatrix=g(),i=this._rotationMatrix,n=-this._bearingInRadians,s=(r=this._rotationMatrix)[0],o=r[1],a=r[2],l=r[3],c=Math.sin(n),h=Math.cos(n),i[0]=s*h+a*c,i[1]=o*h+l*c,i[2]=s*-c+a*h,i[3]=o*-c+l*h)}get rotationMatrix(){return this._rotationMatrix}get pitchInRadians(){return this._pitchInRadians}get pitch(){return this._pitchInRadians/Math.PI*180}setPitch(t){const e=gt(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitchInRadians!==e&&(this._unmodified=!1,this._pitchInRadians=e,this._calcMatrices())}get rollInRadians(){return this._rollInRadians}get roll(){return this._rollInRadians/Math.PI*180}setRoll(t){const e=t/180*Math.PI;this._rollInRadians!==e&&(this._unmodified=!1,this._rollInRadians=e,this._calcMatrices())}get fovInRadians(){return this._fovInRadians}get fov(){return Ot(this._fovInRadians)}setFov(t){t=gt(t,.1,150),this.fov!==t&&(this._unmodified=!1,this._fovInRadians=Ft(t),this._calcMatrices())}get zoom(){return this._zoom}setZoom(t){const e=this.getConstrained(this._center,t).zoom;this._zoom!==e&&(this._unmodified=!1,this._zoom=e,this._tileZoom=Math.max(0,Math.floor(e)),this._scale=Tt(e),this._constrain(),this._calcMatrices())}get center(){return this._center}setCenter(t){t.lat===this._center.lat&&t.lng===this._center.lng||(this._unmodified=!1,this._center=t,this._constrain(),this._calcMatrices())}get elevation(){return this._elevation}setElevation(t){t!==this._elevation&&(this._elevation=t,this._constrain(),this._calcMatrices())}get padding(){return this._edgeInsets.toJSON()}setPadding(t){this._edgeInsets.equals(t)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,t,1),this._calcMatrices())}get centerPoint(){return this._edgeInsets.getCenter(this._width,this._height)}get pixelsPerMeter(){return this._pixelPerMeter}get unmodified(){return this._unmodified}get cameraToCenterDistance(){return this._cameraToCenterDistance}get nearZ(){return this._nearZ}get farZ(){return this._farZ}get autoCalculateNearFarZ(){return this._autoCalculateNearFarZ}overrideNearFarZ(t,e){this._autoCalculateNearFarZ=!1,this._nearZ=t,this._farZ=e,this._calcMatrices()}clearNearFarZOverride(){this._autoCalculateNearFarZ=!0,this._calcMatrices()}isPaddingEqual(t){return this._edgeInsets.equals(t)}interpolatePadding(t,e,i){this._unmodified=!1,this._edgeInsets.interpolate(t,e,i),this._constrain(),this._calcMatrices()}resize(t,e,i=!0){this._width=t,this._height=e,i&&this._constrain(),this._calcMatrices()}getMaxBounds(){return this._latRange&&2===this._latRange.length&&this._lngRange&&2===this._lngRange.length?new ap([this._lngRange[0],this._latRange[0]],[this._lngRange[1],this._latRange[1]]):null}setMaxBounds(t){t?(this._lngRange=[t.getWest(),t.getEast()],this._latRange=[t.getSouth(),t.getNorth()],this._constrain()):(this._lngRange=null,this._latRange=[-85.051129,Ut])}getConstrained(t,e){return this._callbacks.getConstrained(t,e)}getCameraQueryGeometry(t,e){if(1===e.length)return[e[0],t];{let i=t.x,r=t.y,n=t.x,s=t.y;for(const t of e)i=Math.min(i,t.x),r=Math.min(r,t.y),n=Math.max(n,t.x),s=Math.max(s,t.y);return[new c(i,r),new c(n,r),new c(n,s),new c(i,s),new c(i,r)]}}_constrain(){if(!this.center||!this._width||!this._height||this._constraining)return;this._constraining=!0;const t=this._unmodified,{center:e,zoom:i}=this.getConstrained(this.center,this.zoom);this.setCenter(e),this.setZoom(i),this._unmodified=t,this._constraining=!1}_calcMatrices(){if(this._width&&this._height){this._pixelsToGLUnits=[2/this._width,-2/this._height];let t=b(new Float64Array(16));M(t,t,[this._width/2,-this._height/2,1]),P(t,t,[1,-1,0]),this._clipSpaceToPixelsMatrix=t,t=b(new Float64Array(16)),M(t,t,[1,-1,1]),P(t,t,[-1,-1,0]),M(t,t,[2/this._width,2/this._height,1]),this._pixelsToClipSpaceMatrix=t,this._cameraToCenterDistance=.5/Math.tan(this.fovInRadians/2)*this._height}this._callbacks.calcMatrices()}calculateCenterFromCameraLngLatAlt(t,e,i,r){const n=void 0!==i?i:this.bearing,s=r=void 0!==r?r:this.pitch,o=mp.fromLngLat(t,e),a=-Math.cos(Ft(s)),l=Math.sin(Ft(s)),c=l*Math.sin(Ft(n)),h=-l*Math.cos(Ft(n));let u=this.elevation;const p=e-u;let d;a*p>=0||Math.abs(a)<.1?(d=1e4,u=e+d*a):d=-p/a;let f,m,_=fp(1,o.y),g=0;do{if(g+=1,g>10)break;m=d/_,f=new mp(o.x+c*m,o.y+h*m),_=1/f.meterInMercatorCoordinateUnits()}while(Math.abs(d-m*_)>1e-12);return{center:f.toLngLat(),elevation:u,zoom:Pt(this.height/2/Math.tan(this.fovInRadians/2)/m/this.tileSize)}}recalculateZoomAndCenter(t){if(this.elevation-t==0)return;const e=pp(1,this.center.lat)*this.worldSize,i=this.cameraToCenterDistance/e,r=mp.fromLngLat(this.center,this.elevation),n=ff(this.center,this.elevation,this.pitch,this.bearing,i);this._elevation=t;const s=this.calculateCenterFromCameraLngLatAlt(n.toLngLat(),fp(n.z,r.y),this.bearing,this.pitch);this._elevation=s.elevation,this._center=s.center,this.setZoom(s.zoom)}getCameraPoint(){const t=Math.tan(this.pitchInRadians)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new c(t*Math.sin(this.rollInRadians),t*Math.cos(this.rollInRadians)))}getCameraAltitude(){return Math.cos(this.pitchInRadians)*this._cameraToCenterDistance/this._pixelPerMeter+this.elevation}getCameraLngLat(){const t=pp(1,this.center.lat)*this.worldSize;return ff(this.center,this.elevation,this.pitch,this.bearing,this.cameraToCenterDistance/t).toLngLat()}getMercatorTileCoordinates(t){if(!t)return[0,0,1,1];const e=t.canonical.z>=0?1<<t.canonical.z:Math.pow(2,t.canonical.z);return[t.canonical.x/e,t.canonical.y/e,1/e/J,1/e/J]}}class xf{constructor(t,e){this.min=t,this.max=e,this.center=L([],R([],this.min,this.max),.5)}quadrant(t){const e=[t%2==0,t<2],i=k(this.min),r=k(this.max);for(let t=0;t<e.length;t++)i[t]=e[t]?this.min[t]:this.center[t],r[t]=e[t]?this.center[t]:this.max[t];return r[2]=this.max[2],new xf(i,r)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}intersectsFrustum(t){let e=!0;for(let i=0;i<t.planes.length;i++){const r=this.intersectsPlane(t.planes[i]);if(0===r)return 0;1===r&&(e=!1)}return e?2:t.aabb.min[0]>this.max[0]||t.aabb.min[1]>this.max[1]||t.aabb.min[2]>this.max[2]||t.aabb.max[0]<this.min[0]||t.aabb.max[1]<this.min[1]||t.aabb.max[2]<this.min[2]?0:1}intersectsPlane(t){let e=t[3],i=t[3];for(let r=0;r<3;r++)t[r]>0?(e+=t[r]*this.min[r],i+=t[r]*this.max[r]):(i+=t[r]*this.min[r],e+=t[r]*this.max[r]);return e>=0?2:i<0?0:1}}class vf{distanceToTile2d(t,e,i,r){const n=r.distanceX([t,e]),s=r.distanceY([t,e]);return Math.hypot(n,s)}getWrap(t,e,i){return i}getTileAABB(t,e,i,r){var n,s;let o=i,a=i;if(r.terrain){const l=new wp(t.z,e,t.z,t.x,t.y),c=r.terrain.getMinMaxElevation(l);o=null!==(n=c.minElevation)&&void 0!==n?n:i,a=null!==(s=c.maxElevation)&&void 0!==s?s:i}const l=1<<t.z;return new xf([e+t.x/l,t.y/l,o],[e+(t.x+1)/l,(t.y+1)/l,a])}allowVariableZoom(t,e){const i=gt(78.5-t.fov*(Math.abs(Math.cos(t.rollInRadians))*t.height+Math.abs(Math.sin(t.rollInRadians))*t.width)/t.height/2,0,60);return!!e.terrain||t.pitch>i}allowWorldCopies(){return!0}recalculateCache(){}}class bf{constructor(t,e,i){this.points=t,this.planes=e,this.aabb=i}static fromInvProjectionMatrix(t,e=1,i=0){const r=Math.pow(2,i),n=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((i=>{const n=1/(i=G([],i,t))[3]/e*r;return function(t,e,i){return t[0]=e[0]*i[0],t[1]=e[1]*i[1],t[2]=e[2]*i[2],t[3]=e[3]*i[3],t}(i,i,[n,n,1/i[3],n])})),s=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((t=>{const e=B([],O([],Z([],n[t[0]],n[t[1]]),Z([],n[t[2]],n[t[1]]))),i=-F(e,n[t[1]]);return e.concat(i)})),o=[Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY],a=[Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY];for(const t of n)for(let e=0;e<3;e++)o[e]=Math.min(o[e],t[e]),a[e]=Math.max(a[e],t[e]);return new bf(n,s,new xf(o,a))}}class wf{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(t){this._helper.setMinZoom(t)}setMaxZoom(t){this._helper.setMaxZoom(t)}setMinPitch(t){this._helper.setMinPitch(t)}setMaxPitch(t){this._helper.setMaxPitch(t)}setRenderWorldCopies(t){this._helper.setRenderWorldCopies(t)}setBearing(t){this._helper.setBearing(t)}setPitch(t){this._helper.setPitch(t)}setRoll(t){this._helper.setRoll(t)}setFov(t){this._helper.setFov(t)}setZoom(t){this._helper.setZoom(t)}setCenter(t){this._helper.setCenter(t)}setElevation(t){this._helper.setElevation(t)}setMinElevationForCurrentTile(t){this._helper.setMinElevationForCurrentTile(t)}setPadding(t){this._helper.setPadding(t)}interpolatePadding(t,e,i){return this._helper.interpolatePadding(t,e,i)}isPaddingEqual(t){return this._helper.isPaddingEqual(t)}resize(t,e,i=!0){this._helper.resize(t,e,i)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(t){this._helper.setMaxBounds(t)}overrideNearFarZ(t,e){this._helper.overrideNearFarZ(t,e)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(t){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),t)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(t,e){}constructor(t,e,i,r,n){this._posMatrixCache=new Map,this._alignedPosMatrixCache=new Map,this._fogMatrixCacheF32=new Map,this._helper=new yf({calcMatrices:()=>{this._calcMatrices()},getConstrained:(t,e)=>this.getConstrained(t,e)},t,e,i,r,n),this._coveringTilesDetailsProvider=new vf}clone(){const t=new wf;return t.apply(this),t}apply(t,e,i){this._helper.apply(t,e,i)}get cameraPosition(){return this._cameraPosition}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._viewProjMatrix}get inverseProjectionMatrix(){return this._invProjMatrix}get mercatorMatrix(){return this._mercatorMatrix}getVisibleUnwrappedCoordinates(t){const e=[new bp(0,t)];if(this._helper._renderWorldCopies){const i=this.screenPointToMercatorCoordinate(new c(0,0)),r=this.screenPointToMercatorCoordinate(new c(this._helper._width,0)),n=this.screenPointToMercatorCoordinate(new c(this._helper._width,this._helper._height)),s=this.screenPointToMercatorCoordinate(new c(0,this._helper._height)),o=Math.floor(Math.min(i.x,r.x,n.x,s.x)),a=Math.floor(Math.max(i.x,r.x,n.x,s.x)),l=1;for(let i=o-l;i<=a+l;i++)0!==i&&e.push(new bp(i,t))}return e}getCameraFrustum(){return bf.fromInvProjectionMatrix(this._invViewProjMatrix,this.worldSize)}getClippingPlane(){return null}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(t){const e=this.screenPointToLocation(this.centerPoint,t),i=t?t.getElevationForLngLatZoom(e,this._helper._tileZoom):0;this._helper.recalculateZoomAndCenter(i)}setLocationAtPoint(t,e){const i=pp(this.elevation,this.center.lat),r=this.screenPointToMercatorCoordinateAtZ(e,i),n=this.screenPointToMercatorCoordinateAtZ(this.centerPoint,i),s=mp.fromLngLat(t),o=new mp(s.x-(r.x-n.x),s.y-(r.y-n.y));this.setCenter(null==o?void 0:o.toLngLat()),this._helper._renderWorldCopies&&this.setCenter(this.center.wrap())}locationToScreenPoint(t,e){return e?this.coordinatePoint(mp.fromLngLat(t),e.getElevationForLngLatZoom(t,this._helper._tileZoom),this._pixelMatrix3D):this.coordinatePoint(mp.fromLngLat(t))}screenPointToLocation(t,e){var i;return null===(i=this.screenPointToMercatorCoordinate(t,e))||void 0===i?void 0:i.toLngLat()}screenPointToMercatorCoordinate(t,e){if(e){const i=e.pointCoordinate(t);if(null!=i)return i}return this.screenPointToMercatorCoordinateAtZ(t)}screenPointToMercatorCoordinateAtZ(t,e){const i=e||0,r=[t.x,t.y,0,1],n=[t.x,t.y,1,1];G(r,r,this._pixelMatrixInverse),G(n,n,this._pixelMatrixInverse);const s=r[3],o=n[3],a=r[1]/s,l=n[1]/o,c=r[2]/s,h=n[2]/o,u=c===h?0:(i-c)/(h-c);return new mp(ar.number(r[0]/s,n[0]/o,u)/this.worldSize,ar.number(a,l,u)/this.worldSize,i)}coordinatePoint(t,e=0,i=this._pixelMatrix){const r=[t.x*this.worldSize,t.y*this.worldSize,e,1];return G(r,r,i),new c(r[0]/r[3],r[1]/r[3])}getBounds(){const t=Math.max(0,this._helper._height/2-pf(this));return(new ap).extend(this.screenPointToLocation(new c(0,t))).extend(this.screenPointToLocation(new c(this._helper._width,t))).extend(this.screenPointToLocation(new c(this._helper._width,this._helper._height))).extend(this.screenPointToLocation(new c(0,this._helper._height)))}isPointOnMapSurface(t,e){return e?null!=e.pointCoordinate(t):t.y>this.height/2-pf(this)}calculatePosMatrix(t,e=!1,i){var r;const n=null!==(r=t.key)&&void 0!==r?r:Tp(t.wrap,t.canonical.z,t.canonical.z,t.canonical.x,t.canonical.y),s=e?this._alignedPosMatrixCache:this._posMatrixCache;if(s.has(n)){const t=s.get(n);return i?t.f32:t.f64}const o=df(t,this.worldSize);T(o,e?this._alignedProjMatrix:this._viewProjMatrix,o);const a={f64:o,f32:new Float32Array(o)};return s.set(n,a),i?a.f32:a.f64}calculateFogMatrix(t){const e=t.key,i=this._fogMatrixCacheF32;if(i.has(e))return i.get(e);const r=df(t,this.worldSize);return T(r,this._fogMatrix,r),i.set(e,new Float32Array(r)),i.get(e)}getConstrained(t,e){e=gt(+e,this.minZoom,this.maxZoom);const i={center:new op(t.lng,t.lat),zoom:e};let r=this._helper._lngRange;this._helper._renderWorldCopies||null!==r||(r=[-179.9999999999,180-1e-10]);const n=this.tileSize*Tt(i.zoom);let s=0,o=n,a=0,l=n,h=0,u=0;const{x:p,y:d}=this.size;if(this._helper._latRange){const t=this._helper._latRange;s=up(t[1])*n,o=up(t[0])*n,o-s<d&&(h=d/(o-s))}r&&(a=yt(hp(r[0])*n,0,n),l=yt(hp(r[1])*n,0,n),l<a&&(l+=n),l-a<p&&(u=p/(l-a)));const{x:f,y:m}=hf(n,t);let _,g;const y=Math.max(u||0,h||0);if(y){const t=new c(u?(l+a)/2:f,h?(o+s)/2:m);return i.center=uf(n,t).wrap(),i.zoom+=Pt(y),i}if(this._helper._latRange){const t=d/2;m-t<s&&(g=s+t),m+t>o&&(g=o-t)}if(r){const t=(a+l)/2;let e=f;this._helper._renderWorldCopies&&(e=yt(f,t-n/2,t+n/2));const i=p/2;e-i<a&&(_=a+i),e+i>l&&(_=l-i)}if(void 0!==_||void 0!==g){const t=new c(null!=_?_:f,null!=g?g:m);i.center=uf(n,t).wrap()}return i}calculateCenterFromCameraLngLatAlt(t,e,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(t,e,i,r)}_calculateNearFarZIfNeeded(t,e,i){if(!this._helper.autoCalculateNearFarZ)return;const r=Math.min(this.elevation,this.minElevationForCurrentTile,this.getCameraAltitude()-100),n=t-r*this._helper._pixelPerMeter/Math.cos(e),s=r<0?n:t,o=Math.PI/2+this.pitchInRadians,a=Ft(this.fov)*(Math.abs(Math.cos(Ft(this.roll)))*this.height+Math.abs(Math.sin(Ft(this.roll)))*this.width)/this.height*(.5+i.y/this.height),l=Math.sin(a)*s/Math.sin(gt(Math.PI-o-a,.01,Math.PI-.01)),c=pf(this),h=Math.atan(c/this._helper.cameraToCenterDistance),u=Ft(.75),p=h>u?2*h*(.5+i.y/(2*c)):u,d=Math.sin(p)*s/Math.sin(gt(Math.PI-o-p,.01,Math.PI-.01)),f=Math.min(l,d);this._helper._farZ=1.01*(Math.cos(Math.PI/2-e)*f+s),this._helper._nearZ=this._helper._height/50}_calcMatrices(){if(!this._helper._height)return;const t=this.centerOffset,e=hf(this.worldSize,this.center),i=e.x,r=e.y;this._helper._pixelPerMeter=pp(1,this.center.lat)*this.worldSize;const n=Ft(Math.min(this.pitch,89.25)),s=Math.max(this._helper.cameraToCenterDistance/2,this._helper.cameraToCenterDistance+this._helper._elevation*this._helper._pixelPerMeter/Math.cos(n));let o;this._calculateNearFarZIfNeeded(s,n,t),o=new Float64Array(16),E(o,this.fovInRadians,this._helper._width/this._helper._height,this._helper._nearZ,this._helper._farZ),this._invProjMatrix=new Float64Array(16),w(this._invProjMatrix,o),o[8]=2*-t.x/this._helper._width,o[9]=2*t.y/this._helper._height,this._projectionMatrix=v(o),M(o,o,[1,-1,1]),P(o,o,[0,0,-this._helper.cameraToCenterDistance]),S(o,o,-this.rollInRadians),C(o,o,this.pitchInRadians),S(o,o,-this.bearingInRadians),P(o,o,[-i,-r,0]),this._mercatorMatrix=M([],o,[this.worldSize,this.worldSize,this.worldSize]),M(o,o,[1,1,this._helper._pixelPerMeter]),this._pixelMatrix=T(new Float64Array(16),this.clipSpaceToPixelsMatrix,o),P(o,o,[0,0,-this.elevation]),this._viewProjMatrix=o,this._invViewProjMatrix=w([],o);const a=[0,0,-1,1];G(a,a,this._invViewProjMatrix),this._cameraPosition=[a[0]/a[3],a[1]/a[3],a[2]/a[3]],this._fogMatrix=new Float64Array(16),E(this._fogMatrix,this.fovInRadians,this.width/this.height,s,this._helper._farZ),this._fogMatrix[8]=2*-t.x/this.width,this._fogMatrix[9]=2*t.y/this.height,M(this._fogMatrix,this._fogMatrix,[1,-1,1]),P(this._fogMatrix,this._fogMatrix,[0,0,-this.cameraToCenterDistance]),S(this._fogMatrix,this._fogMatrix,-this.rollInRadians),C(this._fogMatrix,this._fogMatrix,this.pitchInRadians),S(this._fogMatrix,this._fogMatrix,-this.bearingInRadians),P(this._fogMatrix,this._fogMatrix,[-i,-r,0]),M(this._fogMatrix,this._fogMatrix,[1,1,this._helper._pixelPerMeter]),P(this._fogMatrix,this._fogMatrix,[0,0,-this.elevation]),this._pixelMatrix3D=T(new Float64Array(16),this.clipSpaceToPixelsMatrix,o);const l=this._helper._width%2/2,c=this._helper._height%2/2,h=Math.cos(this.bearingInRadians),u=Math.sin(-this.bearingInRadians),p=i-Math.round(i)+h*l+u*c,d=r-Math.round(r)+h*c+u*l,f=new Float64Array(o);if(P(f,f,[p>.5?p-1:p,d>.5?d-1:d,0]),this._alignedProjMatrix=f,o=w(new Float64Array(16),this._pixelMatrix),!o)throw new Error("failed to invert matrix");this._pixelMatrixInverse=o,this._clearMatrixCaches()}_clearMatrixCaches(){this._posMatrixCache.clear(),this._alignedPosMatrixCache.clear(),this._fogMatrixCacheF32.clear()}maxPitchScaleFactor(){if(!this._pixelMatrixInverse)return 1;const t=this.screenPointToMercatorCoordinate(new c(0,0)),e=[t.x*this.worldSize,t.y*this.worldSize,0,1];return G(e,e,this._pixelMatrix)[3]/this._helper.cameraToCenterDistance}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){const t=pp(1,this.center.lat)*this.worldSize;return ff(this.center,this.elevation,this.pitch,this.bearing,this._helper.cameraToCenterDistance/t).toLngLat()}lngLatToCameraDepth(t,e){const i=mp.fromLngLat(t),r=[i.x*this.worldSize,i.y*this.worldSize,e,1];return G(r,r,this._viewProjMatrix),r[2]/r[3]}getProjectionData(t){const{overscaledTileID:e,aligned:i,applyTerrainMatrix:r}=t,n=this._helper.getMercatorTileCoordinates(e),s=e?this.calculatePosMatrix(e,i,!0):null;let o;return o=e&&e.terrainRttPosMatrix32f&&r?e.terrainRttPosMatrix32f:s||nt(),{mainMatrix:o,tileMercatorCoords:n,clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:o}}isLocationOccluded(t){return!1}getPixelScale(){return 1}getCircleRadiusCorrection(){return 1}getPitchedTextCorrection(t,e,i){return 1}transformLightDirection(t){return k(t)}getRayDirectionFromPixel(t){throw new Error("Not implemented.")}projectTileCoordinates(t,e,i,r){const n=this.calculatePosMatrix(i);let s;r?(s=[t,e,r(t,e),1],G(s,s,n)):(s=[t,e,0,1],xd(s,s,n));const o=s[3];return{point:new c(s[0]/o,s[1]/o),signedDistanceFromCamera:o,isOccluded:!1}}populateCache(t){for(const e of t)this.calculatePosMatrix(e)}getMatrixForModel(t,e){const i=mp.fromLngLat(t,e),r=i.meterInMercatorCoordinateUnits(),n=rt();return P(n,n,[i.x,i.y,i.z]),S(n,n,Math.PI),C(n,n,Math.PI/2),M(n,n,[-r,r,r]),n}getProjectionDataForCustomLayer(t=!0){const e=new wp(0,0,0,0,0),i=this.getProjectionData({overscaledTileID:e,applyGlobeMatrix:t}),r=df(e,this.worldSize);T(r,this._viewProjMatrix,r),i.tileMercatorCoords=[0,0,1,1];const n=[J,J,this.worldSize/this._helper.pixelsPerMeter],s=it();return M(s,r,n),i.fallbackMatrix=s,i.mainMatrix=s,i}getFastPathSimpleProjectionMatrix(t){return this.calculatePosMatrix(t)}}function Tf(){At("Map cannot fit within canvas with the given bounds, padding, and/or offset.")}function Pf(t){if(t.useSlerp)if(t.k<1){const e=Nt(t.startEulerAngles.roll,t.startEulerAngles.pitch,t.startEulerAngles.bearing),i=Nt(t.endEulerAngles.roll,t.endEulerAngles.pitch,t.endEulerAngles.bearing),r=new Float64Array(4);!function(t,e,i,r){var n,s,o,a,l,c=e[0],h=e[1],u=e[2],p=e[3],d=i[0],f=i[1],_=i[2],g=i[3];(s=c*d+h*f+u*_+p*g)<0&&(s=-s,d=-d,f=-f,_=-_,g=-g),1-s>m?(n=Math.acos(s),o=Math.sin(n),a=Math.sin((1-r)*n)/o,l=Math.sin(r*n)/o):(a=1-r,l=r),t[0]=a*c+l*d,t[1]=a*h+l*f,t[2]=a*u+l*_,t[3]=a*p+l*g}(r,e,i,t.k);const n=function(t){const e=new Float64Array(9);var i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y,x;u=(n=(r=t)[0])*(l=n+n),p=(s=r[1])*l,f=(o=r[2])*l,m=o*(c=s+s),g=(a=r[3])*l,y=a*c,x=a*(h=o+o),(i=e)[0]=1-(d=s*c)-(_=o*h),i[3]=p-x,i[6]=f+y,i[1]=p+x,i[4]=1-u-_,i[7]=m-g,i[2]=f-y,i[5]=m+g,i[8]=1-u-d;const v=Ot(-Math.asin(gt(e[2],-1,1)));let b,w;return Math.hypot(e[5],e[8])<.001?(b=0,w=-Ot(Math.atan2(e[3],e[4]))):(b=Ot(0===e[5]&&0===e[8]?0:Math.atan2(e[5],e[8])),w=Ot(0===e[1]&&0===e[0]?0:Math.atan2(e[1],e[0]))),{roll:b,pitch:v+90,bearing:w}}(r);t.tr.setRoll(n.roll),t.tr.setPitch(n.pitch),t.tr.setBearing(n.bearing)}else t.tr.setRoll(t.endEulerAngles.roll),t.tr.setPitch(t.endEulerAngles.pitch),t.tr.setBearing(t.endEulerAngles.bearing);else t.tr.setRoll(ar.number(t.startEulerAngles.roll,t.endEulerAngles.roll,t.k)),t.tr.setPitch(ar.number(t.startEulerAngles.pitch,t.endEulerAngles.pitch,t.k)),t.tr.setBearing(ar.number(t.startEulerAngles.bearing,t.endEulerAngles.bearing,t.k))}function Mf(t,e,i,r,n){const s=n.padding,o=hf(n.worldSize,i.getNorthWest()),a=hf(n.worldSize,i.getNorthEast()),l=hf(n.worldSize,i.getSouthEast()),h=hf(n.worldSize,i.getSouthWest()),u=Ft(-r),p=o.rotate(u),d=a.rotate(u),f=l.rotate(u),m=h.rotate(u),_=new c(Math.max(p.x,d.x,m.x,f.x),Math.max(p.y,d.y,m.y,f.y)),g=new c(Math.min(p.x,d.x,m.x,f.x),Math.min(p.y,d.y,m.y,f.y)),y=_.sub(g),x=(n.width-(s.left+s.right+e.left+e.right))/y.x,v=(n.height-(s.top+s.bottom+e.top+e.bottom))/y.y;if(v<0||x<0)return void Tf();const b=Math.min(Pt(n.scale*Math.min(x,v)),t.maxZoom),w=c.convert(t.offset),T=new c((e.left-e.right)/2,(e.top-e.bottom)/2).rotate(Ft(r)),P=w.add(T).mult(n.scale/Tt(b));return{center:uf(n.worldSize,o.add(l).div(2).sub(P)),zoom:b,bearing:r}}class Cf{get useGlobeControls(){return!1}handlePanInertia(t,e){return{easingOffset:t,easingCenter:e.center}}handleMapControlsRollPitchBearingZoom(t,e){t.bearingDelta&&e.setBearing(e.bearing+t.bearingDelta),t.pitchDelta&&e.setPitch(e.pitch+t.pitchDelta),t.rollDelta&&e.setRoll(e.roll+t.rollDelta),t.zoomDelta&&e.setZoom(e.zoom+t.zoomDelta)}handleMapControlsPan(t,e,i){t.around.distSqr(e.centerPoint)<.01||e.setLocationAtPoint(i,t.around)}cameraForBoxAndBearing(t,e,i,r,n){return Mf(t,e,i,r,n)}handleJumpToCenterZoom(t,e){t.zoom!==(void 0!==e.zoom?+e.zoom:t.zoom)&&t.setZoom(+e.zoom),void 0!==e.center&&t.setCenter(op.convert(e.center))}handleEaseTo(t,e){const i=t.zoom,r=t.padding,n={roll:t.roll,pitch:t.pitch,bearing:t.bearing},s={roll:void 0===e.roll?t.roll:e.roll,pitch:void 0===e.pitch?t.pitch:e.pitch,bearing:void 0===e.bearing?t.bearing:e.bearing},o=void 0!==e.zoom,a=!t.isPaddingEqual(e.padding);let l=!1;const c=o?+e.zoom:t.zoom;let h=t.centerPoint.add(e.offsetAsPoint);const u=t.screenPointToLocation(h),{center:p,zoom:d}=t.getConstrained(op.convert(e.center||u),null!=c?c:i);_f(t,p);const f=hf(t.worldSize,u),m=hf(t.worldSize,p).sub(f),_=Tt(d-i);return l=d!==i,{easeFunc:o=>{if(l&&t.setZoom(ar.number(i,d,o)),jt(n,s)||Pf({startEulerAngles:n,endEulerAngles:s,tr:t,k:o,useSlerp:n.roll!=s.roll}),a&&(t.interpolatePadding(r,e.padding,o),h=t.centerPoint.add(e.offsetAsPoint)),e.around)t.setLocationAtPoint(e.around,e.aroundPoint);else{const e=Tt(t.zoom-i),r=d>i?Math.min(2,_):Math.max(.5,_),n=Math.pow(r,1-o),s=uf(t.worldSize,f.add(m.mult(o*n)).mult(e));t.setLocationAtPoint(t.renderWorldCopies?s.wrap():s,h)}},isZooming:l,elevationCenter:p}}handleFlyTo(t,e){const i=void 0!==e.zoom,r=t.zoom,n=t.getConstrained(op.convert(e.center||e.locationAtOffset),i?+e.zoom:r),s=n.center,o=n.zoom;_f(t,s);const a=hf(t.worldSize,e.locationAtOffset),l=hf(t.worldSize,s).sub(a),c=l.mag(),h=Tt(o-r);let u;if(void 0!==e.minZoom){const i=Math.min(+e.minZoom,r,o);u=Tt(t.getConstrained(s,i).zoom-r)}return{easeFunc:(e,i,n,c)=>{t.setZoom(1===e?o:r+Pt(i));const h=1===e?s:uf(t.worldSize,a.add(l.mult(n)).mult(i));t.setLocationAtPoint(t.renderWorldCopies?h.wrap():h,c)},scaleOfZoom:h,targetCenter:s,scaleOfMinZoom:u,pixelPathLength:c}}}class If{constructor(t,e,i){this.blendFunction=t,this.blendColor=e,this.mask=i}}If.Replace=[1,0],If.disabled=new If(If.Replace,bi.transparent,[!1,!1,!1,!1]),If.unblended=new If(If.Replace,bi.transparent,[!0,!0,!0,!0]),If.alphaBlended=new If([1,771],bi.transparent,[!0,!0,!0,!0]);const Sf=2305;class Ef{constructor(t,e,i){this.enable=t,this.mode=e,this.frontFace=i}}Ef.disabled=new Ef(!1,1029,Sf),Ef.backCCW=new Ef(!0,1029,Sf),Ef.frontCCW=new Ef(!0,1028,Sf);class Af{constructor(t,e,i){this.func=t,this.mask=e,this.range=i}}Af.ReadOnly=!1,Af.ReadWrite=!0,Af.disabled=new Af(519,Af.ReadOnly,[0,1]);const zf=7680;class kf{constructor(t,e,i,r,n,s){this.test=t,this.ref=e,this.mask=i,this.fail=r,this.depthFail=n,this.pass=s}}kf.disabled=new kf({func:519,mask:0},0,0,zf,zf,zf);const Df=new WeakMap;function Rf(t){var e;if(Df.has(t))return Df.get(t);{const i=null===(e=t.getParameter(t.VERSION))||void 0===e?void 0:e.startsWith("WebGL 2.0");return Df.set(t,i),i}}class Lf{get awaitingQuery(){return!!this._readbackQueue}constructor(t){this._readbackWaitFrames=4,this._measureWaitFrames=6,this._texWidth=1,this._texHeight=1,this._measuredError=0,this._updateCount=0,this._lastReadbackFrame=-1e3,this._readbackQueue=null,this._cachedRenderContext=t;const e=t.context,i=e.gl;this._texFormat=i.RGBA,this._texType=i.UNSIGNED_BYTE;const r=new fa;r.emplaceBack(-1,-1),r.emplaceBack(2,-1),r.emplaceBack(-1,2);const n=new Aa;n.emplaceBack(0,1,2),this._fullscreenTriangle=new sf(e.createVertexBuffer(r,of.members),e.createIndexBuffer(n),La.simpleSegment(0,0,r.length,n.length)),this._resultBuffer=new Uint8Array(4),e.activeTexture.set(i.TEXTURE1);const s=i.createTexture();i.bindTexture(i.TEXTURE_2D,s),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,i.CLAMP_TO_EDGE),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,i.CLAMP_TO_EDGE),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,i.NEAREST),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,i.NEAREST),i.texImage2D(i.TEXTURE_2D,0,this._texFormat,this._texWidth,this._texHeight,0,this._texFormat,this._texType,null),this._fbo=e.createFramebuffer(this._texWidth,this._texHeight,!1,!1),this._fbo.colorAttachment.set(s),Rf(i)&&(this._pbo=i.createBuffer(),i.bindBuffer(i.PIXEL_PACK_BUFFER,this._pbo),i.bufferData(i.PIXEL_PACK_BUFFER,4,i.STREAM_READ),i.bindBuffer(i.PIXEL_PACK_BUFFER,null))}destroy(){const t=this._cachedRenderContext.context.gl;this._fullscreenTriangle.destroy(),this._fbo.destroy(),t.deleteBuffer(this._pbo),this._fullscreenTriangle=null,this._fbo=null,this._pbo=null,this._resultBuffer=null}updateErrorLoop(t,e){const i=this._updateCount;return this._readbackQueue?i>=this._readbackQueue.frameNumberIssued+this._readbackWaitFrames&&this._tryReadback():i>=this._lastReadbackFrame+this._measureWaitFrames&&this._renderErrorTexture(t,e),this._updateCount++,this._measuredError}_bindFramebuffer(){const t=this._cachedRenderContext.context,e=t.gl;t.activeTexture.set(e.TEXTURE1),e.bindTexture(e.TEXTURE_2D,this._fbo.colorAttachment.get()),t.bindFramebuffer.set(this._fbo.framebuffer)}_renderErrorTexture(t,e){const i=this._cachedRenderContext.context,r=i.gl;if(this._bindFramebuffer(),i.viewport.set([0,0,this._texWidth,this._texHeight]),i.clear({color:bi.transparent}),this._cachedRenderContext.useProgram("projectionErrorMeasurement").draw(i,r.TRIANGLES,Af.disabled,kf.disabled,If.unblended,Ef.disabled,((t,e)=>({u_input:t,u_output_expected:e}))(t,e),null,null,"$clipping",this._fullscreenTriangle.vertexBuffer,this._fullscreenTriangle.indexBuffer,this._fullscreenTriangle.segments),this._pbo&&Rf(r)){r.bindBuffer(r.PIXEL_PACK_BUFFER,this._pbo),r.readBuffer(r.COLOR_ATTACHMENT0),r.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,0),r.bindBuffer(r.PIXEL_PACK_BUFFER,null);const t=r.fenceSync(r.SYNC_GPU_COMMANDS_COMPLETE,0);r.flush(),this._readbackQueue={frameNumberIssued:this._updateCount,sync:t}}else this._readbackQueue={frameNumberIssued:this._updateCount,sync:null}}_tryReadback(){const t=this._cachedRenderContext.context.gl;if(this._pbo&&this._readbackQueue&&Rf(t)){const e=t.clientWaitSync(this._readbackQueue.sync,0,0);if(e===t.WAIT_FAILED)return At("WebGL2 clientWaitSync failed."),this._readbackQueue=null,void(this._lastReadbackFrame=this._updateCount);if(e===t.TIMEOUT_EXPIRED)return;t.bindBuffer(t.PIXEL_PACK_BUFFER,this._pbo),t.getBufferSubData(t.PIXEL_PACK_BUFFER,0,this._resultBuffer,0,4),t.bindBuffer(t.PIXEL_PACK_BUFFER,null)}else this._bindFramebuffer(),t.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,this._resultBuffer);this._readbackQueue=null,this._measuredError=Lf._parseRGBA8float(this._resultBuffer),this._lastReadbackFrame=this._updateCount}static _parseRGBA8float(t){let e=0;return e+=t[0]/256,e+=t[1]/65536,e+=t[2]/16777216,t[3]<127&&(e=-e),e/128}}const Bf=J/128;function Ff(t,e){const i=void 0!==t.granularity?Math.max(t.granularity,1):1,r=i+(t.generateBorders?2:0),n=i+(t.extendToNorthPole||t.generateBorders?1:0)+(t.extendToSouthPole||t.generateBorders?1:0),s=r+1,o=n+1,a=t.generateBorders?-1:0,l=t.generateBorders||t.extendToNorthPole?-1:0,c=i+(t.generateBorders?1:0),h=i+(t.generateBorders||t.extendToSouthPole?1:0),u=s*o,p=r*n*6,d=s*o>65536;if(d&&"16bit"===e)throw new Error("Granularity is too large and meshes would not fit inside 16 bit vertex indices.");const f=d||"32bit"===e,m=new Int16Array(2*u);let _=0;for(let e=l;e<=h;e++)for(let r=a;r<=c;r++){let n=r/i*J;-1===r&&(n=-64),r===i+1&&(n=J+Bf);let s=e/i*J;-1===e&&(s=t.extendToNorthPole?kc:-64),e===i+1&&(s=t.extendToSouthPole?Dc:J+Bf),m[_++]=n,m[_++]=s}const g=f?new Uint32Array(p):new Uint16Array(p);let y=0;for(let t=0;t<n;t++)for(let e=0;e<r;e++){const i=e+1+t*s,r=e+(t+1)*s,n=e+1+(t+1)*s;g[y++]=e+t*s,g[y++]=r,g[y++]=i,g[y++]=i,g[y++]=r,g[y++]=n}return{vertices:m.buffer.slice(0),indices:g.buffer.slice(0),uses32bitIndices:f}}const Of=new zc({fill:new Ac(128,2),line:new Ac(512,0),tile:new Ac(128,32),stencil:new Ac(128,1),circle:3});class jf{constructor(){this._tileMeshCache={},this._errorCorrectionUsable=0,this._errorMeasurementLastValue=0,this._errorCorrectionPreviousValue=0,this._errorMeasurementLastChangeTime=-1e3}get name(){return"vertical-perspective"}get transitionState(){return 1}get useSubdivision(){return!0}get shaderVariantName(){return"globe"}get shaderDefine(){return"#define GLOBE"}get shaderPreludeCode(){return rf.projectionGlobe}get vertexShaderPreludeCode(){return rf.projectionMercator.vertexSource}get subdivisionGranularity(){return Of}get useGlobeControls(){return!0}get latitudeErrorCorrectionRadians(){return this._errorCorrectionUsable}destroy(){this._errorMeasurement&&this._errorMeasurement.destroy()}updateGPUdependent(t){this._errorMeasurement||(this._errorMeasurement=new Lf(t));const e=up(this._errorQueryLatitudeDegrees),i=2*Math.atan(Math.exp(Math.PI-e*Math.PI*2))-.5*Math.PI,r=this._errorMeasurement.updateErrorLoop(e,i),n=Wt.now();r!==this._errorMeasurementLastValue&&(this._errorCorrectionPreviousValue=this._errorCorrectionUsable,this._errorMeasurementLastValue=r,this._errorMeasurementLastChangeTime=n);const s=Math.min(Math.max((n-this._errorMeasurementLastChangeTime)/1e3/.5,0),1);this._errorCorrectionUsable=pt(this._errorCorrectionPreviousValue,-this._errorMeasurementLastValue,ft(s))}_getMeshKey(t){return`${t.granularity.toString(36)}_${t.generateBorders?"b":""}${t.extendToNorthPole?"n":""}${t.extendToSouthPole?"s":""}`}getMeshFromTileID(t,e,i,r,n){const s=("stencil"===n?Of.stencil:Of.tile).getGranularityForZoomLevel(e.z);return this._getMesh(t,{granularity:s,generateBorders:i,extendToNorthPole:0===e.y&&r,extendToSouthPole:e.y===(1<<e.z)-1&&r})}_getMesh(t,e){const i=this._getMeshKey(e);if(i in this._tileMeshCache)return this._tileMeshCache[i];const r=function(t,e){const i=Ff(e,"16bit"),r=fa.deserialize({arrayBuffer:i.vertices,length:i.vertices.byteLength/2/2}),n=Aa.deserialize({arrayBuffer:i.indices,length:i.indices.byteLength/2/3});return new sf(t.createVertexBuffer(r,of.members),t.createIndexBuffer(n),La.simpleSegment(0,0,r.length,n.length))}(t,e);return this._tileMeshCache[i]=r,r}recalculate(t){}hasTransition(){const t=Wt.now();let e=!1;return e=e||(t-this._errorMeasurementLastChangeTime)/1e3<.7,e=e||this._errorMeasurement&&this._errorMeasurement.awaitingQuery,e}setErrorQueryLatitudeDegrees(t){this._errorQueryLatitudeDegrees=t}}const Vf=new Mo({type:new vo(_e.projection.type)});class Nf extends me{constructor(t){super(),this._transitionable=new fo(Vf),this.setProjection(t),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new ho(0)),this._mercatorProjection=new cf,this._verticalPerspectiveProjection=new jf}get transitionState(){const t=this.properties.get("type");if("string"==typeof t&&"mercator"===t)return 0;if("string"==typeof t&&"vertical-perspective"===t)return 1;if(t instanceof zi){if("vertical-perspective"===t.from&&"mercator"===t.to)return 1-t.transition;if("mercator"===t.from&&"vertical-perspective"===t.to)return t.transition}return 1}get useGlobeRendering(){return this.transitionState>0}get latitudeErrorCorrectionRadians(){return this._verticalPerspectiveProjection.latitudeErrorCorrectionRadians}get currentProjection(){return this.useGlobeRendering?this._verticalPerspectiveProjection:this._mercatorProjection}get name(){return"globe"}get useSubdivision(){return this.currentProjection.useSubdivision}get shaderVariantName(){return this.currentProjection.shaderVariantName}get shaderDefine(){return this.currentProjection.shaderDefine}get shaderPreludeCode(){return this.currentProjection.shaderPreludeCode}get vertexShaderPreludeCode(){return this.currentProjection.vertexShaderPreludeCode}get subdivisionGranularity(){return this.currentProjection.subdivisionGranularity}get useGlobeControls(){return this.transitionState>0}destroy(){this._mercatorProjection.destroy(),this._verticalPerspectiveProjection.destroy()}updateGPUdependent(t){this._mercatorProjection.updateGPUdependent(t),this._verticalPerspectiveProjection.updateGPUdependent(t)}getMeshFromTileID(t,e,i,r,n){return this.currentProjection.getMeshFromTileID(t,e,i,r,n)}setProjection(t){this._transitionable.setValue("type",(null==t?void 0:t.type)||"mercator")}updateTransitions(t){this._transitioning=this._transitionable.transitioned(t,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()||this.currentProjection.hasTransition()}recalculate(t){this.properties=this._transitioning.possiblyEvaluate(t)}setErrorQueryLatitudeDegrees(t){this._verticalPerspectiveProjection.setErrorQueryLatitudeDegrees(t),this._mercatorProjection.setErrorQueryLatitudeDegrees(t)}}function Uf(t){const e=$f(t.worldSize,t.center.lat);return 2*Math.PI*e}function Zf(t,e,i,r,n){const s=1/(1<<n),o=e/J*s+r*s,a=ht((t/J*s+i*s)*Math.PI*2+Math.PI,2*Math.PI),l=2*Math.atan(Math.exp(Math.PI-o*Math.PI*2))-.5*Math.PI,c=Math.cos(l),h=new Float64Array(3);return h[0]=Math.sin(a)*c,h[1]=Math.sin(l),h[2]=Math.cos(a)*c,h}function Gf(t){return function(t,e){const i=Math.cos(e),r=new Float64Array(3);return r[0]=Math.sin(t)*i,r[1]=Math.sin(e),r[2]=Math.cos(t)*i,r}(t.lng*Math.PI/180,t.lat*Math.PI/180)}function $f(t,e){return t/(2*Math.PI)/Math.cos(e*Math.PI/180)}function qf(t){const e=Math.asin(t[1])/Math.PI*180,i=Math.sqrt(t[0]*t[0]+t[2]*t[2]);if(i>1e-6){const r=t[0]/i,n=Math.acos(t[2]/i),s=(r>0?n:-n)/Math.PI*180;return new op(yt(s,-180,180),e)}return new op(0,e)}function Wf(t){return Math.cos(t*Math.PI/180)}function Hf(t,e){const i=Wf(t);return Pt(Wf(e)/i)}function Xf(t,e){const i=t.rotate(e.bearingInRadians),r=e.zoom+Hf(e.center.lat,0),n=pt(1/Wf(e.center.lat),1/Wf(Math.min(Math.abs(e.center.lat),60)),ut(r,7,3,0,1)),s=360/Uf({worldSize:e.worldSize,center:{lat:e.center.lat}});return new op(e.center.lng-i.x*s*n,gt(e.center.lat+i.y*s,-85.051129,Ut))}function Kf(t){const e=.5*t,i=Math.sin(e),r=Math.cos(e);return Math.log(i+r)-Math.log(r-i)}function Yf(t,e,i,r){const n=t.lat+i*r;if(Math.abs(i)>1){const s=(Math.sign(t.lat+i)!==Math.sign(t.lat)?-Math.abs(t.lat):Math.abs(t.lat))*Math.PI/180,o=Math.abs(t.lat+i)*Math.PI/180,a=Kf(s+r*(o-s)),l=Kf(s),c=Kf(o);return new op(t.lng+e*((a-l)/(c-l)),n)}return new op(t.lng+e*r,n)}class Jf{constructor(t){this._cachePrevious=new Map,this._cache=new Map,this._hadAnyChanges=!1,this._aabbFactory=t}recalculateCache(){if(!this._hadAnyChanges)return;const t=this._cachePrevious;this._cachePrevious=this._cache,this._cache=t,this._cache.clear(),this._hadAnyChanges=!1}getTileAABB(t,e,i,r){const n=`${t.z}_${t.x}_${t.y}`,s=this._cache.get(n);if(s)return s;const o=this._cachePrevious.get(n);if(o)return this._cache.set(n,o),o;const a=this._aabbFactory(t,e,i,r);return this._cache.set(n,a),this._hadAnyChanges=!0,a}}function Qf(t,e,i){const r=t-e;return r<0?-r:Math.max(0,r-i)}function tm(t,e,i,r,n){const s=t-i;let o;return o=s<0?Math.min(-s,1+s-n):s>1?Math.min(Math.max(s-n,0),1-s):0,Math.max(o,Qf(e,r,n))}class em{constructor(){this._aabbCache=new Jf(this._computeTileAABB)}recalculateCache(){this._aabbCache.recalculateCache()}distanceToTile2d(t,e,i,r){const n=1<<i.z,s=1/n,o=i.x/n,a=i.y/n;let l=2;return l=Math.min(l,tm(t,e,o,a,s)),l=Math.min(l,tm(t,e,o+.5,-a-s,s)),l=Math.min(l,tm(t,e,o+.5,2-a-s,s)),l}getWrap(t,e,i){const r=1<<e.z,n=1/r,s=e.x/r,o=Qf(t.x,s,n),a=Qf(t.x,s-1,n),l=Qf(t.x,s+1,n),c=Math.min(o,a,l);return c===l?1:c===a?-1:0}allowVariableZoom(t,e){return $p(t,e)>4}allowWorldCopies(){return!1}getTileAABB(t,e,i,r){return this._aabbCache.getTileAABB(t,e,i,r)}_computeTileAABB(t,e,i,r){if(t.z<=0)return new xf([-1,-1,-1],[1,1,1]);if(1===t.z)return new xf([0===t.x?-1:0,0===t.y?0:-1,-1],[0===t.x?0:1,0===t.y?1:0,1]);{const e=[Zf(0,0,t.x,t.y,t.z),Zf(J,0,t.x,t.y,t.z),Zf(J,J,t.x,t.y,t.z),Zf(0,J,t.x,t.y,t.z)],i=[1,1,1],r=[-1,-1,-1];for(const t of e)for(let e=0;e<3;e++)i[e]=Math.min(i[e],t[e]),r[e]=Math.max(r[e],t[e]);if(0===t.y||t.y===(1<<t.z)-1){const e=[0,0===t.y?1:-1,0];for(let t=0;t<3;t++)i[t]=Math.min(i[t],e[t]),r[t]=Math.max(r[t],e[t])}return new xf(i,r)}}}class im{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(t){this._helper.setMinZoom(t)}setMaxZoom(t){this._helper.setMaxZoom(t)}setMinPitch(t){this._helper.setMinPitch(t)}setMaxPitch(t){this._helper.setMaxPitch(t)}setRenderWorldCopies(t){this._helper.setRenderWorldCopies(t)}setBearing(t){this._helper.setBearing(t)}setPitch(t){this._helper.setPitch(t)}setRoll(t){this._helper.setRoll(t)}setFov(t){this._helper.setFov(t)}setZoom(t){this._helper.setZoom(t)}setCenter(t){this._helper.setCenter(t)}setElevation(t){this._helper.setElevation(t)}setMinElevationForCurrentTile(t){this._helper.setMinElevationForCurrentTile(t)}setPadding(t){this._helper.setPadding(t)}interpolatePadding(t,e,i){return this._helper.interpolatePadding(t,e,i)}isPaddingEqual(t){return this._helper.isPaddingEqual(t)}resize(t,e){this._helper.resize(t,e)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(t){this._helper.setMaxBounds(t)}overrideNearFarZ(t,e){this._helper.overrideNearFarZ(t,e)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(t){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),t)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(t){}constructor(){this._cachedClippingPlane=tt(),this._projectionMatrix=rt(),this._globeViewProjMatrix32f=nt(),this._globeViewProjMatrixNoCorrection=rt(),this._globeViewProjMatrixNoCorrectionInverted=rt(),this._globeProjMatrixInverted=rt(),this._cameraPosition=et(),this._globeLatitudeErrorCorrectionRadians=0,this._helper=new yf({calcMatrices:()=>{this._calcMatrices()},getConstrained:(t,e)=>this.getConstrained(t,e)}),this._coveringTilesDetailsProvider=new em}clone(){const t=new im;return t.apply(this),t}apply(t,e){this._globeLatitudeErrorCorrectionRadians=e||0,this._helper.apply(t)}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._globeViewProjMatrixNoCorrection}get inverseProjectionMatrix(){return this._globeProjMatrixInverted}get cameraPosition(){const t=et();return t[0]=this._cameraPosition[0],t[1]=this._cameraPosition[1],t[2]=this._cameraPosition[2],t}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}getProjectionData(t){const{overscaledTileID:e,applyGlobeMatrix:i}=t,r=this._helper.getMercatorTileCoordinates(e);return{mainMatrix:this._globeViewProjMatrix32f,tileMercatorCoords:r,clippingPlane:this._cachedClippingPlane,projectionTransition:i?1:0,fallbackMatrix:this._globeViewProjMatrix32f}}_computeClippingPlane(t){const e=this.pitchInRadians,i=this.cameraToCenterDistance/t,r=Math.sin(e)*i,n=Math.cos(e)*i+1,s=1/Math.sqrt(r*r+n*n)*1;let o=-r,a=n;const l=Math.sqrt(o*o+a*a);o/=l,a/=l;const c=[0,o,a];return N(c,c,[0,0,0],-this.bearingInRadians),j(c,c,[0,0,0],-1*this.center.lat*Math.PI/180),V(c,c,[0,0,0],this.center.lng*Math.PI/180),L(c,c,.25),[...c,.25*-s]}isLocationOccluded(t){return!this.isSurfacePointVisible(Gf(t))}transformLightDirection(t){const e=this._helper._center.lng*Math.PI/180,i=this._helper._center.lat*Math.PI/180,r=Math.cos(i),n=[Math.sin(e)*r,Math.sin(i),Math.cos(e)*r],s=[n[2],0,-n[0]],o=[0,0,0];O(o,s,n),B(s,s),B(o,o);const a=[0,0,0];return B(a,[s[0]*t[0]+o[0]*t[1]+n[0]*t[2],s[1]*t[0]+o[1]*t[1]+n[1]*t[2],s[2]*t[0]+o[2]*t[1]+n[2]*t[2]]),a}getPixelScale(){return 1/Math.cos(this._helper._center.lat*Math.PI/180)}getCircleRadiusCorrection(){return Math.cos(this._helper._center.lat*Math.PI/180)}getPitchedTextCorrection(t,e,i){const r=function(t,e,i){const r=1/(1<<i.z);return new mp(t/J*r+i.x*r,e/J*r+i.y*r)}(t,e,i.canonical),n=(s=r.y,[ht(r.x*Math.PI*2+Math.PI,2*Math.PI),2*Math.atan(Math.exp(Math.PI-s*Math.PI*2))-.5*Math.PI]);var s;return this.getCircleRadiusCorrection()/Math.cos(n[1])}projectTileCoordinates(t,e,i,r){const n=i.canonical,s=Zf(t,e,n.x,n.y,n.z),o=1+(r?r(t,e):0)/sp,a=[s[0]*o,s[1]*o,s[2]*o,1];G(a,a,this._globeViewProjMatrixNoCorrection);const l=this._cachedClippingPlane,h=l[0]*s[0]+l[1]*s[1]+l[2]*s[2]+l[3]<0;return{point:new c(a[0]/a[3],a[1]/a[3]),signedDistanceFromCamera:a[3],isOccluded:h}}_calcMatrices(){if(!this._helper._width||!this._helper._height)return;const t=$f(this.worldSize,this.center.lat),e=it(),i=it();this._helper.autoCalculateNearFarZ&&(this._helper._nearZ=.5,this._helper._farZ=this.cameraToCenterDistance+2*t),E(e,this.fovInRadians,this.width/this.height,this._helper._nearZ,this._helper._farZ);const r=this.centerOffset;e[8]=2*-r.x/this._helper._width,e[9]=2*r.y/this._helper._height,this._projectionMatrix=v(e),this._globeProjMatrixInverted=it(),w(this._globeProjMatrixInverted,e),P(e,e,[0,0,-this.cameraToCenterDistance]),S(e,e,this.rollInRadians),C(e,e,-this.pitchInRadians),S(e,e,this.bearingInRadians),P(e,e,[0,0,-t]);const n=et();n[0]=t,n[1]=t,n[2]=t,C(i,e,this.center.lat*Math.PI/180),I(i,i,-this.center.lng*Math.PI/180),M(i,i,n),this._globeViewProjMatrixNoCorrection=i,C(e,e,this.center.lat*Math.PI/180-this._globeLatitudeErrorCorrectionRadians),I(e,e,-this.center.lng*Math.PI/180),M(e,e,n),this._globeViewProjMatrix32f=new Float32Array(e),this._globeViewProjMatrixNoCorrectionInverted=it(),w(this._globeViewProjMatrixNoCorrectionInverted,i);const s=et();this._cameraPosition=et(),this._cameraPosition[2]=this.cameraToCenterDistance/t,N(this._cameraPosition,this._cameraPosition,s,-this.rollInRadians),j(this._cameraPosition,this._cameraPosition,s,this.pitchInRadians),N(this._cameraPosition,this._cameraPosition,s,-this.bearingInRadians),R(this._cameraPosition,this._cameraPosition,[0,0,1]),j(this._cameraPosition,this._cameraPosition,s,-this.center.lat*Math.PI/180),V(this._cameraPosition,this._cameraPosition,s,this.center.lng*Math.PI/180),this._cachedClippingPlane=this._computeClippingPlane(t);const o=v(this._globeViewProjMatrixNoCorrectionInverted);M(o,o,[1,1,-1]),this._cachedFrustum=bf.fromInvProjectionMatrix(o)}calculateFogMatrix(t){At("calculateFogMatrix is not supported on globe projection.");const e=it();return b(e),e}getVisibleUnwrappedCoordinates(t){return[new bp(0,t)]}getCameraFrustum(){return this._cachedFrustum}getClippingPlane(){return this._cachedClippingPlane}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(t){t&&At("terrain is not fully supported on vertical perspective projection."),this._helper.recalculateZoomAndCenter(0)}maxPitchScaleFactor(){return 1}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(t,e){if(!this._globeViewProjMatrixNoCorrection)return 1;const i=Gf(t);L(i,i,1+e/sp);const r=tt();return G(r,[i[0],i[1],i[2],1],this._globeViewProjMatrixNoCorrection),r[2]/r[3]}populateCache(t){}getBounds(){const t=.5*this.width,e=.5*this.height,i=[new c(0,0),new c(t,0),new c(this.width,0),new c(this.width,e),new c(this.width,this.height),new c(t,this.height),new c(0,this.height),new c(0,e)],r=[];for(const t of i)r.push(this.unprojectScreenPoint(t));let n=0,s=0,o=0,a=0;const l=this.center;for(const t of r){const e=lt(l.lng,t.lng),i=lt(l.lat,t.lat);e<s&&(s=e),e>n&&(n=e),i<a&&(a=i),i>o&&(o=i)}const h=[l.lng+s,l.lat+a,l.lng+n,l.lat+o];return this.isSurfacePointOnScreen([0,1,0])&&(h[3]=90,h[0]=-180,h[2]=180),this.isSurfacePointOnScreen([0,-1,0])&&(h[1]=-90,h[0]=-180,h[2]=180),new ap(h)}getConstrained(t,e){const i=gt(t.lat,-85.051129,Ut),r=gt(+e,this.minZoom+Hf(0,i),this.maxZoom);return{center:new op(t.lng,i),zoom:r}}calculateCenterFromCameraLngLatAlt(t,e,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(t,e,i,r)}setLocationAtPoint(t,e){const i=Gf(this.unprojectScreenPoint(e)),r=Gf(t),n=et();var s;(s=n)[0]=0,s[1]=0,s[2]=0;const o=et();V(o,i,n,-this.center.lng*Math.PI/180),j(o,o,n,this.center.lat*Math.PI/180);const a=r[0]*r[0]+r[2]*r[2],l=o[0]*o[0];if(a<l)return;const c=Math.sqrt(a-l),h=-c,u=at(r[0],r[2],o[0],c),p=at(r[0],r[2],o[0],h),d=et();V(d,r,n,-u);const f=at(d[1],d[2],o[1],o[2]),m=et();V(m,r,n,-p);const _=at(m[1],m[2],o[1],o[2]),g=.5*Math.PI,y=f>=-g&&f<=g,x=_>=-g&&_<=g;let v,b;if(y&&x){const t=this.center.lng*Math.PI/180,e=this.center.lat*Math.PI/180;ct(u,t)+ct(f,e)<ct(p,t)+ct(_,e)?(v=u,b=f):(v=p,b=_)}else if(y)v=u,b=f;else{if(!x)return;v=p,b=_}const w=v/Math.PI*180,T=b/Math.PI*180,P=this.center.lat;this.setCenter(new op(w,gt(T,-90,90))),this.setZoom(this.zoom+Hf(P,this.center.lat))}locationToScreenPoint(t,e){const i=Gf(t);return e&&L(i,i,1+e.getElevationForLngLatZoom(t,this._helper._tileZoom)/sp),this._projectSurfacePointToScreen(i)}_projectSurfacePointToScreen(t){const e=tt();return G(e,[...t,1],this._globeViewProjMatrixNoCorrection),e[0]/=e[3],e[1]/=e[3],new c((.5*e[0]+.5)*this.width,(.5*-e[1]+.5)*this.height)}screenPointToMercatorCoordinate(t,e){if(e){const i=e.pointCoordinate(t);if(i)return i}return mp.fromLngLat(this.unprojectScreenPoint(t))}screenPointToLocation(t,e){var i;return null===(i=this.screenPointToMercatorCoordinate(t,e))||void 0===i?void 0:i.toLngLat()}isPointOnMapSurface(t,e){const i=this._cameraPosition,r=this.getRayDirectionFromPixel(t);return!!this.rayPlanetIntersection(i,r)}getRayDirectionFromPixel(t){const e=tt();e[0]=t.x/this.width*2-1,e[1]=-1*(t.y/this.height*2-1),e[2]=1,e[3]=1,G(e,e,this._globeViewProjMatrixNoCorrectionInverted),e[0]/=e[3],e[1]/=e[3],e[2]/=e[3];const i=et();i[0]=e[0]-this._cameraPosition[0],i[1]=e[1]-this._cameraPosition[1],i[2]=e[2]-this._cameraPosition[2];const r=et();return B(r,i),r}isSurfacePointVisible(t){const e=this._cachedClippingPlane;return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]+e[3]>=0}isSurfacePointOnScreen(t){if(!this.isSurfacePointVisible(t))return!1;const e=tt();return G(e,[...t,1],this._globeViewProjMatrixNoCorrection),e[0]/=e[3],e[1]/=e[3],e[2]/=e[3],e[0]>-1&&e[0]<1&&e[1]>-1&&e[1]<1&&e[2]>-1&&e[2]<1}rayPlanetIntersection(t,e){const i=F(t,e),r=et(),n=et();L(n,e,i),Z(r,t,n);const s=1-F(r,r);if(s<0)return null;const o=F(t,t)-1,a=-i+(i<0?1:-1)*Math.sqrt(s),l=o/a,c=a;return{tMin:Math.min(l,c),tMax:Math.max(l,c)}}unprojectScreenPoint(t){const e=this._cameraPosition,i=this.getRayDirectionFromPixel(t),r=this.rayPlanetIntersection(e,i);if(r){const t=et();R(t,e,[i[0]*r.tMin,i[1]*r.tMin,i[2]*r.tMin]);const n=et();return B(n,t),qf(n)}const n=this._cachedClippingPlane[0]*i[0]+this._cachedClippingPlane[1]*i[1]+this._cachedClippingPlane[2]*i[2],s=-ot(this._cachedClippingPlane,e)/n,o=et();if(s>0)R(o,e,[i[0]*s,i[1]*s,i[2]*s]);else{const t=et();R(t,e,[2*i[0],2*i[1],2*i[2]]);const r=ot(this._cachedClippingPlane,t);Z(o,t,[this._cachedClippingPlane[0]*r,this._cachedClippingPlane[1]*r,this._cachedClippingPlane[2]*r])}const a=et();return B(a,o),qf(a)}getMatrixForModel(t,e){const i=op.convert(t),r=1/sp,n=rt();return I(n,n,i.lng/180*Math.PI),C(n,n,-i.lat/180*Math.PI),P(n,n,[0,0,1+e/sp]),C(n,n,.5*Math.PI),M(n,n,[r,r,r]),n}getProjectionDataForCustomLayer(t=!0){const e=this.getProjectionData({overscaledTileID:new wp(0,0,0,0,0),applyGlobeMatrix:t});return e.tileMercatorCoords=[0,0,1,1],e}getFastPathSimpleProjectionMatrix(t){}}class rm{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(t){this._helper.setMinZoom(t)}setMaxZoom(t){this._helper.setMaxZoom(t)}setMinPitch(t){this._helper.setMinPitch(t)}setMaxPitch(t){this._helper.setMaxPitch(t)}setRenderWorldCopies(t){this._helper.setRenderWorldCopies(t)}setBearing(t){this._helper.setBearing(t)}setPitch(t){this._helper.setPitch(t)}setRoll(t){this._helper.setRoll(t)}setFov(t){this._helper.setFov(t)}setZoom(t){this._helper.setZoom(t)}setCenter(t){this._helper.setCenter(t)}setElevation(t){this._helper.setElevation(t)}setMinElevationForCurrentTile(t){this._helper.setMinElevationForCurrentTile(t)}setPadding(t){this._helper.setPadding(t)}interpolatePadding(t,e,i){return this._helper.interpolatePadding(t,e,i)}isPaddingEqual(t){return this._helper.isPaddingEqual(t)}resize(t,e,i=!0){this._helper.resize(t,e,i)}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(t){this._helper.setMaxBounds(t)}overrideNearFarZ(t,e){this._helper.overrideNearFarZ(t,e)}clearNearFarZOverride(){this._helper.clearNearFarZOverride()}getCameraQueryGeometry(t){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),t)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}get isGlobeRendering(){return this._globeness>0}setTransitionState(t,e){this._globeness=t,this._globeLatitudeErrorCorrectionRadians=e,this._calcMatrices(),this._verticalPerspectiveTransform.getCoveringTilesDetailsProvider().recalculateCache(),this._mercatorTransform.getCoveringTilesDetailsProvider().recalculateCache()}get currentTransform(){return this.isGlobeRendering?this._verticalPerspectiveTransform:this._mercatorTransform}constructor(){this._globeLatitudeErrorCorrectionRadians=0,this._globeness=1,this._helper=new yf({calcMatrices:()=>{this._calcMatrices()},getConstrained:(t,e)=>this.getConstrained(t,e)}),this._globeness=1,this._mercatorTransform=new wf,this._verticalPerspectiveTransform=new im}clone(){const t=new rm;return t._globeness=this._globeness,t._globeLatitudeErrorCorrectionRadians=this._globeLatitudeErrorCorrectionRadians,t.apply(this),t}apply(t){this._helper.apply(t),this._mercatorTransform.apply(this),this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians)}get projectionMatrix(){return this.currentTransform.projectionMatrix}get modelViewProjectionMatrix(){return this.currentTransform.modelViewProjectionMatrix}get inverseProjectionMatrix(){return this.currentTransform.inverseProjectionMatrix}get cameraPosition(){return this.currentTransform.cameraPosition}getProjectionData(t){const e=this._mercatorTransform.getProjectionData(t),i=this._verticalPerspectiveTransform.getProjectionData(t);return{mainMatrix:this.isGlobeRendering?i.mainMatrix:e.mainMatrix,clippingPlane:i.clippingPlane,tileMercatorCoords:i.tileMercatorCoords,projectionTransition:t.applyGlobeMatrix?this._globeness:0,fallbackMatrix:e.fallbackMatrix}}isLocationOccluded(t){return this.currentTransform.isLocationOccluded(t)}transformLightDirection(t){return this.currentTransform.transformLightDirection(t)}getPixelScale(){return pt(this._mercatorTransform.getPixelScale(),this._verticalPerspectiveTransform.getPixelScale(),this._globeness)}getCircleRadiusCorrection(){return pt(this._mercatorTransform.getCircleRadiusCorrection(),this._verticalPerspectiveTransform.getCircleRadiusCorrection(),this._globeness)}getPitchedTextCorrection(t,e,i){return pt(this._mercatorTransform.getPitchedTextCorrection(t,e,i),this._verticalPerspectiveTransform.getPitchedTextCorrection(t,e,i),this._globeness)}projectTileCoordinates(t,e,i,r){return this.currentTransform.projectTileCoordinates(t,e,i,r)}_calcMatrices(){this._helper._width&&this._helper._height&&(this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians),this._helper._nearZ=this._verticalPerspectiveTransform.nearZ,this._helper._farZ=this._verticalPerspectiveTransform.farZ,this._mercatorTransform.apply(this,!0,this.isGlobeRendering),this._helper._nearZ=this._mercatorTransform.nearZ,this._helper._farZ=this._mercatorTransform.farZ)}calculateFogMatrix(t){return this.currentTransform.calculateFogMatrix(t)}getVisibleUnwrappedCoordinates(t){return this.currentTransform.getVisibleUnwrappedCoordinates(t)}getCameraFrustum(){return this.currentTransform.getCameraFrustum()}getClippingPlane(){return this.currentTransform.getClippingPlane()}getCoveringTilesDetailsProvider(){return this.currentTransform.getCoveringTilesDetailsProvider()}recalculateZoomAndCenter(t){this._mercatorTransform.recalculateZoomAndCenter(t),this._verticalPerspectiveTransform.recalculateZoomAndCenter(t)}maxPitchScaleFactor(){return this._mercatorTransform.maxPitchScaleFactor()}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(t,e){return this.currentTransform.lngLatToCameraDepth(t,e)}populateCache(t){this._mercatorTransform.populateCache(t),this._verticalPerspectiveTransform.populateCache(t)}getBounds(){return this.currentTransform.getBounds()}getConstrained(t,e){return this.currentTransform.getConstrained(t,e)}calculateCenterFromCameraLngLatAlt(t,e,i,r){return this._helper.calculateCenterFromCameraLngLatAlt(t,e,i,r)}setLocationAtPoint(t,e){if(!this.isGlobeRendering)return this._mercatorTransform.setLocationAtPoint(t,e),void this.apply(this._mercatorTransform);this._verticalPerspectiveTransform.setLocationAtPoint(t,e),this.apply(this._verticalPerspectiveTransform)}locationToScreenPoint(t,e){return this.currentTransform.locationToScreenPoint(t,e)}screenPointToMercatorCoordinate(t,e){return this.currentTransform.screenPointToMercatorCoordinate(t,e)}screenPointToLocation(t,e){return this.currentTransform.screenPointToLocation(t,e)}isPointOnMapSurface(t,e){return this.currentTransform.isPointOnMapSurface(t,e)}getRayDirectionFromPixel(t){return this._verticalPerspectiveTransform.getRayDirectionFromPixel(t)}getMatrixForModel(t,e){return this.currentTransform.getMatrixForModel(t,e)}getProjectionDataForCustomLayer(t=!0){const e=this._mercatorTransform.getProjectionDataForCustomLayer(t);if(!this.isGlobeRendering)return e;const i=this._verticalPerspectiveTransform.getProjectionDataForCustomLayer(t);return i.fallbackMatrix=e.mainMatrix,i}getFastPathSimpleProjectionMatrix(t){return this.currentTransform.getFastPathSimpleProjectionMatrix(t)}}class nm{get useGlobeControls(){return!0}handlePanInertia(t,e){const i=Xf(t,e);return Math.abs(i.lng-e.center.lng)>180&&(i.lng=e.center.lng+179.5*Math.sign(i.lng-e.center.lng)),{easingCenter:i,easingOffset:new c(0,0)}}handleMapControlsRollPitchBearingZoom(t,e){const i=t.around,r=e.screenPointToLocation(i);t.bearingDelta&&e.setBearing(e.bearing+t.bearingDelta),t.pitchDelta&&e.setPitch(e.pitch+t.pitchDelta),t.rollDelta&&e.setRoll(e.roll+t.rollDelta);const n=e.zoom;t.zoomDelta&&e.setZoom(e.zoom+t.zoomDelta);const s=e.zoom-n;if(0===s)return;const o=lt(e.center.lng,r.lng),a=o/(Math.abs(o/180)+1),l=lt(e.center.lat,r.lat),c=e.getRayDirectionFromPixel(i),h=e.cameraPosition,u=-1*F(h,c),p=et();R(p,h,[c[0]*u,c[1]*u,c[2]*u]);const d=(b=p,Math.hypot(b[0],b[1],b[2])-1),f=Math.exp(.5*-Math.max(d-.3,0)),m=$f(e.worldSize,e.center.lat)/Math.min(e.width,e.height),_=ut(m,.9,.5,1,.25),g=(1-Tt(-s))*Math.min(f,_),y=e.center.lat,x=e.zoom,v=new op(e.center.lng+a*g,gt(e.center.lat+l*g,-85.051129,Ut));var b;e.setLocationAtPoint(r,i);const w=e.center,T=ut(Math.abs(o),45,85,0,1),P=ut(m,.75,.35,0,1),M=Math.pow(Math.max(T,P),.25),C=lt(w.lng,v.lng),I=lt(w.lat,v.lat);e.setCenter(new op(w.lng+C*M,w.lat+I*M).wrap()),e.setZoom(x+Hf(y,e.center.lat))}handleMapControlsPan(t,e,i){if(!t.panDelta)return;const r=e.center.lat,n=e.zoom;e.setCenter(Xf(t.panDelta,e).wrap()),e.setZoom(n+Hf(r,e.center.lat))}cameraForBoxAndBearing(t,e,i,r,n){const s=Mf(t,e,i,r,n),o=e.left/n.width*2-1,a=(n.width-e.right)/n.width*2-1,l=e.top/n.height*-2+1,c=(n.height-e.bottom)/n.height*-2+1,h=lt(i.getWest(),i.getEast())<0,u=h?i.getEast():i.getWest(),p=h?i.getWest():i.getEast(),d=Math.max(i.getNorth(),i.getSouth()),f=Math.min(i.getNorth(),i.getSouth()),m=u+.5*lt(u,p),_=d+.5*lt(d,f),g=n.clone();g.setCenter(s.center),g.setBearing(s.bearing),g.setPitch(0),g.setRoll(0),g.setZoom(s.zoom);const y=g.modelViewProjectionMatrix,x=[Gf(i.getNorthWest()),Gf(i.getNorthEast()),Gf(i.getSouthWest()),Gf(i.getSouthEast()),Gf(new op(p,_)),Gf(new op(u,_)),Gf(new op(m,d)),Gf(new op(m,f))],v=Gf(s.center);let b=Number.POSITIVE_INFINITY;for(const t of x)o<0&&(b=nm.getLesserNonNegativeNonNull(b,nm.solveVectorScale(t,v,y,"x",o))),a>0&&(b=nm.getLesserNonNegativeNonNull(b,nm.solveVectorScale(t,v,y,"x",a))),l>0&&(b=nm.getLesserNonNegativeNonNull(b,nm.solveVectorScale(t,v,y,"y",l))),c<0&&(b=nm.getLesserNonNegativeNonNull(b,nm.solveVectorScale(t,v,y,"y",c)));if(Number.isFinite(b)&&0!==b)return s.zoom=g.zoom+Pt(b),s;Tf()}handleJumpToCenterZoom(t,e){const i=t.center.lat,r=t.getConstrained(e.center?op.convert(e.center):t.center,t.zoom).center;t.setCenter(r.wrap());const n=void 0!==e.zoom?+e.zoom:t.zoom+Hf(i,r.lat);t.zoom!==n&&t.setZoom(n)}handleEaseTo(t,e){const i=t.zoom,r=t.center,n=t.padding,s={roll:t.roll,pitch:t.pitch,bearing:t.bearing},o={roll:void 0===e.roll?t.roll:e.roll,pitch:void 0===e.pitch?t.pitch:e.pitch,bearing:void 0===e.bearing?t.bearing:e.bearing},a=void 0!==e.zoom,l=!t.isPaddingEqual(e.padding);let h=!1;const u=e.center?op.convert(e.center):r,p=t.getConstrained(u,i).center;_f(t,p);const d=t.clone();d.setCenter(p),d.setZoom(a?+e.zoom:i+Hf(r.lat,u.lat)),d.setBearing(e.bearing);const f=new c(gt(t.centerPoint.x+e.offsetAsPoint.x,0,t.width),gt(t.centerPoint.y+e.offsetAsPoint.y,0,t.height));d.setLocationAtPoint(p,f);const m=(e.offset&&e.offsetAsPoint.mag())>0?d.center:p,_=a?+e.zoom:i+Hf(r.lat,m.lat),g=i+Hf(r.lat,0),y=_+Hf(m.lat,0),x=lt(r.lng,m.lng),v=lt(r.lat,m.lat),b=Tt(y-g);return h=_!==i,{easeFunc:i=>{if(jt(s,o)||Pf({startEulerAngles:s,endEulerAngles:o,tr:t,k:i,useSlerp:s.roll!=o.roll}),l&&t.interpolatePadding(n,e.padding,i),e.around)At("Easing around a point is not supported under globe projection."),t.setLocationAtPoint(e.around,e.aroundPoint);else{const e=y>g?Math.min(2,b):Math.max(.5,b),n=Math.pow(e,1-i),s=Yf(r,x,v,i*n);t.setCenter(s.wrap())}if(h){const e=ar.number(g,y,i)+Hf(0,t.center.lat);t.setZoom(e)}},isZooming:h,elevationCenter:m}}handleFlyTo(t,e){const i=void 0!==e.zoom,r=t.center,n=t.zoom,s=t.padding,o=!t.isPaddingEqual(e.padding),a=t.getConstrained(op.convert(e.center||e.locationAtOffset),n).center,l=i?+e.zoom:t.zoom+Hf(t.center.lat,a.lat),h=t.clone();h.setCenter(a),h.setZoom(l),h.setBearing(e.bearing);const u=new c(gt(t.centerPoint.x+e.offsetAsPoint.x,0,t.width),gt(t.centerPoint.y+e.offsetAsPoint.y,0,t.height));h.setLocationAtPoint(a,u);const p=h.center;_f(t,p);const d=function(t,e,i){const r=F(Gf(e),Gf(i)),n=Math.acos(r),s=Uf(t);return n/(2*Math.PI)*s}(t,r,p),f=n+Hf(r.lat,0),m=l+Hf(p.lat,0),_=Tt(m-f);let g;if("number"==typeof e.minZoom){const i=+e.minZoom+Hf(p.lat,0),r=Math.min(i,f,m)+Hf(0,p.lat);g=Tt(t.getConstrained(p,r).zoom+Hf(p.lat,0)-f)}const y=lt(r.lng,p.lng),x=lt(r.lat,p.lat);return{easeFunc:(i,n,a,c)=>{const h=Yf(r,y,x,a);o&&t.interpolatePadding(s,e.padding,i);const u=1===i?p:h;t.setCenter(u.wrap());const d=f+Pt(n);t.setZoom(1===i?l:d+Hf(0,u.lat))},scaleOfZoom:_,targetCenter:p,scaleOfMinZoom:g,pixelPathLength:d}}static solveVectorScale(t,e,i,r,n){const s="x"===r?[i[0],i[4],i[8],i[12]]:[i[1],i[5],i[9],i[13]],o=[i[3],i[7],i[11],i[15]],a=t[0]*s[0]+t[1]*s[1]+t[2]*s[2],l=t[0]*o[0]+t[1]*o[1]+t[2]*o[2],c=e[0]*s[0]+e[1]*s[1]+e[2]*s[2],h=e[0]*o[0]+e[1]*o[1]+e[2]*o[2];return c+n*l===a+n*h||o[3]*(a-c)+s[3]*(h-l)+a*h==c*l?null:(c+s[3]-n*h-n*o[3])/(c-a-n*h+n*l)}static getLesserNonNegativeNonNull(t,e){return null!==e&&e>=0&&e<t?e:t}}class sm{constructor(t){this._globe=t,this._mercatorCameraHelper=new Cf,this._verticalPerspectiveCameraHelper=new nm}get useGlobeControls(){return this._globe.useGlobeRendering}get currentHelper(){return this.useGlobeControls?this._verticalPerspectiveCameraHelper:this._mercatorCameraHelper}handlePanInertia(t,e){return this.currentHelper.handlePanInertia(t,e)}handleMapControlsRollPitchBearingZoom(t,e){return this.currentHelper.handleMapControlsRollPitchBearingZoom(t,e)}handleMapControlsPan(t,e,i){this.currentHelper.handleMapControlsPan(t,e,i)}cameraForBoxAndBearing(t,e,i,r,n){return this.currentHelper.cameraForBoxAndBearing(t,e,i,r,n)}handleJumpToCenterZoom(t,e){this.currentHelper.handleJumpToCenterZoom(t,e)}handleEaseTo(t,e){return this.currentHelper.handleEaseTo(t,e)}handleFlyTo(t,e){return this.currentHelper.handleFlyTo(t,e)}}const om=(t,e)=>Gs(t,e&&e.filter((t=>"source.canvas"!==t.identifier))),am=function(){const t={},e=_e.$version;for(const i in _e.$root){const r=_e.$root[i];if(r.required){let n=null;n="version"===i?e:"array"===r.type?[]:{},null!=n&&(t[i]=n)}}return t}();class lm extends me{constructor(t,e={}){super(),this._rtlPluginLoaded=()=>{for(const t in this.sourceCaches){const e=this.sourceCaches[t].getSource().type;"vector"!==e&&"geojson"!==e||this.sourceCaches[t].reload()}},this.map=t,this.dispatcher=new Ju(Yu(),t._getMapId()),this.dispatcher.registerMessageHandler("GG",((t,e)=>this.getGlyphs(t,e))),this.dispatcher.registerMessageHandler("GI",((t,e)=>this.getImages(t,e))),this.imageManager=new ku,this.imageManager.setEventedParent(this),this.glyphManager=new Bu(t._requestManager,e.localIdeographFontFamily),this.lineAtlas=new Uu(256,512),this.crossTileSymbolIndex=new tf,this._spritesImagesIds={},this._layers={},this._order=[],this.sourceCaches={},this.zoomHistory=new Qs,this._loaded=!1,this._availableImages=[],this._resetUpdates(),this.dispatcher.broadcast("SR",Qt()),jp().on(Bp,this._rtlPluginLoaded),this.on("data",(t=>{if("source"!==t.dataType||"metadata"!==t.sourceDataType)return;const e=this.sourceCaches[t.sourceId];if(!e)return;const i=e.getSource();if(i&&i.vectorLayerIds)for(const t in this._layers){const e=this._layers[t];e.source===i.id&&this._validateLayer(e)}}))}loadURL(t,e={},i){this.fire(new de("dataloading",{dataType:"style"})),e.validate="boolean"!=typeof e.validate||e.validate;const r=this.map._requestManager.transformRequest(t,"Style");this._loadStyleRequest=new AbortController;const n=this._loadStyleRequest;ee(r,this._loadStyleRequest).then((t=>{this._loadStyleRequest=null,this._load(t.data,e,i)})).catch((t=>{this._loadStyleRequest=null,t&&!n.signal.aborted&&this.fire(new fe(t))}))}loadJSON(t,e={},i){this.fire(new de("dataloading",{dataType:"style"})),this._frameRequest=new AbortController,Wt.frameAsync(this._frameRequest).then((()=>{this._frameRequest=null,e.validate=!1!==e.validate,this._load(t,e,i)})).catch((()=>{}))}loadEmpty(){this.fire(new de("dataloading",{dataType:"style"})),this._load(am,{validate:!1})}_load(t,e,i){var r,n;const s=e.transformStyle?e.transformStyle(i,t):t;if(!e.validate||!om(this,js(s))){this._loaded=!0,this.stylesheet=s;for(const t in s.sources)this.addSource(t,s.sources[t],{validate:!1});s.sprite?this._loadSprite(s.sprite):this.imageManager.setLoaded(!0),this.glyphManager.setURL(s.glyphs),this._createLayers(),this.light=new ju(this.stylesheet.light),this._setProjectionInternal((null===(r=this.stylesheet.projection)||void 0===r?void 0:r.type)||"mercator"),this.sky=new Nu(this.stylesheet.sky),this.map.setTerrain(null!==(n=this.stylesheet.terrain)&&void 0!==n?n:null),this.fire(new de("data",{dataType:"style"})),this.fire(new de("style.load"))}}_createLayers(){const t=xe(this.stylesheet.layers);this.dispatcher.broadcast("SL",t),this._order=t.map((t=>t.id)),this._layers={},this._serializedLayers=null;for(const e of t){const t=Iu(e);t.setEventedParent(this,{layer:{id:e.id}}),this._layers[e.id]=t}}_loadSprite(t,e=!1,i=void 0){let r;this.imageManager.setLoaded(!1),this._spriteRequest=new AbortController,function(t,e,i,r){return n(this,void 0,void 0,(function*(){const s=Su(t),o=i>1?"@2x":"",a={},l={};for(const{id:t,url:i}of s){const n=e.transformRequest(Eu(i,o,".json"),"SpriteJSON");a[t]=ee(n,r);const s=e.transformRequest(Eu(i,o,".png"),"SpriteImage");l[t]=ce.getImage(s,r)}return yield Promise.all([...Object.values(a),...Object.values(l)]),function(t,e){return n(this,void 0,void 0,(function*(){const i={};for(const r in t){i[r]={};const n=Wt.getImageCanvasContext((yield e[r]).data),s=(yield t[r]).data;for(const t in s){const{width:e,height:o,x:a,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:p,content:d,textFitWidth:f,textFitHeight:m}=s[t];i[r][t]={data:null,pixelRatio:h,sdf:c,stretchX:u,stretchY:p,content:d,textFitWidth:f,textFitHeight:m,spriteData:{width:e,height:o,x:a,y:l,context:n}}}}return i}))}(a,l)}))}(t,this.map._requestManager,this.map.getPixelRatio(),this._spriteRequest).then((t=>{if(this._spriteRequest=null,t)for(const i in t){this._spritesImagesIds[i]=[];const r=this._spritesImagesIds[i]?this._spritesImagesIds[i].filter((e=>!(e in t))):[];for(const t of r)this.imageManager.removeImage(t),this._changedImages[t]=!0;for(const r in t[i]){const n="default"===i?r:`${i}:${r}`;this._spritesImagesIds[i].push(n),n in this.imageManager.images?this.imageManager.updateImage(n,t[i][r],!1):this.imageManager.addImage(n,t[i][r]),e&&(this._changedImages[n]=!0)}}})).catch((t=>{this._spriteRequest=null,r=t,this.fire(new fe(r))})).finally((()=>{this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),e&&(this._changed=!0),this.dispatcher.broadcast("SI",this._availableImages),this.fire(new de("data",{dataType:"style"})),i&&i(r)}))}_unloadSprite(){for(const t of Object.values(this._spritesImagesIds).flat())this.imageManager.removeImage(t),this._changedImages[t]=!0;this._spritesImagesIds={},this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new de("data",{dataType:"style"}))}_validateLayer(t){const e=this.sourceCaches[t.source];if(!e)return;const i=t.sourceLayer;if(!i)return;const r=e.getSource();("geojson"===r.type||r.vectorLayerIds&&-1===r.vectorLayerIds.indexOf(i))&&this.fire(new fe(new Error(`Source layer "${i}" does not exist on source "${r.id}" as specified by style layer "${t.id}".`)))}loaded(){if(!this._loaded)return!1;if(Object.keys(this._updatedSources).length)return!1;for(const t in this.sourceCaches)if(!this.sourceCaches[t].loaded())return!1;return!!this.imageManager.isLoaded()}_serializeByIds(t,e=!1){const i=this._serializedAllLayers();if(!t||0===t.length)return Object.values(e?St(i):i);const r=[];for(const n of t)if(i[n]){const t=e?St(i[n]):i[n];r.push(t)}return r}_serializedAllLayers(){let t=this._serializedLayers;if(t)return t;t=this._serializedLayers={};const e=Object.keys(this._layers);for(const i of e){const e=this._layers[i];"custom"!==e.type&&(t[i]=e.serialize())}return t}hasTransitions(){var t,e,i;if(null===(t=this.light)||void 0===t?void 0:t.hasTransition())return!0;if(null===(e=this.sky)||void 0===e?void 0:e.hasTransition())return!0;if(null===(i=this.projection)||void 0===i?void 0:i.hasTransition())return!0;for(const t in this.sourceCaches)if(this.sourceCaches[t].hasTransition())return!0;for(const t in this._layers)if(this._layers[t].hasTransition())return!0;return!1}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading.")}update(t){if(!this._loaded)return;const e=this._changed;if(e){const e=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(e.length||i.length)&&this._updateWorkerLayers(e,i);for(const t in this._updatedSources){const e=this._updatedSources[t];if("reload"===e)this._reloadSource(t);else{if("clear"!==e)throw new Error(`Invalid action ${e}`);this._clearSource(t)}}this._updateTilesForChangedImages(),this._updateTilesForChangedGlyphs();for(const e in this._updatedPaintProps)this._layers[e].updateTransitions(t);this.light.updateTransitions(t),this.sky.updateTransitions(t),this._resetUpdates()}const i={};for(const t in this.sourceCaches){const e=this.sourceCaches[t];i[t]=e.used,e.used=!1}for(const e of this._order){const i=this._layers[e];i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)&&i.source&&(this.sourceCaches[i.source].used=!0)}for(const t in i){const e=this.sourceCaches[t];!!i[t]!=!!e.used&&e.fire(new de("data",{sourceDataType:"visibility",dataType:"source",sourceId:t}))}this.light.recalculate(t),this.sky.recalculate(t),this.projection.recalculate(t),this.z=t.zoom,e&&this.fire(new de("data",{dataType:"style"}))}_updateTilesForChangedImages(){const t=Object.keys(this._changedImages);if(t.length){for(const e in this.sourceCaches)this.sourceCaches[e].reloadTilesForDependencies(["icons","patterns"],t);this._changedImages={}}}_updateTilesForChangedGlyphs(){if(this._glyphsDidChange){for(const t in this.sourceCaches)this.sourceCaches[t].reloadTilesForDependencies(["glyphs"],[""]);this._glyphsDidChange=!1}}_updateWorkerLayers(t,e){this.dispatcher.broadcast("UL",{layers:this._serializeByIds(t,!1),removedIds:e})}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={},this._glyphsDidChange=!1}setState(t,e={}){var i;this._checkLoaded();const r=this.serialize();if(t=e.transformStyle?e.transformStyle(r,t):t,(null===(i=e.validate)||void 0===i||i)&&om(this,js(t)))return!1;(t=St(t)).layers=xe(t.layers);const n=function(t,e){if(!t)return[{command:"setStyle",args:[e]}];let i=[];try{if(!ve(t.version,e.version))return[{command:"setStyle",args:[e]}];ve(t.center,e.center)||i.push({command:"setCenter",args:[e.center]}),ve(t.centerAltitude,e.centerAltitude)||i.push({command:"setCenterAltitude",args:[e.centerAltitude]}),ve(t.zoom,e.zoom)||i.push({command:"setZoom",args:[e.zoom]}),ve(t.bearing,e.bearing)||i.push({command:"setBearing",args:[e.bearing]}),ve(t.pitch,e.pitch)||i.push({command:"setPitch",args:[e.pitch]}),ve(t.roll,e.roll)||i.push({command:"setRoll",args:[e.roll]}),ve(t.sprite,e.sprite)||i.push({command:"setSprite",args:[e.sprite]}),ve(t.glyphs,e.glyphs)||i.push({command:"setGlyphs",args:[e.glyphs]}),ve(t.transition,e.transition)||i.push({command:"setTransition",args:[e.transition]}),ve(t.light,e.light)||i.push({command:"setLight",args:[e.light]}),ve(t.terrain,e.terrain)||i.push({command:"setTerrain",args:[e.terrain]}),ve(t.sky,e.sky)||i.push({command:"setSky",args:[e.sky]}),ve(t.projection,e.projection)||i.push({command:"setProjection",args:[e.projection]});const r={},n=[];!function(t,e,i,r){let n;for(n in e=e||{},t=t||{})Object.prototype.hasOwnProperty.call(t,n)&&(Object.prototype.hasOwnProperty.call(e,n)||Te(n,i,r));for(n in e)Object.prototype.hasOwnProperty.call(e,n)&&(Object.prototype.hasOwnProperty.call(t,n)?ve(t[n],e[n])||("geojson"===t[n].type&&"geojson"===e[n].type&&Me(t,e,n)?be(i,{command:"setGeoJSONSourceData",args:[n,e[n].data]}):Pe(n,e,i,r)):we(n,e,i))}(t.sources,e.sources,n,r);const s=[];t.layers&&t.layers.forEach((t=>{"source"in t&&r[t.source]?i.push({command:"removeLayer",args:[t.id]}):s.push(t)})),i=i.concat(n),function(t,e,i){e=e||[];const r=(t=t||[]).map(Ie),n=e.map(Ie),s=t.reduce(Se,{}),o=e.reduce(Se,{}),a=r.slice(),l=Object.create(null);let c,h,u,p,d;for(let t=0,e=0;t<r.length;t++)c=r[t],Object.prototype.hasOwnProperty.call(o,c)?e++:(be(i,{command:"removeLayer",args:[c]}),a.splice(a.indexOf(c,e),1));for(let t=0,e=0;t<n.length;t++)c=n[n.length-1-t],a[a.length-1-t]!==c&&(Object.prototype.hasOwnProperty.call(s,c)?(be(i,{command:"removeLayer",args:[c]}),a.splice(a.lastIndexOf(c,a.length-e),1)):e++,p=a[a.length-t],be(i,{command:"addLayer",args:[o[c],p]}),a.splice(a.length-t,0,c),l[c]=!0);for(let t=0;t<n.length;t++)if(c=n[t],h=s[c],u=o[c],!l[c]&&!ve(h,u))if(ve(h.source,u.source)&&ve(h["source-layer"],u["source-layer"])&&ve(h.type,u.type)){for(d in Ce(h.layout,u.layout,i,c,null,"setLayoutProperty"),Ce(h.paint,u.paint,i,c,null,"setPaintProperty"),ve(h.filter,u.filter)||be(i,{command:"setFilter",args:[c,u.filter]}),ve(h.minzoom,u.minzoom)&&ve(h.maxzoom,u.maxzoom)||be(i,{command:"setLayerZoomRange",args:[c,u.minzoom,u.maxzoom]}),h)Object.prototype.hasOwnProperty.call(h,d)&&"layout"!==d&&"paint"!==d&&"filter"!==d&&"metadata"!==d&&"minzoom"!==d&&"maxzoom"!==d&&(0===d.indexOf("paint.")?Ce(h[d],u[d],i,c,d.slice(6),"setPaintProperty"):ve(h[d],u[d])||be(i,{command:"setLayerProperty",args:[c,d,u[d]]}));for(d in u)Object.prototype.hasOwnProperty.call(u,d)&&!Object.prototype.hasOwnProperty.call(h,d)&&"layout"!==d&&"paint"!==d&&"filter"!==d&&"metadata"!==d&&"minzoom"!==d&&"maxzoom"!==d&&(0===d.indexOf("paint.")?Ce(h[d],u[d],i,c,d.slice(6),"setPaintProperty"):ve(h[d],u[d])||be(i,{command:"setLayerProperty",args:[c,d,u[d]]}))}else be(i,{command:"removeLayer",args:[c]}),p=a[a.lastIndexOf(c)+1],be(i,{command:"addLayer",args:[u,p]})}(s,e.layers,i)}catch(t){console.warn("Unable to compute style diff:",t),i=[{command:"setStyle",args:[e]}]}return i}(r,t),s=this._getOperationsToPerform(n);if(s.unimplemented.length>0)throw new Error(`Unimplemented: ${s.unimplemented.join(", ")}.`);if(0===s.operations.length)return!1;for(const t of s.operations)t();return this.stylesheet=t,this._serializedLayers=null,!0}_getOperationsToPerform(t){const e=[],i=[];for(const r of t)switch(r.command){case"setCenter":case"setZoom":case"setBearing":case"setPitch":case"setRoll":continue;case"addLayer":e.push((()=>this.addLayer.apply(this,r.args)));break;case"removeLayer":e.push((()=>this.removeLayer.apply(this,r.args)));break;case"setPaintProperty":e.push((()=>this.setPaintProperty.apply(this,r.args)));break;case"setLayoutProperty":e.push((()=>this.setLayoutProperty.apply(this,r.args)));break;case"setFilter":e.push((()=>this.setFilter.apply(this,r.args)));break;case"addSource":e.push((()=>this.addSource.apply(this,r.args)));break;case"removeSource":e.push((()=>this.removeSource.apply(this,r.args)));break;case"setLayerZoomRange":e.push((()=>this.setLayerZoomRange.apply(this,r.args)));break;case"setLight":e.push((()=>this.setLight.apply(this,r.args)));break;case"setGeoJSONSourceData":e.push((()=>this.setGeoJSONSourceData.apply(this,r.args)));break;case"setGlyphs":e.push((()=>this.setGlyphs.apply(this,r.args)));break;case"setSprite":e.push((()=>this.setSprite.apply(this,r.args)));break;case"setTerrain":e.push((()=>this.map.setTerrain.apply(this,r.args)));break;case"setSky":e.push((()=>this.setSky.apply(this,r.args)));break;case"setProjection":this.setProjection.apply(this,r.args);break;case"setTransition":e.push((()=>{}));break;default:i.push(r.command)}return{operations:e,unimplemented:i}}addImage(t,e){if(this.getImage(t))return this.fire(new fe(new Error(`An image named "${t}" already exists.`)));this.imageManager.addImage(t,e),this._afterImageUpdated(t)}updateImage(t,e){this.imageManager.updateImage(t,e)}getImage(t){return this.imageManager.getImage(t)}removeImage(t){if(!this.getImage(t))return this.fire(new fe(new Error(`An image named "${t}" does not exist.`)));this.imageManager.removeImage(t),this._afterImageUpdated(t)}_afterImageUpdated(t){this._availableImages=this.imageManager.listImages(),this._changedImages[t]=!0,this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new de("data",{dataType:"style"}))}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(t,e,i={}){if(this._checkLoaded(),void 0!==this.sourceCaches[t])throw new Error(`Source "${t}" already exists.`);if(!e.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(e).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(e.type)>=0&&this._validate(js.source,`sources.${t}`,e,null,i))return;this.map&&this.map._collectResourceTiming&&(e.collectResourceTiming=!0);const r=this.sourceCaches[t]=new Wp(t,e,this.dispatcher);r.style=this,r.setEventedParent(this,(()=>({isSourceLoaded:r.loaded(),source:r.serialize(),sourceId:t}))),r.onAdd(this.map),this._changed=!0}removeSource(t){if(this._checkLoaded(),void 0===this.sourceCaches[t])throw new Error("There is no source with this ID");for(const e in this._layers)if(this._layers[e].source===t)return this.fire(new fe(new Error(`Source "${t}" cannot be removed while layer "${e}" is using it.`)));const e=this.sourceCaches[t];delete this.sourceCaches[t],delete this._updatedSources[t],e.fire(new de("data",{sourceDataType:"metadata",dataType:"source",sourceId:t})),e.setEventedParent(null),e.onRemove(this.map),this._changed=!0}setGeoJSONSourceData(t,e){if(this._checkLoaded(),void 0===this.sourceCaches[t])throw new Error(`There is no source with this ID=${t}`);const i=this.sourceCaches[t].getSource();if("geojson"!==i.type)throw new Error(`geojsonSource.type is ${i.type}, which is !== 'geojson`);i.setData(e),this._changed=!0}getSource(t){return this.sourceCaches[t]&&this.sourceCaches[t].getSource()}addLayer(t,e,i={}){this._checkLoaded();const r=t.id;if(this.getLayer(r))return void this.fire(new fe(new Error(`Layer "${r}" already exists on this map.`)));let n;if("custom"===t.type){if(om(this,function(t){const e=[],i=t.id;return void 0===i&&e.push({message:`layers.${i}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${i}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${i}: property "renderingMode" must be either "2d" or "3d"`}),e}(t)))return;n=Iu(t)}else{if("source"in t&&"object"==typeof t.source&&(this.addSource(r,t.source),t=xt(t=St(t),{source:r})),this._validate(js.layer,`layers.${r}`,t,{arrayIndex:-1},i))return;n=Iu(t),this._validateLayer(n),n.setEventedParent(this,{layer:{id:r}})}const s=e?this._order.indexOf(e):this._order.length;if(e&&-1===s)this.fire(new fe(new Error(`Cannot add layer "${r}" before non-existing layer "${e}".`)));else{if(this._order.splice(s,0,r),this._layerOrderChanged=!0,this._layers[r]=n,this._removedLayers[r]&&n.source&&"custom"!==n.type){const t=this._removedLayers[r];delete this._removedLayers[r],t.type!==n.type?this._updatedSources[n.source]="clear":(this._updatedSources[n.source]="reload",this.sourceCaches[n.source].pause())}this._updateLayer(n),n.onAdd&&n.onAdd(this.map)}}moveLayer(t,e){if(this._checkLoaded(),this._changed=!0,!this._layers[t])return void this.fire(new fe(new Error(`The layer '${t}' does not exist in the map's style and cannot be moved.`)));if(t===e)return;const i=this._order.indexOf(t);this._order.splice(i,1);const r=e?this._order.indexOf(e):this._order.length;e&&-1===r?this.fire(new fe(new Error(`Cannot move layer "${t}" before non-existing layer "${e}".`))):(this._order.splice(r,0,t),this._layerOrderChanged=!0)}removeLayer(t){this._checkLoaded();const e=this._layers[t];if(!e)return void this.fire(new fe(new Error(`Cannot remove non-existing layer "${t}".`)));e.setEventedParent(null);const i=this._order.indexOf(t);this._order.splice(i,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[t]=e,delete this._layers[t],this._serializedLayers&&delete this._serializedLayers[t],delete this._updatedLayers[t],delete this._updatedPaintProps[t],e.onRemove&&e.onRemove(this.map)}getLayer(t){return this._layers[t]}getLayersOrder(){return[...this._order]}hasLayer(t){return t in this._layers}setLayerZoomRange(t,e,i){this._checkLoaded();const r=this.getLayer(t);r?r.minzoom===e&&r.maxzoom===i||(null!=e&&(r.minzoom=e),null!=i&&(r.maxzoom=i),this._updateLayer(r)):this.fire(new fe(new Error(`Cannot set the zoom range of non-existing layer "${t}".`)))}setFilter(t,e,i={}){this._checkLoaded();const r=this.getLayer(t);if(r){if(!It(r.filter,e))return null==e?(r.filter=void 0,void this._updateLayer(r)):void(this._validate(js.filter,`layers.${r.id}.filter`,e,null,i)||(r.filter=St(e),this._updateLayer(r)))}else this.fire(new fe(new Error(`Cannot filter non-existing layer "${t}".`)))}getFilter(t){return St(this.getLayer(t).filter)}setLayoutProperty(t,e,i,r={}){this._checkLoaded();const n=this.getLayer(t);n?It(n.getLayoutProperty(e),i)||(n.setLayoutProperty(e,i,r),this._updateLayer(n)):this.fire(new fe(new Error(`Cannot style non-existing layer "${t}".`)))}getLayoutProperty(t,e){const i=this.getLayer(t);if(i)return i.getLayoutProperty(e);this.fire(new fe(new Error(`Cannot get style of non-existing layer "${t}".`)))}setPaintProperty(t,e,i,r={}){this._checkLoaded();const n=this.getLayer(t);n?It(n.getPaintProperty(e),i)||(n.setPaintProperty(e,i,r)&&this._updateLayer(n),this._changed=!0,this._updatedPaintProps[t]=!0,this._serializedLayers=null):this.fire(new fe(new Error(`Cannot style non-existing layer "${t}".`)))}getPaintProperty(t,e){return this.getLayer(t).getPaintProperty(e)}setFeatureState(t,e){this._checkLoaded();const i=t.source,r=t.sourceLayer,n=this.sourceCaches[i];if(void 0===n)return void this.fire(new fe(new Error(`The source '${i}' does not exist in the map's style.`)));const s=n.getSource().type;"geojson"===s&&r?this.fire(new fe(new Error("GeoJSON sources cannot have a sourceLayer parameter."))):"vector"!==s||r?(void 0===t.id&&this.fire(new fe(new Error("The feature id parameter must be provided."))),n.setFeatureState(r,t.id,e)):this.fire(new fe(new Error("The sourceLayer parameter must be provided for vector source types.")))}removeFeatureState(t,e){this._checkLoaded();const i=t.source,r=this.sourceCaches[i];if(void 0===r)return void this.fire(new fe(new Error(`The source '${i}' does not exist in the map's style.`)));const n=r.getSource().type,s="vector"===n?t.sourceLayer:void 0;"vector"!==n||s?e&&"string"!=typeof t.id&&"number"!=typeof t.id?this.fire(new fe(new Error("A feature id is required to remove its specific state property."))):r.removeFeatureState(s,t.id,e):this.fire(new fe(new Error("The sourceLayer parameter must be provided for vector source types.")))}getFeatureState(t){this._checkLoaded();const e=t.source,i=t.sourceLayer,r=this.sourceCaches[e];if(void 0!==r)return"vector"!==r.getSource().type||i?(void 0===t.id&&this.fire(new fe(new Error("The feature id parameter must be provided."))),r.getFeatureState(i,t.id)):void this.fire(new fe(new Error("The sourceLayer parameter must be provided for vector source types.")));this.fire(new fe(new Error(`The source '${e}' does not exist in the map's style.`)))}getTransition(){return xt({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){if(!this._loaded)return;const t=Mt(this.sourceCaches,(t=>t.serialize())),e=this._serializeByIds(this._order,!0),i=this.map.getTerrain()||void 0,r=this.stylesheet;return Ct({version:r.version,name:r.name,metadata:r.metadata,light:r.light,sky:r.sky,center:r.center,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,sprite:r.sprite,glyphs:r.glyphs,transition:r.transition,projection:r.projection,sources:t,layers:e,terrain:i},(t=>void 0!==t))}_updateLayer(t){this._updatedLayers[t.id]=!0,t.source&&!this._updatedSources[t.source]&&"raster"!==this.sourceCaches[t.source].getSource().type&&(this._updatedSources[t.source]="reload",this.sourceCaches[t.source].pause()),this._serializedLayers=null,this._changed=!0}_flattenAndSortRenderedFeatures(t){const e=t=>"fill-extrusion"===this._layers[t].type,i={},r=[];for(let n=this._order.length-1;n>=0;n--){const s=this._order[n];if(e(s)){i[s]=n;for(const e of t){const t=e[s];if(t)for(const e of t)r.push(e)}}}r.sort(((t,e)=>e.intersectionZ-t.intersectionZ));const n=[];for(let s=this._order.length-1;s>=0;s--){const o=this._order[s];if(e(o))for(let t=r.length-1;t>=0;t--){const e=r[t].feature;if(i[e.layer.id]<s)break;n.push(e),r.pop()}else for(const e of t){const t=e[o];if(t)for(const e of t)n.push(e.feature)}}return n}queryRenderedFeatures(t,e,i){e&&e.filter&&this._validate(js.filter,"queryRenderedFeatures.filter",e.filter,null,e);const r={};if(e&&e.layers){if(!(Array.isArray(e.layers)||e.layers instanceof Set))return this.fire(new fe(new Error("parameters.layers must be an Array or a Set of strings"))),[];for(const t of e.layers){const e=this._layers[t];if(!e)return this.fire(new fe(new Error(`The layer '${t}' does not exist in the map's style and cannot be queried for features.`))),[];r[e.source]=!0}}const n=[];e.availableImages=this._availableImages;const s=this._serializedAllLayers(),o=e.layers instanceof Set?e.layers:Array.isArray(e.layers)?new Set(e.layers):null,a=Object.assign(Object.assign({},e),{layers:o});for(const o in this.sourceCaches)e.layers&&!r[o]||n.push(ep(this.sourceCaches[o],this._layers,s,t,a,i));return this.placement&&n.push(function(t,e,i,r,n,s,o){const a={},l=s.queryRenderedSymbols(r),c=[];for(const t of Object.keys(l).map(Number))c.push(o[t]);c.sort(ip);for(const i of c){const r=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],e,i.bucketIndex,i.sourceLayerIndex,n.filter,n.layers,n.availableImages,t);for(const t in r){const e=a[t]=a[t]||[],n=r[t];n.sort(((t,e)=>{const r=i.featureSortOrder;if(r){const i=r.indexOf(t.featureIndex);return r.indexOf(e.featureIndex)-i}return e.featureIndex-t.featureIndex}));for(const t of n)e.push(t)}}return function(t,e,i){for(const r in t)for(const n of t[r])rp(n,i[e[r].source]);return t}(a,t,i)}(this._layers,s,this.sourceCaches,t,a,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(n)}querySourceFeatures(t,e){e&&e.filter&&this._validate(js.filter,"querySourceFeatures.filter",e.filter,null,e);const i=this.sourceCaches[t];return i?function(t,e){const i=t.getRenderableIds().map((e=>t.getTileByID(e))),r=[],n={};for(let t=0;t<i.length;t++){const s=i[t],o=s.tileID.canonical.key;n[o]||(n[o]=!0,s.querySourceFeatures(r,e))}return r}(i,e):[]}getLight(){return this.light.getLight()}setLight(t,e={}){this._checkLoaded();const i=this.light.getLight();let r=!1;for(const e in t)if(!It(t[e],i[e])){r=!0;break}if(!r)return;const n={now:Wt.now(),transition:xt({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(t,e),this.light.updateTransitions(n)}getProjection(){var t;return null===(t=this.stylesheet)||void 0===t?void 0:t.projection}setProjection(t){if(this._checkLoaded(),this.projection){if(this.projection.name===t.type)return;this.projection.destroy(),delete this.projection}this.stylesheet.projection=t,this._setProjectionInternal(t.type)}getSky(){var t;return null===(t=this.stylesheet)||void 0===t?void 0:t.sky}setSky(t,e={}){this._checkLoaded();const i=this.getSky();let r=!1;if(!t&&!i)return;if(t&&!i)r=!0;else if(!t&&i)r=!0;else for(const e in t)if(!It(t[e],i[e])){r=!0;break}if(!r)return;const n={now:Wt.now(),transition:xt({duration:300,delay:0},this.stylesheet.transition)};this.stylesheet.sky=t,this.sky.setSky(t,e),this.sky.updateTransitions(n)}_setProjectionInternal(t){const e=function(t){if(Array.isArray(t)){const e=new Nf({type:t});return{projection:e,transform:new rm,cameraHelper:new sm(e)}}switch(t){case"mercator":return{projection:new cf,transform:new wf,cameraHelper:new Cf};case"globe":{const t=new Nf({type:["interpolate",["linear"],["zoom"],11,"vertical-perspective",12,"mercator"]});return{projection:t,transform:new rm,cameraHelper:new sm(t)}}case"vertical-perspective":return{projection:new jf,transform:new im,cameraHelper:new nm};default:return At(`Unknown projection name: ${t}. Falling back to mercator projection.`),{projection:new cf,transform:new wf,cameraHelper:new Cf}}}(t);this.projection=e.projection,this.map.migrateProjection(e.transform,e.cameraHelper);for(const t in this.sourceCaches)this.sourceCaches[t].reload()}_validate(t,e,i,r,n={}){return(!n||!1!==n.validate)&&om(this,t.call(js,xt({key:e,style:this.serialize(),value:i,styleSpec:_e},r)))}_remove(t=!0){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null),jp().off(Bp,this._rtlPluginLoaded);for(const t in this._layers)this._layers[t].setEventedParent(null);for(const t in this.sourceCaches){const e=this.sourceCaches[t];e.setEventedParent(null),e.onRemove(this.map)}this.imageManager.setEventedParent(null),this.setEventedParent(null),t&&this.dispatcher.broadcast("RM",void 0),this.dispatcher.remove(t)}_clearSource(t){this.sourceCaches[t].clearTiles()}_reloadSource(t){this.sourceCaches[t].resume(),this.sourceCaches[t].reload()}_updateSources(t){for(const e in this.sourceCaches)this.sourceCaches[e].update(t,this.map.terrain)}_generateCollisionBoxes(){for(const t in this.sourceCaches)this._reloadSource(t)}_updatePlacement(t,e,i,r,n=!1){let s=!1,o=!1;const a={};for(const e of this._order){const i=this._layers[e];if("symbol"!==i.type)continue;if(!a[i.source]){const t=this.sourceCaches[i.source];a[i.source]=t.getRenderableIds(!0).map((e=>t.getTileByID(e))).sort(((t,e)=>e.tileID.overscaledZ-t.tileID.overscaledZ||(t.tileID.isLessThan(e.tileID)?-1:1)))}const r=this.crossTileSymbolIndex.addLayer(i,a[i.source],t.center.lng);s=s||r}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),((n=n||this._layerOrderChanged||0===i)||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(Wt.now(),t.zoom))&&(this.pauseablePlacement=new Ud(t,this.map.terrain,this._order,n,e,i,r,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,a),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(Wt.now()),o=!0),s&&this.pauseablePlacement.placement.setStale()),o||s)for(const t of this._order){const e=this._layers[t];"symbol"===e.type&&this.placement.updateLayerOpacities(e,a[e.source])}return!this.pauseablePlacement.isDone()||this.placement.hasTransitions(Wt.now())}_releaseSymbolFadeTiles(){for(const t in this.sourceCaches)this.sourceCaches[t].releaseSymbolFadeTiles()}getImages(t,e){return n(this,void 0,void 0,(function*(){const t=yield this.imageManager.getImages(e.icons);this._updateTilesForChangedImages();const i=this.sourceCaches[e.source];return i&&i.setDependencies(e.tileID.key,e.type,e.icons),t}))}getGlyphs(t,e){return n(this,void 0,void 0,(function*(){const t=yield this.glyphManager.getGlyphs(e.stacks),i=this.sourceCaches[e.source];return i&&i.setDependencies(e.tileID.key,e.type,[""]),t}))}getGlyphsUrl(){return this.stylesheet.glyphs||null}setGlyphs(t,e={}){this._checkLoaded(),t&&this._validate(js.glyphs,"glyphs",t,null,e)||(this._glyphsDidChange=!0,this.stylesheet.glyphs=t,this.glyphManager.entries={},this.glyphManager.setURL(t))}addSprite(t,e,i={},r){this._checkLoaded();const n=[{id:t,url:e}],s=[...Su(this.stylesheet.sprite),...n];this._validate(js.sprite,"sprite",s,null,i)||(this.stylesheet.sprite=s,this._loadSprite(n,!0,r))}removeSprite(t){this._checkLoaded();const e=Su(this.stylesheet.sprite);if(e.find((e=>e.id===t))){if(this._spritesImagesIds[t])for(const e of this._spritesImagesIds[t])this.imageManager.removeImage(e),this._changedImages[e]=!0;e.splice(e.findIndex((e=>e.id===t)),1),this.stylesheet.sprite=e.length>0?e:void 0,delete this._spritesImagesIds[t],this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new de("data",{dataType:"style"}))}else this.fire(new fe(new Error(`Sprite "${t}" doesn't exists on this map.`)))}getSprite(){return Su(this.stylesheet.sprite)}setSprite(t,e={},i){this._checkLoaded(),t&&this._validate(js.sprite,"sprite",t,null,e)||(this.stylesheet.sprite=t,t?this._loadSprite(t,!0,i):(this._unloadSprite(),i&&i(null)))}}var cm=zo([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class hm{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null}bind(t,e,i,r,n,s,o,a,l){this.context=t;let c=this.boundPaintVertexBuffers.length!==r.length;for(let t=0;!c&&t<r.length;t++)this.boundPaintVertexBuffers[t]!==r[t]&&(c=!0);!this.vao||this.boundProgram!==e||this.boundLayoutVertexBuffer!==i||c||this.boundIndexBuffer!==n||this.boundVertexOffset!==s||this.boundDynamicVertexBuffer!==o||this.boundDynamicVertexBuffer2!==a||this.boundDynamicVertexBuffer3!==l?this.freshBind(e,i,r,n,s,o,a,l):(t.bindVertexArray.set(this.vao),o&&o.bind(),n&&n.dynamicDraw&&n.bind(),a&&a.bind(),l&&l.bind())}freshBind(t,e,i,r,n,s,o,a){const l=t.numAttributes,c=this.context,h=c.gl;this.vao&&this.destroy(),this.vao=c.createVertexArray(),c.bindVertexArray.set(this.vao),this.boundProgram=t,this.boundLayoutVertexBuffer=e,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=r,this.boundVertexOffset=n,this.boundDynamicVertexBuffer=s,this.boundDynamicVertexBuffer2=o,this.boundDynamicVertexBuffer3=a,e.enableAttributes(h,t);for(const e of i)e.enableAttributes(h,t);s&&s.enableAttributes(h,t),o&&o.enableAttributes(h,t),a&&a.enableAttributes(h,t),e.bind(),e.setVertexAttribPointers(h,t,n);for(const e of i)e.bind(),e.setVertexAttribPointers(h,t,n);s&&(s.bind(),s.setVertexAttribPointers(h,t,n)),r&&r.bind(),o&&(o.bind(),o.setVertexAttribPointers(h,t,n)),a&&(a.bind(),a.setVertexAttribPointers(h,t,n)),c.currentNumAttributes=l}destroy(){this.vao&&(this.context.deleteVertexArray(this.vao),this.vao=null)}}const um=(t,e,i,r,n)=>({u_texture:0,u_ele_delta:t,u_fog_matrix:e,u_fog_color:i?i.properties.get("fog-color"):bi.white,u_fog_ground_blend:i?i.properties.get("fog-ground-blend"):1,u_fog_ground_blend_opacity:n?0:i?i.calculateFogBlendOpacity(r):0,u_horizon_color:i?i.properties.get("horizon-color"):bi.white,u_horizon_fog_blend:i?i.properties.get("horizon-fog-blend"):1,u_is_globe_mode:n?1:0}),pm={mainMatrix:"u_projection_matrix",tileMercatorCoords:"u_projection_tile_mercator_coords",clippingPlane:"u_projection_clipping_plane",projectionTransition:"u_projection_transition",fallbackMatrix:"u_projection_fallback_matrix"};function dm(t){const e=[];for(let i=0;i<t.length;i++){if(null===t[i])continue;const r=t[i].split(" ");e.push(r.pop())}return e}class fm{constructor(t,e,i,r,n,s,o,a){const l=t.gl;this.program=l.createProgram();const c=dm(e.staticAttributes),h=i?i.getBinderAttributes():[],u=c.concat(h),p=rf.prelude.staticUniforms?dm(rf.prelude.staticUniforms):[],d=o.staticUniforms?dm(o.staticUniforms):[],f=e.staticUniforms?dm(e.staticUniforms):[],m=i?i.getBinderUniforms():[],_=p.concat(d).concat(f).concat(m),g=[];for(const t of _)g.indexOf(t)<0&&g.push(t);const y=i?i.defines():[];Rf(l)&&y.unshift("#version 300 es"),n&&y.push("#define OVERDRAW_INSPECTOR;"),s&&y.push("#define TERRAIN3D;"),a&&y.push(a);let x=y.concat(rf.prelude.fragmentSource,o.fragmentSource,e.fragmentSource).join("\n"),v=y.concat(rf.prelude.vertexSource,o.vertexSource,e.vertexSource).join("\n");Rf(l)||(x=function(t){return t.replace(/\bin\s/g,"varying ").replace("out highp vec4 fragColor;","").replace(/fragColor/g,"gl_FragColor").replace(/texture\(/g,"texture2D(")}(x),v=function(t){return t.replace(/\bin\s/g,"attribute ").replace(/\bout\s/g,"varying ").replace(/texture\(/g,"texture2D(")}(v));const b=l.createShader(l.FRAGMENT_SHADER);if(l.isContextLost())return void(this.failedToCreate=!0);if(l.shaderSource(b,x),l.compileShader(b),!l.getShaderParameter(b,l.COMPILE_STATUS))throw new Error(`Could not compile fragment shader: ${l.getShaderInfoLog(b)}`);l.attachShader(this.program,b);const w=l.createShader(l.VERTEX_SHADER);if(l.isContextLost())return void(this.failedToCreate=!0);if(l.shaderSource(w,v),l.compileShader(w),!l.getShaderParameter(w,l.COMPILE_STATUS))throw new Error(`Could not compile vertex shader: ${l.getShaderInfoLog(w)}`);l.attachShader(this.program,w),this.attributes={};const T={};this.numAttributes=u.length;for(let t=0;t<this.numAttributes;t++)u[t]&&(l.bindAttribLocation(this.program,t,u[t]),this.attributes[u[t]]=t);if(l.linkProgram(this.program),!l.getProgramParameter(this.program,l.LINK_STATUS))throw new Error(`Program failed to link: ${l.getProgramInfoLog(this.program)}`);l.deleteShader(w),l.deleteShader(b);for(let t=0;t<g.length;t++){const e=g[t];if(e&&!T[e]){const t=l.getUniformLocation(this.program,e);t&&(T[e]=t)}}this.fixedUniforms=r(t,T),this.terrainUniforms=((t,e)=>({u_depth:new Ya(t,e.u_depth),u_terrain:new Ya(t,e.u_terrain),u_terrain_dim:new Ja(t,e.u_terrain_dim),u_terrain_matrix:new nl(t,e.u_terrain_matrix),u_terrain_unpack:new el(t,e.u_terrain_unpack),u_terrain_exaggeration:new Ja(t,e.u_terrain_exaggeration)}))(t,T),this.projectionUniforms=((t,e)=>({u_projection_matrix:new nl(t,e.u_projection_matrix),u_projection_tile_mercator_coords:new el(t,e.u_projection_tile_mercator_coords),u_projection_clipping_plane:new el(t,e.u_projection_clipping_plane),u_projection_transition:new Ja(t,e.u_projection_transition),u_projection_fallback_matrix:new nl(t,e.u_projection_fallback_matrix)}))(t,T),this.binderUniforms=i?i.getUniforms(t,T):[]}draw(t,e,i,r,n,s,o,a,l,c,h,u,p,d,f,m,_,g,y){const x=t.gl;if(this.failedToCreate)return;if(t.program.set(this.program),t.setDepthMode(i),t.setStencilMode(r),t.setColorMode(n),t.setCullFace(s),a){t.activeTexture.set(x.TEXTURE2),x.bindTexture(x.TEXTURE_2D,a.depthTexture),t.activeTexture.set(x.TEXTURE3),x.bindTexture(x.TEXTURE_2D,a.texture);for(const t in this.terrainUniforms)this.terrainUniforms[t].set(a[t])}if(l)for(const t in l)this.projectionUniforms[pm[t]].set(l[t]);if(o)for(const t in this.fixedUniforms)this.fixedUniforms[t].set(o[t]);m&&m.setUniforms(t,this.binderUniforms,d,{zoom:f});let v=0;switch(e){case x.LINES:v=2;break;case x.TRIANGLES:v=3;break;case x.LINE_STRIP:v=1}for(const i of p.get()){const r=i.vaos||(i.vaos={});(r[c]||(r[c]=new hm)).bind(t,this,h,m?m.getPaintVertexBuffers():[],u,i.vertexOffset,_,g,y),x.drawElements(e,i.primitiveLength*v,x.UNSIGNED_SHORT,i.primitiveOffset*v*2)}}}function mm(t,e,i){const r=1/Q(i,1,e.transform.tileZoom),n=Math.pow(2,i.tileID.overscaledZ),s=i.tileSize*Math.pow(2,e.transform.tileZoom)/n,o=s*(i.tileID.canonical.x+i.tileID.wrap*n),a=s*i.tileID.canonical.y;return{u_image:0,u_texsize:i.imageAtlasTexture.size,u_scale:[r,t.fromScale,t.toScale],u_fade:t.t,u_pixel_coord_upper:[o>>16,a>>16],u_pixel_coord_lower:[65535&o,65535&a]}}const _m=(t,e,i,r)=>{const n=t.style.light,s=n.properties.get("position"),o=[s.x,s.y,s.z],a=y();var l,c,h,u;"viewport"===n.properties.get("anchor")&&(l=a,c=t.transform.bearingInRadians,h=Math.sin(c),u=Math.cos(c),l[0]=u,l[1]=h,l[2]=0,l[3]=-h,l[4]=u,l[5]=0,l[6]=0,l[7]=0,l[8]=1),function(t,e,i){var r=e[0],n=e[1],s=e[2];t[0]=r*i[0]+n*i[3]+s*i[6],t[1]=r*i[1]+n*i[4]+s*i[7],t[2]=r*i[2]+n*i[5]+s*i[8]}(o,o,a);const p=t.transform.transformLightDirection(o),d=n.properties.get("color");return{u_lightpos:o,u_lightpos_globe:p,u_lightintensity:n.properties.get("intensity"),u_lightcolor:[d.r,d.g,d.b],u_vertical_gradient:+e,u_opacity:i,u_fill_translate:r}},gm=(t,e,i,r,n,s,o)=>xt(_m(t,e,i,r),mm(s,t,o),{u_height_factor:-Math.pow(2,n.overscaledZ)/o.tileSize/8}),ym=(t,e,i,r)=>xt(mm(e,t,i),{u_fill_translate:r}),xm=t=>({u_fill_translate:t}),vm=(t,e)=>({u_world:t,u_fill_translate:e}),bm=(t,e,i,r,n)=>xt(ym(t,e,i,n),{u_world:r}),wm=(t,e,i,r,n)=>{const s=t.transform;let o,a,l=0;if("map"===i.paint.get("circle-pitch-alignment")){const t=Q(e,1,s.zoom);o=!0,a=[t,t],l=t/(J*Math.pow(2,e.tileID.overscaledZ))*2*Math.PI*n}else o=!1,a=s.pixelsToGLUnits;return{u_camera_to_center_distance:s.cameraToCenterDistance,u_scale_with_map:+("map"===i.paint.get("circle-pitch-scale")),u_pitch_with_map:+o,u_device_pixel_ratio:t.pixelRatio,u_extrude_scale:a,u_globe_extrude_scale:l,u_translate:r}},Tm=t=>({u_pixel_extrude_scale:[1/t.width,1/t.height]}),Pm=t=>({u_viewport_size:[t.width,t.height]}),Mm=(t,e=1)=>({u_color:t,u_overlay:0,u_overlay_scale:e}),Cm=(t,e,i,r)=>{const n=Q(t,1,e)/(J*Math.pow(2,t.tileID.overscaledZ))*2*Math.PI*r;return{u_extrude_scale:Q(t,1,e),u_intensity:i,u_globe_extrude_scale:n}},Im=(t,e,i,r)=>{const n=x();A(n,0,t.width,t.height,0,0,1);const s=t.context.gl;return{u_matrix:n,u_world:[s.drawingBufferWidth,s.drawingBufferHeight],u_image:i,u_color_ramp:r,u_opacity:e.paint.get("heatmap-opacity")}},Sm=(t,e,i)=>{const r=i.paint.get("hillshade-shadow-color"),n=i.paint.get("hillshade-highlight-color"),s=i.paint.get("hillshade-accent-color");let o=i.paint.get("hillshade-illumination-direction")*(Math.PI/180);return"viewport"===i.paint.get("hillshade-illumination-anchor")&&(o+=t.transform.bearingInRadians),{u_image:0,u_latrange:Am(0,e.tileID),u_light:[i.paint.get("hillshade-exaggeration"),o],u_shadow:r,u_highlight:n,u_accent:s}},Em=(t,e)=>{const i=e.stride,r=x();return A(r,0,J,-8192,0,0,1),P(r,r,[0,-8192,0]),{u_matrix:r,u_image:1,u_dimension:[i,i],u_zoom:t.overscaledZ,u_unpack:e.getUnpackVector()}};function Am(t,e){const i=Math.pow(2,e.canonical.z),r=e.canonical.y;return[new mp(0,r/i).toLngLat().lat,new mp(0,(r+1)/i).toLngLat().lat]}const zm=(t,e,i,r)=>{const n=t.transform;return{u_translation:Bm(t,e,i),u_ratio:r/Q(e,1,n.zoom),u_device_pixel_ratio:t.pixelRatio,u_units_to_pixels:[1/n.pixelsToGLUnits[0],1/n.pixelsToGLUnits[1]]}},km=(t,e,i,r,n)=>xt(zm(t,e,i,r),{u_image:0,u_image_height:n}),Dm=(t,e,i,r,n)=>{const s=t.transform,o=Lm(e,s);return{u_translation:Bm(t,e,i),u_texsize:e.imageAtlasTexture.size,u_ratio:r/Q(e,1,s.zoom),u_device_pixel_ratio:t.pixelRatio,u_image:0,u_scale:[o,n.fromScale,n.toScale],u_fade:n.t,u_units_to_pixels:[1/s.pixelsToGLUnits[0],1/s.pixelsToGLUnits[1]]}},Rm=(t,e,i,r,n,s)=>{const o=t.lineAtlas,a=Lm(e,t.transform),l="round"===i.layout.get("line-cap"),c=o.getDash(n.from,l),h=o.getDash(n.to,l),u=c.width*s.fromScale,p=h.width*s.toScale;return xt(zm(t,e,i,r),{u_patternscale_a:[a/u,-c.height/2],u_patternscale_b:[a/p,-h.height/2],u_sdfgamma:o.width/(256*Math.min(u,p)*t.pixelRatio)/2,u_image:0,u_tex_y_a:c.y,u_tex_y_b:h.y,u_mix:s.t})};function Lm(t,e){return 1/Q(t,1,e.tileZoom)}function Bm(t,e,i){return st(t.transform,e,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}const Fm=(t,e,i,r,n)=>{return{u_tl_parent:t,u_scale_parent:e,u_buffer_scale:1,u_fade_t:i.mix,u_opacity:i.opacity*r.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:r.paint.get("raster-brightness-min"),u_brightness_high:r.paint.get("raster-brightness-max"),u_saturation_factor:(o=r.paint.get("raster-saturation"),o>0?1-1/(1.001-o):-o),u_contrast_factor:(s=r.paint.get("raster-contrast"),s>0?1/(1-s):1+s),u_spin_weights:Om(r.paint.get("raster-hue-rotate")),u_coords_top:[n[0].x,n[0].y,n[1].x,n[1].y],u_coords_bottom:[n[3].x,n[3].y,n[2].x,n[2].y]};var s,o};function Om(t){t*=Math.PI/180;const e=Math.sin(t),i=Math.cos(t);return[(2*i+1)/3,(-Math.sqrt(3)*e-i+1)/3,(Math.sqrt(3)*e-i+1)/3]}const jm=(t,e,i,r,n,s,o,a,l,c,h,u,p)=>{const d=o.transform;return{u_is_size_zoom_constant:+("constant"===t||"source"===t),u_is_size_feature_constant:+("constant"===t||"camera"===t),u_size_t:e?e.uSizeT:0,u_size:e?e.uSize:0,u_camera_to_center_distance:d.cameraToCenterDistance,u_pitch:d.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:d.width/d.height,u_fade_change:o.options.fadeDuration?o.symbolFadeChange:1,u_label_plane_matrix:a,u_coord_matrix:l,u_is_text:+h,u_pitch_with_map:+r,u_is_along_line:n,u_is_variable_anchor:s,u_texsize:u,u_texture:0,u_translation:c,u_pitched_scale:p}},Vm=(t,e,i,r,n,s,o,a,l,c,h,u,p,d)=>{const f=o.transform;return xt(jm(t,e,i,r,n,s,o,a,l,c,h,u,d),{u_gamma_scale:r?Math.cos(f.pitch*Math.PI/180)*f.cameraToCenterDistance:1,u_device_pixel_ratio:o.pixelRatio,u_is_halo:1})},Nm=(t,e,i,r,n,s,o,a,l,c,h,u,p)=>xt(Vm(t,e,i,r,n,s,o,a,l,c,!0,h,0,p),{u_texsize_icon:u,u_texture_icon:1}),Um=(t,e)=>({u_opacity:t,u_color:e}),Zm=(t,e,i,r,n)=>xt(function(t,e,i,r){const n=i.imageManager.getPattern(t.from.toString()),s=i.imageManager.getPattern(t.to.toString()),{width:o,height:a}=i.imageManager.getPixelSize(),l=Math.pow(2,r.tileID.overscaledZ),c=r.tileSize*Math.pow(2,i.transform.tileZoom)/l,h=c*(r.tileID.canonical.x+r.tileID.wrap*l),u=c*r.tileID.canonical.y;return{u_image:0,u_pattern_tl_a:n.tl,u_pattern_br_a:n.br,u_pattern_tl_b:s.tl,u_pattern_br_b:s.br,u_texsize:[o,a],u_mix:e.t,u_pattern_size_a:n.displaySize,u_pattern_size_b:s.displaySize,u_scale_a:e.fromScale,u_scale_b:e.toScale,u_tile_units_to_pixels:1/Q(r,1,i.transform.tileZoom),u_pixel_coord_upper:[h>>16,u>>16],u_pixel_coord_lower:[65535&h,65535&u]}}(i,n,e,r),{u_opacity:t}),Gm=(t,e)=>{},$m={fillExtrusion:(t,e)=>({u_lightpos:new tl(t,e.u_lightpos),u_lightpos_globe:new tl(t,e.u_lightpos_globe),u_lightintensity:new Ja(t,e.u_lightintensity),u_lightcolor:new tl(t,e.u_lightcolor),u_vertical_gradient:new Ja(t,e.u_vertical_gradient),u_opacity:new Ja(t,e.u_opacity),u_fill_translate:new Qa(t,e.u_fill_translate)}),fillExtrusionPattern:(t,e)=>({u_lightpos:new tl(t,e.u_lightpos),u_lightpos_globe:new tl(t,e.u_lightpos_globe),u_lightintensity:new Ja(t,e.u_lightintensity),u_lightcolor:new tl(t,e.u_lightcolor),u_vertical_gradient:new Ja(t,e.u_vertical_gradient),u_height_factor:new Ja(t,e.u_height_factor),u_opacity:new Ja(t,e.u_opacity),u_fill_translate:new Qa(t,e.u_fill_translate),u_image:new Ya(t,e.u_image),u_texsize:new Qa(t,e.u_texsize),u_pixel_coord_upper:new Qa(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new Qa(t,e.u_pixel_coord_lower),u_scale:new tl(t,e.u_scale),u_fade:new Ja(t,e.u_fade)}),fill:(t,e)=>({u_fill_translate:new Qa(t,e.u_fill_translate)}),fillPattern:(t,e)=>({u_image:new Ya(t,e.u_image),u_texsize:new Qa(t,e.u_texsize),u_pixel_coord_upper:new Qa(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new Qa(t,e.u_pixel_coord_lower),u_scale:new tl(t,e.u_scale),u_fade:new Ja(t,e.u_fade),u_fill_translate:new Qa(t,e.u_fill_translate)}),fillOutline:(t,e)=>({u_world:new Qa(t,e.u_world),u_fill_translate:new Qa(t,e.u_fill_translate)}),fillOutlinePattern:(t,e)=>({u_world:new Qa(t,e.u_world),u_image:new Ya(t,e.u_image),u_texsize:new Qa(t,e.u_texsize),u_pixel_coord_upper:new Qa(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new Qa(t,e.u_pixel_coord_lower),u_scale:new tl(t,e.u_scale),u_fade:new Ja(t,e.u_fade),u_fill_translate:new Qa(t,e.u_fill_translate)}),circle:(t,e)=>({u_camera_to_center_distance:new Ja(t,e.u_camera_to_center_distance),u_scale_with_map:new Ya(t,e.u_scale_with_map),u_pitch_with_map:new Ya(t,e.u_pitch_with_map),u_extrude_scale:new Qa(t,e.u_extrude_scale),u_device_pixel_ratio:new Ja(t,e.u_device_pixel_ratio),u_globe_extrude_scale:new Ja(t,e.u_globe_extrude_scale),u_translate:new Qa(t,e.u_translate)}),collisionBox:(t,e)=>({u_pixel_extrude_scale:new Qa(t,e.u_pixel_extrude_scale)}),collisionCircle:(t,e)=>({u_viewport_size:new Qa(t,e.u_viewport_size)}),debug:(t,e)=>({u_color:new il(t,e.u_color),u_overlay:new Ya(t,e.u_overlay),u_overlay_scale:new Ja(t,e.u_overlay_scale)}),depth:Gm,clippingMask:Gm,heatmap:(t,e)=>({u_extrude_scale:new Ja(t,e.u_extrude_scale),u_intensity:new Ja(t,e.u_intensity),u_globe_extrude_scale:new Ja(t,e.u_globe_extrude_scale)}),heatmapTexture:(t,e)=>({u_matrix:new nl(t,e.u_matrix),u_world:new Qa(t,e.u_world),u_image:new Ya(t,e.u_image),u_color_ramp:new Ya(t,e.u_color_ramp),u_opacity:new Ja(t,e.u_opacity)}),hillshade:(t,e)=>({u_image:new Ya(t,e.u_image),u_latrange:new Qa(t,e.u_latrange),u_light:new Qa(t,e.u_light),u_shadow:new il(t,e.u_shadow),u_highlight:new il(t,e.u_highlight),u_accent:new il(t,e.u_accent)}),hillshadePrepare:(t,e)=>({u_matrix:new nl(t,e.u_matrix),u_image:new Ya(t,e.u_image),u_dimension:new Qa(t,e.u_dimension),u_zoom:new Ja(t,e.u_zoom),u_unpack:new el(t,e.u_unpack)}),line:(t,e)=>({u_translation:new Qa(t,e.u_translation),u_ratio:new Ja(t,e.u_ratio),u_device_pixel_ratio:new Ja(t,e.u_device_pixel_ratio),u_units_to_pixels:new Qa(t,e.u_units_to_pixels)}),lineGradient:(t,e)=>({u_translation:new Qa(t,e.u_translation),u_ratio:new Ja(t,e.u_ratio),u_device_pixel_ratio:new Ja(t,e.u_device_pixel_ratio),u_units_to_pixels:new Qa(t,e.u_units_to_pixels),u_image:new Ya(t,e.u_image),u_image_height:new Ja(t,e.u_image_height)}),linePattern:(t,e)=>({u_translation:new Qa(t,e.u_translation),u_texsize:new Qa(t,e.u_texsize),u_ratio:new Ja(t,e.u_ratio),u_device_pixel_ratio:new Ja(t,e.u_device_pixel_ratio),u_image:new Ya(t,e.u_image),u_units_to_pixels:new Qa(t,e.u_units_to_pixels),u_scale:new tl(t,e.u_scale),u_fade:new Ja(t,e.u_fade)}),lineSDF:(t,e)=>({u_translation:new Qa(t,e.u_translation),u_ratio:new Ja(t,e.u_ratio),u_device_pixel_ratio:new Ja(t,e.u_device_pixel_ratio),u_units_to_pixels:new Qa(t,e.u_units_to_pixels),u_patternscale_a:new Qa(t,e.u_patternscale_a),u_patternscale_b:new Qa(t,e.u_patternscale_b),u_sdfgamma:new Ja(t,e.u_sdfgamma),u_image:new Ya(t,e.u_image),u_tex_y_a:new Ja(t,e.u_tex_y_a),u_tex_y_b:new Ja(t,e.u_tex_y_b),u_mix:new Ja(t,e.u_mix)}),raster:(t,e)=>({u_tl_parent:new Qa(t,e.u_tl_parent),u_scale_parent:new Ja(t,e.u_scale_parent),u_buffer_scale:new Ja(t,e.u_buffer_scale),u_fade_t:new Ja(t,e.u_fade_t),u_opacity:new Ja(t,e.u_opacity),u_image0:new Ya(t,e.u_image0),u_image1:new Ya(t,e.u_image1),u_brightness_low:new Ja(t,e.u_brightness_low),u_brightness_high:new Ja(t,e.u_brightness_high),u_saturation_factor:new Ja(t,e.u_saturation_factor),u_contrast_factor:new Ja(t,e.u_contrast_factor),u_spin_weights:new tl(t,e.u_spin_weights),u_coords_top:new el(t,e.u_coords_top),u_coords_bottom:new el(t,e.u_coords_bottom)}),symbolIcon:(t,e)=>({u_is_size_zoom_constant:new Ya(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new Ya(t,e.u_is_size_feature_constant),u_size_t:new Ja(t,e.u_size_t),u_size:new Ja(t,e.u_size),u_camera_to_center_distance:new Ja(t,e.u_camera_to_center_distance),u_pitch:new Ja(t,e.u_pitch),u_rotate_symbol:new Ya(t,e.u_rotate_symbol),u_aspect_ratio:new Ja(t,e.u_aspect_ratio),u_fade_change:new Ja(t,e.u_fade_change),u_label_plane_matrix:new nl(t,e.u_label_plane_matrix),u_coord_matrix:new nl(t,e.u_coord_matrix),u_is_text:new Ya(t,e.u_is_text),u_pitch_with_map:new Ya(t,e.u_pitch_with_map),u_is_along_line:new Ya(t,e.u_is_along_line),u_is_variable_anchor:new Ya(t,e.u_is_variable_anchor),u_texsize:new Qa(t,e.u_texsize),u_texture:new Ya(t,e.u_texture),u_translation:new Qa(t,e.u_translation),u_pitched_scale:new Ja(t,e.u_pitched_scale)}),symbolSDF:(t,e)=>({u_is_size_zoom_constant:new Ya(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new Ya(t,e.u_is_size_feature_constant),u_size_t:new Ja(t,e.u_size_t),u_size:new Ja(t,e.u_size),u_camera_to_center_distance:new Ja(t,e.u_camera_to_center_distance),u_pitch:new Ja(t,e.u_pitch),u_rotate_symbol:new Ya(t,e.u_rotate_symbol),u_aspect_ratio:new Ja(t,e.u_aspect_ratio),u_fade_change:new Ja(t,e.u_fade_change),u_label_plane_matrix:new nl(t,e.u_label_plane_matrix),u_coord_matrix:new nl(t,e.u_coord_matrix),u_is_text:new Ya(t,e.u_is_text),u_pitch_with_map:new Ya(t,e.u_pitch_with_map),u_is_along_line:new Ya(t,e.u_is_along_line),u_is_variable_anchor:new Ya(t,e.u_is_variable_anchor),u_texsize:new Qa(t,e.u_texsize),u_texture:new Ya(t,e.u_texture),u_gamma_scale:new Ja(t,e.u_gamma_scale),u_device_pixel_ratio:new Ja(t,e.u_device_pixel_ratio),u_is_halo:new Ya(t,e.u_is_halo),u_translation:new Qa(t,e.u_translation),u_pitched_scale:new Ja(t,e.u_pitched_scale)}),symbolTextAndIcon:(t,e)=>({u_is_size_zoom_constant:new Ya(t,e.u_is_size_zoom_constant),u_is_size_feature_constant:new Ya(t,e.u_is_size_feature_constant),u_size_t:new Ja(t,e.u_size_t),u_size:new Ja(t,e.u_size),u_camera_to_center_distance:new Ja(t,e.u_camera_to_center_distance),u_pitch:new Ja(t,e.u_pitch),u_rotate_symbol:new Ya(t,e.u_rotate_symbol),u_aspect_ratio:new Ja(t,e.u_aspect_ratio),u_fade_change:new Ja(t,e.u_fade_change),u_label_plane_matrix:new nl(t,e.u_label_plane_matrix),u_coord_matrix:new nl(t,e.u_coord_matrix),u_is_text:new Ya(t,e.u_is_text),u_pitch_with_map:new Ya(t,e.u_pitch_with_map),u_is_along_line:new Ya(t,e.u_is_along_line),u_is_variable_anchor:new Ya(t,e.u_is_variable_anchor),u_texsize:new Qa(t,e.u_texsize),u_texsize_icon:new Qa(t,e.u_texsize_icon),u_texture:new Ya(t,e.u_texture),u_texture_icon:new Ya(t,e.u_texture_icon),u_gamma_scale:new Ja(t,e.u_gamma_scale),u_device_pixel_ratio:new Ja(t,e.u_device_pixel_ratio),u_is_halo:new Ya(t,e.u_is_halo),u_translation:new Qa(t,e.u_translation),u_pitched_scale:new Ja(t,e.u_pitched_scale)}),background:(t,e)=>({u_opacity:new Ja(t,e.u_opacity),u_color:new il(t,e.u_color)}),backgroundPattern:(t,e)=>({u_opacity:new Ja(t,e.u_opacity),u_image:new Ya(t,e.u_image),u_pattern_tl_a:new Qa(t,e.u_pattern_tl_a),u_pattern_br_a:new Qa(t,e.u_pattern_br_a),u_pattern_tl_b:new Qa(t,e.u_pattern_tl_b),u_pattern_br_b:new Qa(t,e.u_pattern_br_b),u_texsize:new Qa(t,e.u_texsize),u_mix:new Ja(t,e.u_mix),u_pattern_size_a:new Qa(t,e.u_pattern_size_a),u_pattern_size_b:new Qa(t,e.u_pattern_size_b),u_scale_a:new Ja(t,e.u_scale_a),u_scale_b:new Ja(t,e.u_scale_b),u_pixel_coord_upper:new Qa(t,e.u_pixel_coord_upper),u_pixel_coord_lower:new Qa(t,e.u_pixel_coord_lower),u_tile_units_to_pixels:new Ja(t,e.u_tile_units_to_pixels)}),terrain:(t,e)=>({u_texture:new Ya(t,e.u_texture),u_ele_delta:new Ja(t,e.u_ele_delta),u_fog_matrix:new nl(t,e.u_fog_matrix),u_fog_color:new il(t,e.u_fog_color),u_fog_ground_blend:new Ja(t,e.u_fog_ground_blend),u_fog_ground_blend_opacity:new Ja(t,e.u_fog_ground_blend_opacity),u_horizon_color:new il(t,e.u_horizon_color),u_horizon_fog_blend:new Ja(t,e.u_horizon_fog_blend),u_is_globe_mode:new Ja(t,e.u_is_globe_mode)}),terrainDepth:(t,e)=>({u_ele_delta:new Ja(t,e.u_ele_delta)}),terrainCoords:(t,e)=>({u_texture:new Ya(t,e.u_texture),u_terrain_coords_id:new Ja(t,e.u_terrain_coords_id),u_ele_delta:new Ja(t,e.u_ele_delta)}),projectionErrorMeasurement:(t,e)=>({u_input:new Ja(t,e.u_input),u_output_expected:new Ja(t,e.u_output_expected)}),atmosphere:(t,e)=>({u_sun_pos:new tl(t,e.u_sun_pos),u_atmosphere_blend:new Ja(t,e.u_atmosphere_blend),u_globe_position:new tl(t,e.u_globe_position),u_globe_radius:new Ja(t,e.u_globe_radius),u_inv_proj_matrix:new nl(t,e.u_inv_proj_matrix)}),sky:(t,e)=>({u_sky_color:new il(t,e.u_sky_color),u_horizon_color:new il(t,e.u_horizon_color),u_horizon:new Qa(t,e.u_horizon),u_horizon_normal:new Qa(t,e.u_horizon_normal),u_sky_horizon_blend:new Ja(t,e.u_sky_horizon_blend),u_sky_blend:new Ja(t,e.u_sky_blend)})};class qm{constructor(t,e,i){this.context=t;const r=t.gl;this.buffer=r.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),t.bindElementBuffer.set(this.buffer),r.bufferData(r.ELEMENT_ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer}bind(){this.context.bindElementBuffer.set(this.buffer)}updateData(t){const e=this.context.gl;if(!this.dynamicDraw)throw new Error("Attempted to update data while not in dynamic mode.");this.context.unbindVAO(),this.bind(),e.bufferSubData(e.ELEMENT_ARRAY_BUFFER,0,t.arrayBuffer)}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}const Wm={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class Hm{constructor(t,e,i,r){this.length=e.length,this.attributes=i,this.itemSize=e.bytesPerElement,this.dynamicDraw=r,this.context=t;const n=t.gl;this.buffer=n.createBuffer(),t.bindVertexBuffer.set(this.buffer),n.bufferData(n.ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?n.DYNAMIC_DRAW:n.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer}bind(){this.context.bindVertexBuffer.set(this.buffer)}updateData(t){if(t.length!==this.length)throw new Error(`Length of new data is ${t.length}, which doesn't match current length of ${this.length}`);const e=this.context.gl;this.bind(),e.bufferSubData(e.ARRAY_BUFFER,0,t.arrayBuffer)}enableAttributes(t,e){for(let i=0;i<this.attributes.length;i++){const r=e.attributes[this.attributes[i].name];void 0!==r&&t.enableVertexAttribArray(r)}}setVertexAttribPointers(t,e,i){for(let r=0;r<this.attributes.length;r++){const n=this.attributes[r],s=e.attributes[n.name];void 0!==s&&t.vertexAttribPointer(s,n.components,t[Wm[n.type]],!1,this.itemSize,n.offset+this.itemSize*(i||0))}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}class Xm{constructor(t){this.gl=t.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1}get(){return this.current}set(t){}getDefault(){return this.default}setDefault(){this.set(this.default)}}class Km extends Xm{getDefault(){return bi.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.clearColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1)}}class Ym extends Xm{getDefault(){return 1}set(t){(t!==this.current||this.dirty)&&(this.gl.clearDepth(t),this.current=t,this.dirty=!1)}}class Jm extends Xm{getDefault(){return 0}set(t){(t!==this.current||this.dirty)&&(this.gl.clearStencil(t),this.current=t,this.dirty=!1)}}class Qm extends Xm{getDefault(){return[!0,!0,!0,!0]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.colorMask(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1)}}class t_ extends Xm{getDefault(){return!0}set(t){(t!==this.current||this.dirty)&&(this.gl.depthMask(t),this.current=t,this.dirty=!1)}}class e_ extends Xm{getDefault(){return 255}set(t){(t!==this.current||this.dirty)&&(this.gl.stencilMask(t),this.current=t,this.dirty=!1)}}class i_ extends Xm{getDefault(){return{func:this.gl.ALWAYS,ref:0,mask:255}}set(t){const e=this.current;(t.func!==e.func||t.ref!==e.ref||t.mask!==e.mask||this.dirty)&&(this.gl.stencilFunc(t.func,t.ref,t.mask),this.current=t,this.dirty=!1)}}class r_ extends Xm{getDefault(){const t=this.gl;return[t.KEEP,t.KEEP,t.KEEP]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||this.dirty)&&(this.gl.stencilOp(t[0],t[1],t[2]),this.current=t,this.dirty=!1)}}class n_ extends Xm{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.STENCIL_TEST):e.disable(e.STENCIL_TEST),this.current=t,this.dirty=!1}}class s_ extends Xm{getDefault(){return[0,1]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.depthRange(t[0],t[1]),this.current=t,this.dirty=!1)}}class o_ extends Xm{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST),this.current=t,this.dirty=!1}}class a_ extends Xm{getDefault(){return this.gl.LESS}set(t){(t!==this.current||this.dirty)&&(this.gl.depthFunc(t),this.current=t,this.dirty=!1)}}class l_ extends Xm{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.BLEND):e.disable(e.BLEND),this.current=t,this.dirty=!1}}class c_ extends Xm{getDefault(){const t=this.gl;return[t.ONE,t.ZERO]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.blendFunc(t[0],t[1]),this.current=t,this.dirty=!1)}}class h_ extends Xm{getDefault(){return bi.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.blendColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1)}}class u_ extends Xm{getDefault(){return this.gl.FUNC_ADD}set(t){(t!==this.current||this.dirty)&&(this.gl.blendEquation(t),this.current=t,this.dirty=!1)}}class p_ extends Xm{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.CULL_FACE):e.disable(e.CULL_FACE),this.current=t,this.dirty=!1}}class d_ extends Xm{getDefault(){return this.gl.BACK}set(t){(t!==this.current||this.dirty)&&(this.gl.cullFace(t),this.current=t,this.dirty=!1)}}class f_ extends Xm{getDefault(){return this.gl.CCW}set(t){(t!==this.current||this.dirty)&&(this.gl.frontFace(t),this.current=t,this.dirty=!1)}}class m_ extends Xm{getDefault(){return null}set(t){(t!==this.current||this.dirty)&&(this.gl.useProgram(t),this.current=t,this.dirty=!1)}}class __ extends Xm{getDefault(){return this.gl.TEXTURE0}set(t){(t!==this.current||this.dirty)&&(this.gl.activeTexture(t),this.current=t,this.dirty=!1)}}class g_ extends Xm{getDefault(){const t=this.gl;return[0,0,t.drawingBufferWidth,t.drawingBufferHeight]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.viewport(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1)}}class y_ extends Xm{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindFramebuffer(e.FRAMEBUFFER,t),this.current=t,this.dirty=!1}}class x_ extends Xm{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindRenderbuffer(e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}class v_ extends Xm{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindTexture(e.TEXTURE_2D,t),this.current=t,this.dirty=!1}}class b_ extends Xm{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindBuffer(e.ARRAY_BUFFER,t),this.current=t,this.dirty=!1}}class w_ extends Xm{getDefault(){return null}set(t){const e=this.gl;e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t),this.current=t,this.dirty=!1}}class T_ extends Xm{getDefault(){return null}set(t){var e;if(t===this.current&&!this.dirty)return;const i=this.gl;Rf(i)?i.bindVertexArray(t):null===(e=i.getExtension("OES_vertex_array_object"))||void 0===e||e.bindVertexArrayOES(t),this.current=t,this.dirty=!1}}class P_ extends Xm{getDefault(){return 4}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_ALIGNMENT,t),this.current=t,this.dirty=!1}}class M_ extends Xm{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t),this.current=t,this.dirty=!1}}class C_ extends Xm{getDefault(){return!1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,t),this.current=t,this.dirty=!1}}class I_ extends Xm{constructor(t,e){super(t),this.context=t,this.parent=e}getDefault(){return null}}class S_ extends I_{setDirty(){this.dirty=!0}set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0),this.current=t,this.dirty=!1}}class E_ extends I_{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}class A_ extends I_{set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,e.DEPTH_STENCIL_ATTACHMENT,e.RENDERBUFFER,t),this.current=t,this.dirty=!1}}const z_="Framebuffer is not complete";class k_{constructor(t,e,i,r,n){this.context=t,this.width=e,this.height=i;const s=t.gl,o=this.framebuffer=s.createFramebuffer();if(this.colorAttachment=new S_(t,o),r)this.depthAttachment=n?new A_(t,o):new E_(t,o);else if(n)throw new Error("Stencil cannot be set without depth");if(s.checkFramebufferStatus(s.FRAMEBUFFER)!==s.FRAMEBUFFER_COMPLETE)throw new Error(z_)}destroy(){const t=this.context.gl,e=this.colorAttachment.get();if(e&&t.deleteTexture(e),this.depthAttachment){const e=this.depthAttachment.get();e&&t.deleteRenderbuffer(e)}t.deleteFramebuffer(this.framebuffer)}}class D_{constructor(t){var e,i;if(this.gl=t,this.clearColor=new Km(this),this.clearDepth=new Ym(this),this.clearStencil=new Jm(this),this.colorMask=new Qm(this),this.depthMask=new t_(this),this.stencilMask=new e_(this),this.stencilFunc=new i_(this),this.stencilOp=new r_(this),this.stencilTest=new n_(this),this.depthRange=new s_(this),this.depthTest=new o_(this),this.depthFunc=new a_(this),this.blend=new l_(this),this.blendFunc=new c_(this),this.blendColor=new h_(this),this.blendEquation=new u_(this),this.cullFace=new p_(this),this.cullFaceSide=new d_(this),this.frontFace=new f_(this),this.program=new m_(this),this.activeTexture=new __(this),this.viewport=new g_(this),this.bindFramebuffer=new y_(this),this.bindRenderbuffer=new x_(this),this.bindTexture=new v_(this),this.bindVertexBuffer=new b_(this),this.bindElementBuffer=new w_(this),this.bindVertexArray=new T_(this),this.pixelStoreUnpack=new P_(this),this.pixelStoreUnpackPremultiplyAlpha=new M_(this),this.pixelStoreUnpackFlipY=new C_(this),this.extTextureFilterAnisotropic=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=t.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.maxTextureSize=t.getParameter(t.MAX_TEXTURE_SIZE),Rf(t)){this.HALF_FLOAT=t.HALF_FLOAT;const r=t.getExtension("EXT_color_buffer_half_float");this.RGBA16F=null!==(e=t.RGBA16F)&&void 0!==e?e:null==r?void 0:r.RGBA16F_EXT,this.RGB16F=null!==(i=t.RGB16F)&&void 0!==i?i:null==r?void 0:r.RGB16F_EXT,t.getExtension("EXT_color_buffer_float")}else{t.getExtension("EXT_color_buffer_half_float"),t.getExtension("OES_texture_half_float_linear");const e=t.getExtension("OES_texture_half_float");this.HALF_FLOAT=null==e?void 0:e.HALF_FLOAT_OES}}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault()}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArray.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0}createIndexBuffer(t,e){return new qm(this,t,e)}createVertexBuffer(t,e,i){return new Hm(this,t,e,i)}createRenderbuffer(t,e,i){const r=this.gl,n=r.createRenderbuffer();return this.bindRenderbuffer.set(n),r.renderbufferStorage(r.RENDERBUFFER,t,e,i),this.bindRenderbuffer.set(null),n}createFramebuffer(t,e,i,r){return new k_(this,t,e,i,r)}clear({color:t,depth:e,stencil:i}){const r=this.gl;let n=0;t&&(n|=r.COLOR_BUFFER_BIT,this.clearColor.set(t),this.colorMask.set([!0,!0,!0,!0])),void 0!==e&&(n|=r.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(e),this.depthMask.set(!0)),void 0!==i&&(n|=r.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),r.clear(n)}setCullFace(t){!1===t.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(t.mode),this.frontFace.set(t.frontFace))}setDepthMode(t){t.func!==this.gl.ALWAYS||t.mask?(this.depthTest.set(!0),this.depthFunc.set(t.func),this.depthMask.set(t.mask),this.depthRange.set(t.range)):this.depthTest.set(!1)}setStencilMode(t){t.test.func!==this.gl.ALWAYS||t.mask?(this.stencilTest.set(!0),this.stencilMask.set(t.mask),this.stencilOp.set([t.fail,t.depthFail,t.pass]),this.stencilFunc.set({func:t.test.func,ref:t.ref,mask:t.test.mask})):this.stencilTest.set(!1)}setColorMode(t){It(t.blendFunction,If.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(t.blendFunction),this.blendColor.set(t.blendColor)),this.colorMask.set(t.mask)}createVertexArray(){var t;return Rf(this.gl)?this.gl.createVertexArray():null===(t=this.gl.getExtension("OES_vertex_array_object"))||void 0===t?void 0:t.createVertexArrayOES()}deleteVertexArray(t){var e;return Rf(this.gl)?this.gl.deleteVertexArray(t):null===(e=this.gl.getExtension("OES_vertex_array_object"))||void 0===e?void 0:e.deleteVertexArrayOES(t)}unbindVAO(){this.bindVertexArray.set(null)}}let R_;function L_(t,e,i,r,n){const s=t.context,o=t.transform,a=s.gl,l=t.useProgram("collisionBox"),c=[];let h=0,u=0;for(let p=0;p<r.length;p++){const d=r[p],f=e.getTile(d).getBucket(i);if(!f)continue;const m=n?f.textCollisionBox:f.iconCollisionBox,_=f.collisionCircleArray;_.length>0&&(c.push({circleArray:_,circleOffset:u,coord:d}),h+=_.length/4,u=h),m&&l.draw(s,a.LINES,Af.disabled,kf.disabled,t.colorModeForRenderPass(),Ef.disabled,Tm(t.transform),t.style.map.terrain&&t.style.map.terrain.getTerrainData(d),o.getProjectionData({overscaledTileID:d,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),i.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,null,t.transform.zoom,null,null,m.collisionVertexBuffer)}if(!n||!c.length)return;const p=t.useProgram("collisionCircle"),d=new Ia;d.resize(4*h),d._trim();let f=0;for(const t of c)for(let e=0;e<t.circleArray.length/4;e++){const i=4*e,r=t.circleArray[i+0],n=t.circleArray[i+1],s=t.circleArray[i+2],o=t.circleArray[i+3];d.emplace(f++,r,n,s,o,0),d.emplace(f++,r,n,s,o,1),d.emplace(f++,r,n,s,o,2),d.emplace(f++,r,n,s,o,3)}(!R_||R_.length<2*h)&&(R_=function(t){const e=2*t,i=new Ea;i.resize(e),i._trim();for(let t=0;t<e;t++){const e=6*t;i.uint16[e+0]=4*t+0,i.uint16[e+1]=4*t+1,i.uint16[e+2]=4*t+2,i.uint16[e+3]=4*t+2,i.uint16[e+4]=4*t+3,i.uint16[e+5]=4*t+0}return i}(h));const m=s.createIndexBuffer(R_,!0),_=s.createVertexBuffer(d,Fh.members,!0);for(const e of c){const r=Pm(t.transform);p.draw(s,a.TRIANGLES,Af.disabled,kf.disabled,t.colorModeForRenderPass(),Ef.disabled,r,t.style.map.terrain&&t.style.map.terrain.getTerrainData(e.coord),null,i.id,_,m,La.simpleSegment(0,2*e.circleOffset,e.circleArray.length,e.circleArray.length/2),null,t.transform.zoom,null,null,null)}_.destroy(),m.destroy()}const B_=b(new Float32Array(16));function F_(t,e,i,r,n,s){const{horizontalAlign:o,verticalAlign:a}=tu(t);return new c((-(o-.5)*e/n+r[0])*s,(-(a-.5)*i/n+r[1])*s)}function O_(t,e,i,r,n,s){const o=e.tileAnchorPoint.add(new c(e.translation[0],e.translation[1]));if(e.pitchWithMap){let t=r.mult(s);i||(t=t.rotate(-n));const a=o.add(t);return id(a.x,a.y,e.pitchedLabelPlaneMatrix,e.getElevation).point}if(i){const i=ud(e.tileAnchorPoint.x+1,e.tileAnchorPoint.y,e).point.sub(t),n=Math.atan(i.y/i.x)+(i.x<0?Math.PI:0);return t.add(r.rotate(n))}return t.add(r)}function j_(t,e,i,r,n,s,o,a,l,h,u,p){const d=t.text.placedSymbolArray,f=t.text.dynamicLayoutVertexArray,m=t.icon.dynamicLayoutVertexArray,_={};f.clear();for(let m=0;m<d.length;m++){const g=d.get(m),y=g.hidden||!g.crossTileID||t.allowVerticalPlacement&&!g.placedOrientation?null:r[g.crossTileID];if(y){const r=new c(g.anchorX,g.anchorY),d={getElevation:p,width:n.width,height:n.height,pitchedLabelPlaneMatrix:s,pitchWithMap:i,transform:n,tileAnchorPoint:r,translation:h,unwrappedTileID:u},m=i?dd(r.x,r.y,d):ud(r.x,r.y,d),x=rd(n.cameraToCenterDistance,m.signedDistanceFromCamera);let v=nu(t.textSizeData,a,g)*x/24;i&&(v*=t.tilePixelRatio/o);const{width:b,height:w,anchor:T,textOffset:P,textBoxScale:M}=y,C=F_(T,b,w,P,M,v),I=n.getPitchedTextCorrection(r.x+h[0],r.y+h[1],u),S=O_(m.point,d,e,C,-n.bearingInRadians,I),E=t.allowVerticalPlacement&&g.placedOrientation===Qh.vertical?Math.PI/2:0;for(let t=0;t<g.numGlyphs;t++)hu(f,S,E);l&&g.associatedIconIndex>=0&&(_[g.associatedIconIndex]={shiftedAnchor:S,angle:E})}else yd(g.numGlyphs,f)}if(l){m.clear();const e=t.icon.placedSymbolArray;for(let t=0;t<e.length;t++){const i=e.get(t);if(i.hidden)yd(i.numGlyphs,m);else{const e=_[t];if(e)for(let t=0;t<i.numGlyphs;t++)hu(m,e.shiftedAnchor,e.angle);else yd(i.numGlyphs,m)}}t.icon.dynamicLayoutVertexBuffer.updateData(m)}t.text.dynamicLayoutVertexBuffer.updateData(f)}function V_(t,e,i){return i.iconsInText&&e?"symbolTextAndIcon":t?"symbolSDF":"symbolIcon"}function N_(t,e,i,r,n,s,o,a,l,c,h,u,p){const d=t.context,f=d.gl,m=t.transform,_="map"===a,g="map"===l,y="viewport"!==a&&"point"!==i.layout.get("symbol-placement"),v=_&&!g&&!y,b=!i.layout.get("symbol-sort-key").isConstant();let T=!1;const P=t.getDepthModeForSublayer(0,Af.ReadOnly),M=i._unevaluatedLayout.hasValue("text-variable-anchor")||i._unevaluatedLayout.hasValue("text-variable-anchor-offset"),C=[],I=m.getCircleRadiusCorrection();for(const a of r){const r=e.getTile(a),l=r.getBucket(i);if(!l)continue;const h=n?l.text:l.icon;if(!h||!h.segments.get().length||!h.hasVisibleVertices)continue;const u=h.programConfigurations.get(i.id),d=n||l.sdfIcons,P=n?l.textSizeData:l.iconSizeData,S=g||0!==m.pitch,E=t.useProgram(V_(d,n,l),u),A=su(P,m.zoom),z=t.style.map.terrain&&t.style.map.terrain.getTerrainData(a);let k,D,R,L,B=[0,0],F=null;if(n)D=r.glyphAtlasTexture,R=f.LINEAR,k=r.glyphAtlasTexture.size,l.iconsInText&&(B=r.imageAtlasTexture.size,F=r.imageAtlasTexture,L=S||t.options.rotating||t.options.zooming||"composite"===P.kind||"camera"===P.kind?f.LINEAR:f.NEAREST);else{const e=1!==i.layout.get("icon-size").constantOr(0)||l.iconsNeedLinear;D=r.imageAtlasTexture,R=d||t.options.rotating||t.options.zooming||e||S?f.LINEAR:f.NEAREST,k=r.imageAtlasTexture.size}const O=Q(r,1,t.transform.zoom),j=Qp(_,t.transform,O),V=x();w(V,j);const N=td(g,_,t.transform,O),U=st(m,r,s,o),Z=m.getProjectionData({overscaledTileID:a,applyGlobeMatrix:!p,applyTerrainMatrix:!0}),G=M&&l.hasTextData(),$="none"!==i.layout.get("icon-text-fit")&&G&&l.hasIconData();if(y){const e=t.style.map.terrain?(e,i)=>t.style.map.terrain.getElevation(a,e,i):null,r="map"===i.layout.get("text-rotation-alignment");sd(l,t,n,j,V,g,c,r,a.toUnwrapped(),m.width,m.height,U,e)}const q=n&&M||$,W=y||q?B_:g?j:t.transform.clipSpaceToPixelsMatrix,H=d&&0!==i.paint.get(n?"text-halo-width":"icon-halo-width").constantOr(1);let X;X=d?l.iconsInText?Nm(P.kind,A,v,g,y,q,t,W,N,U,k,B,I):Vm(P.kind,A,v,g,y,q,t,W,N,U,n,k,0,I):jm(P.kind,A,v,g,y,q,t,W,N,U,n,k,I);const K={program:E,buffers:h,uniformValues:X,projectionData:Z,atlasTexture:D,atlasTextureIcon:F,atlasInterpolation:R,atlasInterpolationIcon:L,isSDF:d,hasHalo:H};if(b&&l.canOverlap){T=!0;const t=h.segments.get();for(const e of t)C.push({segments:new La([e]),sortKey:e.sortKey,state:K,terrainData:z})}else C.push({segments:h.segments,sortKey:0,state:K,terrainData:z})}T&&C.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of C){const r=e.state;if(d.activeTexture.set(f.TEXTURE0),r.atlasTexture.bind(r.atlasInterpolation,f.CLAMP_TO_EDGE),r.atlasTextureIcon&&(d.activeTexture.set(f.TEXTURE1),r.atlasTextureIcon&&r.atlasTextureIcon.bind(r.atlasInterpolationIcon,f.CLAMP_TO_EDGE)),r.isSDF){const n=r.uniformValues;r.hasHalo&&(n.u_is_halo=1,U_(r.buffers,e.segments,i,t,r.program,P,h,u,n,r.projectionData,e.terrainData)),n.u_is_halo=0}U_(r.buffers,e.segments,i,t,r.program,P,h,u,r.uniformValues,r.projectionData,e.terrainData)}}function U_(t,e,i,r,n,s,o,a,l,c,h){const u=r.context;n.draw(u,u.gl.TRIANGLES,s,o,a,Ef.backCCW,l,h,c,i.id,t.layoutVertexBuffer,t.indexBuffer,e,i.paint,r.transform.zoom,t.programConfigurations.get(i.id),t.dynamicLayoutVertexBuffer,t.opacityVertexBuffer)}function Z_(t,e,i,r,n){const s=t.context,o=s.gl,a=kf.disabled,l=new If([o.ONE,o.ONE],bi.transparent,[!0,!0,!0,!0]),c=e.getBucket(i);if(!c)return;const h=r.key;let u=i.heatmapFbos.get(h);u||(u=$_(s,e.tileSize,e.tileSize),i.heatmapFbos.set(h,u)),s.bindFramebuffer.set(u.framebuffer),s.viewport.set([0,0,e.tileSize,e.tileSize]),s.clear({color:bi.transparent});const p=c.programConfigurations.get(i.id),d=t.useProgram("heatmap",p,!n),f=t.transform.getProjectionData({overscaledTileID:e.tileID,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),m=t.style.map.terrain.getTerrainData(r);d.draw(s,o.TRIANGLES,Af.disabled,a,l,Ef.disabled,Cm(e,t.transform.zoom,i.paint.get("heatmap-intensity"),1),m,f,i.id,c.layoutVertexBuffer,c.indexBuffer,c.segments,i.paint,t.transform.zoom,p)}function G_(t,e,i,r,n){const s=t.context,o=s.gl,a=t.transform;s.setColorMode(t.colorModeForRenderPass());const l=q_(s,e),c=i.key,h=e.heatmapFbos.get(c);if(!h)return;s.activeTexture.set(o.TEXTURE0),o.bindTexture(o.TEXTURE_2D,h.colorAttachment.get()),s.activeTexture.set(o.TEXTURE1),l.bind(o.LINEAR,o.CLAMP_TO_EDGE);const u=a.getProjectionData({overscaledTileID:i,applyTerrainMatrix:n,applyGlobeMatrix:!r});t.useProgram("heatmapTexture").draw(s,o.TRIANGLES,Af.disabled,kf.disabled,t.colorModeForRenderPass(),Ef.disabled,Im(t,e,0,1),null,u,e.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments,e.paint,a.zoom),h.destroy(),e.heatmapFbos.delete(c)}function $_(t,e,i){var r,n;const s=t.gl,o=s.createTexture();s.bindTexture(s.TEXTURE_2D,o),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,s.LINEAR),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,s.LINEAR);const a=null!==(r=t.HALF_FLOAT)&&void 0!==r?r:s.UNSIGNED_BYTE,l=null!==(n=t.RGBA16F)&&void 0!==n?n:s.RGBA;s.texImage2D(s.TEXTURE_2D,0,l,e,i,0,s.RGBA,a,null);const c=t.createFramebuffer(e,i,!1,!1);return c.colorAttachment.set(o),c}function q_(t,e){return e.colorRampTexture||(e.colorRampTexture=new Au(t,e.colorRamp,t.gl.RGBA)),e.colorRampTexture}function W_(t,e,i,r,n){if(!i||!r||!r.imageAtlas)return;const s=r.imageAtlas.patternPositions;let o=s[i.to.toString()],a=s[i.from.toString()];if(!o&&a&&(o=a),!a&&o&&(a=o),!o||!a){const t=n.getPaintProperty(e);o=s[t],a=s[t]}o&&a&&t.setConstantPatternPositions(o,a)}function H_(t,e,i,r,n,s,o,a){const l=t.context.gl,c="fill-pattern",h=i.paint.get(c),u=h&&h.constantOr(1),p=i.getCrossfadeParameters();let d,f,m,_,g;const y=t.transform,x=i.paint.get("fill-translate"),v=i.paint.get("fill-translate-anchor");o?(f=u&&!i.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",d=l.LINES):(f=u?"fillPattern":"fill",d=l.TRIANGLES);const b=h.constantOr(null);for(const h of r){const w=e.getTile(h);if(u&&!w.patternsLoaded())continue;const T=w.getBucket(i);if(!T)continue;const P=T.programConfigurations.get(i.id),M=t.useProgram(f,P),C=t.style.map.terrain&&t.style.map.terrain.getTerrainData(h);u&&(t.context.activeTexture.set(l.TEXTURE0),w.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),P.updatePaintBuffers(p)),W_(P,c,b,w,i);const I=y.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!a,applyTerrainMatrix:!0}),S=st(y,w,x,v);if(o){_=T.indexBuffer2,g=T.segments2;const e=[l.drawingBufferWidth,l.drawingBufferHeight];m="fillOutlinePattern"===f&&u?bm(t,p,w,e,S):vm(e,S)}else _=T.indexBuffer,g=T.segments,m=u?ym(t,p,w,S):xm(S);let E;if("translucent"===t.renderPass&&a){const[e]=t.getStencilConfigForOverlapAndUpdateStencilID(r);E=e[h.overscaledZ]}else E=t.stencilModeForClipping(h);M.draw(t.context,d,n,E,s,Ef.backCCW,m,C,I,i.id,T.layoutVertexBuffer,_,g,i.paint,t.transform.zoom,P)}}function X_(t,e,i,r,n,s,o,a){const l=t.context,c=l.gl,h="fill-extrusion-pattern",u=i.paint.get(h),p=u.constantOr(1),d=i.getCrossfadeParameters(),f=i.paint.get("fill-extrusion-opacity"),m=u.constantOr(null),_=t.transform;for(const u of r){const r=e.getTile(u),g=r.getBucket(i);if(!g)continue;const y=t.style.map.terrain&&t.style.map.terrain.getTerrainData(u),x=g.programConfigurations.get(i.id),v=t.useProgram(p?"fillExtrusionPattern":"fillExtrusion",x);p&&(t.context.activeTexture.set(c.TEXTURE0),r.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),x.updatePaintBuffers(d));const b=_.getProjectionData({overscaledTileID:u,applyGlobeMatrix:!a,applyTerrainMatrix:!0});W_(x,h,m,r,i);const w=st(_,r,i.paint.get("fill-extrusion-translate"),i.paint.get("fill-extrusion-translate-anchor")),T=i.paint.get("fill-extrusion-vertical-gradient"),P=p?gm(t,T,f,w,u,d,r):_m(t,T,f,w);v.draw(l,l.gl.TRIANGLES,n,s,o,Ef.backCCW,P,y,b,i.id,g.layoutVertexBuffer,g.indexBuffer,g.segments,i.paint,t.transform.zoom,x,t.style.map.terrain&&g.centroidVertexBuffer)}}function K_(t,e,i,r,n,s,o,a,l){var c;const h=t.style.projection,u=t.context,p=t.transform,d=u.gl,f=t.useProgram("hillshade"),m=!t.options.moving;for(const _ of r){const r=e.getTile(_),g=r.fbo;if(!g)continue;const y=h.getMeshFromTileID(u,_.canonical,a,!0,"raster"),x=null===(c=t.style.map.terrain)||void 0===c?void 0:c.getTerrainData(_);u.activeTexture.set(d.TEXTURE0),d.bindTexture(d.TEXTURE_2D,g.colorAttachment.get());const v=p.getProjectionData({overscaledTileID:_,aligned:m,applyGlobeMatrix:!l,applyTerrainMatrix:!0});f.draw(u,d.TRIANGLES,s,n[_.overscaledZ],o,Ef.backCCW,Sm(t,r,i),x,v,i.id,y.vertexBuffer,y.indexBuffer,y.segments)}}const Y_=[new c(0,0),new c(J,0),new c(J,J),new c(0,J)];function J_(t,e,i,r,n,s,o,a,l=!1,c=!1){const h=r[r.length-1].overscaledZ,u=t.context,p=u.gl,d=t.useProgram("raster"),f=t.transform,m=t.style.projection,_=t.colorModeForRenderPass(),g=!t.options.moving;for(const y of r){const r=t.getDepthModeForSublayer(y.overscaledZ-h,1===i.paint.get("raster-opacity")?Af.ReadWrite:Af.ReadOnly,p.LESS),x=e.getTile(y);x.registerFadeDuration(i.paint.get("raster-fade-duration"));const v=e.findLoadedParent(y,0),b=e.findLoadedSibling(y),w=Q_(x,v||b||null,e,i,t.transform,t.style.map.terrain);let T,P;const M="nearest"===i.paint.get("raster-resampling")?p.NEAREST:p.LINEAR;u.activeTexture.set(p.TEXTURE0),x.texture.bind(M,p.CLAMP_TO_EDGE,p.LINEAR_MIPMAP_NEAREST),u.activeTexture.set(p.TEXTURE1),v?(v.texture.bind(M,p.CLAMP_TO_EDGE,p.LINEAR_MIPMAP_NEAREST),T=Math.pow(2,v.tileID.overscaledZ-x.tileID.overscaledZ),P=[x.tileID.canonical.x*T%1,x.tileID.canonical.y*T%1]):x.texture.bind(M,p.CLAMP_TO_EDGE,p.LINEAR_MIPMAP_NEAREST),x.texture.useMipmap&&u.extTextureFilterAnisotropic&&t.transform.pitch>20&&p.texParameterf(p.TEXTURE_2D,u.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,u.extTextureFilterAnisotropicMax);const C=t.style.map.terrain&&t.style.map.terrain.getTerrainData(y),I=f.getProjectionData({overscaledTileID:y,aligned:g,applyGlobeMatrix:!c,applyTerrainMatrix:!0}),S=Fm(P||[0,0],T||1,w,i,a),E=m.getMeshFromTileID(u,y.canonical,s,o,"raster");d.draw(u,p.TRIANGLES,r,n?n[y.overscaledZ]:kf.disabled,_,l?Ef.frontCCW:Ef.backCCW,S,C,I,i.id,E.vertexBuffer,E.indexBuffer,E.segments)}}function Q_(t,e,i,r,n,s){const o=r.paint.get("raster-fade-duration");if(!s&&o>0){const r=Wt.now(),s=(r-t.timeAdded)/o,a=e?(r-e.timeAdded)/o:-1,l=i.getSource(),c=$p(n,{tileSize:l.tileSize,roundZoom:l.roundZoom}),h=!e||Math.abs(e.tileID.overscaledZ-c)>Math.abs(t.tileID.overscaledZ-c),u=h&&t.refreshedUponExpiration?1:gt(h?s:1-a,0,1);return t.refreshedUponExpiration&&s>=1&&(t.refreshedUponExpiration=!1),e?{opacity:1,mix:1-u}:{opacity:u,mix:0}}return{opacity:1,mix:0}}const tg=new bi(1,0,0,1),eg=new bi(0,1,0,1),ig=new bi(0,0,1,1),rg=new bi(1,0,1,1),ng=new bi(0,1,1,1);function sg(t,e,i,r){ag(t,0,e+i/2,t.transform.width,i,r)}function og(t,e,i,r){ag(t,e-i/2,0,i,t.transform.height,r)}function ag(t,e,i,r,n,s){const o=t.context,a=o.gl;a.enable(a.SCISSOR_TEST),a.scissor(e*t.pixelRatio,i*t.pixelRatio,r*t.pixelRatio,n*t.pixelRatio),o.clear({color:s}),a.disable(a.SCISSOR_TEST)}function lg(t,e,i){const r=t.context,n=r.gl,s=t.useProgram("debug"),o=Af.disabled,a=kf.disabled,l=t.colorModeForRenderPass(),c="$debug",h=t.style.map.terrain&&t.style.map.terrain.getTerrainData(i);r.activeTexture.set(n.TEXTURE0);const u=e.getTileByID(i.key).latestRawTileData,p=Math.floor((u&&u.byteLength||0)/1024),d=e.getTile(i).tileSize,f=512/Math.min(d,512)*(i.overscaledZ/t.transform.zoom)*.5;let m=i.canonical.toString();i.overscaledZ!==i.canonical.z&&(m+=` => ${i.overscaledZ}`),function(t,e){t.initDebugOverlayCanvas();const i=t.debugOverlayCanvas,r=t.context.gl,n=t.debugOverlayCanvas.getContext("2d");n.clearRect(0,0,i.width,i.height),n.shadowColor="white",n.shadowBlur=2,n.lineWidth=1.5,n.strokeStyle="white",n.textBaseline="top",n.font="bold 36px Open Sans, sans-serif",n.fillText(e,5,5),n.strokeText(e,5,5),t.debugOverlayTexture.update(i),t.debugOverlayTexture.bind(r.LINEAR,r.CLAMP_TO_EDGE)}(t,`${m} ${p}kB`);const _=t.transform.getProjectionData({overscaledTileID:i,applyGlobeMatrix:!0,applyTerrainMatrix:!0});s.draw(r,n.TRIANGLES,o,a,If.alphaBlended,Ef.disabled,Mm(bi.transparent,f),null,_,c,t.debugBuffer,t.quadTriangleIndexBuffer,t.debugSegments),s.draw(r,n.LINE_STRIP,o,a,l,Ef.disabled,Mm(bi.red),h,_,c,t.debugBuffer,t.tileBorderIndexBuffer,t.debugSegments)}function cg(t,e,i,r){const{isRenderingGlobe:n}=r,s=t.context,o=s.gl,a=t.transform,l=t.colorModeForRenderPass(),c=t.getDepthModeFor3D(),h=t.useProgram("terrain");s.bindFramebuffer.set(null),s.viewport.set([0,0,t.width,t.height]);for(const r of i){const i=e.getTerrainMesh(r.tileID),u=t.renderToTexture.getTexture(r),p=e.getTerrainData(r.tileID);s.activeTexture.set(o.TEXTURE0),o.bindTexture(o.TEXTURE_2D,u.texture);const d=e.getMeshFrameDelta(a.zoom),f=a.calculateFogMatrix(r.tileID.toUnwrapped()),m=um(d,f,t.style.sky,a.pitch,n),_=a.getProjectionData({overscaledTileID:r.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});h.draw(s,o.TRIANGLES,c,kf.disabled,l,Ef.backCCW,m,p,_,"terrain",i.vertexBuffer,i.indexBuffer,i.segments)}}function hg(t,e){if(!e.mesh){const i=new fa;i.emplaceBack(-1,-1),i.emplaceBack(1,-1),i.emplaceBack(1,1),i.emplaceBack(-1,1);const r=new Aa;r.emplaceBack(0,1,2),r.emplaceBack(0,2,3),e.mesh=new sf(t.createVertexBuffer(i,of.members),t.createIndexBuffer(r),La.simpleSegment(0,0,i.length,r.length))}return e.mesh}class ug{constructor(t,e){this.context=new D_(t),this.transform=e,this._tileTextures={},this.terrainFacilitator={dirty:!0,matrix:b(new Float64Array(16)),renderTime:0},this.setup(),this.numSublayers=Wp.maxUnderzooming+Wp.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new tf}resize(t,e,i){if(this.width=Math.floor(t*i),this.height=Math.floor(e*i),this.pixelRatio=i,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const t of this.style._order)this.style._layers[t].resize()}setup(){const t=this.context,e=new fa;e.emplaceBack(0,0),e.emplaceBack(J,0),e.emplaceBack(0,J),e.emplaceBack(J,J),this.tileExtentBuffer=t.createVertexBuffer(e,of.members),this.tileExtentSegments=La.simpleSegment(0,0,4,2);const i=new fa;i.emplaceBack(0,0),i.emplaceBack(J,0),i.emplaceBack(0,J),i.emplaceBack(J,J),this.debugBuffer=t.createVertexBuffer(i,of.members),this.debugSegments=La.simpleSegment(0,0,4,5);const r=new _a;r.emplaceBack(0,0,0,0),r.emplaceBack(J,0,J,0),r.emplaceBack(0,J,0,J),r.emplaceBack(J,J,J,J),this.rasterBoundsBuffer=t.createVertexBuffer(r,cm.members),this.rasterBoundsSegments=La.simpleSegment(0,0,4,2);const n=new fa;n.emplaceBack(0,0),n.emplaceBack(J,0),n.emplaceBack(0,J),n.emplaceBack(J,J),this.rasterBoundsBufferPosOnly=t.createVertexBuffer(n,of.members),this.rasterBoundsSegmentsPosOnly=La.simpleSegment(0,0,4,5);const s=new fa;s.emplaceBack(0,0),s.emplaceBack(1,0),s.emplaceBack(0,1),s.emplaceBack(1,1),this.viewportBuffer=t.createVertexBuffer(s,of.members),this.viewportSegments=La.simpleSegment(0,0,4,2);const o=new ka;o.emplaceBack(0),o.emplaceBack(1),o.emplaceBack(3),o.emplaceBack(2),o.emplaceBack(0),this.tileBorderIndexBuffer=t.createIndexBuffer(o);const a=new Aa;a.emplaceBack(1,0,2),a.emplaceBack(1,2,3),this.quadTriangleIndexBuffer=t.createIndexBuffer(a);const l=this.context.gl;this.stencilClearMode=new kf({func:l.ALWAYS,mask:0},0,255,l.ZERO,l.ZERO,l.ZERO),this.tileExtentMesh=new sf(this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments)}clearStencil(){const t=this.context,e=t.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const i=x();A(i,0,this.width,this.height,0,0,1),M(i,i,[e.drawingBufferWidth,e.drawingBufferHeight,0]);const r={mainMatrix:i,tileMercatorCoords:[0,0,1,1],clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:i};this.useProgram("clippingMask",null,!0).draw(t,e.TRIANGLES,Af.disabled,this.stencilClearMode,If.disabled,Ef.disabled,null,null,r,"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments)}_renderTileClippingMasks(t,e,i){if(this.currentStencilSource===t.source||!t.isTileClipped()||!e||!e.length)return;this.currentStencilSource=t.source,this.nextStencilID+e.length>256&&this.clearStencil();const r=this.context;r.setColorMode(If.disabled),r.setDepthMode(Af.disabled);const n={};for(const t of e)n[t.key]=this.nextStencilID++;this._renderTileMasks(n,e,i,!0),this._renderTileMasks(n,e,i,!1),this._tileClippingMaskIDs=n}_renderTileMasks(t,e,i,r){const n=this.context,s=n.gl,o=this.style.projection,a=this.transform,l=this.useProgram("clippingMask");for(const c of e){const e=t[c.key],h=this.style.map.terrain&&this.style.map.terrain.getTerrainData(c),u=o.getMeshFromTileID(this.context,c.canonical,r,!0,"stencil"),p=a.getProjectionData({overscaledTileID:c,applyGlobeMatrix:!0,applyTerrainMatrix:!0});l.draw(n,s.TRIANGLES,Af.disabled,new kf({func:s.ALWAYS,mask:0},e,255,s.KEEP,s.KEEP,s.REPLACE),If.disabled,i?Ef.disabled:Ef.backCCW,null,h,p,"$clipping",u.vertexBuffer,u.indexBuffer,u.segments)}}_renderTilesDepthBuffer(){const t=this.context,e=t.gl,i=this.style.projection,r=this.transform,n=this.useProgram("depth"),s=this.getDepthModeFor3D(),o=qp(r,{tileSize:r.tileSize});for(const a of o){const o=this.style.map.terrain&&this.style.map.terrain.getTerrainData(a),l=i.getMeshFromTileID(this.context,a.canonical,!0,!0,"raster"),c=r.getProjectionData({overscaledTileID:a,applyGlobeMatrix:!0,applyTerrainMatrix:!0});n.draw(t,e.TRIANGLES,s,kf.disabled,If.disabled,Ef.backCCW,null,o,c,"$clipping",l.vertexBuffer,l.indexBuffer,l.segments)}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const t=this.nextStencilID++,e=this.context.gl;return new kf({func:e.NOTEQUAL,mask:255},t,255,e.KEEP,e.KEEP,e.REPLACE)}stencilModeForClipping(t){const e=this.context.gl;return new kf({func:e.EQUAL,mask:255},this._tileClippingMaskIDs[t.key],0,e.KEEP,e.KEEP,e.REPLACE)}getStencilConfigForOverlapAndUpdateStencilID(t){const e=this.context.gl,i=t.sort(((t,e)=>e.overscaledZ-t.overscaledZ)),r=i[i.length-1].overscaledZ,n=i[0].overscaledZ-r+1;if(n>1){this.currentStencilSource=void 0,this.nextStencilID+n>256&&this.clearStencil();const t={};for(let i=0;i<n;i++)t[i+r]=new kf({func:e.GEQUAL,mask:255},i+this.nextStencilID,255,e.KEEP,e.KEEP,e.REPLACE);return this.nextStencilID+=n,[t,i]}return[{[r]:kf.disabled},i]}stencilConfigForOverlapTwoPass(t){const e=this.context.gl,i=t.sort(((t,e)=>e.overscaledZ-t.overscaledZ)),r=i[i.length-1].overscaledZ,n=i[0].overscaledZ-r+1;if(this.clearStencil(),n>1){const t={},s={};for(let i=0;i<n;i++)t[i+r]=new kf({func:e.GREATER,mask:255},n+1+i,255,e.KEEP,e.KEEP,e.REPLACE),s[i+r]=new kf({func:e.GREATER,mask:255},1+i,255,e.KEEP,e.KEEP,e.REPLACE);return this.nextStencilID=2*n+1,[t,s,i]}return this.nextStencilID=3,[{[r]:new kf({func:e.GREATER,mask:255},2,255,e.KEEP,e.KEEP,e.REPLACE)},{[r]:new kf({func:e.GREATER,mask:255},1,255,e.KEEP,e.KEEP,e.REPLACE)},i]}colorModeForRenderPass(){const t=this.context.gl;if(this._showOverdrawInspector){const e=1/8;return new If([t.CONSTANT_COLOR,t.ONE],new bi(e,e,e,0),[!0,!0,!0,!0])}return"opaque"===this.renderPass?If.unblended:If.alphaBlended}getDepthModeForSublayer(t,e,i){if(!this.opaquePassEnabledForLayer())return Af.disabled;const r=1-((1+this.currentLayer)*this.numSublayers+t)*this.depthEpsilon;return new Af(i||this.context.gl.LEQUAL,e,[r,r])}getDepthModeFor3D(){return new Af(this.context.gl.LEQUAL,Af.ReadWrite,this.depthRangeFor3D)}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(t,e){var i,r;this.style=t,this.options=e,this.lineAtlas=t.lineAtlas,this.imageManager=t.imageManager,this.glyphManager=t.glyphManager,this.symbolFadeChange=t.placement.symbolFadeChange(Wt.now()),this.imageManager.beginFrame();const n=this.style._order,s=this.style.sourceCaches,o={},a={},l={},c={isRenderingToTexture:!1,isRenderingGlobe:(null===(i=t.projection)||void 0===i?void 0:i.transitionState)>0};for(const t in s){const e=s[t];e.used&&e.prepare(this.context),o[t]=e.getVisibleCoordinates(!1),a[t]=o[t].slice().reverse(),l[t]=e.getVisibleCoordinates(!0).reverse()}this.opaquePassCutoff=1/0;for(let t=0;t<n.length;t++)if(this.style._layers[n[t]].is3D()){this.opaquePassCutoff=t;break}this.maybeDrawDepthAndCoords(!1),this.renderToTexture&&(this.renderToTexture.prepareForRender(this.style,this.transform.zoom),this.opaquePassCutoff=0),this.renderPass="offscreen";for(const t of n){const e=this.style._layers[t];if(!e.hasOffscreenPass()||e.isHidden(this.transform.zoom))continue;const i=a[e.source];("custom"===e.type||i.length)&&this.renderLayer(this,s[e.source],e,i,c)}if(null===(r=this.style.projection)||void 0===r||r.updateGPUdependent({context:this.context,useProgram:t=>this.useProgram(t)}),this.context.viewport.set([0,0,this.width,this.height]),this.context.bindFramebuffer.set(null),this.context.clear({color:e.showOverdrawInspector?bi.black:bi.transparent,depth:1}),this.clearStencil(),this.style.sky&&function(t,e){const i=t.context,r=i.gl,n=((t,e,i)=>{const r=Math.cos(e.rollInRadians),n=Math.sin(e.rollInRadians),s=pf(e),o=e.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}).projectionTransition;return{u_sky_color:t.properties.get("sky-color"),u_horizon_color:t.properties.get("horizon-color"),u_horizon:[(e.width/2-s*n)*i,(e.height/2+s*r)*i],u_horizon_normal:[-n,r],u_sky_horizon_blend:t.properties.get("sky-horizon-blend")*e.height/2*i,u_sky_blend:o}})(e,t.style.map.transform,t.pixelRatio),s=new Af(r.LEQUAL,Af.ReadWrite,[0,1]),o=kf.disabled,a=t.colorModeForRenderPass(),l=t.useProgram("sky"),c=hg(i,e);l.draw(i,r.TRIANGLES,s,o,a,Ef.disabled,n,null,void 0,"sky",c.vertexBuffer,c.indexBuffer,c.segments)}(this,this.style.sky),this._showOverdrawInspector=e.showOverdrawInspector,this.depthRangeFor3D=[0,1-(t._order.length+2)*this.numSublayers*this.depthEpsilon],!this.renderToTexture)for(this.renderPass="opaque",this.currentLayer=n.length-1;this.currentLayer>=0;this.currentLayer--){const t=this.style._layers[n[this.currentLayer]],e=s[t.source],i=o[t.source];this._renderTileClippingMasks(t,i,!1),this.renderLayer(this,e,t,i,c)}this.renderPass="translucent";let h=!1;for(this.currentLayer=0;this.currentLayer<n.length;this.currentLayer++){const t=this.style._layers[n[this.currentLayer]],e=s[t.source];if(this.renderToTexture&&this.renderToTexture.renderLayer(t,c))continue;this.opaquePassEnabledForLayer()||h||(h=!0,c.isRenderingGlobe&&!this.style.map.terrain&&this._renderTilesDepthBuffer());const i=("symbol"===t.type?l:a)[t.source];this._renderTileClippingMasks(t,o[t.source],!1),this.renderLayer(this,e,t,i,c)}if(c.isRenderingGlobe&&function(t,e,i){const r=t.context,n=r.gl,s=t.useProgram("atmosphere"),o=new Af(n.LEQUAL,Af.ReadOnly,[0,1]),a=t.transform,l=function(t,e){const i=t.properties.get("position"),r=[-i.x,-i.y,-i.z],n=b(new Float64Array(16));var s,o,a,l,c,h,u;return"map"===t.properties.get("anchor")&&(S(n,n,e.rollInRadians),C(n,n,-e.pitchInRadians),S(n,n,e.bearingInRadians),C(n,n,e.center.lat*Math.PI/180),I(n,n,-e.center.lng*Math.PI/180)),(s=r)[0]=((a=n)[0]*(l=(o=r)[0])+a[4]*(c=o[1])+a[8]*(h=o[2])+a[12])/(u=(u=a[3]*l+a[7]*c+a[11]*h+a[15])||1),s[1]=(a[1]*l+a[5]*c+a[9]*h+a[13])/u,s[2]=(a[2]*l+a[6]*c+a[10]*h+a[14])/u,r}(i,t.transform),c=a.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),h=e.properties.get("atmosphere-blend")*c.projectionTransition;if(0===h)return;const u=$f(a.worldSize,a.center.lat),p=a.inverseProjectionMatrix,d=new Float64Array(4);d[3]=1,G(d,d,a.modelViewProjectionMatrix),d[0]/=d[3],d[1]/=d[3],d[2]/=d[3],d[3]=1,G(d,d,p),d[0]/=d[3],d[1]/=d[3],d[2]/=d[3],d[3]=1;const f=((t,e,i,r,n)=>({u_sun_pos:t,u_atmosphere_blend:e,u_globe_position:i,u_globe_radius:r,u_inv_proj_matrix:n}))(l,h,[d[0],d[1],d[2]],u,p),m=hg(r,e);s.draw(r,n.TRIANGLES,o,kf.disabled,If.alphaBlended,Ef.disabled,f,null,null,"atmosphere",m.vertexBuffer,m.indexBuffer,m.segments)}(this,this.style.sky,this.style.light),this.options.showTileBoundaries){const t=function(t,e){let i=null;const r=Object.values(t._layers).flatMap((i=>i.source&&!i.isHidden(e)?[t.sourceCaches[i.source]]:[])),n=r.filter((t=>"vector"===t.getSource().type)),s=r.filter((t=>"vector"!==t.getSource().type)),o=t=>{(!i||i.getSource().maxzoom<t.getSource().maxzoom)&&(i=t)};return n.forEach((t=>o(t))),i||s.forEach((t=>o(t))),i}(this.style,this.transform.zoom);t&&function(t,e,i){for(let r=0;r<i.length;r++)lg(t,e,i[r])}(this,t,t.getVisibleCoordinates())}this.options.showPadding&&function(t){const e=t.transform.padding;sg(t,t.transform.height-(e.top||0),3,tg),sg(t,e.bottom||0,3,eg),og(t,e.left||0,3,ig),og(t,t.transform.width-(e.right||0),3,rg);const i=t.transform.centerPoint;!function(t,e,i,r){ag(t,e-1,i-10,2,20,r),ag(t,e-10,i-1,20,2,r)}(t,i.x,t.transform.height-i.y,ng)}(this),this.context.setDefault()}maybeDrawDepthAndCoords(t){if(!this.style||!this.style.map||!this.style.map.terrain)return;const e=this.terrainFacilitator.matrix,i=this.transform.modelViewProjectionMatrix;let r=this.terrainFacilitator.dirty;var n,s;r||(r=t?!((n=e)[0]===(s=i)[0]&&n[1]===s[1]&&n[2]===s[2]&&n[3]===s[3]&&n[4]===s[4]&&n[5]===s[5]&&n[6]===s[6]&&n[7]===s[7]&&n[8]===s[8]&&n[9]===s[9]&&n[10]===s[10]&&n[11]===s[11]&&n[12]===s[12]&&n[13]===s[13]&&n[14]===s[14]&&n[15]===s[15]):!function(t,e){var i=t[0],r=t[1],n=t[2],s=t[3],o=t[4],a=t[5],l=t[6],c=t[7],h=t[8],u=t[9],p=t[10],d=t[11],f=t[12],_=t[13],g=t[14],y=t[15],x=e[0],v=e[1],b=e[2],w=e[3],T=e[4],P=e[5],M=e[6],C=e[7],I=e[8],S=e[9],E=e[10],A=e[11],z=e[12],k=e[13],D=e[14],R=e[15];return Math.abs(i-x)<=m*Math.max(1,Math.abs(i),Math.abs(x))&&Math.abs(r-v)<=m*Math.max(1,Math.abs(r),Math.abs(v))&&Math.abs(n-b)<=m*Math.max(1,Math.abs(n),Math.abs(b))&&Math.abs(s-w)<=m*Math.max(1,Math.abs(s),Math.abs(w))&&Math.abs(o-T)<=m*Math.max(1,Math.abs(o),Math.abs(T))&&Math.abs(a-P)<=m*Math.max(1,Math.abs(a),Math.abs(P))&&Math.abs(l-M)<=m*Math.max(1,Math.abs(l),Math.abs(M))&&Math.abs(c-C)<=m*Math.max(1,Math.abs(c),Math.abs(C))&&Math.abs(h-I)<=m*Math.max(1,Math.abs(h),Math.abs(I))&&Math.abs(u-S)<=m*Math.max(1,Math.abs(u),Math.abs(S))&&Math.abs(p-E)<=m*Math.max(1,Math.abs(p),Math.abs(E))&&Math.abs(d-A)<=m*Math.max(1,Math.abs(d),Math.abs(A))&&Math.abs(f-z)<=m*Math.max(1,Math.abs(f),Math.abs(z))&&Math.abs(_-k)<=m*Math.max(1,Math.abs(_),Math.abs(k))&&Math.abs(g-D)<=m*Math.max(1,Math.abs(g),Math.abs(D))&&Math.abs(y-R)<=m*Math.max(1,Math.abs(y),Math.abs(R))}(e,i)),r||(r=this.style.map.terrain.sourceCache.anyTilesAfterTime(this.terrainFacilitator.renderTime)),r&&(function(t,e){t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]}(e,i),this.terrainFacilitator.renderTime=Date.now(),this.terrainFacilitator.dirty=!1,function(t,e){const i=t.context,r=i.gl,n=t.transform,s=If.unblended,o=new Af(r.LEQUAL,Af.ReadWrite,[0,1]),a=e.sourceCache.getRenderableTiles(),l=t.useProgram("terrainDepth");i.bindFramebuffer.set(e.getFramebuffer("depth").framebuffer),i.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),i.clear({color:bi.transparent,depth:1});for(const t of a){const a=e.getTerrainMesh(t.tileID),c=e.getTerrainData(t.tileID),h=n.getProjectionData({overscaledTileID:t.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0}),u={u_ele_delta:e.getMeshFrameDelta(n.zoom)};l.draw(i,r.TRIANGLES,o,kf.disabled,s,Ef.backCCW,u,c,h,"terrain",a.vertexBuffer,a.indexBuffer,a.segments)}i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height])}(this,this.style.map.terrain),function(t,e){const i=t.context,r=i.gl,n=t.transform,s=If.unblended,o=new Af(r.LEQUAL,Af.ReadWrite,[0,1]),a=e.getCoordsTexture(),l=e.sourceCache.getRenderableTiles(),c=t.useProgram("terrainCoords");i.bindFramebuffer.set(e.getFramebuffer("coords").framebuffer),i.viewport.set([0,0,t.width/devicePixelRatio,t.height/devicePixelRatio]),i.clear({color:bi.transparent,depth:1}),e.coordsIndex=[];for(const t of l){const l=e.getTerrainMesh(t.tileID),h=e.getTerrainData(t.tileID);i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,a.texture);const u={u_terrain_coords_id:(255-e.coordsIndex.length)/255,u_texture:0,u_ele_delta:e.getMeshFrameDelta(n.zoom)},p=n.getProjectionData({overscaledTileID:t.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});c.draw(i,r.TRIANGLES,o,kf.disabled,s,Ef.backCCW,u,h,p,"terrain",l.vertexBuffer,l.indexBuffer,l.segments),e.coordsIndex.push(t.tileID.key)}i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height])}(this,this.style.map.terrain))}renderLayer(t,e,i,r,n){i.isHidden(this.transform.zoom)||("background"===i.type||"custom"===i.type||(r||[]).length)&&(this.id=i.id,(t=>"symbol"===t.type)(i)?function(t,e,i,r,n,s){if("translucent"!==t.renderPass)return;const{isRenderingToTexture:o}=s,a=kf.disabled,l=t.colorModeForRenderPass();(i._unevaluatedLayout.hasValue("text-variable-anchor")||i._unevaluatedLayout.hasValue("text-variable-anchor-offset"))&&function(t,e,i,r,n,s,o,a,l){const c=e.transform,h=e.style.map.terrain,u="map"===n,p="map"===s;for(const n of t){const t=r.getTile(n),s=t.getBucket(i);if(!s||!s.text||!s.text.segments.get().length)continue;const d=su(s.textSizeData,c.zoom),f=Q(t,1,e.transform.zoom),m=Qp(u,e.transform,f),_="none"!==i.layout.get("icon-text-fit")&&s.hasIconData();if(d){const e=Math.pow(2,c.zoom-t.tileID.overscaledZ),i=h?(t,e)=>h.getElevation(n,t,e):null;j_(s,u,p,l,c,m,e,d,_,st(c,t,o,a),n.toUnwrapped(),i)}}}(r,t,i,e,i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),n),0!==i.paint.get("icon-opacity").constantOr(1)&&N_(t,e,i,r,!1,i.paint.get("icon-translate"),i.paint.get("icon-translate-anchor"),i.layout.get("icon-rotation-alignment"),i.layout.get("icon-pitch-alignment"),i.layout.get("icon-keep-upright"),a,l,o),0!==i.paint.get("text-opacity").constantOr(1)&&N_(t,e,i,r,!0,i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.layout.get("text-keep-upright"),a,l,o),e.map.showCollisionBoxes&&(L_(t,e,i,r,!0),L_(t,e,i,r,!1))}(t,e,i,r,this.style.placement.variableOffsets,n):(t=>"circle"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;const{isRenderingToTexture:s}=n,o=i.paint.get("circle-opacity"),a=i.paint.get("circle-stroke-width"),l=i.paint.get("circle-stroke-opacity"),c=!i.layout.get("circle-sort-key").isConstant();if(0===o.constantOr(1)&&(0===a.constantOr(1)||0===l.constantOr(1)))return;const h=t.context,u=h.gl,p=t.transform,d=t.getDepthModeForSublayer(0,Af.ReadOnly),f=kf.disabled,m=t.colorModeForRenderPass(),_=[],g=p.getCircleRadiusCorrection();for(let n=0;n<r.length;n++){const o=r[n],a=e.getTile(o),l=a.getBucket(i);if(!l)continue;const h=st(p,a,i.paint.get("circle-translate"),i.paint.get("circle-translate-anchor")),u=l.programConfigurations.get(i.id),d=t.useProgram("circle",u),f=l.layoutVertexBuffer,m=l.indexBuffer,y=t.style.map.terrain&&t.style.map.terrain.getTerrainData(o),x={programConfiguration:u,program:d,layoutVertexBuffer:f,indexBuffer:m,uniformValues:wm(t,a,i,h,g),terrainData:y,projectionData:p.getProjectionData({overscaledTileID:o,applyGlobeMatrix:!s,applyTerrainMatrix:!0})};if(c){const t=l.segments.get();for(const e of t)_.push({segments:new La([e]),sortKey:e.sortKey,state:x})}else _.push({segments:l.segments,sortKey:0,state:x})}c&&_.sort(((t,e)=>t.sortKey-e.sortKey));for(const e of _){const{programConfiguration:r,program:n,layoutVertexBuffer:s,indexBuffer:o,uniformValues:a,terrainData:l,projectionData:c}=e.state;n.draw(h,u.TRIANGLES,d,f,m,Ef.backCCW,a,l,c,i.id,s,o,e.segments,i.paint,t.transform.zoom,r)}}(t,e,i,r,n):(t=>"heatmap"===t.type)(i)?function(t,e,i,r,n){if(0===i.paint.get("heatmap-opacity"))return;const s=t.context,{isRenderingToTexture:o,isRenderingGlobe:a}=n;if(t.style.map.terrain){for(const n of r){const r=e.getTile(n);e.hasRenderableParent(n)||("offscreen"===t.renderPass?Z_(t,r,i,n,a):"translucent"===t.renderPass&&G_(t,i,n,o,a))}s.viewport.set([0,0,t.width,t.height])}else"offscreen"===t.renderPass?function(t,e,i,r){const n=t.context,s=n.gl,o=t.transform,a=kf.disabled,l=new If([s.ONE,s.ONE],bi.transparent,[!0,!0,!0,!0]);(function(t,e,i){const r=t.gl;t.activeTexture.set(r.TEXTURE1),t.viewport.set([0,0,e.width/4,e.height/4]);let n=i.heatmapFbos.get(Kl);n?(r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),t.bindFramebuffer.set(n.framebuffer)):(n=$_(t,e.width/4,e.height/4),i.heatmapFbos.set(Kl,n))})(n,t,i),n.clear({color:bi.transparent});for(let c=0;c<r.length;c++){const h=r[c];if(e.hasRenderableParent(h))continue;const u=e.getTile(h),p=u.getBucket(i);if(!p)continue;const d=p.programConfigurations.get(i.id),f=t.useProgram("heatmap",d),m=o.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!0,applyTerrainMatrix:!1}),_=o.getCircleRadiusCorrection();f.draw(n,s.TRIANGLES,Af.disabled,a,l,Ef.backCCW,Cm(u,o.zoom,i.paint.get("heatmap-intensity"),_),null,m,i.id,p.layoutVertexBuffer,p.indexBuffer,p.segments,i.paint,o.zoom,d)}n.viewport.set([0,0,t.width,t.height])}(t,e,i,r):"translucent"===t.renderPass&&function(t,e){const i=t.context,r=i.gl;i.setColorMode(t.colorModeForRenderPass());const n=e.heatmapFbos.get(Kl);n&&(i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),i.activeTexture.set(r.TEXTURE1),q_(i,e).bind(r.LINEAR,r.CLAMP_TO_EDGE),t.useProgram("heatmapTexture").draw(i,r.TRIANGLES,Af.disabled,kf.disabled,t.colorModeForRenderPass(),Ef.disabled,Im(t,e,0,1),null,null,e.id,t.viewportBuffer,t.quadTriangleIndexBuffer,t.viewportSegments,e.paint,t.transform.zoom))}(t,i)}(t,e,i,r,n):(t=>"line"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;const{isRenderingToTexture:s}=n,o=i.paint.get("line-opacity"),a=i.paint.get("line-width");if(0===o.constantOr(1)||0===a.constantOr(1))return;const l=t.getDepthModeForSublayer(0,Af.ReadOnly),c=t.colorModeForRenderPass(),h=i.paint.get("line-dasharray"),u=i.paint.get("line-pattern"),p=u.constantOr(1),d=i.paint.get("line-gradient"),f=i.getCrossfadeParameters(),m=p?"linePattern":h?"lineSDF":d?"lineGradient":"line",_=t.context,g=_.gl,y=t.transform;let x=!0;for(const n of r){const o=e.getTile(n);if(p&&!o.patternsLoaded())continue;const a=o.getBucket(i);if(!a)continue;const b=a.programConfigurations.get(i.id),w=t.context.program.get(),T=t.useProgram(m,b),P=x||T.program!==w,M=t.style.map.terrain&&t.style.map.terrain.getTerrainData(n),C=u.constantOr(null);if(C&&o.imageAtlas){const t=o.imageAtlas,e=t.patternPositions[C.to.toString()],i=t.patternPositions[C.from.toString()];e&&i&&b.setConstantPatternPositions(e,i)}const I=y.getProjectionData({overscaledTileID:n,applyGlobeMatrix:!s,applyTerrainMatrix:!0}),S=y.getPixelScale(),E=p?Dm(t,o,i,S,f):h?Rm(t,o,i,S,h,f):d?km(t,o,i,S,a.lineClipsArray.length):zm(t,o,i,S);if(p)_.activeTexture.set(g.TEXTURE0),o.imageAtlasTexture.bind(g.LINEAR,g.CLAMP_TO_EDGE),b.updatePaintBuffers(f);else if(h&&(P||t.lineAtlas.dirty))_.activeTexture.set(g.TEXTURE0),t.lineAtlas.bind(_);else if(d){const r=a.gradients[i.id];let s=r.texture;if(i.gradientVersion!==r.version){let o=256;if(i.stepInterpolant){const i=e.getSource().maxzoom,r=n.canonical.z===i?Math.ceil(1<<t.transform.maxZoom-n.canonical.z):1;o=gt((v=a.maxLineLength/J*1024*r)<=1?1:Math.pow(2,Math.ceil(Math.log(v)/Math.LN2)),256,_.maxTextureSize)}r.gradient=Xl({expression:i.gradientExpression(),evaluationKey:"lineProgress",resolution:o,image:r.gradient||void 0,clips:a.lineClipsArray}),r.texture?r.texture.update(r.gradient):r.texture=new Au(_,r.gradient,g.RGBA),r.version=i.gradientVersion,s=r.texture}_.activeTexture.set(g.TEXTURE0),s.bind(i.stepInterpolant?g.NEAREST:g.LINEAR,g.CLAMP_TO_EDGE)}let A;if(s){const[e]=t.getStencilConfigForOverlapAndUpdateStencilID(r);A=e[n.overscaledZ]}else A=t.stencilModeForClipping(n);T.draw(_,g.TRIANGLES,l,A,c,Ef.disabled,E,M,I,i.id,a.layoutVertexBuffer,a.indexBuffer,a.segments,i.paint,t.transform.zoom,b,a.layoutVertexBuffer2),x=!1}var v}(t,e,i,r,n):(t=>"fill"===t.type)(i)?function(t,e,i,r,n){const s=i.paint.get("fill-color"),o=i.paint.get("fill-opacity");if(0===o.constantOr(1))return;const{isRenderingToTexture:a}=n,l=t.colorModeForRenderPass(),c=i.paint.get("fill-pattern"),h=t.opaquePassEnabledForLayer()&&!c.constantOr(1)&&1===s.constantOr(bi.transparent).a&&1===o.constantOr(0)?"opaque":"translucent";if(t.renderPass===h){const n=t.getDepthModeForSublayer(1,"opaque"===t.renderPass?Af.ReadWrite:Af.ReadOnly);H_(t,e,i,r,n,l,!1,a)}if("translucent"===t.renderPass&&i.paint.get("fill-antialias")){const n=t.getDepthModeForSublayer(i.getPaintProperty("fill-outline-color")?2:0,Af.ReadOnly);H_(t,e,i,r,n,l,!0,a)}}(t,e,i,r,n):(t=>"fill-extrusion"===t.type)(i)?function(t,e,i,r,n){const s=i.paint.get("fill-extrusion-opacity");if(0===s)return;const{isRenderingToTexture:o}=n;if("translucent"===t.renderPass){const n=new Af(t.context.gl.LEQUAL,Af.ReadWrite,t.depthRangeFor3D);if(1!==s||i.paint.get("fill-extrusion-pattern").constantOr(1))X_(t,e,i,r,n,kf.disabled,If.disabled,o),X_(t,e,i,r,n,t.stencilModeFor3D(),t.colorModeForRenderPass(),o);else{const s=t.colorModeForRenderPass();X_(t,e,i,r,n,kf.disabled,s,o)}}}(t,e,i,r,n):(t=>"hillshade"===t.type)(i)?function(t,e,i,r,n){if("offscreen"!==t.renderPass&&"translucent"!==t.renderPass)return;const{isRenderingToTexture:s}=n,o=t.context,a=t.style.projection.useSubdivision,l=t.getDepthModeForSublayer(0,Af.ReadOnly),c=t.colorModeForRenderPass();if("offscreen"===t.renderPass)!function(t,e,i,r,n,s,o){const a=t.context,l=a.gl;for(const c of i){const i=e.getTile(c),h=i.dem;if(!h||!h.data)continue;if(!i.needsHillshadePrepare)continue;const u=h.dim,p=h.stride,d=h.getPixels();if(a.activeTexture.set(l.TEXTURE1),a.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||t.getTileTexture(p),i.demTexture){const t=i.demTexture;t.update(d,{premultiply:!1}),t.bind(l.NEAREST,l.CLAMP_TO_EDGE)}else i.demTexture=new Au(a,d,l.RGBA,{premultiply:!1}),i.demTexture.bind(l.NEAREST,l.CLAMP_TO_EDGE);a.activeTexture.set(l.TEXTURE0);let f=i.fbo;if(!f){const t=new Au(a,{width:u,height:u,data:null},l.RGBA);t.bind(l.LINEAR,l.CLAMP_TO_EDGE),f=i.fbo=a.createFramebuffer(u,u,!0,!1),f.colorAttachment.set(t.texture)}a.bindFramebuffer.set(f.framebuffer),a.viewport.set([0,0,u,u]),t.useProgram("hillshadePrepare").draw(a,l.TRIANGLES,n,s,o,Ef.disabled,Em(i.tileID,h),null,null,r.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments),i.needsHillshadePrepare=!1}}(t,e,r,i,l,kf.disabled,c),o.viewport.set([0,0,t.width,t.height]);else if("translucent"===t.renderPass)if(a){const[n,o,a]=t.stencilConfigForOverlapTwoPass(r);K_(t,e,i,a,n,l,c,!1,s),K_(t,e,i,a,o,l,c,!0,s)}else{const[n,o]=t.getStencilConfigForOverlapAndUpdateStencilID(r);K_(t,e,i,o,n,l,c,!1,s)}}(t,e,i,r,n):(t=>"raster"===t.type)(i)?function(t,e,i,r,n){if("translucent"!==t.renderPass)return;if(0===i.paint.get("raster-opacity"))return;if(!r.length)return;const{isRenderingToTexture:s}=n,o=e.getSource(),a=t.style.projection.useSubdivision;if(o instanceof Cp)J_(t,e,i,r,null,!1,!1,o.tileCoords,o.flippedWindingOrder,s);else if(a){const[n,o,a]=t.stencilConfigForOverlapTwoPass(r);J_(t,e,i,a,n,!1,!0,Y_,!1,s),J_(t,e,i,a,o,!0,!0,Y_,!1,s)}else{const[n,o]=t.getStencilConfigForOverlapAndUpdateStencilID(r);J_(t,e,i,o,n,!1,!0,Y_,!1,s)}}(t,e,i,r,n):(t=>"background"===t.type)(i)?function(t,e,i,r,n){const s=i.paint.get("background-color"),o=i.paint.get("background-opacity");if(0===o)return;const{isRenderingToTexture:a}=n,l=t.context,c=l.gl,h=t.style.projection,u=t.transform,p=u.tileSize,d=i.paint.get("background-pattern");if(t.isPatternMissing(d))return;const f=!d&&1===s.a&&1===o&&t.opaquePassEnabledForLayer()?"opaque":"translucent";if(t.renderPass!==f)return;const m=kf.disabled,_=t.getDepthModeForSublayer(0,"opaque"===f?Af.ReadWrite:Af.ReadOnly),g=t.colorModeForRenderPass(),y=t.useProgram(d?"backgroundPattern":"background"),x=r||qp(u,{tileSize:p,terrain:t.style.map.terrain});d&&(l.activeTexture.set(c.TEXTURE0),t.imageManager.bind(t.context));const v=i.getCrossfadeParameters();for(const e of x){const r=u.getProjectionData({overscaledTileID:e,applyGlobeMatrix:!a,applyTerrainMatrix:!0}),n=d?Zm(o,t,d,{tileID:e,tileSize:p},v):Um(o,s),f=t.style.map.terrain&&t.style.map.terrain.getTerrainData(e),x=h.getMeshFromTileID(l,e.canonical,!1,!0,"raster");y.draw(l,c.TRIANGLES,_,m,g,Ef.backCCW,n,f,r,i.id,x.vertexBuffer,x.indexBuffer,x.segments)}}(t,0,i,r,n):(t=>"custom"===t.type)(i)&&function(t,e,i,r){const{isRenderingGlobe:n}=r,s=t.context,o=i.implementation,a=t.style.projection,l=t.transform,c=l.getProjectionDataForCustomLayer(n),h={farZ:l.farZ,nearZ:l.nearZ,fov:l.fov*Math.PI/180,modelViewProjectionMatrix:l.modelViewProjectionMatrix,projectionMatrix:l.projectionMatrix,shaderData:{variantName:a.shaderVariantName,vertexShaderPrelude:`const float PI = 3.141592653589793;\nuniform mat4 u_projection_matrix;\n${a.shaderPreludeCode.vertexSource}`,define:a.shaderDefine},defaultProjectionData:c},u=o.renderingMode?o.renderingMode:"2d";if("offscreen"===t.renderPass){const e=o.prerender;e&&(t.setCustomLayerDefaults(),s.setColorMode(t.colorModeForRenderPass()),e.call(o,s.gl,h),s.setDirty(),t.setBaseState())}else if("translucent"===t.renderPass){t.setCustomLayerDefaults(),s.setColorMode(t.colorModeForRenderPass()),s.setStencilMode(kf.disabled);const e="3d"===u?t.getDepthModeFor3D():t.getDepthModeForSublayer(0,Af.ReadOnly);s.setDepthMode(e),o.render(s.gl,h),s.setDirty(),t.setBaseState(),s.bindFramebuffer.set(null)}}(t,0,i,n))}saveTileTexture(t){const e=this._tileTextures[t.size[0]];e?e.push(t):this._tileTextures[t.size[0]]=[t]}getTileTexture(t){const e=this._tileTextures[t];return e&&e.length>0?e.pop():null}isPatternMissing(t){if(!t)return!1;if(!t.from||!t.to)return!0;const e=this.imageManager.getPattern(t.from.toString()),i=this.imageManager.getPattern(t.to.toString());return!e||!i}useProgram(t,e,i=!1){this.cache=this.cache||{};const r=!!this.style.map.terrain,n=this.style.projection,s=t+(e?e.cacheKey:"")+`/${i?lf:n.shaderVariantName}`+(this._showOverdrawInspector?"/overdraw":"")+(r?"/terrain":"");return this.cache[s]||(this.cache[s]=new fm(this.context,rf[t],e,$m[t],this._showOverdrawInspector,r,i?rf.projectionMercator:n.shaderPreludeCode,i?af:n.shaderDefine)),this.cache[s]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault()}setBaseState(){const t=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(t.FUNC_ADD)}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new Au(this.context,this.debugOverlayCanvas,this.context.gl.RGBA))}destroy(){this.debugOverlayTexture&&this.debugOverlayTexture.destroy()}overLimit(){const{drawingBufferWidth:t,drawingBufferHeight:e}=this.context.gl;return this.width!==t||this.height!==e}}function pg(t,e){let i,r=!1,n=null,s=null;const o=()=>{n=null,r&&(t.apply(s,i),n=setTimeout(o,e),r=!1)};return(...t)=>(r=!0,s=this,i=t,n||o(),n)}class dg{constructor(t){this._getCurrentHash=()=>{const t=window.location.hash.replace("#","");if(this._hashName){let e;return t.split("&").map((t=>t.split("="))).forEach((t=>{t[0]===this._hashName&&(e=t)})),(e&&e[1]||"").split("/")}return t.split("/")},this._onHashChange=()=>{const t=this._getCurrentHash();if(!this._isValidHash(t))return!1;const e=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(t[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+t[2],+t[1]],zoom:+t[0],bearing:e,pitch:+(t[4]||0)}),!0},this._updateHashUnthrottled=()=>{const t=window.location.href.replace(/(#.*)?$/,this.getHashString());window.history.replaceState(window.history.state,null,t)},this._removeHash=()=>{const t=this._getCurrentHash();if(0===t.length)return;const e=t.join("/");let i=e;i.split("&").length>0&&(i=i.split("&")[0]),this._hashName&&(i=`${this._hashName}=${e}`);let r=window.location.hash.replace(i,"");r.startsWith("#&")?r=r.slice(0,1)+r.slice(2):"#"===r&&(r="");let n=window.location.href.replace(/(#.+)?$/,r);n=n.replace("&&","&"),window.history.replaceState(window.history.state,null,n)},this._updateHash=pg(this._updateHashUnthrottled,300),this._hashName=t&&encodeURIComponent(t)}addTo(t){return this._map=t,addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),this._removeHash(),delete this._map,this}getHashString(t){const e=this._map.getCenter(),i=Math.round(100*this._map.getZoom())/100,r=Math.ceil((i*Math.LN2+Math.log(512/360/.5))/Math.LN10),n=Math.pow(10,r),s=Math.round(e.lng*n)/n,o=Math.round(e.lat*n)/n,a=this._map.getBearing(),l=this._map.getPitch();let c="";if(c+=t?`/${s}/${o}/${i}`:`${i}/${o}/${s}`,(a||l)&&(c+="/"+Math.round(10*a)/10),l&&(c+=`/${Math.round(l)}`),this._hashName){const t=this._hashName;let e=!1;const i=window.location.hash.slice(1).split("&").map((i=>{const r=i.split("=")[0];return r===t?(e=!0,`${r}=${c}`):i})).filter((t=>t));return e||i.push(`${t}=${c}`),`#${i.join("&")}`}return`#${c}`}_isValidHash(t){if(t.length<3||t.some(isNaN))return!1;try{new op(+t[2],+t[1])}catch(t){return!1}const e=+t[0],i=+(t[3]||0),r=+(t[4]||0);return e>=this._map.getMinZoom()&&e<=this._map.getMaxZoom()&&i>=-180&&i<=180&&r>=this._map.getMinPitch()&&r<=this._map.getMaxPitch()}}const fg={linearity:.3,easing:mt(0,0,.3,1)},mg=xt({deceleration:2500,maxSpeed:1400},fg),_g=xt({deceleration:20,maxSpeed:1400},fg),gg=xt({deceleration:1e3,maxSpeed:360},fg),yg=xt({deceleration:1e3,maxSpeed:90},fg),xg=xt({deceleration:1e3,maxSpeed:360},fg);class vg{constructor(t){this._map=t,this.clear()}clear(){this._inertiaBuffer=[]}record(t){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:Wt.now(),settings:t})}_drainInertiaBuffer(){const t=this._inertiaBuffer,e=Wt.now();for(;t.length>0&&e-t[0].time>160;)t.shift()}_onMoveEnd(t){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const e={zoom:0,bearing:0,pitch:0,roll:0,pan:new c(0,0),pinchAround:void 0,around:void 0};for(const{settings:t}of this._inertiaBuffer)e.zoom+=t.zoomDelta||0,e.bearing+=t.bearingDelta||0,e.pitch+=t.pitchDelta||0,e.roll+=t.rollDelta||0,t.panDelta&&e.pan._add(t.panDelta),t.around&&(e.around=t.around),t.pinchAround&&(e.pinchAround=t.pinchAround);const i=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,r={};if(e.pan.mag()){const n=wg(e.pan.mag(),i,xt({},mg,t||{})),s=e.pan.mult(n.amount/e.pan.mag()),o=this._map.cameraHelper.handlePanInertia(s,this._map.transform);r.center=o.easingCenter,r.offset=o.easingOffset,bg(r,n)}if(e.zoom){const t=wg(e.zoom,i,_g);r.zoom=this._map.transform.zoom+t.amount,bg(r,t)}if(e.bearing){const t=wg(e.bearing,i,gg);r.bearing=this._map.transform.bearing+gt(t.amount,-179,179),bg(r,t)}if(e.pitch){const t=wg(e.pitch,i,yg);r.pitch=this._map.transform.pitch+t.amount,bg(r,t)}if(e.roll){const t=wg(e.roll,i,xg);r.roll=this._map.transform.roll+gt(t.amount,-179,179),bg(r,t)}if(r.zoom||r.bearing){const t=void 0===e.pinchAround?e.around:e.pinchAround;r.around=t?this._map.unproject(t):this._map.getCenter()}return this.clear(),xt(r,{noMoveStart:!0})}}function bg(t,e){(!t.duration||t.duration<e.duration)&&(t.duration=e.duration,t.easing=e.easing)}function wg(t,e,i){const{maxSpeed:r,linearity:n,deceleration:s}=i,o=gt(t*n/(e/1e3),-r,r),a=Math.abs(o)/(s*n);return{easing:i.easing,duration:1e3*a,amount:o*(a/2)}}class Tg extends de{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i,r={}){const n=Ht.mousePos(e.getCanvas(),i);super(t,xt({point:n,lngLat:e.unproject(n),originalEvent:i},r)),this._defaultPrevented=!1,this.target=e}}class Pg extends de{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){const r="touchend"===t?i.changedTouches:i.touches,n=Ht.touchPos(e.getCanvasContainer(),r),s=n.map((t=>e.unproject(t))),o=n.reduce(((t,e,i,r)=>t.add(e.div(r.length))),new c(0,0));super(t,{points:n,point:o,lngLats:s,lngLat:e.unproject(o),originalEvent:i}),this._defaultPrevented=!1}}class Mg extends de{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(t,e,i){super(t,{originalEvent:i}),this._defaultPrevented=!1}}class Cg{constructor(t,e){this._map=t,this._clickTolerance=e.clickTolerance}reset(){delete this._mousedownPos}wheel(t){return this._firePreventable(new Mg(t.type,this._map,t))}mousedown(t,e){return this._mousedownPos=e,this._firePreventable(new Tg(t.type,this._map,t))}mouseup(t){this._map.fire(new Tg(t.type,this._map,t))}click(t,e){this._mousedownPos&&this._mousedownPos.dist(e)>=this._clickTolerance||this._map.fire(new Tg(t.type,this._map,t))}dblclick(t){return this._firePreventable(new Tg(t.type,this._map,t))}mouseover(t){this._map.fire(new Tg(t.type,this._map,t))}mouseout(t){this._map.fire(new Tg(t.type,this._map,t))}touchstart(t){return this._firePreventable(new Pg(t.type,this._map,t))}touchmove(t){this._map.fire(new Pg(t.type,this._map,t))}touchend(t){this._map.fire(new Pg(t.type,this._map,t))}touchcancel(t){this._map.fire(new Pg(t.type,this._map,t))}_firePreventable(t){if(this._map.fire(t),t.defaultPrevented)return{}}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class Ig{constructor(t){this._map=t}reset(){this._delayContextMenu=!1,this._ignoreContextMenu=!0,delete this._contextMenuEvent}mousemove(t){this._map.fire(new Tg(t.type,this._map,t))}mousedown(){this._delayContextMenu=!0,this._ignoreContextMenu=!1}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new Tg("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent)}contextmenu(t){this._delayContextMenu?this._contextMenuEvent=t:this._ignoreContextMenu||this._map.fire(new Tg(t.type,this._map,t)),this._map.listens("contextmenu")&&t.preventDefault()}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class Sg{constructor(t){this._map=t}get transform(){return this._map._requestedCameraState||this._map.transform}get center(){return{lng:this.transform.center.lng,lat:this.transform.center.lat}}get zoom(){return this.transform.zoom}get pitch(){return this.transform.pitch}get bearing(){return this.transform.bearing}unproject(t){return this.transform.screenPointToLocation(c.convert(t),this._map.terrain)}}class Eg{constructor(t,e){this._map=t,this._tr=new Sg(t),this._el=t.getCanvasContainer(),this._container=t.getContainer(),this._clickTolerance=e.clickTolerance||1}isEnabled(){return!!this._enabled}isActive(){return!!this._active}enable(){this.isEnabled()||(this._enabled=!0)}disable(){this.isEnabled()&&(this._enabled=!1)}mousedown(t,e){this.isEnabled()&&t.shiftKey&&0===t.button&&(Ht.disableDrag(),this._startPos=this._lastPos=e,this._active=!0)}mousemoveWindow(t,e){if(!this._active)return;const i=e;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const r=this._startPos;this._lastPos=i,this._box||(this._box=Ht.create("div","maplibregl-boxzoom",this._container),this._container.classList.add("maplibregl-crosshair"),this._fireEvent("boxzoomstart",t));const n=Math.min(r.x,i.x),s=Math.max(r.x,i.x),o=Math.min(r.y,i.y),a=Math.max(r.y,i.y);Ht.setTransform(this._box,`translate(${n}px,${o}px)`),this._box.style.width=s-n+"px",this._box.style.height=a-o+"px"}mouseupWindow(t,e){if(!this._active)return;if(0!==t.button)return;const i=this._startPos,r=e;if(this.reset(),Ht.suppressClick(),i.x!==r.x||i.y!==r.y)return this._map.fire(new de("boxzoomend",{originalEvent:t})),{cameraAnimation:t=>t.fitScreenCoordinates(i,r,this._tr.bearing,{linear:!0})};this._fireEvent("boxzoomcancel",t)}keydown(t){this._active&&27===t.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",t))}reset(){this._active=!1,this._container.classList.remove("maplibregl-crosshair"),this._box&&(Ht.remove(this._box),this._box=null),Ht.enableDrag(),delete this._startPos,delete this._lastPos}_fireEvent(t,e){return this._map.fire(new de(t,{originalEvent:e}))}}function Ag(t,e){if(t.length!==e.length)throw new Error(`The number of touches and points are not equal - touches ${t.length}, points ${e.length}`);const i={};for(let r=0;r<t.length;r++)i[t[r].identifier]=e[r];return i}class zg{constructor(t){this.reset(),this.numTouches=t.numTouches}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1}touchstart(t,e,i){(this.centroid||i.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=t.timeStamp),i.length===this.numTouches&&(this.centroid=function(t){const e=new c(0,0);for(const i of t)e._add(i);return e.div(t.length)}(e),this.touches=Ag(i,e)))}touchmove(t,e,i){if(this.aborted||!this.centroid)return;const r=Ag(i,e);for(const t in this.touches){const e=r[t];(!e||e.dist(this.touches[t])>30)&&(this.aborted=!0)}}touchend(t,e,i){if((!this.centroid||t.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const t=!this.aborted&&this.centroid;if(this.reset(),t)return t}}}class kg{constructor(t){this.singleTap=new zg(t),this.numTaps=t.numTaps,this.reset()}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset()}touchstart(t,e,i){this.singleTap.touchstart(t,e,i)}touchmove(t,e,i){this.singleTap.touchmove(t,e,i)}touchend(t,e,i){const r=this.singleTap.touchend(t,e,i);if(r){const e=t.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(r)<30;if(e&&i||this.reset(),this.count++,this.lastTime=t.timeStamp,this.lastTap=r,this.count===this.numTaps)return this.reset(),r}}}class Dg{constructor(t){this._tr=new Sg(t),this._zoomIn=new kg({numTouches:1,numTaps:2}),this._zoomOut=new kg({numTouches:2,numTaps:1}),this.reset()}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset()}touchstart(t,e,i){this._zoomIn.touchstart(t,e,i),this._zoomOut.touchstart(t,e,i)}touchmove(t,e,i){this._zoomIn.touchmove(t,e,i),this._zoomOut.touchmove(t,e,i)}touchend(t,e,i){const r=this._zoomIn.touchend(t,e,i),n=this._zoomOut.touchend(t,e,i),s=this._tr;return r?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:s.zoom+1,around:s.unproject(r)},{originalEvent:t})}):n?(this._active=!0,t.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:e=>e.easeTo({duration:300,zoom:s.zoom-1,around:s.unproject(n)},{originalEvent:t})}):void 0}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class Rg{constructor(t){this._enabled=!!t.enable,this._moveStateManager=t.moveStateManager,this._clickTolerance=t.clickTolerance||1,this._moveFunction=t.move,this._activateOnStart=!!t.activateOnStart,t.assignEvents(this),this.reset()}reset(t){this._active=!1,this._moved=!1,delete this._lastPoint,this._moveStateManager.endMove(t)}_move(...t){const e=this._moveFunction(...t);if(e.bearingDelta||e.pitchDelta||e.rollDelta||e.around||e.panDelta)return this._active=!0,e}dragStart(t,e){this.isEnabled()&&!this._lastPoint&&this._moveStateManager.isValidStartEvent(t)&&(this._moveStateManager.startMove(t),this._lastPoint=Array.isArray(e)?e[0]:e,this._activateOnStart&&this._lastPoint&&(this._active=!0))}dragMove(t,e){if(!this.isEnabled())return;const i=this._lastPoint;if(!i)return;if(t.preventDefault(),!this._moveStateManager.isValidMoveEvent(t))return void this.reset(t);const r=Array.isArray(e)?e[0]:e;return!this._moved&&r.dist(i)<this._clickTolerance?void 0:(this._moved=!0,this._lastPoint=r,this._move(i,r))}dragEnd(t){this.isEnabled()&&this._lastPoint&&this._moveStateManager.isValidEndEvent(t)&&(this._moved&&Ht.suppressClick(),this.reset(t))}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}getClickTolerance(){return this._clickTolerance}}const Lg={0:1,2:2};class Bg{constructor(t){this._correctEvent=t.checkCorrectEvent}startMove(t){const e=Ht.mouseButton(t);this._eventButton=e}endMove(t){delete this._eventButton}isValidStartEvent(t){return this._correctEvent(t)}isValidMoveEvent(t){return!function(t,e){const i=Lg[e];return void 0===t.buttons||(t.buttons&i)!==i}(t,this._eventButton)}isValidEndEvent(t){return Ht.mouseButton(t)===this._eventButton}}class Fg{constructor(){this._firstTouch=void 0}_isOneFingerTouch(t){return 1===t.targetTouches.length}_isSameTouchEvent(t){return t.targetTouches[0].identifier===this._firstTouch}startMove(t){this._firstTouch=t.targetTouches[0].identifier}endMove(t){delete this._firstTouch}isValidStartEvent(t){return this._isOneFingerTouch(t)}isValidMoveEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}isValidEndEvent(t){return this._isOneFingerTouch(t)&&this._isSameTouchEvent(t)}}class Og{constructor(t=new Bg({checkCorrectEvent:()=>!0}),e=new Fg){this.mouseMoveStateManager=t,this.oneFingerTouchMoveStateManager=e}_executeRelevantHandler(t,e,i){return t instanceof MouseEvent?e(t):"undefined"!=typeof TouchEvent&&t instanceof TouchEvent?i(t):void 0}startMove(t){this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.startMove(t)),(t=>this.oneFingerTouchMoveStateManager.startMove(t)))}endMove(t){this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.endMove(t)),(t=>this.oneFingerTouchMoveStateManager.endMove(t)))}isValidStartEvent(t){return this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.isValidStartEvent(t)),(t=>this.oneFingerTouchMoveStateManager.isValidStartEvent(t)))}isValidMoveEvent(t){return this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.isValidMoveEvent(t)),(t=>this.oneFingerTouchMoveStateManager.isValidMoveEvent(t)))}isValidEndEvent(t){return this._executeRelevantHandler(t,(t=>this.mouseMoveStateManager.isValidEndEvent(t)),(t=>this.oneFingerTouchMoveStateManager.isValidEndEvent(t)))}}const jg=t=>{t.mousedown=t.dragStart,t.mousemoveWindow=t.dragMove,t.mouseup=t.dragEnd,t.contextmenu=t=>{t.preventDefault()}};class Vg{constructor(t,e){this._clickTolerance=t.clickTolerance||1,this._map=e,this.reset()}reset(){this._active=!1,this._touches={},this._sum=new c(0,0)}_shouldBePrevented(t){return t<(this._map.cooperativeGestures.isEnabled()?2:1)}touchstart(t,e,i){return this._calculateTransform(t,e,i)}touchmove(t,e,i){if(this._active){if(!this._shouldBePrevented(i.length))return t.preventDefault(),this._calculateTransform(t,e,i);this._map.cooperativeGestures.notifyGestureBlocked("touch_pan",t)}}touchend(t,e,i){this._calculateTransform(t,e,i),this._active&&this._shouldBePrevented(i.length)&&this.reset()}touchcancel(){this.reset()}_calculateTransform(t,e,i){i.length>0&&(this._active=!0);const r=Ag(i,e),n=new c(0,0),s=new c(0,0);let o=0;for(const t in r){const e=r[t],i=this._touches[t];i&&(n._add(e),s._add(e.sub(i)),o++,r[t]=e)}if(this._touches=r,this._shouldBePrevented(o)||!s.mag())return;const a=s.div(o);return this._sum._add(a),this._sum.mag()<this._clickTolerance?void 0:{around:n.div(o),panDelta:a}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class Ng{constructor(){this.reset()}reset(){this._active=!1,delete this._firstTwoTouches}touchstart(t,e,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([e[0],e[1]]))}touchmove(t,e,i){if(!this._firstTwoTouches)return;t.preventDefault();const[r,n]=this._firstTwoTouches,s=Ug(i,e,r),o=Ug(i,e,n);if(!s||!o)return;const a=this._aroundCenter?null:s.add(o).div(2);return this._move([s,o],a,t)}touchend(t,e,i){if(!this._firstTwoTouches)return;const[r,n]=this._firstTwoTouches,s=Ug(i,e,r),o=Ug(i,e,n);s&&o||(this._active&&Ht.suppressClick(),this.reset())}touchcancel(){this.reset()}enable(t){this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around}disable(){this._enabled=!1,this.reset()}isEnabled(){return!!this._enabled}isActive(){return!!this._active}}function Ug(t,e,i){for(let r=0;r<t.length;r++)if(t[r].identifier===i)return e[r]}function Zg(t,e){return Math.log(t/e)/Math.LN2}class Gg extends Ng{reset(){super.reset(),delete this._distance,delete this._startDistance}_start(t){this._startDistance=this._distance=t[0].dist(t[1])}_move(t,e){const i=this._distance;if(this._distance=t[0].dist(t[1]),this._active||!(Math.abs(Zg(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:Zg(this._distance,i),pinchAround:e}}}function $g(t,e){return 180*t.angleWith(e)/Math.PI}class qg extends Ng{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector}_start(t){this._startVector=this._vector=t[0].sub(t[1]),this._minDiameter=t[0].dist(t[1])}_move(t,e,i){const r=this._vector;if(this._vector=t[0].sub(t[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:$g(this._vector,r),pinchAround:e}}_isBelowThreshold(t){this._minDiameter=Math.min(this._minDiameter,t.mag());const e=25/(Math.PI*this._minDiameter)*360,i=$g(t,this._startVector);return Math.abs(i)<e}}function Wg(t){return Math.abs(t.y)>Math.abs(t.x)}class Hg extends Ng{constructor(t){super(),this._currentTouchCount=0,this._map=t}reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints}touchstart(t,e,i){super.touchstart(t,e,i),this._currentTouchCount=i.length}_start(t){this._lastPoints=t,Wg(t[0].sub(t[1]))&&(this._valid=!1)}_move(t,e,i){if(this._map.cooperativeGestures.isEnabled()&&this._currentTouchCount<3)return;const r=t[0].sub(this._lastPoints[0]),n=t[1].sub(this._lastPoints[1]);return this._valid=this.gestureBeginsVertically(r,n,i.timeStamp),this._valid?(this._lastPoints=t,this._active=!0,{pitchDelta:(r.y+n.y)/2*-.5}):void 0}gestureBeginsVertically(t,e,i){if(void 0!==this._valid)return this._valid;const r=t.mag()>=2,n=e.mag()>=2;if(!r&&!n)return;if(!r||!n)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const s=t.y>0==e.y>0;return Wg(t)&&Wg(e)&&s}}const Xg={panStep:100,bearingStep:15,pitchStep:10};class Kg{constructor(t){this._tr=new Sg(t);const e=Xg;this._panStep=e.panStep,this._bearingStep=e.bearingStep,this._pitchStep=e.pitchStep,this._rotationDisabled=!1}reset(){this._active=!1}keydown(t){if(t.altKey||t.ctrlKey||t.metaKey)return;let e=0,i=0,r=0,n=0,s=0;switch(t.keyCode){case 61:case 107:case 171:case 187:e=1;break;case 189:case 109:case 173:e=-1;break;case 37:t.shiftKey?i=-1:(t.preventDefault(),n=-1);break;case 39:t.shiftKey?i=1:(t.preventDefault(),n=1);break;case 38:t.shiftKey?r=1:(t.preventDefault(),s=-1);break;case 40:t.shiftKey?r=-1:(t.preventDefault(),s=1);break;default:return}return this._rotationDisabled&&(i=0,r=0),{cameraAnimation:o=>{const a=this._tr;o.easeTo({duration:300,easeId:"keyboardHandler",easing:Yg,zoom:e?Math.round(a.zoom)+e*(t.shiftKey?2:1):a.zoom,bearing:a.bearing+i*this._bearingStep,pitch:a.pitch+r*this._pitchStep,offset:[-n*this._panStep,-s*this._panStep],center:a.center},{originalEvent:t})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0}enableRotation(){this._rotationDisabled=!1}}function Yg(t){return t*(2-t)}const Jg=4.000244140625;class Qg{constructor(t,e){this._onTimeout=t=>{this._type="wheel",this._delta-=this._lastValue,this._active||this._start(t)},this._map=t,this._tr=new Sg(t),this._triggerRenderFrame=e,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=.0022222222222222222}setZoomRate(t){this._defaultZoomRate=t}setWheelZoomRate(t){this._wheelZoomRate=t}isEnabled(){return!!this._enabled}isActive(){return!!this._active||void 0!==this._finishTimeout}isZooming(){return!!this._zooming}enable(t){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!t&&"center"===t.around)}disable(){this.isEnabled()&&(this._enabled=!1)}_shouldBePrevented(t){return!!this._map.cooperativeGestures.isEnabled()&&!(t.ctrlKey||this._map.cooperativeGestures.isBypassed(t))}wheel(t){if(!this.isEnabled())return;if(this._shouldBePrevented(t))return void this._map.cooperativeGestures.notifyGestureBlocked("wheel_zoom",t);let e=t.deltaMode===WheelEvent.DOM_DELTA_LINE?40*t.deltaY:t.deltaY;const i=Wt.now(),r=i-(this._lastWheelEventTime||0);this._lastWheelEventTime=i,0!==e&&e%Jg==0?this._type="wheel":0!==e&&Math.abs(e)<4?this._type="trackpad":r>400?(this._type=null,this._lastValue=e,this._timeout=setTimeout(this._onTimeout,40,t)):this._type||(this._type=Math.abs(r*e)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,e+=this._lastValue)),t.shiftKey&&e&&(e/=4),this._type&&(this._lastWheelEvent=t,this._delta-=e,this._active||this._start(t)),t.preventDefault()}_start(t){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const e=Ht.mousePos(this._map.getCanvas(),t),i=this._tr;this._aroundPoint=this._aroundCenter?i.transform.locationToScreenPoint(op.convert(i.center)):e,this._frameId||(this._frameId=!0,this._triggerRenderFrame())}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const t=this._tr.transform;if("number"==typeof this._lastExpectedZoom){const e=t.zoom-this._lastExpectedZoom;"number"==typeof this._startZoom&&(this._startZoom+=e),"number"==typeof this._targetZoom&&(this._targetZoom+=e)}if(0!==this._delta){const e="wheel"===this._type&&Math.abs(this._delta)>Jg?this._wheelZoomRate:this._defaultZoomRate;let i=2/(1+Math.exp(-Math.abs(this._delta*e)));this._delta<0&&0!==i&&(i=1/i);const r="number"!=typeof this._targetZoom?t.scale:Tt(this._targetZoom);this._targetZoom=Math.min(t.maxZoom,Math.max(t.minZoom,Pt(r*i))),"wheel"===this._type&&(this._startZoom=t.zoom,this._easing=this._smoothOutEasing(200)),this._delta=0}const e="number"!=typeof this._targetZoom?t.zoom:this._targetZoom,i=this._startZoom,r=this._easing;let n,s=!1;if("wheel"===this._type&&i&&r){const t=Wt.now()-this._lastWheelEventTime,o=Math.min((t+5)/200,1),a=r(o);n=ar.number(i,e,a),o<1?this._frameId||(this._frameId=!0):s=!0}else n=e,s=!0;return this._active=!0,s&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._triggerRenderFrame(),delete this._targetZoom,delete this._lastExpectedZoom,delete this._finishTimeout}),200)),this._lastExpectedZoom=n,{noInertia:!0,needsRenderFrame:!s,zoomDelta:n-t.zoom,around:this._aroundPoint,originalEvent:this._lastWheelEvent}}_smoothOutEasing(t){let e=_t;if(this._prevEase){const t=this._prevEase,i=(Wt.now()-t.start)/t.duration,r=t.easing(i+.01)-t.easing(i),n=.27/Math.sqrt(r*r+1e-4)*.01;e=mt(n,Math.sqrt(.0729-n*n),.25,1)}return this._prevEase={start:Wt.now(),duration:t,easing:e},e}reset(){this._active=!1,this._zooming=!1,delete this._targetZoom,delete this._lastExpectedZoom,this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout)}}class ty{constructor(t,e){this._clickZoom=t,this._tapZoom=e}enable(){this._clickZoom.enable(),this._tapZoom.enable()}disable(){this._clickZoom.disable(),this._tapZoom.disable()}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class ey{constructor(t){this._tr=new Sg(t),this.reset()}reset(){this._active=!1}dblclick(t,e){return t.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:this._tr.zoom+(t.shiftKey?-1:1),around:this._tr.unproject(e)},{originalEvent:t})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class iy{constructor(){this._tap=new kg({numTouches:1,numTaps:1}),this.reset()}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,delete this._tapPoint,this._tap.reset()}touchstart(t,e,i){if(!this._swipePoint)if(this._tapTime){const r=e[0],n=t.timeStamp-this._tapTime<500,s=this._tapPoint.dist(r)<30;n&&s?i.length>0&&(this._swipePoint=r,this._swipeTouch=i[0].identifier):this.reset()}else this._tap.touchstart(t,e,i)}touchmove(t,e,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const r=e[0],n=r.y-this._swipePoint.y;return this._swipePoint=r,t.preventDefault(),this._active=!0,{zoomDelta:n/128}}}else this._tap.touchmove(t,e,i)}touchend(t,e,i){if(this._tapTime)this._swipePoint&&0===i.length&&this.reset();else{const r=this._tap.touchend(t,e,i);r&&(this._tapTime=t.timeStamp,this._tapPoint=r)}}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class ry{constructor(t,e,i){this._el=t,this._mousePan=e,this._touchPan=i}enable(t){this._inertiaOptions=t||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("maplibregl-touch-drag-pan")}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("maplibregl-touch-drag-pan")}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class ny{constructor(t,e,i,r){this._pitchWithRotate=t.pitchWithRotate,this._rollEnabled=t.rollEnabled,this._mouseRotate=e,this._mousePitch=i,this._mouseRoll=r}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable(),this._rollEnabled&&this._mouseRoll.enable()}disable(){this._mouseRotate.disable(),this._mousePitch.disable(),this._mouseRoll.disable()}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())&&(!this._rollEnabled||this._mouseRoll.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()||this._mouseRoll.isActive()}}class sy{constructor(t,e,i,r){this._el=t,this._touchZoom=e,this._touchRotate=i,this._tapDragZoom=r,this._rotationDisabled=!1,this._enabled=!0}enable(t){this._touchZoom.enable(t),this._rotationDisabled||this._touchRotate.enable(t),this._tapDragZoom.enable(),this._el.classList.add("maplibregl-touch-zoom-rotate")}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("maplibregl-touch-zoom-rotate")}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable()}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable()}}class oy{constructor(t,e){this._bypassKey=-1!==navigator.userAgent.indexOf("Mac")?"metaKey":"ctrlKey",this._map=t,this._options=e,this._enabled=!1}isActive(){return!1}reset(){}_setupUI(){if(this._container)return;const t=this._map.getCanvasContainer();t.classList.add("maplibregl-cooperative-gestures"),this._container=Ht.create("div","maplibregl-cooperative-gesture-screen",t);let e=this._map._getUIString("CooperativeGesturesHandler.WindowsHelpText");"metaKey"===this._bypassKey&&(e=this._map._getUIString("CooperativeGesturesHandler.MacHelpText"));const i=this._map._getUIString("CooperativeGesturesHandler.MobileHelpText"),r=document.createElement("div");r.className="maplibregl-desktop-message",r.textContent=e,this._container.appendChild(r);const n=document.createElement("div");n.className="maplibregl-mobile-message",n.textContent=i,this._container.appendChild(n),this._container.setAttribute("aria-hidden","true")}_destroyUI(){this._container&&(Ht.remove(this._container),this._map.getCanvasContainer().classList.remove("maplibregl-cooperative-gestures")),delete this._container}enable(){this._setupUI(),this._enabled=!0}disable(){this._enabled=!1,this._destroyUI()}isEnabled(){return this._enabled}isBypassed(t){return t[this._bypassKey]}notifyGestureBlocked(t,e){this._enabled&&(this._map.fire(new de("cooperativegestureprevented",{gestureType:t,originalEvent:e})),this._container.classList.add("maplibregl-show"),setTimeout((()=>{this._container.classList.remove("maplibregl-show")}),100))}}const ay=t=>t.zoom||t.drag||t.roll||t.pitch||t.rotate;class ly extends de{}function cy(t){return t.panDelta&&t.panDelta.mag()||t.zoomDelta||t.bearingDelta||t.pitchDelta||t.rollDelta}class hy{constructor(t,e){this.handleWindowEvent=t=>{this.handleEvent(t,`${t.type}Window`)},this.handleEvent=(t,e)=>{if("blur"===t.type)return void this.stop(!0);this._updatingCamera=!0;const i="renderFrame"===t.type?void 0:t,r={needsRenderFrame:!1},n={},s={},o=t.touches,a=o?this._getMapTouches(o):void 0,l=a?Ht.touchPos(this._map.getCanvas(),a):Ht.mousePos(this._map.getCanvas(),t);for(const{handlerName:o,handler:c,allowed:h}of this._handlers){if(!c.isEnabled())continue;let u;this._blockedByActive(s,h,o)?c.reset():c[e||t.type]&&(u=c[e||t.type](t,l,a),this.mergeHandlerResult(r,n,u,o,i),u&&u.needsRenderFrame&&this._triggerRenderFrame()),(u||c.isActive())&&(s[o]=c)}const c={};for(const t in this._previousActiveHandlers)s[t]||(c[t]=i);this._previousActiveHandlers=s,(Object.keys(c).length||cy(r))&&(this._changes.push([r,n,c]),this._triggerRenderFrame()),(Object.keys(s).length||cy(r))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:h}=r;h&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],h(this._map))},this._map=t,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new vg(t),this._bearingSnap=e.bearingSnap,this._previousActiveHandlers={},this._eventsInProgress={},this._addDefaultHandlers(e);const i=this._el;this._listeners=[[i,"touchstart",{passive:!0}],[i,"touchmove",{passive:!1}],[i,"touchend",void 0],[i,"touchcancel",void 0],[i,"mousedown",void 0],[i,"mousemove",void 0],[i,"mouseup",void 0],[document,"mousemove",{capture:!0}],[document,"mouseup",void 0],[i,"mouseover",void 0],[i,"mouseout",void 0],[i,"dblclick",void 0],[i,"click",void 0],[i,"keydown",{capture:!1}],[i,"keyup",void 0],[i,"wheel",{passive:!1}],[i,"contextmenu",void 0],[window,"blur",void 0]];for(const[t,e,i]of this._listeners)Ht.addEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i)}destroy(){for(const[t,e,i]of this._listeners)Ht.removeEventListener(t,e,t===document?this.handleWindowEvent:this.handleEvent,i)}_addDefaultHandlers(t){const e=this._map,i=e.getCanvasContainer();this._add("mapEvent",new Cg(e,t));const r=e.boxZoom=new Eg(e,t);this._add("boxZoom",r),t.interactive&&t.boxZoom&&r.enable();const n=e.cooperativeGestures=new oy(e,t.cooperativeGestures);this._add("cooperativeGestures",n),t.cooperativeGestures&&n.enable();const s=new Dg(e),o=new ey(e);e.doubleClickZoom=new ty(o,s),this._add("tapZoom",s),this._add("clickZoom",o),t.interactive&&t.doubleClickZoom&&e.doubleClickZoom.enable();const a=new iy;this._add("tapDragZoom",a);const l=e.touchPitch=new Hg(e);this._add("touchPitch",l),t.interactive&&t.touchPitch&&e.touchPitch.enable(t.touchPitch);const h=()=>e.project(e.getCenter()),u=function({enable:t,clickTolerance:e,aroundCenter:i=!0,minPixelCenterThreshold:r=100,rotateDegreesPerPixelMoved:n=.8},s){const o=new Bg({checkCorrectEvent:t=>0===Ht.mouseButton(t)&&t.ctrlKey||2===Ht.mouseButton(t)&&!t.ctrlKey});return new Rg({clickTolerance:e,move:(t,e)=>{const o=s();if(i&&Math.abs(o.y-t.y)>r)return{bearingDelta:Vt(new c(t.x,e.y),e,o)};let a=(e.x-t.x)*n;return i&&e.y<o.y&&(a=-a),{bearingDelta:a}},moveStateManager:o,enable:t,assignEvents:jg})}(t,h),p=function({enable:t,clickTolerance:e,pitchDegreesPerPixelMoved:i=-.5}){const r=new Bg({checkCorrectEvent:t=>0===Ht.mouseButton(t)&&t.ctrlKey||2===Ht.mouseButton(t)});return new Rg({clickTolerance:e,move:(t,e)=>({pitchDelta:(e.y-t.y)*i}),moveStateManager:r,enable:t,assignEvents:jg})}(t),d=function({enable:t,clickTolerance:e,rollDegreesPerPixelMoved:i=.3},r){const n=new Bg({checkCorrectEvent:t=>2===Ht.mouseButton(t)&&t.ctrlKey});return new Rg({clickTolerance:e,move:(t,e)=>{const n=r();let s=(e.x-t.x)*i;return e.y<n.y&&(s=-s),{rollDelta:s}},moveStateManager:n,enable:t,assignEvents:jg})}(t,h);e.dragRotate=new ny(t,u,p,d),this._add("mouseRotate",u,["mousePitch"]),this._add("mousePitch",p,["mouseRotate","mouseRoll"]),this._add("mouseRoll",d,["mousePitch"]),t.interactive&&t.dragRotate&&e.dragRotate.enable();const f=function({enable:t,clickTolerance:e}){const i=new Bg({checkCorrectEvent:t=>0===Ht.mouseButton(t)&&!t.ctrlKey});return new Rg({clickTolerance:e,move:(t,e)=>({around:e,panDelta:e.sub(t)}),activateOnStart:!0,moveStateManager:i,enable:t,assignEvents:jg})}(t),m=new Vg(t,e);e.dragPan=new ry(i,f,m),this._add("mousePan",f),this._add("touchPan",m,["touchZoom","touchRotate"]),t.interactive&&t.dragPan&&e.dragPan.enable(t.dragPan);const _=new qg,g=new Gg;e.touchZoomRotate=new sy(i,g,_,a),this._add("touchRotate",_,["touchPan","touchZoom"]),this._add("touchZoom",g,["touchPan","touchRotate"]),t.interactive&&t.touchZoomRotate&&e.touchZoomRotate.enable(t.touchZoomRotate);const y=e.scrollZoom=new Qg(e,(()=>this._triggerRenderFrame()));this._add("scrollZoom",y,["mousePan"]),t.interactive&&t.scrollZoom&&e.scrollZoom.enable(t.scrollZoom);const x=e.keyboard=new Kg(e);this._add("keyboard",x),t.interactive&&t.keyboard&&e.keyboard.enable(),this._add("blockableMapEvent",new Ig(e))}_add(t,e,i){this._handlers.push({handlerName:t,handler:e,allowed:i}),this._handlersById[t]=e}stop(t){if(!this._updatingCamera){for(const{handler:t}of this._handlers)t.reset();this._inertia.clear(),this._fireEvents({},{},t),this._changes=[]}}isActive(){for(const{handler:t}of this._handlers)if(t.isActive())return!0;return!1}isZooming(){return!!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return!!this._eventsInProgress.rotate}isMoving(){return Boolean(ay(this._eventsInProgress))||this.isZooming()}_blockedByActive(t,e,i){for(const r in t)if(r!==i&&(!e||e.indexOf(r)<0))return!0;return!1}_getMapTouches(t){const e=[];for(const i of t)this._el.contains(i.target)&&e.push(i);return e}mergeHandlerResult(t,e,i,r,n){if(!i)return;xt(t,i);const s={handlerName:r,originalEvent:i.originalEvent||n};void 0!==i.zoomDelta&&(e.zoom=s),void 0!==i.panDelta&&(e.drag=s),void 0!==i.rollDelta&&(e.roll=s),void 0!==i.pitchDelta&&(e.pitch=s),void 0!==i.bearingDelta&&(e.rotate=s)}_applyChanges(){const t={},e={},i={};for(const[r,n,s]of this._changes)r.panDelta&&(t.panDelta=(t.panDelta||new c(0,0))._add(r.panDelta)),r.zoomDelta&&(t.zoomDelta=(t.zoomDelta||0)+r.zoomDelta),r.bearingDelta&&(t.bearingDelta=(t.bearingDelta||0)+r.bearingDelta),r.pitchDelta&&(t.pitchDelta=(t.pitchDelta||0)+r.pitchDelta),r.rollDelta&&(t.rollDelta=(t.rollDelta||0)+r.rollDelta),void 0!==r.around&&(t.around=r.around),void 0!==r.pinchAround&&(t.pinchAround=r.pinchAround),r.noInertia&&(t.noInertia=r.noInertia),xt(e,n),xt(i,s);this._updateMapTransform(t,e,i),this._changes=[]}_updateMapTransform(t,e,i){const r=this._map,n=r._getTransformForUpdate(),s=r.terrain;if(!(cy(t)||s&&this._terrainMovement))return this._fireEvents(e,i,!0);r._stop(!0);let{panDelta:o,zoomDelta:a,bearingDelta:l,pitchDelta:c,rollDelta:h,around:u,pinchAround:p}=t;void 0!==p&&(u=p),u=u||r.transform.centerPoint,s&&!n.isPointOnMapSurface(u)&&(u=n.centerPoint);const d={panDelta:o,zoomDelta:a,rollDelta:h,pitchDelta:c,bearingDelta:l,around:u};this._map.cameraHelper.useGlobeControls&&!n.isPointOnMapSurface(u)&&(u=n.centerPoint);const f=u.distSqr(n.centerPoint)<.01?n.center:n.screenPointToLocation(o?u.sub(o):u);s?(this._map.cameraHelper.handleMapControlsRollPitchBearingZoom(d,n),this._terrainMovement||!e.drag&&!e.zoom?e.drag&&this._terrainMovement?n.setCenter(n.screenPointToLocation(n.centerPoint.sub(o))):this._map.cameraHelper.handleMapControlsPan(d,n,f):(this._terrainMovement=!0,this._map._elevationFreeze=!0,this._map.cameraHelper.handleMapControlsPan(d,n,f))):(this._map.cameraHelper.handleMapControlsRollPitchBearingZoom(d,n),this._map.cameraHelper.handleMapControlsPan(d,n,f)),r._applyUpdatedTransform(n),this._map._update(),t.noInertia||this._inertia.record(t),this._fireEvents(e,i,!0)}_fireEvents(t,e,i){const r=ay(this._eventsInProgress),n=ay(t),s={};for(const e in t){const{originalEvent:i}=t[e];this._eventsInProgress[e]||(s[`${e}start`]=i),this._eventsInProgress[e]=t[e]}!r&&n&&this._fireEvent("movestart",n.originalEvent);for(const t in s)this._fireEvent(t,s[t]);n&&this._fireEvent("move",n.originalEvent);for(const e in t){const{originalEvent:i}=t[e];this._fireEvent(e,i)}const o={};let a;for(const t in this._eventsInProgress){const{handlerName:i,originalEvent:r}=this._eventsInProgress[t];this._handlersById[i].isActive()||(delete this._eventsInProgress[t],a=e[i]||r,o[`${t}end`]=a)}for(const t in o)this._fireEvent(t,o[t]);const l=ay(this._eventsInProgress),c=(r||n)&&!l;if(c&&this._terrainMovement){this._map._elevationFreeze=!1,this._terrainMovement=!1;const t=this._map._getTransformForUpdate();this._map.getCenterClampedToGround()&&t.recalculateZoomAndCenter(this._map.terrain),this._map._applyUpdatedTransform(t)}if(i&&c){this._updatingCamera=!0;const t=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),e=t=>0!==t&&-this._bearingSnap<t&&t<this._bearingSnap;!t||!t.essential&&Wt.prefersReducedMotion?(this._map.fire(new de("moveend",{originalEvent:a})),e(this._map.getBearing())&&this._map.resetNorth()):(e(t.bearing||this._map.getBearing())&&(t.bearing=0),t.freezeElevation=!0,this._map.easeTo(t,{originalEvent:a})),this._updatingCamera=!1}}_fireEvent(t,e){this._map.fire(new de(t,e?{originalEvent:e}:{}))}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((t=>{delete this._frameId,this.handleEvent(new ly("renderFrame",{timeStamp:t})),this._applyChanges()}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame())}}class uy extends me{constructor(t,e,i){super(),this._renderFrameCallback=()=>{const t=Math.min((Wt.now()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(t)),t<1&&this._easeFrameId?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop()},this._moving=!1,this._zooming=!1,this.transform=t,this._bearingSnap=i.bearingSnap,this.cameraHelper=e,this.on("moveend",(()=>{delete this._requestedCameraState}))}migrateProjection(t,e){t.apply(this.transform),this.transform=t,this.cameraHelper=e}getCenter(){return new op(this.transform.center.lng,this.transform.center.lat)}setCenter(t,e){return this.jumpTo({center:t},e)}getCenterElevation(){return this.transform.elevation}setCenterElevation(t,e){return this.jumpTo({elevation:t},e),this}getCenterClampedToGround(){return this._centerClampedToGround}setCenterClampedToGround(t){this._centerClampedToGround=t}panBy(t,e,i){return t=c.convert(t).mult(-1),this.panTo(this.transform.center,xt({offset:t},e),i)}panTo(t,e,i){return this.easeTo(xt({center:t},e),i)}getZoom(){return this.transform.zoom}setZoom(t,e){return this.jumpTo({zoom:t},e),this}zoomTo(t,e,i){return this.easeTo(xt({zoom:t},e),i)}zoomIn(t,e){return this.zoomTo(this.getZoom()+1,t,e),this}zoomOut(t,e){return this.zoomTo(this.getZoom()-1,t,e),this}getVerticalFieldOfView(){return this.transform.fov}setVerticalFieldOfView(t,e){return t!=this.transform.fov&&(this.transform.setFov(t),this.fire(new de("movestart",e)).fire(new de("move",e)).fire(new de("moveend",e))),this}getBearing(){return this.transform.bearing}setBearing(t,e){return this.jumpTo({bearing:t},e),this}getPadding(){return this.transform.padding}setPadding(t,e){return this.jumpTo({padding:t},e),this}rotateTo(t,e,i){return this.easeTo(xt({bearing:t},e),i)}resetNorth(t,e){return this.rotateTo(0,xt({duration:1e3},t),e),this}resetNorthPitch(t,e){return this.easeTo(xt({bearing:0,pitch:0,roll:0,duration:1e3},t),e),this}snapToNorth(t,e){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(t,e):this}getPitch(){return this.transform.pitch}setPitch(t,e){return this.jumpTo({pitch:t},e),this}getRoll(){return this.transform.roll}setRoll(t,e){return this.jumpTo({roll:t},e),this}cameraForBounds(t,e){t=ap.convert(t).adjustAntiMeridian();const i=e&&e.bearing||0;return this._cameraForBoxAndBearing(t.getNorthWest(),t.getSouthEast(),i,e)}_cameraForBoxAndBearing(t,e,i,r){const n={top:0,bottom:0,right:0,left:0};if("number"==typeof(r=xt({padding:n,offset:[0,0],maxZoom:this.transform.maxZoom},r)).padding){const t=r.padding;r.padding={top:t,bottom:t,right:t,left:t}}const s=xt(n,r.padding);r.padding=s;const o=this.transform,a=new ap(t,e);return this.cameraHelper.cameraForBoxAndBearing(r,s,a,i,o)}fitBounds(t,e,i){return this._fitInternal(this.cameraForBounds(t,e),e,i)}fitScreenCoordinates(t,e,i,r,n){return this._fitInternal(this._cameraForBoxAndBearing(this.transform.screenPointToLocation(c.convert(t)),this.transform.screenPointToLocation(c.convert(e)),i,r),r,n)}_fitInternal(t,e,i){return t?(delete(e=xt(t,e)).padding,e.linear?this.easeTo(e,i):this.flyTo(e,i)):this}jumpTo(t,e){this.stop();const i=this._getTransformForUpdate();let r=!1,n=!1,s=!1;const o=i.zoom;this.cameraHelper.handleJumpToCenterZoom(i,t);const a=i.zoom!==o;return"elevation"in t&&i.elevation!==+t.elevation&&i.setElevation(+t.elevation),"bearing"in t&&i.bearing!==+t.bearing&&(r=!0,i.setBearing(+t.bearing)),"pitch"in t&&i.pitch!==+t.pitch&&(n=!0,i.setPitch(+t.pitch)),"roll"in t&&i.roll!==+t.roll&&(s=!0,i.setRoll(+t.roll)),null==t.padding||i.isPaddingEqual(t.padding)||i.setPadding(t.padding),this._applyUpdatedTransform(i),this.fire(new de("movestart",e)).fire(new de("move",e)),a&&this.fire(new de("zoomstart",e)).fire(new de("zoom",e)).fire(new de("zoomend",e)),r&&this.fire(new de("rotatestart",e)).fire(new de("rotate",e)).fire(new de("rotateend",e)),n&&this.fire(new de("pitchstart",e)).fire(new de("pitch",e)).fire(new de("pitchend",e)),s&&this.fire(new de("rollstart",e)).fire(new de("roll",e)).fire(new de("rollend",e)),this.fire(new de("moveend",e))}calculateCameraOptionsFromTo(t,e,i,r=0){const n=mp.fromLngLat(t,e),s=mp.fromLngLat(i,r),o=s.x-n.x,a=s.y-n.y,l=s.z-n.z,c=Math.hypot(o,a,l);if(0===c)throw new Error("Can't calculate camera options with same From and To");const h=Math.hypot(o,a),u=Pt(this.transform.cameraToCenterDistance/c/this.transform.tileSize),p=180*Math.atan2(o,-a)/Math.PI;let d=180*Math.acos(h/c)/Math.PI;return d=l<0?90-d:90+d,{center:s.toLngLat(),elevation:r,zoom:u,pitch:d,bearing:p}}calculateCameraOptionsFromCameraLngLatAltRotation(t,e,i,r,n){const s=this.transform.calculateCenterFromCameraLngLatAlt(t,e,i,r);return{center:s.center,elevation:s.elevation,zoom:s.zoom,bearing:i,pitch:r,roll:n}}easeTo(t,e){this._stop(!1,t.easeId),(!1===(t=xt({offset:[0,0],duration:500,easing:_t},t)).animate||!t.essential&&Wt.prefersReducedMotion)&&(t.duration=0);const i=this._getTransformForUpdate(),r=this.getBearing(),n=i.pitch,s=i.roll,o="bearing"in t?this._normalizeBearing(t.bearing,r):r,a="pitch"in t?+t.pitch:n,l="roll"in t?this._normalizeBearing(t.roll,s):s,h="padding"in t?t.padding:i.padding,u=c.convert(t.offset);let p,d;t.around&&(p=op.convert(t.around),d=i.locationToScreenPoint(p));const f={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching,rolling:this._rolling},m=this.cameraHelper.handleEaseTo(i,{bearing:o,pitch:a,roll:l,padding:h,around:p,aroundPoint:d,offsetAsPoint:u,offset:t.offset,zoom:t.zoom,center:t.center});return this._rotating=this._rotating||r!==o,this._pitching=this._pitching||a!==n,this._rolling=this._rolling||l!==s,this._padding=!i.isPaddingEqual(h),this._zooming=this._zooming||m.isZooming,this._easeId=t.easeId,this._prepareEase(e,t.noMoveStart,f),this.terrain&&this._prepareElevation(m.elevationCenter),this._ease((r=>{m.easeFunc(r),this.terrain&&!t.freezeElevation&&this._updateElevation(r),this._applyUpdatedTransform(i),this._fireMoveEvents(e)}),(i=>{this.terrain&&t.freezeElevation&&this._finalizeElevation(),this._afterEase(e,i)}),t),this}_prepareEase(t,e,i={}){this._moving=!0,e||i.moving||this.fire(new de("movestart",t)),this._zooming&&!i.zooming&&this.fire(new de("zoomstart",t)),this._rotating&&!i.rotating&&this.fire(new de("rotatestart",t)),this._pitching&&!i.pitching&&this.fire(new de("pitchstart",t)),this._rolling&&!i.rolling&&this.fire(new de("rollstart",t))}_prepareElevation(t){this._elevationCenter=t,this._elevationStart=this.transform.elevation,this._elevationTarget=this.terrain.getElevationForLngLatZoom(t,this.transform.tileZoom),this._elevationFreeze=!0}_updateElevation(t){this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom));const e=this.terrain.getElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);if(t<1&&e!==this._elevationTarget){const i=this._elevationTarget-this._elevationStart;this._elevationStart+=t*(i-(e-(i*t+this._elevationStart))/(1-t)),this._elevationTarget=e}this.transform.setElevation(ar.number(this._elevationStart,this._elevationTarget,t))}_finalizeElevation(){this._elevationFreeze=!1,this.getCenterClampedToGround()&&this.transform.recalculateZoomAndCenter(this.terrain)}_getTransformForUpdate(){return this.transformCameraUpdate||this.terrain?(this._requestedCameraState||(this._requestedCameraState=this.transform.clone()),this._requestedCameraState):this.transform}_elevateCameraIfInsideTerrain(t){if(!this.terrain&&t.elevation>=0&&t.pitch<=90)return{};const e=t.getCameraLngLat(),i=t.getCameraAltitude(),r=this.terrain?this.terrain.getElevationForLngLatZoom(e,t.zoom):0;if(i<r){const i=this.calculateCameraOptionsFromTo(e,r,t.center,t.elevation);return{pitch:i.pitch,zoom:i.zoom}}return{}}_applyUpdatedTransform(t){const e=[];if(e.push((t=>this._elevateCameraIfInsideTerrain(t))),this.transformCameraUpdate&&e.push((t=>this.transformCameraUpdate(t))),!e.length)return;const i=t.clone();for(const t of e){const e=i.clone(),{center:r,zoom:n,roll:s,pitch:o,bearing:a,elevation:l}=t(e);r&&e.setCenter(r),void 0!==l&&e.setElevation(l),void 0!==n&&e.setZoom(n),void 0!==s&&e.setRoll(s),void 0!==o&&e.setPitch(o),void 0!==a&&e.setBearing(a),i.apply(e)}this.transform.apply(i)}_fireMoveEvents(t){this.fire(new de("move",t)),this._zooming&&this.fire(new de("zoom",t)),this._rotating&&this.fire(new de("rotate",t)),this._pitching&&this.fire(new de("pitch",t)),this._rolling&&this.fire(new de("roll",t))}_afterEase(t,e){if(this._easeId&&e&&this._easeId===e)return;delete this._easeId;const i=this._zooming,r=this._rotating,n=this._pitching,s=this._rolling;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._rolling=!1,this._padding=!1,i&&this.fire(new de("zoomend",t)),r&&this.fire(new de("rotateend",t)),n&&this.fire(new de("pitchend",t)),s&&this.fire(new de("rollend",t)),this.fire(new de("moveend",t))}flyTo(t,e){if(!t.essential&&Wt.prefersReducedMotion){const i=vt(t,["center","zoom","bearing","pitch","roll","elevation"]);return this.jumpTo(i,e)}this.stop(),t=xt({offset:[0,0],speed:1.2,curve:1.42,easing:_t},t);const i=this._getTransformForUpdate(),r=i.bearing,n=i.pitch,s=i.roll,o=i.padding,a="bearing"in t?this._normalizeBearing(t.bearing,r):r,l="pitch"in t?+t.pitch:n,h="roll"in t?this._normalizeBearing(t.roll,s):s,u="padding"in t?t.padding:i.padding,p=c.convert(t.offset);let d=i.centerPoint.add(p);const f=i.screenPointToLocation(d),m=this.cameraHelper.handleFlyTo(i,{bearing:a,pitch:l,roll:h,padding:u,locationAtOffset:f,offsetAsPoint:p,center:t.center,minZoom:t.minZoom,zoom:t.zoom});let _=t.curve;const g=Math.max(i.width,i.height),y=g/m.scaleOfZoom,x=m.pixelPathLength;"number"==typeof m.scaleOfMinZoom&&(_=Math.sqrt(g/m.scaleOfMinZoom/x*2));const v=_*_;function b(t){const e=(y*y-g*g+(t?-1:1)*v*v*x*x)/(2*(t?y:g)*v*x);return Math.log(Math.sqrt(e*e+1)-e)}function w(t){return(Math.exp(t)-Math.exp(-t))/2}function T(t){return(Math.exp(t)+Math.exp(-t))/2}const P=b(!1);let M=function(t){return T(P)/T(P+_*t)},C=function(t){return g*((T(P)*(w(e=P+_*t)/T(e))-w(P))/v)/x;var e},I=(b(!0)-P)/_;if(Math.abs(x)<2e-6||!isFinite(I)){if(Math.abs(g-y)<1e-6)return this.easeTo(t,e);const i=y<g?-1:1;I=Math.abs(Math.log(y/g))/_,C=()=>0,M=t=>Math.exp(i*_*t)}return t.duration="duration"in t?+t.duration:1e3*I/("screenSpeed"in t?+t.screenSpeed/_:+t.speed),t.maxDuration&&t.duration>t.maxDuration&&(t.duration=0),this._zooming=!0,this._rotating=r!==a,this._pitching=l!==n,this._rolling=h!==s,this._padding=!i.isPaddingEqual(u),this._prepareEase(e,!1),this.terrain&&this._prepareElevation(m.targetCenter),this._ease((c=>{const f=c*I,_=1/M(f),g=C(f);this._rotating&&i.setBearing(ar.number(r,a,c)),this._pitching&&i.setPitch(ar.number(n,l,c)),this._rolling&&i.setRoll(ar.number(s,h,c)),this._padding&&(i.interpolatePadding(o,u,c),d=i.centerPoint.add(p)),m.easeFunc(c,_,g,d),this.terrain&&!t.freezeElevation&&this._updateElevation(c),this._applyUpdatedTransform(i),this._fireMoveEvents(e)}),(()=>{this.terrain&&t.freezeElevation&&this._finalizeElevation(),this._afterEase(e)}),t),this}isEasing(){return!!this._easeFrameId}stop(){return this._stop()}_stop(t,e){var i;if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const t=this._onEaseEnd;delete this._onEaseEnd,t.call(this,e)}return t||null===(i=this.handlers)||void 0===i||i.stop(!1),this}_ease(t,e,i){!1===i.animate||0===i.duration?(t(1),e()):(this._easeStart=Wt.now(),this._easeOptions=i,this._onEaseFrame=t,this._onEaseEnd=e,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback))}_normalizeBearing(t,e){t=yt(t,-180,180);const i=Math.abs(t-e);return Math.abs(t-360-e)<i&&(t-=360),Math.abs(t+360-e)<i&&(t+=360),t}queryTerrainElevation(t){return this.terrain?this.terrain.getElevationForLngLatZoom(op.convert(t),this.transform.tileZoom):null}}const py={compact:!0,customAttribution:'<a href="https://maplibre.org/" target="_blank">MapLibre</a>'};class dy{constructor(t=py){this._toggleAttribution=()=>{this._container.classList.contains("maplibregl-compact")&&(this._container.classList.contains("maplibregl-compact-show")?(this._container.setAttribute("open",""),this._container.classList.remove("maplibregl-compact-show")):(this._container.classList.add("maplibregl-compact-show"),this._container.removeAttribute("open")))},this._updateData=t=>{!t||"metadata"!==t.sourceDataType&&"visibility"!==t.sourceDataType&&"style"!==t.dataType&&"terrain"!==t.type||this._updateAttributions()},this._updateCompact=()=>{this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1===this._compact?this._container.setAttribute("open",""):this._container.classList.contains("maplibregl-compact")||this._container.classList.contains("maplibregl-attrib-empty")||(this._container.setAttribute("open",""),this._container.classList.add("maplibregl-compact","maplibregl-compact-show")):(this._container.setAttribute("open",""),this._container.classList.contains("maplibregl-compact")&&this._container.classList.remove("maplibregl-compact","maplibregl-compact-show"))},this._updateCompactMinimize=()=>{this._container.classList.contains("maplibregl-compact")&&this._container.classList.contains("maplibregl-compact-show")&&this._container.classList.remove("maplibregl-compact-show")},this.options=t}getDefaultPosition(){return"bottom-right"}onAdd(t){return this._map=t,this._compact=this.options.compact,this._container=Ht.create("details","maplibregl-ctrl maplibregl-ctrl-attrib"),this._compactButton=Ht.create("summary","maplibregl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=Ht.create("div","maplibregl-ctrl-attrib-inner",this._container),this._updateAttributions(),this._updateCompact(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("terrain",this._updateData),this._map.on("resize",this._updateCompact),this._map.on("drag",this._updateCompactMinimize),this._container}onRemove(){Ht.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("terrain",this._updateData),this._map.off("resize",this._updateCompact),this._map.off("drag",this._updateCompactMinimize),this._map=void 0,this._compact=void 0,this._sanitizedAttributionHTML=void 0}_setElementTitle(t,e){const i=this._map._getUIString(`AttributionControl.${e}`);t.title=i,t.setAttribute("aria-label",i)}_updateAttributions(){if(!this._map.style)return;let t=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?t=t.concat(this.options.customAttribution.map((t=>"string"!=typeof t?"":t))):"string"==typeof this.options.customAttribution&&t.push(this.options.customAttribution)),this._map.style.stylesheet){const t=this._map.style.stylesheet;this.styleOwner=t.owner,this.styleId=t.id}const e=this._map.style.sourceCaches;for(const i in e){const r=e[i];if(r.used||r.usedForTerrain){const e=r.getSource();e.attribution&&t.indexOf(e.attribution)<0&&t.push(e.attribution)}}t=t.filter((t=>String(t).trim())),t.sort(((t,e)=>t.length-e.length)),t=t.filter(((e,i)=>{for(let r=i+1;r<t.length;r++)if(t[r].indexOf(e)>=0)return!1;return!0}));const i=t.join(" | ");i!==this._sanitizedAttributionHTML&&(this._sanitizedAttributionHTML=Ht.sanitize(i),t.length?(this._innerContainer.innerHTML=this._sanitizedAttributionHTML,this._container.classList.remove("maplibregl-attrib-empty")):this._container.classList.add("maplibregl-attrib-empty"),this._updateCompact(),this._editLink=null)}}class fy{constructor(t={}){this._updateCompact=()=>{const t=this._container.children;if(t.length){const e=t[0];this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1!==this._compact&&e.classList.add("maplibregl-compact"):e.classList.remove("maplibregl-compact")}},this.options=t}getDefaultPosition(){return"bottom-left"}onAdd(t){this._map=t,this._compact=this.options&&this.options.compact,this._container=Ht.create("div","maplibregl-ctrl");const e=Ht.create("a","maplibregl-ctrl-logo");return e.target="_blank",e.rel="noopener nofollow",e.href="https://maplibre.org/",e.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),e.setAttribute("rel","noopener nofollow"),this._container.appendChild(e),this._container.style.display="block",this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){Ht.remove(this._container),this._map.off("resize",this._updateCompact),this._map=void 0,this._compact=void 0}}class my{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1}add(t){const e=++this._id;return this._queue.push({callback:t,id:e,cancelled:!1}),e}remove(t){const e=this._currentlyRunning,i=e?this._queue.concat(e):this._queue;for(const e of i)if(e.id===t)return void(e.cancelled=!0)}run(t=0){if(this._currentlyRunning)throw new Error("Attempting to run(), but is already running.");const e=this._currentlyRunning=this._queue;this._queue=[];for(const i of e)if(!i.cancelled&&(i.callback(t),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[]}}var _y;!function(t){t.create="create",t.load="load",t.fullLoad="fullLoad"}(_y||(_y={}));let gy=null,yy=[];const xy=1e3/60,vy="loadTime",by="fullLoadTime",wy={mark(t){performance.mark(t)},frame(t){const e=t;null!=gy&&yy.push(e-gy),gy=e},clearMetrics(){gy=null,yy=[],performance.clearMeasures(vy),performance.clearMeasures(by);for(const t in _y)performance.clearMarks(_y[t])},getPerformanceMetrics(){performance.measure(vy,_y.create,_y.load),performance.measure(by,_y.create,_y.fullLoad);const t=performance.getEntriesByName(vy)[0].duration,e=performance.getEntriesByName(by)[0].duration,i=yy.length,r=1/(yy.reduce(((t,e)=>t+e),0)/i/1e3),n=yy.filter((t=>t>xy)).reduce(((t,e)=>t+(e-xy)/xy),0);return{loadTime:t,fullLoadTime:e,fps:r,percentDroppedFrames:n/(i+n)*100,totalFrames:i}}};var Ty=zo([{name:"a_pos3d",type:"Int16",components:3}]);class Py extends me{constructor(t){super(),this._lastTilesetChange=Wt.now(),this.sourceCache=t,this._tiles={},this._renderableTilesKeys=[],this._sourceTileCache={},this.minzoom=0,this.maxzoom=22,this.deltaZoom=1,this.tileSize=t._source.tileSize*2**this.deltaZoom,t.usedForTerrain=!0,t.tileSize=this.tileSize}destruct(){this.sourceCache.usedForTerrain=!1,this.sourceCache.tileSize=null}update(t,e){this.sourceCache.update(t,e),this._renderableTilesKeys=[];const i={};for(const r of qp(t,{tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,reparseOverscaled:!1,terrain:e,calculateTileZoom:this.sourceCache._source.calculateTileZoom}))i[r.key]=!0,this._renderableTilesKeys.push(r.key),this._tiles[r.key]||(r.terrainRttPosMatrix32f=new Float64Array(16),A(r.terrainRttPosMatrix32f,0,J,J,0,0,1),this._tiles[r.key]=new Vp(r,this.tileSize),this._lastTilesetChange=Wt.now());for(const t in this._tiles)i[t]||delete this._tiles[t]}freeRtt(t){for(const e in this._tiles){const i=this._tiles[e];(!t||i.tileID.equals(t)||i.tileID.isChildOf(t)||t.isChildOf(i.tileID))&&(i.rtt=[])}}getRenderableTiles(){return this._renderableTilesKeys.map((t=>this.getTileByID(t)))}getTileByID(t){return this._tiles[t]}getTerrainCoords(t){const e={};for(const i of this._renderableTilesKeys){const r=this._tiles[i].tileID,n=t.clone(),s=it();if(r.canonical.equals(t.canonical))A(s,0,J,J,0,0,1);else if(r.canonical.isChildOf(t.canonical)){const e=r.canonical.z-t.canonical.z,i=r.canonical.x-(r.canonical.x>>e<<e),n=r.canonical.y-(r.canonical.y>>e<<e),o=J>>e;A(s,0,o,o,0,0,1),P(s,s,[-i*o,-n*o,0])}else{if(!t.canonical.isChildOf(r.canonical))continue;{const e=t.canonical.z-r.canonical.z,i=t.canonical.x-(t.canonical.x>>e<<e),n=t.canonical.y-(t.canonical.y>>e<<e),o=J>>e;A(s,0,J,J,0,0,1),P(s,s,[i*o,n*o,0]),M(s,s,[1/2**e,1/2**e,0])}}n.terrainRttPosMatrix32f=new Float32Array(s),e[i]=n}return e}getSourceTile(t,e){const i=this.sourceCache._source;let r=t.overscaledZ-this.deltaZoom;if(r>i.maxzoom&&(r=i.maxzoom),r<i.minzoom)return null;this._sourceTileCache[t.key]||(this._sourceTileCache[t.key]=t.scaledTo(r).key);let n=this.sourceCache.getTileByID(this._sourceTileCache[t.key]);if((!n||!n.dem)&&e)for(;r>=i.minzoom&&(!n||!n.dem);)n=this.sourceCache.getTileByID(t.scaledTo(r--).key);return n}anyTilesAfterTime(t=Date.now()){return this._lastTilesetChange>=t}}class My{constructor(t,e,i){this._meshCache={},this.painter=t,this.sourceCache=new Py(e),this.options=i,this.exaggeration="number"==typeof i.exaggeration?i.exaggeration:1,this.qualityFactor=2,this.meshSize=128,this._demMatrixCache={},this.coordsIndex=[],this._coordsTextureSize=1024}getDEMElevation(t,e,i,r=J){var n;if(!(e>=0&&e<r&&i>=0&&i<r))return 0;const s=this.getTerrainData(t),o=null===(n=s.tile)||void 0===n?void 0:n.dem;if(!o)return 0;const a=function(t,e,i){var r=e[0],n=e[1];return t[0]=i[0]*r+i[4]*n+i[12],t[1]=i[1]*r+i[5]*n+i[13],t}([],[e/r*J,i/r*J],s.u_terrain_matrix),l=[a[0]*o.dim,a[1]*o.dim],c=Math.floor(l[0]),h=Math.floor(l[1]),u=l[0]-c,p=l[1]-h;return o.get(c,h)*(1-u)*(1-p)+o.get(c+1,h)*u*(1-p)+o.get(c,h+1)*(1-u)*p+o.get(c+1,h+1)*u*p}getElevationForLngLatZoom(t,e){if(!function(t,e){const{x:i,y:r}=mp.fromLngLat(e);return!(t<0||t>25||r<0||r>=1||i<0||i>=1)}(e,t.wrap()))return 0;const{tileID:i,mercatorX:r,mercatorY:n}=this._getOverscaledTileIDFromLngLatZoom(t,e);return this.getElevation(i,r%J,n%J,J)}getElevation(t,e,i,r=J){return this.getDEMElevation(t,e,i,r)*this.exaggeration}getTerrainData(t){if(!this._emptyDemTexture){const t=this.painter.context,e=new Hl({width:1,height:1},new Uint8Array(4));this._emptyDepthTexture=new Au(t,e,t.gl.RGBA,{premultiply:!1}),this._emptyDemUnpack=[0,0,0,0],this._emptyDemTexture=new Au(t,new Hl({width:1,height:1}),t.gl.RGBA,{premultiply:!1}),this._emptyDemTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._emptyDemMatrix=b([])}const e=this.sourceCache.getSourceTile(t,!0);if(e&&e.dem&&(!e.demTexture||e.needsTerrainPrepare)){const t=this.painter.context;e.demTexture=this.painter.getTileTexture(e.dem.stride),e.demTexture?e.demTexture.update(e.dem.getPixels(),{premultiply:!1}):e.demTexture=new Au(t,e.dem.getPixels(),t.gl.RGBA,{premultiply:!1}),e.demTexture.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),e.needsTerrainPrepare=!1}const i=e&&e+e.tileID.key+t.key;if(i&&!this._demMatrixCache[i]){const i=this.sourceCache.sourceCache._source.maxzoom;let s=t.canonical.z-e.tileID.canonical.z;t.overscaledZ>t.canonical.z&&(t.canonical.z>=i?s=t.canonical.z-i:At("cannot calculate elevation if elevation maxzoom > source.maxzoom"));const o=t.canonical.x-(t.canonical.x>>s<<s),a=t.canonical.y-(t.canonical.y>>s<<s),l=((r=new Float64Array(16))[0]=(n=[1/(J<<s),1/(J<<s),0])[0],r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=n[1],r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=n[2],r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r);P(l,l,[o*J,a*J,0]),this._demMatrixCache[t.key]={matrix:l,coord:t}}var r,n;return{u_depth:2,u_terrain:3,u_terrain_dim:e&&e.dem&&e.dem.dim||1,u_terrain_matrix:i?this._demMatrixCache[t.key].matrix:this._emptyDemMatrix,u_terrain_unpack:e&&e.dem&&e.dem.getUnpackVector()||this._emptyDemUnpack,u_terrain_exaggeration:this.exaggeration,texture:(e&&e.demTexture||this._emptyDemTexture).texture,depthTexture:(this._fboDepthTexture||this._emptyDepthTexture).texture,tile:e}}getFramebuffer(t){const e=this.painter,i=e.width/devicePixelRatio,r=e.height/devicePixelRatio;return!this._fbo||this._fbo.width===i&&this._fbo.height===r||(this._fbo.destroy(),this._fboCoordsTexture.destroy(),this._fboDepthTexture.destroy(),delete this._fbo,delete this._fboDepthTexture,delete this._fboCoordsTexture),this._fboCoordsTexture||(this._fboCoordsTexture=new Au(e.context,{width:i,height:r,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboCoordsTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fboDepthTexture||(this._fboDepthTexture=new Au(e.context,{width:i,height:r,data:null},e.context.gl.RGBA,{premultiply:!1}),this._fboDepthTexture.bind(e.context.gl.NEAREST,e.context.gl.CLAMP_TO_EDGE)),this._fbo||(this._fbo=e.context.createFramebuffer(i,r,!0,!1),this._fbo.depthAttachment.set(e.context.createRenderbuffer(e.context.gl.DEPTH_COMPONENT16,i,r))),this._fbo.colorAttachment.set("coords"===t?this._fboCoordsTexture.texture:this._fboDepthTexture.texture),this._fbo}getCoordsTexture(){const t=this.painter.context;if(this._coordsTexture)return this._coordsTexture;const e=new Uint8Array(this._coordsTextureSize*this._coordsTextureSize*4);for(let t=0,i=0;t<this._coordsTextureSize;t++)for(let r=0;r<this._coordsTextureSize;r++,i+=4)e[i+0]=255&r,e[i+1]=255&t,e[i+2]=r>>8<<4|t>>8,e[i+3]=0;const i=new Hl({width:this._coordsTextureSize,height:this._coordsTextureSize},new Uint8Array(e.buffer)),r=new Au(t,i,t.gl.RGBA,{premultiply:!1});return r.bind(t.gl.NEAREST,t.gl.CLAMP_TO_EDGE),this._coordsTexture=r,r}pointCoordinate(t){this.painter.maybeDrawDepthAndCoords(!0);const e=new Uint8Array(4),i=this.painter.context,r=i.gl,n=Math.round(t.x*this.painter.pixelRatio/devicePixelRatio),s=Math.round(t.y*this.painter.pixelRatio/devicePixelRatio),o=Math.round(this.painter.height/devicePixelRatio);i.bindFramebuffer.set(this.getFramebuffer("coords").framebuffer),r.readPixels(n,o-s-1,1,1,r.RGBA,r.UNSIGNED_BYTE,e),i.bindFramebuffer.set(null);const a=e[0]+(e[2]>>4<<8),l=e[1]+((15&e[2])<<8),c=this.coordsIndex[255-e[3]],h=c&&this.sourceCache.getTileByID(c);if(!h)return null;const u=this._coordsTextureSize,p=(1<<h.tileID.canonical.z)*u;return new mp((h.tileID.canonical.x*u+a)/p+h.tileID.wrap,(h.tileID.canonical.y*u+l)/p,this.getElevation(h.tileID,a,l,u))}depthAtPoint(t){const e=new Uint8Array(4),i=this.painter.context,r=i.gl;return i.bindFramebuffer.set(this.getFramebuffer("depth").framebuffer),r.readPixels(t.x,this.painter.height/devicePixelRatio-t.y-1,1,1,r.RGBA,r.UNSIGNED_BYTE,e),i.bindFramebuffer.set(null),(e[0]/16777216+e[1]/65536+e[2]/256+e[3])/256}getTerrainMesh(t){var e;const i=(null===(e=this.painter.style.projection)||void 0===e?void 0:e.transitionState)>0,r=i&&0===t.canonical.y,n=i&&t.canonical.y===(1<<t.canonical.z)-1,s=`m_${r?"n":""}_${n?"s":""}`;if(this._meshCache[s])return this._meshCache[s];const o=this.painter.context,a=new ma,l=new Aa,c=this.meshSize,h=J/c,u=c*c;for(let t=0;t<=c;t++)for(let e=0;e<=c;e++)a.emplaceBack(e*h,t*h,0);for(let t=0;t<u;t+=c+1)for(let e=0;e<c;e++)l.emplaceBack(e+t,c+e+t+1,c+e+t+2),l.emplaceBack(e+t,c+e+t+2,e+t+1);const p=a.length,d=p+(c+1),f=(c+1)*c,m=r?kc:0,_=r?0:1,g=n?Dc:J,y=n?0:1;for(let t=0;t<=c;t++)a.emplaceBack(t*h,m,_);for(let t=0;t<=c;t++)a.emplaceBack(t*h,g,y);for(let t=0;t<c;t++)l.emplaceBack(f+t,d+t,d+t+1),l.emplaceBack(f+t,d+t+1,f+t+1),l.emplaceBack(0+t,p+t+1,p+t),l.emplaceBack(0+t,0+t+1,p+t+1);const x=a.length,v=x+2*(c+1);for(const t of[0,1])for(let e=0;e<=c;e++)for(const i of[0,1])a.emplaceBack(t*J,e*h,i);for(let t=0;t<2*c;t+=2)l.emplaceBack(x+t,x+t+1,x+t+3),l.emplaceBack(x+t,x+t+3,x+t+2),l.emplaceBack(v+t,v+t+3,v+t+1),l.emplaceBack(v+t,v+t+2,v+t+3);const b=new sf(o.createVertexBuffer(a,Ty.members),o.createIndexBuffer(l),La.simpleSegment(0,0,a.length,l.length));return this._meshCache[s]=b,b}getMeshFrameDelta(t){return 2*Math.PI*sp/Math.pow(2,Math.max(t,0))/5}getMinTileElevationForLngLatZoom(t,e){var i;const{tileID:r}=this._getOverscaledTileIDFromLngLatZoom(t,e);return null!==(i=this.getMinMaxElevation(r).minElevation)&&void 0!==i?i:0}getMinMaxElevation(t){const e=this.getTerrainData(t).tile,i={minElevation:null,maxElevation:null};return e&&e.dem&&(i.minElevation=e.dem.min*this.exaggeration,i.maxElevation=e.dem.max*this.exaggeration),i}_getOverscaledTileIDFromLngLatZoom(t,e){const i=mp.fromLngLat(t.wrap()),r=(1<<e)*J,n=i.x*r,s=i.y*r,o=Math.floor(n/J),a=Math.floor(s/J);return{tileID:new wp(e,0,e,o,a),mercatorX:n,mercatorY:s}}}class Cy{constructor(t,e,i){this._context=t,this._size=e,this._tileSize=i,this._objects=[],this._recentlyUsed=[],this._stamp=0}destruct(){for(const t of this._objects)t.texture.destroy(),t.fbo.destroy()}_createObject(t){const e=this._context.createFramebuffer(this._tileSize,this._tileSize,!0,!0),i=new Au(this._context,{width:this._tileSize,height:this._tileSize,data:null},this._context.gl.RGBA);return i.bind(this._context.gl.LINEAR,this._context.gl.CLAMP_TO_EDGE),this._context.extTextureFilterAnisotropic&&this._context.gl.texParameterf(this._context.gl.TEXTURE_2D,this._context.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,this._context.extTextureFilterAnisotropicMax),e.depthAttachment.set(this._context.createRenderbuffer(this._context.gl.DEPTH_STENCIL,this._tileSize,this._tileSize)),e.colorAttachment.set(i.texture),{id:t,fbo:e,texture:i,stamp:-1,inUse:!1}}getObjectForId(t){return this._objects[t]}useObject(t){t.inUse=!0,this._recentlyUsed=this._recentlyUsed.filter((e=>t.id!==e)),this._recentlyUsed.push(t.id)}stampObject(t){t.stamp=++this._stamp}getOrCreateFreeObject(){for(const t of this._recentlyUsed)if(!this._objects[t].inUse)return this._objects[t];if(this._objects.length>=this._size)throw new Error("No free RenderPool available, call freeAllObjects() required!");const t=this._createObject(this._objects.length);return this._objects.push(t),t}freeObject(t){t.inUse=!1}freeAllObjects(){for(const t of this._objects)this.freeObject(t)}isFull(){return!(this._objects.length<this._size)&&!1===this._objects.some((t=>!t.inUse))}}const Iy={background:!0,fill:!0,line:!0,raster:!0,hillshade:!0};class Sy{constructor(t,e){this.painter=t,this.terrain=e,this.pool=new Cy(t.context,30,e.sourceCache.tileSize*e.qualityFactor)}destruct(){this.pool.destruct()}getTexture(t){return this.pool.getObjectForId(t.rtt[this._stacks.length-1].id).texture}prepareForRender(t,e){this._stacks=[],this._prevType=null,this._rttTiles=[],this._renderableTiles=this.terrain.sourceCache.getRenderableTiles(),this._renderableLayerIds=t._order.filter((i=>!t._layers[i].isHidden(e))),this._coordsAscending={};for(const e in t.sourceCaches){this._coordsAscending[e]={};const i=t.sourceCaches[e].getVisibleCoordinates();for(const t of i){const i=this.terrain.sourceCache.getTerrainCoords(t);for(const t in i)this._coordsAscending[e][t]||(this._coordsAscending[e][t]=[]),this._coordsAscending[e][t].push(i[t])}}this._coordsAscendingStr={};for(const e of t._order){const i=t._layers[e],r=i.source;if(Iy[i.type]&&!this._coordsAscendingStr[r]){this._coordsAscendingStr[r]={};for(const t in this._coordsAscending[r])this._coordsAscendingStr[r][t]=this._coordsAscending[r][t].map((t=>t.key)).sort().join()}}for(const t of this._renderableTiles)for(const e in this._coordsAscendingStr){const i=this._coordsAscendingStr[e][t.tileID.key];i&&i!==t.rttCoords[e]&&(t.rtt=[])}}renderLayer(t,e){if(t.isHidden(this.painter.transform.zoom))return!1;const i=Object.assign(Object.assign({},e),{isRenderingToTexture:!0}),r=t.type,n=this.painter,s=this._renderableLayerIds[this._renderableLayerIds.length-1]===t.id;if(Iy[r]&&(this._prevType&&Iy[this._prevType]||this._stacks.push([]),this._prevType=r,this._stacks[this._stacks.length-1].push(t.id),!s))return!0;if(Iy[this._prevType]||Iy[r]&&s){this._prevType=r;const t=this._stacks.length-1,e=this._stacks[t]||[];for(const r of this._renderableTiles){if(this.pool.isFull()&&(cg(this.painter,this.terrain,this._rttTiles,i),this._rttTiles=[],this.pool.freeAllObjects()),this._rttTiles.push(r),r.rtt[t]){const e=this.pool.getObjectForId(r.rtt[t].id);if(e.stamp===r.rtt[t].stamp){this.pool.useObject(e);continue}}const s=this.pool.getOrCreateFreeObject();this.pool.useObject(s),this.pool.stampObject(s),r.rtt[t]={id:s.id,stamp:s.stamp},n.context.bindFramebuffer.set(s.fbo.framebuffer),n.context.clear({color:bi.transparent,stencil:0}),n.currentStencilSource=void 0;for(let t=0;t<e.length;t++){const o=n.style._layers[e[t]],a=o.source?this._coordsAscending[o.source][r.tileID.key]:[r.tileID];n.context.viewport.set([0,0,s.fbo.width,s.fbo.height]),n._renderTileClippingMasks(o,a,!0),n.renderLayer(n,n.style.sourceCaches[o.source],o,a,i),o.source&&(r.rttCoords[o.source]=this._coordsAscendingStr[o.source][r.tileID.key])}}return cg(this.painter,this.terrain,this._rttTiles,i),this._rttTiles=[],this.pool.freeAllObjects(),Iy[r]}return!1}}const Ey={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"MapLibre logo","Map.Title":"Map","Marker.Title":"Map marker","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","Popup.Close":"Close popup","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm","GlobeControl.Enable":"Enable globe","GlobeControl.Disable":"Disable globe","TerrainControl.Enable":"Enable terrain","TerrainControl.Disable":"Disable terrain","CooperativeGesturesHandler.WindowsHelpText":"Use Ctrl + scroll to zoom the map","CooperativeGesturesHandler.MacHelpText":"Use ⌘ + scroll to zoom the map","CooperativeGesturesHandler.MobileHelpText":"Use two fingers to move the map"},Ay=r,zy={hash:!1,interactive:!0,bearingSnap:7,attributionControl:py,maplibreLogo:!1,refreshExpiredTiles:!0,canvasContextAttributes:{antialias:!1,preserveDrawingBuffer:!1,powerPreference:"high-performance",failIfMajorPerformanceCaveat:!1,desynchronized:!1,contextType:void 0},scrollZoom:!0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:60,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,trackResize:!0,center:[0,0],elevation:0,zoom:0,bearing:0,pitch:0,roll:0,renderWorldCopies:!0,maxTileCacheSize:null,maxTileCacheZoomLevels:Xt.MAX_TILE_CACHE_ZOOM_LEVELS,transformRequest:null,transformCameraUpdate:null,fadeDuration:300,crossSourceCollisions:!0,clickTolerance:3,localIdeographFontFamily:"sans-serif",pitchWithRotate:!0,rollEnabled:!1,validateStyle:!0,maxCanvasSize:[4096,4096],cancelPendingTileRequestsWhileZooming:!0,centerClampedToGround:!0},ky={showCompass:!0,showZoom:!0,visualizePitch:!1,visualizeRoll:!0};class Dy{constructor(t,e,i=!1){this.mousedown=t=>{this.startMove(t,Ht.mousePos(this.element,t)),Ht.addEventListener(window,"mousemove",this.mousemove),Ht.addEventListener(window,"mouseup",this.mouseup)},this.mousemove=t=>{this.move(t,Ht.mousePos(this.element,t))},this.mouseup=t=>{this._rotatePitchHanlder.dragEnd(t),this.offTemp()},this.touchstart=t=>{1!==t.targetTouches.length?this.reset():(this._startPos=this._lastPos=Ht.touchPos(this.element,t.targetTouches)[0],this.startMove(t,this._startPos),Ht.addEventListener(window,"touchmove",this.touchmove,{passive:!1}),Ht.addEventListener(window,"touchend",this.touchend))},this.touchmove=t=>{1!==t.targetTouches.length?this.reset():(this._lastPos=Ht.touchPos(this.element,t.targetTouches)[0],this.move(t,this._lastPos))},this.touchend=t=>{0===t.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),delete this._startPos,delete this._lastPos,this.offTemp()},this.reset=()=>{this._rotatePitchHanlder.reset(),delete this._startPos,delete this._lastPos,this.offTemp()},this._clickTolerance=10,this.element=e;const r=new Og;this._rotatePitchHanlder=new Rg({clickTolerance:3,move:(t,r)=>{const n=e.getBoundingClientRect(),s=new c((n.bottom-n.top)/2,(n.right-n.left)/2);return{bearingDelta:Vt(new c(t.x,r.y),r,s),pitchDelta:i?-.5*(r.y-t.y):void 0}},moveStateManager:r,enable:!0,assignEvents:()=>{}}),this.map=t,Ht.addEventListener(e,"mousedown",this.mousedown),Ht.addEventListener(e,"touchstart",this.touchstart,{passive:!1}),Ht.addEventListener(e,"touchcancel",this.reset)}startMove(t,e){this._rotatePitchHanlder.dragStart(t,e),Ht.disableDrag()}move(t,e){const i=this.map,{bearingDelta:r,pitchDelta:n}=this._rotatePitchHanlder.dragMove(t,e)||{};r&&i.setBearing(i.getBearing()+r),n&&i.setPitch(i.getPitch()+n)}off(){const t=this.element;Ht.removeEventListener(t,"mousedown",this.mousedown),Ht.removeEventListener(t,"touchstart",this.touchstart,{passive:!1}),Ht.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),Ht.removeEventListener(window,"touchend",this.touchend),Ht.removeEventListener(t,"touchcancel",this.reset),this.offTemp()}offTemp(){Ht.enableDrag(),Ht.removeEventListener(window,"mousemove",this.mousemove),Ht.removeEventListener(window,"mouseup",this.mouseup),Ht.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),Ht.removeEventListener(window,"touchend",this.touchend)}}let Ry;function Ly(t,e,i){const r=new op(t.lng,t.lat);if(t=new op(t.lng,t.lat),e){const r=new op(t.lng-360,t.lat),n=new op(t.lng+360,t.lat),s=i.locationToScreenPoint(t).distSqr(e);i.locationToScreenPoint(r).distSqr(e)<s?t=r:i.locationToScreenPoint(n).distSqr(e)<s&&(t=n)}for(;Math.abs(t.lng-i.center.lng)>180;){const e=i.locationToScreenPoint(t);if(e.x>=0&&e.y>=0&&e.x<=i.width&&e.y<=i.height)break;t.lng>i.center.lng?t.lng-=360:t.lng+=360}return t.lng!==r.lng&&i.isPointOnMapSurface(i.locationToScreenPoint(t))?t:r}const By={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function Fy(t,e,i){const r=t.classList;for(const t in By)r.remove(`maplibregl-${i}-anchor-${t}`);r.add(`maplibregl-${i}-anchor-${e}`)}class Oy extends me{constructor(t){if(super(),this._onKeyPress=t=>{const e=t.code,i=t.charCode||t.keyCode;"Space"!==e&&"Enter"!==e&&32!==i&&13!==i||this.togglePopup()},this._onMapClick=t=>{const e=t.originalEvent.target,i=this._element;this._popup&&(e===i||i.contains(e))&&this.togglePopup()},this._update=t=>{var e;if(!this._map)return;const i=this._map.loaded()&&!this._map.isMoving();("terrain"===(null==t?void 0:t.type)||"render"===(null==t?void 0:t.type)&&!i)&&this._map.once("render",this._update),this._lngLat=this._map.transform.renderWorldCopies?Ly(this._lngLat,this._flatPos,this._map.transform):null===(e=this._lngLat)||void 0===e?void 0:e.wrap(),this._flatPos=this._pos=this._map.project(this._lngLat)._add(this._offset),this._map.terrain&&(this._flatPos=this._map.transform.locationToScreenPoint(this._lngLat)._add(this._offset));let r="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?r=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(r=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let n="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?n="rotateX(0deg)":"map"===this._pitchAlignment&&(n=`rotateX(${this._map.getPitch()}deg)`),this._subpixelPositioning||t&&"moveend"!==t.type||(this._pos=this._pos.round()),Ht.setTransform(this._element,`${By[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${n} ${r}`),Wt.frameAsync(new AbortController).then((()=>{this._updateOpacity(t&&"moveend"===t.type)})).catch((()=>{}))},this._onMove=t=>{if(!this._isDragging){const e=this._clickTolerance||this._map._clickTolerance;this._isDragging=t.point.dist(this._pointerdownPos)>=e}this._isDragging&&(this._pos=t.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new de("dragstart"))),this.fire(new de("drag")))},this._onUp=()=>{this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new de("dragend")),this._state="inactive"},this._addDragHandler=t=>{this._element.contains(t.originalEvent.target)&&(t.preventDefault(),this._positionDelta=t.point.sub(this._pos).add(this._offset),this._pointerdownPos=t.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp))},this._anchor=t&&t.anchor||"center",this._color=t&&t.color||"#3FB1CE",this._scale=t&&t.scale||1,this._draggable=t&&t.draggable||!1,this._clickTolerance=t&&t.clickTolerance||0,this._subpixelPositioning=t&&t.subpixelPositioning||!1,this._isDragging=!1,this._state="inactive",this._rotation=t&&t.rotation||0,this._rotationAlignment=t&&t.rotationAlignment||"auto",this._pitchAlignment=t&&t.pitchAlignment&&"auto"!==t.pitchAlignment?t.pitchAlignment:this._rotationAlignment,this.setOpacity(null==t?void 0:t.opacity,null==t?void 0:t.opacityWhenCovered),t&&t.element)this._element=t.element,this._offset=c.convert(t&&t.offset||[0,0]);else{this._defaultMarker=!0,this._element=Ht.create("div");const e=Ht.createNS("http://www.w3.org/2000/svg","svg"),i=41,r=27;e.setAttributeNS(null,"display","block"),e.setAttributeNS(null,"height",`${i}px`),e.setAttributeNS(null,"width",`${r}px`),e.setAttributeNS(null,"viewBox",`0 0 ${r} ${i}`);const n=Ht.createNS("http://www.w3.org/2000/svg","g");n.setAttributeNS(null,"stroke","none"),n.setAttributeNS(null,"stroke-width","1"),n.setAttributeNS(null,"fill","none"),n.setAttributeNS(null,"fill-rule","evenodd");const s=Ht.createNS("http://www.w3.org/2000/svg","g");s.setAttributeNS(null,"fill-rule","nonzero");const o=Ht.createNS("http://www.w3.org/2000/svg","g");o.setAttributeNS(null,"transform","translate(3.0, 29.0)"),o.setAttributeNS(null,"fill","#000000");const a=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const t of a){const e=Ht.createNS("http://www.w3.org/2000/svg","ellipse");e.setAttributeNS(null,"opacity","0.04"),e.setAttributeNS(null,"cx","10.5"),e.setAttributeNS(null,"cy","5.80029008"),e.setAttributeNS(null,"rx",t.rx),e.setAttributeNS(null,"ry",t.ry),o.appendChild(e)}const l=Ht.createNS("http://www.w3.org/2000/svg","g");l.setAttributeNS(null,"fill",this._color);const h=Ht.createNS("http://www.w3.org/2000/svg","path");h.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),l.appendChild(h);const u=Ht.createNS("http://www.w3.org/2000/svg","g");u.setAttributeNS(null,"opacity","0.25"),u.setAttributeNS(null,"fill","#000000");const p=Ht.createNS("http://www.w3.org/2000/svg","path");p.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),u.appendChild(p);const d=Ht.createNS("http://www.w3.org/2000/svg","g");d.setAttributeNS(null,"transform","translate(6.0, 7.0)"),d.setAttributeNS(null,"fill","#FFFFFF");const f=Ht.createNS("http://www.w3.org/2000/svg","g");f.setAttributeNS(null,"transform","translate(8.0, 8.0)");const m=Ht.createNS("http://www.w3.org/2000/svg","circle");m.setAttributeNS(null,"fill","#000000"),m.setAttributeNS(null,"opacity","0.25"),m.setAttributeNS(null,"cx","5.5"),m.setAttributeNS(null,"cy","5.5"),m.setAttributeNS(null,"r","5.4999962");const _=Ht.createNS("http://www.w3.org/2000/svg","circle");_.setAttributeNS(null,"fill","#FFFFFF"),_.setAttributeNS(null,"cx","5.5"),_.setAttributeNS(null,"cy","5.5"),_.setAttributeNS(null,"r","5.4999962"),f.appendChild(m),f.appendChild(_),s.appendChild(o),s.appendChild(l),s.appendChild(u),s.appendChild(d),s.appendChild(f),e.appendChild(s),e.setAttributeNS(null,"height",i*this._scale+"px"),e.setAttributeNS(null,"width",r*this._scale+"px"),this._element.appendChild(e),this._offset=c.convert(t&&t.offset||[0,-14])}if(this._element.classList.add("maplibregl-marker"),this._element.addEventListener("dragstart",(t=>{t.preventDefault()})),this._element.addEventListener("mousedown",(t=>{t.preventDefault()})),Fy(this._element,this._anchor,"marker"),t&&t.className)for(const e of t.className.split(" "))this._element.classList.add(e);this._popup=null}addTo(t){return this.remove(),this._map=t,this._element.setAttribute("aria-label",t._getUIString("Marker.Title")),t.getCanvasContainer().appendChild(this._element),t.on("move",this._update),t.on("moveend",this._update),t.on("terrain",this._update),t.on("projectiontransition",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._opacityTimeout&&(clearTimeout(this._opacityTimeout),delete this._opacityTimeout),this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("terrain",this._update),this._map.off("projectiontransition",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),Ht.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=op.convert(t),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(t){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),t){if(!("offset"in t.options)){const e=38.1,i=13.5,r=Math.abs(i)/Math.SQRT2;t.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-38.1],"bottom-left":[r,-1*(e-i+r)],"bottom-right":[-r,-1*(e-i+r)],left:[i,-1*(e-i)],right:[-13.5,-1*(e-i)]}:this._offset}this._popup=t,this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress)}return this}setSubpixelPositioning(t){return this._subpixelPositioning=t,this}getPopup(){return this._popup}togglePopup(){const t=this._popup;return this._element.style.opacity===this._opacityWhenCovered?this:t?(t.isOpen()?t.remove():(t.setLngLat(this._lngLat),t.addTo(this._map)),this):this}_updateOpacity(t=!1){var e,i;if(!(null===(e=this._map)||void 0===e?void 0:e.terrain)){const t=this._map.transform.isLocationOccluded(this._lngLat)?this._opacityWhenCovered:this._opacity;return void(this._element.style.opacity!==t&&(this._element.style.opacity=t))}if(t)this._opacityTimeout=null;else{if(this._opacityTimeout)return;this._opacityTimeout=setTimeout((()=>{this._opacityTimeout=null}),100)}const r=this._map,n=r.terrain.depthAtPoint(this._pos),s=r.terrain.getElevationForLngLatZoom(this._lngLat,r.transform.tileZoom);if(r.transform.lngLatToCameraDepth(this._lngLat,s)-n<.006)return void(this._element.style.opacity=this._opacity);const o=-this._offset.y/r.transform.pixelsPerMeter,a=Math.sin(r.getPitch()*Math.PI/180)*o,l=r.terrain.depthAtPoint(new c(this._pos.x,this._pos.y-this._offset.y)),h=r.transform.lngLatToCameraDepth(this._lngLat,s+a)-l>.006;(null===(i=this._popup)||void 0===i?void 0:i.isOpen())&&h&&this._popup.remove(),this._element.style.opacity=h?this._opacityWhenCovered:this._opacity}getOffset(){return this._offset}setOffset(t){return this._offset=c.convert(t),this._update(),this}addClassName(t){this._element.classList.add(t)}removeClassName(t){this._element.classList.remove(t)}toggleClassName(t){return this._element.classList.toggle(t)}setDraggable(t){return this._draggable=!!t,this._map&&(t?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(t){return this._rotation=t||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(t){return this._rotationAlignment=t||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(t){return this._pitchAlignment=t&&"auto"!==t?t:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}setOpacity(t,e){return(void 0===this._opacity||void 0===t&&void 0===e)&&(this._opacity="1",this._opacityWhenCovered="0.2"),void 0!==t&&(this._opacity=t),void 0!==e&&(this._opacityWhenCovered=e),this._map&&this._updateOpacity(!0),this}}const jy={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let Vy=0,Ny=!1;const Uy={maxWidth:100,unit:"metric"};function Zy(t,e,i){const r=i&&i.maxWidth||100,n=t._container.clientHeight/2,s=t._container.clientWidth/2,o=t.unproject([s-r/2,n]),a=t.unproject([s+r/2,n]),l=Math.round(t.project(a).x-t.project(o).x),c=Math.min(r,l,t._container.clientWidth),h=o.distanceTo(a);if(i&&"imperial"===i.unit){const i=3.2808*h;i>5280?Gy(e,c,i/5280,t._getUIString("ScaleControl.Miles")):Gy(e,c,i,t._getUIString("ScaleControl.Feet"))}else i&&"nautical"===i.unit?Gy(e,c,h/1852,t._getUIString("ScaleControl.NauticalMiles")):h>=1e3?Gy(e,c,h/1e3,t._getUIString("ScaleControl.Kilometers")):Gy(e,c,h,t._getUIString("ScaleControl.Meters"))}function Gy(t,e,i,r){const n=function(t){const e=Math.pow(10,`${Math.floor(t)}`.length-1);let i=t/e;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(t){const e=Math.pow(10,Math.ceil(-Math.log(t)/Math.LN10));return Math.round(t*e)/e}(i),e*i}(i);t.style.width=e*(n/i)+"px",t.innerHTML=`${n}&nbsp;${r}`}const $y={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px",subpixelPositioning:!1,locationOccludedOpacity:void 0},qy=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function Wy(t){if(t){if("number"==typeof t){const e=Math.round(Math.abs(t)/Math.SQRT2);return{center:new c(0,0),top:new c(0,t),"top-left":new c(e,e),"top-right":new c(-e,e),bottom:new c(0,-t),"bottom-left":new c(e,-e),"bottom-right":new c(-e,-e),left:new c(t,0),right:new c(-t,0)}}if(t instanceof c||Array.isArray(t)){const e=c.convert(t);return{center:e,top:e,"top-left":e,"top-right":e,bottom:e,"bottom-left":e,"bottom-right":e,left:e,right:e}}return{center:c.convert(t.center||[0,0]),top:c.convert(t.top||[0,0]),"top-left":c.convert(t["top-left"]||[0,0]),"top-right":c.convert(t["top-right"]||[0,0]),bottom:c.convert(t.bottom||[0,0]),"bottom-left":c.convert(t["bottom-left"]||[0,0]),"bottom-right":c.convert(t["bottom-right"]||[0,0]),left:c.convert(t.left||[0,0]),right:c.convert(t.right||[0,0])}}return Wy(new c(0,0))}const Hy=r;t.AJAXError=Jt,t.AttributionControl=dy,t.BoxZoomHandler=Eg,t.CanvasSource=Sp,t.CooperativeGesturesHandler=oy,t.DoubleClickZoomHandler=ty,t.DragPanHandler=ry,t.DragRotateHandler=ny,t.EdgeInsets=mf,t.Event=de,t.Evented=me,t.FullscreenControl=class extends me{constructor(t={}){super(),this._onFullscreenChange=()=>{var t;let e=window.document.fullscreenElement||window.document.mozFullScreenElement||window.document.webkitFullscreenElement||window.document.msFullscreenElement;for(;null===(t=null==e?void 0:e.shadowRoot)||void 0===t?void 0:t.fullscreenElement;)e=e.shadowRoot.fullscreenElement;e===this._container!==this._fullscreen&&this._handleFullscreenChange()},this._onClickFullscreen=()=>{this._isFullscreen()?this._exitFullscreen():this._requestFullscreen()},this._fullscreen=!1,t&&t.container&&(t.container instanceof HTMLElement?this._container=t.container:At("Full screen control 'container' must be a DOM element.")),"onfullscreenchange"in document?this._fullscreenchange="fullscreenchange":"onmozfullscreenchange"in document?this._fullscreenchange="mozfullscreenchange":"onwebkitfullscreenchange"in document?this._fullscreenchange="webkitfullscreenchange":"onmsfullscreenchange"in document&&(this._fullscreenchange="MSFullscreenChange")}onAdd(t){return this._map=t,this._container||(this._container=this._map.getContainer()),this._controlContainer=Ht.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),this._controlContainer}onRemove(){Ht.remove(this._controlContainer),this._map=null,window.document.removeEventListener(this._fullscreenchange,this._onFullscreenChange)}_setupUI(){const t=this._fullscreenButton=Ht.create("button","maplibregl-ctrl-fullscreen",this._controlContainer);Ht.create("span","maplibregl-ctrl-icon",t).setAttribute("aria-hidden","true"),t.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),window.document.addEventListener(this._fullscreenchange,this._onFullscreenChange)}_updateTitle(){const t=this._getTitle();this._fullscreenButton.setAttribute("aria-label",t),this._fullscreenButton.title=t}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_handleFullscreenChange(){this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("maplibregl-ctrl-shrink"),this._fullscreenButton.classList.toggle("maplibregl-ctrl-fullscreen"),this._updateTitle(),this._fullscreen?(this.fire(new de("fullscreenstart")),this._prevCooperativeGesturesEnabled=this._map.cooperativeGestures.isEnabled(),this._map.cooperativeGestures.disable()):(this.fire(new de("fullscreenend")),this._prevCooperativeGesturesEnabled&&this._map.cooperativeGestures.enable())}_exitFullscreen(){window.document.exitFullscreen?window.document.exitFullscreen():window.document.mozCancelFullScreen?window.document.mozCancelFullScreen():window.document.msExitFullscreen?window.document.msExitFullscreen():window.document.webkitCancelFullScreen?window.document.webkitCancelFullScreen():this._togglePseudoFullScreen()}_requestFullscreen(){this._container.requestFullscreen?this._container.requestFullscreen():this._container.mozRequestFullScreen?this._container.mozRequestFullScreen():this._container.msRequestFullscreen?this._container.msRequestFullscreen():this._container.webkitRequestFullscreen?this._container.webkitRequestFullscreen():this._togglePseudoFullScreen()}_togglePseudoFullScreen(){this._container.classList.toggle("maplibregl-pseudo-fullscreen"),this._handleFullscreenChange(),this._map.resize()}},t.GeoJSONSource=Mp,t.GeolocateControl=class extends me{constructor(t){super(),this._onSuccess=t=>{if(this._map){if(this._isOutOfMapMaxBounds(t))return this._setErrorState(),this.fire(new de("outofmaxbounds",t)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=t,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background");break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(t),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(t),this.options.showUserLocation&&this._dotElement.classList.remove("maplibregl-user-location-dot-stale"),this.fire(new de("geolocate",t)),this._finish()}},this._updateCamera=t=>{const e=new op(t.coords.longitude,t.coords.latitude),i=t.coords.accuracy,r=xt({bearing:this._map.getBearing()},this.options.fitBoundsOptions),n=ap.fromLngLat(e,i);this._map.fitBounds(n,r,{geolocateSource:!0})},this._updateMarker=t=>{if(t){const e=new op(t.coords.longitude,t.coords.latitude);this._accuracyCircleMarker.setLngLat(e).addTo(this._map),this._userLocationDotMarker.setLngLat(e).addTo(this._map),this._accuracy=t.coords.accuracy,this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius()}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove()},this._onZoom=()=>{this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius()},this._onError=t=>{if(this._map){if(this.options.trackUserLocation)if(1===t.code){this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t),void 0!==this._geolocationWatchID&&this._clearWatch()}else{if(3===t.code&&Ny)return;this._setErrorState()}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("maplibregl-user-location-dot-stale"),this.fire(new de("error",t)),this._finish()}},this._finish=()=>{this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0},this._setupUI=()=>{this._map&&(this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this._geolocateButton=Ht.create("button","maplibregl-ctrl-geolocate",this._container),Ht.create("span","maplibregl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",this._geolocateButton.disabled=!0)},this._finishSetupUI=t=>{if(this._map){if(!1===t){At("Geolocation support is not available so the GeolocateControl will be disabled.");const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t)}else{const t=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.disabled=!1,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t)}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=Ht.create("div","maplibregl-user-location-dot"),this._userLocationDotMarker=new Oy({element:this._dotElement}),this._circleElement=Ht.create("div","maplibregl-user-location-accuracy-circle"),this._accuracyCircleMarker=new Oy({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onZoom)),this._geolocateButton.addEventListener("click",(()=>this.trigger())),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(t=>{t.geolocateSource||"ACTIVE_LOCK"!==this._watchState||t.originalEvent&&"resize"===t.originalEvent.type||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this.fire(new de("trackuserlocationend")),this.fire(new de("userlocationlostfocus")))}))}},this.options=xt({},jy,t)}onAdd(t){return this._map=t,this._container=Ht.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),function(){return n(this,arguments,void 0,(function*(t=!1){if(void 0!==Ry&&!t)return Ry;if(void 0===window.navigator.permissions)return Ry=!!window.navigator.geolocation,Ry;try{const t=yield window.navigator.permissions.query({name:"geolocation"});Ry="denied"!==t.state}catch(t){Ry=!!window.navigator.geolocation}return Ry}))}().then((t=>this._finishSetupUI(t))),this._container}onRemove(){void 0!==this._geolocationWatchID&&(window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),Ht.remove(this._container),this._map.off("zoom",this._onZoom),this._map=void 0,Vy=0,Ny=!1}_isOutOfMapMaxBounds(t){const e=this._map.getMaxBounds(),i=t.coords;return e&&(i.longitude<e.getWest()||i.longitude>e.getEast()||i.latitude<e.getSouth()||i.latitude>e.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case"ACTIVE_ERROR":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}}_updateCircleRadius(){const t=this._map.getBounds(),e=t.getSouthEast(),i=t.getNorthEast(),r=e.distanceTo(i),n=Math.ceil(this._accuracy/(r/this._map._container.clientHeight)*2);this._circleElement.style.width=`${n}px`,this._circleElement.style.height=`${n}px`}trigger(){if(!this._setup)return At("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new de("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":Vy--,Ny=!1,this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this.fire(new de("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new de("trackuserlocationstart")),this.fire(new de("userlocationfocus"));break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case"OFF":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let t;this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),Vy++,Vy>1?(t={maximumAge:6e5,timeout:0},Ny=!0):(t=this.options.positionOptions,Ny=!1),this._geolocationWatchID=window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,t)}}else window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return!0}_clearWatch(){window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null)}},t.GlobeControl=class{constructor(){this._toggleProjection=()=>{var t;const e=null===(t=this._map.getProjection())||void 0===t?void 0:t.type;this._map.setProjection("mercator"!==e&&e?{type:"mercator"}:{type:"globe"}),this._updateGlobeIcon()},this._updateGlobeIcon=()=>{var t;this._globeButton.classList.remove("maplibregl-ctrl-globe"),this._globeButton.classList.remove("maplibregl-ctrl-globe-enabled"),"globe"===(null===(t=this._map.getProjection())||void 0===t?void 0:t.type)?(this._globeButton.classList.add("maplibregl-ctrl-globe-enabled"),this._globeButton.title=this._map._getUIString("GlobeControl.Disable")):(this._globeButton.classList.add("maplibregl-ctrl-globe"),this._globeButton.title=this._map._getUIString("GlobeControl.Enable"))}}onAdd(t){return this._map=t,this._container=Ht.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._globeButton=Ht.create("button","maplibregl-ctrl-globe",this._container),Ht.create("span","maplibregl-ctrl-icon",this._globeButton).setAttribute("aria-hidden","true"),this._globeButton.type="button",this._globeButton.addEventListener("click",this._toggleProjection),this._updateGlobeIcon(),this._map.on("styledata",this._updateGlobeIcon),this._container}onRemove(){Ht.remove(this._container),this._map.off("styledata",this._updateGlobeIcon),this._globeButton.removeEventListener("click",this._toggleProjection),this._map=void 0}},t.Hash=dg,t.ImageSource=Cp,t.KeyboardHandler=Kg,t.LngLat=op,t.LngLatBounds=ap,t.LogoControl=fy,t.Map=class extends uy{constructor(t){var e,i;wy.mark(_y.create);const r=Object.assign(Object.assign(Object.assign({},zy),t),{canvasContextAttributes:Object.assign(Object.assign({},zy.canvasContextAttributes),t.canvasContextAttributes)});if(null!=r.minZoom&&null!=r.maxZoom&&r.minZoom>r.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=r.minPitch&&null!=r.maxPitch&&r.minPitch>r.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=r.minPitch&&r.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=r.maxPitch&&r.maxPitch>180)throw new Error("maxPitch must be less than or equal to 180");const n=new wf,s=new Cf;if(void 0!==r.minZoom&&n.setMinZoom(r.minZoom),void 0!==r.maxZoom&&n.setMaxZoom(r.maxZoom),void 0!==r.minPitch&&n.setMinPitch(r.minPitch),void 0!==r.maxPitch&&n.setMaxPitch(r.maxPitch),void 0!==r.renderWorldCopies&&n.setRenderWorldCopies(r.renderWorldCopies),super(n,s,{bearingSnap:r.bearingSnap}),this._idleTriggered=!1,this._crossFadingFactor=1,this._renderTaskQueue=new my,this._controls=[],this._mapId=wt(),this._contextLost=t=>{t.preventDefault(),this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this.fire(new de("webglcontextlost",{originalEvent:t}))},this._contextRestored=t=>{this._setupPainter(),this.resize(),this._update(),this.fire(new de("webglcontextrestored",{originalEvent:t}))},this._onMapScroll=t=>{if(t.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1},this._onWindowOnline=()=>{this._update()},this._interactive=r.interactive,this._maxTileCacheSize=r.maxTileCacheSize,this._maxTileCacheZoomLevels=r.maxTileCacheZoomLevels,this._canvasContextAttributes=Object.assign({},r.canvasContextAttributes),this._trackResize=!0===r.trackResize,this._bearingSnap=r.bearingSnap,this._centerClampedToGround=r.centerClampedToGround,this._refreshExpiredTiles=!0===r.refreshExpiredTiles,this._fadeDuration=r.fadeDuration,this._crossSourceCollisions=!0===r.crossSourceCollisions,this._collectResourceTiming=!0===r.collectResourceTiming,this._locale=Object.assign(Object.assign({},Ey),r.locale),this._clickTolerance=r.clickTolerance,this._overridePixelRatio=r.pixelRatio,this._maxCanvasSize=r.maxCanvasSize,this.transformCameraUpdate=r.transformCameraUpdate,this.cancelPendingTileRequestsWhileZooming=!0===r.cancelPendingTileRequestsWhileZooming,this._imageQueueHandle=ce.addThrottleControl((()=>this.isMoving())),this._requestManager=new he(r.transformRequest),"string"==typeof r.container){if(this._container=document.getElementById(r.container),!this._container)throw new Error(`Container '${r.container}' not found.`)}else{if(!(r.container instanceof HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=r.container}if(r.maxBounds&&this.setMaxBounds(r.maxBounds),this._setupContainer(),this._setupPainter(),this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),this.on("terrain",(()=>{this.painter.terrainFacilitator.dirty=!0,this._update(!0)})),this.once("idle",(()=>{this._idleTriggered=!0})),"undefined"!=typeof window){addEventListener("online",this._onWindowOnline,!1);let t=!1;const e=pg((t=>{this._trackResize&&!this._removed&&(this.resize(t),this.redraw())}),50);this._resizeObserver=new ResizeObserver((i=>{t?e(i):t=!0})),this._resizeObserver.observe(this._container)}this.handlers=new hy(this,r),this._hash=r.hash&&new dg("string"==typeof r.hash&&r.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:r.center,elevation:r.elevation,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,roll:r.roll}),r.bounds&&(this.resize(),this.fitBounds(r.bounds,xt({},r.fitBoundsOptions,{duration:0}))));const o="string"==typeof r.style||!("globe"===(null===(i=null===(e=r.style)||void 0===e?void 0:e.projection)||void 0===i?void 0:i.type));this.resize(null,o),this._localIdeographFontFamily=r.localIdeographFontFamily,this._validateStyle=r.validateStyle,r.style&&this.setStyle(r.style,{localIdeographFontFamily:r.localIdeographFontFamily}),r.attributionControl&&this.addControl(new dy("boolean"==typeof r.attributionControl?void 0:r.attributionControl)),r.maplibreLogo&&this.addControl(new fy,r.logoPosition),this.on("style.load",(()=>{if(o||this._resizeTransform(),this.transform.unmodified){const t=vt(this.style.stylesheet,["center","zoom","bearing","pitch","roll"]);this.jumpTo(t)}})),this.on("data",(t=>{this._update("style"===t.dataType),this.fire(new de(`${t.dataType}data`,t))})),this.on("dataloading",(t=>{this.fire(new de(`${t.dataType}dataloading`,t))})),this.on("dataabort",(t=>{this.fire(new de("sourcedataabort",t))}))}_getMapId(){return this._mapId}addControl(t,e){if(void 0===e&&(e=t.getDefaultPosition?t.getDefaultPosition():"top-right"),!t||!t.onAdd)return this.fire(new fe(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const i=t.onAdd(this);this._controls.push(t);const r=this._controlPositions[e];return-1!==e.indexOf("bottom")?r.insertBefore(i,r.firstChild):r.appendChild(i),this}removeControl(t){if(!t||!t.onRemove)return this.fire(new fe(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const e=this._controls.indexOf(t);return e>-1&&this._controls.splice(e,1),t.onRemove(this),this}hasControl(t){return this._controls.indexOf(t)>-1}calculateCameraOptionsFromTo(t,e,i,r){return null==r&&this.terrain&&(r=this.terrain.getElevationForLngLatZoom(i,this.transform.tileZoom)),super.calculateCameraOptionsFromTo(t,e,i,r)}resize(t,e=!0){const[i,r]=this._containerDimensions(),n=this._getClampedPixelRatio(i,r);if(this._resizeCanvas(i,r,n),this.painter.resize(i,r,n),this.painter.overLimit()){const t=this.painter.context.gl;this._maxCanvasSize=[t.drawingBufferWidth,t.drawingBufferHeight];const e=this._getClampedPixelRatio(i,r);this._resizeCanvas(i,r,e),this.painter.resize(i,r,e)}this._resizeTransform(e);const s=!this._moving;return s&&(this.stop(),this.fire(new de("movestart",t)).fire(new de("move",t))),this.fire(new de("resize",t)),s&&this.fire(new de("moveend",t)),this}_resizeTransform(t=!0){var e;const[i,r]=this._containerDimensions();this.transform.resize(i,r,t),null===(e=this._requestedCameraState)||void 0===e||e.resize(i,r,t)}_getClampedPixelRatio(t,e){const{0:i,1:r}=this._maxCanvasSize,n=this.getPixelRatio(),s=t*n,o=e*n;return Math.min(s>i?i/s:1,o>r?r/o:1)*n}getPixelRatio(){var t;return null!==(t=this._overridePixelRatio)&&void 0!==t?t:devicePixelRatio}setPixelRatio(t){this._overridePixelRatio=t,this.resize()}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(t){return this.transform.setMaxBounds(ap.convert(t)),this._update()}setMinZoom(t){if((t=null==t?-2:t)>=-2&&t<=this.transform.maxZoom)return this.transform.setMinZoom(t),this._update(),this.getZoom()<t&&this.setZoom(t),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(t){if((t=null==t?22:t)>=this.transform.minZoom)return this.transform.setMaxZoom(t),this._update(),this.getZoom()>t&&this.setZoom(t),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(t){if((t=null==t?0:t)<0)throw new Error("minPitch must be greater than or equal to 0");if(t>=0&&t<=this.transform.maxPitch)return this.transform.setMinPitch(t),this._update(),this.getPitch()<t&&this.setPitch(t),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(t){if((t=null==t?60:t)>180)throw new Error("maxPitch must be less than or equal to 180");if(t>=this.transform.minPitch)return this.transform.setMaxPitch(t),this._update(),this.getPitch()>t&&this.setPitch(t),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(t){return this.transform.setRenderWorldCopies(t),this._update()}project(t){return this.transform.locationToScreenPoint(op.convert(t),this.style&&this.terrain)}unproject(t){return this.transform.screenPointToLocation(c.convert(t),this.terrain)}isMoving(){var t;return this._moving||(null===(t=this.handlers)||void 0===t?void 0:t.isMoving())}isZooming(){var t;return this._zooming||(null===(t=this.handlers)||void 0===t?void 0:t.isZooming())}isRotating(){var t;return this._rotating||(null===(t=this.handlers)||void 0===t?void 0:t.isRotating())}_createDelegatedListener(t,e,i){if("mouseenter"===t||"mouseover"===t){let r=!1;const n=n=>{const s=e.filter((t=>this.getLayer(t))),o=0!==s.length?this.queryRenderedFeatures(n.point,{layers:s}):[];o.length?r||(r=!0,i.call(this,new Tg(t,this,n.originalEvent,{features:o}))):r=!1};return{layers:e,listener:i,delegates:{mousemove:n,mouseout:()=>{r=!1}}}}if("mouseleave"===t||"mouseout"===t){let r=!1;const n=n=>{const s=e.filter((t=>this.getLayer(t)));(0!==s.length?this.queryRenderedFeatures(n.point,{layers:s}):[]).length?r=!0:r&&(r=!1,i.call(this,new Tg(t,this,n.originalEvent)))},s=e=>{r&&(r=!1,i.call(this,new Tg(t,this,e.originalEvent)))};return{layers:e,listener:i,delegates:{mousemove:n,mouseout:s}}}{const r=t=>{const r=e.filter((t=>this.getLayer(t))),n=0!==r.length?this.queryRenderedFeatures(t.point,{layers:r}):[];n.length&&(t.features=n,i.call(this,t),delete t.features)};return{layers:e,listener:i,delegates:{[t]:r}}}}_saveDelegatedListener(t,e){this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[t]=this._delegatedListeners[t]||[],this._delegatedListeners[t].push(e)}_removeDelegatedListener(t,e,i){if(!this._delegatedListeners||!this._delegatedListeners[t])return;const r=this._delegatedListeners[t];for(let t=0;t<r.length;t++){const n=r[t];if(n.listener===i&&n.layers.length===e.length&&n.layers.every((t=>e.includes(t)))){for(const t in n.delegates)this.off(t,n.delegates[t]);return void r.splice(t,1)}}}on(t,e,i){if(void 0===i)return super.on(t,e);const r="string"==typeof e?[e]:e,n=this._createDelegatedListener(t,r,i);this._saveDelegatedListener(t,n);for(const t in n.delegates)this.on(t,n.delegates[t]);return{unsubscribe:()=>{this._removeDelegatedListener(t,r,i)}}}once(t,e,i){if(void 0===i)return super.once(t,e);const r="string"==typeof e?[e]:e,n=this._createDelegatedListener(t,r,i);for(const e in n.delegates){const s=n.delegates[e];n.delegates[e]=(...e)=>{this._removeDelegatedListener(t,r,i),s(...e)}}this._saveDelegatedListener(t,n);for(const t in n.delegates)this.once(t,n.delegates[t]);return this}off(t,e,i){return void 0===i?super.off(t,e):(this._removeDelegatedListener(t,"string"==typeof e?[e]:e,i),this)}queryRenderedFeatures(t,e){if(!this.style)return[];let i;const r=t instanceof c||Array.isArray(t),n=r?t:[[0,0],[this.transform.width,this.transform.height]];if(e=e||(r?{}:t)||{},n instanceof c||"number"==typeof n[0])i=[c.convert(n)];else{const t=c.convert(n[0]),e=c.convert(n[1]);i=[t,new c(e.x,t.y),e,new c(t.x,e.y),t]}return this.style.queryRenderedFeatures(i,e,this.transform)}querySourceFeatures(t,e){return this.style.querySourceFeatures(t,e)}setStyle(t,e){return!1!==(e=xt({},{localIdeographFontFamily:this._localIdeographFontFamily,validate:this._validateStyle},e)).diff&&e.localIdeographFontFamily===this._localIdeographFontFamily&&this.style&&t?(this._diffStyle(t,e),this):(this._localIdeographFontFamily=e.localIdeographFontFamily,this._updateStyle(t,e))}setTransformRequest(t){return this._requestManager.setTransformRequest(t),this}_getUIString(t){const e=this._locale[t];if(null==e)throw new Error(`Missing UI string '${t}'`);return e}_updateStyle(t,e){var i,r;if(e.transformStyle&&this.style&&!this.style._loaded)return void this.style.once("style.load",(()=>this._updateStyle(t,e)));const n=this.style&&e.transformStyle?this.style.serialize():void 0;return this.style&&(this.style.setEventedParent(null),this.style._remove(!t)),t?(this.style=new lm(this,e||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof t?this.style.loadURL(t,e,n):this.style.loadJSON(t,e,n),this):(null===(r=null===(i=this.style)||void 0===i?void 0:i.projection)||void 0===r||r.destroy(),delete this.style,this)}_lazyInitEmptyStyle(){this.style||(this.style=new lm(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty())}_diffStyle(t,e){if("string"==typeof t){const i=this._requestManager.transformRequest(t,"Style");ee(i,new AbortController).then((t=>{this._updateDiff(t.data,e)})).catch((t=>{t&&this.fire(new fe(t))}))}else"object"==typeof t&&this._updateDiff(t,e)}_updateDiff(t,e){try{this.style.setState(t,e)&&this._update(!0)}catch(i){At(`Unable to perform style diff: ${i.message||i.error||i}.  Rebuilding the style from scratch.`),this._updateStyle(t,e)}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():At("There is no style added to the map.")}addSource(t,e){return this._lazyInitEmptyStyle(),this.style.addSource(t,e),this._update(!0)}isSourceLoaded(t){const e=this.style&&this.style.sourceCaches[t];if(void 0!==e)return e.loaded();this.fire(new fe(new Error(`There is no source with ID '${t}'`)))}setTerrain(t){if(this.style._checkLoaded(),this._terrainDataCallback&&this.style.off("data",this._terrainDataCallback),t){const e=this.style.sourceCaches[t.source];if(!e)throw new Error(`cannot load terrain, because there exists no source with ID: ${t.source}`);null===this.terrain&&e.reload();for(const e in this.style._layers){const i=this.style._layers[e];"hillshade"===i.type&&i.source===t.source&&At("You are using the same source for a hillshade layer and for 3D terrain. Please consider using two separate sources to improve rendering quality.")}this.terrain=new My(this.painter,e,t),this.painter.renderToTexture=new Sy(this.painter,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._terrainDataCallback=e=>{"style"===e.dataType?this.terrain.sourceCache.freeRtt():"source"===e.dataType&&e.tile&&(e.sourceId!==t.source||this._elevationFreeze||(this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))),this.terrain.sourceCache.freeRtt(e.tile.tileID))},this.style.on("data",this._terrainDataCallback)}else this.terrain&&this.terrain.sourceCache.destruct(),this.terrain=null,this.painter.renderToTexture&&this.painter.renderToTexture.destruct(),this.painter.renderToTexture=null,this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0);return this.fire(new de("terrain",{terrain:t})),this}getTerrain(){var t,e;return null!==(e=null===(t=this.terrain)||void 0===t?void 0:t.options)&&void 0!==e?e:null}areTilesLoaded(){const t=this.style&&this.style.sourceCaches;for(const e in t){const i=t[e]._tiles;for(const t in i){const e=i[t];if("loaded"!==e.state&&"errored"!==e.state)return!1}}return!0}removeSource(t){return this.style.removeSource(t),this._update(!0)}getSource(t){return this.style.getSource(t)}addImage(t,e,i={}){const{pixelRatio:r=1,sdf:n=!1,stretchX:s,stretchY:o,content:a,textFitWidth:l,textFitHeight:c}=i;if(this._lazyInitEmptyStyle(),!(e instanceof HTMLImageElement||Rt(e))){if(void 0===e.width||void 0===e.height)return this.fire(new fe(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:i,height:h,data:u}=e,p=e;return this.style.addImage(t,{data:new Hl({width:i,height:h},new Uint8Array(u)),pixelRatio:r,stretchX:s,stretchY:o,content:a,textFitWidth:l,textFitHeight:c,sdf:n,version:0,userImage:p}),p.onAdd&&p.onAdd(this,t),this}}{const{width:i,height:h,data:u}=Wt.getImageData(e);this.style.addImage(t,{data:new Hl({width:i,height:h},u),pixelRatio:r,stretchX:s,stretchY:o,content:a,textFitWidth:l,textFitHeight:c,sdf:n,version:0})}}updateImage(t,e){const i=this.style.getImage(t);if(!i)return this.fire(new fe(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const r=e instanceof HTMLImageElement||Rt(e)?Wt.getImageData(e):e,{width:n,height:s,data:o}=r;if(void 0===n||void 0===s)return this.fire(new fe(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));if(n!==i.data.width||s!==i.data.height)return this.fire(new fe(new Error("The width and height of the updated image must be that same as the previous version of the image")));const a=!(e instanceof HTMLImageElement||Rt(e));return i.data.replace(o,a),this.style.updateImage(t,i),this}getImage(t){return this.style.getImage(t)}hasImage(t){return t?!!this.style.getImage(t):(this.fire(new fe(new Error("Missing required image id"))),!1)}removeImage(t){this.style.removeImage(t)}loadImage(t){return ce.getImage(this._requestManager.transformRequest(t,"Image"),new AbortController)}listImages(){return this.style.listImages()}addLayer(t,e){return this._lazyInitEmptyStyle(),this.style.addLayer(t,e),this._update(!0)}moveLayer(t,e){return this.style.moveLayer(t,e),this._update(!0)}removeLayer(t){return this.style.removeLayer(t),this._update(!0)}getLayer(t){return this.style.getLayer(t)}getLayersOrder(){return this.style.getLayersOrder()}setLayerZoomRange(t,e,i){return this.style.setLayerZoomRange(t,e,i),this._update(!0)}setFilter(t,e,i={}){return this.style.setFilter(t,e,i),this._update(!0)}getFilter(t){return this.style.getFilter(t)}setPaintProperty(t,e,i,r={}){return this.style.setPaintProperty(t,e,i,r),this._update(!0)}getPaintProperty(t,e){return this.style.getPaintProperty(t,e)}setLayoutProperty(t,e,i,r={}){return this.style.setLayoutProperty(t,e,i,r),this._update(!0)}getLayoutProperty(t,e){return this.style.getLayoutProperty(t,e)}setGlyphs(t,e={}){return this._lazyInitEmptyStyle(),this.style.setGlyphs(t,e),this._update(!0)}getGlyphs(){return this.style.getGlyphsUrl()}addSprite(t,e,i={}){return this._lazyInitEmptyStyle(),this.style.addSprite(t,e,i,(t=>{t||this._update(!0)})),this}removeSprite(t){return this._lazyInitEmptyStyle(),this.style.removeSprite(t),this._update(!0)}getSprite(){return this.style.getSprite()}setSprite(t,e={}){return this._lazyInitEmptyStyle(),this.style.setSprite(t,e,(t=>{t||this._update(!0)})),this}setLight(t,e={}){return this._lazyInitEmptyStyle(),this.style.setLight(t,e),this._update(!0)}getLight(){return this.style.getLight()}setSky(t,e={}){return this._lazyInitEmptyStyle(),this.style.setSky(t,e),this._update(!0)}getSky(){return this.style.getSky()}setFeatureState(t,e){return this.style.setFeatureState(t,e),this._update()}removeFeatureState(t,e){return this.style.removeFeatureState(t,e),this._update()}getFeatureState(t){return this.style.getFeatureState(t)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let t=0,e=0;return this._container&&(t=this._container.clientWidth||400,e=this._container.clientHeight||300),[t,e]}_setupContainer(){const t=this._container;t.classList.add("maplibregl-map");const e=this._canvasContainer=Ht.create("div","maplibregl-canvas-container",t);this._interactive&&e.classList.add("maplibregl-interactive"),this._canvas=Ht.create("canvas","maplibregl-canvas",e),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex",this._interactive?"0":"-1"),this._canvas.setAttribute("aria-label",this._getUIString("Map.Title")),this._canvas.setAttribute("role","region");const i=this._containerDimensions(),r=this._getClampedPixelRatio(i[0],i[1]);this._resizeCanvas(i[0],i[1],r);const n=this._controlContainer=Ht.create("div","maplibregl-control-container",t),s=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((t=>{s[t]=Ht.create("div",`maplibregl-ctrl-${t} `,n)})),this._container.addEventListener("scroll",this._onMapScroll,!1)}_resizeCanvas(t,e,i){this._canvas.width=Math.floor(i*t),this._canvas.height=Math.floor(i*e),this._canvas.style.width=`${t}px`,this._canvas.style.height=`${e}px`}_setupPainter(){const t=Object.assign(Object.assign({},this._canvasContextAttributes),{alpha:!0,depth:!0,stencil:!0,premultipliedAlpha:!0});let e=null;this._canvas.addEventListener("webglcontextcreationerror",(i=>{e={requestedAttributes:t},i&&(e.statusMessage=i.statusMessage,e.type=i.type)}),{once:!0});let i=null;if(i=this._canvasContextAttributes.contextType?this._canvas.getContext(this._canvasContextAttributes.contextType,t):this._canvas.getContext("webgl2",t)||this._canvas.getContext("webgl",t),!i){const t="Failed to initialize WebGL";throw e?(e.message=t,new Error(JSON.stringify(e))):new Error(t)}this.painter=new ug(i,this.transform),re.testSupport(i)}migrateProjection(t,e){super.migrateProjection(t,e),this.painter.transform=t,this.fire(new de("projectiontransition",{newProjection:this.style.projection.name}))}loaded(){return!this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(t){return this.style&&this.style._loaded?(this._styleDirty=this._styleDirty||t,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(t){return this._update(),this._renderTaskQueue.add(t)}_cancelRenderFrame(t){this._renderTaskQueue.remove(t)}_render(t){var e,i,r,n,s;const o=this._idleTriggered?this._fadeDuration:0,a=(null===(e=this.style.projection)||void 0===e?void 0:e.transitionState)>0;if(this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(t),this._removed)return;let l=!1;if(this.style&&this._styleDirty){this._styleDirty=!1;const t=this.transform.zoom,e=Wt.now();this.style.zoomHistory.update(t,e);const i=new ho(t,{now:e,fadeDuration:o,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),r=i.crossFadingFactor();1===r&&r===this._crossFadingFactor||(l=!0,this._crossFadingFactor=r),this.style.update(i)}const c=(null===(i=this.style.projection)||void 0===i?void 0:i.transitionState)>0!==a;null===(r=this.style.projection)||void 0===r||r.setErrorQueryLatitudeDegrees(this.transform.center.lat),this.transform.setTransitionState(null===(n=this.style.projection)||void 0===n?void 0:n.transitionState,null===(s=this.style.projection)||void 0===s?void 0:s.latitudeErrorCorrectionRadians),this.style&&(this._sourcesDirty||c)&&(this._sourcesDirty=!1,this.style._updateSources(this.transform)),this.terrain?(this.terrain.sourceCache.update(this.transform,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),!this._elevationFreeze&&this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))):(this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0)),this._placementDirty=this.style&&this.style._updatePlacement(this.transform,this.showCollisionBoxes,o,this._crossSourceCollisions,c),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:o,showPadding:this.showPadding}),this.fire(new de("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,wy.mark(_y.load),this.fire(new de("load"))),this.style&&(this.style.hasTransitions()||l)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles();const h=this._sourcesDirty||this._styleDirty||this._placementDirty;return h||this._repaint?this.triggerRepaint():!this.isMoving()&&this.loaded()&&this.fire(new de("idle")),!this._loaded||this._fullyLoaded||h||(this._fullyLoaded=!0,wy.mark(_y.fullLoad)),this}redraw(){return this.style&&(this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._render(0)),this}remove(){var t;this._hash&&this._hash.remove();for(const t of this._controls)t.onRemove(this);this._controls=[],this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._renderTaskQueue.clear(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),"undefined"!=typeof window&&removeEventListener("online",this._onWindowOnline,!1),ce.removeThrottleControl(this._imageQueueHandle),null===(t=this._resizeObserver)||void 0===t||t.disconnect();const e=this.painter.context.gl.getExtension("WEBGL_lose_context");(null==e?void 0:e.loseContext)&&e.loseContext(),this._canvas.removeEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.removeEventListener("webglcontextlost",this._contextLost,!1),Ht.remove(this._canvasContainer),Ht.remove(this._controlContainer),this._container.removeEventListener("scroll",this._onMapScroll,!1),this._container.classList.remove("maplibregl-map"),wy.clearMetrics(),this._removed=!0,this.fire(new de("remove"))}triggerRepaint(){this.style&&!this._frameRequest&&(this._frameRequest=new AbortController,Wt.frame(this._frameRequest,(t=>{wy.frame(t),this._frameRequest=null;try{this._render(t)}catch(t){if(!function(t){return t.message===Zt}(t)&&!function(t){return t.message===z_}(t))throw t}}),(()=>{})))}get showTileBoundaries(){return!!this._showTileBoundaries}set showTileBoundaries(t){this._showTileBoundaries!==t&&(this._showTileBoundaries=t,this._update())}get showPadding(){return!!this._showPadding}set showPadding(t){this._showPadding!==t&&(this._showPadding=t,this._update())}get showCollisionBoxes(){return!!this._showCollisionBoxes}set showCollisionBoxes(t){this._showCollisionBoxes!==t&&(this._showCollisionBoxes=t,t?this.style._generateCollisionBoxes():this._update())}get showOverdrawInspector(){return!!this._showOverdrawInspector}set showOverdrawInspector(t){this._showOverdrawInspector!==t&&(this._showOverdrawInspector=t,this._update())}get repaint(){return!!this._repaint}set repaint(t){this._repaint!==t&&(this._repaint=t,this.triggerRepaint())}get vertices(){return!!this._vertices}set vertices(t){this._vertices=t,this._update()}get version(){return Ay}getCameraTargetElevation(){return this.transform.elevation}getProjection(){return this.style.getProjection()}setProjection(t){return this._lazyInitEmptyStyle(),this.style.setProjection(t),this._update(!0)}},t.MapMouseEvent=Tg,t.MapTouchEvent=Pg,t.MapWheelEvent=Mg,t.Marker=Oy,t.MercatorCoordinate=mp,t.NavigationControl=class{constructor(t){this._updateZoomButtons=()=>{const t=this._map.getZoom(),e=t===this._map.getMaxZoom(),i=t===this._map.getMinZoom();this._zoomInButton.disabled=e,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",e.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString())},this._rotateCompassArrow=()=>{this._compassIcon.style.transform=this.options.visualizePitch&&this.options.visualizeRoll?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateZ(${-this._map.transform.roll}deg) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitchInRadians),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${-this._map.transform.bearing}deg)`:this.options.visualizeRoll?`rotate(${-this._map.transform.bearing-this._map.transform.roll}deg)`:`rotate(${-this._map.transform.bearing}deg)`},this._setButtonTitle=(t,e)=>{const i=this._map._getUIString(`NavigationControl.${e}`);t.title=i,t.setAttribute("aria-label",i)},this.options=xt({},ky,t),this._container=Ht.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._container.addEventListener("contextmenu",(t=>t.preventDefault())),this.options.showZoom&&(this._zoomInButton=this._createButton("maplibregl-ctrl-zoom-in",(t=>this._map.zoomIn({},{originalEvent:t}))),Ht.create("span","maplibregl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden","true"),this._zoomOutButton=this._createButton("maplibregl-ctrl-zoom-out",(t=>this._map.zoomOut({},{originalEvent:t}))),Ht.create("span","maplibregl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden","true")),this.options.showCompass&&(this._compass=this._createButton("maplibregl-ctrl-compass",(t=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:t}):this._map.resetNorth({},{originalEvent:t})})),this._compassIcon=Ht.create("span","maplibregl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden","true"))}onAdd(t){return this._map=t,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.on("roll",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new Dy(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){Ht.remove(this._container),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this.options.visualizeRoll&&this._map.off("roll",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map}_createButton(t,e){const i=Ht.create("button",t,this._container);return i.type="button",i.addEventListener("click",e),i}},t.Point=c,t.Popup=class extends me{constructor(t){super(),this._updateOpacity=()=>{void 0!==this.options.locationOccludedOpacity&&(this._container.style.opacity=this._map.transform.isLocationOccluded(this.getLngLat())?`${this.options.locationOccludedOpacity}`:void 0)},this.remove=()=>(this._content&&Ht.remove(this._content),this._container&&(Ht.remove(this._container),delete this._container),this._closeButton&&this._closeButton.removeEventListener("click",this._onClose),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),this._map._canvasContainer.classList.remove("maplibregl-track-pointer"),delete this._map,this.fire(new de("close"))),this),this._onMouseUp=t=>{this._update(t.point)},this._onMouseMove=t=>{this._update(t.point)},this._onDrag=t=>{this._update(t.point)},this._update=t=>{var e;if(!this._map||!this._lngLat&&!this._trackPointer||!this._content)return;if(!this._container){if(this._container=Ht.create("div","maplibregl-popup",this._map.getContainer()),this._tip=Ht.create("div","maplibregl-popup-tip",this._container),this._container.appendChild(this._content),this.options.className)for(const t of this.options.className.split(" "))this._container.classList.add(t);this._closeButton&&this._closeButton.setAttribute("aria-label",this._map._getUIString("Popup.Close")),this._trackPointer&&this._container.classList.add("maplibregl-popup-track-pointer")}if(this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._lngLat=this._map.transform.renderWorldCopies&&!this._trackPointer?Ly(this._lngLat,this._flatPos,this._map.transform):null===(e=this._lngLat)||void 0===e?void 0:e.wrap(),this._trackPointer&&!t)return;const i=this._flatPos=this._pos=this._trackPointer&&t?t:this._map.project(this._lngLat);this._map.terrain&&(this._flatPos=this._trackPointer&&t?t:this._map.transform.locationToScreenPoint(this._lngLat));let r=this.options.anchor;const n=Wy(this.options.offset);if(!r){const t=this._container.offsetWidth,e=this._container.offsetHeight;let s;s=i.y+n.bottom.y<e?["top"]:i.y>this._map.transform.height-e?["bottom"]:[],i.x<t/2?s.push("left"):i.x>this._map.transform.width-t/2&&s.push("right"),r=0===s.length?"bottom":s.join("-")}let s=i.add(n[r]);this.options.subpixelPositioning||(s=s.round()),Ht.setTransform(this._container,`${By[r]} translate(${s.x}px,${s.y}px)`),Fy(this._container,r,"popup"),this._updateOpacity()},this._onClose=()=>{this.remove()},this.options=xt(Object.create($y),t)}addTo(t){return this._map&&this.remove(),this._map=t,this.options.closeOnClick&&this._map.on("click",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")):this._map.on("move",this._update),this.fire(new de("open")),this}isOpen(){return!!this._map}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=op.convert(t),this._pos=null,this._flatPos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._container&&this._container.classList.remove("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.remove("maplibregl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._flatPos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._container&&this._container.classList.add("maplibregl-popup-track-pointer"),this._map._canvasContainer.classList.add("maplibregl-track-pointer")),this}getElement(){return this._container}setText(t){return this.setDOMContent(document.createTextNode(t))}setHTML(t){const e=document.createDocumentFragment(),i=document.createElement("body");let r;for(i.innerHTML=t;r=i.firstChild,r;)e.appendChild(r);return this.setDOMContent(e)}getMaxWidth(){var t;return null===(t=this._container)||void 0===t?void 0:t.style.maxWidth}setMaxWidth(t){return this.options.maxWidth=t,this._update(),this}setDOMContent(t){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=Ht.create("div","maplibregl-popup-content",this._container);return this._content.appendChild(t),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(t){return this._container&&this._container.classList.add(t),this}removeClassName(t){return this._container&&this._container.classList.remove(t),this}setOffset(t){return this.options.offset=t,this._update(),this}toggleClassName(t){if(this._container)return this._container.classList.toggle(t)}setSubpixelPositioning(t){this.options.subpixelPositioning=t}_createCloseButton(){this.options.closeButton&&(this._closeButton=Ht.create("button","maplibregl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose))}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const t=this._container.querySelector(qy);t&&t.focus()}},t.RasterDEMTileSource=Pp,t.RasterTileSource=yp,t.ScaleControl=class{constructor(t){this._onMove=()=>{Zy(this._map,this._container,this.options)},this.setUnit=t=>{this.options.unit=t,Zy(this._map,this._container,this.options)},this.options=Object.assign(Object.assign({},Uy),t)}getDefaultPosition(){return"bottom-left"}onAdd(t){return this._map=t,this._container=Ht.create("div","maplibregl-ctrl maplibregl-ctrl-scale",t.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){Ht.remove(this._container),this._map.off("move",this._onMove),this._map=void 0}},t.ScrollZoomHandler=Qg,t.Style=lm,t.TerrainControl=class{constructor(t){this._toggleTerrain=()=>{this._map.getTerrain()?this._map.setTerrain(null):this._map.setTerrain(this.options),this._updateTerrainIcon()},this._updateTerrainIcon=()=>{this._terrainButton.classList.remove("maplibregl-ctrl-terrain"),this._terrainButton.classList.remove("maplibregl-ctrl-terrain-enabled"),this._map.terrain?(this._terrainButton.classList.add("maplibregl-ctrl-terrain-enabled"),this._terrainButton.title=this._map._getUIString("TerrainControl.Disable")):(this._terrainButton.classList.add("maplibregl-ctrl-terrain"),this._terrainButton.title=this._map._getUIString("TerrainControl.Enable"))},this.options=t}onAdd(t){return this._map=t,this._container=Ht.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._terrainButton=Ht.create("button","maplibregl-ctrl-terrain",this._container),Ht.create("span","maplibregl-ctrl-icon",this._terrainButton).setAttribute("aria-hidden","true"),this._terrainButton.type="button",this._terrainButton.addEventListener("click",this._toggleTerrain),this._updateTerrainIcon(),this._map.on("terrain",this._updateTerrainIcon),this._container}onRemove(){Ht.remove(this._container),this._map.off("terrain",this._updateTerrainIcon),this._map=void 0}},t.TwoFingersTouchPitchHandler=Hg,t.TwoFingersTouchRotateHandler=qg,t.TwoFingersTouchZoomHandler=Gg,t.TwoFingersTouchZoomRotateHandler=sy,t.VectorTileSource=gp,t.VideoSource=Ip,t.addProtocol=function(t,e){Xt.REGISTERED_PROTOCOLS[t]=e},t.addSourceType=(t,e)=>n(void 0,void 0,void 0,(function*(){if(Ap(t))throw new Error(`A source type called "${t}" already exists.`);((t,e)=>{Ep[t]=e})(t,e)})),t.clearPrewarmedResources=function(){const t=Xu;t&&(t.isPreloaded()&&1===t.numActive()?(t.release(qu),Xu=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"))},t.config=Xt,t.createTileMesh=Ff,t.getMaxParallelImageRequests=function(){return Xt.MAX_PARALLEL_IMAGE_REQUESTS},t.getRTLTextPluginStatus=function(){return jp().getRTLTextPluginStatus()},t.getVersion=function(){return Hy},t.getWorkerCount=function(){return Wu.workerCount},t.getWorkerUrl=function(){return Xt.WORKER_URL},t.importScriptInWorkers=function(t){return Qu().broadcast("IS",t)},t.prewarm=function(){Yu().acquire(qu)},t.removeProtocol=function(t){delete Xt.REGISTERED_PROTOCOLS[t]},t.setMaxParallelImageRequests=function(t){Xt.MAX_PARALLEL_IMAGE_REQUESTS=t},t.setRTLTextPlugin=function(t,e){return jp().setRTLTextPlugin(t,e)},t.setWorkerCount=function(t){Wu.workerCount=t},t.setWorkerUrl=function(t){Xt.WORKER_URL=t}}));
//# sourceMappingURL=maplibre-gl-csp.js.map
