"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettingsService = exports.setQueryManager = exports.setPPLService = exports.setOverviewPage = exports.setOSDSavedObjectsClient = exports.setOSDHttp = exports.getQueryManager = exports.getPPLService = exports.getOverviewPage = exports.getOSDSavedObjectsClient = exports.getOSDHttp = void 0;
var _common = require("../../../../src/plugins/opensearch_dashboards_utils/common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

let uiSettings;
let notifications;
const uiSettingsService = exports.uiSettingsService = {
  init: (client, notificationsStart) => {
    uiSettings = client;
    notifications = notificationsStart;
  },
  get: (key, defaultOverride) => {
    var _uiSettings;
    return ((_uiSettings = uiSettings) === null || _uiSettings === void 0 ? void 0 : _uiSettings.get(key, defaultOverride)) || '';
  },
  set: (key, value) => {
    var _uiSettings2;
    return ((_uiSettings2 = uiSettings) === null || _uiSettings2 === void 0 ? void 0 : _uiSettings2.set(key, value)) || Promise.reject('uiSettings client not initialized.');
  },
  addToast: toast => {
    return notifications.toasts.add(toast);
  }
};
const [getPPLService, setPPLService] = (0, _common.createGetterSetter)('PPLService');
exports.setPPLService = setPPLService;
exports.getPPLService = getPPLService;
const [getOSDHttp, setOSDHttp] = (0, _common.createGetterSetter)('http');
exports.setOSDHttp = setOSDHttp;
exports.getOSDHttp = getOSDHttp;
const [getOSDSavedObjectsClient, setOSDSavedObjectsClient] = (0, _common.createGetterSetter)('SavedObjectsClient');
exports.setOSDSavedObjectsClient = setOSDSavedObjectsClient;
exports.getOSDSavedObjectsClient = getOSDSavedObjectsClient;
const [getQueryManager, setQueryManager] = (0, _common.createGetterSetter)('QueryManager');
exports.setQueryManager = setQueryManager;
exports.getQueryManager = getQueryManager;
const [getOverviewPage, setOverviewPage] = (0, _common.createGetterSetter)('Page');
exports.setOverviewPage = setOverviewPage;
exports.getOverviewPage = getOverviewPage;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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